# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class EdgeComputeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def can_base_station_access_edge_repository(self, base_station_serial_number, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Can a base station access (pull) a docker repository? Registry request in most cases.  Note: imageRepository with 'plugins/' pattern will return true  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.can_base_station_access_edge_repository(base_station_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str base_station_serial_number: Base Station Serial Number (required)
        :param str image_repository: Repository
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.can_base_station_access_edge_repository_with_http_info(base_station_serial_number, **kwargs)  # noqa: E501
        else:
            (data) = self.can_base_station_access_edge_repository_with_http_info(base_station_serial_number, **kwargs)  # noqa: E501
            return data

    def can_base_station_access_edge_repository_with_http_info(self, base_station_serial_number, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Can a base station access (pull) a docker repository? Registry request in most cases.  Note: imageRepository with 'plugins/' pattern will return true  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.can_base_station_access_edge_repository_with_http_info(base_station_serial_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str base_station_serial_number: Base Station Serial Number (required)
        :param str image_repository: Repository
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['base_station_serial_number', 'image_repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method can_base_station_access_edge_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'base_station_serial_number' is set
        if ('base_station_serial_number' not in params or
                params['base_station_serial_number'] is None):
            raise ValueError("Missing the required parameter `base_station_serial_number` when calling `can_base_station_access_edge_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'base_station_serial_number' in params:
            path_params['baseStationSerialNumber'] = params['base_station_serial_number']  # noqa: E501

        query_params = []
        if 'image_repository' in params:
            query_params.append(('imageRepository', params['image_repository']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/BaseStation/{baseStationSerialNumber}/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_edge_definition(self, **kwargs):  # noqa: E501
        """Creates a definition  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to create a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_definition(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDefinitionCreateRequest body: A request with information to create a new definition
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_edge_definition_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_edge_definition_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_edge_definition_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a definition  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to create a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_definition_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDefinitionCreateRequest body: A request with information to create a new definition
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_edge_definition" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_edge_definition_assignment(self, **kwargs):  # noqa: E501
        """Creates a definition assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_definition_assignment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDefinitionAssignmentCreateRequest body: A request with information to create a new assignment
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_edge_definition_assignment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_edge_definition_assignment_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_edge_definition_assignment_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a definition assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_definition_assignment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDefinitionAssignmentCreateRequest body: A request with information to create a new assignment
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_edge_definition_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_edge_image_repository_prefix(self, **kwargs):  # noqa: E501
        """Create an image repository prefix record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_image_repository_prefix(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeImagePrefixCreateRequest body: Create request
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_edge_image_repository_prefix_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_edge_image_repository_prefix_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_edge_image_repository_prefix_with_http_info(self, **kwargs):  # noqa: E501
        """Create an image repository prefix record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_edge_image_repository_prefix_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeImagePrefixCreateRequest body: Create request
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_edge_image_repository_prefix" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImagePrefixResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_edge_definition(self, definition_id, **kwargs):  # noqa: E501
        """Deletes a definition including any attached revisions  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to delete a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_definition(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def delete_edge_definition_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Deletes a definition including any attached revisions  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to delete a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_definition_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_edge_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `delete_edge_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_edge_definition_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Deletes a definition assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_definition_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def delete_edge_definition_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Deletes a definition assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_definition_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_edge_definition_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `delete_edge_definition_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_edge_image_repository_prefix(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Deletes an image repository prefix record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_image_repository_prefix(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
            return data

    def delete_edge_image_repository_prefix_with_http_info(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Deletes an image repository prefix record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_prefix_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_edge_image_repository_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_prefix_id' is set
        if ('image_repository_prefix_id' not in params or
                params['image_repository_prefix_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_prefix_id` when calling `delete_edge_image_repository_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_prefix_id' in params:
            path_params['imageRepositoryPrefixId'] = params['image_repository_prefix_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes/{imageRepositoryPrefixId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_agent_settings(self, assignment_id, **kwargs):  # noqa: E501
        """Get edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_agent_settings(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def get_edge_agent_settings_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Get edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_agent_settings_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_agent_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_edge_agent_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}/edgeAgentSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeAgentSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition(self, definition_id, **kwargs):  # noqa: E501
        """Gets a single definition  # noqa: E501

        Required Permissions: Location Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: (required)
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Gets a single definition  # noqa: E501

        Required Permissions: Location Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: (required)
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `get_edge_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_access_list(self, definition_id, **kwargs):  # noqa: E501
        """Gets the access list for a single definition  # noqa: E501

        Required Permissions: Location Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_access_list(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: (required)
        :return: EdgeDefinitionAccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_access_list_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_access_list_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_access_list_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Gets the access list for a single definition  # noqa: E501

        Required Permissions: Location Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_access_list_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: (required)
        :return: EdgeDefinitionAccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `get_edge_definition_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionAccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Gets a single assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to get (required)
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Gets a single assignment  # noqa: E501

        Required Permissions: Location Admin  The user must be at least a location admin   for the location of the base station belonging   to the assignment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to get (required)
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_edge_definition_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignment_compose_yaml(self, assignment_id, **kwargs):  # noqa: E501
        """Generate and get docker compose preview yaml for a definition assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment_compose_yaml(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Definition assignment id (required)
        :param bool is_for_base_station: Return yaml that will be download to base station. Default is true
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignment_compose_yaml_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignment_compose_yaml_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignment_compose_yaml_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Generate and get docker compose preview yaml for a definition assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment_compose_yaml_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Definition assignment id (required)
        :param bool is_for_base_station: Return yaml that will be download to base station. Default is true
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'is_for_base_station']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignment_compose_yaml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_edge_definition_assignment_compose_yaml`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []
        if 'is_for_base_station' in params:
            query_params.append(('isForBaseStation', params['is_for_base_station']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}/composeYaml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignment_logs(self, assignment_id, **kwargs):  # noqa: E501
        """Get edge logs associated with a  definition assignment (via its base station)  # noqa: E501

        Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment_logs(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ContainerImageName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ContainerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` | | `Message` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `ContainerImageName` | String | | `ContainerName` | String | | `Timestamp` | DateTime |
        :return: PagedResultsModelEdgeLogDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignment_logs_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignment_logs_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignment_logs_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Get edge logs associated with a  definition assignment (via its base station)  # noqa: E501

        Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignment_logs_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ContainerImageName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ContainerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` | | `Message` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `ContainerImageName` | String | | `ContainerName` | String | | `Timestamp` | DateTime |
        :return: PagedResultsModelEdgeLogDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignment_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_edge_definition_assignment_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeLogDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignments(self, **kwargs):  # noqa: E501
        """Gets multiple assignments  # noqa: E501

        Required Permissions: Global Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignments_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignments_with_http_info(self, **kwargs):  # noqa: E501
        """Gets multiple assignments  # noqa: E501

        Required Permissions: Global Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignments_by_corporation(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple assignments for a corporation  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments_by_corporation(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignments_by_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignments_by_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignments_by_corporation_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple assignments for a corporation  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments_by_corporation_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignments_by_corporation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_edge_definition_assignments_by_corporation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/corporations/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_assignments_by_location(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple assignments for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments_by_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_assignments_by_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_assignments_by_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_assignments_by_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple assignments for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_assignments_by_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `DefinitionId` | Guid | `eq, neq, in` | | `DefinitionName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `BaseStationName` | String | | `BaseStationSerialNumber` | String | | `CreatedBy` | String | | `DefinitionName` | String |
        :return: PagedResultsModelEdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_assignments_by_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_edge_definition_assignments_by_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/locations/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definition_compose_yaml(self, definition_id, **kwargs):  # noqa: E501
        """Generate and get docker compose preview yaml for a definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_compose_yaml(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param bool is_for_base_station: Return yaml that will be download to base station. Default is true
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definition_compose_yaml_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definition_compose_yaml_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definition_compose_yaml_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Generate and get docker compose preview yaml for a definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definition_compose_yaml_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param bool is_for_base_station: Return yaml that will be download to base station. Default is true
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id', 'is_for_base_station']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definition_compose_yaml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `get_edge_definition_compose_yaml`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []
        if 'is_for_base_station' in params:
            query_params.append(('isForBaseStation', params['is_for_base_station']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}/composeYaml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definitions(self, **kwargs):  # noqa: E501
        """Gets multiple definitions for a given owner  # noqa: E501

        Required Permissions: Global Admin or Sentry.  Note: This route currently times out without a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definitions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definitions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_edge_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """Gets multiple definitions for a given owner  # noqa: E501

        Required Permissions: Global Admin or Sentry.  Note: This route currently times out without a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definitions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definitions_by_corporation(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple definitions for a corporation  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions_by_corporation(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definitions_by_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definitions_by_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definitions_by_corporation_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple definitions for a corporation  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions_by_corporation_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definitions_by_corporation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_edge_definitions_by_corporation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/corporations/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_definitions_by_location(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple definitions for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions_by_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_definitions_by_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_definitions_by_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_edge_definitions_by_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple definitions for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_definitions_by_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CreatedBy` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedBy` | String | | `Name` | String | | `OwnerName` | String |
        :return: PagedResultsModelEdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_definitions_by_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_edge_definitions_by_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/locations/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_eligible_base_stations_for_corporation(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple eligible base stations for a corporation  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_eligible_base_stations_for_corporation(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelEdgeEligibleBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_eligible_base_stations_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_eligible_base_stations_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_edge_eligible_base_stations_for_corporation_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Gets multiple eligible base stations for a corporation  # noqa: E501

        Required Permissions: Corporation Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_eligible_base_stations_for_corporation_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelEdgeEligibleBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id', 'filter', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_eligible_base_stations_for_corporation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_edge_eligible_base_stations_for_corporation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/eligibleBaseStations/corporations/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeEligibleBaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_eligible_base_stations_for_location(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple eligible base stations for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_eligible_base_stations_for_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelEdgeEligibleBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_eligible_base_stations_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_eligible_base_stations_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_edge_eligible_base_stations_for_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets multiple eligible base stations for a location  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_eligible_base_stations_for_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `BaseStationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `BaseStationSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelEdgeEligibleBaseStationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_eligible_base_stations_for_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_edge_eligible_base_stations_for_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/eligibleBaseStations/locations/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeEligibleBaseStationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repositories(self, **kwargs):  # noqa: E501
        """Get list of current docker image repositories.  # noqa: E501

        Required Permissions: Global Admin or Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repositories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repositories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_edge_image_repositories_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of current docker image repositories.  # noqa: E501

        Required Permissions: Global Admin or Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repositories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repositories_for_corporation(self, corporation_id, **kwargs):  # noqa: E501
        """Get list of current docker image repositories available to a corporation.  Includes all image repositories that have been granted access to all.  Does not include image repositories belonging to any locations underneath the corporation.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories_for_corporation(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: Corporation Id (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repositories_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repositories_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repositories_for_corporation_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Get list of current docker image repositories available to a corporation.  Includes all image repositories that have been granted access to all.  Does not include image repositories belonging to any locations underneath the corporation.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories_for_corporation_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: Corporation Id (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repositories_for_corporation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_edge_image_repositories_for_corporation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/corporation/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repositories_for_location(self, location_id, **kwargs):  # noqa: E501
        """Get list of current docker image repositories available to a location.  Includes any image repositories assigned to the parent corporation of the location along  with any image repositories that have been granted access to all.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location Admin or higher for that location.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories_for_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Location Id (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repositories_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repositories_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repositories_for_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Get list of current docker image repositories available to a location.  Includes any image repositories assigned to the parent corporation of the location along  with any image repositories that have been granted access to all.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location Admin or higher for that location.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repositories_for_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: Location Id (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerName` | String | `eq, neq, in, like, isnull, isnotnull` | | `OwnerType` | OwnerType | `eq, neq, in` | | `Repository` | String | `eq, neq, in, like, isnull, isnotnull` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `OwnerName` | String | | `OwnerType` | OwnerType | | `Repository` | String | | `Updated` | DateTime |
        :return: PagedResultsModelEdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repositories_for_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_edge_image_repositories_for_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/location/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelEdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repository(self, image_repository_id, **kwargs):  # noqa: E501
        """Get docker image repository record.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: Repository Id (required)
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repository_with_http_info(image_repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repository_with_http_info(image_repository_id, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repository_with_http_info(self, image_repository_id, **kwargs):  # noqa: E501
        """Get docker image repository record.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_with_http_info(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: Repository Id (required)
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_id' is set
        if ('image_repository_id' not in params or
                params['image_repository_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_id` when calling `get_edge_image_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_id' in params:
            path_params['imageRepositoryId'] = params['image_repository_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/{imageRepositoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repository_0(self, repository_name, **kwargs):  # noqa: E501
        """Get docker image repository record.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_0(repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_name: Repository Name (required)
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repository_0_with_http_info(repository_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repository_0_with_http_info(repository_name, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repository_0_with_http_info(self, repository_name, **kwargs):  # noqa: E501
        """Get docker image repository record.  # noqa: E501

        Required Permissions: Location Admin.  When the image has an owner of type location, the user must be a location admin or higher for that location.  When the image has an owner of type corporation, the user must be a corporation admin or higher for that corporation.  Sales, Sentry, and Global admins can view all images.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_0_with_http_info(repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_name: Repository Name (required)
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repository_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `get_edge_image_repository_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_name' in params:
            path_params['repositoryName'] = params['repository_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/{repositoryName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repository_prefix(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Get an image repository prefix record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefix(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repository_prefix_with_http_info(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Get an image repository prefix record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_prefix_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repository_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_prefix_id' is set
        if ('image_repository_prefix_id' not in params or
                params['image_repository_prefix_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_prefix_id` when calling `get_edge_image_repository_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_prefix_id' in params:
            path_params['imageRepositoryPrefixId'] = params['image_repository_prefix_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes/{imageRepositoryPrefixId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImagePrefixResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repository_prefix_for_corporation(self, corporation_id, **kwargs):  # noqa: E501
        """Get an image repository prefix record for corporation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefix_for_corporation(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: The id of the corporation (required)
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repository_prefix_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repository_prefix_for_corporation_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_edge_image_repository_prefix_for_corporation_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Get an image repository prefix record for corporation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefix_for_corporation_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: The id of the corporation (required)
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repository_prefix_for_corporation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_edge_image_repository_prefix_for_corporation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes/corporations/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImagePrefixResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_image_repository_prefixes(self, **kwargs):  # noqa: E501
        """Get a list of image repository prefix records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefixes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[EdgeImagePrefixResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_image_repository_prefixes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_image_repository_prefixes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_edge_image_repository_prefixes_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of image repository prefix records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_image_repository_prefixes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[EdgeImagePrefixResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_image_repository_prefixes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EdgeImagePrefixResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_registry_access_check(self, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Get Docker Registry Access Check for current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_registry_access_check(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository: Image repository trying to push or pull
        :return: EdgeRegistryAccessCheckResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_registry_access_check_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_registry_access_check_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_edge_registry_access_check_with_http_info(self, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Get Docker Registry Access Check for current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_registry_access_check_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository: Image repository trying to push or pull
        :return: EdgeRegistryAccessCheckResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_registry_access_check" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'image_repository' in params:
            query_params.append(('imageRepository', params['image_repository']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeRegistryAccessCheckResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_edge_registry_notification(self, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Processes notifications sent from registry. Request is structured to mimic standard docker registry events.  Will only process 'push' and 'pull' actions and in some cases if repository record already exists.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_edge_registry_notification(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeRegistryNotificationRequest body: Notification request
        :return: list[EdgeRegistryNotificationResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_edge_registry_notification_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.process_edge_registry_notification_with_http_info(**kwargs)  # noqa: E501
            return data

    def process_edge_registry_notification_with_http_info(self, **kwargs):  # noqa: E501
        """Docker Registry specific route.    Processes notifications sent from registry. Request is structured to mimic standard docker registry events.  Will only process 'push' and 'pull' actions and in some cases if repository record already exists.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_edge_registry_notification_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeRegistryNotificationRequest body: Notification request
        :return: list[EdgeRegistryNotificationResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method process_edge_registry_notification" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/notification', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EdgeRegistryNotificationResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revert_edge_agent_settings(self, assignment_id, **kwargs):  # noqa: E501
        """Delete / revert edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_edge_agent_settings(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revert_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.revert_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def revert_edge_agent_settings_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Delete / revert edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revert_edge_agent_settings_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_edge_agent_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `revert_edge_agent_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}/edgeAgentSettings', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeAgentSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_agent_settings(self, assignment_id, **kwargs):  # noqa: E501
        """Update edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_agent_settings(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :param EdgeAgentSettingsRequest body: A request with information to modify edge agent settings
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_agent_settings_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def update_edge_agent_settings_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Update edge agent settings associated with an assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_agent_settings_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment containing the settings (required)
        :param EdgeAgentSettingsRequest body: A request with information to modify edge agent settings
        :return: EdgeAgentSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_agent_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `update_edge_agent_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}/edgeAgentSettings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeAgentSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_definition(self, definition_id, **kwargs):  # noqa: E501
        """Updates a definition  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to update a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param EdgeDefinitionUpdateRequest body: A request with information to modify an existing definition
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_definition_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def update_edge_definition_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Updates a definition  # noqa: E501

        Required Permissions: Location Admin.   Must be a corporation admin or above to update a definition   with an OwnerType of Corporation.  Sales cannot update, delete, or create definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param EdgeDefinitionUpdateRequest body: A request with information to modify an existing definition
        :return: EdgeDefinitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `update_edge_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_definition_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Updates an assignment  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to update (required)
        :param EdgeDefinitionAssignmentUpdateRequest body: A request with information to modify an existing assignment
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_definition_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def update_edge_definition_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Updates an assignment  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: The id of the assignment to update (required)
        :param EdgeDefinitionAssignmentUpdateRequest body: A request with information to modify an existing assignment
        :return: EdgeDefinitionAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_definition_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `update_edge_definition_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/Assignments/{assignmentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDefinitionAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_definition_grant_access(self, definition_id, **kwargs):  # noqa: E501
        """Updates and replaces existing definition access (grant to)  Eligible base stations under these locations / corporations can use this definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition_grant_access(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param EdgeDefinitionGrantAccessRequest body: >A request with location ids and / or corporation ids
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_definition_grant_access_with_http_info(definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_definition_grant_access_with_http_info(definition_id, **kwargs)  # noqa: E501
            return data

    def update_edge_definition_grant_access_with_http_info(self, definition_id, **kwargs):  # noqa: E501
        """Updates and replaces existing definition access (grant to)  Eligible base stations under these locations / corporations can use this definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_definition_grant_access_with_http_info(definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str definition_id: The id of the definition (required)
        :param EdgeDefinitionGrantAccessRequest body: >A request with location ids and / or corporation ids
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_definition_grant_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition_id' is set
        if ('definition_id' not in params or
                params['definition_id'] is None):
            raise ValueError("Missing the required parameter `definition_id` when calling `update_edge_definition_grant_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'definition_id' in params:
            path_params['definitionId'] = params['definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Definitions/{definitionId}/access', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_image_repository(self, image_repository_id, **kwargs):  # noqa: E501
        """Update docker image repository record (limited).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: Repository Id (required)
        :param EdgeImageRepositoryUpdateRequest body: Update request
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_image_repository_with_http_info(image_repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_image_repository_with_http_info(image_repository_id, **kwargs)  # noqa: E501
            return data

    def update_edge_image_repository_with_http_info(self, image_repository_id, **kwargs):  # noqa: E501
        """Update docker image repository record (limited).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository_with_http_info(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: Repository Id (required)
        :param EdgeImageRepositoryUpdateRequest body: Update request
        :return: EdgeImageRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_image_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_id' is set
        if ('image_repository_id' not in params or
                params['image_repository_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_id` when calling `update_edge_image_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_id' in params:
            path_params['imageRepositoryId'] = params['image_repository_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/{imageRepositoryId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImageRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_image_repository_access(self, image_repository_id, **kwargs):  # noqa: E501
        """Updates and replaces existing container image repository access (grant to)  Eligible definitions / base stations under these locations / corporations can use this repository.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository_access(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: The id of the repository (required)
        :param EdgeImageRepositoryAccessRequest body: A request with location ids and / or corporation ids
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_image_repository_access_with_http_info(image_repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_image_repository_access_with_http_info(image_repository_id, **kwargs)  # noqa: E501
            return data

    def update_edge_image_repository_access_with_http_info(self, image_repository_id, **kwargs):  # noqa: E501
        """Updates and replaces existing container image repository access (grant to)  Eligible definitions / base stations under these locations / corporations can use this repository.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository_access_with_http_info(image_repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_id: The id of the repository (required)
        :param EdgeImageRepositoryAccessRequest body: A request with location ids and / or corporation ids
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_image_repository_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_id' is set
        if ('image_repository_id' not in params or
                params['image_repository_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_id` when calling `update_edge_image_repository_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_id' in params:
            path_params['imageRepositoryId'] = params['image_repository_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/{imageRepositoryId}/access', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_edge_image_repository_prefix(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Update an image repository prefix record (limited).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository_prefix(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :param EdgeImagePrefixUpdateRequest body: Update request
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, **kwargs)  # noqa: E501
            return data

    def update_edge_image_repository_prefix_with_http_info(self, image_repository_prefix_id, **kwargs):  # noqa: E501
        """Update an image repository prefix record (limited).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_edge_image_repository_prefix_with_http_info(image_repository_prefix_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_repository_prefix_id: The id of the repository prefix (required)
        :param EdgeImagePrefixUpdateRequest body: Update request
        :return: EdgeImagePrefixResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_repository_prefix_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_edge_image_repository_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_repository_prefix_id' is set
        if ('image_repository_prefix_id' not in params or
                params['image_repository_prefix_id'] is None):
            raise ValueError("Missing the required parameter `image_repository_prefix_id` when calling `update_edge_image_repository_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_repository_prefix_id' in params:
            path_params['imageRepositoryPrefixId'] = params['image_repository_prefix_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/EdgeCompute/Registry/Repositories/Prefixes/{imageRepositoryPrefixId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeImagePrefixResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
