# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class DashboardsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_dashboard(self, **kwargs):  # noqa: E501
        """Creates a new dashboard  # noqa: E501

        Required Permissions: Corporation Admin if only CorporationId is provided  Required Permissions: Location Admin if both LocationId and CorporationId are provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dashboard(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DashboardCreateRequest body: Contains dashboard details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dashboard_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_dashboard_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_dashboard_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new dashboard  # noqa: E501

        Required Permissions: Corporation Admin if only CorporationId is provided  Required Permissions: Location Admin if both LocationId and CorporationId are provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dashboard_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DashboardCreateRequest body: Contains dashboard details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dashboard" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DashboardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dashboard(self, id, **kwargs):  # noqa: E501
        """Deletes a dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboard_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboard_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_dashboard_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes a dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_dashboard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard(self, id, **kwargs):  # noqa: E501
        """get_dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_dashboard_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_dashboard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DashboardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_templates(self, **kwargs):  # noqa: E501
        """Gets dashboard templates  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelDashboardTemplateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_templates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_templates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dashboard_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Gets dashboard templates  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :return: PagedResultsModelDashboardTemplateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_templates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelDashboardTemplateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboards(self, **kwargs):  # noqa: E501
        """Gets all dashboards available to the user  # noqa: E501

        Required Permissions: Location User for location dashboards.   Required Permissions: Corporation User for corporation dashboards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | PrimaryCorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `DashboardTypeName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `PowerBiReport` | PowerBiReportChild | `isnull, isnotnull` | | `PowerBiReportUrl` | Uri | `eq, neq, in, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `DashboardTypeName` | String | | `LocationName` | String | | `Name` | String |
        :return: PagedResultsModelDashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dashboards_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all dashboards available to the user  # noqa: E501

        Required Permissions: Location User for location dashboards.   Required Permissions: Corporation User for corporation dashboards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | PrimaryCorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `DashboardTypeName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `PowerBiReport` | PowerBiReportChild | `isnull, isnotnull` | | `PowerBiReportUrl` | Uri | `eq, neq, in, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `DashboardTypeName` | String | | `LocationName` | String | | `Name` | String |
        :return: PagedResultsModelDashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboards" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelDashboardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dashboard(self, id, **kwargs):  # noqa: E501
        """Updates a dashboard  # noqa: E501

        Required Permissions: Location Admin for a location dashboard  Required Permissions: Corporation Admin for a corporation dashboard  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :param DashboardUpdateRequest body: Updated dashboard details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dashboard_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dashboard_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_dashboard_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates a dashboard  # noqa: E501

        Required Permissions: Location Admin for a location dashboard  Required Permissions: Corporation Admin for a corporation dashboard  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :param DashboardUpdateRequest body: Updated dashboard details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_dashboard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DashboardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dashboard_permissions(self, id, **kwargs):  # noqa: E501
        """Updates dashboard permissions  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard_permissions(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :param DashboardPermissionsUpdateRequest body: Dashboard permission details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dashboard_permissions_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dashboard_permissions_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_dashboard_permissions_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates dashboard permissions  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard_permissions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Id of the dashboard (required)
        :param DashboardPermissionsUpdateRequest body: Dashboard permission details
        :return: DashboardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dashboard_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_dashboard_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Dashboards/{id}/permissions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DashboardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
