# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class AnalyticsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_analytics_assignment(self, **kwargs):  # noqa: E501
        """Creates a model assignment on a new analytics group under the specified parent group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analytics_assignment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelAssignmentCreateRequest body: Contains model assignment details
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_analytics_assignment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_analytics_assignment_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_analytics_assignment_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a model assignment on a new analytics group under the specified parent group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analytics_assignment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelAssignmentCreateRequest body: Contains model assignment details
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analytics_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analytics_models(self, **kwargs):  # noqa: E501
        """Creates an Analytics Model  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analytics_models(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AnalyticsModelCreateRequest body: The requested values for the new analytics model
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_analytics_models_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_analytics_models_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_analytics_models_with_http_info(self, **kwargs):  # noqa: E501
        """Creates an Analytics Model  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_analytics_models_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AnalyticsModelCreateRequest body: The requested values for the new analytics model
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analytics_models" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyticsModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_analytics_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Deletes the model assignment and the analytics group that holds it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_analytics_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def delete_analytics_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Deletes the model assignment and the analytics group that holds it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_analytics_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_analytics_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `delete_analytics_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/assignments/{assignmentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_analytics_model(self, model_id, **kwargs):  # noqa: E501
        """Deletes an Analytics Model  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_analytics_model(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_analytics_model_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_analytics_model_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def delete_analytics_model_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Deletes an Analytics Model  # noqa: E501

        Required Permissions: System Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_analytics_model_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_analytics_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `delete_analytics_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Gets the model assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def get_analytics_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Gets the model assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_analytics_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/assignments/{assignmentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_assignments(self, **kwargs):  # noqa: E501
        """Gets all model assignments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_assignments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `GroupId` | Guid | `eq, neq, in` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserEmail` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserFirstName` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `AnalyticsModelId` | Guid | `eq, neq, in` | | `AnalyticsModelName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RootGroupId` | Guid | `eq, neq, in` | | `RootGroupName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedDate` | DateTime |
        :return: PagedResultsModelModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_assignments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_assignments_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_analytics_assignments_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all model assignments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_assignments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `GroupId` | Guid | `eq, neq, in` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserEmail` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserFirstName` | String | `eq, neq, in, like, isnull, isnotnull` | | `UserId` | Guid | `eq, neq, in` | | `UserLastName` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `AnalyticsModelId` | Guid | `eq, neq, in` | | `AnalyticsModelName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RootGroupId` | Guid | `eq, neq, in` | | `RootGroupName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreatedDate` | DateTime |
        :return: PagedResultsModelModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_assignments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelModelAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_logs(self, model_id, start_date, end_date, **kwargs):  # noqa: E501
        """Gets logs for the model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_logs(model_id, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model (required)
        :param datetime start_date: (required)
        :param datetime end_date: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Message` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Date` | DateTime |
        :return: PagedResultsModelAnalyticsLogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_logs_with_http_info(model_id, start_date, end_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_logs_with_http_info(model_id, start_date, end_date, **kwargs)  # noqa: E501
            return data

    def get_analytics_logs_with_http_info(self, model_id, start_date, end_date, **kwargs):  # noqa: E501
        """Gets logs for the model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_logs_with_http_info(model_id, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model (required)
        :param datetime start_date: (required)
        :param datetime end_date: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Message` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Date` | DateTime |
        :return: PagedResultsModelAnalyticsLogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id', 'start_date', 'end_date', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `get_analytics_logs`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params or
                params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `get_analytics_logs`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if ('end_date' not in params or
                params['end_date'] is None):
            raise ValueError("Missing the required parameter `end_date` when calling `get_analytics_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('StartDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('EndDate', params['end_date']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/{modelId}/Logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelAnalyticsLogResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_model(self, model_id, **kwargs):  # noqa: E501
        """Gets an Analytics Model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the analytics model requested (required)
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_model_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_model_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def get_analytics_model_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Gets an Analytics Model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the analytics model requested (required)
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `get_analytics_model`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyticsModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_model_source(self, model_id, **kwargs):  # noqa: E501
        """Gets the files associated with an analytics model  # noqa: E501

        Required Permissions: Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model_source(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_model_source_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_model_source_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def get_analytics_model_source_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Gets the files associated with an analytics model  # noqa: E501

        Required Permissions: Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model_source_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_model_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `get_analytics_model_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}/Source', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_model_template(self, **kwargs):  # noqa: E501
        """Gets the analytics model template file  # noqa: E501

        Required Permissions: Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model_template(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_model_template_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_model_template_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_analytics_model_template_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the analytics model template file  # noqa: E501

        Required Permissions: Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_model_template_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_model_template" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/Source/Template', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analytics_models(self, **kwargs):  # noqa: E501
        """Gets Analytics Models  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_models(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `ErrorType` | AnalyticsModelErrorTypeCodes? | `eq, neq, in, isnull, isnotnull` | | `IsDeprecated` | Boolean | `eq, neq` | | `IsGlobal` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Version` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `Version` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelAnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analytics_models_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_analytics_models_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_analytics_models_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Analytics Models  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analytics_models_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `ErrorType` | AnalyticsModelErrorTypeCodes? | `eq, neq, in, isnull, isnotnull` | | `IsDeprecated` | Boolean | `eq, neq` | | `IsGlobal` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Version` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime | | `Name` | String | | `Version` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Name`.
        :return: PagedResultsModelAnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_models" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelAnalyticsModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_analytics_assignment(self, assignment_id, **kwargs):  # noqa: E501
        """Updates a model assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_assignment(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :param ModelAssignmentUpdateRequest body: Contains model assignment details
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_analytics_assignment_with_http_info(assignment_id, **kwargs)  # noqa: E501
            return data

    def update_analytics_assignment_with_http_info(self, assignment_id, **kwargs):  # noqa: E501
        """Updates a model assignment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_assignment_with_http_info(assignment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str assignment_id: Id of the model assignment (required)
        :param ModelAssignmentUpdateRequest body: Contains model assignment details
        :return: ModelAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assignment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_analytics_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params or
                params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `update_analytics_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assignment_id' in params:
            path_params['assignmentId'] = params['assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/models/assignments/{assignmentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_analytics_model_source(self, model_id, **kwargs):  # noqa: E501
        """Updates the files associated with an analytics model  # noqa: E501

        Required Permissions: minimum Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_model_source(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :param str file:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_analytics_model_source_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_analytics_model_source_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def update_analytics_model_source_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Updates the files associated with an analytics model  # noqa: E501

        Required Permissions: minimum Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_model_source_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: (required)
        :param str file:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_analytics_model_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `update_analytics_model_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}/Source', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_analytics_model_status(self, model_id, **kwargs):  # noqa: E501
        """Updates the status of the model  # noqa: E501

        Required Permissions: KCF admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_model_status(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model being updated (required)
        :param AnalyticsModelStatusUpdateRequest body: The updated status values
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_analytics_model_status_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_analytics_model_status_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def update_analytics_model_status_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Updates the status of the model  # noqa: E501

        Required Permissions: KCF admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_model_status_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model being updated (required)
        :param AnalyticsModelStatusUpdateRequest body: The updated status values
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_analytics_model_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `update_analytics_model_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyticsModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_analytics_models(self, model_id, **kwargs):  # noqa: E501
        """Updates an Analytics Model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_models(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model being updated (required)
        :param AnalyticsModelUpdateRequest body: The requested update values
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_analytics_models_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_analytics_models_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def update_analytics_models_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Updates an Analytics Model  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_analytics_models_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Id of the model being updated (required)
        :param AnalyticsModelUpdateRequest body: The requested update values
        :return: AnalyticsModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_analytics_models" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `update_analytics_models`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Analytics/Models/{modelId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyticsModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
