from os.path import join, abspath, dirname
import argparse
import os
import shutil
import sys


def copy_workspace(workspace_dir: str, target_dir: str):
    # the codes below are generated by gpt-4o
    # Copy files from demo_dir to target_dir
    if not os.path.exists(target_dir):
        os.makedirs(target_dir)
    for item in os.listdir(workspace_dir):
        s = os.path.join(workspace_dir, item)
        d = os.path.join(target_dir, item)
        if "__pycache__" in s:
            continue
        if os.path.isdir(s):
            shutil.copytree(s, d, False, None)
        else:
            shutil.copy2(s, d)


def main():
    from ghostos.bootstrap import get_bootstrap_config
    conf = get_bootstrap_config()
    parser = argparse.ArgumentParser(
        description="initialize GhostOS skeleton files to target directory",
    )
    parser.add_argument(
        "--target", "-t",
        help="the target directory that keep the skeleton files of GhostOS",
        type=str,
        required=True,
    )
    parsed = parser.parse_args(sys.argv[1:])
    target_dir = abspath(parsed.target)
    copy_workspace(conf.workspace_dir, target_dir)
    print(f"Copied skeleton files to {target_dir}")


if __name__ == '__main__':
    main()
