# Returns a preview of the template, used for dashtools UI
import os
import dash_bootstrap_components as dbc
from dash import  dcc, html
import platform
import datetime


def home_header():
    """
    Home header
    """
    layout = html.Div([

        html.Div(
            [

                html.Div(
                    [
                        html.Img(
                            src=os.path.normpath("/assets/advanced-banner.svg"),
                            style={
                                "height": "42px",
                                "width": "auto",
                                "margin-left": "40px",
                                'margin-top': '-5px'
                            },
                        ),

                    ], style={'display': 'inline-block'}
                ),

                html.Div(
                    [
                        html.A(
                            dbc.Button(html.Div(["Visit About Page"], style={
                                'color': 'black', 'font-size': '15px', 'font-style': 'italic'}), color='white'),
                        ),

                    ],
                    style={
                        "display": "inline-block",
                        "float": "right",
                        "padding-right": "30px",
                        'margin-top': '-5px'
                    }
                )

            ],
            style={
                "display": "inline-block",
                "width": "100%"
            }
        )],

        id="header",
        className="flex-display",
        style={
            "margin-top": "10px",
            "width": "100%",
            "height": "35px",
            "display": "inline-block"
    },
    )

    return layout

navbar = dbc.Navbar(
    [home_header()],
    dark=True,
    sticky="top",
    color='#ffffff'
)


def forms():
    """
    Generates user input forms for upload screen
    """

    destination_phone_number = dbc.Row(
        [
            dbc.Label("Destination Number",
                      html_for="dest-phone-number", width=3),
            dbc.Col(
                dbc.Input(
                    id="dest-phone-number",
                    html_size='tel',
                    type='tel',
                    autocomplete='off',
                    placeholder="(123) 456-7890",
                    style={
                        'lineHeight': '1px',
                        'minHeight': '1px',
                        'fontWeight': '100',
                        'borderStyle': 'solid',
                        'borderRadius': '0.25rem',
                    }
                ),
                width=9,
            ),
        ],
        className="mb-2 form-item",
    )

    call_template = dbc.Row(
        [
            dbc.Label("Call Template", html_for="call-template-select", width=3),
            dbc.Col(
                dbc.Select(
                    id='call-template-select',
                    value=1,
                    options=[
                        {"label": "English-US (Standard)", "value": 1},
                        {"label": "English-IN (Short)", "value": 2},
                        {"label": "Spanish-MX (Short)", "value": 3},
                    ],
                ),
                width=9,
            ),
        ],
        className="mb-2 form-item",
    )

    provider = dbc.Row(
        [
            dbc.Label("Healthcare Provider",
                      html_for="provider-input", width=3),
            dbc.Col(
                dbc.Input(
                    id="provider-input",
                    value="Joy Health",
                    autocomplete='off',
                    placeholder="Healthcare Provider Name",
                    style={
                        'lineHeight': '1px',
                        'minHeight': '1px',
                        'fontWeight': '100',
                        'borderStyle': 'solid',
                        'borderRadius': '0.25rem',
                    }
                ),
                width=9,
            ),
        ],
        className="mb-2 form-item",
    )

    # Determine if OS is Windows or Mac
    if platform.system() == "Windows":
        date_format = "%B %#d"
    else:
        date_format = "%B %-d"

    visitDate = dbc.Row(
        [
            dbc.Label("Visit Date",
                      html_for="visit-date-input", width=3),
            dbc.Col(
                dbc.Input(
                    id="visit-date-input",
                    autocomplete='off',
                    placeholder="Visit Date",
                    value=datetime.datetime.now().strftime(date_format),
                    style={
                        'lineHeight': '1px',
                        'minHeight': '1px',
                        'fontWeight': '100',
                        'borderStyle': 'solid',
                        'borderRadius': '0.25rem',
                    }
                ),
                width=9,
            ),
        ],
        className="mb-2 form-item",
    )

    callerName = dbc.Row(
        [
            dbc.Label("Recipient Name",
                      html_for="caller-name-input", width=3),
            dbc.Col(
                dbc.Input(
                    id="caller-name-input",
                    placeholder="Name",
                    autocomplete='off',
                    value="John Doe",
                    style={
                        'lineHeight': '1px',
                        'minHeight': '1px',
                        'fontWeight': '100',
                        'borderStyle': 'solid',
                        'borderRadius': '0.25rem',
                    }
                ),
                width=9,
            ),
        ],
        className="mb-2 form-item",
    )

    return dbc.Form([callerName, call_template, destination_phone_number, provider, visitDate])



def home_page():
    """
    Main landing page for {appName}
    """

    return html.Div([

        html.Div([
            html.Div([
                # Text and Titles
                html.H3(
                    "Sample Dash App",
                    style={'padding-top': '10px', 'margin-bottom':'5px'},
                ),
                html.A("This sample application contains assets, callbacks, clientside scripting, CSS, links, and multiple pages of content.", style={'margin-bottom':'35px',  "font-weight":"100", "font-size":"13px"}),
                html.H5([
                    "Application Details"
                ], style={'margin-bottom': '0px', 'margin-top':'10px'}),
                html.Hr(style={'color': 'black',
                               'margin-top': '0px', 'margin-bottom': '30px'}),

                # Application Details
                forms(),

                html.Div(id='call-status-text'),
                html.Div([
                    dbc.Button(
                        [
                            html.P("Amazing Button", style={
                                   'display': 'inline-block', 'height': '0px'}),
                        ],
                        id='send-call-button',
                        className="uploadButton",
                        type="button",
                    ),
                ], style={
                    'width': '100%',
                    'display': 'flex',
                    'justify-content': 'center',
                    'margin-top': '15px',
                },
                    id="upload-button-container"),
            ],
                style={
                    'min-width': '400px',
                    'margin-bottom': '10px',
                    'color': '#444',
                    'padding-bottom': '100px',
                    'padding-left': '40px',
            }),
        ],
            style={
                'width': '70%',
        },
            className='center'
        ),
    ],
        style={
            'padding-top': '10px',
            'margin-bottom': '60px',
            'min-height': '100vh',
    },
    )

def footer():
    """
    App footer
    """
    return html.Div([
        # # # # # # # # Footer # # # # # # # #
        dbc.CardFooter(
            [
                dcc.Markdown(
                    "Sample App - My Plotly Dash Application - Footer",
                    style={
                        "display": "inline-block",
                        'font-size': '15px'}),
            ],
            style={'backgroundColor': 'black',
                   'textAlign': 'center',
                   'width': '100%',
                   'color': 'white',
                   'height': 'auto'},
            className='align-bottom'),
    ],
        style={
            'backgroundColor': 'black',
            'width': '100%',
    }
    )

def render():

    return html.Div([
    # represents the URL bar, doesn't render anything

    # content will be rendered in this element
    html.Div([
        html.Div(
            [
                html.Div(id="hidden-div", style={"display": "none"}),
                navbar,
                home_page(),
                footer()],
            style={"backgroundColor": "#fff"})
        ],
             style={"backgroundColor": "#202124"}
    ),

    ], style={"position": "relative", "minHeight": "100vh", 'backgroundColor': '#202124'})