from typing import List

from pydantic import BaseModel 
from sqlalchemy import Column, String, Integer, ForeignKey, Table
from sqlalchemy.orm import relationship

from poindexter.models import Base
from poindexter.models.Tag import Tag


Plugin_Tag_Table = Table(
  'plugin_tag_association',
  Base.metadata,
  Column('plugin_id', ForeignKey('plugins.id')),
  Column('tag_id', ForeignKey('tags.id'))
)


class PluginCreate(BaseModel):
  name: str
  description: str
  author: str
  version: str


class Plugin(PluginCreate):
  id: int
  tags: List[Tag]
  class Config:
    orm_mode = True


class PluginModel(Base):
  __tablename__ = 'plugins'
  id = Column(Integer, primary_key=True, index=True)
  name = Column(String)
  description = Column(String)
  author = Column(String)
  version = Column(String)
  tags = relationship("TagModel", secondary=Plugin_Tag_Table)
