#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# ctapipe documentation build configuration file, created by
# sphinx-quickstart on Fri Jan  6 10:22:58 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- General configuration ------------------------------------------------
import datetime
import os

# Get configuration information from setup.cfg
from configparser import ConfigParser

import ctapipe

conf = ConfigParser()
conf.read([os.path.join(os.path.dirname(__file__), "..", "setup.cfg")])
setup_cfg = dict(conf.items("metadata"))
# If your documentation needs a minimal Sphinx version, state it here.
#
needs_sphinx = "1.5"

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.viewcode",
    "sphinx.ext.githubpages",
    "sphinx.ext.mathjax",
    "sphinx_automodapi.automodapi",
    "nbsphinx",
    "matplotlib.sphinxext.plot_directive",
    "numpydoc",
]

numpydoc_show_class_members = False
nbsphinx_timeout = 200  # allow max 2 minutes to build each notebook


# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]


def setup(app):
    # fix trait aliases generating doc warnings
    from ctapipe.core import traits

    aliases = [
        "flag",
        "observe",
        "Bool",
        "CRegExp",
        "CaselessStrEnum",
        "Dict",
        "Enum",
        "Float",
        "Int",
        "CInt",
        "Integer",
        "List",
        "Long",
        "Set",
        "TraitError",
        "Unicode",
    ]
    for alias in aliases:
        getattr(traits, alias).__name__ = alias
        getattr(traits, alias).__module__ = "ctapipe.core.traits"


# These links are ignored in the checks, necessary due to broken intersphinx for
# these
nitpick_ignore = [
    ("py:class", "traitlets.config.configurable.Configurable"),
    ("py:class", "traitlets.traitlets.HasTraits"),
    ("py:class", "traitlets.traitlets.HasDescriptors"),
    ("py:class", "traitlets.traitlets.TraitType"),
    ("py:class", "traitlets.traitlets.BaseDescriptor"),
    ("py:class", "traitlets.traitlets.List"),
    ("py:class", "traitlets.traitlets.Container"),
    ("py:class", "traitlets.traitlets.Instance"),
    ("py:class", "traitlets.traitlets.ClassBasedTraitType"),
    ("py:class", "traitlets.traitlets.Int"),
    ("py:class", "traitlets.config.application.Application"),
    ("py:obj", "traitlets.config.boolean_flag"),
    ("py:obj", "traitlets.TraitError"),
    ("py:obj", "-v"),
    ("py:meth", "MetaHasDescriptors.__init__"),
    ("py:meth", "HasTraits.__new__"),
    ("py:meth", "BaseDescriptor.instance_init"),
    ("py:obj", "cls"),
    ("py:obj", "name"),
    ("py:class", "astropy.coordinates.baseframe.BaseCoordinateFrame"),
    ("py:class", "astropy.table.table.Table"),
]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# have all links automatically associated with the right domain.
default_role = "py:obj"

suppress_warnings = ["ref.citation"]  # ignore citation not referenced warnings

# General information about the project.

project = setup_cfg["name"]
author = setup_cfg["author"]
copyright = "{}.  Last updated {}".format(
    setup_cfg["author"], datetime.datetime.now().strftime("%d %b %Y %H:%M")
)

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

version = ctapipe.__version__
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store", "**.ipynb_checkpoints"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "default"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']
html_static_path = ["_static"]

html_context = {
    "css_files": ["_static/theme_overrides.css"]  # override wide tables in RTD theme
}


# -- Options for HTMLHelp output ------------------------------------------


# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = f"{project} v{release}"

# Output file base name for HTML help builder.
htmlhelp_basename = project + "doc"

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# -- Options for LaTeX output --------------------------------------------------

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ("index", project + ".tex", project + " Documentation", author, "manual")
]

# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [("index", project.lower(), project + " Documentation", [author], 1)]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "ctapipe",
        "ctapipe Documentation",
        author,
        "ctapipe",
        "Experimental Data Analysis for the" "Cherenkov Telescope Array (CTA).",
        "Science",
    )
]

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "python": ("https://docs.python.org/3.8", None),
    "numpy": ("https://numpy.org/doc/stable/", None),
    "scipy": ("https://docs.scipy.org/doc/scipy/", None),
    "astropy": ("https://docs.astropy.org/en/latest/", None),
    "pytables": ("http://www.pytables.org/", None),
    "pandas": ("https://pandas.pydata.org/pandas-docs/stable/", None),
    "matplotlib": ("https://matplotlib.org/stable", None),
    "cython": ("http://docs.cython.org/en/latest/", None),
    "iminuit": ("https://iminuit.readthedocs.io/en/latest/", None),
    "traitlets": ("https://traitlets.readthedocs.io/en/stable/", None),
}

# on_rtd is whether we are on readthedocs.org
on_rtd = os.environ.get("READTHEDOCS", None) == "True"

if not on_rtd:  # only import and set the theme if we're building docs locally
    try:
        import sphinx_rtd_theme
    except ImportError:
        raise ImportError(
            "It looks like you don't have the sphinx_rtd_theme "
            "package installed. This documentation "
            "uses the Read The Docs theme, so you must install this "
            "first. For example, pip install sphinx_rtd_theme"
        )
    html_theme = "sphinx_rtd_theme"
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
