<!-- THIS IS A TEMPLATE - Replace placeholders with your project details -->
<!-- Generated by Quaestor - See project-init command to generate actual documentation -->
<!-- META:document:memory -->
<!-- META:version:1.0 -->
<!-- META:ai-optimized:true -->

# Project Memory & Progress Tracking

<!-- SECTION:memory:purpose:START -->
## Document Purpose
This file tracks the current state, progress, and future plans for the project. It serves as the "memory" of what has been done, what's in progress, and what's planned.
<!-- SECTION:memory:purpose:END -->

<!-- SECTION:memory:status:START -->
## Current Status

<!-- DATA:project-status:START -->
```yaml
status:
  last_updated: "[Date]"
  current_phase: "[Phase name]"
  current_milestone: "[Milestone name]"
  overall_progress: "[Percentage or description]"
```
<!-- DATA:project-status:END -->

<!-- SECTION:memory:summary:START -->
## Quick Summary

<!-- DATA:project-summary:START -->
```yaml
project_focus: "[Describe your project's current focus]"
progress:
  completed:
    - "[Completed item 1]"
    - "[Completed item 2]"
  in_progress:
    - "[In progress item 1]"
    - "[In progress item 2]"
  planned:
    - "[Planned item 1]"
    - "[Planned item 2]"
```
<!-- DATA:project-summary:END -->
<!-- SECTION:memory:summary:END -->
<!-- SECTION:memory:status:END -->

<!-- SECTION:memory:next-tasks:START -->
## Next Tasks

<!-- DATA:next-tasks:START -->
```yaml
next_task: "[The immediate next task to work on when /task is called without arguments]"

pending_tasks:
  - task: "[High priority task 1]"
    context: "[Why this is important]"
    estimate: "[Time estimate]"
  - task: "[Task 2]"
    context: "[Context]"
    estimate: "[Time estimate]"
```
<!-- DATA:next-tasks:END -->
<!-- SECTION:memory:next-tasks:END -->

<!-- SECTION:memory:active-work:START -->
## Active Work

<!-- DATA:active-work:START -->
```yaml
overview: "[Describe what you're currently working on]"
approach: "[Detail your implementation strategy]"
blockers: []
decisions_needed: []
```
<!-- DATA:active-work:END -->
<!-- SECTION:memory:active-work:END -->

<!-- SECTION:memory:timeline:START -->
## Project Timeline

<!-- DATA:milestones:START -->
```yaml
milestones:
  - id: "milestone_1"
    name: "[Name]"
    status: "[Status]"
    progress: "[X]%"
    goal: "[Description of what this milestone achieves]"
    completed:
      - task: "[Completed task]"
        date: "[Date if helpful]"
        notes: "[Brief description]"
    in_progress:
      - task: "[Current task]"
        assignee: "[Who if team project]"
        eta: "[Estimated completion]"
    todo:
      - task: "[Planned task]"
        priority: "[High/Medium/Low]"
        estimate: "[Time estimate]"
  
  - id: "milestone_2"
    name: "[Name]"
    status: "upcoming"
    goal: "[Description]"
    planned_tasks:
      - "[Task 1]"
      - "[Task 2]"
    estimated_timeline: "[Timeline]"
  
  - id: "milestone_3"
    name: "[Name]"
    status: "future"
    goal: "[Description]"
    high_level_items:
      - "[Item 1]"
      - "[Item 2]"
```
<!-- DATA:milestones:END -->
<!-- SECTION:memory:timeline:END -->

<!-- SECTION:memory:components:START -->
## Component Status

<!-- DATA:component-status:START -->
```yaml
components:
  core:
    - name: "[Component name]"
      status: "complete"
      description: "[Brief description of status]"
    - name: "[Component name]"
      status: "in_progress"
      description: "[What's in progress]"
    - name: "[Component name]"
      status: "planned"
      description: "[What's planned]"
  
  supporting:
    - name: "[Component name]"
      status: "complete"
      description: "[Status]"
    - name: "[Component name]"
      status: "planned"
      description: "[Status]"
  
  infrastructure:
    - name: "[Component name]"
      status: "complete"
      description: "[Status]"
    - name: "[Component name]"
      status: "in_progress"
      description: "[Status]"
```
<!-- DATA:component-status:END -->
<!-- SECTION:memory:components:END -->

<!-- SECTION:memory:implementation:START -->
## Key Implementation Files

<!-- DATA:implementation-map:START -->
```yaml
implementation:
  core:
    - path: "/src/[component]/"
      description: "[Description of what's in this directory]"
      key_files: []
  tests:
    - path: "/tests/"
      description: "[Description of test organization]"
      coverage: "[Current coverage %]"
  docs:
    - path: "/docs/"
      description: "[Description of documentation]"
      status: "[Up to date/Needs update]"
  config:
    - path: "/config/"
      description: "[Configuration files]"
      files:
        - name: ".env.example"
          purpose: "[Environment variables]"
  examples:
    - path: "/examples/"
      description: "[Example code or reference implementations]"
```
<!-- DATA:implementation-map:END -->
<!-- SECTION:memory:implementation:END -->

<!-- SECTION:memory:metrics:START -->
## Success Metrics

<!-- DATA:success-metrics:START -->
```yaml
metrics:
  technical:
    - metric: "[e.g., Test coverage]"
      target: "[e.g., 100%]"
      current: "[e.g., 85%]"
    - metric: "[Performance metric]"
      target: "[Target]"
      current: "[Current]"
    - metric: "[Code quality metric]"
      target: "[Target]"
      current: "[Current]"
  
  business:
    - metric: "[Business metric]"
      target: "[Target]"
      current: "[Current]"
    - metric: "[User satisfaction metric]"
      target: "[Target]"
      current: "[Current]"
    - metric: "[Growth metric]"
      target: "[Target]"
      current: "[Current]"
  
  user_experience:
    - metric: "[UX metric]"
      target: "[Target]"
      current: "[Current]"
    - metric: "[Accessibility metric]"
      target: "[Target]"
      current: "[Current]"
    - metric: "[Performance metric]"
      target: "[Target]"
      current: "[Current]"
```
<!-- DATA:success-metrics:END -->
<!-- SECTION:memory:metrics:END -->

<!-- SECTION:memory:risks:START -->
## Risk Mitigation

<!-- DATA:risk-register:START -->
```yaml
risks:
  technical:
    - id: "tech_risk_1"
      name: "[Risk Name]"
      description: "[Description]"
      impact: "[High/Medium/Low]"
      likelihood: "[High/Medium/Low]"
      mitigation: "[Mitigation strategy]"
      status: "[Active/Mitigated/Monitoring]"
    - id: "tech_risk_2"
      name: "[Risk Name]"
      description: "[Description]"
      impact: "[High/Medium/Low]"
      likelihood: "[High/Medium/Low]"
      mitigation: "[Mitigation strategy]"
      status: "[Active/Mitigated/Monitoring]"
  
  operational:
    - id: "ops_risk_1"
      name: "[Risk Name]"
      description: "[Description]"
      impact: "[High/Medium/Low]"
      likelihood: "[High/Medium/Low]"
      mitigation: "[Mitigation strategy]"
      status: "[Active/Mitigated/Monitoring]"
  
  business:
    - id: "biz_risk_1"
      name: "[Risk Name]"
      description: "[Description]"
      impact: "[High/Medium/Low]"
      likelihood: "[High/Medium/Low]"
      mitigation: "[Mitigation strategy]"
      status: "[Active/Mitigated/Monitoring]"
```
<!-- DATA:risk-register:END -->
<!-- SECTION:memory:risks:END -->

<!-- SECTION:memory:lessons:START -->
## Lessons Learned

<!-- DATA:lessons-learned:START -->
```yaml
lessons:
  - date: "[Date]"
    category: "[Technical/Process/Team]"
    lesson: "[Key insight from the project]"
    impact: "[How this changed approach]"
  - date: "[Date]"
    category: "[Category]"
    lesson: "[What's working well]"
    impact: "[Positive outcome]"
  - date: "[Date]"
    category: "[Category]"
    lesson: "[What could be improved]"
    action: "[Action taken or planned]"
  - date: "[Date]"
    category: "[Technical]"
    lesson: "[Technical discovery]"
    documentation: "[Where this is documented]"
```
<!-- DATA:lessons-learned:END -->
<!-- SECTION:memory:lessons:END -->

<!-- SECTION:memory:actions:START -->
## Next Actions

<!-- DATA:next-actions:START -->
```yaml
actions:
  immediate:
    timeframe: "This Week"
    tasks:
      - id: "immediate_1"
        task: "[High priority task]"
        owner: "[Assignee if applicable]"
        due: "[Due date]"
      - id: "immediate_2"
        task: "[High priority task]"
        owner: "[Assignee if applicable]"
        due: "[Due date]"
      - id: "immediate_3"
        task: "[High priority task]"
        owner: "[Assignee if applicable]"
        due: "[Due date]"
  
  short_term:
    timeframe: "Next 2-4 Weeks"
    tasks:
      - id: "short_1"
        task: "[Medium priority task]"
        dependencies: []
        estimate: "[Time estimate]"
      - id: "short_2"
        task: "[Medium priority task]"
        dependencies: []
        estimate: "[Time estimate]"
      - id: "short_3"
        task: "[Medium priority task]"
        dependencies: []
        estimate: "[Time estimate]"
  
  long_term:
    timeframe: "Next Quarter"
    goals:
      - id: "long_1"
        goal: "[Long-term goal]"
        success_criteria: "[How to measure success]"
      - id: "long_2"
        goal: "[Long-term goal]"
        success_criteria: "[How to measure success]"
      - id: "long_3"
        goal: "[Long-term goal]"
        success_criteria: "[How to measure success]"
```
<!-- DATA:next-actions:END -->
<!-- SECTION:memory:actions:END -->

<!-- SECTION:memory:references:START -->
## Notes & References

<!-- DATA:references:START -->
```yaml
notes:
  - date: "[Date]"
    note: "[Additional note]"
    tags: []
  
links:
  - title: "[Document title]"
    url: "[URL or path]"
    description: "[Why this is important]"
  
external_references:
  - title: "[Reference title]"
    type: "[Article/Documentation/Tool]"
    url: "[URL]"
    relevance: "[How this relates to project]"
```
<!-- DATA:references:END -->
<!-- SECTION:memory:references:END -->

---
*This document serves as the living memory of current progress. Update it regularly as you complete tasks and learn new insights.*