---
allowed-tools: [Read, Write, Edit, MultiEdit, Bash, Glob, Grep, TodoWrite, Task]
description: "Unified Quaestor command template with orchestration patterns"
performance-profile: "standard" # Options: standard, optimization, complex
complexity-threshold: 0.5 # Range: 0.2-0.8 based on command sophistication
auto-activation: ["context-detection", "quality-gates", "milestone-integration"]
intelligence-features: ["auto-detection", "context-awareness", "validation", "orchestration"]
---

# {COMMAND_NAME} - {COMMAND_PURPOSE}

## Purpose
{Brief description of command functionality and use cases}

## Usage
```
/{command} [target] [options] [--flags]
```

## Arguments
- `target` - {Target description}
- `options` - {Options description}
- `--flags` - {Flags description}

## Auto-Intelligence

### Context Detection
```yaml
Project Analysis:
  - Language: Auto-detect → Python|Rust|JS|TS standards
  - Framework: {Framework-specific patterns}
  - Architecture: {Pattern detection - MVC|DDD|VSA}
  - Complexity: Assess scope → tool selection strategy
```

### Execution Strategy
- **Standard (0.2-0.4)**: Simple tasks, direct execution
- **Optimization (0.4-0.6)**: Quality-focused, fast validation
- **Complex (0.6-0.8)**: Multi-agent coordination, systematic approach

## Execution: {Phase1} → {Phase2} → {Phase3} → {Phase4}

### Phase 1: {Analysis Phase} 🔍
**{Intelligence Pattern}:**
```yaml
{Phase Description}:
  - {Key action 1}
  - {Key action 2}
  - {Key action 3}
```

### Phase 2: {Processing Phase} ⚡
**{Intelligence Pattern}:**
- {Intelligent processing description}
- {Auto-detection or orchestration}
- {Quality integration}

### Phase 3: {Execution Phase} 🚀
**{Intelligence Pattern}:**
- {Execution description with automation}
- {Parallel processing if applicable}
- {Milestone integration}

### Phase 4: {Validation Phase} ✅
**{Intelligence Pattern}:**
- {Validation criteria}
- {Quality gates}
- {Completion verification}

## Quality Gates

### Essential Checks
- ✅ {Check 1}
- ✅ {Check 2}  
- ✅ {Check 3}

### Validation Cycle
```
Execute → Validate → Fix (if ❌) → Re-validate → ✅ Complete
```

## Integration Points

### Quaestor Workflow
- **Milestone**: Auto-update progress tracking
- **Memory**: Document findings and decisions
- **Quality**: Apply project-specific standards

### Intelligent Orchestration
- **Direct execution**: <10 files → Read + Edit operations
- **Parallel agents**: 10-50 files → Multi-agent coordination
- **Complex systems**: >50 files → Systematic Agent delegation
- **Auto-escalation**: Complexity threshold triggers

## Success Criteria
- ✅ {Success criterion 1}
- ✅ {Success criterion 2}
- ✅ {Success criterion 3}

## Examples

### Basic Usage
```
/{command} {basic example}
```

### Advanced Usage  
```
/{command} {advanced example with flags}
```

---
*Template with orchestration and auto-activation patterns for Claude integration*