/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.AlgorithmSpecification;
import com.amazonaws.services.sagemaker.model.Channel;
import com.amazonaws.services.sagemaker.model.MetricData;
import com.amazonaws.services.sagemaker.model.ModelArtifacts;
import com.amazonaws.services.sagemaker.model.OutputDataConfig;
import com.amazonaws.services.sagemaker.model.ResourceConfig;
import com.amazonaws.services.sagemaker.model.SecondaryStatus;
import com.amazonaws.services.sagemaker.model.SecondaryStatusTransition;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.TrainingJobStatus;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeTrainingJobResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String trainingJobName;
    private String trainingJobArn;
    private String tuningJobArn;
    private String labelingJobArn;
    private ModelArtifacts modelArtifacts;
    private String trainingJobStatus;
    private String secondaryStatus;
    private String failureReason;
    private Map<String, String> hyperParameters;
    private AlgorithmSpecification algorithmSpecification;
    private String roleArn;
    private List<Channel> inputDataConfig;
    private OutputDataConfig outputDataConfig;
    private ResourceConfig resourceConfig;
    private VpcConfig vpcConfig;
    private StoppingCondition stoppingCondition;
    private Date creationTime;
    private Date trainingStartTime;
    private Date trainingEndTime;
    private Date lastModifiedTime;
    private List<SecondaryStatusTransition> secondaryStatusTransitions;
    private List<MetricData> finalMetricDataList;
    private Boolean enableNetworkIsolation;
    private Boolean enableInterContainerTrafficEncryption;

    public void setTrainingJobName(String trainingJobName) {
        this.trainingJobName = trainingJobName;
    }

    public String getTrainingJobName() {
        return this.trainingJobName;
    }

    public DescribeTrainingJobResult withTrainingJobName(String trainingJobName) {
        this.setTrainingJobName(trainingJobName);
        return this;
    }

    public void setTrainingJobArn(String trainingJobArn) {
        this.trainingJobArn = trainingJobArn;
    }

    public String getTrainingJobArn() {
        return this.trainingJobArn;
    }

    public DescribeTrainingJobResult withTrainingJobArn(String trainingJobArn) {
        this.setTrainingJobArn(trainingJobArn);
        return this;
    }

    public void setTuningJobArn(String tuningJobArn) {
        this.tuningJobArn = tuningJobArn;
    }

    public String getTuningJobArn() {
        return this.tuningJobArn;
    }

    public DescribeTrainingJobResult withTuningJobArn(String tuningJobArn) {
        this.setTuningJobArn(tuningJobArn);
        return this;
    }

    public void setLabelingJobArn(String labelingJobArn) {
        this.labelingJobArn = labelingJobArn;
    }

    public String getLabelingJobArn() {
        return this.labelingJobArn;
    }

    public DescribeTrainingJobResult withLabelingJobArn(String labelingJobArn) {
        this.setLabelingJobArn(labelingJobArn);
        return this;
    }

    public void setModelArtifacts(ModelArtifacts modelArtifacts) {
        this.modelArtifacts = modelArtifacts;
    }

    public ModelArtifacts getModelArtifacts() {
        return this.modelArtifacts;
    }

    public DescribeTrainingJobResult withModelArtifacts(ModelArtifacts modelArtifacts) {
        this.setModelArtifacts(modelArtifacts);
        return this;
    }

    public void setTrainingJobStatus(String trainingJobStatus) {
        this.trainingJobStatus = trainingJobStatus;
    }

    public String getTrainingJobStatus() {
        return this.trainingJobStatus;
    }

    public DescribeTrainingJobResult withTrainingJobStatus(String trainingJobStatus) {
        this.setTrainingJobStatus(trainingJobStatus);
        return this;
    }

    public DescribeTrainingJobResult withTrainingJobStatus(TrainingJobStatus trainingJobStatus) {
        this.trainingJobStatus = trainingJobStatus.toString();
        return this;
    }

    public void setSecondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
    }

    public String getSecondaryStatus() {
        return this.secondaryStatus;
    }

    public DescribeTrainingJobResult withSecondaryStatus(String secondaryStatus) {
        this.setSecondaryStatus(secondaryStatus);
        return this;
    }

    public DescribeTrainingJobResult withSecondaryStatus(SecondaryStatus secondaryStatus) {
        this.secondaryStatus = secondaryStatus.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public DescribeTrainingJobResult withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public Map<String, String> getHyperParameters() {
        return this.hyperParameters;
    }

    public void setHyperParameters(Map<String, String> hyperParameters) {
        this.hyperParameters = hyperParameters;
    }

    public DescribeTrainingJobResult withHyperParameters(Map<String, String> hyperParameters) {
        this.setHyperParameters(hyperParameters);
        return this;
    }

    public DescribeTrainingJobResult addHyperParametersEntry(String key, String value) {
        if (null == this.hyperParameters) {
            this.hyperParameters = new HashMap<String, String>();
        }
        if (this.hyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hyperParameters.put(key, value);
        return this;
    }

    public DescribeTrainingJobResult clearHyperParametersEntries() {
        this.hyperParameters = null;
        return this;
    }

    public void setAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.algorithmSpecification = algorithmSpecification;
    }

    public AlgorithmSpecification getAlgorithmSpecification() {
        return this.algorithmSpecification;
    }

    public DescribeTrainingJobResult withAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.setAlgorithmSpecification(algorithmSpecification);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public DescribeTrainingJobResult withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Channel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<Channel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<Channel>(inputDataConfig);
    }

    public DescribeTrainingJobResult withInputDataConfig(Channel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<Channel>(inputDataConfig.length));
        }
        for (Channel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public DescribeTrainingJobResult withInputDataConfig(Collection<Channel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public DescribeTrainingJobResult withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public DescribeTrainingJobResult withResourceConfig(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public DescribeTrainingJobResult withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public DescribeTrainingJobResult withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public DescribeTrainingJobResult withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setTrainingStartTime(Date trainingStartTime) {
        this.trainingStartTime = trainingStartTime;
    }

    public Date getTrainingStartTime() {
        return this.trainingStartTime;
    }

    public DescribeTrainingJobResult withTrainingStartTime(Date trainingStartTime) {
        this.setTrainingStartTime(trainingStartTime);
        return this;
    }

    public void setTrainingEndTime(Date trainingEndTime) {
        this.trainingEndTime = trainingEndTime;
    }

    public Date getTrainingEndTime() {
        return this.trainingEndTime;
    }

    public DescribeTrainingJobResult withTrainingEndTime(Date trainingEndTime) {
        this.setTrainingEndTime(trainingEndTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public DescribeTrainingJobResult withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<SecondaryStatusTransition> getSecondaryStatusTransitions() {
        return this.secondaryStatusTransitions;
    }

    public void setSecondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
        if (secondaryStatusTransitions == null) {
            this.secondaryStatusTransitions = null;
            return;
        }
        this.secondaryStatusTransitions = new ArrayList<SecondaryStatusTransition>(secondaryStatusTransitions);
    }

    public DescribeTrainingJobResult withSecondaryStatusTransitions(SecondaryStatusTransition ... secondaryStatusTransitions) {
        if (this.secondaryStatusTransitions == null) {
            this.setSecondaryStatusTransitions(new ArrayList<SecondaryStatusTransition>(secondaryStatusTransitions.length));
        }
        for (SecondaryStatusTransition ele : secondaryStatusTransitions) {
            this.secondaryStatusTransitions.add(ele);
        }
        return this;
    }

    public DescribeTrainingJobResult withSecondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
        this.setSecondaryStatusTransitions(secondaryStatusTransitions);
        return this;
    }

    public List<MetricData> getFinalMetricDataList() {
        return this.finalMetricDataList;
    }

    public void setFinalMetricDataList(Collection<MetricData> finalMetricDataList) {
        if (finalMetricDataList == null) {
            this.finalMetricDataList = null;
            return;
        }
        this.finalMetricDataList = new ArrayList<MetricData>(finalMetricDataList);
    }

    public DescribeTrainingJobResult withFinalMetricDataList(MetricData ... finalMetricDataList) {
        if (this.finalMetricDataList == null) {
            this.setFinalMetricDataList(new ArrayList<MetricData>(finalMetricDataList.length));
        }
        for (MetricData ele : finalMetricDataList) {
            this.finalMetricDataList.add(ele);
        }
        return this;
    }

    public DescribeTrainingJobResult withFinalMetricDataList(Collection<MetricData> finalMetricDataList) {
        this.setFinalMetricDataList(finalMetricDataList);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public DescribeTrainingJobResult withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
    }

    public Boolean getEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public DescribeTrainingJobResult withEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.setEnableInterContainerTrafficEncryption(enableInterContainerTrafficEncryption);
        return this;
    }

    public Boolean isEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingJobName() != null) {
            sb.append("TrainingJobName: ").append(this.getTrainingJobName()).append(",");
        }
        if (this.getTrainingJobArn() != null) {
            sb.append("TrainingJobArn: ").append(this.getTrainingJobArn()).append(",");
        }
        if (this.getTuningJobArn() != null) {
            sb.append("TuningJobArn: ").append(this.getTuningJobArn()).append(",");
        }
        if (this.getLabelingJobArn() != null) {
            sb.append("LabelingJobArn: ").append(this.getLabelingJobArn()).append(",");
        }
        if (this.getModelArtifacts() != null) {
            sb.append("ModelArtifacts: ").append(this.getModelArtifacts()).append(",");
        }
        if (this.getTrainingJobStatus() != null) {
            sb.append("TrainingJobStatus: ").append(this.getTrainingJobStatus()).append(",");
        }
        if (this.getSecondaryStatus() != null) {
            sb.append("SecondaryStatus: ").append(this.getSecondaryStatus()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getHyperParameters() != null) {
            sb.append("HyperParameters: ").append(this.getHyperParameters()).append(",");
        }
        if (this.getAlgorithmSpecification() != null) {
            sb.append("AlgorithmSpecification: ").append(this.getAlgorithmSpecification()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getTrainingStartTime() != null) {
            sb.append("TrainingStartTime: ").append(this.getTrainingStartTime()).append(",");
        }
        if (this.getTrainingEndTime() != null) {
            sb.append("TrainingEndTime: ").append(this.getTrainingEndTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getSecondaryStatusTransitions() != null) {
            sb.append("SecondaryStatusTransitions: ").append(this.getSecondaryStatusTransitions()).append(",");
        }
        if (this.getFinalMetricDataList() != null) {
            sb.append("FinalMetricDataList: ").append(this.getFinalMetricDataList()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation()).append(",");
        }
        if (this.getEnableInterContainerTrafficEncryption() != null) {
            sb.append("EnableInterContainerTrafficEncryption: ").append(this.getEnableInterContainerTrafficEncryption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingJobResult)) {
            return false;
        }
        DescribeTrainingJobResult other = (DescribeTrainingJobResult)obj;
        if (other.getTrainingJobName() == null ^ this.getTrainingJobName() == null) {
            return false;
        }
        if (other.getTrainingJobName() != null && !other.getTrainingJobName().equals(this.getTrainingJobName())) {
            return false;
        }
        if (other.getTrainingJobArn() == null ^ this.getTrainingJobArn() == null) {
            return false;
        }
        if (other.getTrainingJobArn() != null && !other.getTrainingJobArn().equals(this.getTrainingJobArn())) {
            return false;
        }
        if (other.getTuningJobArn() == null ^ this.getTuningJobArn() == null) {
            return false;
        }
        if (other.getTuningJobArn() != null && !other.getTuningJobArn().equals(this.getTuningJobArn())) {
            return false;
        }
        if (other.getLabelingJobArn() == null ^ this.getLabelingJobArn() == null) {
            return false;
        }
        if (other.getLabelingJobArn() != null && !other.getLabelingJobArn().equals(this.getLabelingJobArn())) {
            return false;
        }
        if (other.getModelArtifacts() == null ^ this.getModelArtifacts() == null) {
            return false;
        }
        if (other.getModelArtifacts() != null && !other.getModelArtifacts().equals(this.getModelArtifacts())) {
            return false;
        }
        if (other.getTrainingJobStatus() == null ^ this.getTrainingJobStatus() == null) {
            return false;
        }
        if (other.getTrainingJobStatus() != null && !other.getTrainingJobStatus().equals(this.getTrainingJobStatus())) {
            return false;
        }
        if (other.getSecondaryStatus() == null ^ this.getSecondaryStatus() == null) {
            return false;
        }
        if (other.getSecondaryStatus() != null && !other.getSecondaryStatus().equals(this.getSecondaryStatus())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getHyperParameters() == null ^ this.getHyperParameters() == null) {
            return false;
        }
        if (other.getHyperParameters() != null && !other.getHyperParameters().equals(this.getHyperParameters())) {
            return false;
        }
        if (other.getAlgorithmSpecification() == null ^ this.getAlgorithmSpecification() == null) {
            return false;
        }
        if (other.getAlgorithmSpecification() != null && !other.getAlgorithmSpecification().equals(this.getAlgorithmSpecification())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        if (other.getResourceConfig() != null && !other.getResourceConfig().equals(this.getResourceConfig())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getTrainingStartTime() == null ^ this.getTrainingStartTime() == null) {
            return false;
        }
        if (other.getTrainingStartTime() != null && !other.getTrainingStartTime().equals(this.getTrainingStartTime())) {
            return false;
        }
        if (other.getTrainingEndTime() == null ^ this.getTrainingEndTime() == null) {
            return false;
        }
        if (other.getTrainingEndTime() != null && !other.getTrainingEndTime().equals(this.getTrainingEndTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getSecondaryStatusTransitions() == null ^ this.getSecondaryStatusTransitions() == null) {
            return false;
        }
        if (other.getSecondaryStatusTransitions() != null && !other.getSecondaryStatusTransitions().equals(this.getSecondaryStatusTransitions())) {
            return false;
        }
        if (other.getFinalMetricDataList() == null ^ this.getFinalMetricDataList() == null) {
            return false;
        }
        if (other.getFinalMetricDataList() != null && !other.getFinalMetricDataList().equals(this.getFinalMetricDataList())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        if (other.getEnableNetworkIsolation() != null && !other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation())) {
            return false;
        }
        if (other.getEnableInterContainerTrafficEncryption() == null ^ this.getEnableInterContainerTrafficEncryption() == null) {
            return false;
        }
        return other.getEnableInterContainerTrafficEncryption() == null || other.getEnableInterContainerTrafficEncryption().equals(this.getEnableInterContainerTrafficEncryption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingJobName() == null ? 0 : this.getTrainingJobName().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingJobArn() == null ? 0 : this.getTrainingJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getTuningJobArn() == null ? 0 : this.getTuningJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getLabelingJobArn() == null ? 0 : this.getLabelingJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getModelArtifacts() == null ? 0 : this.getModelArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingJobStatus() == null ? 0 : this.getTrainingJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryStatus() == null ? 0 : this.getSecondaryStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameters() == null ? 0 : this.getHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmSpecification() == null ? 0 : this.getAlgorithmSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingStartTime() == null ? 0 : this.getTrainingStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingEndTime() == null ? 0 : this.getTrainingEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryStatusTransitions() == null ? 0 : this.getSecondaryStatusTransitions().hashCode());
        hashCode = 31 * hashCode + (this.getFinalMetricDataList() == null ? 0 : this.getFinalMetricDataList().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        hashCode = 31 * hashCode + (this.getEnableInterContainerTrafficEncryption() == null ? 0 : this.getEnableInterContainerTrafficEncryption().hashCode());
        return hashCode;
    }

    public DescribeTrainingJobResult clone() {
        try {
            return (DescribeTrainingJobResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

