__author__ = "Natalie Shapira"
__copyright__ = "Copyright 2021, Hebrew Psychological Lexicons Project"
__credits__ = ["Natalie Shapira", "Dana Atzil-Slonim", "Daniel Juravski", "Moran Baruch",
               "Adar Paz", "Dana Stolowicz-Melman" , "Tal Alfi-Yogev" , "Roy Azoulay" ,
               "Adi Singer", "Maayan Revivo", "Chen Dahbash", "Limor Dayan", "Tamar Naim",
               "Lidar Gez", "Boaz Yanai", "Adva Maman", "Adam Nadaf", "Elinor Sarfati",
               "Amna Baloum", "Tal Naor", "Ephraim Mosenkis", "Matan Kenigsbuch",
               "Badreya Sarsour", "Yarden Elias", "Liat Braun", "Moria Rubin",
               "Jany Gelfand Morgenshteyn", "Noa Bergwerk", "Noam Yosef", "Sivan Peled",
               "Coral Avigdor", "Rahav Obercyger", "Rachel Mann", "Tomer Alper", "Inbal Beka",
               "Ori Shapira", "Yoav Goldberg"]
__license__ = "Apache-2.0; CC-BY-SA"
__version__ = "1.0.3"
__maintainer__ = "Natalie Shapira"
__email__ = "nd1234@gmail.com"


from src.hepsylex.Constants import Constants
from os import listdir
from os.path import isfile, join

class Lexicons(object):
    ConversationTopics_Topic000 = ['נושא', 'חינוך', 'נפרדות', 'משרד', 'תהליך', 'דוגמא', 'ראש', 'אחרים', 'אומרת',
                                   'אירוע', 'ממשלה', 'מערכת', 'נקרא', 'תחום', 'וועד', 'מציאות', 'אוקי', 'כבד', 'השקעה',
                                   'סביבה']
    ConversationTopics_Topic001 = ['להבין', 'אדם', 'להגיד', 'מנסה', 'אומרת', 'להסביר', 'לפגוע', 'לקבל', 'פוגע', 'צורה',
                                   'פגע', 'יחס', 'ניסה', 'מקום', 'להיכנס', 'אגו', 'כבוד', 'דוגמא', 'קשר', 'ניסיתי']
    ConversationTopics_Topic002 = ['רגשות', 'רגש', 'אמרת', 'תאומרת', 'לתת', 'נקודה', 'רחמים', 'התחלה', 'דיוק', 'זאתי',
                                   'שאת', 'דיאלוג', 'עצובה', 'עצב', 'הרגשת', 'עמוק', 'שמחה', 'מוסר', 'פנימי', 'מודע']
    ConversationTopics_Topic003 = ['נגיד', 'יודעת', 'קטע', 'דברים', 'פעמים', 'אנשים', 'בואי', 'מלא', 'אומרת', 'אומרים',
                                   'סוג', 'בוא', 'אמת', 'דוגמא', 'באה', 'להגיד', 'סדר', 'מפריע', 'מדברים', 'רמה']
    ConversationTopics_Topic004 = ['תחושה', 'זמן', 'זאתי', 'חדר', 'כושר', 'תחושות', 'טובה', 'מרגיש', 'עליות', 'לשון',
                                   'מדהים', 'ירידות', 'נעימה', 'מרוצה', 'פספוס', 'לשחרר', 'טבלה', 'מוצא', 'תקופה',
                                   'תקופות']
    ConversationTopics_Topic005 = ['עבודה', 'יודע', 'לעשות', 'אומר', 'עושה', 'עניין', 'נותן', 'מקום', 'בוא', 'מתאים',
                                   'תשמע', 'בחינת', 'רוצה', 'אמת', 'אוהב', 'מעדיף', 'עוזב', 'מנהל', 'עובד', 'רגע']
    ConversationTopics_Topic006 = ['זמן', 'סדר', 'מתח', 'התעצבנתי', 'לקחתי', 'פעמים', 'עיצבן', 'דיברתי', 'תדאג', 'מנה',
                                   'הפתעה', 'ויכוח', 'עצבני', 'טריגר', 'ישבתי', 'גינה', 'משחרר', 'גדולה', 'כואב',
                                   'לשחרר']
    ConversationTopics_Topic007 = ['אישה', 'גברים', 'גבר', 'כלב', 'נשים', 'אומרת', 'כלבה', 'כלבים', 'לצאת', 'נשוי',
                                   'בעל', 'איש', 'יחסים', 'בעלה', 'להתלונן', 'זקן', 'סיבוב', 'נשית', 'גינת', 'גברי']
    ConversationTopics_Topic008 = ['החלטה', 'רוצה', 'להחליט', 'החלטות', 'לקבל', 'לבחור', 'בחירה', 'חיים', 'מקבל',
                                   'מתאים', 'אוקיי', 'קיבלתי', 'סופו', 'החלטתי', 'זמן', 'אופציות', 'אופציה', 'בחרתי',
                                   'מחליט', 'אחליט']
    ConversationTopics_Topic009 = ['טיול', 'קיבוץ', 'הולכים', 'טיולים', 'מקום', 'עושים', 'ראינו', 'מועדון', 'בריכה',
                                   'חוזרים', 'מדריך', 'פרחים', 'שנתי', 'קבוצה', 'רעש', 'משנה', 'חור', 'איבוד', 'גדול',
                                   'הלכו']
    ConversationTopics_Topic010 = ['ללמוד', 'לימודים', 'תואר', 'קורס', 'אוניברסיטה', 'למדתי', 'מבחן', 'תחום', 'מקצוע',
                                   'לומדת', 'לעשות', 'מבחנים', 'עשיתי', 'שנה', 'עבודה', 'לומד', 'קורסים', 'לומדים',
                                   'מתמטיקה', 'מעניין']
    ConversationTopics_Topic011 = ['לעשות', 'עשיתי', 'דברים', 'עושה', 'אעשה', 'סדר', 'עושים', 'רשימה', 'לום', 'עשית',
                                   'מחשב', 'צעד', 'פעמים', 'נעשה', 'אוקי', 'אוקיי', 'קטן', 'ראש', 'הספקתי', 'תעשי']
    ConversationTopics_Topic012 = ['להגיד', 'אומר', 'רגע', 'צורה', 'תגובה', 'מפריע', 'אמרת', 'הפריע', 'רואה', 'אומרים',
                                   'לבוא', 'מילה', 'לדבר', 'סיבה', 'ראיתי', 'קרה', 'לפתוח', 'מראה', 'להגיב', 'קורה']
    ConversationTopics_Topic013 = ['נפש', 'תחום', 'בריאות', 'קורס', 'שירות', 'מתמודדים', 'נקרא', 'שיקום', 'אנוש',
                                   'עובדים', 'הוסטל', 'קהל', 'גועל', 'פסיכולוגיה', 'תוכנית', 'מלווה', 'אגודת', 'עמיתים',
                                   'הרצאה', 'משפחות']
    ConversationTopics_Topic014 = ['אנשים', 'אחרים', 'איתם', 'מעניין', 'לדבר', 'דברים', 'חברים', 'אדם', 'נגיד',
                                   'מקומות', 'מקום', 'סביבה', 'מדברים', 'ראיתי', 'חברה', 'כיף', 'אוהבת', 'לראות',
                                   'קרובים', 'שונה']
    ConversationTopics_Topic015 = ['משחק', 'משחקים', 'לשחק', 'כדורגל', 'אוהב', 'משחקת', 'כדורסל', 'עולם', 'משחקי',
                                   'זאתי', 'מגרש', 'ספורט', 'קלפים', 'שיחק', 'ענק', 'שחק', 'שחקן', 'קבוצה', 'שיחקתי',
                                   'כלים']
    ConversationTopics_Topic016 = ['אדם', 'ביקורת', 'לבן', 'צורה', 'אומרת', 'רגיל', 'מבוגר', 'סוג', 'פנים', 'עוזר',
                                   'חסר', 'מעבירה', 'תעשה', 'חיבה', 'עושה', 'בני', 'אוד', 'עמוד', 'ביצה', 'קול']
    ConversationTopics_Topic017 = ['התחיל', 'מתחיל', 'התחלתי', 'משבר', 'מתחילים', 'קרה', 'התחילו', 'להיכנס', 'רגע',
                                   'טיפה', 'קיצור', 'הגיע', 'נכנס', 'משכורות', 'לצעוק', 'תחיל', 'דיוק', 'התחלנו',
                                   'להתחיל', 'לקח']
    ConversationTopics_Topic018 = ['אמרתי', 'רוצה', 'אומר', 'מעצבן', 'נראה', 'להגיד', 'נניח', 'יצא', 'לדבר', 'קטע',
                                   'משנה', 'עיצב', 'קיצור', 'מבינה', 'אגיד', 'זוכרת', 'הבנת', 'בעיה', 'התעצבנתי',
                                   'לשים']
    ConversationTopics_Topic019 = ['מים', 'קפה', 'כוס', 'לשתות', 'שותה', 'לקפוץ', 'שתיתי', 'יין', 'שתה', 'בקבוק',
                                   'בירה', 'שתייה', 'קולה', 'לשבת', 'חמים', 'שותים', 'מלאה', 'קפצתי', 'וודקה', 'שמש']
    ConversationTopics_Topic020 = ['בחינה', 'ידיים', 'רגליים', 'מצב', 'לעשות', 'ראש', 'נפשית', 'פיזית', 'בחינת',
                                   'להוציא', 'לדאוג', 'מעמד', 'להילחם', 'נופל', 'להרים', 'חיים', 'מבחינה', 'עולה',
                                   'ליפול', 'עלה']
    ConversationTopics_Topic021 = ['תקופה', 'שנה', 'עבדתי', 'התחלתי', 'שנים', 'עשיתי', 'זמן', 'ארוכה', 'לעבוד', 'התחלה',
                                   'חזרתי', 'עבודה', 'עברתי', 'למדתי', 'חודשים', 'שלב', 'עזבתי', 'אחרונה', 'לקח',
                                   'לחזור']
    ConversationTopics_Topic022 = ['תקשורת', 'מקום', 'מטפל', 'חיים', 'רוצה', 'מאמן', 'הריון', 'מטפלים', 'להגיד',
                                   'מטופל', 'שאלתי', 'הקשבה', 'זוגיות', 'קוראים', 'נגיד', 'תהליך', 'אימון', 'מרחב',
                                   'שלו', 'עיני']
    ConversationTopics_Topic023 = ['זוכרת', 'ילדה', 'אמא', 'קטנה', 'גיל', 'ילדות', 'הורים', 'חושבת', 'גדולה', 'גדלתי',
                                   'סוג', 'כיתה', 'הבנתי', 'בית', 'נולדה', 'שהייתי', 'גדלה', 'צעירה', 'דיוק', 'קיבוץ']
    ConversationTopics_Topic024 = ['אמרה', 'אמרתי', 'אומרת', 'אמא', 'דיברתי', 'אחותי', 'סיפרתי', 'חברה', 'דיברה',
                                   'לדבר', 'שאלתי', 'טלפון', 'תשמעי', 'שאלה', 'נתנה', 'סיפרה', 'רצתה', 'תראי', 'עשתה',
                                   'קיצור']
    ConversationTopics_Topic025 = ['מדבר', 'נושא', 'מדברים', 'דברים', 'חושב', 'נושאים', 'ביקורת', 'דיברנו', 'מקבל',
                                   'לקבל', 'מביא', 'שומע', 'קיצור', 'בודק', 'הגנה', 'מסכים', 'משימות', 'זהיר', 'זהירות',
                                   'נקודה']
    ConversationTopics_Topic026 = ['חברה', 'חברות', 'טובה', 'יודעת', 'חושבת', 'טובות', 'מקום', 'חברים', 'אמת', 'זאתי',
                                   'חבורה', 'בנות', 'טיפוס', 'זוגיות', 'נמצאת', 'קרובות', 'נפגשות', 'אוהבת', 'קרובה',
                                   'איתן']
    ConversationTopics_Topic027 = ['ארץ', 'עיר', 'מקום', 'מרכז', 'לנסוע', 'גרה', 'באה', 'אזור', 'רחוב', 'חבר', 'גרים',
                                   'נוסעת', 'צפון', 'קרוב', 'נסעתי', 'הורים', 'אוקי', 'רחוק', 'גדולה', 'מגיעה']
    ConversationTopics_Topic028 = ['עבודה', 'חברה', 'חברת', 'ראיון', 'לעבוד', 'קורות', 'מקום', 'תפקיד', 'חיים', 'שירות',
                                   'עבדתי', 'מנהלת', 'ראיונות', 'כוח', 'ניסיון', 'נראה', 'שכר', 'ריאיון', 'אמרו',
                                   'הציעו']
    ConversationTopics_Topic029 = ['שנה', 'חודש', 'חודשים', 'עברה', 'חודשיים', 'זמן', 'שנים', 'שנתיים', 'נגמר', 'תקופה',
                                   'באה', 'אחרונה', 'שבועיים', 'ערך', 'קרה', 'תראי', 'תחילת', 'שינוי', 'גדול', 'שבועות']
    ConversationTopics_Topic030 = ['כסף', 'לשלם', 'חשבון', 'חודש', 'בנק', 'מחיר', 'דירה', 'לקחת', 'עולה', 'שילמתי',
                                   'סכום', 'משכורת', 'מצב', 'הוצאות', 'לקנות', 'משכנתא', 'כלכלי', 'משלמת', 'לתת',
                                   'לוקח']
    ConversationTopics_Topic031 = ['יודעת', 'ללכת', 'הולכת', 'לעשות', 'רוצה', 'לצאת', 'עושה', 'לכת', 'מקום', 'בית',
                                   'לחזור', 'לום', 'לשבת', 'אלך', 'זמן', 'אוהבת', 'מעדיפה', 'רגל', 'אעשה', 'כוח']
    ConversationTopics_Topic032 = ['יום', 'אמרתי', 'ערב', 'בוקר', 'שעה', 'התקשרתי', 'לבוא', 'שבוע', 'להגיע', 'ידעתי',
                                   'קבענו', 'קבעתי', 'פגישה', 'צהריים', 'עבודה', 'להתחיל', 'נראה', 'התקשרה', 'תבוא',
                                   'שעתיים']
    ConversationTopics_Topic033 = ['לחץ', 'מלחיץ', 'מתח', 'לחוץ', 'גוף', 'סוכר', 'רגוע', 'שמאל', 'לחוצה', 'גבוה',
                                   'הכניס', 'בדיקה', 'להכניס', 'סכרת', 'נתן', 'מתחים', 'יוצר', 'שינויים', 'לחצים',
                                   'להוריד']
    ConversationTopics_Topic034 = ['אמרתי', 'הרגשתי', 'ראיתי', 'רציתי', 'ידעתי', 'הלכתי', 'עשיתי', 'הבנתי', 'חשבתי',
                                   'רגע', 'הגעתי', 'התחלתי', 'נכנסתי', 'באתי', 'קרה', 'יצאתי', 'לקחתי', 'ניסיתי',
                                   'לעשות', 'שלב']
    ConversationTopics_Topic035 = ['יודעת', 'אומרת', 'קטע', 'מבינה', 'מאמינה', 'סדר', 'אלוהים', 'אמת', 'חיה', 'רוך',
                                   'ואי', 'תשמעי', 'האמין', 'הכל', 'להאמין', 'משפחה', 'לוקחת', 'לשים', 'ברוך', 'עין']
    ConversationTopics_Topic036 = ['עבודה', 'שעות', 'יום', 'שבוע', 'לעבוד', 'ימים', 'עובדת', 'בוקר', 'זמן', 'עובד',
                                   'לעשות', 'יוצא', 'חודש', 'משמרת', 'עומס', 'ערב', 'נגיד', 'עבדתי', 'משמרות', 'משרה']
    ConversationTopics_Topic037 = ['אוהבת', 'אהבה', 'אוהב', 'כיף', 'אמת', 'אהבתי', 'חיבוק', 'לתת', 'לקבל', 'אדם',
                                   'נשיקה', 'אוהבים', 'שונאת', 'קטע', 'לאהוב', 'נתן', 'חסר', 'נותנת', 'טיפוס', 'מגע']
    ConversationTopics_Topic038 = ['אמרתי', 'טעות', 'סדר', 'מרוצה', 'צודק', 'בעיה', 'להוציא', 'עשית', 'אוקי', 'כדור',
                                   'נעשה', 'רגע', 'אמרת', 'בוא', 'צעד', 'אחוז', 'טעויות', 'עשיתי', 'אומר', 'טעיתי']
    ConversationTopics_Topic039 = ['אמרתי', 'ראיתי', 'בלה', 'נתתי', 'רגע', 'מבט', 'צודקת', 'אלימות', 'הסתכלתי', 'טעה',
                                   'טובה', 'עניתי', 'קורה', 'ציניות', 'מודה', 'הערתי', 'ישב', 'שיקול', 'גדול', 'הערות']
    ConversationTopics_Topic040 = ['רוצה', 'לעשות', 'יקרה', 'מצב', 'להמשיך', 'להתחיל', 'מקווה', 'חיים', 'לראות',
                                   'לחשוב', 'לתת', 'אצטרך', 'לדעת', 'לקחת', 'לעבוד', 'דברים', 'חשבתי', 'להתמודד',
                                   'לנסות', 'חושבת']
    ConversationTopics_Topic041 = ['שנים', 'נניח', 'שנה', 'רונית', 'בעיה', 'בית', 'בעיות', 'שירה', 'גיל', 'ירה',
                                   'פנסיה', 'שרה', 'נדמה', 'נראה', 'עשתה', 'מצב', 'זתומרת', 'אמרה', 'אורה', 'אילן']
    ConversationTopics_Topic042 = ['יום', 'שעה', 'שעות', 'מגיעה', 'בית', 'עבודה', 'חוזרת', 'הולכת', 'שעתיים', 'הפסקה',
                                   'יוצאת', 'עייפה', 'סדר', 'מלא', 'לנוח', 'לשבת', 'שקט', 'עייפות', 'סיבה', 'בורחת']
    ConversationTopics_Topic043 = ['אמרו', 'עשו', 'ראיתי', 'ידעתי', 'באו', 'נתנו', 'רצו', 'אנשים', 'ראו', 'התחלה',
                                   'איתם', 'דיברו', 'הגיעו', 'ישבו', 'יחיד', 'אומרים', 'התחילו', 'חשבו', 'שמעתי',
                                   'שאלתי']
    ConversationTopics_Topic044 = ['חיים', 'תקופה', 'תקופות', 'דברים', 'לראות', 'מאושר', 'שנים', 'קשים', 'אושר', 'גיל',
                                   'ידי', 'טובים', 'טובות', 'חיי', 'מאושרת', 'חוויות', 'שמחה', 'עובר', 'שמח', 'עוברת']
    ConversationTopics_Topic045 = ['אופניים', 'כביש', 'אוטו', 'מכוניות', 'מכונית', 'חניה', 'רחוב', 'דרכים', 'חניון',
                                   'רכב', 'גשר', 'נהג', 'קיבלתי', 'כבישים', 'אמצע', 'מכירה', 'חדשות', 'סיכוי', 'תנועה',
                                   'אופנוע']
    ConversationTopics_Topic046 = ['מתאים', 'מחפשת', 'אינטרנט', 'למצוא', 'לחפש', 'מצאתי', 'זמן', 'אתר', 'חיפשתי',
                                   'מחפש', 'זוגיות', 'לצאת', 'מוצאת', 'חסר', 'החלטתי', 'מקום', 'תירוצים', 'מתאימים',
                                   'תירוץ', 'אמצא']
    ConversationTopics_Topic047 = ['יודעת', 'חושבת', 'סיטואציה', 'נגיד', 'מושג', 'בחינת', 'להגיד', 'ברור', 'בחינתי',
                                   'מכירה', 'מקום', 'בואי', 'שאת', 'קטע', 'סוג', 'עובדה', 'בחורה', 'אדם', 'קיי',
                                   'נראית']
    ConversationTopics_Topic048 = ['עזרה', 'לעזור', 'לבקש', 'מבקשת', 'רוצה', 'ביקשתי', 'עוזר', 'עוזרת', 'לתת', 'עוזרים',
                                   'מצב', 'תעזור', 'מבקש', 'קיבלתי', 'נותנת', 'מבקשים', 'מובן', 'לקבל', 'באה', 'אבקש']
    ConversationTopics_Topic049 = ['יודעת', 'מרגישה', 'הרגשתי', 'חושבת', 'הרגיש', 'להרגיש', 'אשמה', 'נוח', 'רגשות',
                                   'מקום', 'אמת', 'תחושה', 'להסביר', 'רגעים', 'סוג', 'קשר', 'חוסר', 'תחושות', 'הרגשה',
                                   'רגישה']
    ConversationTopics_Topic050 = ['דיכאון', 'מצב', 'הרגשה', 'זאתי', 'ראש', 'גוף', 'מרגישה', 'כואב', 'כאב', 'הרגשתי',
                                   'פיזית', 'תחושה', 'להתמודד', 'חזקה', 'קרה', 'נפשית', 'סוג', 'הרגיש', 'הכל', 'הצלחתי']
    ConversationTopics_Topic051 = ['מצב', 'הגעתי', 'רוח', 'זמן', 'מגיע', 'להגיע', 'נמצאת', 'מקום', 'קורה', 'משפיע',
                                   'שלב', 'עבודה', 'משנה', 'נמצא', 'מצבים', 'באסה', 'שגרה', 'רגיל', 'מצבי', 'לחץ']
    ConversationTopics_Topic052 = ['אמרה', 'עשתה', 'אמא', 'רצתה', 'אומרת', 'באה', 'הלכה', 'התחילה', 'ראתה', 'לקחה',
                                   'ידעה', 'אישה', 'חברה', 'דיברה', 'קיבלה', 'סיפרה', 'נתנה', 'חזרה', 'הגיעה', 'עבדה']
    ConversationTopics_Topic053 = ['ביטוח', 'פנסיה', 'לאומי', 'משכורת', 'עבודה', 'שנה', 'קיבלתי', 'שכר', 'כסף', 'מגיע',
                                   'הכנסה', 'חוק', 'עובד', 'מקבל', 'תוכנה', 'לעבוד', 'לקבל', 'חודשים', 'חוזה', 'חודש']
    ConversationTopics_Topic054 = ['חושבת', 'דברים', 'פרידה', 'להכיל', 'רמה', 'להרגיש', 'רגשית', 'קורה', 'הרגשתי',
                                   'להתמודד', 'הבנתי', 'לחשוב', 'חולשה', 'להבין', 'חוויתי', 'נקודות', 'שטויות', 'קשים',
                                   'סופו', 'חיים']
    ConversationTopics_Topic055 = ['לראות', 'טלוויזיה', 'רואה', 'עיתונים', 'עיתון', 'ראיתי', 'זמן', 'טלויזיה', 'חדשות',
                                   'תוכנית', 'ראה', 'לשבת', 'תכנית', 'ערוץ', 'נגיד', 'אראה', 'תוכניות', 'אוהבת', 'מחשב',
                                   'רדיו']
    ConversationTopics_Topic056 = ['עצמית', 'נמוך', 'גבוהה', 'מודעות', 'רמה', 'ביטחון', 'גבוה', 'ביטוי', 'רמת', 'הערכה',
                                   'דימוי', 'נמוכה', 'ידי', 'חוסר', 'טיפה', 'מעגל', 'ערכה', 'גובה', 'בעיה', 'מעמד']
    ConversationTopics_Topic057 = ['קול', 'לשמוע', 'מוזיקה', 'שומעת', 'שומע', 'דברים', 'שיר', 'שירים', 'רעש', 'שמעתי',
                                   'אוזן', 'קולות', 'ראש', 'אומר', 'שומעים', 'ידי', 'טלויזיה', 'מעניין', 'רדיו', 'שקט']
    ConversationTopics_Topic058 = ['עובד', 'עבודה', 'משרד', 'אנשים', 'מנהל', 'עובדים', 'עסק', 'בוס', 'לעבוד', 'לקוחות',
                                   'תחום', 'לנהל', 'שיווק', 'צוות', 'ניהול', 'מכירות', 'מנהלת', 'לקוח', 'שיחה', 'חדש']
    ConversationTopics_Topic059 = ['דברים', 'טובים', 'להגיד', 'צורה', 'חיים', 'טובה', 'קורים', 'להסתכל', 'לראות',
                                   'אחרים', 'חיובי', 'בצורה', 'צדדים', 'רואה', 'איתם', 'לחשוב', 'סוג', 'מסוימים',
                                   'חיוביים', 'עליהם']
    ConversationTopics_Topic060 = ['הולך', 'רואה', 'שמח', 'חיים', 'מצליח', 'הצלחה', 'נראה', 'כישלון', 'ציפיות', 'אומר',
                                   'עצוב', 'פחד', 'אדם', 'לעמוד', 'גרוע', 'מסתדרים', 'אצליח', 'להצליח', 'עומד', 'עולם']
    ConversationTopics_Topic061 = ['יודעת', 'זמן', 'סבלנות', 'צעקות', 'עצבים', 'אמת', 'רבים', 'לסבול', 'אמצע', 'לשמוע',
                                   'מנסה', 'רבה', 'פעמים', 'עצבני', 'עצבנית', 'עיצב', 'שקט', 'צועק', 'מריבות', 'שיא']
    ConversationTopics_Topic062 = ['חלום', 'חלומות', 'עוגה', 'זוכרת', 'חלמתי', 'חלב', 'שוקולד', 'זאתי', 'סוכר', 'חולמת',
                                   'נגמר', 'חתיכה', 'ממתקים', 'חמאה', 'לחם', 'להתעסק', 'בצק', 'גלידה', 'לאכול', 'עוגת']
    ConversationTopics_Topic063 = ['יודעת', 'מצליחה', 'מנסה', 'לעשות', 'לחשוב', 'דברים', 'הצלחתי', 'ניסה', 'זמן',
                                   'להבין', 'חושבת', 'נגיד', 'לנסות', 'מרגישה', 'ניסיתי', 'להגיד', 'אוקי', 'לקבל',
                                   'למצוא', 'לראות']
    ConversationTopics_Topic064 = ['חתונה', 'גבולות', 'להתחתן', 'חיים', 'ילדים', 'לשים', 'התחתנו', 'להביא', 'נישואין',
                                   'להעמיד', 'מתחתנת', 'נישואים', 'התחתנתי', 'מתחתנים', 'דבש', 'הריון', 'הבנתי',
                                   'להציב', 'התחתנה', 'אופן']
    ConversationTopics_Topic065 = ['מבחן', 'מסוימת', 'מידה', 'תוצאות', 'מעבדה', 'לומד', 'מציאות', 'חומר', 'מחקר',
                                   'מנחה', 'מורה', 'וכו', 'מים', 'תנאי', 'מבחנים', 'נושא', 'חומרים', 'שיטות', 'שיטה',
                                   'אבחון']
    ConversationTopics_Topic066 = ['בוא', 'אמרתי', 'בואי', 'הלכנו', 'נלך', 'נעשה', 'כיף', 'עשינו', 'אמרנו', 'מסעדה',
                                   'ישבנו', 'נחמד', 'נראה', 'הגענו', 'סדר', 'דיברנו', 'רציתי', 'טובה', 'זוכרת', 'קפה']
    ConversationTopics_Topic067 = ['מקום', 'מקומות', 'להגיע', 'רוצה', 'רחוק', 'נמצא', 'להישאר', 'נוח', 'חדש', 'נמצאת',
                                   'להביא', 'רוצים', 'לברוח', 'ללכת', 'עזבו', 'לעזוב', 'פינה', 'לחפש', 'לפנות', 'נקודה']
    ConversationTopics_Topic068 = ['ילדים', 'ילד', 'אמא', 'זמן', 'אומרת', 'גיל', 'קטן', 'תינוק', 'משפחה', 'חיים', 'בית',
                                   'גדול', 'קטנים', 'להביא', 'ראה', 'לדאוג', 'ילדה', 'איתם', 'אבא', 'הורים']
    ConversationTopics_Topic069 = ['זוכר', 'חושב', 'יודע', 'ילדות', 'ילד', 'חבר', 'מדבר', 'קוראים', 'קראו', 'סיפרתי',
                                   'סיבה', 'בטוח', 'מכות', 'עשינו', 'קרה', 'יחידי', 'פסיכולוג', 'זיכרון', 'לזכור',
                                   'קונפליקט']
    ConversationTopics_Topic070 = ['שבוע', 'עבר', 'יום', 'ימים', 'שבועיים', 'חודש', 'אחרונים', 'אחרון', 'שבועות',
                                   'דיברנו', 'נראה', 'מהלך', 'יומיים', 'שלם', 'ימי', 'התחיל', 'קרוב', 'התחלתי', 'קיצור',
                                   'נקרא']
    ConversationTopics_Topic071 = ['אעשה', 'אמרתי', 'אגיד', 'זמן', 'לעשות', 'חשבתי', 'נראה', 'סדר', 'אלך', 'אקח',
                                   'ארגיש', 'אצטרך', 'סופו', 'אבוא', 'אראה', 'עשיתי', 'אגיע', 'אנסה', 'אתחיל', 'אשב']
    ConversationTopics_Topic072 = ['יום', 'הולדת', 'שלי', 'מתנה', 'ימי', 'שבת', 'עשינו', 'מתנות', 'ברכה', 'מזל',
                                   'קיצור', 'הפתעה', 'חברים', 'דיוק', 'ביום', 'מסיבת', 'רבה', 'שבוע', 'לחגוג', 'הרס']
    ConversationTopics_Topic073 = ['דברים', 'קושי', 'להתמודד', 'תחושה', 'עניין', 'חוסר', 'תחושת', 'להבין', 'פעמים',
                                   'קשיים', 'קשים', 'סיטואציות', 'ראה', 'עבר', 'אחרים', 'מצליח', 'סדר', 'נובע',
                                   'התמודדות', 'סיטואציה']
    ConversationTopics_Topic074 = ['ישיבה', 'דתי', 'הולך', 'בית', 'תורה', 'לומד', 'כנסת', 'רוחנית', 'דברים', 'דתיים',
                                   'חרדי', 'ישיבות', 'שיעור', 'מכיר', 'תשובה', 'זוכר', 'להתפלל', 'לבוש', 'אמונה', 'חור']
    ConversationTopics_Topic075 = ['תהליך', 'תהליכים', 'עברתי', 'דברים', 'לעבור', 'שלב', 'משפטי', 'עוברת', 'צורה',
                                   'חדשה', 'מטרה', 'יועץ', 'לראות', 'תמיכה', 'הליך', 'עוברים', 'ייעוץ', 'יועצת', 'הצעה',
                                   'התפתחות']
    ConversationTopics_Topic076 = ['תיק', 'משטרה', 'רכב', 'נהיגה', 'רישיון', 'להוציא', 'רשיון', 'סדר', 'מושג', 'שוטר',
                                   'כבד', 'ארנק', 'טסט', 'תיקים', 'תעודת', 'מפתחות', 'זהות', 'הוסיף', 'עברה', 'פלאפון']
    ConversationTopics_Topic077 = ['יוצא', 'עניין', 'פעמים', 'דופן', 'ראשוני', 'חזור', 'נגיד', 'ערך', 'הלוך', 'שונים',
                                   'להחזיר', 'משימה', 'להגיע', 'מנוע', 'לוקח', 'בעל', 'מקומות', 'תחומי', 'אינסטינקט',
                                   'נכנס']
    ConversationTopics_Topic078 = ['עושה', 'אומרת', 'רואה', 'הולכת', 'שמחה', 'בעיה', 'מתחילה', 'יושבת', 'ראה', 'נניח',
                                   'עוזרת', 'נכנסת', 'עובדת', 'מגיעה', 'עובד', 'רבה', 'משתמשת', 'מצוין', 'עיניי',
                                   'עיסוק']
    ConversationTopics_Topic079 = ['חוויה', 'מציאות', 'זמן', 'מקום', 'דמיון', 'עצוב', 'בניתי', 'חוויות', 'לקחת', 'ילד',
                                   'אוד', 'הגיע', 'דמות', 'עצב', 'אהבתי', 'רגילה', 'געת', 'חדשה', 'מסגרת', 'להתרחק']
    ConversationTopics_Topic080 = ['מרגיש', 'נוח', 'יודע', 'הרגשה', 'להרגיש', 'עושה', 'אומר', 'להגיד', 'טובה', 'בטוח',
                                   'מקום', 'מצליח', 'רגיש', 'נותן', 'ביטחון', 'לבוא', 'רגע', 'מחפש', 'סיטואציה', 'חסר']
    ConversationTopics_Topic081 = ['אומר', 'אנשים', 'מכות', 'משוגע', 'עולם', 'בדידות', 'שקט', 'חרא', 'משוגעת', 'מבינה',
                                   'משקר', 'מוציא', 'חברים', 'תחרות', 'גדולה', 'אסמכתאות', 'תראי', 'חוזר', 'שנה',
                                   'להוציא']
    ConversationTopics_Topic082 = ['עיניים', 'נראית', 'רואים', 'מראה', 'פנים', 'מסתכלת', 'לראות', 'שיער', 'מבט',
                                   'להסתכל', 'חיצוני', 'פנימי', 'עולם', 'חיוך', 'צבע', 'אופי', 'דומה', 'עליה', 'מגניב',
                                   'לשים']
    ConversationTopics_Topic083 = ['טיפול', 'מטפלת', 'חושבת', 'פסיכולוגי', 'פסיכולוגית', 'טיפולים', 'מטפל', 'נראה',
                                   'להמשיך', 'לטפל', 'עניין', 'טיפולי', 'פגישה', 'אמת', 'סוג', 'אמרת', 'תהליך', 'ללכת',
                                   'פגישות', 'מטופל']
    ConversationTopics_Topic084 = ['שעה', 'זמן', 'דקות', 'בית', 'לצאת', 'להגיע', 'דקה', 'לעשות', 'הגעתי', 'עבודה',
                                   'מגיעה', 'לחץ', 'להספיק', 'נסיעה', 'באתי', 'לחכות', 'לוקח', 'יצאתי', 'שעון', 'לסיים']
    ConversationTopics_Topic085 = ['לאכול', 'אוכלת', 'יודעת', 'להכין', 'טעים', 'סלט', 'בית', 'לבשל', 'הכנתי', 'אכלתי',
                                   'עושה', 'יום', 'אוכלים', 'מבשלת', 'רעב', 'מרק', 'אוהבת', 'ירקות', 'ארוחת', 'פירות']
    ConversationTopics_Topic086 = ['עושה', 'רוצה', 'זמן', 'דברים', 'יודעת', 'אומרת', 'לעשות', 'מקום', 'לתת', 'נותנת',
                                   'סדר', 'מבינה', 'הרגשה', 'מפריע', 'רגע', 'גבול', 'מוותרת', 'לוקחת', 'מביאה', 'הרגיש']
    ConversationTopics_Topic087 = ['תקווה', 'פתח', 'אביב', 'רמת', 'עושים', 'איש', 'חדש', 'אונו', 'שכונה', 'חשמל',
                                   'מגיעה', 'גרה', 'קריית', 'חברת', 'אזור', 'יחידה', 'איזור', 'מנהל', 'בטיחות', 'דרום']
    ConversationTopics_Topic088 = ['פגישה', 'אמרתי', 'שבוע', 'דיברנו', 'יצא', 'לדבר', 'נחמד', 'עבר', 'דיברתי', 'רציתי',
                                   'זמן', 'סדר', 'התחלה', 'יצאתי', 'נפגשנו', 'אמת', 'שיחה', 'אחרונה', 'ראיתי', 'להיפגש']
    ConversationTopics_Topic089 = ['אומרת', 'מצחיק', 'עושה', 'כיף', 'שטויות', 'הומור', 'אומרים', 'צחוק', 'ואי', 'צוחקת',
                                   'צוחקים', 'מסתכלת', 'לצחוק', 'מזל', 'יושבת', 'וואי', 'צחוקים', 'מתה', 'חוש', 'יואו']
    ConversationTopics_Topic090 = ['חושב', 'יודע', 'אומר', 'מאמין', 'אשתי', 'סוג', 'מחשבה', 'דברים', 'מסתכל', 'הולך',
                                   'מרגיש', 'אמת', 'קטע', 'דוגמה', 'אגיד', 'איפשהו', 'יקרה', 'מחשבות', 'נושא', 'חיים']
    ConversationTopics_Topic091 = ['באה', 'אמרה', 'הגיעה', 'חברה', 'כסף', 'חזרה', 'אחותי', 'לקחת', 'ערב', 'נסעה',
                                   'לקחה', 'בנות', 'יצאה', 'דתייה', 'הלכה', 'שכנה', 'פארק', 'ישבה', 'הביאה', 'להביא']
    ConversationTopics_Topic092 = ['תמיכה', 'מחזור', 'בסיס', 'קצב', 'גדול', 'ירדו', 'מילואים', 'לדעת', 'נופלת', 'נניח',
                                   'הופך', 'יעזור', 'אסימון', 'ממשיכים', 'ירד', 'צרפת', 'יומי', 'עוברים', 'יקבל',
                                   'כתובת']
    ConversationTopics_Topic093 = ['שאלה', 'שאלות', 'תשובה', 'לשאול', 'שואלת', 'שאלתי', 'שואל', 'תשובות', 'לענות',
                                   'אלות', 'שואלים', 'רגע', 'עונה', 'שאלת', 'תשאלי', 'אשאל', 'שאלון', 'הבנתי', 'שאול',
                                   'אישיות']
    ConversationTopics_Topic094 = ['חרדה', 'שליטה', 'פחד', 'לשחרר', 'מובן', 'זמן', 'לשלוט', 'עצבים', 'גוף', 'חוסר',
                                   'חרדות', 'התקפי', 'יכלתי', 'סטרס', 'התקף', 'תוצאה', 'נכנסתי', 'אובדן', 'טירוף',
                                   'יטה']
    ConversationTopics_Topic095 = ['קשר', 'זמן', 'חברים', 'קשרים', 'ליצור', 'חבר', 'שומרת', 'ראה', 'סיפרתי', 'חיים',
                                   'לשמור', 'רציתי', 'חודשים', 'נוצר', 'חברות', 'טובים', 'חברה', 'ידיד', 'שמרתי',
                                   'איתם']
    ConversationTopics_Topic096 = ['חשבתי', 'מדריכה', 'אמרתי', 'הדרכה', 'הרגשתי', 'אמרה', 'להגיד', 'מטופלים', 'פגישה',
                                   'הבנתי', 'אמת', 'קיצר', 'נראה', 'עשיתי', 'פגישות', 'רווחה', 'הכשרה', 'מטופלת',
                                   'מקרה', 'אוקי']
    ConversationTopics_Topic097 = ['זוגיות', 'זוג', 'קשר', 'רוצה', 'נראה', 'דייטים', 'דייט', 'טובה', 'למצוא', 'רציני',
                                   'אחוז', 'לצאת', 'מובן', 'הזדמנות', 'להתקרב', 'דפוק', 'בטוח', 'לסמוך', 'אהבה', 'מלא']
    ConversationTopics_Topic098 = ['סרט', 'לראות', 'סרטים', 'נחמד', 'ראיתי', 'הצגה', 'נראה', 'ללכת', 'קולנוע', 'הולכת',
                                   'משעמם', 'מעניין', 'אוהבת', 'כיף', 'חברה', 'לכת', 'נקרא', 'הולכים', 'כרטיסים', 'אמת']
    ConversationTopics_Topic099 = ['חברים', 'זוג', 'חבר', 'חברה', 'מכיר', 'אנשים', 'מכירים', 'מכירה', 'נגיד', 'הכיר',
                                   'להכיר', 'בני', 'הכרתי', 'שנים', 'חברות', 'שנה', 'אדם', 'אמת', 'בחורה', 'זוגות']
    ConversationTopics_Topic100 = ['רואה', 'ראה', 'לראות', 'ראיתי', 'עיניים', 'עין', 'מסתכל', 'מסתכלת', 'להסתכל',
                                   'משקפיים', 'תמונה', 'ראייה', 'רחוק', 'צדדים', 'רואים', 'אדם', 'יראה', 'רחוב',
                                   'סביבה', 'מלאה']
    ConversationTopics_Topic101 = ['אמרתי', 'שאלתי', 'שיחה', 'דיברתי', 'שאל', 'להגיד', 'לדבר', 'שואל', 'שאלה', 'לשאול',
                                   'קטע', 'באתי', 'שאלות', 'שואלת', 'נתן', 'פעמים', 'שיחת', 'תספר', 'זכר', 'דיבר']
    ConversationTopics_Topic102 = ['לקנות', 'קניתי', 'חנות', 'קונה', 'כסף', 'קניות', 'קנה', 'כרטיס', 'מתנה', 'אקנה',
                                   'סופר', 'הולכת', 'הלכתי', 'מכשיר', 'מוכרת', 'לחנות', 'קניון', 'חדש', 'קונים',
                                   'בגדים']
    ConversationTopics_Topic103 = ['אוויר', 'מזגן', 'אור', 'חורף', 'מזג', 'גשם', 'חום', 'קיץ', 'להדליק', 'יורד', 'שמש',
                                   'קור', 'חושך', 'אוהבת', 'חשוך', 'לנשום', 'ירוק', 'צבע', 'נקודת', 'טמפרטורה']
    ConversationTopics_Topic104 = ['זמן', 'דברים', 'מחשבות', 'עושה', 'ראש', 'להתעסק', 'לוקח', 'אמת', 'מקום', 'עסוקה',
                                   'אחרון', 'מלא', 'מעסיק', 'לקח', 'פנוי', 'לימודים', 'לחשוב', 'לשבת', 'עסוק',
                                   'הזדמנות']
    ConversationTopics_Topic105 = ['חיים', 'אדם', 'עולם', 'לחיות', 'אומרת', 'אנשים', 'דברים', 'חושבת', 'משפחה', 'מוות',
                                   'חיה', 'תראי', 'אומרים', 'חיות', 'גדולה', 'קיצוני', 'קשיים', 'למות', 'מחשבה', 'לבן']
    ConversationTopics_Topic106 = ['טלפון', 'יום', 'לדבר', 'אמרתי', 'להתקשר', 'מתקשר', 'זמן', 'התקשר', 'מתקשרת', 'עונה',
                                   'התקשרתי', 'רוצה', 'קרה', 'שיחה', 'הודעה', 'טלפונים', 'מדבר', 'ערב', 'התקשרה',
                                   'דיברתי']
    ConversationTopics_Topic107 = ['אומרת', 'יודעת', 'זמן', 'מבינה', 'באה', 'רגע', 'תראי', 'פעמים', 'חושבת', 'מדברת',
                                   'ברור', 'אוקי', 'משנה', 'לבוא', 'מרגישה', 'יוצאת', 'מתכוונת', 'הרגשה', 'נמאס',
                                   'מסתכלת']
    ConversationTopics_Topic108 = ['בוקר', 'לילה', 'לישון', 'לקום', 'יום', 'קמתי', 'מיטה', 'ישנתי', 'ישון', 'קמה',
                                   'שינה', 'הלכתי', 'שעה', 'ישן', 'שעות', 'הולכת', 'עייפה', 'ללכת', 'התעוררתי', 'ימים']
    ConversationTopics_Topic109 = ['דין', 'משפט', 'עורך', 'חשבון', 'כסף', 'עורכת', 'משרד', 'בית', 'עורכי', 'לתת',
                                   'תביעה', 'הסכם', 'פשרה', 'דיון', 'הוצאה', 'שופט', 'משפטים', 'פועל', 'מבינה', 'נתן']
    ConversationTopics_Topic110 = ['קצר', 'ארוך', 'טווח', 'פרק', 'זמן', 'שיער', 'סמים', 'תירוץ', 'ארוכים', 'סיפור',
                                   'גמילה', 'אנשים', 'לשתוק', 'מכור', 'קוקו', 'מכורים', 'לטווח', 'חסרת', 'מציק',
                                   'להשתמש']
    ConversationTopics_Topic111 = ['כועסת', 'כעס', 'אומרת', 'לכעוס', 'כעסתי', 'כועס', 'עליה', 'צועקת', 'סיטואציה',
                                   'כעסים', 'עושה', 'זעם', 'צורה', 'עצבנית', 'נלחצת', 'התפרצויות', 'תסכול', 'לצעוק',
                                   'מתעצבנת', 'מבקשת']
    ConversationTopics_Topic112 = ['דברים', 'בגדים', 'ארון', 'לזרוק', 'חולצה', 'לסדר', 'בית', 'חדר', 'נעליים', 'שולחן',
                                   'זורקת', 'שקית', 'ארונות', 'מקום', 'סדר', 'לשים', 'זרקתי', 'מסודר', 'לקחתי',
                                   'ניירות']
    ConversationTopics_Topic113 = ['בנות', 'חברות', 'נשים', 'איתן', 'מדברות', 'נגיד', 'בנים', 'קטע', 'עושות', 'אוהבת',
                                   'בחורות', 'רוצות', 'טובות', 'אחרות', 'צעירות', 'לרקוד', 'באות', 'גילי', 'יודעות',
                                   'אומרות']
    ConversationTopics_Topic114 = ['דברים', 'אחרים', 'לעשות', 'עושה', 'יודעת', 'קשור', 'זמן', 'חושבת', 'קטנים',
                                   'קשורים', 'תראי', 'עניין', 'מקומות', 'פעמים', 'רואה', 'מסוימים', 'לטפל', 'חדשים',
                                   'לשים', 'נגיד']
    ConversationTopics_Topic115 = ['יודעת', 'נראה', 'חושבת', 'מוזר', 'ברור', 'קטע', 'נשמע', 'אמת', 'נגיד', 'דברים',
                                   'הגיוני', 'להגיד', 'אדם', 'בטוחה', 'רוצה', 'קשור', 'מתאים', 'מושג', 'מדהים', 'מניחה']
    ConversationTopics_Topic116 = ['אמרתי', 'רוצה', 'שקט', 'נתתי', 'ביקשתי', 'קטע', 'באתי', 'לקבל', 'לתת', 'רציתי',
                                   'טובה', 'להחזיר', 'הלכתי', 'תנו', 'אומרים', 'אישור', 'בקשה', 'לגמור', 'תשמעי',
                                   'נשאר']
    ConversationTopics_Topic117 = ['אומרת', 'יודעת', 'רוצה', 'מקום', 'רואה', 'חושבת', 'מצב', 'להגיד', 'ראה', 'תראי',
                                   'נכנסת', 'הולכת', 'אדם', 'מדברת', 'שאת', 'אמת', 'שואלת', 'בעלי', 'תשמעי', 'יחסים']
    ConversationTopics_Topic118 = ['אימון', 'אימונים', 'אמת', 'חושב', 'יודע', 'מכון', 'נראה', 'אשכרה', 'מאמן', 'כושר',
                                   'ידיוק', 'קולט', 'עושה', 'רואה', 'קרב', 'תחרות', 'מתאמנים', 'ואללה', 'להתאמן',
                                   'נגיד']
    ConversationTopics_Topic119 = ['מדינה', 'שוק', 'רגל', 'שחור', 'לבן', 'לדעת', 'קנאה', 'עסק', 'אפור', 'הגיע', 'קיים',
                                   'להתמודד', 'ביטחון', 'שלם', 'יודעים', 'השתלמות', 'אומר', 'אשתי', 'מידע', 'זוכר']
    ConversationTopics_Topic120 = ['חוסר', 'ביטחון', 'חסר', 'דברים', 'אונים', 'חסרת', 'אנשים', 'משא', 'בטחון', 'מתן',
                                   'לקבל', 'צדק', 'תנאים', 'פגיעה', 'ודאות', 'אמונה', 'אמון', 'אונס', 'רגישות', 'טחון']
    ConversationTopics_Topic121 = ['אומר', 'אמרתי', 'יודע', 'רוצה', 'בוא', 'תעשה', 'תראה', 'תשמע', 'תגיד', 'נכנס',
                                   'תלך', 'ראה', 'עושה', 'חבר', 'קרה', 'הולך', 'תקשיב', 'התחיל', 'מתקשר', 'עזוב']
    ConversationTopics_Topic122 = ['אמא', 'אבא', 'סבתא', 'סבא', 'שנים', 'משפחה', 'גיל', 'נפטרה', 'נפטר', 'בית', 'דודה',
                                   'חיים', 'שלי', 'שנה', 'הורים', 'אישה', 'אחותה', 'אחים', 'ילדים', 'אחות']
    ConversationTopics_Topic123 = ['שואה', 'ארץ', 'מדינה', 'מלחמה', 'ישראל', 'יהודים', 'וינה', 'משפחה', 'אוסטריה',
                                   'עולם', 'בחירות', 'ישראלית', 'נשים', 'יהודי', 'דעה', 'סיפור', 'גרמניה', 'שנים',
                                   'ערבים', 'רוצים']
    ConversationTopics_Topic124 = ['זתומרת', 'חתולים', 'בית', 'דברים', 'עניין', 'חתול', 'להוציא', 'בעיות', 'לתת',
                                   'לקחת', 'הולכת', 'להכנס', 'לעשות', 'תראי', 'בלגן', 'מתפקדת', 'אמנות', 'כלבים',
                                   'אופן', 'להכניס']
    ConversationTopics_Topic125 = ['קרה', 'קורה', 'זמן', 'רגע', 'חשבתי', 'יקרה', 'אמת', 'להבין', 'הולך', 'מקרה',
                                   'פעמים', 'לקרות', 'ראש', 'הבנתי', 'עובר', 'מחשבה', 'לחשוב', 'סדר', 'מחשבות', 'לום']
    ConversationTopics_Topic126 = ['טיול', 'לנסוע', 'לחו', 'מלון', 'נוסעים', 'ארץ', 'נסיעה', 'נסעתי', 'ימים', 'נוסע',
                                   'יורק', 'שנה', 'לטייל', 'טיסה', 'טיולים', 'נסענו', 'אסע', 'נוסעת', 'לטוס', 'חופש']
    ConversationTopics_Topic127 = ['לכתוב', 'כתבתי', 'כותבת', 'מכתב', 'כתב', 'כתוב', 'כותב', 'כתבה', 'ספר', 'רשמתי',
                                   'עשיתי', 'לרשום', 'קיבלתי', 'סיפור', 'יומן', 'להוציא', 'כתיבה', 'רושמת', 'מייל',
                                   'מילים']
    ConversationTopics_Topic128 = ['בית', 'חולים', 'יום', 'ללכת', 'מצב', 'הולך', 'בעל', 'אבות', 'כנסת', 'בתים', 'הכנסת',
                                   'נתנו', 'הולכים', 'אלך', 'גדלתי', 'אבא', 'כיסא', 'מגיע', 'דברים', 'עדין']
    ConversationTopics_Topic129 = ['אמרתי', 'אומרת', 'רוצה', 'יודעת', 'באה', 'תעשי', 'תגידי', 'תשמעי', 'תראי', 'אמא',
                                   'בואי', 'תקשיבי', 'שאת', 'קטע', 'להגיד', 'תבואי', 'בעיה', 'סדר', 'הולכת', 'תלכי']
    ConversationTopics_Topic130 = ['שנים', 'שנה', 'אחרונות', 'שנתיים', 'עבד', 'פעמים', 'זמן', 'אורך', 'נשאר', 'התחיל',
                                   'עבר', 'ראיתי', 'חשבתי', 'אדם', 'תקופות', 'ראש', 'הלך', 'דברים', 'עברו', 'הגיע']
    ConversationTopics_Topic131 = ['בוכה', 'לבכות', 'בכיתי', 'אימא', 'בכי', 'בכה', 'דמעות', 'רואה', 'קרה', 'בכתה',
                                   'רגישה', 'ישבתי', 'חדר', 'הצליח', 'כאב', 'כואב', 'היסטריה', 'סיבה', 'שומעת', 'יום']
    ConversationTopics_Topic132 = ['ציון', 'טאק', 'תעודת', 'טקס', 'קיבלתי', 'הצטיינות', 'מצטיין', 'טיק', 'לקבל',
                                   'ציונים', 'טופס', 'זהות', 'נכה', 'תעודה', 'קיבלה', 'מודע', 'מקבלים', 'הוראה', 'למלא',
                                   'תעודות']
    ConversationTopics_Topic133 = ['בעיה', 'לדבר', 'רוצה', 'נושא', 'בעיות', 'מעניין', 'לפתור', 'לום', 'עניין', 'אמת',
                                   'אומרת', 'סיפור', 'מתחיל', 'פיתרון', 'שביל', 'נגמר', 'להעלות', 'פסיכולוג', 'אדבר',
                                   'מדברת']
    ConversationTopics_Topic134 = ['משקל', 'ספורט', 'קילו', 'לאכול', 'עליתי', 'דיאטה', 'ירדתי', 'לרדת', 'לעלות', 'רזה',
                                   'אוכלת', 'התחלתי', 'לשמור', 'בריא', 'שמנה', 'הפסקתי', 'מדרגות', 'עשיתי', 'יורדת',
                                   'ניתוח']
    ConversationTopics_Topic135 = ['חשבונות', 'עשיתי', 'שולחן', 'הנהלת', 'להעביר', 'תביא', 'מסר', 'עזר', 'טירוף', 'כנס',
                                   'סעיף', 'העברתי', 'סחורה', 'נמשך', 'חשבון', 'עבודה', 'תוכנות', 'נייר', 'לעבור',
                                   'כפתור']
    ConversationTopics_Topic136 = ['יודע', 'חושב', 'אומר', 'מרגיש', 'נקרא', 'להגיד', 'נגיד', 'מכיר', 'מקום', 'קשור',
                                   'בוא', 'עולם', 'להסביר', 'זוכר', 'שואל', 'בטוח', 'רמה', 'תשמע', 'מסתכל', 'אוהב']
    ConversationTopics_Topic137 = ['דלת', 'לפתוח', 'פתח', 'פתוח', 'חלון', 'נכנס', 'מפתח', 'פתחתי', 'פנים', 'סגרתי',
                                   'פותח', 'קטן', 'גדול', 'לסגור', 'אוויר', 'עושים', 'עירייה', 'אורות', 'נפתח', 'אונס']
    ConversationTopics_Topic138 = ['סדר', 'פסח', 'ליל', 'גמור', 'חול', 'עושים', 'הנחה', 'לקחת', 'הסדר', 'יומיים',
                                   'יוצא', 'בלאגן', 'מועד', 'חוברות', 'משנה', 'זכור', 'חמץ', 'קיצר', 'מעצבנת', 'אופן']
    ConversationTopics_Topic139 = ['גיל', 'צבא', 'שנים', 'צעיר', 'קורס', 'שנות', 'אהבתי', 'התבגרות', 'זוכר', 'השתחררתי',
                                   'צעירים', 'חיל', 'חבר', 'טירונות', 'רמה', 'צעירה', 'פנסיה', 'בני', 'גילאים', 'עולם']
    ConversationTopics_Topic140 = ['לעשן', 'סמים', 'מעשנת', 'סיגריות', 'ריח', 'אלכוהול', 'עשן', 'הפסקתי', 'מעשן',
                                   'מעשנים', 'שירותים', 'עישנתי', 'סיגריה', 'שותה', 'פאה', 'מפריע', 'לשתות', 'יוצאת',
                                   'להפסיק', 'תעשה']
    ConversationTopics_Topic141 = ['קבוצה', 'אנשים', 'קבוצות', 'חברה', 'קבוצת', 'קוראים', 'שפע', 'גדולה', 'חברתית',
                                   'אחרים', 'מסגרת', 'פעילות', 'אמרו', 'איתם', 'להיפתח', 'מסגרות', 'חברים', 'סגור',
                                   'משותף', 'שייך']
    ConversationTopics_Topic142 = ['עשיתי', 'הלכתי', 'אמרתי', 'יצאתי', 'יום', 'עבודה', 'הליכה', 'שעה', 'ישבתי', 'חזרתי',
                                   'ללכת', 'הגעתי', 'לעשות', 'יצא', 'סופר', 'ראיתי', 'לכת', 'רגל', 'דקות', 'באתי']
    ConversationTopics_Topic143 = ['בעיות', 'ריכוז', 'קשב', 'בעיה', 'אישיות', 'צרות', 'נפשיות', 'אומרת', 'קשיים',
                                   'הפרעות', 'עין', 'ריטלין', 'מוח', 'זיכרון', 'אבחון', 'מפריע', 'הפרעת', 'אחרות',
                                   'פרעות', 'פיצול']
    ConversationTopics_Topic144 = ['חדר', 'מיטה', 'בית', 'סלון', 'דלת', 'ספה', 'מטבח', 'שולחן', 'יושבת', 'שינה',
                                   'זוכרת', 'נוח', 'קטן', 'אמבטיה', 'לשים', 'באה', 'טלוויזיה', 'ישבתי', 'פינה', 'נכנס']
    ConversationTopics_Topic145 = ['יום', 'שבוע', 'חופש', 'שבת', 'עבודה', 'יומיים', 'סדר', 'בוקר', 'ימים', 'לעשות',
                                   'ערב', 'אמרתי', 'לחזור', 'בית', 'ישי', 'יוצא', 'אמצע', 'עבר', 'עובדת', 'עבדתי']
    ConversationTopics_Topic146 = ['אופן', 'חושב', 'מקום', 'אומרת', 'סוג', 'עניין', 'כללי', 'פעמים', 'אמת', 'מובן',
                                   'אישי', 'הבנה', 'נגיד', 'ברור', 'רמה', 'סיטואציות', 'הקשר', 'טבעי', 'רבה', 'רגשי']
    ConversationTopics_Topic147 = ['יודעת', 'מפחדת', 'חושבת', 'זמן', 'דברים', 'עניין', 'נראה', 'מפחיד', 'חיים', 'בטוחה',
                                   'עולה', 'ראה', 'נאדם', 'מלחיץ', 'יקרה', 'מתכוונת', 'מרגיע', 'לברוח', 'מכוערת',
                                   'חרדות']
    ConversationTopics_Topic148 = ['זוכרת', 'יודעת', 'לספר', 'סיפרתי', 'סיפור', 'חושבת', 'לדבר', 'להגיד', 'דברים',
                                   'רציתי', 'אמרתי', 'קרה', 'חשבתי', 'דיברנו', 'עניין', 'ידעתי', 'מספרת', 'התחלתי',
                                   'דיברתי', 'הרגשתי']
    ConversationTopics_Topic149 = ['כיתה', 'מורה', 'תלמידים', 'ילדים', 'מורים', 'כיתות', 'תיכון', 'שנה', 'ילד', 'חינוך',
                                   'שיעור', 'תלמיד', 'טובה', 'ללמד', 'תלמידה', 'מחנכת', 'ספר', 'שיעורים', 'הוראה',
                                   'מורות']
    ConversationTopics_Topic150 = ['פחד', 'מפחיד', 'פוחדת', 'פחדים', 'מפחד', 'פחדתי', 'חרדות', 'מפחדת', 'להיכנס', 'אדם',
                                   'בטוח', 'לפחד', 'חרדה', 'חששות', 'חשש', 'מחשבות', 'לאבד', 'תוקפנות', 'דחייה', 'עברו']
    ConversationTopics_Topic151 = ['הודעה', 'כתבתי', 'שלחתי', 'כתבה', 'מייל', 'יום', 'לשלוח', 'פייסבוק', 'שלח', 'כתב',
                                   'הודעות', 'שלחה', 'שולח', 'בוקר', 'כותב', 'אשלח', 'שולחת', 'מחכה', 'דיברנו', 'חתי']
    ConversationTopics_Topic152 = ['זמן', 'כיף', 'רגע', 'חיים', 'שקט', 'לעשות', 'לצאת', 'נהנה', 'אוהב', 'שלב', 'לראות',
                                   'ליהנות', 'לנו', 'קטע', 'משעמם', 'למדתי', 'נותן', 'נהניתי', 'לחיות', 'הנות']
    ConversationTopics_Topic153 = ['צורה', 'הבנתי', 'התנהגות', 'זאתי', 'רואה', 'משנה', 'שונה', 'להתנהג', 'סדר', 'פרצוף',
                                   'דפוס', 'תנועה', 'מראה', 'פועל', 'מתנהגת', 'שטויות', 'מתנהג', 'חזקה', 'יתרתי',
                                   'מילים']
    ConversationTopics_Topic154 = ['בית', 'לנקות', 'מנקה', 'זמן', 'נקי', 'דברים', 'נגיד', 'לסדר', 'מסודר', 'ניקיון',
                                   'לעשות', 'עושה', 'בלאגן', 'מרפסת', 'אמא', 'ניקיתי', 'עשיתי', 'מסדרת', 'סדר', 'ניקה']
    ConversationTopics_Topic155 = ['רוצה', 'צורך', 'חיים', 'קורבן', 'סביבה', 'לרצות', 'עניין', 'רצון', 'טובה', 'תלות',
                                   'מקום', 'עושה', 'עצמאית', 'לוותר', 'מנסה', 'טענות', 'אכזבה', 'תלויה', 'מצפון',
                                   'עצמאות']
    ConversationTopics_Topic156 = ['יחסים', 'מערכת', 'מערכות', 'אנשים', 'טובים', 'לנו', 'מילה', 'חוויה', 'רצון',
                                   'ערכות', 'שכל', 'חתכתי', 'להפעיל', 'ערכת', 'אינטרסים', 'קרובים', 'בחור', 'לחתוך',
                                   'מפעילה', 'גיליתי']
    ConversationTopics_Topic157 = ['סיפור', 'הלך', 'בחור', 'סיפר', 'לקח', 'ילד', 'סיפרתי', 'קיבל', 'הגיע', 'חבר', 'חזר',
                                   'דיבר', 'חור', 'עזב', 'קיצור', 'שלו', 'גדול', 'התחיל', 'משנה', 'ניסה']
    ConversationTopics_Topic158 = ['יודעת', 'חושבת', 'מרגישה', 'אומרת', 'מדברת', 'דברים', 'מבינה', 'להגיד', 'רואה',
                                   'שאת', 'עושה', 'הרגיש', 'מקבלת', 'לדבר', 'בטוחה', 'טובה', 'עניין', 'שואלת', 'יושבת',
                                   'הולכת']
    ConversationTopics_Topic159 = ['חושבת', 'נחמד', 'יתי', 'אנשים', 'מניחה', 'נחמדה', 'סוג', 'שהיתי', 'הרגשה', 'עובדה',
                                   'אמת', 'אוהבת', 'ענין', 'עולם', 'מוצאת', 'יורת', 'היתי', 'הניח', 'אינ', 'מושג']
    ConversationTopics_Topic160 = ['חוג', 'מלא', 'דברים', 'עושים', 'ציור', 'התחלה', 'עושה', 'שונה', 'לעשות', 'אוטומט',
                                   'סדנה', 'לחוג', 'עיצוב', 'מעצב', 'הפך', 'מציג', 'חוגים', 'מתאימה', 'כפיים', 'תנועות']
    ConversationTopics_Topic161 = ['רופא', 'חולים', 'בדיקות', 'רופאה', 'תור', 'קופת', 'בית', 'לעשות', 'שיניים', 'ללכת',
                                   'בדיקה', 'תרופות', 'רופאים', 'הלכתי', 'אמרה', 'פרטי', 'מצב', 'דיאליזה', 'מיון',
                                   'אמרו']
    ConversationTopics_Topic162 = ['דברים', 'לעשות', 'כוחות', 'עושה', 'נותן', 'להכניס', 'כוח', 'מודע', 'אחרים', 'לקחת',
                                   'לשנות', 'נתן', 'בחרתי', 'מנסה', 'אומץ', 'להתמודד', 'שלם', 'מצב', 'שינוי', 'להצליח']
    ConversationTopics_Topic163 = ['שיחה', 'לדבר', 'דברים', 'שיחות', 'פעולה', 'לשתף', 'להגיד', 'דיברנו', 'מדברים',
                                   'דיברתי', 'איתם', 'קורה', 'מדבר', 'לספר', 'דיבור', 'אמת', 'נושא', 'שיתוף', 'נדבר',
                                   'משתפת']
    ConversationTopics_Topic164 = ['שיעור', 'עניין', 'שיעורים', 'לימודים', 'קורס', 'חומר', 'ללמוד', 'מעניין', 'מורה',
                                   'הרצאה', 'נושא', 'לשבת', 'שעה', 'תחום', 'עבודות', 'אוניברסיטה', 'ישבתי', 'אחרון',
                                   'כיתה', 'מרצה']
    ConversationTopics_Topic165 = ['מטר', 'מטרה', 'לרוץ', 'אמצע', 'הגעתי', 'מרחק', 'מטרות', 'רחוב', 'יעד', 'רחוק',
                                   'נתניה', 'להגיע', 'קילומטר', 'רצתי', 'חוף', 'ריצה', 'שלט', 'תאילנד', 'אביב', 'מדהים']
    ConversationTopics_Topic166 = ['ניתוח', 'בטן', 'כואב', 'כאבים', 'רגל', 'כאב', 'גוף', 'כיסא', 'גלגלים', 'כאבי',
                                   'רופא', 'דלקת', 'שבר', 'ללכת', 'רגליים', 'ימים', 'חזה', 'פיזיותרפיה', 'לזוז', 'מכה']
    ConversationTopics_Topic167 = ['דירה', 'בית', 'לעבור', 'לגור', 'דירות', 'קומה', 'שנים', 'בניין', 'גור', 'גרה',
                                   'גרים', 'עברתי', 'שנה', 'גרתי', 'זוג', 'אביב', 'חדרים', 'עברנו', 'הולך', 'שכר']
    ConversationTopics_Topic168 = ['יעשה', 'לעשות', 'רוצה', 'יבוא', 'יגיד', 'דוחה', 'לקחת', 'יילך', 'יגידו', 'מגעיל',
                                   'ייתן', 'איתן', 'ברירה', 'ייקח', 'לדחות', 'ירצה', 'תעשו', 'ייצא', 'יונתן', 'דחה']
    ConversationTopics_Topic169 = ['חולה', 'מחלה', 'סרטן', 'חולים', 'חלה', 'מצב', 'נפש', 'אשפוז', 'חום', 'מיטה',
                                   'מחלות', 'אדם', 'טיפול', 'פסיכולוג', 'לטפל', 'פסיכיאטר', 'בריא', 'טיפולים', 'רופאים',
                                   'קוראים']
    ConversationTopics_Topic170 = ['תפקיד', 'צוות', 'ראש', 'רמה', 'מנהל', 'להתקדם', 'מנהלת', 'אחריות', 'תפקידים',
                                   'להביא', 'ארגון', 'תחום', 'מחלקה', 'רוצים', 'חדש', 'מערכת', 'אגף', 'לנהל', 'משימות',
                                   'סמכות']
    ConversationTopics_Topic171 = ['לשנות', 'אחוז', 'התנהגות', 'גישה', 'צורה', 'אגיד', 'מצב', 'סיבה', 'חשיבה', 'סיבות',
                                   'חיובי', 'טובה', 'בחירה', 'חרא', 'הפוך', 'שלילית', 'צורת', 'אחרים', 'דעת', 'מציק']
    ConversationTopics_Topic172 = ['מילים', 'מילה', 'אנגלית', 'שפה', 'עברית', 'לדבר', 'אומרת', 'קוראים', 'אומרים',
                                   'מדברים', 'מדבר', 'צרפתית', 'אחרות', 'דיבור', 'גרמנית', 'לתרגם', 'טון', 'מדברת',
                                   'ארץ', 'שפת']
    ConversationTopics_Topic173 = ['לקחת', 'כדורים', 'אחריות', 'לקחתי', 'כדור', 'לוקחת', 'תרופות', 'לוקח', 'התחלתי',
                                   'דברים', 'תרופה', 'מינון', 'לוואי', 'תופעות', 'להחליף', 'שנים', 'זריקה', 'גורם',
                                   'להתמודד', 'פסיכיאטר']
    ConversationTopics_Topic174 = ['שבת', 'יום', 'ערב', 'בית', 'ארוחת', 'בוקר', 'צהרים', 'לבוא', 'לשבת', 'צהריים',
                                   'באים', 'ילדים', 'לאכול', 'הורים', 'מוצאי', 'כיף', 'הולכים', 'עושים', 'ארוחה', 'שעה']
    ConversationTopics_Topic175 = ['מצטער', 'מבטיח', 'ציפה', 'תלונות', 'קיבל', 'עניינים', 'תיאוריה', 'לסגור', 'קיצון',
                                   'מאמין', 'באת', 'עקום', 'מסוים', 'מחובר', 'נגעתי', 'הבאתי', 'כעס', 'לראות', 'להצטער',
                                   'מטפס']
    ConversationTopics_Topic176 = ['אחי', 'אחותי', 'אמא', 'גדולה', 'קטן', 'קטנה', 'גיסתי', 'גדול', 'אחים', 'זאתי',
                                   'אחיינים', 'קטנים', 'יצא', 'ילדים', 'גדולים', 'אחות', 'עשתה', 'חתונה', 'אחיינית',
                                   'גיל']
    ConversationTopics_Topic177 = ['כלים', 'כביסה', 'מטבח', 'עושה', 'מכונת', 'מים', 'מקלחת', 'לשטוף', 'כיור', 'כלי',
                                   'מכונות', 'לכבס', 'מדיח', 'ידיים', 'בגדים', 'מכונה', 'להשתמש', 'שוטף', 'ארגז',
                                   'כביסות']
    ConversationTopics_Topic178 = ['עבודה', 'לעבוד', 'לעשות', 'עבודות', 'למצוא', 'עובד', 'עובדת', 'מקום', 'יום', 'לחץ',
                                   'לבוא', 'מסגרת', 'טובה', 'כסף', 'לחפש', 'לימודים', 'זאתי', 'חדשה', 'ללכת', 'ראש']
    ConversationTopics_Topic179 = ['הורים', 'ילדים', 'יודעים', 'עשו', 'בית', 'חברים', 'באו', 'משפחה', 'באים', 'איתם',
                                   'ידעו', 'הלכו', 'לנו', 'רצו', 'הביאו', 'גדול', 'הגיעו', 'לקחו', 'משפחות', 'קרה']
    ConversationTopics_Topic180 = ['אומר', 'יודע', 'מגיע', 'הולך', 'עושה', 'חוזר', 'עבודה', 'מצליח', 'קורה', 'יושב',
                                   'חושב', 'עייף', 'לוקח', 'עובד', 'נכנס', 'מדבר', 'זמן', 'רגיל', 'יוצא', 'מתחיל']
    ConversationTopics_Topic181 = ['עניין', 'תאומרת', 'חושב', 'אגיד', 'זאתי', 'יודע', 'קטע', 'מבינה', 'אדם', 'בחורה',
                                   'בעיה', 'מעניין', 'מדבר', 'ליווי', 'אוקיי', 'בחורות', 'דוגמה', 'חורה', 'להגיד',
                                   'חיים']
    ConversationTopics_Topic182 = ['אבא', 'אמא', 'הורים', 'בית', 'שלי', 'שלו', 'קטע', 'חיים', 'ילד', 'אחותי', 'נפטר',
                                   'ראה', 'חדר', 'לראות', 'קיבלתי', 'אחי', 'נתן', 'ריב', 'פעמים', 'עזב']
    ConversationTopics_Topic183 = ['סופר', 'שורה', 'עגלה', 'מסקנה', 'תחתונה', 'הגעתי', 'נכים', 'שלמה', 'מגיעה', 'הגענו',
                                   'אנשים', 'נכה', 'לוי', 'אישה', 'אמצע', 'קיבל', 'קופה', 'פקודות', 'שורות', 'בשורה']
    ConversationTopics_Topic184 = ['עובדת', 'סוציאלית', 'אמרה', 'אומרת', 'משרד', 'לקבל', 'תראי', 'קוראים', 'עובדות',
                                   'אמרו', 'עובד', 'שיקום', 'בריאות', 'מוגן', 'דיור', 'מצב', 'עובדים', 'מנהלת', 'נותנת',
                                   'מוסד']
    ConversationTopics_Topic185 = ['אירוע', 'חתונה', 'אירועים', 'מסיבת', 'מסיבה', 'פורים', 'להזמין', 'רווקות', 'מסיבות',
                                   'משנה', 'מזמינים', 'דוד', 'הזמינו', 'שמחתי', 'זוכר', 'הגיעה', 'משתתפים', 'חתונות',
                                   'מארגנת', 'סיום']
    ConversationTopics_Topic186 = ['ברור', 'רגע', 'נגיד', 'נראה', 'שאלה', 'אוקי', 'יוצר', 'פועל', 'מושלם', 'ספק',
                                   'התחלה', 'אמרת', 'עמדה', 'הכל', 'לחשוב', 'בסיס', 'מקום', 'אוקיי', 'מדובר', 'ברורים']
    ConversationTopics_Topic187 = ['משפחה', 'אמא', 'דודה', 'ילדים', 'אחותי', 'דודים', 'אחים', 'סבתא', 'הורים', 'בני',
                                   'דוד', 'אחיות', 'אחות', 'בנות', 'גדולה', 'נכדים', 'קשר', 'אבא', 'אשתו', 'סבא']
    ConversationTopics_Topic188 = ['כוח', 'זמן', 'דורש', 'לעשות', 'מאמץ', 'עובד', 'אדם', 'להשקיע', 'כוחות', 'אנרגיה',
                                   'להתחיל', 'אנרגיות', 'פיזי', 'מעייף', 'רוצה', 'חדש', 'קושי', 'מתסכל', 'מוטיבציה',
                                   'להיכנס']
    ConversationTopics_Topic189 = ['להגיד', 'רוצה', 'לבוא', 'תגיד', 'אומר', 'אגיד', 'תבוא', 'רגע', 'בעיה', 'בוא',
                                   'יגיד', 'יבוא', 'סדר', 'באה', 'מצפה', 'משנה', 'לתת', 'אוקיי', 'אבוא', 'תגידי']
    ConversationTopics_Topic190 = ['רציתי', 'אמרתי', 'באתי', 'חשבתי', 'לבוא', 'להגיד', 'ברית', 'הגיע', 'אמת', 'להגיע',
                                   'עשיתי', 'התחלה', 'ראש', 'לראות', 'יבוא', 'ארצות', 'שכחתי', 'יכלתי', 'שאלתי', 'הביא']
    ConversationTopics_Topic191 = ['אוטו', 'אוטובוס', 'נוסעת', 'לנסוע', 'נסעתי', 'בית', 'יום', 'לקחת', 'אביב', 'נוסע',
                                   'רכבת', 'לילה', 'אמרתי', 'רכב', 'תחנה', 'בוקר', 'באה', 'נסיעה', 'מונית', 'אוטובוסים']
    ConversationTopics_Topic192 = ['אומר', 'יודע', 'אוהב', 'אדם', 'חושב', 'מרגיש', 'הולך', 'רואה', 'ראש', 'חבר', 'נותן',
                                   'ראה', 'מדבר', 'עובד', 'נמצא', 'עובר', 'מקום', 'תחום', 'מחפש', 'עושה']
    ConversationTopics_Topic193 = ['רוצה', 'לעשות', 'דברים', 'רוצים', 'להגיד', 'נניח', 'ללכת', 'עניין', 'מעניין', 'לתת',
                                   'לשמוע', 'מבינה', 'יעשה', 'לדעת', 'לשנות', 'נעשה', 'לחשוב', 'לבוא', 'רעיון', 'נושא']
    ConversationTopics_Topic194 = ['אנשים', 'עושים', 'אומרים', 'רוצים', 'יודעים', 'אחרים', 'רואים', 'חושבים', 'דברים',
                                   'יגידו', 'באים', 'אדם', 'משנה', 'מגיעים', 'חיים', 'מבינים', 'עובדים', 'אומר',
                                   'הולכים', 'נותנים']
    ConversationTopics_Topic195 = ['בית', 'ספר', 'ילדים', 'כיתה', 'הורים', 'מורה', 'תיכון', 'בתי', 'שיעורי', 'תלמידים',
                                   'חברים', 'ילדה', 'רוצים', 'יסודי', 'חינוך', 'טובים', 'לימודים', 'מנהל', 'ילדות',
                                   'שיעורים']
    ConversationTopics_Topic196 = ['לקרוא', 'ספר', 'ספרים', 'קראתי', 'קוראת', 'קורא', 'מעניין', 'עיתון', 'קוראים',
                                   'אקרא', 'מאמר', 'קראו', 'זמן', 'נחמד', 'ספריה', 'כתוב', 'ישבתי', 'ספרות', 'מאמרים',
                                   'יושב']
    ConversationTopics_Topic197 = ['אדם', 'בוא', 'דואג', 'צרכים', 'אחראי', 'להבין', 'לתת', 'סיכון', 'מכיר', 'טובה',
                                   'עצה', 'שביל', 'אישיות', 'ממנו', 'ניסיון', 'יקבל', 'סופו', 'מתאימים', 'שומר', 'סכנה']
    ConversationTopics_Topic198 = ['תמונה', 'תמונות', 'פייסבוק', 'עשיתי', 'אדום', 'ציור', 'אמת', 'ציורים', 'לצלם',
                                   'צילומים', 'צייר', 'בפייסבוק', 'מציירת', 'לצייר', 'ראיתי', 'צילמתי', 'הסתכלתי',
                                   'דיסק', 'קעקוע', 'אמיתי']
    ConversationTopics_Topic199 = ['להרגיש', 'אדם', 'אנשים', 'גורם', 'אמיתי', 'ערך', 'סיבה', 'עולם', 'אחרים', 'נורמאלי',
                                   'סובלת', 'אומרת', 'שונאת', 'צורה', 'הכל', 'מסכנה', 'מעשה', 'בושה', 'לגרום', 'זכות']
    DataDrivenSupervised_WellBeing_Clinical = ['אבל', 'יודע', 'אז', 'אני', 'כזה', 'כאילו', 'שאני', 'משהו', 'זה', 'כן',
                                               'הזה', 'נגיד', 'איזה', '<NUM>', 'לי', 'הייתי', 'אמ', 'אתה', 'יכול',
                                               'כבר']
    DataDrivenSupervised_WellBeing_NonClinical = ['<PUNC>', 'את', 'היא', 'הוא', 'יודעת', 'XXX', 'לו', 'לה', 'באמת',
                                                  'עם', 'אמרתי', 'אה', 'ו', 'אותה', 'גם', 'שלו', 'על', 'והיא', 'תמיד',
                                                  'הייתה']
    DepressiveCharacteristics_But = ['אבל']
    DepressiveCharacteristics_Cursing = ['לעזאזל', 'שיט', 'חרא', 'בחרא', 'זבל', 'הזבל']
    DepressiveCharacteristics_Direct = ['נמאס', 'קשה', 'כואב', 'כעס', 'עצוב', 'בדיכאון', 'אשמה', 'בוכה', 'בעיה',
                                        'התעצבנתי', 'להעליב', 'מצטערת', 'פחד', 'לחץ', 'בעיות', 'מפחדת', 'שקשה', 'הפחד',
                                        'מפחד', 'קשים', 'מלחיץ', 'מבאס', 'פוחדת', 'מתסכל', 'מטריד', 'דואגת', 'מפריע',
                                        'לחוצה']
    DepressiveCharacteristics_I = ['אני', 'כשאני', 'ואני', 'לכשאני', 'שאני', 'ושאני', 'וכשאני', 'שכשאני', 'לאאני',
                                   'האני', 'אניאני', 'כןאני', 'זהאני', 'אאני', 'אנילא', 'אממאני', 'באני', 'וואני',
                                   'ששאני', 'לאני', 'יודעתאני', 'אבלאני', 'כאילואני', 'נכוןאני', 'אומרתאני', 'אניכאילו',
                                   'אזאני', 'ליאני', 'משאני', 'שליאני', 'אניזה', 'לךאני', 'כאני', 'זהואני', 'להיותאני',
                                   'אניXXX', 'אניXXX', 'שםאני', 'באמתאני', 'בסדראני', 'מהאני', 'יודעאני', 'כיאני',
                                   'אוקייאני', 'טובאני', 'הזהאני', 'כבראני', 'פשוטאני', 'פעםאני', 'כזהאני', 'אניכן',
                                   'שאניאני', 'שהאני', 'אניאת', 'אהאני', 'אניאבל', 'פהאני', 'עכשיואני', 'להאני',
                                   'שאנילא', 'היאאני', 'חושבתאני', 'אניצריכה', 'והאני', 'זאתאני', 'לעשותאני', 'רוצהאני',
                                   'משהוואני', 'אנינגיד', 'ואנילא', 'אםאני', 'הואאני', 'קשהאני', 'שאתהאני', 'מזהאני',
                                   'עושהאני', 'שזהאני', 'אחדאני', 'רואהאני', 'קשראני', 'כלוםאני', 'שאניזה', 'כןכןאני',
                                   'אניחושב', 'תראיאני', 'שלאני', 'גםאני', 'כןואני', 'אניחושבת', 'אניזאת']
    DepressiveCharacteristics_Indecision = ['מצד', 'ומצד', 'אפשרות', 'אופציה', 'בחירה']
    DepressiveCharacteristics_Knowing = ['מבין', 'לדעת', 'יודע', 'יודעת', 'מבינה', 'ידעתי']
    DepressiveCharacteristics_Meaning = ['חיים', 'החיים', 'לחיות', 'מחשבות']
    DepressiveCharacteristics_Negation = ['לא', 'אין', 'אי', 'ולא', 'שלא', 'אל', 'ואין']
    DepressiveCharacteristics_NonFluenciesAhEm = ['אהה', 'אממ', 'מממ', 'אה', 'אההה', 'אמ', 'ממ']
    DepressiveCharacteristics_NonFluenciesLike = ['כאילו', 'וכאילו', 'שכאילו', 'עכשיו']
    DepressiveCharacteristics_OK = ['אוקיי']
    DepressiveCharacteristics_Tentativeness = ['כנראה', 'אולי', 'יתכן', 'נראה']
    DepressiveCharacteristics_Total = ['אף', 'שאף', 'כולם', 'כל', 'לגמרי', 'המון', 'ממש', 'מאוד', 'בהחלט', 'באמת',
                                       'ובאמת', 'מוחלטת', 'נורא', 'הנורא']
    DepressiveCharacteristics_UnknownWord = ['XXX', 'xxx', 'XX', 'XXXX', 'XXXXX', 'מXXX', 'מהXXX', 'XXXזה', 'לאXXX']
    EmotionalVariety_Amused = ['צחקוק', 'חחח', 'מרנין', 'סקרנות', 'נהנות', 'מבדרת', 'פרחים', 'בדוח', 'נהננו', 'משמח',
                               'פורח', 'שיעשע', 'חיוך', 'מצחיק', 'נהנים', 'נהנה', 'גיחוך', 'שמחה', 'שימח', 'חזק',
                               'מבודרים', 'משועשע', 'צחוקים', 'צחיקה', 'מבדר', 'מבדח', 'מצחקק', 'נקרעתי', 'בצחוק',
                               'חמה', 'מרשים', 'לצחוק', 'משועשעת', 'נעים', 'מחייכת', 'הצחיק', 'קומי', 'כיפי', 'נהנת',
                               'צוחקים', 'קומדיה', 'מבדחים', 'נהנו', 'מהנה', 'מחייך', 'אביב', 'שעשוע', 'טוב', 'בידור',
                               'מפתיע', 'וואו', 'צחקנו', 'רוח-שטות', 'קורע', 'מבודחים', 'בשמחה', 'מצחקקת', 'הצחקת',
                               'לשחק', 'נהדרת', 'לגלות', 'לחייך', 'פריחה', 'מבדחת', 'מבודח', 'הרגת', 'מצחיקה', 'נחמד',
                               'הרשים', 'משעשע', 'ענק', 'נהנתי', 'הנאה', 'חח', 'הצחקתי', 'צחוק', 'חחחח', 'מבדחות',
                               'מבודרות', 'נפלא', 'מבודר', 'טובים', 'מסקרן', 'צחקתי', 'התבדחות', 'כיף', 'כייפי',
                               'חינני', 'נהנית', 'מבודחת']
    EmotionalVariety_Anger = ['להרוס', 'שנאה', 'השתוללו', 'התחממו', 'רותחות', 'כח', 'כאב', 'מדבר', 'תסכול', 'ארחם',
                              'אגרוף', 'מטנף', '"גננה"', 'מתסכל', 'עצב', 'משחרר', 'חם', 'רוגזה', 'מתעצבנת', 'לחץ',
                              'נסערים', 'פגע', 'רותחים', 'מסנגר', 'זועף', 'רוגזת', 'מתרעם', 'התסכול', 'הזדעם',
                              'התקוממות', 'זועמת', 'חום', 'סובל', 'זעם', 'השתולל', 'לצעוק', 'מבסוט', 'הרגיז', 'מתחרט',
                              'תרעומת', 'מצייץ', 'נגד', 'קריזה', 'כועסות', 'חרא', 'התחממה', 'סומך', 'מתמרמר', 'חוזק',
                              'כעסים', 'נכשלו', 'כעוסה', 'לכעוס', 'עלבון', 'טרק', 'זועמות', 'עיצבן', 'צחק', 'רגז',
                              'חזק', 'טרקתי', 'פגיעה', 'מצטער', 'מצקצק', 'התעצבנתי', 'טינף', 'רוטן', 'מרגיז', 'קריזות',
                              'בערה', 'סבל', 'לעצבן', 'זעפו', 'אלים', 'תחשוב', 'עצבנית', 'מתעצבן', 'צועק', 'השתוללה',
                              'עצבני', 'הכעיסה', 'מהר', 'מתנפל', 'נזעמה', 'זעף', 'חמה', 'מתפלא', 'נרגזות', 'רגזה',
                              'שיט', 'חלסטרה', 'כעסתי', 'שמפריע', 'וכועס', 'הבלאגן', 'כועסת', 'תוקף', 'חרוןאף', 'וצועק',
                              'חרון', 'איום', 'להוציא', 'מרחם', 'שליטה', 'מלכלכך', 'מריר', 'תקיף', 'דיכאון', 'מתבאס',
                              'טנטרום', 'מוגזם', 'לזעום', 'אימפולסיבי', 'בכי', 'מוותר', 'כואב', 'מעצבנת', 'צרחה',
                              'ויכוח', 'מגחך', 'כעסה', 'זעמו', 'מקטר', 'ייאוש', 'מרתיח', 'מלכלך', 'תעצור', 'מלגלג',
                              'התעצבנה', 'ליכלך', 'כעס', 'חורפה', 'לקנטר', 'קשה', 'העצבים', 'מיאוס', 'סבלנות', 'רגזן',
                              'מתבדח', 'עצבנות', 'קצף', 'שונא', 'מעצבנים', 'מתרפק', 'ריב', 'קוצררוח', 'זעפה', 'כועסים',
                              'קצפו', 'מחרבן', 'לעזאזל', 'עוצמה', 'התעצבן', 'סטירה', 'זועמים', 'מעוצבן', 'נרגז',
                              'להכעיס', 'מעצבן', 'תקצפנה', 'רותח', 'מפחיד', 'עלבונות', 'רותחת', 'נזעם', 'צעקות',
                              'התרעמו', 'נסערות', 'מתוסכלת', 'רוגז', 'מתרגש', 'קריז', 'מסתכל', 'מרירות', 'מקומם',
                              'הכעיסו', 'נפגענו', 'צועקת', 'מגונן', 'מטריף', 'עצבים', 'אטום', 'מאיים', 'ריבים', 'אדום',
                              'נמאס', 'טינה', 'התחמם', 'האשמה', 'מתח', 'ממורמר', 'אומץ', 'כועס', 'אפס', 'כעוס', 'מתעלק',
                              'נעלב', 'מתנצל', 'קונפליקט', 'רתיחה', 'נסערת', 'התרתח', 'אכעס', 'שחרור', 'תיעוב', 'יתנפל',
                              'מסתלבט', 'מלחיץ', 'לחתוך', 'ציער', 'מחרפן', 'ישיר', 'נמאסו', 'כוח', 'אף', 'בער', 'הכעיס',
                              'אלימות', 'זועם', 'כישלון', 'להתעצבן', 'מתרגז', 'צעקה', 'מכעיס', 'לשנוא', 'נסער',
                              'מאויים', 'מתבכיין', 'מכות', 'מתלונן', 'מתאבל']
    EmotionalVariety_Anticipation = ['אהיה', 'אופציה', 'אחשוב', 'אכפת', 'אמור', 'אמצא', 'אסתדר', 'אפילו', 'ארגיש',
                                     'אשנה', 'באוויר', 'באים', 'בבית', 'ביקשתי', 'בעתיד', 'בקשה', 'גדול', 'הזדמנות',
                                     'הזמן', 'היכן', 'הכי', 'הכנה לקראת...', 'הכנה מראש', 'הלוואי', 'המתנה ל...',
                                     'הסוף', 'הרצון', 'השפעה', 'השתוקקות', 'התפלל', 'התפללה', 'חולם', 'חולמות',
                                     'חולמים', 'חולמת', 'חושב', 'חושבת', 'חיכינו', 'חיכיתי', 'חיכתה', 'חלום', 'חלמתי',
                                     'חמדה', 'חפץ', 'חפצה', 'חפצנו', 'חפצתי', 'חרדה', 'חשבתי', 'חשק', 'חשקה', 'יאללה',
                                     'יבוא', 'יבוא', 'יהיה', 'יחל', 'יחלה', 'כמה', 'כמהה', 'כמיהה', 'כשאני', 'לגלות',
                                     'להוכיח', 'להיות', 'להמציא', 'להסתדר', 'להשיג', 'להשתנות', 'לחוות', 'לחכות',
                                     'למצוא', 'לצפות', 'לקוות', 'לקראת', 'לשנותחוויה', 'לשפר', 'מאוד', 'מבקש', 'מבקשת',
                                     'מזל', 'מחדש', 'מחכה', 'מחכות', 'מחכים', 'מחשבה על העתיד', 'מטרה', 'מייחל',
                                     'מייחלת', 'מלחיץ', 'ממש', 'מעוניין', 'מעוניינת', 'מעניין', 'מפלל', 'מצליח',
                                     'מצליחה', 'מצפה', 'מצפות', 'מצפים', 'מקווה', 'מקווים', 'מקוות', 'משנה', 'משפיע',
                                     'משתוקק', 'משתוקקת', 'מת', 'מתחיל', 'מתחילה', 'מתחשק', 'מתכוונת', 'מתלהב', 'מתעכב',
                                     'מתפללים', 'נו', 'נצפה', 'נקווה', 'נרגש', 'עוד מעט...', 'עיכוב', 'עניין', 'ערגה',
                                     'פוטנציאל', 'פילל', 'פיללתי', 'צופה', 'צופן', 'ציפייה', 'ציפינו', 'ציפיתי',
                                     'צפייה על העתיד', 'קיווה', 'קיוותה', 'רוצה', 'רצה', 'רצון', 'רצינו', 'רציתי',
                                     'רצתה', 'שהוא', 'שהיא', 'שהם', 'שינוי', 'תאווה', 'תקווה', 'תשוקה']
    EmotionalVariety_Anxiety = ['קשוב', 'מחריד', 'מסתייג', 'חרדתי', 'חוששים', 'מזדעזע', 'כאב', 'פרנויה', 'בחרדה',
                                'מודאגת', 'שבר', 'תסכול', 'מבועתים', 'נופלת', 'בלבול', 'מתסכל', 'מושפע', 'מזיע',
                                'משתוקק', 'עצב', 'לחוצים', 'בריאות', 'בעת', 'לחץ', 'נכלם', 'רועדים', 'טלטלה', 'פוחדות',
                                'חשד', 'טראומה', 'מובך', 'מטורפת', 'נלחץ', 'מבועתת', 'פחדים', 'התדרדרות', 'מטלטל',
                                'תהום', 'רעדה', 'סובל', 'חששנות', 'בורחת', 'חיל', 'איפה?', 'בדידות', 'חרד', 'בודד',
                                'דאג', 'נזהר', 'דואגת', 'חשש', 'משויך', 'פחדתי', 'רגישות', 'לארגוע', 'בעיה', 'פחדנות',
                                'בעיות', 'יראה', 'מחכה', 'קורס', 'רועדות', 'מיואש', 'דאבה', 'חרדתיות', 'מוטרד', 'מתמיד',
                                'מכשול', 'פוחדים', 'מלחיצה', 'מחלה', 'חרדה', 'לחוצה', 'מזועזע', 'מצפה', 'מפחדת', 'נגעל',
                                'הסטרס', 'סבל', 'מייחל', 'עצוב', 'די', 'מקפיא', 'הורס', 'צועק', 'מבולבלים', 'התבלבל',
                                'לאנודע', 'לחוץ', 'מתחלחל', 'מתמודדים', 'חוסרודאות', 'נלחצתי', 'מבועתות', 'פוחד',
                                'דוגר', 'משוגעת', 'פוביה', 'פאניקה', 'מדאיג', 'פחד', 'חולה', 'דאגנות', 'מבוהלת', 'איום',
                                'דיכאון', 'מאוכזב', 'מפחדות', 'זקוק', 'דאגתנות', 'מצוקה', 'בכי', 'משוגע', 'חוסרריכוז',
                                'משותק', 'נאנח', 'שחרד', 'רעש', 'הפחד', 'פיקברכיים', 'רתיעה', 'דואג', 'נרתעות', 'קשיים',
                                'חושש', 'כעס', 'מבועת', 'לחרדה', 'מורא', 'מופתע', 'משתלט', 'מתנגד', 'יושב', 'נחרדת',
                                'לאידוע', 'התלבטות', 'מחויב', 'מערער', 'חולשה', 'מבואס', 'חלחלה', 'מורכב', 'אחראי',
                                'תיאבון', 'מנהל', 'אומללות', 'עמוק', 'מודאג', 'נפש', 'וואי', 'סלחן', 'חרדות', 'אימה',
                                'בהלה', 'זיעה', 'מבלבל', 'חוששת', 'דאגה', 'התבלבלו', 'הרס', 'עירור', 'תחרות', 'התקף',
                                'חוששות', 'וחרד', 'בראש', 'מפחיד', 'נלחצת', 'סטרס', 'מעיק', 'מייחלת', 'שחור', 'מבוהלים',
                                'משתק', 'פניקה', 'לדאוג', 'ביעות', 'לחוצות', 'מתרגש', 'התבלבלה', 'נדהם', 'פחדן',
                                'מחוייב', 'חרדנות', 'מתרשם', 'מבולבלת', 'מפחדים', 'מבוהל', 'הבהלות', 'תהומות', 'הנאה',
                                'חרדני', 'מבולבל', 'נרתע', 'מבולבלות', 'מתח', 'נרתעים', 'מתכחש', 'החשש', 'לחשוש',
                                'נעלב', 'נאנחת', 'מפחד', 'מבועס', 'לנשום', 'נבוך', 'חוזר', 'פלצות', 'נשימות', 'בז',
                                'פוחדת', 'העקה', 'טרור', 'חששות', 'קושי', 'תשישות', 'היסטריה', 'מציק', 'מלחיץ',
                                'נפגעתי', 'החושש', 'מגויס', 'צמא', 'אולי', 'הנשמה', 'מפריע', 'נחרד', 'נרתעת', 'המתח',
                                'סובלני', 'נלחצה', 'דאגתי', 'סובלת', 'בלהה', 'חרדנית', 'כישלון', 'מתוסכל', 'חיוור',
                                'דאגנו', 'מועקה', 'לפחד', 'במצוקה']
    EmotionalVariety_Ashamed = ['מסתיר', 'מפדח', 'התבזו', 'בזיון', 'הובך', 'שבר', 'בזה', 'נבוכה', 'מבוזה', 'כשלון',
                                'מביש', 'מתפדחת', 'בושות', 'משפיל', 'שפל', 'נכשל', 'נכלם', 'לצערי', 'התכנסו', 'זועף',
                                'מובך', 'לאטוב', 'מחפיר', 'אדמומיות', 'מבסוט', 'לאמנסה', 'נזהר', 'פדיחה', 'רדום',
                                'מושפלת', 'פאדיחות', 'חרא', 'מהופנט', 'נפלו', 'ביזוי', 'בעיות', 'עלבון', 'פאתטי',
                                'מוזר', 'מתמוגג', 'פאדחן', 'מיואש', 'מבוכה', 'מצטער', 'מוטרד', 'מבוישים', 'בזוי',
                                'מזועזע', 'אשמה', 'הזוי', 'התעצבו', 'מגוכך', 'נגעל', 'ספקן', 'עצוב', 'התבזה', 'שתק',
                                'התחבאות', 'מתבייש', 'ביישנית', 'מתפדח', 'חריג', 'מתפלץ', 'הובכה', 'מבוישת', 'כלום',
                                'מבויש', 'התקלס', 'אותקין', 'פאתטית', 'מתביישות', 'טעיתי', 'מבוייש', 'מביכים',
                                'התפאדחתי', 'ביזיון', 'עליבות', 'מתבזים', 'קלון', 'חשדן', 'גמגום', 'קטן', 'שותק',
                                'התביישתי', 'מאוכזב', 'מבייש', 'מסונוור', 'פאדחני', 'רציני', 'מופנם', 'התבזתה', 'עולב',
                                'סגור', 'פאדיחה', 'בושה', 'מתביישים', 'אשם', 'אכזבה', 'לברוח', 'מופנמים', 'מושפל',
                                'כשל', 'מופתע', 'מצפון', 'דריכה', 'בכתה', 'שקטים', 'שבור', 'לארוצה', 'חולשה', 'מבואס',
                                'מובכת', 'התכנסה', 'אחראי', 'מסוחרר', 'מחבוא', 'מודאג', 'ברחתי', 'המום', 'מצטערת',
                                'בישן', 'בושההה', 'להסתתר', 'מתביישת', 'נלוז', 'לאנעים', 'צעקות', 'נפעם', 'לאיכול',
                                'מביישים', 'מוקטן', 'לא', 'נדהם', 'שותקים', 'להיכשל', 'בושת', 'ספק', 'מגוכחת', 'נפל',
                                'כלימה', 'הובכתי', 'אדום', 'מבוהל', 'מבולבל', 'מביך', 'פנים', 'התעצבה', 'ביישן', 'נשבר',
                                'שקט', 'בוש', 'מתבזה', 'נעלב', 'כעוס', 'אפס', 'מעליב', 'נבוך', 'חרפה', 'סליחה',
                                'מבויישת', 'שתיקה', 'טינופת', 'נכשלתי', 'נחרד', 'מצטמרר', 'מאשים', 'הפנמה', 'מרוגש',
                                'מדוכדך', 'מתוסכל', 'נכלמת', 'מתאמץ', 'נסער', 'מבזה', 'מביכה', 'זחוח']
    EmotionalVariety_Calm = ['מושלם', 'אחלה', 'סבבה', 'זן', 'יציבה', 'בית', 'נינוח', 'קשוח', 'תשוש', 'רוגע', 'הירגעות',
                             'נינוחים', 'שוכב', 'רגוע', 'משחררת', 'משחרר', 'ניחותא', 'מסודר', 'רגועה', 'שכוך', 'ששש',
                             'מדיטציה', 'סטלה', 'פרודקטיבי', 'אדיש', 'נוחות', 'רוחני', 'נייטרלי', 'משוחררת', 'שלוות',
                             'יושן', 'מאולחש', 'לאט', 'סבלני', 'סומך', 'איזון', 'רועש', 'טבע', 'איטי', 'דביק', 'מנוחה',
                             'אור', 'אוכל', 'יוגה', 'נחת', 'יפים', 'קול', 'ישנוני', 'שאיפה', 'שקטות', 'בוגר', 'מאוזן',
                             'רילקסין', 'מחוייך', 'עצבני', 'לחוץ', 'להשתחרר', 'שלווה', 'נינוחה', 'בנוח', 'חופש',
                             'שלמות', 'קיצי', 'ריכוז', 'מנומנם', 'שלוו', 'חדגוני', 'ורגוע', 'זולה', 'משוחרר', 'חושב',
                             'נינוחות', 'נעים', 'עיף', 'מסטול', 'ישבתי', 'משוגע', 'שלוים', 'כיפי', 'נועם', 'חלש',
                             'נעימים', 'פניות', 'סבלנות', 'שקטים', 'יושב', 'רגועות', 'מקשיב', 'יפה', 'עירני', 'נרגע',
                             'טוב', 'שממה', 'חשוך', 'לנוח', 'קללל', 'שליו', 'סימפטי', 'נוח', 'אידילי', 'נקי', 'נשימה',
                             'אופוריה', 'רילקס', 'קודר', 'מגניב', 'חשך', 'מרגוע', 'דממה', 'שקטה', 'זורם', 'טיול',
                             'לשחרר', 'מרגיע', 'שלו', 'בריא', 'חופשי', 'שלום', 'סופ"ש', 'נחמד', 'עייף', 'מיטה',
                             '"בציל"', 'מואר', 'אופטימי', 'מחויך', 'מוזיקה', 'הנאה', 'מבולבל', '"ציל"', 'ניתוק',
                             'שוקולד', 'מוצלח', 'תרגע', 'מתוח', 'שינה', 'פרודוקטיבי', 'שקט', 'תפילה', 'רגיעה', 'שבת',
                             'ערני', 'עגמומי', 'מרוכז', 'שלוה', 'שאננות', 'להסתדר', 'מאושר', 'גשום', 'נרגעתי', 'רגועים',
                             'פסטורלי', 'רווחה', 'יושנים', 'קל', 'מרוגש', 'מדוכדך', 'שאנן', 'שכבתי', 'הרגעה', 'קריר']
    EmotionalVariety_Confusion = ['אבוד', 'אבלבל', 'אה', 'או', 'אובד עצות', 'אולי', 'אחר', 'אחרת', 'אי הבנה',
                                  'איבד את הדרך', 'איבד את הכיוון', 'איזשהו', 'איך', 'איפה', 'אלא', 'אמ', 'אמביוולנטי',
                                  'אמור', 'אממ', 'בודקת', 'בילבל', 'בילבלה', 'בלאגן', 'בלבול', 'בלבלנו', 'בלבלת',
                                  'בלבלתי', 'בלגן', 'בסימן שאלה', 'בספק', 'בעיה', 'בעצם', 'בערך', 'הזוי', 'הזויה',
                                  'הזייה', 'היסוס', 'הממ', 'הפוך', 'השאלה', 'השתנה', 'התבלבל', 'התבלבלה', 'התבלבלנו',
                                  'התבלבלתי', 'התלבטות', 'ו...', 'ואיך', 'וואו', 'וואי', 'וכאילו', 'וכאלה', 'ולפעמים',
                                  'ומה', 'זר', 'חוסר', 'חוסר ביטחון', 'חוסר היגיון', 'חוסר וודאות', 'חוסר פרספקטיבה',
                                  'חסר אונים', 'חסר כיוון', 'חצוי', 'טעות', 'יבלבל', 'יוצא דופן', 'כאילו', 'כאלה',
                                  'כביכול', 'כזה', 'כמו', 'כנראה', 'לא בטוח', 'לא בנוח', 'לא ברור', 'לא החלטי',
                                  'לא שפוי', 'לאדע', 'לאדעת', 'לבדוק', 'לבחון', 'לבחור', 'לבלבל', 'לברר', 'לדעתי',
                                  'להבין', 'להבין', 'להגיד', 'להתבלבל', 'להתייעץ', 'ללא מוצא', 'למה', 'למרות', 'לפעמים',
                                  'מאיפה', 'מאשר', 'מבוי סתום', 'מבולבל', 'מבולבלות', 'מבולבלים', 'מבולבלת', 'מבולגן',
                                  'מה', 'מהומה', 'מהורהר', 'מהסס', 'מוזר', 'מורכב', 'מחפש', 'מחפשת', 'מי', 'מלא ספק',
                                  'מלחיץ', 'ממ', 'מניח', 'מניחה', 'מנסה', 'מסוחרר', 'מסורבל', 'מסתחרר', 'מסתתחרר',
                                  'מעבר', 'מעורפל', 'מפליא', 'מפתיע', 'מצד', 'מציף', 'משהו', 'משתנה', 'מתהפך', 'מתי',
                                  'מתלבט', 'מתלבטת', 'מתנדנד', 'מתעתע', 'מתעתעת', 'מתפלא', 'נאנחת', 'נגיד', 'נניח',
                                  'סחרור', 'ספק', 'ספקן', 'סקפטי', 'עקום', 'עקומה', 'ערפול', 'ערפל', 'פזור דעת',
                                  'פליאה', 'פער', 'פקפוק', 'פשוט', 'פתאום', 'פתאומי', 'צקצוק', 'קונפליקט', 'ש...',
                                  'שאלה', 'שאלות', 'שואל', 'שוכחת', 'שינויים', 'שכאילו', 'שמה', 'תוהה', 'תוהו ובוהו',
                                  'תזוזה', 'תחשבי', 'תלוי', 'תלוי בין שמיים וארץ', 'תלויה', 'תעתוע', 'תקוע', 'תקיעות']
    EmotionalVariety_Contentment = ['מושלם', 'אחלה', 'סיפוק', 'סבבה', 'מאמין', 'בחירה', 'זן', 'אוהבת', 'רקידה', 'סיפק',
                                    'נינוח', 'תענוג', 'מרוצים', 'מדויק', 'רוגע', 'משמח', 'להשיג', 'הסכמה', 'יששש',
                                    'מבסוטה', 'מושפע', 'טובה', 'בטוח', 'כייף', 'אהבתי', 'תאמיני', 'חדווה', 'מבסוט',
                                    'מסיבה', 'התרשמתי', 'מצחיק', 'רדום', 'משוש', 'היכולות', 'נהנה', 'תצליח', 'ביטחון',
                                    'שמחה', 'משמעות', 'מלא', 'מנוחה', 'ודאות', 'שבע', 'מתאים', 'אה', 'מוקסמת',
                                    'שביעתרצון', 'משועשע', 'ממולא', 'אוהב', 'נחת', 'בשביעות', 'מרוצה', 'מאוזן', 'רצון',
                                    'די', 'וודאות', 'התרשם', 'רווי', 'מתרגשת', 'בול', 'לגמרי', 'ממלא', 'שלווה', 'חמה',
                                    'נינוחה', 'עליזות', 'מתלהב', 'משועשעת', 'שטוב', 'נעים', 'התלהב', 'לאזן', 'סגור',
                                    'שביעותרוח', 'מספיק', 'הישג', 'הסתפקות', 'לוודא', 'מסופק', 'עונג', 'הצליחו', 'גילה',
                                    'ישר', 'עשייה', 'מופתע', 'החלטה', 'שבערצון', 'הצליח', 'תצליחי', 'סיפקו', 'טוב',
                                    'מתפעל', 'רון', 'לספק', 'מלאה', 'התלהבתי', 'מסופקת', 'מתפעלת', 'נהדר', 'התלהבות',
                                    'סלחן', 'שליו', 'אושר', 'אופוריה', 'וודאי', 'שבעה', 'נחלה', 'החלטתי', 'מתקדמת',
                                    'מתרשמת', 'עלהכיפאק', 'שלם', 'מתרגש', 'מופתעת', 'בוודאות', 'נחתרוח', 'אופטימי',
                                    'שביעות', 'מתרשם', 'יתרגש', 'אופטימית', 'הנאה', 'שביעותרצון', 'מסופקים', 'שמח',
                                    'מתינות', 'שקט', 'מסופקות', 'הגיוני', 'הוקל', 'מרוצות', 'מספק', 'בשליטה', 'יש',
                                    'מעריך', 'דיצה', 'ששון', 'מבסוטית', 'מסוגל', 'שכך', 'הסתפק', 'גיל', 'נפלא', 'מאושר',
                                    'הקלה', 'מאושרת', 'מצוין', 'כיף', 'שהצלחתי', 'ריצוי', 'משמעותית', 'אמונה', 'הצלחה',
                                    'ספוק', 'נהנית', 'סיפקה', 'זחוח']
    EmotionalVariety_Disgust = ['אוי', 'איכס', 'איכסה', 'איף', 'בחיים', 'בחילה', 'בעע', 'בשום', "ג'יף", "ג'יפה", 'גועל',
                                'גועלי', 'גועלית', 'גרוע', 'גרועה', 'גרועות', 'גרועים', 'דבק', 'דוחה', 'דוחות', 'דוחים',
                                'דחייה', 'די', 'דיי', 'דפוק', 'דפוקה', 'דפוקות', 'דפוקים', 'האלה', 'הזאת', 'הזאתי',
                                'הזה', 'הזו', 'הסתיגות', 'התעלק', 'התעלקה', 'התקרצץ', 'התקרצצה', 'זבל', 'זבלונים',
                                'זבלים', 'זוועה', 'זועף', 'זועפות', 'זועפים', 'זועפת', 'זעוף', 'זעופות', 'זעופים',
                                'זעף', 'זעפתי', 'חופר', 'חופרות', 'חופרים', 'חופרת', 'חפר', 'חפרת', 'טירטור',
                                'טירטורים', 'טפיל', 'טרדה', 'טרדן', 'טרול', 'טרטור', 'טרטורים', 'יאק', 'לארצה', 'לברוח',
                                'לדחות', 'להימלט', 'להפסיק', 'להקיא', 'לזרוק', 'לכי', 'לסלוד', 'לעזוב', 'מאוס', 'מאמלל',
                                'מאמללות', 'מאמללים', 'מאמללת', 'מבולגן', 'מבחיל', 'מבחילה', 'מבחילים', 'מגעיל',
                                'מגעילה', 'מגעילות', 'מגעילים', 'מוזר', 'מזורגג', 'מזורגגות', 'מזורגגים', 'מזורגגת',
                                'מזעזע', 'מזעזעות', 'מזעזעים', 'מזעזעת', 'מחרפן', 'מחרפנות', 'מחרפנים', 'מחרפנת',
                                'מטרטר', 'מטרטרות', 'מטרטרים', 'מטרטרת', 'מטריד', 'מטרידה', 'מטרידות', 'מטרידים',
                                'מטריל', 'מין', 'מיני', 'מלוכלך', 'ממני', 'מספיק', 'מסריח', 'מסריחה', 'מסריחות',
                                'מסריחים', 'מקומם', 'מקוממות', 'מקוממים', 'מקוממת', 'מקיא', 'מרתיח', 'מרתיחה',
                                'מרתיחות', 'מרתיחים', 'משביז', 'משביזה', 'מתבייש', 'מתביישת', 'מתוסכל', 'מתסכל',
                                'מתסכלות', 'מתסכלים', 'מתסכלת', 'מתעב', 'מתעלק', 'מתעלקת', 'נגד', 'נגעל', 'נדבק',
                                'נדבקים', 'נדבקת', 'נודניק', 'נודניקים', 'נודניקית', 'נורא', 'נוראי', 'נוראית', 'נטפל',
                                'נטפלות', 'נטפלים', 'נטפלת', 'נמאס', 'נמאסת', 'נמאסתי', 'נמאסתם', 'סולד', 'סולדות',
                                'סולדים', 'סולדת', 'סירחון', 'סלדנו', 'סלדתי', 'סלידה', 'סרחה', 'סרחון', 'עדיין',
                                'עופי', 'עלוקה', 'פיכסה', 'צקצוק', 'קבס', "קרינג'י", 'קרציה', 'קשה', 'רע', 'רתיעה',
                                'שונא', 'שונאתת', 'תיעוב', 'תניח', 'תניחי', 'תסכול', 'תעוף', 'תעזבי', 'תעזוב']
    EmotionalVariety_Enthusiastic = ['מושלם', 'סבבה', 'משקיע', 'מושלמת', 'שיגעון', 'עילאי', 'רגשות', 'נדיר', 'שמחתי',
                                     'לקפוץ', 'מתרגשות', 'הוראיי', 'עליז', 'מטורפת', 'אהבתי', 'מושלםם', 'איןמצב',
                                     'ווהוו', 'מבסוט', 'התרשמתי', 'יהנה', 'נכבשה', 'יא', 'נהנה', 'הוטרפה', 'משולהב',
                                     'אההה', 'מחכה', 'שמחה', 'נכבש', 'השתגע', 'האנרגיות', 'משקיעה', 'יוהו', 'מפרגן',
                                     'אוהב', 'מאוד', 'קול', 'נלהבת', 'מצפה', 'מרוצה', 'בטירוף', 'הכי', 'היפעמות',
                                     'התרשם', 'מטורף', 'מתלהבת', 'מתרגשת', 'לגמרי', 'עילוי', 'גדול', 'דייי', 'מתרגשים',
                                     'מרשים', 'מתלהב', 'מלוהט', 'מהמםםם', 'דיי', 'בעננים', 'מהיר', 'מדהים', 'ככ',
                                     'וואוווווווו', 'כיפי', 'דיייי', 'מתלהבים', 'אנרגיה', 'נלהב', 'להינות', 'אהההה',
                                     'הוטרף', 'ואו', 'התרגשתי', 'ואוו', 'קוצררוח', 'מושלםםם', 'מתפעל', 'נרגש',
                                     'שיאהמטורף', 'יו', 'מקסימה', 'התלהבתי', 'התפעלתי', 'התלהבות', 'וואי', 'חוויה',
                                     'מהמם', 'יתרשם', 'אושר', 'מדהימה', 'יתלהב', 'מגניב', 'הוטרפו', 'זורם', 'ישש',
                                     'מתרגש', 'ענק', 'להוט', 'נרגשת', 'פנטסטי', 'אדיר', 'טירוף', 'מטריף', 'נהניתי',
                                     'יתרגש', 'מפרגנת', 'אקסטטי', 'שמח', 'ווואוווו', 'התפעל', 'התרגשות', 'הוקסם',
                                     'וואוו', 'יאיי', 'מהירות', 'שווה', 'השתגעו', 'השתגעה', 'מסתורי', 'מלהיב', 'מאושר',
                                     'מאושרת', 'התרגש', 'שיא', 'כיף', 'האנרגיה', 'אנרגטי', 'יאללה', 'צחק', 'מגניבבב',
                                     'התלהבה']
    EmotionalVariety_Fatigue = ['באפיסת כוחות', 'נרפה', 'אונים', 'אחרונה', 'איבדתי', 'איטי', 'אין כוח', 'אפוף', 'אפופה',
                                'אפופים', 'אפיסת כוחות', 'ארוך', 'במיטה', 'בקיצור', 'ברירה', 'בשפל', 'גמור', 'גמורה',
                                'די', 'דיכאון', 'דיכוי', 'הגיע לסף', 'החיים', 'הלאה', 'הפסקה', 'הפסקתי', 'הרוס',
                                'הרוסה', 'התיש', 'התישו', 'התעייף', 'התעייפה', 'התעייפו', 'התעייפיתי', 'התעצל',
                                'התעצלה', 'התרופפות', 'התשת', 'ותרנות', 'זהו', 'זקנה', 'חודשים', 'חולה', 'חולשה',
                                'חוסר', 'חוסר כוח', 'חוסר מסוגלות', 'חלש', 'חלשה', 'חסר', 'חסר אונים', 'חסר אנרגיה',
                                'חסר כוחות', 'חסר כוחות', 'חסרת כוחות', 'חצי ישן', 'חצי ישנה', 'טושטוש', 'יגע', 'יגעים',
                                'ישן', 'ישנה', 'ישנוני', 'ישנוניות', 'ישנונית', 'ישנות', 'ישנים', 'ישנתי', 'כבד',
                                'כבדות', 'כבוי', 'כדורים', 'כובד', 'כלוא', 'כלום', 'כנוע, נכנע, מוכנע', 'לאה', 'לאות',
                                'לאט', 'לבד', 'להירדם', 'להפסיק', 'להתיש', 'להתמודד', 'להתעייף', 'לוותר', 'לחץ',
                                'לישון', 'ללא מרץ', 'לנוח', 'לנסות', 'לסגור', 'לעצור', 'לשחרר', 'מאוחר', 'מבוגר',
                                'מבוגרת', 'מוות', 'מוותר', 'מוחלש', 'מוריד', 'מותש', 'מותשות', 'מותשים', 'מותשת',
                                'מטושטש', 'מטושטשת', 'מיוגע', 'מיוגעת', 'מכביד', 'מספיק', 'מפורק', 'מפורר', 'מרוקן',
                                'מרים ידיים', 'משביז', 'משועמם', 'משעמם', 'משתדלת', 'משתעלת', 'מת', 'מתה', 'מתמוטט',
                                'מתעפץ', 'מתעפצת', 'נאנח', 'נאנחת', 'נגמר', 'נגמרתי', 'נו', 'נומנום', 'נופל', 'נוקשה',
                                'נטול כוחות', 'נטול מרץ', 'ניסיתי', 'נמאס', 'נפילה', 'נראה', 'נרדם', 'נרדמה', 'נרדמתי',
                                'נשלט', 'נתמך', 'סדוק', 'סוף', 'סחוט', 'סחוט', 'סחוטה', 'סרחה', 'סתם', 'עבודה', 'עדיין',
                                'עומד', 'עומדת', 'עזבי', 'עזבתי', 'עזוב', 'עייף', 'עייפה', 'עייפות', 'עייפים', 'עייפתי',
                                'על פני תהום', 'עמוס', 'עפוץ', 'עצלות', 'עצלנות', 'פאסיביות', 'פושט יד', 'פסיבי',
                                'צריך', 'צריכה', 'קרוע', 'קרועה', 'קשה', 'רגע', 'רגשית', 'רדום', 'רדומה', 'רופף',
                                'רחוק', 'רפוי', 'רצוץ', 'רצוצה', 'רצינות יתר', 'שבוז', 'שבוזה', 'שבועות', 'שבור',
                                'שביר', 'שבק חיים', 'שבקתי חיים', 'שוב', 'שובר', 'שחוק', 'שחיקה', 'שינה', 'שמתי זין',
                                'שנים', 'שעות', 'שפוך', 'שפוכה', 'שקט', 'תעזבו', 'תעזוב', 'תקוע', 'תקופה', 'תשוש',
                                'תשושה', 'תשושות', 'תשושים', 'תשישות']
    EmotionalVariety_Guilty = ['עונש', 'תומך', 'מתחבא', 'מוסרי', 'פורעחוק', 'בגללך', 'כאב', 'עברין', 'מצדד', 'מאכזב',
                               'פושע', 'לאבסדר', 'יטפל', 'שגיאה', 'יואשם', 'עצב', 'להאשים', 'אשומים', 'חיבבדין',
                               'לצערי', 'יפגע', 'פגע', 'יורשע', 'מובך', 'התגונן', 'מורשע', 'סובל', 'קרימנל', 'מתחרט',
                               'פושעת', 'ילקה', 'אשמים', 'מוצף', 'טובח', 'נאשמת', 'בעיה', 'בעיות', 'מתגונן', 'מפקפק',
                               'זילזל', 'צער', 'מיואש', 'פגיעה', 'בגללו', 'מצטער', 'האשמתי', 'מוטרד', 'שמאשים', 'מכשול',
                               'עשה', 'צודק', 'נפשע', 'האשים', 'עליי', 'אשמה', 'לאנכון', 'האשימה', 'אצבע', 'עצוב',
                               'קרימינל', 'יתחשב', 'מתרברב', 'שקרן', 'תעזוב', 'נחשד', 'נפלתי', 'בגלל', 'באשמתי', 'יענש',
                               'יאשימו', 'טעה', 'טעיתי', 'מודה', 'פחד', 'קלון', 'מזלזל', 'קטן', 'שותק', 'מסתכן',
                               'וידוי', 'ישלוט', 'חוטא', 'נפגעת', 'מתעניין', 'גרם', 'יסתכן', 'בוחל', 'סגור', 'מאושם',
                               'בושה', 'אשם', 'מתחרטת', 'עוון', 'לברוח', 'מאושמים', 'כעס', 'מתעלל', 'כשל', 'קשה',
                               'מצפון', 'פושעים', 'יאשים', 'עוזב', 'הנאשם', 'אחראי', 'מחבוא', 'האשם', 'פשע', 'אישום',
                               'טועים', 'בגללי', 'שולט', 'שאשם', 'ישתוק', 'הורשע', 'הודאה', 'מתמהמה', 'הרס', 'מטפל',
                               'חשוד', 'להיתפס', 'מתביישת', 'מוטעה', 'לאנעים', 'מיוסר', 'רע', 'מתערב', 'בוגד', 'אחריות',
                               'גנב', 'שיקר', 'מודים', 'מואשם', 'ענישה', 'מוקטן', 'לפגוע', 'פשעתי', 'פוגע', 'להרשיע',
                               'לחובתי', 'משקר', 'פשעים', 'מטען', 'נפגע', 'חטאתי', 'עוול', 'נפל', 'מבוהל', 'שינוי',
                               'ייענש', 'מודות', 'חיב', 'חרטה', 'האשמה', 'הואשם', 'לאמוסרי', 'טועה', 'מואשמת', 'לפרוק',
                               'נבוך', 'מתעמר', 'מאשימה', 'חרפה', 'נפלה', 'דין', 'התחרטתי', 'נאשם', 'מזוכה', 'כשלתי',
                               'טעות', 'נאשמים', 'נכשלתי', 'עובר', 'בכוונה', 'מתקנא', 'אחריותי', 'בריחה', 'מאשים',
                               'מייסר', 'עברינות', 'הואשמתי', 'חייב', 'חטא', 'ישתלח']
    EmotionalVariety_Hostile = ['שנאה', 'כוחנית', 'מפגרת', 'עויינים', 'יריבות', 'פנימי', 'כח', 'מאיימת', 'תקיפה',
                                'הרסני', 'קשוח', 'אויבים', 'אלימים', 'כוחנות', 'שיפוטי', 'חד-צדדי', 'תקיפות', 'מביש',
                                'להתווכח', 'מתקיף', 'עוינות', 'ממסדי', 'יפגע', 'עצמאי', 'לאטוב', 'מתריסה', 'אויבות',
                                'דווקא', 'איבה', 'לדחות', 'מפגר', 'עויינת', 'קנאה', 'הרביץ', 'התרסה', 'רופס', 'יריב',
                                'ציניות', 'רועש', 'בעיות', 'פשיסטי', 'אנטגוניסטי', 'ברוטלי', 'מתריס', 'שמרני', 'חזק',
                                'מסכן', 'נמסיס', 'פגיעה', 'עוינת', 'קנאי', 'מגעיל', 'אנטישמי', 'בזוי', 'מרגיז',
                                'מסוכנת', 'מתנקל', 'פוגעני', 'חד', 'מסוכן', 'מותקף', 'אלים', 'הורס', 'חריג', 'כוחני',
                                'חמוץ', 'חתרני', 'מובהק', 'מלחמתי', 'צהוב', 'שופט', 'שופטת', 'גס', 'מתון', 'נקמני',
                                'מוטה', 'מנוכר', 'מרחיק', 'רב', 'תוקף', 'איום', 'מזניח', 'גברתני', 'תקיף', 'אויבת',
                                'דוקא', 'לשבור', 'מבאס', 'צוררת', 'להתעמת', 'להשתלט', 'ירוד', 'למנוע', 'אי-נעימות',
                                'אימפוטנטי', 'קללות', 'אלימה', 'בוטה', 'אגרסיבי', 'כעס', 'תוקפני', 'אכזרי', 'מאויימת',
                                'אויב', 'עול', 'צוררים', 'דחייה', 'רעה', 'שונא', 'ביקורתי', 'ריב', 'סכנה', 'מבואס',
                                'דבוב', 'רעים', 'אנטי-ישראלי', 'לעומתי', 'מיליטנטי', 'גזעני', 'קם', 'אבסורדי', 'ישירות',
                                'איימתי', 'מעצבן', 'תוקפנות', 'ציניקן', 'מפחיד', 'צורר', 'השליטה', 'לאנעים', 'רע',
                                'צרים', 'פייסני', 'הזנחה', 'לפגוע', 'פוגע', 'יריבה', 'מטעה', 'דיפלומטי', 'קיצוני',
                                'אוייב', 'עויינות', 'פטריוטי', 'פוגעים', 'מאיים', 'טינה', 'שולטת', 'ציני', 'קשות',
                                'עוין', 'עויין', 'קומוניסטי', 'שונאת', 'אסטרטגי', 'חשאי', 'לסכן', 'ממורמר', 'קילל',
                                'מעליב', 'הרבצתי', 'צוררות', 'שקרים', 'מופקר', 'הפגיעה', 'תיעוב', 'מאוים', 'מפוקפק',
                                'מציק', 'מגעילה', 'עוינים', 'להרע', 'פוגעת', 'צר', 'כוח', 'לריב', 'קיקיוני', 'אלימות',
                                'עוררות', 'בוטות', 'מכה']
    EmotionalVariety_Interested = ['קשוב', 'אחלה', 'סקרנות', 'אינטרסנטי', 'מרוכזת', 'תוהה', 'אכפת', 'ענייני', 'סקרניות',
                                   'לאידעתי', 'אכפתית', 'מיוחדים', 'התעניין', 'מצויין', 'מצוינת', 'בעניין', 'מגרה',
                                   'מוכנה', 'יאוו', 'מעורר', 'מהנהנת', 'מוכנות', 'משך', 'מתעניינות', 'יוצאמןהכלל',
                                   'אהבתי', 'רציתי', 'מרותק', 'התחברתי', 'מסקרנת', 'תרצה', 'ניסיונות', 'שוקל', 'מצחיק',
                                   'מתעניינים', 'הבנתי', 'שומע', 'מסוקרן', 'שוקלים', 'מיוחד', 'חיפוש', 'ביררתי',
                                   'מאמצים', 'ברצינות', 'מתעניינת', 'מקסים', 'נוכח', 'מעוניינים', 'התחשק', 'מעורבים',
                                   'מדליק', 'משועשע', 'עוד', 'ראוילציון', 'מרגש', 'חטטני', 'מבדר', 'רלוונטי', 'הזוי',
                                   'מייחד', 'מעורבות', 'מייחל', 'מענינת', 'רצון', 'טעים', 'ערך', 'מרותקת', 'מוכן',
                                   'מטורף', 'מושך', 'מתלהבת', 'מתעמק', 'לשמוע', 'בעלעניין', 'מאזין', 'אכפתיים', 'למדתי',
                                   'חדש', 'אטרקטיבי', 'חפץ', 'מופלא', 'משמעת', 'מעוניינת', 'מרשים', 'מתלהב', 'בקשה',
                                   'שיאוו', 'שואל', 'מעניין', 'מדהים', 'הסתקרן', 'תועלתני', 'חיכיתי', 'מתעניין', 'מרתק',
                                   'אינטרס', 'ערוך', 'מעוניין', 'קולטת', 'שונה', 'מהנה', 'להתעניין', 'התרגשתי',
                                   'מעונין', 'מקשיב', 'יפה', 'מתאמצת', 'טוב', 'מסתקרנת', 'מורכב', 'מקסימה', 'וואו',
                                   'מענין', 'תועלתי', 'רוצות', 'רותק', 'נהדר', 'מרותקים', 'ער', 'מוכנים', 'רואה',
                                   'חטטן', 'ענין', 'קונקרטי', 'מחפש', 'ירצו', 'מעניינים', 'מדהימה', 'מנסים', 'מרשימה',
                                   'מעורבת', 'שוקלת', 'חושבת', 'השקעה', 'מגניב', 'מידע', 'מפליא', 'ניסיון', 'מעורב',
                                   'מעולה', 'דייייי', 'משמעותי', 'נחמד', 'אבדוק', 'תעזור', 'וחשבתי', 'מסתכל', 'משעשע',
                                   'חשוב', 'סקרן', 'סיקרן', 'תכליתי', 'אדיר', 'לחקור', 'חושבים', 'אכפתי', 'במיוחד',
                                   'בסדר', 'לומד', 'מבקש', 'מעניינת', 'עיניין', 'מטריד', 'מסתקרן', 'משכיה', 'מחפשים',
                                   'לשאול', 'יודע', 'לרצות', 'מנסה', 'משונה', 'עניין', 'מיוחדבמינו', 'עורר', 'פרגמטי',
                                   'וואוו', 'הסתקרנתי', 'בלתירגיל', 'סקרנים', 'סקרנית', 'ירצה', 'שווה', 'אברר', 'מרוכז',
                                   'סיקרנת', 'רוצה', 'לדעת', 'מלהיב', 'מבודר', 'נפלא', 'סקרני', 'בעליעניין', 'יוצאדופן',
                                   'מסקרן', 'מצוין', 'עשיר', 'ואאי', 'התענינתי', 'כייפי', 'רוצים', 'מרוגש', 'מעוניינות',
                                   'למה?', 'בדקתי', 'התעניינתי', 'אכפתיות', 'הקשבה', 'וואלה', 'מסוקרנת']
    EmotionalVariety_Joy = [':)', 'אדיר', 'אהב', 'אהבה', 'אהבה', 'אהבתי', 'אוהב', 'אוהבות', 'אוהבים', 'אוהבת',
                            'אופטימיות', 'אור', 'אושר', 'אחגוג', 'אחושילינג', 'אחלה', 'אליפות', 'אש', 'אשש', 'אששש',
                            'בהיי', 'בעננים', 'ברכה', 'בשמיים', 'גדול', 'גדולה', 'גדולל', 'גיל', 'גילה', 'דיי', 'דייי',
                            'דיצה', 'הולך', 'הולכת', 'הופה', 'הוראיי', 'הכי', 'המון', 'הנאה', 'הצלחתי', 'הרבה', 'התלהב',
                            'התלהבה', 'התרוממות רוח', 'התרשמתי', 'ווהוו', 'ורוד', 'זוהר', 'זורח', 'ח', 'חבל על הזמן',
                            'חבלז', 'חבר', 'חברות', 'חגגנו', 'חגיגה', 'חדווה', 'חוגג', 'חוגגות', 'חוגגים', 'חוגגת',
                            'חופש', 'חזק', 'חח', 'חחח', 'חחחח', 'חיובי', 'חיוך', 'חלום', 'טוב', 'טובב', 'טובבב', 'טובה',
                            'טופ', 'יאא', 'יאיי', 'יופי', 'יוצא מן הכלל', 'יותר', 'יחגוג', 'יפה', 'יקרה', 'יש', 'ישש',
                            'כיף', 'כיף חיים', 'כיףףף', 'לאהוב', 'לגמרי', 'להיות', 'להיות בהיי', 'להיות בעננים',
                            'להתענג', 'ליגה', 'ללכת', 'לעשות', 'לקחת', 'מאוד', 'מאושר', 'מאושרות', 'מאושרים', 'מאושרת',
                            'מבסוט', 'מבסוטה', 'מדהים', 'מהמם', 'מהממת', 'מהנה', 'מושלם', 'מזל', 'מטורף', 'מטורףף',
                            'מטריף', 'מטריפה', 'מין', 'מיני', 'מלא', 'מלהיב', 'ממש', 'מסופק', 'מסיבה', 'מספק', 'מעולה',
                            'מעלף', 'מעלפת', 'מצחיק', 'מצחקקת', 'מצליח', 'מצליחה', 'מקסים', 'מקסימה', 'מקפיץ', 'מרומם',
                            'מרוצה', 'מרץ', 'מרשים', 'מרשימה', 'משגע', 'משגעת', 'משובה', 'משובח', 'משועשע', 'משעשע',
                            'מתנה', 'מתנות', 'מתענג', 'נאהב', 'נהדר', 'נהנה', 'נהנים', 'נהנת', 'נהנתי', 'נחגוג', 'נעים',
                            'נפלא', 'סבבה', 'סוףף', 'סיפוק', 'עוד', 'עונג', 'עוצר נשימה', 'על גג העולם', 'על הגג',
                            'עליזות', 'עליזות', 'עליצות', 'ענק', 'ענקית', 'עפתי', 'עשר', 'פגזז', 'פלא', 'פנומנלי',
                            'פנומנלית', 'צהלה', 'צוהל', 'צוחקות', 'צוחקת', 'צחוק', 'צחקתי', 'קול', 'קורן', 'קל', 'קליל',
                            'קסום', 'קסומה', 'רון', 'רוצההה', 'רינה', 'ריקודים', 'רענן', 'רצון', 'רקדנו', 'שיש', 'שמח',
                            'שמחה', 'שמחות', 'שמחים', 'שמחנו', 'שמחנו', 'שמחתי', 'שמחתינו', 'שמחתכם', 'שמחתכן', 'שמחתם',
                            'ששון', 'תאהבי', 'תחגוג', 'תענוג']
    EmotionalVariety_Nervous = ['עצלן', 'חרדתי', 'רועד', 'מנותק', 'שיגיע', 'להילחץ', 'נינוח', 'קשוח', 'בחרדה', 'ערער',
                                'בלבול', 'רגוע', 'מזיע', 'עצב', 'לחוצים', 'מחומם', 'עוינות', 'לחץ', 'תדאג', 'רועדים',
                                'באלגן', 'עצבן', 'מתוחה', 'בהול', 'זועף', 'טראומה', 'מובך', 'נבהלתי', 'מודאגים', 'זעם',
                                'חרד', 'פקעת', 'לבכות', 'רעד', 'פחדתי', 'בעיה', 'מלחיצים', 'מתוחים', 'רגזני', 'רועש',
                                'בעיות', 'צער', 'רגז', 'איטי', 'מיואש', 'מצטער', 'מוטרד', 'מעוצבנת', 'נוראי', 'במתח',
                                'שתוי', 'התעצבנתי', 'מלחיצה', 'נזעף', 'זעפן', 'חרדה', 'אווח', 'החוסר', 'לחוצה',
                                'עייפות', 'רתחני', 'טרוד', 'מפחדת', 'מרוצה', 'סבל', 'עצוב', 'מולחץ', 'רעב', 'עצבנית',
                                'אתגר', 'צועק', 'עצבני', 'לחוץ', 'מרוגז', 'טעון', 'פוחד', 'אווופ', 'דחוף', 'מנומנם',
                                'פאניקה', 'מתוחות', 'פראנואיד', 'פחד', 'מתיחות', 'הפחדים', 'כעסני', 'מאוכזב', 'עיף',
                                'מסטול', 'מצוקה', 'מרעיד', 'נדרך', 'כואב', 'מעצבנת', 'מותש', 'רעש', 'הפחד', 'שיכור',
                                'נדרכים', 'מתחים', 'מרתיח', 'חלש', 'חושש', 'נלחצות', 'כעס', 'קשה', 'רוטנת', 'מופתע',
                                'מתנגד', 'אוףף', 'מגחכת', 'רגזן', 'זעמן', 'עצבנות', 'לחצים', 'משועמם', 'עירני', 'חולשה',
                                'מבואס', 'נרגש', 'היסטרי', 'סיגריה', 'אוף', 'מודאג', 'נרגז', 'חרדות', 'מעוצבן', 'חוששת',
                                'דאגה', 'רתחן', 'מעצבן', 'רותח', 'מפחיד', 'סטרס', 'נזעם', 'מעיק', 'נווו', 'תזזיתי',
                                'לחוצות', 'מתרגש', 'עייף', 'רוגז', 'להוט', 'פוגע', 'צועקת', 'גרוע', 'זעוף', 'אמאלה',
                                'דרוכות', 'עצבים', 'קיפאון', 'מופרע', 'אטום', 'קפוץ', 'מבולבלת', 'מפחדים', 'מבוהל',
                                'מבולבל', 'לשאול', 'שיעבור', 'עוין', 'יואוו', 'מוטרדת', 'מפוחד', 'מתח', 'פסימי', 'מתוח',
                                'החשש', 'הלחיץ', 'זעום', 'ממורמר', 'מרגישה', 'פרודוקטיבי', 'תדאגי', 'כועס', 'כעוס',
                                'נדרכות', 'מפחד', 'מבועס', 'נבוך', 'מעורער', 'כעסן', 'חששות', 'מעפן', 'חששן', 'ערני',
                                'קושי', 'דרוך', 'חששתי', 'מציק', 'מלחיץ', 'נפגעתי', 'לאמאושר', 'רגוז', 'מפריע',
                                'דריכות', 'נלחצה', 'דאגתי', 'מתיש', 'זועם', 'כישלון', 'להתעצבן', 'הקושי', 'מדוכדך',
                                'מכעיס', 'מרוגש', 'דרוכים', 'מתוסכל', 'נלחצים', 'עיצבנו', 'נסער', 'אוופ', 'חטא', 'פצוץ',
                                'חתום']
    EmotionalVariety_NotAmused = ['משביז', 'מתאבלים', 'רציניות', 'אוך', 'משעמם', 'מאכזב', 'מתסכל', 'מדכא', 'עצב', 'אבל',
                                  'מחומם', 'קצרים', 'בהלם', 'זועף', 'בעיה', 'מרצין', 'רגזני', 'ברצינות', 'בעיות',
                                  'מבעס', 'מוזר', 'צער', 'רגז', 'מבהיל', 'השתעמם', 'מגעיל', 'נזעף', 'משמים', 'זעפן',
                                  'מרגיז', 'רתחני', 'סיבוך', 'חבל', 'עצוב', 'רצינית', 'חוסר', 'עצבני', 'התאבלה',
                                  'מיותר', 'מצוברח', 'מרוגז', 'קריפי', 'רציניים', 'שטויות', 'חסרהבעה', 'מבואסת',
                                  'כעסני', 'מקריפ', 'עצובה', 'טיפשי', 'רציני', 'בכי', 'חתומות', 'מבאס', 'מרתיח',
                                  'התאבלנו', 'דמעה', 'שלילית', 'רגזן', 'חסרהתלהבות', 'מייאש', 'גועל', 'מבואס', 'היסטרי',
                                  'זלזול', 'מסובך', 'חשוך', 'באסה', 'נרגז', 'אירוני', 'מעוצבן', 'בוכה', 'התאבל',
                                  'מעציב', 'רתחן', 'מעצבן', 'העציב', 'מעייף', 'קצר', 'מפחיד', 'נזעם', 'מעיק', 'מסתבך',
                                  'רוגז', 'משעשע', 'גרוע', 'זעוף', 'קפוץ', 'מביך', 'מתוח', 'זעום', 'סיוט', 'כעוס',
                                  'מעליב', 'מצער', 'כעסן', 'רצינות', 'מעפן', 'בכיתי', 'חסרמצברוח', 'בזבוז', 'מרוכז',
                                  'מלחיץ', 'רגוז', 'מחרפן', 'מתיש', 'זועם', 'מכעיס', 'לאמרשים', 'התאבלתי', 'חתום',
                                  'מזעזע']
    EmotionalVariety_NotAnger = ['מושלם', 'אחלה', 'סיפוק', 'סבבה', 'חכם', 'סולח', 'לעודד', 'נינוח', 'תענוג', 'רוגע',
                                 'משמח', 'רגוע', 'רינה', 'מושפע', 'מבסוטה', 'רגועה', 'הבנה', 'עליז', 'בהלם', 'מובך',
                                 'סלחני', 'לבביות', 'חדווה', 'משוחררת', 'מבסוט', 'התרשמתי', 'חיוך', 'מחלתי', 'מצחיק',
                                 'אינוכועס', 'אהבה', 'התאפקו', 'נהנה', 'רגישות', 'סבלני', 'מאפשר', 'מהופנט', 'איזון',
                                 'שמחה', 'סלחתי', 'הומור', 'התמוגגות', 'מתמוגג', 'שימח', 'חזק', 'מאופקות', 'מנוחה',
                                 'עדינות', 'משועשע', 'אוהב', 'מבין', 'נחת', 'סבבההה', 'מרוצה', 'מאוזן', 'מתפדח', 'קבלה',
                                 'צוחקות', 'שלווה', 'גדול', 'עליזות', 'מתלהב', 'אדישות', 'משוחרר', 'נעים', 'מסטול',
                                 'סלחנות', 'התלהב', 'עדן', 'מבינה', 'עונג', 'שלווים', 'גילה', 'להירגע', 'הרגיעה',
                                 'מתבונן', 'מפויס', 'מופתע', 'התאפק', 'קררוח', 'מחייך', 'עדנה', 'חמלה', 'חיובי', 'יפה',
                                 'מקשיב', 'צבעים', 'נרגע', 'טוב', 'מתפעל', 'רגועות', 'רון', 'שמחים', 'שעשוע', 'התלהבתי',
                                 'צהלה', 'מהמם', 'סלחן', 'יופי', 'שליו', 'אהבת', 'נוח', 'שולם', 'המום', 'סימפתיה',
                                 'אושר', 'מאופק', 'מחילה', 'צוחקת', 'שלו', 'מוחל', 'מעולה', 'מרגיע', 'נפעם', 'בריא',
                                 'שלום', 'נחמד', 'שלם', 'מתרגש', 'נרגעו', 'פתוח', 'הדדיות', 'בסדר', 'הרגיע', 'אנושיות',
                                 'מתרשם', 'יתרגש', 'נרגעה', 'הנאה', 'רחמים', 'מפוייס', 'גישור', 'מוצלח', 'שמח',
                                 'מפוייסת', 'מאופקת', 'שקט', 'מאשר', 'נעלב', 'צחוק', 'התאפקה', 'קרתרוח', 'אמון', 'דיצה',
                                 'רגיעה', 'קוררוח', 'ששון', 'מבסוטית', 'שכך', 'סליחה', 'מסתנוור', 'חוסן', 'חמוד',
                                 'שמחות', 'מאושר', 'נעימות', 'התרגש', 'נרגעתי', 'צוחק', 'רגועים', 'מאופקים', 'כיף',
                                 'מרוגש', 'יופיי', 'מתאמץ', 'חוכמה', 'הקשבה', 'אמפתיה', 'הרגעה']
    EmotionalVariety_NotAnticipation = ['אדיש', 'אדישה', 'אדישות', 'אדישים', 'אולי', 'אזמה (אז מה)', 'אין',
                                        'אין לי כוח', 'אכזבה', 'אמונה', 'אפאתי', 'אפטי', 'אפתי', 'אפתיה', 'אתבאס',
                                        'בבית', 'בלי', 'בסיסי', 'דומה', 'דפוס', 'הגיוני', 'היינו', 'הימנעות מהציפייה',
                                        'הנחתי', 'הסתם', 'הרגל', 'התאכזבנו', 'התאכזבת', 'התאכזבתי', 'התרגלתי', 'ושוב',
                                        'זהה', 'זומבי', 'חוסר עניין', 'חוסר ציפייה', 'חוסר תקווה', 'חזרתי', 'טבעי',
                                        'יבאס', 'יבש', 'ידוע', 'ידע', 'יהיה', 'יופי', 'כבר', 'כלום', 'כרגיל', "ל'משנה",
                                        'לא אכפת לי', 'לא מצפה', 'לא שם זין', 'לא שמה זין', 'לא שמים זין', 'לאכזב',
                                        'לאכזיב', 'לגיטימי', 'להחזיר', 'לפחות', 'מאוכזב', 'מאוכזבות', 'מאוכזבת',
                                        'מאליו', 'מגוחך', 'מגחך', 'מגכחת', 'מוכר', 'מזהה', 'מחשבה על ההווה', 'מי ישמע',
                                        'מכונס', 'מכיר', 'מכירה', 'מכירים', 'מנומנם', 'מרוחק', 'משעמם', 'נו', 'נורמאלי',
                                        'נתאכזב', 'נתבאס', 'סתם', 'סתמי', 'עבר', 'עד', 'עזבו אותי', 'עזבי אותי',
                                        'עזוב אותי', 'עמום', 'פחד מהציפייה', 'פחות', 'פעם', 'קבוע', 'קהות', 'רדידות',
                                        'רואה', 'ריקני', 'שאנן', 'שאננות', 'שבדרך', 'שגרה', 'שגרתי', 'שוב', 'שווה נפש',
                                        'תבאס', 'תמיד']
    EmotionalVariety_NotAnxiety = ['נורמלי', 'אחלה', 'סיפוק', 'יציבות', 'סבבה', 'זן', 'נינוח', 'שמחתי', 'רפוי', 'רוגע',
                                   'שוכב', 'רגוע', 'בטוחה', 'ידיעה', 'בריאות', 'ניחותא', 'חיוביות', 'מסודר', 'רגועה',
                                   'בטוח', 'הבנה', 'כייף', 'ממוקדים', 'עליז', 'שנטי', 'התמקד', 'תאמיני', 'אדיש',
                                   'משוחררת', 'מסיבה', 'לאלחוץ', 'חיוך', 'יושן', 'ביטחון', 'לאט', 'סומך', 'איזון',
                                   'שמחה', 'ממוקד', 'חזק', 'מנוחה', 'פשוט', 'מדליק', 'מבין', 'נחת', 'חביבה', 'מימנוחות',
                                   'חיובית', 'מאוזן', 'שגרה', 'קליל', 'בטוחים', 'נגינה', 'מוגן', 'שוחרשלום', 'שלווה',
                                   'נינוחה', 'גדול', 'חופש', 'בקלילות', 'ריכוז', 'מנוח', 'יציב', 'שלוו', 'משוחרר',
                                   'נינוחות', 'מדהים', 'נעים', 'סדר', 'ישבתי', 'ישינה', 'מחושב', 'התרכזה', 'מהנה',
                                   'מיושב', 'יושב', 'השקט', 'אביב', 'ממוקדות', 'חיובי', 'יפה', 'רגועות', 'נרגע', 'טוב',
                                   'נשען', 'ישן', 'חיוביים', 'נפש', 'נהדר', 'אינטנסיבי', 'חביב', 'קלילות', 'שליו',
                                   'נפישה', 'ממוקדת', 'נוח', 'אושר', 'שקול', 'לחייך', 'נשימה', 'ברור', 'מגניב', 'דומם',
                                   'הנפשות', 'שקטה', 'זורם', 'מעולה', 'שלו', 'מרגיע', 'בריא', 'חופשי', 'בטוחות',
                                   'זורמת', 'להרגיע', 'רופף', 'שפוי', 'נחמד', 'שלם', 'נושם', 'אדיר', 'נהנתי', 'נחמדה',
                                   'בסדר', 'הנאה', 'לסמוך', 'קלילה', 'מוצלח', 'שמח', 'הרמוניה', 'שקט', 'אמון', 'רגיעה',
                                   'התרגעות', 'שחרור', 'מרוכז', 'נפלא', 'ביטחוןעצמי', 'מאושר', 'הקלה', 'מצוין',
                                   'התרכזו', 'רגועים', 'רווחה', 'חברתי', 'קל', 'כיף', 'התרכז', 'אמונה', 'הצלחה',
                                   'שכבתי', 'הרגעה']
    EmotionalVariety_NotAshamed = ['נורמלי', 'כרגיל', 'השתבחות', 'זכיתי', 'פעיל', 'תומך', 'מתהדרת', 'נינוח', 'מדבר',
                                   'מדויק', 'גבוה', 'מפצירה', 'רגוע', 'חסרבושה', 'בטוחה', 'נועזים', 'חושק', 'לאמבייש',
                                   'יזם', 'רם', 'בטוח', 'התגאתי', 'גאים', 'איןעלי', 'מתנסה', 'בטח', 'מבסוט', 'העז',
                                   'חושקת', 'יהירים', 'החצנה', 'ביטחון', 'הטוב', 'התפארות', 'לאמתביישים', 'ארוגנטיות',
                                   'מצטיינת', 'גבהות', 'שמחה', 'חזק', 'דעתני', 'גאות', 'יהיר', 'גיבור', 'מצודד', 'קול',
                                   'מורם', 'מפקפקת', 'מרוצה', 'יוזמה', 'לשתף', 'מוחצן', 'בטוחים', 'שחצנות', 'התיהרות',
                                   'חברותי', 'דעתי', 'מתנשא', 'התהדרות', 'מעוניינת', 'בעד', 'השתחצנות', 'בטחון',
                                   'בוטחת', 'מדברים', 'מתכבד', 'מאוהב', 'מעיז', 'תומכת', 'מתעניין', 'שיתפתי',
                                   'היפראקטיב', 'התנשאות', 'הישג', 'ראשמורם', 'שלמה', 'יהירות', 'מחצין', 'מואהבת',
                                   'קשה', 'אתגאה', 'בוחר', 'דוגלת', 'טוב', 'חסרהבנה', 'נרגש', 'חסרמודעות', 'אעשה',
                                   'שופוני', 'אתחשב', 'בדוק', 'כריזמתי', 'חוצפה', 'אמת', 'נקי', 'נועז', 'מתגאה',
                                   'יזמות', 'יוזם', 'נכבד', 'זכאי', 'כבוד', 'חופשי', 'אתעניין', 'שלם', 'פתוח', 'דיבור',
                                   'סקרן', 'יהירה', 'התגאיתי', 'מחובר', 'ראש', 'מפציר', 'ראותנות', 'מאוהבבבבב', 'גאווה',
                                   'בעצמי', 'שהתברכה', 'התגאה', 'מוצלח', 'לדעתי', 'שמח', 'מתחיל', 'מכובד', 'החלטי',
                                   'עניין', 'זקוף', 'וגאה', 'סנוביות', 'מאוהבת', 'חוקר', 'שווה', 'רגיל', 'רהבתנות',
                                   'מעז', 'גאה', 'חוסן', 'מצליח', 'רוצה', 'ביטחוןעצמי', 'מאושר', 'יוהרה', 'מכבד',
                                   'צוחק', 'בקלות', 'מתחשבת', 'גאוותנות', 'מתהדר', 'העזתי', 'גאוותנית', 'מתרה', 'אמיץ',
                                   'גאוותן', 'מאוהבב', 'הצלחה', 'התגאות', 'אקטיבי', 'התרברבות', 'גאהההה', 'בחרתי',
                                   'גאההה', 'בטוחות', 'זחוח']
    EmotionalVariety_NotCalm = ['נלחמת', 'מסתייג', 'תזזיתיות', 'אימפולסיביות', 'מזדעזע', 'מנותק', 'צורחים', 'מודאגת',
                                'ואי', 'מתנער', 'בלבול', 'הפרעה', 'מתסכל', 'מושפע', 'מתחמק', 'היפראקטיבי', 'הסחות',
                                'לחוצים', 'חם', 'טרודה', 'מתעצבנת', 'צרח', 'לחץ', 'מוסחת', 'חלוה', 'מתוחה', 'בהלם',
                                'בהול', 'טראומה', 'מובך', 'נלחץ', 'צמוד', 'בלאגן', 'מבסוט', 'מרעיש', 'חרד', 'תפוס',
                                'נזהר', 'תזוזה', 'מבולגן', 'לארגוע', 'בעיה', 'מיהרתי', 'מתוחים', 'רועש', 'בעיות',
                                'מתגונן', 'מתמוגג', 'מיואש', 'מנוחה', 'ואייי', 'מוטרד', 'משועשע', 'מחלה', 'חרדה',
                                'מרגיז', 'עייפות', 'לחוצה', 'מזועזע', 'חסרמנוחה', 'נגעל', 'מודר', 'מרגיזים', 'התרשם',
                                'מטורף', 'מבחן', 'עומס', 'עצבנית', 'מתעצבן', 'זזתי', 'ממהר', 'מתחלחל', 'לחוץ', 'מהר',
                                'עצבני', 'מצוברח', 'מרוגז', 'זז', 'זזו', 'דחוף', 'שיט', 'אי-שקט', 'פאניקה', 'אוחח',
                                'כועסת', 'מדאיג', 'מעורערת', 'הסחה', 'פחד', 'דאגות', 'אטימות', 'נרעש', 'מאוכזב', 'יואו',
                                'בכי', 'משוגע', 'להתלונן', 'אינחת', 'רעש', 'עצבניים', 'אקשן', 'היפרקטיבי', 'חושש',
                                'כעס', 'מופתע', 'מאויימת', 'חסר', 'בלגן', 'נחרדת', 'סבלתי', 'עצבנות', 'מוסח', 'מערער',
                                'אכול', 'כועסים', 'מבואס', 'נרגש', 'תזיזיתי', 'לעזאזל', 'מודאג', 'נרגז', 'מעוצבן',
                                'בוכה', 'המום', 'תוסס', 'מעצבן', 'משגע', 'תחרות', 'קצר', 'רותח', 'רקדו', 'פקק', 'נלחצת',
                                'תזזיתי', 'לדאוג', 'נדהם', 'נרגשת', 'מעורפל', 'מייד', 'נרעשת', 'עצבים', 'מופרע',
                                'מטריד', 'מאיים', 'סערה', 'מבולבל', 'נרתע', 'מוטרדת', 'מתח', 'מתוח', 'ממורמר', 'מתעלם',
                                'סיוט', 'כועס', 'נעלב', 'לאנוח', 'מבועס', 'מפחד', 'נבוך', 'קופצני', 'מעורער', 'נסערת',
                                'רץ', 'תזיזיתית', 'דרוך', 'לאלעניין', 'בוכים', 'השתגעו', 'מלחיץ', 'עבודה', 'סקפטי',
                                'מפריע', 'נחרד', 'דריכות', 'תכף', 'חסרשקט', 'נבהל', 'להתעצבן', 'מתוסכל', 'מדוכדך',
                                'מכעיס', 'נלחצים', 'נסער', 'תקוע', 'מאויים', 'מועקה', 'שיגעון', 'במצוקה']
    EmotionalVariety_NotConfusion = ['אה!', 'אוקי', 'אוקיי', 'אחלה', 'אחרי', 'אחריות', 'אין', 'אין בעיה', 'אין ספק',
                                     'אין שאלה', 'איתה', 'איתי', 'איתך', 'אלף אחוז', 'אמיתי', 'אעשה', 'אצלי', 'אצלך',
                                     'אשכרה', 'באמת', 'בארץ', 'בבטחון', 'בבית', 'בדוק', 'בדיוק', 'בדקנו', 'בדקתי',
                                     'בהחלט', 'בהיר', 'בהכרח', 'בוודאות', 'בוודאי', 'בול', 'בולט', 'בטוח', 'בטוחה',
                                     'בטח', 'בלי בעיה', 'בלי ספק', 'בסדר', 'בסיידר', 'בעיניי', 'ברור', 'ברורה',
                                     'ברורות', 'ברורים', 'בשבילי', 'גבול', 'גבולות', 'גם', 'דה', 'דהה', 'דורש', 'הבין',
                                     'הבינה', 'הבינו', 'הבינותי', 'הבנה', 'הבנת', 'הבנתי', 'הגיוני', 'החלטתי', 'היום',
                                     'הייתה', 'הייתי', 'הלאה', 'המציאות', 'הצלחתי', 'הרגשתי', 'הרי', 'השבוע', 'השנה',
                                     'וודאות', 'זאת', 'זה', 'זוכרת', 'חייבת', 'חשוב', 'טוב', 'טוף', 'טריוואילי',
                                     'טריויאלי', 'ידוע', 'ידועות', 'ידועים', 'ידע', 'יודע', 'יודעות', 'יודעים', 'יודעת',
                                     'יציב', 'יציבות', 'כלומר', 'כמובן', 'כן', 'לא מבלבל', 'לגמרי', 'לדעת', 'להבין',
                                     'להגיד', 'להיות', 'להסביר', 'לחלוטין', 'ללא ספק', 'למדתי', 'מאה אחוז', 'מבין',
                                     'מה השאלה', 'מובהק', 'מובהקות', 'מובהקים', 'מובהקת', 'מובן', 'מובנת', 'מודע',
                                     'מודעת', 'מטרה', 'מיליון אחוז', 'מיקוד', 'מנהל', 'מסגרת', 'מסודר', 'מסתדר',
                                     'מעניין', 'נגמר', 'נהיר', 'נהירה', 'נקודה', 'סבבה', 'סגור', 'סגרנו', 'סגרתי',
                                     'סדר', 'סמוך עליי', 'סמכי עליי', 'פיתרון', 'פשוט', 'צלול', 'צלולה', 'צלולים',
                                     'צפוי', 'צריך', 'קבוע', 'קוהרנטי', 'קונקרטי', 'רציונלי', 'שייך', 'של', 'שלה',
                                     'שלהם', 'שלו', 'שלי', 'שליטה', 'שלך', 'שלם', 'שלמה', 'שלמים', 'שלנו', 'שם', 'שקוף',
                                     'שקיפות', 'תוכנית', 'תכלס', 'תמיד', 'תפקיד', 'תשובה']
    EmotionalVariety_NotContentment = ['מוגבל', 'מסתייג', 'מאוכזבת', 'החמצה', 'רועד', 'מזדעזע', 'חיכה', 'משעמם',
                                       'חוסרסיפוק', 'מאכזב', 'תסכול', 'זהירות', 'מתנער', 'מתסכל', 'מדכא', 'מושפע',
                                       'נוראית', 'אינסוף', 'עצב', 'החמצתי', 'אינוברור', 'חמדן', 'מובך', 'הופתעתי',
                                       'להתאכזב', 'נתקע', 'מורכבת', 'חסרה', 'לדחות', 'מבסוט', 'מתחרט', 'קנאה', 'נזהר',
                                       'נהנה', 'ביקורתית', 'מתקשה', 'לוזר', 'סדוק', 'עלבון', 'דחינו', 'דחו', 'מחכה',
                                       'מתמוגג', 'מיואש', 'קנאי', 'מוטרד', 'חלל', 'משועשע', 'עוד', 'רודף', 'שיפור',
                                       'מזועזע', 'מרוצה', 'נגעל', 'חבל', 'עצוב', 'רעב', 'התרשם', 'פיספס', 'ריק', 'חוסר',
                                       'מחשבות', 'עצבני', 'לחוץ', 'אירצון', 'פוחד', 'פספסתי', 'נדכה', 'שמפריע', 'כעסתי',
                                       'דכאוני', 'התבאסתי', 'חושב', 'התבלבלות', 'חלקי', 'נרעש', 'מאוכזב', 'מוגזם',
                                       'חצי', 'נדכא', 'ריקני', 'לאשלם', 'עולב', 'בכי', 'דחיתי', 'מבאס', 'להתלונן',
                                       'שקשה', 'מבקר', 'טרגי', 'ייאוש', 'אכזבה', 'נואש', 'חושש', 'כעס', 'ההתלבטות',
                                       'דייקן', 'מרוקן', 'מופתע', 'אוףף', 'דכאון', 'מנחוס', 'חסר', 'דחייה', 'מתכסח',
                                       'ביקורתי', 'חוסרמשמעות', 'שבור', 'זוהר', 'מבואס', 'להתחרט', 'מתלוננת', 'לאמסופק',
                                       'מדוכא', 'הלאה', 'לשפר', 'אוף', 'מודאג', 'התפעלתי', 'מקנא', 'באסה', 'מרוקנת',
                                       'הביקורתי', 'אימה', 'אין', 'המום', 'דאגה', 'בכח', 'תחרות', 'קודר', 'קטנוני',
                                       'מפחיד', 'ביאוס', 'רע', 'בררן', 'בקושי', 'נפעם', 'לאמובן', 'שחור', 'לאשווה',
                                       'מתוסכלת', 'תמיד', 'בערך', 'מתרגש', 'מופתעת', 'נדהם', 'מרירות', 'חלשה', 'כמעט',
                                       'זעוף', 'עמום', 'חוסרמצברוח', 'מתרשם', 'יתרגש', 'מאיים', 'לשנות', 'טינה',
                                       'מבולבל', 'פיספסה', 'נרתע', 'פסימי', 'חרטה', 'מתח', 'מלנכולי', 'מתוח',
                                       'התאכזבתי', 'ממורמר', 'חלק', 'מתעלם', 'נעלב', 'אפס', 'מפחד', 'מבועס', 'נבוך',
                                       'פספוס', 'פרפקציוניסט', 'ליד', 'תיעוב', 'עגמומי', 'בזבוז', 'רוצה', 'מסתנוור',
                                       'מסתורי', 'נחרד', 'התרגש', 'אישביעותרצון', 'מצטמרר', 'ביקרותי', 'נבהל', 'כישלון',
                                       'מתוסכל', 'תקועה', 'מדוכדך', 'מכעיס', 'מחסור', 'עיוות', 'נסער', 'תקוע', 'עגום',
                                       'דחית', 'שלילי', 'הפסד']
    EmotionalVariety_NotDisgust = ['אגדי', 'אוהב', 'אוהבת', 'אוהד', 'אוקי', 'אוקיי', 'אחלה', 'אכיל', 'אפשר', 'אפשרי',
                                   'אש', 'אשש', 'אששש', 'בוטח', 'בסדר', 'בעד', 'בריא', 'הכי', 'הכל', 'המון', 'הסתדרתי',
                                   'הרבה', 'ואו', 'ואוו', 'וואו', 'וואוו', 'חן', 'טהור', 'טהורה', 'טהורות', 'טהורים',
                                   'טוב', 'טובב', 'טובבב', 'טובה', 'טובים', 'טוהר', 'טעים', 'טעימות', 'טעימים', 'יאם',
                                   'יאמי', 'יופי', 'יכול', 'יכולה', 'יפה', 'יפות', 'יפים', 'יש', 'כדאי', 'ככה-ככה',
                                   'כןכן', 'לא דוחה', 'לא מגעיל', 'לא משהו', 'לדבר', 'לקחת', 'מדהים', 'מהמם', 'מופלא',
                                   'מוצלח', 'מושך', 'מושלם', 'מטורףף', 'מים', 'מין', 'ממ', 'מממ', 'ממממ', 'מסודר',
                                   'מסופק', 'מעדיף', 'מעדיפה', 'מענג', 'מעניין', 'מצוין', 'מקסים', 'מקסימה', 'מקסימות',
                                   'מקסימים', 'מרהיב', 'מרתק', 'מתאים', 'מתפעל', 'נאה', 'נאות', 'נדיר', 'נדירה',
                                   'נדירות', 'נדירים', 'נהדר', 'נהדרות', 'נהדרים', 'נהדרת', 'נהנה', 'נוח', 'נוחות',
                                   'נחמד', 'נעים', 'נעימה', 'נעימות', 'נעימים', 'נקי', 'סבבה', 'סביר', 'סוףף', 'עוד',
                                   'עונג', 'עם', 'עניין', 'פגזי', 'פסדר', 'קסום', 'קסומה', 'קסומים', 'קסם', 'רוצה',
                                   'רוצות', 'רוצים', 'רצוי', 'רצויה', 'רצויות', 'רצוייה', 'רצוייות', 'רצויים', 'רצוים',
                                   'רצינו', 'רציתי', 'שיש', 'תענוג', 'תרצו']
    EmotionalVariety_NotEnthusiastic = ['משביז', 'לאה', 'אוי', 'חופר', 'משעמם', 'קשוח', 'זוועתי', 'מאכזב', 'תשוש',
                                        'משועממים', 'מתסכל', 'מדכא', 'פסיכי', 'נכלם', 'בכוח', 'מפרך', 'מעופף', 'אדיש',
                                        'חום', 'רדום', 'דאון', 'מבעס', 'מוזר', 'לאבפוקוס', 'נוראי', 'מגעיל', 'מרדים',
                                        'משמים', 'עייפות', 'מרגיז', 'חבל', 'עצוב', 'איפוק', 'מטורף', 'חזרה', 'לחוץ',
                                        'מבוישת', 'מבויש', 'מיותר', 'אפאתי', 'שטויות', 'מדכדך', 'נרדמתי', 'ישנה',
                                        'כבוי', 'מייגע', 'ועייף', 'חפרת', 'נרדמת', 'סחוט', 'מבאס', 'מותש', 'מחורבן',
                                        'שלילית', 'לאמשו', 'שליליות', 'אכזרי', 'חסר', 'משועמם', 'חסרהתלהבות', 'ועייפה',
                                        'מייאש', 'ארוךךךך', 'חולשה', 'רדומים', 'מסובך', 'ישן', 'ככה-ככה', 'באסה', 'כבד',
                                        'אין', 'שואתי', 'מעצבן', 'מעייף', 'מפחיד', 'מעיק', 'נחמד', 'משועממת', 'עייף',
                                        'רדומות', 'גרוע', 'מבולבל', 'מביך', 'תשושה', 'סיוט', 'נבוך', 'קר', 'משתעממים',
                                        'מעפן', 'אפאטי', 'תשישות', 'מלחיץ', 'נרדם', 'מזחל', 'משתעממות', 'מתיש', 'ארוך',
                                        'רדומה', 'מחסור', 'עייפה', 'קריר']
    EmotionalVariety_NotFatigue = ['אגיע', 'אדרנלין', 'אודרוב', 'אוהב', 'אוהבת', 'אחת', 'אימון', 'אנרגטי', 'אנרגטית',
                                   'אנרגיה', 'אנרגיות', 'בזריזות', 'ביום', 'ביחד', 'במהירות', 'בעננים', 'הולך',
                                   'הספקתי', 'התלהבות', 'התעורר', 'התעוררה', 'התעוררו', 'התערוררתי', 'ואמוס', 'זורם',
                                   'זריז', 'זריזה', 'זריזות', 'זריזות', 'זריזים', 'חזק', 'חזקה', 'חי', 'חיה', 'חיות',
                                   'חיים', 'חתירה לפעולה', 'יאללה', 'יותר', 'יכול', 'יכולה', 'יכולים', 'יכולתי', 'כוח',
                                   'כוחות', 'כולם', 'כושר', 'כח', 'כיף', 'לא עייף', 'לבוא', 'לבנות', 'להגיע', 'להוביל',
                                   'להוריד', 'להזיז', 'להיות', 'להכין', 'להקים', 'להרגיש', 'להרים', 'להשיג', 'להשקיע',
                                   'להשתולל', 'להשתחרר', 'להתאמץ', 'להתגבר', 'להתמודד', 'להתעסק', 'להתקדם', 'לטייל',
                                   'ליצור', 'ללכת', 'למלא', 'לנהל', 'לנקות', 'לעבוד', 'לעלות', 'לעמוד', 'לעשות',
                                   'לפגוש', 'לפתח', 'לצאת', 'לקיים', 'לקפוץ', 'לראות', 'לרוץ', 'לתכנן', 'מאוד', 'מאמץ',
                                   'מהיר', 'מהירה', 'מהירות', 'מהירים', 'מהר', 'מוטיבציה', 'מיד', 'מין', 'מיני', 'מנהל',
                                   'מסוגל', 'מסוגל', 'מסוגלות', 'מסוגלות', 'מסוגלים', 'מסוגלת', 'מסיבה', 'מעורר', 'מרץ',
                                   'משימה', 'משמעותי', 'מתקדם', 'נו', 'נוכל', 'נכונות לעשייה', 'נלהב', 'נמרץ', 'נמרצות',
                                   'נמרצות', 'נמרצים', 'נמרצת', 'נמשיך', 'ספורט', 'עבודה', 'עוד', 'עוצמה', 'עוצמתי',
                                   'עושה', 'עושים', 'עירנות', 'עירניות', 'עירניים', 'עם כוח', 'עניין', 'עסוקה', 'עפתי',
                                   'ער', 'ערה', 'ערות', 'ערני', 'ערני', 'ערנית', 'ערנית', 'פעולה', 'פעילה', 'צעירה',
                                   'קדימה', 'ראשונה', 'רוצה', 'ריחפתי', 'רצון לפעולה', 'רציתי', 'תחושה', 'תשוקה']
    EmotionalVariety_NotGuilty = ['סיפוק', 'חכם', 'מוסרי', 'לאהתכוון', 'רוגע', 'רגוע', 'תם', 'מסודר', 'הם', 'ניקיון',
                                  'טהורה', 'הוגנת', 'ניצחון', 'הגינות', 'זך', 'ביטחון', 'זכאית', 'תמימות', 'כנה',
                                  'שמחה', 'הן', 'חףמפשע', 'ראויה', 'מנוחה', 'חלילה', 'נקיות', 'זכאיות', 'ניצח', 'צודק',
                                  'הגונה', 'בוגר', 'מוחצן', 'נקיים', 'ראוי', 'שקוף', 'ראויים', 'צודקים', 'הוא',
                                  'משוחרר', 'זכאות', 'הוגן', 'צדיקות', 'חף', 'נקייה', 'צדק', 'חפות', 'כשיר', 'חפה',
                                  'נכון', 'ישר', 'חפים', 'לאבכוונה', 'נרגע', 'טוב', 'כנות', 'צדיק', 'זוכה', 'הוגנות',
                                  'חףפשע', 'חסיד', 'נקי', 'וי', 'עבר', 'זיכיון', 'זכאי', 'אחריות', 'לאאשם', 'מרגיע',
                                  'שלם', 'תירגע', 'בסדר', 'ללאאשמה', 'מנוקה', 'זכאים', 'תמים', 'הגון', 'מוצדק', 'מתבגר',
                                  'אמין', 'היא', 'תמימה', 'תמימים', 'צלול', 'טוהר', 'נאמנות', 'שחרור', 'לאטעה', 'שווה',
                                  'רגיל', 'טהור', 'מזוכה', 'גאה', 'רך', 'שזכאי', 'רווחה', 'זיכוי', 'נקיה', 'נאמן',
                                  'הרגעה']
    EmotionalVariety_NotHostile = ['מיודע', 'ומוכשר', 'כרגיל', 'חברים', 'ומחוסן', 'להיפתח', 'תומך', 'ומתוק', 'ממושמע',
                                   'ושובב', 'מזמין', 'להתמקד', 'עוזרת', 'ויפיוף', 'מנומס', 'ידיד', 'משמח', 'נתנה',
                                   'מתוקון', 'רגוע', 'התקשרות', 'בטוחה', 'טובה', 'מוכשר', 'חם', 'ידידותיים', 'הבנה',
                                   'קשר', 'חטוב', 'טבעי', 'עדין', 'חיוך', 'מצחיק', 'יפיוף', 'עמית', 'אהבה', 'השגחה',
                                   'הדדי', 'הכרה', 'אופי', 'מקסים', 'ומחונך', 'מתגונן', 'תמימות', 'כנה', 'הזמנה',
                                   'חמים', 'שמחה', 'וחמוד', 'אדיבה', 'ומתפנק', 'דיאלוג', 'ליטוף', 'מנוחה', 'עדינות',
                                   'הכילה', 'וממושמע', 'לבן', 'ומהמם', 'מפרגן', 'אוהב', 'מבין', 'חביבה', 'וחייכן',
                                   'חייכנית', 'ידידות', 'מכיל', 'מלבב', 'אינטימי', 'נוחה', 'רוך', 'הבין', 'מחוייך',
                                   'חברותי', 'אדיב', 'ומושלם', 'מעודד', 'לבבי', 'קבלה', 'מאפשרת', 'מסייע', 'שלווה',
                                   'חמה', 'לברדור', 'מתון', 'אח', 'יעזור', 'מתפנק', 'משוחרר', 'בטחון', 'קרובה',
                                   'ידידותית', 'התגוננתי', 'נעים', 'מחוייכך', 'מתלטף', 'רכות', 'ידידה', 'עוזר', 'חברות',
                                   'מסתדר', 'לבלות', 'סחבקי', 'ומתלטף', 'וידידותי', 'הכלה', 'מנומסת', 'כלבון', 'הזמינה',
                                   'חמלה', 'להודות', 'מקשיב', 'עזרה', 'חייכן', 'באופיו', 'טוב', 'כנות', 'פרוותי',
                                   'לחבק', 'מקסימה', 'אהוב', 'וחברותי', 'וביישן', 'תמיכה', 'הבינה', 'מכילים', 'חביב',
                                   'חברי', 'נתינה', 'שליו', 'ביופיו', 'סימפטי', 'יפיופון', 'נוח', 'אמת', 'מחונך',
                                   'הזמין', 'נקי', 'וחששן', 'הבינו', 'ביתי', 'לבבית', 'אינועוין', 'חבר', 'מדוד', 'זורם',
                                   'ידידותי', 'וחתיך', 'מרגיע', 'שלום', 'מאירפנים', 'סימפטיה', 'נחמד', 'פתוח',
                                   'מושלמון', 'ידידים', 'מודע', 'נחמדה', 'אכפתי', 'החברתי', 'חברה', 'מחויך', 'אוהד',
                                   'חיבור', 'בעדינות', 'מזמינה', 'תמים', 'מכילות', 'שמח', 'כלבלבון', 'ונהדר', 'שקט',
                                   'מכילה', 'קרוב', 'ומקסים', 'אמון', 'ומתחשב', 'סולידרי', 'משפחתי', 'חששן', 'ומסתדר',
                                   'מקבל', 'רך', 'עדינה', 'חמוד', 'אמיתי', 'נעימה', 'נעימות', 'טובים', 'חברתי', 'חינוך',
                                   'וביופיו', 'חברותית', 'כייפי', 'כיף', 'מקרב', 'ברכות', 'הכיל', 'כן']
    EmotionalVariety_NotInterested = ['מסרב', 'דחה', 'חופר', 'משעמם', 'דבילי', 'משועממים', 'לאבאלי', 'מפוהק', 'לוותר',
                                      'זומבי', 'מסרבים', 'לאטוב', 'נמנעת', 'אדיש', 'שללה', 'מתעתע', 'נייטרלי', 'לדחות',
                                      'טבעי', 'משתעמם', 'מפגר', 'הפרעות', 'רדום', 'שעמום', 'משעממת', 'מתעל', 'אפתי',
                                      'ולא', 'אוקיי', 'לאמעוניין', 'עתיק', 'שגרתי', 'פשוט', 'מרדים', 'ויתרתי', 'מתעייף',
                                      'הזוי', 'די', 'עייפתי', 'עומס', 'חסרחשיבות', 'חוסר', 'שלל', 'מיותר', 'פחות',
                                      'דחתה', 'שטויות', 'משועממות', 'ישנים', '"מצעמם"', 'לאמתעניין', 'בעייתי', 'אדישות',
                                      'משעממים', 'חדגוני', 'נרדמתי', 'מזלזל', 'מייגע', 'לאחשוב', 'שיעמום', 'לסרב',
                                      'חפרת', 'מוגזם', 'משעמםםםםם', 'שעמם', 'דחיתי', 'חוסראכפתיות', 'לעע', 'מבאס',
                                      'מוותר', 'נמנעתי', 'צולע', 'מספיק', 'לברוח', 'קשה', 'מגחכת', 'חסר', 'סירבה',
                                      'משועמם', 'חסרהתלהבות', 'אשתעמם', 'השתעממתי', 'לארוצה', 'אדישים', 'איכ', 'טוב',
                                      'סתמי', 'זלזול', 'ישן', 'להרחיק', 'אוף', 'שולי', 'איף', 'סתם', 'באסה', 'לחפור',
                                      'בנאלי', 'מחפש', 'מעייף', 'מתעדף', 'מתעה', 'מעיק', 'דפוק', 'עלוב', 'מסרבות',
                                      'משועממת', 'משעמםםםם', 'נחמד', 'עייף', 'לא', 'סירב', 'דוחה', 'דל', 'לאמקשיב',
                                      'להירדם', 'בסדר', 'גרוע', 'מוותרת', 'עייפים', 'עמום', 'אפשרי', 'איכס', 'סביר',
                                      'פיהק', 'אדישה', 'איננורוצים', 'לעזוב', 'אינירוצה', 'טיפוסי', 'רצינות', 'משעמים',
                                      'מעפן', 'להתרחק', 'רגיל', 'נרדם', 'משתעממת', 'נסבל', 'משתעממות', 'להתחמק', 'מתיש',
                                      'שכיח', 'אניהולך', 'חוזרעל', 'בינוני', 'לאמרוכז', 'חסררצון', 'סירוב', 'אוופ',
                                      'לפהק', 'לאמעניין', 'חסרערך', 'מסרבת']
    EmotionalVariety_NotJoy = [':(', 'אבל', 'אבלות', 'אבלים', 'אוי', 'אויש', 'אוך', 'אומלל', 'אומללה', 'אומללות',
                               'אומללים', 'אונים', 'אוף', 'אטריד', 'אטריח', 'איום', 'איומה', 'איומות', 'איומים', 'אלים',
                               'אלימות', 'אסון', 'אפור', 'אציק', 'אשמה', 'באסה', 'בדידות', 'בודד', 'בודדה', 'בוכה',
                               'בחילה', 'ביאוס', 'ביאסת', 'ביאסתם', 'ביאסתן', 'בלחץ', 'בצער', "ג'יפה", 'גרוע', 'גרועה',
                               'גרועות', 'גרועים', 'דחוי', 'דיכאון', 'דיכי', 'דיפרסיה', 'דכאון', 'דכדוך', 'דמעות',
                               'דפוק', 'הבעיה', 'הזאת', 'הטריד', 'הטרידה', 'הטרידו', 'הלבד', 'הפסד', 'הצטער', 'הצטערה',
                               'הצטערו', 'הציק', 'הציקה', 'הצקה', 'הרוס', 'הרס', 'התבאס', 'התבאסה', 'התבאסנו',
                               'התבאסתי', 'התבאסתם', 'התבאסתן', 'התעללות', 'התקף', 'התרגז', 'התרגזה', 'התרגזו', 'התרעם',
                               'התרעמה', 'התרעמו', 'התרעמתי', 'זוועה', 'זוועתי', 'זנוח', 'זר', 'חוסר', 'חוסר שייכות',
                               'חלל', 'חסך', 'חרא', 'חרד', 'חרדה', 'חרה', 'חשש', 'טירחה', 'טראומה', 'טרדה', 'יאוש',
                               'יגון', 'יטריד', 'יטרידו', 'יטריח', 'יסורים', 'יציק', 'כאב', 'כאוב', 'כבוי', 'כואב',
                               'כועס', 'כועסות', 'כועסים', 'כועסת', 'כישלון', 'כלא', 'כעוס', 'כעוסה', 'כעס', 'כעסה',
                               'כעסנו', 'כעסתי', 'לא כייף', 'לא שייך', 'לארצה', 'לבכות', 'להפסיק', 'להתאבד', 'לחוץ',
                               'לחץ', 'לחתוך', 'לסבול', 'לצעוק', 'לצערי', 'לריב', 'מאוד', 'מאיים', 'מאכזב', 'מאמלל',
                               'מאמללות', 'מאמללים', 'מאמללת', 'מבאס', 'מבוזבז', 'מגוגגות', 'מדוכא', 'מדוכדך', 'מדיי',
                               'מדכא', 'מוות', 'מוזנח', 'מוטרד', 'מוטרדות', 'מוטרדים', 'מוטרדת', 'מופקר', 'מוריד',
                               'מזוגג', 'מזוגגים', 'מזוגגת', 'מזוויע', 'מזופת', 'מזופתת', 'מחלה', 'מחרפן', 'מטורטר',
                               'מטורטרות', 'מטורטרים', 'מטורטרת', 'מטריד', 'מטרידה', 'מטרידות', 'מטרידים', 'מטריח',
                               'מטריחה', 'מטריחות', 'מטריחים', 'מידי', 'מיואש', 'מיואשות', 'מיואשים', 'מיואשת', 'מיוסר',
                               'מין', 'מיני', 'מכות', 'מכעיס', 'מלחמה', 'ממוצע', 'ממש', 'מנסה', 'מסכן', 'מסכנה',
                               'מספיק', 'מסריח', 'מעונה', 'מעייף', 'מעייפות', 'מעייפים', 'מעייפת', 'מעיק', 'מעצבן',
                               'מעצבנות', 'מעצבנים', 'מעצבנת', 'מפוספס', 'מפחדת', 'מפריע', 'מצטער', 'מצטערות',
                               'מצטערים', 'מצטערת', 'מציף', 'מציק', 'מציק', 'מציקות', 'מציקים', 'מקומם', 'מקוממת',
                               'מקנא', 'מקנאה', 'מרגיז', 'מרומה', 'מרוסק', 'מרתיח', 'משביז', 'משבר', 'משגע', 'משוגע',
                               'משוגעת', 'מתאבל', 'מתאבלות', 'מתאבלים', 'מתח', 'מתייסר', 'מתסכל', 'מתענה', 'מתקומם',
                               'מתקוממות', 'מתקוממים', 'מתקוממת', 'נדבק', 'נדבקו', 'נדבקנו', 'נדבקת', 'נדבקתי', 'נורא',
                               'נוראי', 'נוראית', 'נזק', 'נטוש', 'נטישה', 'ניכור', 'נכות', 'נסער', 'נסערו', 'נסערת',
                               'נעלב', 'נעצב', 'נעצבו', 'נפגע', 'נפטר', 'נציק', 'נרגז', 'נרגזים', 'נרגזת', 'נתעצב',
                               'נתעצבה', 'נתעצבתי', 'סביר', 'סבל', 'סבלתי', 'סובל', 'סוער', 'סוערים', 'סורי', 'סיוט',
                               'סרטן', 'סתם', 'עגום', 'עזוב', 'עייף', 'עייפה', 'עייפות', 'עימות', 'עינוי', 'עיף',
                               'עיפה', 'על הפנים', 'עלבון', 'עמוס', 'עצב', 'עצבות', 'עצבים', 'עצוב', 'עצובה', 'עצובות',
                               'עצובים', 'פגוע', 'פוגע', 'פוחדת', 'פחד', 'פחדתי', 'פחות', 'פסימי', 'פספוס', 'פצוע',
                               'פרידה', 'צער', 'צקצוק', 'צרה', 'צריך', 'קודר', 'קוצפות', 'קוצפים', 'קורבן', 'קטסטרופה',
                               'קנאה', 'קצף', 'קצפה', 'קקה', 'קריזה', 'קשה', 'קשים', 'רגוז', 'רגוזה', 'רגוזים', 'רגיל',
                               'רוגוזות', 'רוגז', 'רותח', 'רותחות', 'רותחים', 'ריב', 'ריק', 'רע', 'רתחה', 'שבוז',
                               'שבוזה', 'שבוזות', 'שבוזים', 'שגעון', 'שואה', 'שובר', 'שונא', 'שונאת', 'שוקע', 'שחור',
                               'שיגע', 'שיגעה', 'שיגעו', 'שיט', 'שלילי', 'שנאה', 'שקשה', 'תובעני', 'תוגה', 'תטריד',
                               'תטריח', 'תכעס', 'תכעסו', 'תלוש', 'תסכול', 'תסכל', 'תסכלה', 'תסכלו', 'תציק', 'תציקו']
    EmotionalVariety_NotNervous = ['אחלה', 'יציבות', 'סבבה', 'רגיש', 'נינוח', 'קשוח', 'רפוי', 'רוגע', 'משמח', 'שוכב',
                                   'רגוע', 'בטוחה', 'משחרר', 'מרומם', 'רגועה', 'בטוח', 'משתחרר', 'מדיטציה', 'אדיש',
                                   'נוחות', 'שלוות', 'חיוך', 'נהנה', 'לאט', 'ביטחון', 'בשלום', 'סבלני', 'איזון', 'חלוש',
                                   'רועש', 'שמחה', 'אינומתוח', 'מנוחה', 'מהורהר', 'יוגה', 'נחת', 'נשמח', 'ישנוני',
                                   'מרוצה', 'מאוזן', 'בטוב', 'מצחקק', 'מחוייך', 'שקולים', 'שלווה', 'נינוחה', 'חופש',
                                   'מחייכים', 'סיום', 'אמוציונלי', 'מנומנם', 'יציב', 'ששש...', 'משוחרר', 'בטחון',
                                   'נינוחות', 'מאוזנת', 'קטן', 'נעים', 'בוטח', 'הביטחון', 'מופנם', 'שלוים', 'אצליח',
                                   'תקווה', 'חלש', 'פניות', 'מפויס', 'מהנה', 'סבלנות', 'יושב', 'שקולות', 'רגועות',
                                   'מענג', 'מקשיב', 'יפה', 'עירני', 'נרגע', 'חייכן', 'ללאדאגות', 'אסרטיבי', 'ישן',
                                   'נהדר', 'יופי', 'מוטרף', 'שליו', 'סימפטי', 'אפרורי', 'נוח', 'אידילי', 'לגיטימי',
                                   'שקול', 'רילקס', 'קודר', 'זכה', 'דומם', 'דממה', 'שקטה', 'זורם', 'שלו', 'ידידותי',
                                   'מרגיע', 'חופשי', 'נחמד', 'שלם', 'נוכחות', 'אופטימי', 'מחויך', 'מודעות', 'מבוהל',
                                   'גאווה', 'שקולה', 'מבולבל', 'להניח', 'צנוע', 'תמים', 'מפוייס', 'מפוחד', 'שמח',
                                   'לאטלאט', 'מתוח', 'שינה', 'שקט', 'מתעלם', 'הוקל', 'מאוזנים', 'צחוק', 'קופצני',
                                   'בקטנה', 'קר', 'דואגלאחר', 'רגיעה', 'שחרור', 'ערני', 'עגמומי', 'שלוה', 'רך', 'ערב',
                                   'סבלן', 'להסתדר', 'מאושר', 'מהוסס', 'הקלה', 'בקלות', 'רהוט', 'רגועים', 'פסטורלי',
                                   'רווחה', 'קל', 'מרוגש', 'חיוור', 'מדוכדך', 'מפוכח', 'שאנן', 'אנחה', 'שפוף', 'הקשבה',
                                   'נהנית', 'זחוח']
    EmotionalVariety_NotProud = ['מסתיר', 'מאוכזבת', 'החמצה', 'עכבה', 'בזיון', 'להתבייש', 'נחות', 'ספין', 'בלוף',
                                 'מאכזב', 'מסתירים', 'עצב', 'כשלון', 'מסתירה', 'תחתית', 'להתחבא', 'לוותר', 'מהלך',
                                 'נכלם', 'נכשל', 'מובך', 'קוריוז', 'ככישלון', 'בעיה', 'לוזר', 'עלבון', 'וכשלון', 'משבר',
                                 'הרסתי', 'מבוישים', 'ויתרתי', 'התפרק', 'להפסיק', 'קפאון', 'עצוב', 'מסתירות', 'מתבייש',
                                 'חידלון', 'נכס', 'מבוישת', 'כלום', 'מבויש', 'נפלתי', 'מתביישות', 'מידור', 'להוריד',
                                 'קשקוש', 'איום', 'מאוכזב', 'אילוץ', 'מבייש', 'שברתי', 'מוותר', 'בושי', 'כאוס', 'בושה',
                                 'מתביישים', 'כהפסד', 'הכישלון', 'אכזבה', 'לברוח', 'אכזבתי', 'דשדוש', 'לאמשו', 'מושפל',
                                 'נכלמים', 'כשל', 'נמוך', 'על', 'דחייה', 'לאהצלחתי', 'שבור', 'מובכת', 'מחבוא', 'נכלמות',
                                 'באסה', 'נכשלה', 'פורש', 'מפסיד', 'כאסון', 'נהרס', 'אופורטוניזם', 'אסון', 'מתביישת',
                                 'נפילה', 'רע', 'לחדול', 'להחמיץ', 'עלוב', 'קיבעון', 'הכשלון', 'להיכשל', 'נפל',
                                 'קיפאון', 'כלימה', 'מביך', 'אוותר', 'משגה', 'זגזוג', 'נשבר', 'חוסרהצלחה', 'בוש', 'אפס',
                                 'נבוך', 'פספוס', 'עיכוב', 'צעד', 'וכישלון', 'ויתור', 'נכשלתי', 'אווף', 'בריחה',
                                 'נחותה', 'כישלון', 'נכלמת', 'ככשלון', 'מפץ', 'הפסד']
    EmotionalVariety_NotSad = ['מושלם', 'אחלה', 'צחקוק', 'סיפוק', 'מרנין', 'שמייייייייח', 'מנגן', 'סבבה', 'שש', 'אוהבת',
                               'רקידה', 'לעודד', 'שמחתי', 'מרוצים', 'ישמח', 'רוגע', 'משמח', 'רגוע', 'רינה', 'יששש',
                               'מבסוטה', 'משתוקק', 'מרומם', 'כייף', 'עליז', 'שמייח', 'שמיייח', 'תשמח', 'מבסוט', 'חיוך',
                               'אהבה', 'נהנה', 'מאושרות', 'מקסים', 'חיוני', 'צהל', 'שמחה', 'צחק', 'הומור', 'אדאג',
                               'אור', 'אאחל', 'משועשע', 'מפרגן', 'אוהב', 'מאוד', 'מרגש', 'שמיייייייח', 'חיובית',
                               'מטרוף', 'מצפה', 'מרוצה', 'קליל', 'נגינה', 'מחוייך', 'להתעודד', 'מתרגשת', 'מעודד',
                               'שמחחחח', 'צוחקות', 'שלווה', 'עליזות', 'חייכתי', 'מאחלת', 'מחייכים', 'מחמם', 'משובב',
                               'משועשעת', 'קורן', 'שטוב', 'בעננים', 'ולשמוח', 'מדהים', 'איזהכיף', 'נעים', 'נהנת',
                               'צוחקים', 'שמחחח', 'ושמח', 'תקווה', 'מסופק', 'עונג', 'דואג', 'מחייך', 'שבערצון', 'חיובי',
                               'יפה', 'שעשוע', 'שמחים', 'נרגש', 'ראייתהטוב', 'וואו', 'חיבוק', 'מתוק', 'לאעצוב', 'נהדר',
                               'מהמם', 'רוקד', 'אהבת', 'מקוה', 'אושר', 'שמייייח', 'צוחקת', 'נהינת', 'מגניב', 'גל',
                               'לרקוד', 'רוקדים', 'שמחתחיים', 'ישש', 'נחמד', 'מתרגש', 'משעשע', 'אופטימי', 'בסדר',
                               'שביעות', 'התרונן', 'מאחל', 'מקווה', 'עליזה', 'הנאה', 'מוצלח', 'שמח', 'שקט', 'בכיף',
                               'שמחח', 'מרוצות', 'צחוק', 'יום', 'הצטהל', 'באלי', 'יש', 'דיצה', 'רגיעה', 'שווה', 'נהנית',
                               'רגיל', 'רוצה', 'שמיח', 'גאה', 'נפלא', 'מלהיב', 'מבטיח', 'מאושר', 'הקלה', 'ושמחים',
                               'מאושרת', 'מצוין', 'צוחק', 'קל', 'לשמוח', 'כיף', 'שהצלחתי', 'אנרגטי', 'מאושרים', 'עלץ']
    EmotionalVariety_NotSurprise = ['אדיש', 'אדישה', 'אולי', 'אז?', 'אחר', 'אמרתי', 'אמרתי לך', 'בדיעבד', 'בטוח', 'בטח',
                                    'ברור', 'דה', 'דהה', 'הגיוני', 'הזה', 'הכרה', 'המשכי', 'הנחה מראש', 'העריכו',
                                    'הערכתי', 'חדשות ישנות', 'חוזר', 'חזרה', 'טריוואילי', 'טריויאלי', 'ידוע',
                                    'ידוע מראש', 'ידע', 'ידעתי', 'יודעת', 'יכול', 'יכולה', 'ככה', 'כמוני', 'כרגיל',
                                    'לא חדש', 'לא מופתע', 'לגיטימי', 'לחזור', 'מאליו', 'מה נראה לך', 'מובן', 'מוכן',
                                    'מוכר', 'ממש', 'ממשיך', 'ממשיכה', 'מעריך', 'מעריכה', 'מעריכות', 'מצפה', 'מצפות',
                                    'מצפים', 'משעמם', 'נו באמת', 'נורמלי', 'ניחשתי', 'סביר', 'עושה', 'פחות', 'פעם',
                                    'ציפה', 'ציפו', 'ציפייה', 'ציפינו', 'ציפיתי', 'ציפתה', 'צלול', 'צפוי', 'צפויה',
                                    'קבוע', 'קורה', 'ראיתי', 'רגוע', 'רגיל', 'רואה?', 'שיעמום', 'שיערתי', 'שם']
    EmotionalVariety_NotTrust = ['אחשוד', 'אי אפשר לסמוך', 'אסור', 'אשמה', 'בגד', 'בגידה', 'בדייה', 'בדינו', 'בדיתם',
                                 'בדיתן', 'בוגד', 'בוגדות', 'בוגדים', 'בוגדת', 'בילף', 'בילפה', 'בילפנו', 'בכלל',
                                 'בלוף', 'גנב', 'דבר', 'דו-פרצופי', 'הבל', 'הגזמת', 'ההם', 'הוטעו', 'הוליך שולל',
                                 'הוליכה שולל', 'הוליכו שולל', 'הולכו שולל', 'הולכתי שולל', 'הונאה', 'הונה', 'הונתה',
                                 'הזוי', 'הזוייה', 'הטעה', 'הטעו', 'הטעייה', 'הטענו', 'הטעתה', 'המצאה', 'המצאת',
                                 'המצאתי', 'המצאתם', 'הפוך', 'וברגע', 'והוא', 'והיא', 'חדשתי', 'חוסר אמונה', 'חושדות',
                                 'חושדים', 'חרדה', 'חרם', 'חשד', 'כזב', 'כזבים', 'כיזב', 'כיזבה', 'לא', 'לא אמין',
                                 'לא אמיתי', 'לא כנה', 'לבגוד', 'לבד', 'להחשיד', 'להם', 'להסתיר', 'לוקש', 'לוקשים',
                                 'לנצל', 'לפגוע', 'מוגזם', 'מוגזמת', 'מוזר', 'מזעזע', 'ממציא', 'ממציאה', 'מסבן',
                                 'מסבנת', 'מסתיר', 'מעצבן', 'מעשיות', 'מעשייה', 'מפחד', 'מפחדת', 'מפחיד', 'מפריע',
                                 'מרמה', 'משקר', 'משקרת', 'נאף', 'נאפה', 'נבגד', 'נוטר טינה', 'נוכל', 'נורא', 'ניאופים',
                                 'ניצול', 'ניצל', 'נקמני', 'סדק', 'סיבן', 'סיבנה', 'סכין בגב', 'עבד עליה', 'עבד עליו',
                                 'עבדה עליה', 'עבדה עליו', 'עבדו עליה', 'עבדו עליו', 'עבדו עליי', 'עבדנו עליה',
                                 'עבדנו עליו', 'עבדתי עליה', 'עבדתי עליו', 'עבודה בעיניים', 'פגוע', 'פחד', 'פחדתי',
                                 'פחות', 'פייק', 'רוע', 'רימאה', 'רימה', 'רימתה', 'רמאות', 'רמאי', 'רע', 'שיקר',
                                 'שיקרה', 'שיקרו', 'שקר', 'שקרים', 'שקרן', 'תוקפני', 'תחשדי', 'תחשוד', 'תרמית']
    EmotionalVariety_NotVigor = ['בטלן', 'מסכנה', 'לאה', 'עצלן', 'רפיון', 'שחוקה', 'רועד', 'אלגנטיות', 'רגיש', 'שברירי',
                                 'לאות', 'נינוח', 'משעמם', 'ריקנות', 'תשוש', 'הפרעה', 'מאלחש', 'רגוע', 'חינניות', 'עצב',
                                 'שפל', 'חוסראון', 'מסכנות', 'התעצל', 'שברירית', 'לאטוב', 'רעוע', 'אדיש', 'בדידות',
                                 'עדין', 'הפסיק', 'עצלות', 'רדום', 'תרדמה', 'שעמום', 'מאולחש', 'לאט', 'דאון', 'אפתיה',
                                 'פגיע', 'חולי', 'מסכן', 'איטי', 'חוסריכולת', 'מיואש', 'עדינות', 'פגיעה', 'גמורה',
                                 'גמורים', 'מסכנים', 'מרדים', 'משמים', 'עייפות', 'רפה', 'ישנוני', 'אמורפי', 'עצוב',
                                 'מכונס', 'רוך', 'ריק', 'חוסר', 'אימפוטנציה', 'אונים', 'מבוישת', 'מבויש', 'חלישות',
                                 'פוחד', 'ישנים', 'חסרישע', 'מנומנם', 'שחוקים', 'נרדמתי', 'פחד', 'חולה', 'מעומעמם',
                                 'ישנה', 'כבוי', 'קטן', 'דיכאון', 'פגיעות', 'ועייף', 'מאוכזב', 'נרדמת', 'סחוט', 'בכי',
                                 'סגור', 'כואב', 'נחלשות', 'חלושס', 'מותש', 'להתעלם', 'למנוע', 'חלש', 'איטיות', 'עצל',
                                 'כעס', 'עצלנות', 'חוסראנרגיה', 'איןאונים', 'חסר', 'נמוך', 'אייכולת', 'נרפות', 'להימנע',
                                 'ועייפה', 'נחלשו', 'אומלל', 'אצילי', 'חסרכוח', 'חולשה', 'מדוכא', 'עמוק', 'ישן', 'שחוק',
                                 'מודאג', 'יגעות', 'רכרוכי', 'קלילות', 'כבד', 'אין', 'משימם', 'גמור', 'מאופק', 'מעייף',
                                 'חוסרכל', 'מתביישת', 'נמוכה', 'ללאמרץ', 'מחליש', 'התרוקן', 'אוזלתיד', 'עייף',
                                 'חסרשאיפור', 'חלשה', 'להירדם', 'פחדן', 'עייפים', 'בטטה', 'עמום', 'עצבות', 'מופרע',
                                 'חסרמרץ', 'מייבש', 'נחלש', 'רכרוכית', 'שינה', 'שקט', 'דק', 'מוחלשת', 'נחלשה', 'עזבו',
                                 'לשרוד', 'אותנטי', 'תשישות', 'מרוחק', 'רדוד', 'חלשים', 'רך', 'חלשות', 'אלגנטי',
                                 'מפריע', 'אווף', 'קל', 'מתיש', 'קלוש', 'מתוסכל', 'רדומה', 'ישנתי', 'עייפה', 'מוחלש',
                                 'עיפות', 'רפיסות', 'הפסקה']
    EmotionalVariety_Proud = ['סיפוק', 'עף', 'זחיחה', 'זכיתי', 'תומך', 'מתהדרת', 'משתחצן', 'עשיתי', 'הגשמתי', 'גבוה',
                              'מפצירה', 'יששש', 'לכבד', 'חושק', 'בטוח', 'השגתי', 'כייף', 'בעלגאוה', 'התגאתי', 'גאים',
                              'גאותנית', 'תראו', 'גבהרוח', 'בטח', 'מבסוט', 'מגיע', 'חושקת', 'ניצחון', 'אני', 'יהירים',
                              'שוויצריות', 'ביטחון', 'התפארות', 'עפה', 'מתנשאים', 'ארוגנטיות', 'גבהות', 'שויצר', 'שמחה',
                              'משמעות', 'נפוחה', 'השתחצנו', 'יהיר', 'מצליחה', 'הרשמתי', 'מצודד', 'אבגוד', 'לזכות',
                              'מרגש', 'שאיפה', 'מפקפקת', 'מרוצה', 'ערך', 'מתבייש', 'שחצנות', 'רברבן', 'התיהרות', 'רושם',
                              'נכס', 'מתנשא', 'גאותנות', 'התהדרות', 'מעוניינת', 'פרס', 'השתחצנות', 'בטחון', 'מדהים',
                              'מאוהב', 'תומכת', 'להשתלט', 'גאותן', 'התנשאות', 'שחצנית', 'הישג', 'מסופק', 'שחצני',
                              'יהירות', 'מואהבת', 'בזכותי', 'ארוגנטי', 'שחצניות', 'הצליח', 'מלאבעצמו', 'אתגאה', 'דוגלת',
                              'בזכותנו', 'התקדמות', 'שחצנים', 'נרגש', 'שחצן', 'מקנא', 'גאותני', 'שופוני', 'אתחשב',
                              'מתביש', 'אהבת', 'מקנאת', 'מתנשאת', 'מתגאה', 'רברבנות', 'כבוד', 'הו', 'אנזוף', 'אתעניין',
                              'התעלות', 'מאה', 'מכובדת', 'זכייה', 'הצלחתי', 'יהירה', 'מוצלחת', 'התגאיתי', 'להתגבר',
                              'שויצרית', 'מפציר', 'ראותנות', 'שויצרים', 'טווס', 'גאווה', 'זחיחות', 'מאוהבבבבב',
                              'רברברנית', 'בעצמי', 'שהתברכה', 'מוצלח', 'שמח', 'חזקים', 'מכובד', 'וגאה', 'סנוביות', 'יש',
                              'מאוהבת', 'רהבתנות', 'זחיח', 'גאה', 'ניצחתי', 'זכינו', 'יוהרה', 'מתחשבת', 'גאוותנות',
                              'שלי', 'שהצלחתי', 'מתרה', 'נצחון', 'מאוהבב', 'רגש', 'שויצריות', 'נפוח', 'הצלחה', 'התגאות',
                              'התרברבות', 'גאהההה', 'בחרתי', 'גאההה']
    EmotionalVariety_Sad = ['אוי', 'לילה', 'לקבל', 'מיואשת', 'רגיש', 'אפור', 'כאב', 'משעמם', 'ריקנות', 'שבר', 'מאכזב',
                            'משמח', 'לסבול', 'מתסכל', 'מדכא', 'עגומות', 'עגומים', 'חושך', 'עצב', 'אבל', 'נכשל', 'בודדה',
                            'קיבלתי', 'פתטי', 'נפלופניו', 'פגועה', 'סובל', 'בדידות', 'בודד', 'כואבת', 'לבכות', 'דאון',
                            'שעצוב', 'מבעס', 'לאשמח', 'פאתטי', 'מוזר', 'בדיכאון', 'צער', 'כאבי', 'מיואש', 'מבהיל',
                            'מצטער', 'מגעיל', 'הורמונים', 'מכשול', 'מרגש', 'מרגיז', 'מבדר', 'הזוי', 'התעצבו', 'עצוב',
                            'נעלבה', 'התייאש', 'אובדן', 'ריק', 'חוסר', 'חסראנרגיות', 'קודרות', 'הדיכאון', 'יגון',
                            'נפלתי', 'עצובות', 'דיכי', 'שיט', 'מבואסת', 'נפטר', 'התבאסתי', 'ליפול', 'למות', 'פרידה',
                            'מריר', 'עצובה', 'מדהים', 'דיכאון', 'טיפשי', 'פצע', 'נדכא', 'הורמונלית', 'רציני', 'מחמיא',
                            'אבכה', 'אומללים', 'בכי', 'מבאס', 'סגור', 'כואב', 'מתאבל', 'מר', 'שקשה', 'טרגי', 'מצערת',
                            'ייאוש', 'אכזבה', 'נואש', 'חלש', 'עגומה', 'לאמשו', 'כעס', 'קודרים', 'קשה', 'חוסראנרגיה',
                            'מחזור', 'מתה', 'בכתה', 'אמורה', 'אמל', 'מייאש', 'שבור', 'אומלל', 'חולשה', 'מבואס', 'נרגש',
                            'דמעות', 'מדוכא', 'וסת', 'חיבוק', 'אומללות', 'אוף', 'התייאשתי', 'באסה', 'פצוע', 'אירוני',
                            'פגוע', 'בוכה', 'מעציב', 'מצטערת', 'איבדתי', 'העציב', 'מעצבן', 'מבודד', 'מעייף', 'קודר',
                            'מפחיד', 'ביאוס', 'רע', 'חבר', 'בוגד', 'מעיק', 'רגישה', 'שחור', 'עלוב', 'נחמד', 'עייף',
                            'לא', 'משעשע', 'דפרסיבי', 'בגידה', 'חלשה', 'עצובים', 'צורם', 'תאונה', 'גרוע', 'אוףףף',
                            'עצבות', 'ועצוב', 'נמאס', 'מביך', 'רחמים', 'מכאיב', 'פסימי', 'נעלבתי', 'נשבר', 'בעסה',
                            'מלנכולי', 'טראגי', 'קודרת', 'שקט', 'הגיוני', 'נעלב', 'מעליב', 'מוות', 'נבוך', 'מצער',
                            'לדיכאון', 'בכיתי', 'עגמומי', 'מציק', 'גירושים', 'מלחיץ', 'גירוש', 'נפגעתי', 'ציער',
                            'מדוכאת', 'לאמאושר', 'נורא', 'סובלת', 'לבד', 'כיף', 'מתיש', 'סגורה', 'כישלון', 'נוגה',
                            'מדוכדך', 'מכעיס', 'רגש', 'למה', 'מציף', 'אנחה', 'עגום', 'מת', 'התאבלתי', 'דכאוני', 'מזעזע']
    EmotionalVariety_Surprise = ['אה', 'אהה', 'אומייגאד', 'אותי?', 'איזה', 'איך', 'אימא', 'אימאלה', 'אשכרה', 'באיזה',
                                 'באמת??', 'בהלה', 'בהלם', 'בום', 'בשוק', 'דווקא', 'דייי', 'הוא?', 'הופתעו', 'הופתעתי',
                                 'הזוי', 'היא?', 'הלומות', 'הלומים', 'הלם', 'המום', 'המומה', 'הפתיע', 'הפתעה', 'הפתעות',
                                 'השתאה', 'השתאות', 'השתאתה', 'השתומם', 'השתוממה', 'השתוממו', 'השתוממות', 'השתוממנו',
                                 'התעלפתי', 'התפלא', 'התפלאה', 'התפלאנו', 'התפלאתי', 'התפעלות', 'התפעם', 'התפעמה',
                                 'התפעמות', 'התפעמנו', 'התפעמתי', 'ואו', 'ואוו', 'ואז', 'וברגע', 'והוא', 'וואו',
                                 'וואוו', 'וואי', 'וואלה', 'ופתאום', 'חסר מילים', 'חריג', 'טירוף', 'טרלול', 'טרללת',
                                 'טרפת', 'יאא', 'יאוו', 'יוו', 'ישש', 'כזאת', 'כמהה??', 'לאיזה', 'להפתיע', 'לפתע',
                                 'מאיפה?', 'מבהיל', 'מדהים', 'מה הלו"ז', 'מה הקטע', 'מה נסגר', 'מהה', 'מוכה אלם',
                                 'מופלא', 'מופתע', 'מופתעות', 'מופתעים', 'מופתעת', 'מטורלל', 'מטורף', 'מטורפת', 'מיוחד',
                                 'מייי', 'מעניין', 'מפחיד', 'מפעים', 'מראש', 'משוגע', 'משתאה', 'מתמיה', 'מתעלף',
                                 'מתעלפת', 'מתפלאה', 'נבהלתי', 'נדהם', 'נדהמנו', 'נדהמתי', 'ניסים', 'נס', 'נפל מהכסא',
                                 'נקסם', 'נרעש', 'נרעשנו', 'נרעשת', 'נרעשתי', 'נשתל', 'נשתלת', 'נשתלתי', 'עכשיו?',
                                 'פחד', 'פלא', 'פליאה', 'פסיכי', 'פסיכית', 'פעור פה', 'פתאום', 'פתאומי', 'פתאומית',
                                 'קטע', 'רציני??', 'שאת', 'שאתה', 'שדווקא', 'שוק', 'תדהמה', 'תמוה', 'תמוהה', 'תמיהה']
    EmotionalVariety_Trust = ['אוהבים', 'אוהבת', 'אח', 'אחותי', 'אחי', 'אחריות', 'איזון', 'אישור', 'איתך', 'אכפת',
                              'אמא', 'אמון', 'אמונה', 'אמין', 'אמיתי', 'אמפתיה', 'אפשר', 'בבית', 'בוטח', 'בוטחת',
                              'בטוח', 'בטוחה', 'בטוחים', 'בטח', 'בטחון', 'בטחת', 'בטחתי', 'ביחד', 'ביטחון', 'בינינו',
                              'בקבוצה', 'ברור', 'בשביל', 'בשבילי', 'בשבילך', 'גב', 'הביתה', 'הגנה', 'הדדי', 'הדדיות',
                              'ההורים', 'הוקרה', 'הזדמנות', 'הכלה', 'המשפחה', 'הערכה', 'הקשבה', 'זוג', 'חבר', 'חברה',
                              'חברות', 'חברים', 'חום', 'חיבוק', 'חם', 'חמה', 'חמלה', 'טיפול', 'ידיד', 'יודע', 'יודעת',
                              'יחד', 'ייעוץ', 'יעזור', 'כבוד', 'כנות', 'כתף', 'לב', 'לבטוח', 'לדאוג', 'לדבר', 'להאמין',
                              'להגן', 'להישאר', 'להכיל', 'להכיר', 'להקשיב', 'להשען', 'לויאלי', 'לוייאלי', 'לנו',
                              'לסמוך', 'לעזור', 'לעטוף', 'לצידו', 'לצידי', 'לקבל', 'לשתף', 'לתמוך', 'לתת', 'מאמין',
                              'מאמינה', 'מאמינות', 'מאמינים', 'מבינה', 'מוגן', 'מודה', 'מחילה', 'מכבדת', 'מכיר',
                              'מלווה', 'מסוגלת', 'מסור', 'מסורה', 'מסורות', 'מסורים', 'מסכימה', 'מקבל', 'מרגישה',
                              'מרחב', 'משענת', 'משפחה', 'נאמן', 'נאמנה', 'נאמנות', 'נאמנות', 'נוח', 'נוכחות', 'נותן',
                              'נחמדה', 'נקי', 'נשאר', 'נשארת', 'נשען', 'נשענות', 'נשענים', 'נשענת', 'סבלנות', 'סומך',
                              'סומכים', 'סומכת', 'סמוך', 'סמכי', 'סמכתי', 'עבורך', 'עוזר', 'עוזרת', 'עזרה', 'פקדון',
                              'פרטנר', 'פתוח', 'צוות', 'קבלה', 'קרבה', 'רגש', 'שומר', 'שומר אמונים', 'שומרת', 'שותף',
                              'שייכות', 'שלם', 'שלנו', 'תאמיני', 'תודה', 'תמיכה', 'תקשיבי']
    EmotionalVariety_Vigor = ['חסינה', 'תזזיתיות', 'טיל', 'יציבות', 'יאאא', 'להט', 'כח', 'פעיל', 'רגיש', 'תוכנית',
                              'תומך', 'הכוח', 'הרסני', 'קרדינלי', 'מתפקדת', 'שובבות', 'שמן', 'תמריץ', 'וולנטרי',
                              'אספיק', 'עצום', 'בכוח', 'עליז', 'בעלהשפעה', 'קפצני', 'קדימה', 'טבעי', 'חוזקה', 'חזקה',
                              'תזוזה', 'עוצמות', 'משולהב', 'מחויבות', 'חוזק', 'חשק', 'עוצמתי', 'חיוני', 'שמחה',
                              'להמריץ', 'שובב', 'חיוניות', 'משמועתי', 'חזק', 'מלא', 'רעננות', 'להתעצם', 'לחזק', 'לתפקד',
                              'אופטימלי', 'חיובית', 'גבר', 'רצון', 'מעשה', 'נחוץ', 'עוצמתיים', 'אנרגיות', 'כוחני',
                              'רצינית', 'אדרנלין', 'התחזקו', 'ממהר', 'מתקשרת', 'אביביות', 'מסייע', 'נמרץ', 'האומץ',
                              'ויטליות', 'מזיק', 'הכרחי', 'התחזקה', 'חיות', 'מתלהב', 'עוצמתית', 'פעלתני', 'עושה',
                              'מהיר', 'עתיד', 'משוגע', 'מרץ', 'עסוק', 'יעיל', 'מחזק', 'תקין', 'אנרגיה', 'מועיל',
                              'היפרקטיבי', 'נמרצת', 'עשייה', 'חייתי', 'קריטי', 'עמידות', 'חסין', 'מטוטיבציה', 'התחזק',
                              'נלהב', 'שימושי', 'נמרצות', 'להודות', 'חיונית', 'מורכב', 'וולונטרי', 'פרקטי', 'זריזות',
                              'עוצמה', 'נמרצים', 'עזוז', 'אינטנסיבי', 'התלהבות', 'תמיכה', 'צעיר', 'מצחקקת', 'מאמץ',
                              'חיזק', 'מתכנן', 'חסינות', 'חמקמק', 'מטפל', 'מעורבת', 'השקעה', 'קשיחות', 'טריוויאלי',
                              'ליזום', 'ידידותי', 'קופץ', 'משמעותי', 'רבאק', 'חשוב', 'תשוקה', 'אדיר', 'חסינים',
                              'להתגבר', 'יכולת', 'מיטבי', 'חרוץ', 'און', 'אפקטיבי', 'עוצמתיות', 'רבעוצמה', 'מוצלח',
                              'שמח', 'חזקים', 'חיוניים', 'מבריק', 'שאפתן', 'מתעצם', 'מוטיבציה', 'מתעורר', 'אומץ',
                              'התרגשות', 'כוחניות', 'קופצני', 'קרוב', 'אמיצה', 'מוצק', 'אש', 'מהפכני', 'עוז', 'חוסן',
                              'לדחוף', 'מדלג', 'התמודדות', 'חזקות', 'כוח', 'טיפול', 'חברתי', 'אקוטי', 'כיף', 'אנרגטי',
                              'אמיץ', 'חיים', 'רגש', 'תאורטי', 'אקטיבי', 'יאללה', 'ממשי', 'מוחשי']
    Paralinguistics_Body = ['משתעלת', 'מכחכחת', 'משתעל', 'מושכת', 'מקנחת', 'כף', 'מגהק', 'כחכוח', 'נשימה', 'מפהקת',
                            'מקנח', 'מתנשף', 'מפהק', 'מכחכח', 'נושמת', 'מושך', 'נשיפה', 'מוחאת', 'מתעטשת', 'שיעול',
                            'נושפת', 'קינוח', 'מתעטש', 'נושם', 'שותה', 'מתנשפת', 'כפיים', 'מאנפף', 'פיהוק', 'לוגמת',
                            'אפצי', 'משיכה', 'שואפת', 'ומכחכחת', 'נוקשת', 'שאיפת', 'ומשתעלת', 'ומקנחת', 'לוגם', 'בולעת',
                            'נושף', 'נשימות', 'כחכוך']
    Paralinguistics_Crying = ['בוכה', 'חנוק', 'רועד', 'נשבר', 'חנק', 'לבכות', 'בכי', 'מתייפחת', 'מדמעות', 'בבכי',
                              'עצוב', 'נחנק', 'צוחקתבוכה', 'ובוכה', 'שבוכה', 'השתנקות', 'משתנק', 'מבכי']
    Paralinguistics_HighTone = ['גבוה', 'צועק', 'צועקת', 'חזק', 'רם', 'צעקה', 'שאגה']
    Paralinguistics_Humming = ['מהנהנת', 'מהמהם', 'מהנהן', 'מהמהמת', 'אהא', 'הנהון', 'אהמ', 'המהום', 'הנהון']
    Paralinguistics_ImitationTone = ['חיקוי', 'מחקה', 'בנימה', 'כחיקוי', 'לחיקוי', 'בחיקוי', 'תיאטרלית', 'בדרמטיות',
                                     'בתיאטרליות', 'דרמטית', 'מתחנחן', 'מזויף', 'ילדותי', 'צווחני', 'מתיילד',
                                     'בתאטרליות', 'תינוקי']
    Paralinguistics_Joy = ['צוחקת', 'צוחק', 'צוחקות', 'מצחקקת', 'צוחקים', 'מצחקק', 'צחקוק', 'צחוק', 'מצחקקים', 'משועשע',
                           'לצחוק', 'בהומור', 'בצחוק', 'מבודחת', 'מצחקקות', 'מצחוק', 'מחייכת', 'משועשעת', 'וצוחקת',
                           'בצחקוק', 'מחייך', 'הומוריסטי', 'מצחיק', 'צוחקתבוכה', 'בחיוך', 'חיוך', 'בשעשוע', 'שמחה',
                           'מחוייכת', 'וצחקוק', 'הומוריסטית', 'וצחוק', 'מצחיקים']
    Paralinguistics_LowTone = ['שקט', 'ממלמל', 'במלמול', 'ממלמלת', 'מלמול', 'בלחישה', 'בלחש', 'לחישה', 'לוחשת']
    Paralinguistics_Sarcasm = ['בציניות', 'ציני']
    Paralinguistics_Sigh = ['נאנחת', 'נאנח', 'אנחה', 'באנחה', 'נאחנת']
    Paralinguistics_Smirk = ['מגחכת', 'גיחוך', 'מגחך', 'בגיחוך', 'מגחכות', 'מגחכים']
    Paralinguistics_TutTut = ['צקצוק', 'מצקצק', 'מצקצקת', 'ציקצוק', 'צקצקו']
    Questions = ['למה', 'מה', 'איך', 'מתי', 'כמה', 'מי', 'מאין', 'איפה', 'היכן', 'מדוע', 'כמה', 'איך', 'כיצד', 'איזו',
                 'איזה', 'אילו', 'לאן']
    StopWords = ['לא', 'כול', 'חשב', 'רצה', 'זה', 'כ', 'מ', 'ב', 'ל', 'אני', 'כל', 'ה', 'את', 'כאילו', 'לי', 'מה', 'אז',
                 'כן', 'אבל', 'גם', 'כל', 'על', 'של', 'הוא', 'היא', 'שאני', 'היה', 'אה', 'עם', 'כי', 'יש', 'XXX',
                 'משהו', 'שלי', 'אם', 'אתה', 'יודעת', 'לך', 'או', 'שזה', 'מאוד', 'יותר', 'רוצה', 'אומרת', 'כזה', 'שהוא',
                 'וזה', 'ש', 'הזה', 'ו', 'ככה', 'להיות', 'באמת', 'עכשיו', 'לו', 'איזה', 'לה', 'ואני', 'הייתי', 'אותי',
                 'טוב', '<NUM>', 'עוד', 'אולי', 'אין', 'יכול', 'דברים', 'כבר', 'אמרתי', 'איך', 'שהיא', 'הרבה', 'לעשות',
                 'קצת', 'חושבת', 'יודע', 'ואז', 'ה', 'פעם', 'בסדר', 'ממש', 'שם', 'כך', 'שאת', 'אומר', 'הם', 'זאת',
                 'למה', 'נכון', 'אותו', 'אחד', 'צריך', 'כמו', 'עושה', 'פה', 'הייתה', 'פשוט', 'שלך', 'רק', 'נורא',
                 'יכולה', 'קשה', 'שאתה', 'צריכה', 'הזמן', 'כמה', 'דבר', 'שיש', 'להגיד', 'אנחנו', 'ולא', 'שלא', 'וגם']
    Top2000 = ['לא', 'זה', 'אני', 'את', 'כאילו', 'לי', 'מה', 'אז', 'כן', 'אבל', 'גם', 'כל', 'על', 'של', 'הוא', 'היא',
               'שאני', 'היה', 'אה', 'עם', 'כי', 'יש', 'XXX', 'משהו', 'שלי', 'אם', 'אתה', 'יודעת', 'לך', 'או', 'שזה',
               'מאוד', 'יותר', 'רוצה', 'אומרת', 'כזה', 'שהוא', 'וזה', 'ש', 'הזה', 'ו', 'ככה', 'להיות', 'באמת', 'עכשיו',
               'לו', 'איזה', 'לה', 'ואני', 'הייתי', 'אותי', 'טוב', '<NUM>', 'עוד', 'אולי', 'אין', 'יכול', 'דברים',
               'כבר', 'אמרתי', 'איך', 'שהיא', 'הרבה', 'לעשות', 'קצת', 'חושבת', 'יודע', 'ואז', 'ה', 'פעם', 'בסדר', 'ממש',
               'שם', 'כך', 'שאת', 'אומר', 'הם', 'זאת', 'למה', 'נכון', 'אותו', 'אחד', 'צריך', 'כמו', 'עושה', 'פה',
               'הייתה', 'פשוט', 'שלך', 'רק', 'נורא', 'יכולה', 'קשה', 'שאתה', 'צריכה', 'הזמן', 'כמה', 'דבר', 'שיש',
               'להגיד', 'אנחנו', 'ולא', 'שלא', 'מרגישה', 'אנשים', 'היום', 'הזאת', 'וגם', 'רואה', 'חושב', 'האלה',
               'צוחקת', 'אהה', 'יהיה', 'הכל', 'אותך', 'אותה', 'אחרי', 'יום', 'אחר', 'לזה', 'עצמי', 'תמיד', 'נגיד', 'עד',
               'נראה', 'שלו', 'בא', 'לפני', 'אפילו', 'בכלל', 'הדברים', 'ב', 'אממ', 'היו', 'אדם', 'שהם', 'בגלל', 'שלה',
               'אמא', 'מרגיש', 'והוא', 'שני', 'לדבר', 'מיני', 'אמרה', 'והיא', 'בבית', 'אפשר', 'להם', 'ל', 'כאלה', 'בזה',
               'בעצם', 'מקום', 'זמן', 'פתאום', 'אמר', 'אוקיי', 'לפעמים', 'מישהו', 'פחות', 'זהו', 'בדיוק', 'כדי', 'בן',
               'איתו', 'מבינה', 'מזה', 'הכי', 'מי', 'סתם', 'ואת', 'לנו', 'אותם', 'קורה', 'ממ', 'לראות', 'אף', 'בכל',
               'כזאת', 'לעצמי', 'איתה', 'שמה', 'עבודה', 'שכאילו', 'המון', 'אחת', 'ביום', 'ללכת', 'שבוע', 'וכאילו',
               'זוכרת', 'שנה', 'עדיין', 'פעמים', 'רגע', 'דווקא', 'בשביל', 'כנראה', 'שום', 'לבד', 'היית', 'וכל', 'במקום',
               'שהיה', 'מצד', 'מנסה', 'איפה', 'שנים', 'הרגשתי', 'נשמע', 'ברור', 'אחרת', 'בלי', 'איתי', 'עשיתי', 'עצמך',
               'כלום', 'אבא', 'קודם', 'חשוב', 'לחשוב', 'חשבתי', 'הולך', 'אוקי', 'טובה', 'אמ', 'עליו', 'לבוא', 'באה',
               'ויש', 'ומה', 'להבין', 'שגם', 'בעיה', 'בסוף', 'באיזה', 'שאנחנו', 'אי', 'ב<NUM>', 'אחרים', 'בו', 'בצורה',
               'אמרת', 'רציתי', 'עליי', 'לעבוד', 'קרה', 'לקחת', 'הולכת', 'מספיק', 'מעניין', 'בחיים', 'מבין', 'למרות',
               'שוב', 'ביחד', 'הדבר', 'איזשהו', 'אל', 'שהייתי', 'החיים', 'בדרך', 'אתמול', 'שיהיה', 'אליי', 'בין', 'חלק',
               'לתת', 'בטח', 'אוהבת', 'בוא', 'אהמ', 'העבודה', 'כשאני', 'איתך', 'ואתה', 'בארץ', 'מדברת', 'משנה', 'וזהו',
               'בעבודה', 'לגמרי', 'המקום', 'ראיתי', 'תראי', 'אגיד', 'עובד', 'מממ', 'ממני', 'שאם', 'סוג', 'הילדים',
               'השבוע', 'העניין', 'כולם', 'הביתה', 'שאין', 'ואם', 'חברה', 'כסף', 'לצאת', 'די', 'בבוקר', 'להרגיש',
               'עושים', 'יפה', 'להגיע', 'שלנו', 'הבנתי', 'אלא', 'באותו', 'למשל', 'אליו', 'צוחק', 'בתוך', 'האמת',
               'ילדים', 'קשר', 'שלהם', 'כרגע', 'השני', 'מגיע', 'ההורים', 'הממ', 'מדבר', 'איתם', 'לפחות', 'בי', 'שאולי',
               'דרך', 'מין', 'היינו', 'מתי', 'קל', 'אצל', 'אצלי', 'כאן', 'לקבל', 'נעים', 'דיברנו', 'כיף', 'שצריך',
               'זוכר', 'וחצי', 'לב', 'הבית', 'שכן', 'בראש', 'ספר', 'ממה', 'בואי', 'לדעת', 'מול', 'שעה', 'אוכל', 'והם',
               'יצא', 'צריכים', 'הן', 'תהיה', 'אומרים', 'כלל', 'קשור', 'הלכתי', 'יוצא', 'שישי', 'ללמוד', 'באופן',
               'אעשה', 'שכל', 'בית', 'שאלה', 'לאט', 'מכירה', 'ראשון', 'בת', 'אוהב', 'נותן', 'הבן', 'ידעתי', 'עליה',
               'אליה', 'לשם', 'ועוד', 'בטוח', 'לכל', 'ילד', 'מצב', 'הזאתי', 'ואמרתי', 'כלומר', 'וככה', 'מצליחה',
               'שאמרתי', 'שעבר', 'ישר', 'עשה', 'נחמד', 'יקרה', 'חצי', 'הנה', 'לשמוע', 'לעצמך', 'מישהי', 'גדול', 'בשבוע',
               'עניין', 'השאלה', 'שעות', 'כמעט', 'לוקח', 'ימים', 'לגבי', 'עובדת', 'מלא', 'דקות', 'מאד', 'התחלתי',
               'לישון', 'והכל', 'לפה', 'ממנו', 'תחושה', 'אתם', 'להתמודד', 'שבאמת', 'בך', 'בהתחלה', 'ברגע', 'בה', 'ואיך',
               'לנסות', 'רוצים', 'הקטע', 'רע', 'מתאים', 'מדברים', 'מבחינת', 'סוף', 'הבא', 'הרי', 'וואו', 'חברים', 'זו',
               'להביא', 'למצוא', 'שבת', 'בזמן', 'דיברתי', 'המצב', 'אמרו', 'בקטע', 'כמובן', 'מדי', 'טובים', 'שאמרת',
               'לשבת', 'נוח', 'בטוחה', 'לחזור', 'והיה', 'עצמו', 'אהיה', 'בתור', 'בקשר', 'חייבת', 'באיזשהו', 'חיים',
               'ועכשיו', 'שואלת', 'באתי', 'לעזור', 'חוץ', 'אכפת', 'חוסר', 'למקום', 'ממך', 'התחיל', 'מ', 'עליך', 'נכנס',
               'תקופה', 'תגיד', 'תודה', 'הקשר', 'צקצוק', 'להמשיך', 'ואין', 'שומעת', 'חייב', 'זוג', 'לשים', 'להתחיל',
               'בגיל', 'לספר', 'חודשים', 'לזמט', 'האנשים', 'יכולים', 'לשאול', 'במצב', 'מפחיד', 'שקל', 'איזשהי', 'לבית',
               'חמישי', 'מפריע', 'בערב', 'סבבה', 'וואי', 'קטן', 'נמצא', 'התחושה', 'לעבודה', 'עליהם', 'המשפחה', 'ברמה',
               'בשבילי', 'מתחיל', 'שונה', 'הגעתי', 'מכיר', 'שקורה', 'מהר', 'כוח', 'לאיזה', 'במה', 'בעיקר', 'שתי',
               'נניח', 'ילדה', 'ממנה', 'הרגשה', 'להסביר', 'האחרון', 'סיפרתי', 'יכולתי', 'חודש', 'רואים', 'מתוך',
               'והייתי', 'ובאמת', 'לאכול', 'יודעים', 'עבר', 'הרגשת', 'לוקחת', 'עשתה', 'אח', 'עולה', 'חבר', 'הסיפור',
               'לסיים', 'ואולי', 'מבחינתי', 'הבעיה', 'בדברים', 'לעבור', 'סליחה', 'מקווה', 'מהבית', 'שמחה', 'באמצע',
               'חברות', 'הטיפול', 'חולים', 'עובר', 'בסופו', 'משפחה', 'מידי', 'חזק', 'מצליח', 'נגמר', 'מחר', 'מגיעה',
               'שאפשר', 'שה', 'לאנשים', 'הדרך', 'ולהגיד', 'שהייתה', 'חסר', 'מעבר', 'שהיו', 'נותנת', 'מעצבן', 'לחיות',
               'כשאת', 'ניסיתי', 'הצלחתי', 'האם', 'תשמעי', 'מכל', 'חולה', 'חדש', 'שלב', 'מוזר', 'יחסית', 'לפי', 'שקרה',
               'מאז', 'שאלתי', 'תוך', 'בעולם', 'נמצאת', 'ואחר', 'להוציא', 'כשאתה', 'שיחה', 'בלילה', 'ועם', 'תגידי',
               'בעיר', 'אחותי', 'תראה', 'טיפול', 'נשאר', 'החברה', 'הראש', 'יאללה', 'לקחתי', 'גדולה', 'בהם', 'יושב',
               'נאנחת', 'להסתכל', 'בוכה', 'כזאתי', 'שהן', 'מבחינה', 'פחד', 'ופתאום', 'הגיע', 'קיבלתי', 'עוזר', 'הפגישה',
               'יוצאת', 'חוזר', 'מקבל', 'אישה', 'לחץ', 'טיפה', 'מספר', 'עצמה', 'גורם', 'נהיה', 'שבועיים', 'ועל', 'עשית',
               'מקבלת', 'בחוץ', 'תשמע', 'מאיפה', 'בערך', 'מן', 'עחמט', 'הראשון', 'הבאה', 'מהם', 'להיכנס', 'בעיות',
               'הבת', 'מחשבות', 'מעט', 'צוחקות', 'דירה', 'השנה', 'הולכים', 'שעשיתי', 'מסתכלת', 'שאלות', 'שיכול', 'לאמא',
               'לבין', 'לשנות', 'א', 'שלושה', 'חוזרת', 'נו', 'כשהוא', 'העולם', 'אליך', 'נעשה', 'לקרוא', 'יושבת',
               'שלישי', 'בצד', 'שככה', 'יצאתי', 'יהיו', 'תעשה', 'שווה', 'זתומרת', 'שאנשים', 'ואנחנו', 'בקיצור',
               'ביטחון', 'שמישהו', 'שבו', 'יופי', 'מפחדת', 'בשבילך', 'תלוי', 'מסוגלת', 'שכבר', 'לאן', 'מאשר', 'מקומות',
               'מוכנה', 'השם', 'מאמינה', 'שואל', 'באים', 'לקח', 'במיוחד', 'הלך', 'קטנה', 'בחדר', 'מסתכל', 'קרוב', 'ופה',
               'כואב', 'מתחילה', 'יחסים', 'שנתיים', 'רביעי', 'רוב', 'הראשונה', 'ליד', 'שלוש', 'נתן', 'מסוים', 'בטלפון',
               'הנושא', 'קוראים', 'מוקדם', 'מספרת', 'אמור', 'בנות', 'שהיית', 'הלאה', 'ל<NUM>', 'אותנו', 'נאמט', 'כשהיא',
               'פעמיים', 'שקט', 'אלך', 'בטיפול', 'לדברים', 'הסוף', 'לקנות', 'השיחה', 'מאוחר', 'לנסוע', 'שעכשיו', 'אגב',
               'שדיברנו', 'רצה', 'ערב', 'אלף', 'אותן', 'האחרונה', 'מצחיק', 'למצב', 'ואחרי', 'שניה', 'ראשונה', 'יבוא',
               'לשמור', 'ושם', 'ה<NUM>', 'גמור', 'בעצמי', 'שעברה', 'נכנסת', 'מושג', 'לבדוק', 'עדין', 'מפה', 'וואלה',
               'בינינו', 'טלפון', 'הכסף', 'אליהם', 'תהליך', 'חבל', 'וכן', 'שאמא', 'שמתי', 'שקשה', 'כשהייתי', 'כועסת',
               'אצלך', 'הילד', 'מראש', 'קטע', 'שמאוד', 'מחשבה', 'מקרה', 'בפנים', 'לחפש', 'חוויה', 'תעשי', 'זתאומרת',
               'חזרה', 'מאמין', 'רצתה', 'דודה', 'המחשבות', 'לפתוח', 'הזו', 'הגיוני', 'סביב', 'פגישה', 'עשו', 'לקום',
               'כתבתי', 'מצחקקת', 'לכתוב', 'בתקופה', 'ולמה', 'בכיתה', 'אשמה', 'שלום', 'מוכן', 'בחורה', 'יחד', 'השנים',
               'עובדים', 'המחשבה', 'מצפה', 'הפעם', 'קול', 'ומצד', 'סיטואציה', 'כללי', 'לבן', 'אחורה', 'הקודמת', 'שמשהו',
               'עלייך', 'סיפור', 'שינוי', 'משם', 'הצד', 'החוצה', 'אחריות', 'עזרה', 'שמעתי', 'חי', 'מהעבודה', 'חרדה',
               'יל', 'להישאר', 'למשהו', 'יעשה', 'קשים', 'מתקשר', 'עבדתי', 'אתן', 'מסוימת', 'לשלם', 'הפחד', 'לקרות',
               'רגיל', 'מפחד', 'במובן', 'אצטרך', 'נתתי', 'ראש', 'אצלה', 'שהכל', 'אצלו', 'מלחיץ', 'כלפי', 'באותה',
               'חופש', 'רצון', 'הולדת', 'שיותר', 'דיי', 'אבוא', 'שומע', 'הלימודים', 'מילה', 'זוגיות', 'ממקום', 'אלי',
               'אחי', 'כעס', 'גיל', 'שמח', 'וכמה', 'צורך', 'סיבה', 'משמעותי', 'הXXX', 'אלה', 'חזרתי', 'בעניין', 'אחוז',
               'התחילה', 'עברתי', 'שליטה', 'לכם', 'כשזה', 'שנייה', 'למישהו', 'תשובה', 'למדתי', 'מביא', 'בשם', 'אמורה',
               'טבעי', 'עלה', 'יזקלכן', 'עלי', 'בעבר', 'עונה', 'בשבת', 'גבוה', 'רחוק', 'לעמוד', 'בוקר', 'מחכה', 'אצלנו',
               'במקרה', 'להכיר', 'בפגישה', 'הסיטואציה', 'טובות', 'איכשהו', 'להראות', 'עדיף', 'בפעם', 'תבוא', 'אחרות',
               'לטיפול', 'האחרונות', 'אפשרות', 'משפט', 'ההרגשה', 'החלטה', 'דין', 'שנקרא', 'לדעתי', 'מחפשת', 'מדיי',
               'לקראת', 'צריכות', 'מוצאת', 'מניחה', 'מסוגל', 'גרוע', 'נושא', 'יכולת', 'ביקורת', 'יומיים', 'יגיד', 'גרה',
               'פגישות', 'שבעצם', 'הבנות', 'אופן', 'להעביר', 'פיזית', 'המטפלת', 'מתכוונת', 'בינתיים', 'בתחום', 'חושבים',
               'שטויות', 'לבקש', 'קטנים', 'נראית', 'לטפל', 'מובן', 'רגשות', 'נקרא', 'בשנה', 'ספק', 'החלק', 'חזקה',
               'ולפעמים', 'ברירה', 'לעזוב', 'ישבתי', 'ובסוף', 'מראה', 'ויותר', 'בהקשר', 'לידי', 'שתהיה', 'שבא', 'מטפלת',
               'יעזור', 'נדבר', 'ידע', 'חודשיים', 'מביאה', 'עצוב', 'חווה', 'אהבה', 'אוי', 'שלומך', 'בגדול', 'מחדש',
               'המילה', 'והיום', 'הקול', 'הגוף', 'התפקיד', 'הרגיש', 'קפה', 'הודעה', 'תוהה', 'עייפה', 'לוותר', 'מעדיפה',
               'בחור', 'מחפש', 'נכנסתי', 'בעיניי', 'שבועות', 'רת', 'נוסעת', 'בסך', 'מדהים', 'החוויה', 'רצית', 'חיה',
               'עומד', 'הלא', 'כדאי', 'מוצא', 'לענות', 'מעלה', 'ולעשות', 'בני', 'דיברת', 'מצאתי', 'ין', 'רוח', 'להתקשר',
               'היי', 'מתחבר', 'נתנה', 'המציאות', 'לסדר', 'שXXX', 'להכניס', 'איתן', 'קמה', 'התקשרתי', 'בלשון', 'לומר',
               'סך', 'קיים', 'הדירה', 'להתעסק', 'הפוך', 'אמנם', 'ארגיש', 'ואומר', 'לגור', 'ומאוד', 'לאורך', 'הלכה',
               'חשבון', 'אמיתי', 'היכולת', 'קוראת', 'כוחות', 'מתקשרת', 'דומה', 'סדר', 'החלטתי', 'לבחור', 'גרם', 'הקושי',
               'מורה', 'ואמא', 'אביב', 'מתארת', 'עזר', 'לילדים', 'מהמקום', 'להן', 'וכאלה', 'מזמן', 'נשים', 'שזאת',
               'קושי', 'הטלפון', 'האחרונים', 'מילים', 'עשינו', 'כח', 'אראה', 'לעצור', 'להחליט', 'מעולה', 'לאו', 'ורק',
               'מהצד', 'מ<NUM>', 'חדר', 'עוברת', 'וה', 'הגדול', 'הרצון', 'איש', 'ומשהו', 'חם', 'ישנה', 'במהלך', 'ועד',
               'התהליך', 'אצליח', 'נקודה', 'יואו', 'צודקת', 'בנוח', 'בהרבה', 'שרציתי', 'בעצמך', 'לומדת', 'כש', 'שלם',
               'מנהל', 'סיפרת', 'חדשה', 'שלפעמים', 'נותנים', 'תחושות', 'אהבתי', 'עצם', 'האוטו', 'לומד', 'במשהו',
               'יכולות', 'תואר', 'לכאן', 'אסור', 'מסתדר', 'מים', 'ננסה', 'לנקות', 'פתוח', 'אר', 'מזל', 'פי', 'בקול',
               'משפיע', 'לתוך', 'חזר', 'שעתיים', 'קמתי', 'כאב', 'סיכוי', 'המשפט', 'הספר', 'רבה', 'ויכול', 'שעוד',
               'אפשרי', 'שיחות', 'חן', 'דיברה', 'קורס', 'מסוימים', 'מודע', 'ולהיות', 'קונה', 'ליצור', 'לעניין',
               'בסיטואציה', 'מדברות', 'לרצות', 'גר', 'בהכרח', 'גבר', 'כלים', 'תקשיבי', 'עי', 'היחסים', 'לדאוג', 'נסעתי',
               'בעלי', 'תפקיד', 'לחוץ', 'סבתא', 'קדימה', 'סאמט', 'להחזיק', 'לשתף', 'הבאתי', 'ובגלל', 'כתבה', 'באו',
               'סרט', 'מבאס', 'כביכול', 'בקושי', 'חמש', 'הופך', 'לפגוע', 'לבכות', 'בלחץ', 'בשום', 'אמרנו', 'מגיעים',
               'החוסר', 'רגילה', 'ולראות', 'עשרה', 'דמטכן', 'סיפרה', 'הילדה', 'שאי', 'בחודש', 'בלתי', 'שכולם', 'בצבא',
               'ושאני', 'ספציפית', 'ודברים', 'עיר', 'שאומרים', 'מתאר', 'מיוחד', 'להכנס', 'הלב', 'צעיר', 'משמעות',
               'דוגמא', 'נשארת', 'דיבר', 'הרגשות', 'כשיש', 'סבלנות', 'שפשוט', 'הלכנו', 'הכוונה', 'דוגמה', 'עייף',
               'בעוד', 'מסביב', 'בתחילת', 'מיד', 'התקשרה', 'החברים', 'במקומות', 'עבד', 'אוכלת', 'במשך', 'מגחכת',
               'המטרה', 'פוגע', 'שתמיד', 'למי', 'בשעה', 'לשחרר', 'לימודים', 'שי', 'מזכיר', 'יושבים', 'הזדמנות', 'הצורך',
               'קם', 'למחרת', 'חשבת', 'נעימה', 'חד', 'אקח', 'הסיבה', 'להכין', 'התחושות', 'רגשית', 'משתעלת', 'לפגוש',
               'שאבא', 'להוריד', 'לכולם', 'הגיעה', 'המקומות', 'הורים', 'הדלת', 'נתנו', 'ראתה', 'לחכות', 'בXXX', 'לאבא',
               'מאיזה', 'מתחילים', 'החדר', 'לחלוטין', 'לשני', 'בלימודים', 'ההוא', 'במשרד', 'לחדר', 'שפתאום', 'כועס',
               'ליום', 'מבקשת', 'עברה', 'מעצמי', 'אן', 'אופציה', 'והיו', 'ראית', 'הלחץ', 'מוציא', 'לבמט', 'בריא',
               'התחילו', 'קבוצה', 'מגיל', 'פסח', 'להיפגש', 'נפטר', 'עומדת', 'איזושהי', 'אגיע', 'כותבת', 'היחיד',
               'שהרבה', 'ותמיד', 'וכבר', 'שנורא', 'אוהבים', 'למטה', 'ביקשתי', 'שאל', 'איתנו', 'מהדברים', 'ושוב', 'דקה',
               'שניהם', 'מבחינתך', 'ארוך', 'משחק', 'להפסיק', 'שאתם', 'נמאס', 'שהיום', 'עבודות', 'ראה', 'לרופא', 'פוחדת',
               'שחשבתי', 'שאף', 'בעיני', 'בנושא', 'יוצאים', 'צעד', 'תכלס', 'הפנים', 'היתה', 'שעשית', 'האמא', 'לנהל',
               'אישי', 'לקחה', 'פחדתי', 'להשיג', 'מסכימה', 'להתקדם', 'עזבי', 'במיטה', 'לסגור', 'להחזיר', 'ואומרת',
               'שינה', 'התקשר', 'שנגיד', 'מטפל', 'מערכת', 'תהיי', 'וכו', 'הכבוד', 'ונורא', 'להשאיר', 'שונים', 'ממשיך',
               'ועדיין', 'שהיינו', 'מרוצה', 'אלייך', 'קורא', 'הגב', 'XXXX', 'לעיר', 'גבולות', 'כלכלית', 'לעלות',
               'פעולה', 'בהחלט', 'לXXX', 'קצר', 'בעל', 'בשקט', 'דורש', 'להסתדר', 'רגעים', 'טה', 'מתסכל', 'כיוון',
               'קשרים', 'קניתי', 'קראתי', 'אשמח', 'למקומות', 'מחוץ', 'מאחורי', 'טלוויזיה', 'שסיפרתי', 'מכירים',
               'וראיתי', 'שממש', 'נחמדה', 'ממשיכה', 'כדורים', 'להורים', 'השולחן', 'האוכל', 'לבנות', 'מותר', 'ספורט',
               'דוד', 'השנייה', 'לעצמו', 'בחברה', 'שפה', 'רגש', 'הסתם', 'טעות', 'החברות', 'שלכם', 'בשבילו', 'משתדלת',
               'והרבה', 'החודש', 'בחירה', 'צודק', 'אדבר', 'נלך', 'עסוקה', 'צעירה', 'והייתה', 'נוסע', 'וצריך', 'שעושים',
               'העובדה', 'ניסיון', 'בשלב', 'מסודר', 'הבעיות', 'איזו', 'שיקרה', 'עולם', 'תמונה', 'מודעת', 'שפעם',
               'לכיוון', 'מעל', 'המורה', 'אנסה', 'הנקודה', 'לאף', 'סיפר', 'שהרגשתי', 'נפש', 'העיניים', 'ואף', 'נהנה',
               'לכן', 'סיטואציות', 'רגוע', 'גדולים', 'פנים', 'יגידו', 'בלה', 'אוויר', 'ביטוי', 'רצו', 'התחלנו', 'נגד',
               'בזוגיות', 'גברים', 'יה', 'לעולם', 'החבר', 'בתחושה', 'שדווקא', 'עוזרת', 'להיפך', 'בפני', 'ישנתי',
               'מתכוון', 'כ', 'לארץ', 'לבקר', 'תקווה', 'מבינים', 'שבה', 'משעמם', 'ארוחת', 'תקופות', 'שלחתי', 'כמוני',
               'האחרים', 'שאומר', 'נכונה', 'יראה', 'ההחלטה', 'חדשים', 'תחושת', 'ובכל', 'מתחת', 'לנוח', 'דקלכן', 'ושל',
               'התקופה', 'אירוע', 'נורמלי', 'חיובי', 'מבוגר', 'השאלות', 'לפנות', 'התשובה', 'הסתכלתי', 'למעלה', 'מסכים',
               'השניה', 'צד', 'במשפחה', 'הבנת', 'ואבא', 'אתחיל', 'וכזה', 'לוקחים', 'עס', 'שכחתי', 'שקצת', 'קיבל',
               'להתחבר', 'המערכת', 'מטריד', 'אלינו', 'בכוונה', 'בשבילה', 'שרק', 'לרגע', 'רבע', 'מצוין', 'נוסעים',
               'מרוב', 'טועה', 'קר', 'תלך', 'מצבים', 'ישן', 'ושזה', 'סיימתי', 'רציני', 'ארבע', 'להשאר', 'אמצא', 'שהכי',
               'יד', 'כזו', 'להקשיב', 'מת', 'ברחוב', 'שאחרי', 'בחזרה', 'בעיניים', 'הנכון', 'המנהל', 'הקטנה', 'אנרגיה',
               'הקודם', 'איפשהו', 'התחלת', 'סגור', 'במידה', 'עצמם', 'וקצת', 'ערך', 'יוצר', 'ולדבר', 'מל', 'לשחק',
               'לעומת', 'הבחור', 'גי', 'מהבחינה', 'מבחוץ', 'לגעת', 'בשיחה', 'צוחקים', 'הגענו', 'כבד', 'ארוכה', 'לחיים',
               'חייבים', 'בפייסבוק', 'אישית', 'מרגישים', 'שדיברתי', 'הכעס', 'עובדה', 'הסביבה', 'עברו', 'הכרתי', 'בקלות',
               'האחים', 'תחום', 'תבואי', 'לזרוק', 'בשנים', 'מכניס', 'מאליו', 'האלו', 'שתיים', 'משכורת', 'מנקה', 'אק',
               'ואיזה', 'ידעה', 'התגובה', 'הלילה', 'ופשוט', 'גל', 'בפועל', 'במילים', 'קשיים', 'מאמץ', 'היותר', 'אדע',
               'מניח', 'סאקל', 'צורה', 'הביא', 'דואגת', 'בגדים', 'הפריע', 'תן', 'נפגשים', 'אחזור', 'רופא', 'דם',
               'מהחיים', 'יעבור', 'שזו', 'הבנה', 'שלמה', 'מעורר', 'כתב', 'הרגע', 'מורכב', 'להצליח', 'לחברה', 'רם',
               'האישה', 'חום', 'כושר', 'אחות', 'ועשיתי', 'נמשיך', 'בקבוצה', 'היחידה', 'יצאה', 'מתה', 'לפתור', 'מקבלים',
               'תחשבי', 'כזקל', 'ביניהם', 'הגדולה', 'גן', 'האפשרות', 'לגרום', 'להאמין', 'לחול', 'מעדיף', 'היתי',
               'בוודאי', 'קיבלה', 'נפשית', 'לרדת', 'כתוב', 'ודווקא', 'זאתי', 'כיתה', 'מקצוע', 'ואפילו', 'נפגשנו',
               'בימים', 'אנרגיות', 'להעלות', 'סבא', 'לאלא', 'ברמת', 'עוברים', 'בדירה', 'בעייתי', 'לשלוח', 'להחליף',
               'לאומי', 'גבוהה', 'הבוס', 'חג', 'המילים', 'ונראה', 'שסיפרת', 'הרעיון', 'לשתות', 'רי', 'אחלה', 'לילה',
               'שאז', 'שבאתי', 'מגעיל', 'לשום', 'ואנשים', 'להשתמש', 'פנוי', 'שומרת', 'שראיתי', 'קשות', 'שניים', 'וללכת',
               'ואיפה', 'ביחס', 'גרים', 'הצלחת', 'מאה', 'החרדה', 'מחיר', 'לכעוס', 'אצא', 'ההיא', 'ניתוח', 'תלכי',
               'להזמין', 'מתח', 'הסדר', 'בלאגן', 'הפסקה', 'לעוד', 'תוכל', 'נקודות', 'בכמה', 'מנסים', 'הבינה', 'שמגיע',
               'נמוך', 'הספקתי', 'הקטן', 'הפסקתי', 'משרד', 'מקרים', 'והרגשתי', 'להכיל', 'עת', 'ובעצם', 'וממש', 'למעשה',
               'נדמה', 'הרגל', 'כשהם', 'שעושה', 'עיניים', 'שונאת', 'הרגש', 'הטוב', 'הבין', 'השתנה', 'כולנו', 'חכם',
               'יגיע', 'שבן', 'שהתחלתי', 'וXXX', 'אביא', 'אשתי', 'סיפורים', 'שיעור', 'נמצאים', 'דרכים', 'לברוח', 'בכיף',
               'שמע', 'כרגיל', 'וכולם', 'למלא', 'הביטחון', 'שומר', 'ההתנהגות', 'חברתית', 'אספר', 'להתנהג', 'ביני',
               'עמוק', 'האחריות', 'ככל', 'המחלה', 'לידה', 'שאפילו', 'הצליח', 'בעלה', 'שכר', 'דוחה', 'באת', 'שחשוב',
               'שבכלל', 'ואמר', 'רעיון', 'ספרים', 'הגעת', 'להשקיע', 'שקשור', 'גיחוך', 'המנהלת', 'ישבנו', 'לסבול',
               'חלקים', 'קיבלת', 'בזמנו', 'מבחן', 'תחשוב', 'החתונה', 'השעה', 'לצד', 'המחשב', 'שיהיו', 'כדור', 'הלוואי',
               'חרא', 'רגשי', 'מתאימה', 'חוזרים', 'עבדה', 'שלפני', 'ברקע', 'כותב', 'תמונות', 'טעם', 'הרופא', 'רעש',
               'ללא', 'מסתבר', 'שעם', 'לתפוס', 'ירד', 'תופס', 'ברוך', 'נשארתי', 'חשובה', 'תרצה', 'המטופלת', 'עוזב',
               'ביי', 'מצטערת', 'שדברים', 'לתאר', 'אשתו', 'מושלם', 'נקי', 'לסמוך', 'מחלה', 'מקסימום', 'מתמודד', 'להרים',
               'נפטרה', 'הבחורה', 'העניינים', 'נהנית', 'ואמרת', 'להזיז', 'קבוע', 'הכלים', 'מגניב', 'אוטו', 'והלכתי',
               'נזכרתי', 'סופר', 'מתנה', 'נופל', 'תקשורת', 'בהמשך', 'ואמרה', 'לשכנע', 'חסרת', 'מרשה', 'ויום', 'ביטוח',
               'שטוב', 'פגע', 'הקורס', 'להגדיר', 'הבדל', 'נה', 'ויהיה', 'מציק', 'מקצועית', 'עמטכן', 'מעסיק', 'הלכו',
               'הזוגיות', 'התכוונתי', 'תקשיב', 'ידעו', 'ברגל', 'שהגעתי', 'לזכור', 'ששם', 'שאלת', 'אקבל', 'קודמת',
               'רגיש', 'בנאדם', 'הגיעו', 'מסתדרת', 'החינוך', 'ועושה', 'הכוחות', 'מאנשים', 'גבול', 'בתל', 'לאיזשהו',
               'מטרה', 'שבהם', 'הגבולות', 'ארצה', 'מטופל', 'נאנח', 'בטון', 'לתקן', 'ראו', 'בדיעבד', 'עניינים', 'ספציפי',
               'ההתנהלות', 'ולכן', 'ומי', 'טיפוס', 'עצבני', 'עלינו', 'לילד', 'מוותרת', 'פתוחה', 'קן', 'פנימי',
               'בעיקרון', 'עסוק', 'דה', 'מעריך', 'דת', 'ידיים', 'מעיר', 'חשק', 'להשלים', 'שבגלל', 'נובע', 'מוכר',
               'שההורים', 'כשאנחנו', 'ייתן', 'מרגיע', 'אחרונה', 'נושאים', 'לכי', 'תנסה', 'בידיוק', 'משלם', 'ייקח',
               'מסגרת', 'הצבא', 'אחראי', 'שבסוף', 'לחוצה', 'משמעותית', 'ימי', 'תנסי', 'לגיטימי', 'העצמי', 'ניסה',
               'שואלים', 'שקלים', 'חכמה', 'יבואו', 'משאיר']
    Top5000 = ['לא', 'זה', 'אני', 'את', 'כאילו', 'לי', 'מה', 'אז', 'כן', 'אבל', 'גם', 'כל', 'על', 'של', 'הוא', 'היא',
               'שאני', 'היה', 'אה', 'עם', 'כי', 'יש', 'XXX', 'משהו', 'שלי', 'אם', 'אתה', 'יודעת', 'לך', 'או', 'שזה',
               'מאוד', 'יותר', 'רוצה', 'אומרת', 'כזה', 'שהוא', 'וזה', 'ש', 'הזה', 'ו', 'ככה', 'להיות', 'באמת', 'עכשיו',
               'לו', 'איזה', 'לה', 'ואני', 'הייתי', 'אותי', 'טוב', '<NUM>', 'עוד', 'אולי', 'אין', 'יכול', 'דברים',
               'כבר', 'אמרתי', 'איך', 'שהיא', 'הרבה', 'לעשות', 'קצת', 'חושבת', 'יודע', 'ואז', 'ה', 'פעם', 'בסדר', 'ממש',
               'שם', 'כך', 'שאת', 'אומר', 'הם', 'זאת', 'למה', 'נכון', 'אותו', 'אחד', 'צריך', 'כמו', 'עושה', 'פה',
               'הייתה', 'פשוט', 'שלך', 'רק', 'נורא', 'יכולה', 'קשה', 'שאתה', 'צריכה', 'הזמן', 'כמה', 'דבר', 'שיש',
               'להגיד', 'אנחנו', 'ולא', 'שלא', 'מרגישה', 'אנשים', 'היום', 'הזאת', 'וגם', 'רואה', 'חושב', 'האלה',
               'צוחקת', 'אהה', 'יהיה', 'הכל', 'אותך', 'אותה', 'אחרי', 'יום', 'אחר', 'לזה', 'עצמי', 'תמיד', 'נגיד', 'עד',
               'נראה', 'שלו', 'בא', 'לפני', 'אפילו', 'בכלל', 'הדברים', 'ב', 'אממ', 'היו', 'אדם', 'שהם', 'בגלל', 'שלה',
               'אמא', 'מרגיש', 'והוא', 'שני', 'לדבר', 'מיני', 'אמרה', 'והיא', 'בבית', 'אפשר', 'להם', 'ל', 'כאלה', 'בזה',
               'בעצם', 'מקום', 'זמן', 'פתאום', 'אמר', 'אוקיי', 'לפעמים', 'מישהו', 'פחות', 'זהו', 'בדיוק', 'כדי', 'בן',
               'איתו', 'מבינה', 'מזה', 'הכי', 'מי', 'סתם', 'ואת', 'לנו', 'אותם', 'קורה', 'ממ', 'לראות', 'אף', 'בכל',
               'כזאת', 'לעצמי', 'איתה', 'שמה', 'עבודה', 'שכאילו', 'המון', 'אחת', 'ביום', 'ללכת', 'שבוע', 'וכאילו',
               'זוכרת', 'שנה', 'עדיין', 'פעמים', 'רגע', 'דווקא', 'בשביל', 'כנראה', 'שום', 'לבד', 'היית', 'וכל', 'במקום',
               'שהיה', 'מצד', 'מנסה', 'איפה', 'שנים', 'הרגשתי', 'נשמע', 'ברור', 'אחרת', 'בלי', 'איתי', 'עשיתי', 'עצמך',
               'כלום', 'אבא', 'קודם', 'חשוב', 'לחשוב', 'חשבתי', 'הולך', 'אוקי', 'טובה', 'אמ', 'עליו', 'לבוא', 'באה',
               'ויש', 'ומה', 'להבין', 'שגם', 'בעיה', 'בסוף', 'באיזה', 'שאנחנו', 'אי', 'ב<NUM>', 'אחרים', 'בו', 'בצורה',
               'אמרת', 'רציתי', 'עליי', 'לעבוד', 'קרה', 'לקחת', 'הולכת', 'מספיק', 'מעניין', 'בחיים', 'מבין', 'למרות',
               'שוב', 'ביחד', 'הדבר', 'איזשהו', 'אל', 'שהייתי', 'החיים', 'בדרך', 'אתמול', 'שיהיה', 'אליי', 'בין', 'חלק',
               'לתת', 'בטח', 'אוהבת', 'בוא', 'אהמ', 'העבודה', 'כשאני', 'איתך', 'ואתה', 'בארץ', 'מדברת', 'משנה', 'וזהו',
               'בעבודה', 'לגמרי', 'המקום', 'ראיתי', 'תראי', 'אגיד', 'עובד', 'מממ', 'ממני', 'שאם', 'סוג', 'הילדים',
               'השבוע', 'העניין', 'כולם', 'הביתה', 'שאין', 'ואם', 'חברה', 'כסף', 'לצאת', 'די', 'בבוקר', 'להרגיש',
               'עושים', 'יפה', 'להגיע', 'שלנו', 'הבנתי', 'אלא', 'באותו', 'למשל', 'אליו', 'צוחק', 'בתוך', 'האמת',
               'ילדים', 'קשר', 'שלהם', 'כרגע', 'השני', 'מגיע', 'ההורים', 'הממ', 'מדבר', 'איתם', 'לפחות', 'בי', 'שאולי',
               'דרך', 'מין', 'היינו', 'מתי', 'קל', 'אצל', 'אצלי', 'כאן', 'לקבל', 'נעים', 'דיברנו', 'כיף', 'שצריך',
               'זוכר', 'וחצי', 'לב', 'הבית', 'שכן', 'בראש', 'ספר', 'ממה', 'בואי', 'לדעת', 'מול', 'שעה', 'אוכל', 'והם',
               'יצא', 'צריכים', 'הן', 'תהיה', 'אומרים', 'כלל', 'קשור', 'הלכתי', 'יוצא', 'שישי', 'ללמוד', 'באופן',
               'אעשה', 'שכל', 'בית', 'שאלה', 'לאט', 'מכירה', 'ראשון', 'בת', 'אוהב', 'נותן', 'הבן', 'ידעתי', 'עליה',
               'אליה', 'לשם', 'ועוד', 'בטוח', 'לכל', 'ילד', 'מצב', 'הזאתי', 'ואמרתי', 'כלומר', 'וככה', 'מצליחה',
               'שאמרתי', 'שעבר', 'ישר', 'עשה', 'נחמד', 'יקרה', 'חצי', 'הנה', 'לשמוע', 'לעצמך', 'מישהי', 'גדול', 'בשבוע',
               'עניין', 'השאלה', 'שעות', 'כמעט', 'לוקח', 'ימים', 'לגבי', 'עובדת', 'מלא', 'דקות', 'מאד', 'התחלתי',
               'לישון', 'והכל', 'לפה', 'ממנו', 'תחושה', 'אתם', 'להתמודד', 'שבאמת', 'בך', 'בהתחלה', 'ברגע', 'בה', 'ואיך',
               'לנסות', 'רוצים', 'הקטע', 'רע', 'מתאים', 'מדברים', 'מבחינת', 'סוף', 'הבא', 'הרי', 'וואו', 'חברים', 'זו',
               'להביא', 'למצוא', 'שבת', 'בזמן', 'דיברתי', 'המצב', 'אמרו', 'בקטע', 'כמובן', 'מדי', 'טובים', 'שאמרת',
               'לשבת', 'נוח', 'בטוחה', 'לחזור', 'והיה', 'עצמו', 'אהיה', 'בתור', 'בקשר', 'חייבת', 'באיזשהו', 'חיים',
               'ועכשיו', 'שואלת', 'באתי', 'לעזור', 'חוץ', 'אכפת', 'חוסר', 'למקום', 'ממך', 'התחיל', 'מ', 'עליך', 'נכנס',
               'תקופה', 'תגיד', 'תודה', 'הקשר', 'צקצוק', 'להמשיך', 'ואין', 'שומעת', 'חייב', 'זוג', 'לשים', 'להתחיל',
               'בגיל', 'לספר', 'חודשים', 'לזמט', 'האנשים', 'יכולים', 'לשאול', 'במצב', 'מפחיד', 'שקל', 'איזשהי', 'לבית',
               'חמישי', 'מפריע', 'בערב', 'סבבה', 'וואי', 'קטן', 'נמצא', 'התחושה', 'לעבודה', 'עליהם', 'המשפחה', 'ברמה',
               'בשבילי', 'מתחיל', 'שונה', 'הגעתי', 'מכיר', 'שקורה', 'מהר', 'כוח', 'לאיזה', 'במה', 'בעיקר', 'שתי',
               'נניח', 'ילדה', 'ממנה', 'הרגשה', 'להסביר', 'האחרון', 'סיפרתי', 'יכולתי', 'חודש', 'רואים', 'מתוך',
               'והייתי', 'ובאמת', 'לאכול', 'יודעים', 'עבר', 'הרגשת', 'לוקחת', 'עשתה', 'אח', 'עולה', 'חבר', 'הסיפור',
               'לסיים', 'ואולי', 'מבחינתי', 'הבעיה', 'בדברים', 'לעבור', 'סליחה', 'מקווה', 'מהבית', 'שמחה', 'באמצע',
               'חברות', 'הטיפול', 'חולים', 'עובר', 'בסופו', 'משפחה', 'מידי', 'חזק', 'מצליח', 'נגמר', 'מחר', 'מגיעה',
               'שאפשר', 'שה', 'לאנשים', 'הדרך', 'ולהגיד', 'שהייתה', 'חסר', 'מעבר', 'שהיו', 'נותנת', 'מעצבן', 'לחיות',
               'כשאת', 'ניסיתי', 'הצלחתי', 'האם', 'תשמעי', 'מכל', 'חולה', 'חדש', 'שלב', 'מוזר', 'יחסית', 'לפי', 'שקרה',
               'מאז', 'שאלתי', 'תוך', 'בעולם', 'נמצאת', 'ואחר', 'להוציא', 'כשאתה', 'שיחה', 'בלילה', 'ועם', 'תגידי',
               'בעיר', 'אחותי', 'תראה', 'טיפול', 'נשאר', 'החברה', 'הראש', 'יאללה', 'לקחתי', 'גדולה', 'בהם', 'יושב',
               'נאנחת', 'להסתכל', 'בוכה', 'כזאתי', 'שהן', 'מבחינה', 'פחד', 'ופתאום', 'הגיע', 'קיבלתי', 'עוזר', 'הפגישה',
               'יוצאת', 'חוזר', 'מקבל', 'אישה', 'לחץ', 'טיפה', 'מספר', 'עצמה', 'גורם', 'נהיה', 'שבועיים', 'ועל', 'עשית',
               'מקבלת', 'בחוץ', 'תשמע', 'מאיפה', 'בערך', 'מן', 'עחמט', 'הראשון', 'הבאה', 'מהם', 'להיכנס', 'בעיות',
               'הבת', 'מחשבות', 'מעט', 'צוחקות', 'דירה', 'השנה', 'הולכים', 'שעשיתי', 'מסתכלת', 'שאלות', 'שיכול', 'לאמא',
               'לבין', 'לשנות', 'א', 'שלושה', 'חוזרת', 'נו', 'כשהוא', 'העולם', 'אליך', 'נעשה', 'לקרוא', 'יושבת',
               'שלישי', 'בצד', 'שככה', 'יצאתי', 'יהיו', 'תעשה', 'שווה', 'זתומרת', 'שאנשים', 'ואנחנו', 'בקיצור',
               'ביטחון', 'שמישהו', 'שבו', 'יופי', 'מפחדת', 'בשבילך', 'תלוי', 'מסוגלת', 'שכבר', 'לאן', 'מאשר', 'מקומות',
               'מוכנה', 'השם', 'מאמינה', 'שואל', 'באים', 'לקח', 'במיוחד', 'הלך', 'קטנה', 'בחדר', 'מסתכל', 'קרוב', 'ופה',
               'כואב', 'מתחילה', 'יחסים', 'שנתיים', 'רביעי', 'רוב', 'הראשונה', 'ליד', 'שלוש', 'נתן', 'מסוים', 'בטלפון',
               'הנושא', 'קוראים', 'מוקדם', 'מספרת', 'אמור', 'בנות', 'שהיית', 'הלאה', 'ל<NUM>', 'אותנו', 'נאמט', 'כשהיא',
               'פעמיים', 'שקט', 'אלך', 'בטיפול', 'לדברים', 'הסוף', 'לקנות', 'השיחה', 'מאוחר', 'לנסוע', 'שעכשיו', 'אגב',
               'שדיברנו', 'רצה', 'ערב', 'אלף', 'אותן', 'האחרונה', 'מצחיק', 'למצב', 'ואחרי', 'שניה', 'ראשונה', 'יבוא',
               'לשמור', 'ושם', 'ה<NUM>', 'גמור', 'בעצמי', 'שעברה', 'נכנסת', 'מושג', 'לבדוק', 'עדין', 'מפה', 'וואלה',
               'בינינו', 'טלפון', 'הכסף', 'אליהם', 'תהליך', 'חבל', 'וכן', 'שאמא', 'שמתי', 'שקשה', 'כשהייתי', 'כועסת',
               'אצלך', 'הילד', 'מראש', 'קטע', 'שמאוד', 'מחשבה', 'מקרה', 'בפנים', 'לחפש', 'חוויה', 'תעשי', 'זתאומרת',
               'חזרה', 'מאמין', 'רצתה', 'דודה', 'המחשבות', 'לפתוח', 'הזו', 'הגיוני', 'סביב', 'פגישה', 'עשו', 'לקום',
               'כתבתי', 'מצחקקת', 'לכתוב', 'בתקופה', 'ולמה', 'בכיתה', 'אשמה', 'שלום', 'מוכן', 'בחורה', 'יחד', 'השנים',
               'עובדים', 'המחשבה', 'מצפה', 'הפעם', 'קול', 'ומצד', 'סיטואציה', 'כללי', 'לבן', 'אחורה', 'הקודמת', 'שמשהו',
               'עלייך', 'סיפור', 'שינוי', 'משם', 'הצד', 'החוצה', 'אחריות', 'עזרה', 'שמעתי', 'חי', 'מהעבודה', 'חרדה',
               'יל', 'להישאר', 'למשהו', 'יעשה', 'קשים', 'מתקשר', 'עבדתי', 'אתן', 'מסוימת', 'לשלם', 'הפחד', 'לקרות',
               'רגיל', 'מפחד', 'במובן', 'אצטרך', 'נתתי', 'ראש', 'אצלה', 'שהכל', 'אצלו', 'מלחיץ', 'כלפי', 'באותה',
               'חופש', 'רצון', 'הולדת', 'שיותר', 'דיי', 'אבוא', 'שומע', 'הלימודים', 'מילה', 'זוגיות', 'ממקום', 'אלי',
               'אחי', 'כעס', 'גיל', 'שמח', 'וכמה', 'צורך', 'סיבה', 'משמעותי', 'הXXX', 'אלה', 'חזרתי', 'בעניין', 'אחוז',
               'התחילה', 'עברתי', 'שליטה', 'לכם', 'כשזה', 'שנייה', 'למישהו', 'תשובה', 'למדתי', 'מביא', 'בשם', 'אמורה',
               'טבעי', 'עלה', 'יזקלכן', 'עלי', 'בעבר', 'עונה', 'בשבת', 'גבוה', 'רחוק', 'לעמוד', 'בוקר', 'מחכה', 'אצלנו',
               'במקרה', 'להכיר', 'בפגישה', 'הסיטואציה', 'טובות', 'איכשהו', 'להראות', 'עדיף', 'בפעם', 'תבוא', 'אחרות',
               'לטיפול', 'האחרונות', 'אפשרות', 'משפט', 'ההרגשה', 'החלטה', 'דין', 'שנקרא', 'לדעתי', 'מחפשת', 'מדיי',
               'לקראת', 'צריכות', 'מוצאת', 'מניחה', 'מסוגל', 'גרוע', 'נושא', 'יכולת', 'ביקורת', 'יומיים', 'יגיד', 'גרה',
               'פגישות', 'שבעצם', 'הבנות', 'אופן', 'להעביר', 'פיזית', 'המטפלת', 'מתכוונת', 'בינתיים', 'בתחום', 'חושבים',
               'שטויות', 'לבקש', 'קטנים', 'נראית', 'לטפל', 'מובן', 'רגשות', 'נקרא', 'בשנה', 'ספק', 'החלק', 'חזקה',
               'ולפעמים', 'ברירה', 'לעזוב', 'ישבתי', 'ובסוף', 'מראה', 'ויותר', 'בהקשר', 'לידי', 'שתהיה', 'שבא', 'מטפלת',
               'יעזור', 'נדבר', 'ידע', 'חודשיים', 'מביאה', 'עצוב', 'חווה', 'אהבה', 'אוי', 'שלומך', 'בגדול', 'מחדש',
               'המילה', 'והיום', 'הקול', 'הגוף', 'התפקיד', 'הרגיש', 'קפה', 'הודעה', 'תוהה', 'עייפה', 'לוותר', 'מעדיפה',
               'בחור', 'מחפש', 'נכנסתי', 'בעיניי', 'שבועות', 'רת', 'נוסעת', 'בסך', 'מדהים', 'החוויה', 'רצית', 'חיה',
               'עומד', 'הלא', 'כדאי', 'מוצא', 'לענות', 'מעלה', 'ולעשות', 'בני', 'דיברת', 'מצאתי', 'ין', 'רוח', 'להתקשר',
               'היי', 'מתחבר', 'נתנה', 'המציאות', 'לסדר', 'שXXX', 'להכניס', 'איתן', 'קמה', 'התקשרתי', 'בלשון', 'לומר',
               'סך', 'קיים', 'הדירה', 'להתעסק', 'הפוך', 'אמנם', 'ארגיש', 'ואומר', 'לגור', 'ומאוד', 'לאורך', 'הלכה',
               'חשבון', 'אמיתי', 'היכולת', 'קוראת', 'כוחות', 'מתקשרת', 'דומה', 'סדר', 'החלטתי', 'לבחור', 'גרם', 'הקושי',
               'מורה', 'ואמא', 'אביב', 'מתארת', 'עזר', 'לילדים', 'מהמקום', 'להן', 'וכאלה', 'מזמן', 'נשים', 'שזאת',
               'קושי', 'הטלפון', 'האחרונים', 'מילים', 'עשינו', 'כח', 'אראה', 'לעצור', 'להחליט', 'מעולה', 'לאו', 'ורק',
               'מהצד', 'מ<NUM>', 'חדר', 'עוברת', 'וה', 'הגדול', 'הרצון', 'איש', 'ומשהו', 'חם', 'ישנה', 'במהלך', 'ועד',
               'התהליך', 'אצליח', 'נקודה', 'יואו', 'צודקת', 'בנוח', 'בהרבה', 'שרציתי', 'בעצמך', 'לומדת', 'כש', 'שלם',
               'מנהל', 'סיפרת', 'חדשה', 'שלפעמים', 'נותנים', 'תחושות', 'אהבתי', 'עצם', 'האוטו', 'לומד', 'במשהו',
               'יכולות', 'תואר', 'לכאן', 'אסור', 'מסתדר', 'מים', 'ננסה', 'לנקות', 'פתוח', 'אר', 'מזל', 'פי', 'בקול',
               'משפיע', 'לתוך', 'חזר', 'שעתיים', 'קמתי', 'כאב', 'סיכוי', 'המשפט', 'הספר', 'רבה', 'ויכול', 'שעוד',
               'אפשרי', 'שיחות', 'חן', 'דיברה', 'קורס', 'מסוימים', 'מודע', 'ולהיות', 'קונה', 'ליצור', 'לעניין',
               'בסיטואציה', 'מדברות', 'לרצות', 'גר', 'בהכרח', 'גבר', 'כלים', 'תקשיבי', 'עי', 'היחסים', 'לדאוג', 'נסעתי',
               'בעלי', 'תפקיד', 'לחוץ', 'סבתא', 'קדימה', 'סאמט', 'להחזיק', 'לשתף', 'הבאתי', 'ובגלל', 'כתבה', 'באו',
               'סרט', 'מבאס', 'כביכול', 'בקושי', 'חמש', 'הופך', 'לפגוע', 'לבכות', 'בלחץ', 'בשום', 'אמרנו', 'מגיעים',
               'החוסר', 'רגילה', 'ולראות', 'עשרה', 'דמטכן', 'סיפרה', 'הילדה', 'שאי', 'בחודש', 'בלתי', 'שכולם', 'בצבא',
               'ושאני', 'ספציפית', 'ודברים', 'עיר', 'שאומרים', 'מתאר', 'מיוחד', 'להכנס', 'הלב', 'צעיר', 'משמעות',
               'דוגמא', 'נשארת', 'דיבר', 'הרגשות', 'כשיש', 'סבלנות', 'שפשוט', 'הלכנו', 'הכוונה', 'דוגמה', 'עייף',
               'בעוד', 'מסביב', 'בתחילת', 'מיד', 'התקשרה', 'החברים', 'במקומות', 'עבד', 'אוכלת', 'במשך', 'מגחכת',
               'המטרה', 'פוגע', 'שתמיד', 'למי', 'בשעה', 'לשחרר', 'לימודים', 'שי', 'מזכיר', 'יושבים', 'הזדמנות', 'הצורך',
               'קם', 'למחרת', 'חשבת', 'נעימה', 'חד', 'אקח', 'הסיבה', 'להכין', 'התחושות', 'רגשית', 'משתעלת', 'לפגוש',
               'שאבא', 'להוריד', 'לכולם', 'הגיעה', 'המקומות', 'הורים', 'הדלת', 'נתנו', 'ראתה', 'לחכות', 'בXXX', 'לאבא',
               'מאיזה', 'מתחילים', 'החדר', 'לחלוטין', 'לשני', 'בלימודים', 'ההוא', 'במשרד', 'לחדר', 'שפתאום', 'כועס',
               'ליום', 'מבקשת', 'עברה', 'מעצמי', 'אן', 'אופציה', 'והיו', 'ראית', 'הלחץ', 'מוציא', 'לבמט', 'בריא',
               'התחילו', 'קבוצה', 'מגיל', 'פסח', 'להיפגש', 'נפטר', 'עומדת', 'איזושהי', 'אגיע', 'כותבת', 'היחיד',
               'שהרבה', 'ותמיד', 'וכבר', 'שנורא', 'אוהבים', 'למטה', 'ביקשתי', 'שאל', 'איתנו', 'מהדברים', 'ושוב', 'דקה',
               'שניהם', 'מבחינתך', 'ארוך', 'משחק', 'להפסיק', 'שאתם', 'נמאס', 'שהיום', 'עבודות', 'ראה', 'לרופא', 'פוחדת',
               'שחשבתי', 'שאף', 'בעיני', 'בנושא', 'יוצאים', 'צעד', 'תכלס', 'הפנים', 'היתה', 'שעשית', 'האמא', 'לנהל',
               'אישי', 'לקחה', 'פחדתי', 'להשיג', 'מסכימה', 'להתקדם', 'עזבי', 'במיטה', 'לסגור', 'להחזיר', 'ואומרת',
               'שינה', 'התקשר', 'שנגיד', 'מטפל', 'מערכת', 'תהיי', 'וכו', 'הכבוד', 'ונורא', 'להשאיר', 'שונים', 'ממשיך',
               'ועדיין', 'שהיינו', 'מרוצה', 'אלייך', 'קורא', 'הגב', 'XXXX', 'לעיר', 'גבולות', 'כלכלית', 'לעלות',
               'פעולה', 'בהחלט', 'לXXX', 'קצר', 'בעל', 'בשקט', 'דורש', 'להסתדר', 'רגעים', 'טה', 'מתסכל', 'כיוון',
               'קשרים', 'קניתי', 'קראתי', 'אשמח', 'למקומות', 'מחוץ', 'מאחורי', 'טלוויזיה', 'שסיפרתי', 'מכירים',
               'וראיתי', 'שממש', 'נחמדה', 'ממשיכה', 'כדורים', 'להורים', 'השולחן', 'האוכל', 'לבנות', 'מותר', 'ספורט',
               'דוד', 'השנייה', 'לעצמו', 'בחברה', 'שפה', 'רגש', 'הסתם', 'טעות', 'החברות', 'שלכם', 'בשבילו', 'משתדלת',
               'והרבה', 'החודש', 'בחירה', 'צודק', 'אדבר', 'נלך', 'עסוקה', 'צעירה', 'והייתה', 'נוסע', 'וצריך', 'שעושים',
               'העובדה', 'ניסיון', 'בשלב', 'מסודר', 'הבעיות', 'איזו', 'שיקרה', 'עולם', 'תמונה', 'מודעת', 'שפעם',
               'לכיוון', 'מעל', 'המורה', 'אנסה', 'הנקודה', 'לאף', 'סיפר', 'שהרגשתי', 'נפש', 'העיניים', 'ואף', 'נהנה',
               'לכן', 'סיטואציות', 'רגוע', 'גדולים', 'פנים', 'יגידו', 'בלה', 'אוויר', 'ביטוי', 'רצו', 'התחלנו', 'נגד',
               'בזוגיות', 'גברים', 'יה', 'לעולם', 'החבר', 'בתחושה', 'שדווקא', 'עוזרת', 'להיפך', 'בפני', 'ישנתי',
               'מתכוון', 'כ', 'לארץ', 'לבקר', 'תקווה', 'מבינים', 'שבה', 'משעמם', 'ארוחת', 'תקופות', 'שלחתי', 'כמוני',
               'האחרים', 'שאומר', 'נכונה', 'יראה', 'ההחלטה', 'חדשים', 'תחושת', 'ובכל', 'מתחת', 'לנוח', 'דקלכן', 'ושל',
               'התקופה', 'אירוע', 'נורמלי', 'חיובי', 'מבוגר', 'השאלות', 'לפנות', 'התשובה', 'הסתכלתי', 'למעלה', 'מסכים',
               'השניה', 'צד', 'במשפחה', 'הבנת', 'ואבא', 'אתחיל', 'וכזה', 'לוקחים', 'עס', 'שכחתי', 'שקצת', 'קיבל',
               'להתחבר', 'המערכת', 'מטריד', 'אלינו', 'בכוונה', 'בשבילה', 'שרק', 'לרגע', 'רבע', 'מצוין', 'נוסעים',
               'מרוב', 'טועה', 'קר', 'תלך', 'מצבים', 'ישן', 'ושזה', 'סיימתי', 'רציני', 'ארבע', 'להשאר', 'אמצא', 'שהכי',
               'יד', 'כזו', 'להקשיב', 'מת', 'ברחוב', 'שאחרי', 'בחזרה', 'בעיניים', 'הנכון', 'המנהל', 'הקטנה', 'אנרגיה',
               'הקודם', 'איפשהו', 'התחלת', 'סגור', 'במידה', 'עצמם', 'וקצת', 'ערך', 'יוצר', 'ולדבר', 'מל', 'לשחק',
               'לעומת', 'הבחור', 'גי', 'מהבחינה', 'מבחוץ', 'לגעת', 'בשיחה', 'צוחקים', 'הגענו', 'כבד', 'ארוכה', 'לחיים',
               'חייבים', 'בפייסבוק', 'אישית', 'מרגישים', 'שדיברתי', 'הכעס', 'עובדה', 'הסביבה', 'עברו', 'הכרתי', 'בקלות',
               'האחים', 'תחום', 'תבואי', 'לזרוק', 'בשנים', 'מכניס', 'מאליו', 'האלו', 'שתיים', 'משכורת', 'מנקה', 'אק',
               'ואיזה', 'ידעה', 'התגובה', 'הלילה', 'ופשוט', 'גל', 'בפועל', 'במילים', 'קשיים', 'מאמץ', 'היותר', 'אדע',
               'מניח', 'סאקל', 'צורה', 'הביא', 'דואגת', 'בגדים', 'הפריע', 'תן', 'נפגשים', 'אחזור', 'רופא', 'דם',
               'מהחיים', 'יעבור', 'שזו', 'הבנה', 'שלמה', 'מעורר', 'כתב', 'הרגע', 'מורכב', 'להצליח', 'לחברה', 'רם',
               'האישה', 'חום', 'כושר', 'אחות', 'ועשיתי', 'נמשיך', 'בקבוצה', 'היחידה', 'יצאה', 'מתה', 'לפתור', 'מקבלים',
               'תחשבי', 'כזקל', 'ביניהם', 'הגדולה', 'גן', 'האפשרות', 'לגרום', 'להאמין', 'לחול', 'מעדיף', 'היתי',
               'בוודאי', 'קיבלה', 'נפשית', 'לרדת', 'כתוב', 'ודווקא', 'זאתי', 'כיתה', 'מקצוע', 'ואפילו', 'נפגשנו',
               'בימים', 'אנרגיות', 'להעלות', 'סבא', 'לאלא', 'ברמת', 'עוברים', 'בדירה', 'בעייתי', 'לשלוח', 'להחליף',
               'לאומי', 'גבוהה', 'הבוס', 'חג', 'המילים', 'ונראה', 'שסיפרת', 'הרעיון', 'לשתות', 'רי', 'אחלה', 'לילה',
               'שאז', 'שבאתי', 'מגעיל', 'לשום', 'ואנשים', 'להשתמש', 'פנוי', 'שומרת', 'שראיתי', 'קשות', 'שניים', 'וללכת',
               'ואיפה', 'ביחס', 'גרים', 'הצלחת', 'מאה', 'החרדה', 'מחיר', 'לכעוס', 'אצא', 'ההיא', 'ניתוח', 'תלכי',
               'להזמין', 'מתח', 'הסדר', 'בלאגן', 'הפסקה', 'לעוד', 'תוכל', 'נקודות', 'בכמה', 'מנסים', 'הבינה', 'שמגיע',
               'נמוך', 'הספקתי', 'הקטן', 'הפסקתי', 'משרד', 'מקרים', 'והרגשתי', 'להכיל', 'עת', 'ובעצם', 'וממש', 'למעשה',
               'נדמה', 'הרגל', 'כשהם', 'שעושה', 'עיניים', 'שונאת', 'הרגש', 'הטוב', 'הבין', 'השתנה', 'כולנו', 'חכם',
               'יגיע', 'שבן', 'שהתחלתי', 'וXXX', 'אביא', 'אשתי', 'סיפורים', 'שיעור', 'נמצאים', 'דרכים', 'לברוח', 'בכיף',
               'שמע', 'כרגיל', 'וכולם', 'למלא', 'הביטחון', 'שומר', 'ההתנהגות', 'חברתית', 'אספר', 'להתנהג', 'ביני',
               'עמוק', 'האחריות', 'ככל', 'המחלה', 'לידה', 'שאפילו', 'הצליח', 'בעלה', 'שכר', 'דוחה', 'באת', 'שחשוב',
               'שבכלל', 'ואמר', 'רעיון', 'ספרים', 'הגעת', 'להשקיע', 'שקשור', 'גיחוך', 'המנהלת', 'ישבנו', 'לסבול',
               'חלקים', 'קיבלת', 'בזמנו', 'מבחן', 'תחשוב', 'החתונה', 'השעה', 'לצד', 'המחשב', 'שיהיו', 'כדור', 'הלוואי',
               'חרא', 'רגשי', 'מתאימה', 'חוזרים', 'עבדה', 'שלפני', 'ברקע', 'כותב', 'תמונות', 'טעם', 'הרופא', 'רעש',
               'ללא', 'מסתבר', 'שעם', 'לתפוס', 'ירד', 'תופס', 'ברוך', 'נשארתי', 'חשובה', 'תרצה', 'המטופלת', 'עוזב',
               'ביי', 'מצטערת', 'שדברים', 'לתאר', 'אשתו', 'מושלם', 'נקי', 'לסמוך', 'מחלה', 'מקסימום', 'מתמודד', 'להרים',
               'נפטרה', 'הבחורה', 'העניינים', 'נהנית', 'ואמרת', 'להזיז', 'קבוע', 'הכלים', 'מגניב', 'אוטו', 'והלכתי',
               'נזכרתי', 'סופר', 'מתנה', 'נופל', 'תקשורת', 'בהמשך', 'ואמרה', 'לשכנע', 'חסרת', 'מרשה', 'ויום', 'ביטוח',
               'שטוב', 'פגע', 'הקורס', 'להגדיר', 'הבדל', 'נה', 'ויהיה', 'מציק', 'מקצועית', 'עמטכן', 'מעסיק', 'הלכו',
               'הזוגיות', 'התכוונתי', 'תקשיב', 'ידעו', 'ברגל', 'שהגעתי', 'לזכור', 'ששם', 'שאלת', 'אקבל', 'קודמת',
               'רגיש', 'בנאדם', 'הגיעו', 'מסתדרת', 'החינוך', 'ועושה', 'הכוחות', 'מאנשים', 'גבול', 'בתל', 'לאיזשהו',
               'מטרה', 'שבהם', 'הגבולות', 'ארצה', 'מטופל', 'נאנח', 'בטון', 'לתקן', 'ראו', 'בדיעבד', 'עניינים', 'ספציפי',
               'ההתנהלות', 'ולכן', 'ומי', 'טיפוס', 'עצבני', 'עלינו', 'לילד', 'מוותרת', 'פתוחה', 'קן', 'פנימי',
               'בעיקרון', 'עסוק', 'דה', 'מעריך', 'דת', 'ידיים', 'מעיר', 'חשק', 'להשלים', 'שבגלל', 'נובע', 'מוכר',
               'שההורים', 'כשאנחנו', 'ייתן', 'מרגיע', 'אחרונה', 'נושאים', 'לכי', 'תנסה', 'בידיוק', 'משלם', 'ייקח',
               'מסגרת', 'הצבא', 'אחראי', 'שבסוף', 'לחוצה', 'משמעותית', 'ימי', 'תנסי', 'לגיטימי', 'העצמי', 'ניסה',
               'שואלים', 'שקלים', 'חכמה', 'יבואו', 'משאיר', 'טל', 'דואג', 'איזשהוא', 'עשרים', 'נכנסה', 'מוציאה',
               'סיבות', 'הפך', 'בגן', 'שעברתי', 'הרגליים', 'מלווה', 'מב', 'מבקש', 'עזוב', 'לפתח', 'נתחיל', 'השיחות',
               'ייצא', 'מטורף', 'באזור', 'להרגיע', 'פשוטה', 'בחול', 'עשר', 'להתחתן', 'חשובים', 'ואי', 'משתנה', 'חלש',
               'בגוף', 'באוטו', 'באוטובוס', 'הקבוצה', 'תרופות', 'שיצאתי', 'מוריד', 'הגיל', 'רלוונטי', 'שפחות', 'חופשי',
               'מסויים', 'לטייל', 'מפגש', 'שמונה', 'דיברו', 'מלאה', 'ת', 'לברר', 'בסלון', 'אילן', 'הטובים', 'כולל',
               'נאמר', 'חשש', 'ברמות', 'חוויות', 'בלב', 'באוניברסיטה', 'עמוס', 'לעצמה', 'דיבור', 'עצמית', 'במציאות',
               'לריב', 'מכתב', 'ידי', 'מעריכה', 'לכמה', 'רמה', 'לר', 'מידה', 'רן', 'וב', 'שהלכתי', 'סביר', 'דעתי',
               'להתקרב', 'לדמיין', 'עושות', 'הלכת', 'לרוץ', 'יורד', 'התמונה', 'להוכיח', 'מיליון', 'עניתי', 'הכלב',
               'שהרגשת', 'סוציאלית', 'קורים', 'להציע', 'מחזיק', 'תוכלי', 'ללמד', 'סיום', 'הפגישות', 'כמשהו', 'להגיש',
               'תרגיש', 'טיול', 'במרכז', 'פרטי', 'מתמודדת', 'הקשיים', 'סובלת', 'עצובה', 'למיטה', 'פותח', 'קיצור',
               'אשאל', 'לפחד', 'בנים', 'בחרתי', 'לדוגמא', 'מנהלת', 'במסגרת', 'מסתכלים', 'השינוי', 'שחור', 'הערב',
               'נוכל', 'להרבה', 'הימים', 'בעצמו', 'שנראה', 'באינטרנט', 'וכנראה', 'תור', 'לראש', 'נגקל', 'לקחו',
               'בסביבה', 'שעולה', 'ברורה', 'תשובות', 'כלפיי', 'הבוקר', 'קרובים', 'ט', 'באף', 'דמות', 'ודיברנו',
               'שהדברים', 'מאפשר', 'שרוצה', 'פנימה', 'הסתדר', 'דיכאון', 'אחים', 'שעבדתי', 'וזאת', 'התנהגות', 'קיצוני',
               'הקטנים', 'היד', 'בוחר', 'מתחברת', 'תסכול', 'סומכת', 'אצלם', 'ו<NUM>', 'מחזיר', 'המחיר', 'מולי', 'נהדר',
               'ניסתה', 'השעות', 'העיקר', 'והן', 'לאחרים', 'סימן', 'גאה', 'כאלו', 'משתדל', 'תשומת', 'הבחירה', 'שיעורים',
               'בוחרת', 'החלטות', 'נחשוב', 'אימון', 'הצדדים', 'מקודם', 'צהרים', 'סגורה', 'נסענו', 'ישב', 'כעסתי',
               'והיינו', 'בשעות', 'משרה', 'הליכה', 'שלח', 'בר', 'וחלילה', 'ההבדל', 'תינוק', 'נפל', 'רגישה', 'למשרד',
               'שקיבלתי', 'מושכת', 'בקיץ', 'חוששת', 'ארבעה', 'באנשים', 'שלחה', 'ביקש', 'עצבים', 'עזבתי', 'הילדות',
               'פער', 'שותה', 'יראו', 'יכלה', 'הטלוויזיה', 'התואר', 'וש', 'לאחר', 'הביאה', 'ופחות', 'קו', 'שאר',
               'התעצבנתי', 'חיצוני', 'אלוהים', 'מתעסק', 'נוגע', 'מקצועי', 'אמורים', 'לשיחה', 'ביקשה', 'שירות', 'מסכנה',
               'במקביל', 'קרובה', 'לאחרונה', 'מעייף', 'הכוח', 'בכיוון', 'יכלתי', 'שנינו', 'מזקל', 'צחוק', 'ואפשר',
               'תביא', 'פגשתי', 'רשמתי', 'ללימודים', 'אשם', 'בואנה', 'רגועה', 'לומדים', 'רגל', 'ואחד', 'המשכורת',
               'כביסה', 'תחילת', 'תנועה', 'תדע', 'מר', 'המשמעות', 'ניפגש', 'לקשר', 'מבוגרים', 'ופעם', 'תיקח', 'בתהליך',
               'אור', 'לשבוע', 'השאר', 'ומאז', 'ממשהו', 'מטופלת', 'קשורה', 'מאושר', 'ביותר', 'ולי', 'החליט', 'בידיים',
               'תלויה', 'בריאה', 'תופסת', 'נמשך', 'לאותו', 'בשליטה', 'להפוך', 'קלה', 'ממלא', 'החשש', 'אשאר', 'שש',
               'מהן', 'צהריים', 'ליהנות', 'שלהן', 'בדבר', 'התקדמות', 'ליסוע', 'קניות', 'שמים', 'נולד', 'מוטיבציה',
               'מצא', 'מתנהג', 'ביניכם', 'התיק', 'מרחק', 'מדובר', 'מעניינת', 'אכלתי', 'אונים', 'ובכלל', 'הצלחה',
               'ביחסים', 'חוויתי', 'להתנהל', 'אופציות', 'משלמת', 'נסעה', 'מכינה', 'התחלה', 'הזוי', 'שלילי', 'רקע',
               'באיזשהי', 'נכנסים', 'לדירה', 'הנפש', 'קבענו', 'וקשה', 'פותחת', 'מתישהו', 'הבאת', 'מסכן', 'מרגש', 'לחבר',
               'לרוב', 'לקוחות', 'הצרכים', 'צוות', 'בחשבון', 'לקבוע', 'אישור', 'חס', 'לרשום', 'להניח', 'להתייחס',
               'היחידי', 'צדדים', 'לבשל', 'הרצפה', 'משום', 'ממשיכים', 'בדיקות', 'עצבנית', 'הביקורת', 'והכי', 'מיום',
               'החג', 'מצטער', 'ידעת', 'הוצאתי', 'התחתנה', 'שקשורים', 'מסובך', 'הכאב', 'נתת', 'קשורים', 'העסק', 'מושך',
               'דן', 'לחוות', 'נפגע', 'כבוד', 'עזב', 'לנשום', 'גישה', 'בטחון', 'אחשוב', 'חמוד', 'זורק', 'קולות', 'באסה',
               'מצליחים', 'הכדורים', 'מטומטם', 'בתיכון', 'להפגש', 'חשבה', 'מבית', 'עסק', 'מתעסקת', 'נפשי', 'חתונה',
               'כוס', 'פתחתי', 'מחפשים', 'אסע', 'המבחן', 'הקלה', 'בעקבות', 'לצערי', 'שקורים', 'פתח', 'העובדת', 'מזהה',
               'חיכיתי', 'המים', 'וכשאני', 'לפגישה', 'מכות', 'הסיבות', 'מהעניין', 'לחודש', 'שאלו', 'לבת', 'לשלוט',
               'שמפריע', 'חדשות', 'בצהריים', 'בבנק', 'האופציה', 'חיפשתי', 'בדיכאון', 'חלום', 'בשוק', 'הכנסה', 'כישלון',
               'בשני', 'תמיכה', 'תוכנית', 'עצמאי', 'משתמשת', 'מתעצבנת', 'ואתמול', 'נפגשתי', 'אימא', 'דפוק', 'שבע',
               'בסיס', 'שינויים', 'חברת', 'שמעי', 'פסיכולוגית', 'מחליטה', 'אכזבה', 'בעתיד', 'מכה', 'במחשב', 'במשקל',
               'מכחכחת', 'רץ', 'מסויימת', 'קיצר', 'כזקלכן', 'נאקל', 'נשואה', 'משחקים', 'שמעת', 'מקסים', 'וביום',
               'ברגעים', 'אמשיך', 'שולח', 'שאלון', 'השאלון', 'יכל', 'מקובל', 'גדולות', 'עצמאית', 'לדוגמה', 'תיק',
               'זקוקה', 'צעירים', 'שונות', 'תכף', 'תני', 'יציב', 'תרצי', 'שמצד', 'איבדתי', 'מאמא', 'החלום', 'הפער',
               'למשפחה', 'בונה', 'אוף', 'שהילדים', 'אירועים', 'מוזיקה', 'הסרט', 'ציפיתי', 'מוות', 'גב', 'כלכלי',
               'מהמשפחה', 'והנה', 'בחורות', 'מפגשים', 'הנסיעה', 'פרידה', 'לצעוק', 'מלכתחילה', 'משפטים', 'נזכרת', 'סרטן',
               'בקיבוץ', 'אוכלים', 'לצורך', 'ביד', 'ירצה', 'להסתיר', 'לפעול', 'מספרים', 'במערכת', 'אשב', 'קיימת',
               'נסיעה', 'יילך', 'יוכל', 'האדם', 'אחותה', 'לסרט', 'מעניינים', 'מתנהגת', 'השבת', 'וחשבתי', 'נוחות',
               'טעויות', 'גיסתי', 'שהבן', 'יולי', 'פיזי', 'ניתן', 'הכלכלי', 'לצפות', 'אישיות', 'עמדה', 'נפתח', 'ציון',
               'סובל', 'וואללה', 'לשירותים', 'המדינה', 'עברנו', 'מתעצבן', 'רכב', 'חשב', 'ענתה', 'בשבועיים', 'עומס',
               'סרטים', 'פשוטים', 'אמירה', 'תגובה', 'במחשבה', 'הערכה', 'להגן', 'ליפול', 'חושש', 'הכדור', 'אחראית',
               'קטנות', 'לשלב', 'שמחתי', 'רושם', 'שילמתי', 'זר', 'כאבים', 'נוראי', 'מתיש', 'הניתוח', 'בבר', 'ושהוא',
               'שהולך', 'היכולות', 'מציאות', 'החליטה', 'מסוכן', 'משמח', 'סר', 'דל', 'נוסף', 'הכנתי', 'לארגן', 'מעגל',
               'ושהיא', 'שגרה', 'פוגשת', 'סיוט', 'שעד', 'להתגבר', 'ולפני', 'נחזור', 'מחליט', 'המשחק', 'וברגע', 'לאחותי',
               'בחוויה', 'שירה', 'למדה', 'הצהריים', 'העצמאות', 'להשפיע', 'מבוגרת', 'בפגישות', 'תחת', 'ציפיות', 'המקרה',
               'מלחמה', 'נסגר', 'להנות', 'בריאות', 'התחום', 'קיבלו', 'יצאנו', 'הנכונה', 'מעמד', 'דתי', 'מכניסה', 'יקר',
               'הבעל', 'סגרתי', 'נשמעת', 'תדעי', 'וחלק', 'לשנה', 'המוח', 'שאמרו', 'יחזור', 'מדהימה', 'למות', 'סוקל',
               'משקל', 'מסודרת', 'וטוב', 'הרגישה', 'בעצמה', 'למסקנה', 'לאבד', 'בבקשה', 'קחי', 'בחופש', 'טיפולים',
               'מסתובב', 'השיעור', 'האבא', 'משמרת', 'אתכם', 'החדש', 'מגחך', 'מפתיע', 'רונית', 'להתנתק', 'הביאו',
               'מזכירה', 'תל', 'מודה', 'שכרגע', 'נוצר', 'מסתדרים', 'אפשרויות', 'אבדוק', 'גורמים', 'אתקשר', 'שעובר',
               'בתפקיד', 'רבים', 'בכוח', 'אוטובוס', 'ובטח', 'במצבים', 'מרגיז', 'יעלה', 'פגיעה', 'ולהבין', 'בשיעור',
               'הדיבור', 'בהרגשה', 'באנגלית', 'החלקים', 'מוקל', 'גדלתי', 'חינוך', 'ושאת', 'מתייחס', 'שמת', 'השלב',
               'נתפס', 'והתחלתי', 'מצחקק', 'חומר', 'אווירה', 'נקודת', 'חיבור', 'הסברתי', 'גט', 'מפעם', 'ובלי', 'השכר',
               'לקפוץ', 'אמצע', 'תחזור', 'שיעורי', 'לעשן', 'שמעניין', 'צי', 'כולה', 'מוותר', 'לים', 'שיבוא', 'פייר',
               'השפיע', 'עין', 'התרופות', 'עליהן', 'שהבנתי', 'מלון', 'אשים', 'מייל', 'ובין', 'מעצמך', 'שף', 'אעבוד',
               'צועקת', 'לקדם', 'שלמדתי', 'להגיב', 'שברגע', 'תשאלי', 'הגנה', 'אמת', 'תספר', 'יזקלנכון', 'המשכתי',
               'פסיכולוגי', 'ליותר', 'להספיק', 'מס', 'פועל', 'קילו', 'ורציתי', 'כשלא', 'שיכולים', 'המטפל', 'העין',
               'ענה', 'זיכרון', 'עוצר', 'מהצבא', 'מקשיבה', 'סומך', 'כןכן', 'תיארת', 'בילדות', 'אנגלית', 'מהסוג', 'אופי',
               'מטפלים', 'זז', 'לאסוף', 'משאירה', 'משלמים', 'המיטה', 'קשב', 'יצאת', 'קבעתי', 'שנעשה', 'מאמן', 'מקשיב',
               'בסיטואציות', 'קולט', 'עולים', 'ח', 'הידיים', 'לכיתה', 'להשתחרר', 'הגישה', 'שהחיים', 'תקבל', 'החופש',
               'עצמנו', 'חשבונות', 'מפני', 'מזגן', 'מסיימת', 'שדיברת', 'תקוע', 'בגרונה', 'ישראל', 'משתעל', 'מולו',
               'לצחוק', 'לקל', 'האופי', 'מהיום', 'שיום', 'יסתדר', 'מסתובבת', 'הסוציאלית', 'הכיוון', 'וישר', 'יעשו',
               'יצאו', 'הגבול', 'מבפנים', 'להתעצבן', 'האשמה', 'האחר', 'במחשבות', 'האח', 'הפה', 'דחוף', 'מרחב', 'להתעלם',
               'להעיר', 'מאיתנו', 'וסתם', 'בשישי', 'שכזה', 'נפגעת', 'להיזכר', 'טעים', 'חמודה', 'נהניתי', 'השקט', 'לגדל',
               'לתפקד', 'שכנראה', 'תחומים', 'בסגנון', 'ולנסות', 'ירדתי', 'בכיתי', 'להסתובב', 'לשפר', 'חה', 'מתקדם',
               'מחשב', 'תרגישי', 'כנסת', 'בצהרים', 'בישיבה', 'שלחו', 'ים', 'סכום', 'רב', 'תגיע', 'מציעה', 'להזכיר',
               'רמת', 'שולחת', 'התמודדות', 'יחס', 'בסביבות', 'להתאים', 'והילדים', 'דייט', 'פסיכולוג', 'להציג', 'המזגן',
               'וקל', 'עיצבן', 'שרצית', 'מודעות', 'הפעמים', 'מקל', 'אישיים', 'כולי', 'מבחנים', 'חיובית', 'עוזרים',
               'נעלם', 'מערכות', 'וכמובן', 'בואו', 'לדחות', 'עומדים', 'החומר', 'חיי', 'להילחם', 'לאהוב', 'שאחד',
               'נסיון', 'שיניים', 'שנדבר', 'ילך', 'שלושים', 'תקועה', 'קבוצות', 'ולחשוב', 'שעדיין', 'שהמצב', 'המפגש',
               'מהזמן', 'העתיד', 'צבא', 'תוכניות', 'חשיבה', 'השטויות', 'כלב', 'משתף', 'האירוע', 'עבורך', 'תלמידים',
               'תצטרך', 'בהן', 'פעילות', 'בנקודה', 'אמונה', 'נראים', 'עייפות', 'משימה', 'שלשום', 'למכור', 'בורחת',
               'רצינית', 'להתמקד', 'תמצא', 'מכאן', 'מעביר', 'מגיבה', 'שייך', 'טלפונים', 'לכאורה', 'למים', 'יי', 'משתמש',
               'וד', 'לפנסיה', 'יחסי', 'בימי', 'ריק', 'מינית', 'שתינו', 'למידה', 'מבלבל', 'להתייעץ', 'והיית', 'עוזבת',
               'רעים', 'הנכדים', 'גיליתי', 'הפנימי', 'שיגידו', 'מעכשיו', 'ג', 'בבת', 'אנחה', 'התאים', 'עברת', 'לחלק',
               'ואמרו', 'חמישה', 'משימות', 'להביע', 'לגשת', 'בנוסף', 'מאיים', 'ושלא', 'ואומרים', 'לייצר', 'לאל',
               'מהתחלה', 'מגלה', 'הפרידה', 'המדריכה', 'שיצא', 'ניקח', 'קלים', 'במטבח', 'דודים', 'תצא', 'שחלק', 'לטיול',
               'למד', 'דוגמאות', 'ידוע', 'פיתרון', 'במישהו', 'תדבר', 'קראו', 'העזרה', 'מהרגע', 'להתארגן', 'משתפת',
               'מכירות', 'נחמדים', 'המה', 'הרגשי', 'משבר', 'הטיול', 'קורות', 'אס', 'לחתונה', 'עליתי', 'נחשב', 'הקשרים',
               'לנצל', 'בצחוק', 'ליל', 'במין', 'קלטתי', 'הנחה', 'במוח', 'מהמיטה', 'זכות', 'בחצי', 'מביך', 'יחשבו',
               'מרוויח', 'העובדים', 'הזיכרון', 'תתחיל', 'אקנה', 'עובדות', 'מטר', 'מגיב', 'נפגשת', 'מסוימות', 'כשהיינו',
               'שחזרתי', 'מתעוררת', 'שבכל', 'באיך', 'בכללי', 'לגיל', 'שבסופו', 'הולכות', 'הזמנתי', 'שנשאר', 'התלמידים',
               'חולשה', 'הכיתה', 'המקצוע', 'תעזבי', 'שומעים', 'שאמרנו', 'תהליכים', 'ייגמר', 'ונגיד', 'וניסיתי', 'שמי',
               'איזשהיא', 'סב', 'ילדות', 'ר', 'שמו', 'כרטיס', 'קורסים', 'ההבנה', 'זורקת', 'כמוך', 'הבגדים', 'בסרט',
               'ודיברתי', 'ראינו', 'אמיתית', 'ולאט', 'מסיים', 'שובר', 'להפך', 'חדרים', 'המורים', 'עורך', 'מאותו',
               'מתייחסת', 'נפגש', 'מזמינה', 'מקנאה', 'בינך', 'תפסתי', 'אסביר', 'הקשה', 'שחסר', 'חזרו', 'להיפרד',
               'במרכאות', 'להירדם', 'לבקל', 'נשימה', 'ול', 'המוות', 'נסע', 'מתלבטת', 'מביאים', 'לארוחת', 'הצליחה',
               'בודקת', 'רעה', 'זכרתי', 'ובסדר', 'ולתת', 'מאושרת', 'שמן', 'מחובר', 'המספר', 'למשוך', 'התעוררתי',
               'תביני', 'וודאות', 'שיראו', 'בגרון', 'הדרכה', 'מתקשרים', 'שלישית', 'בטלוויזיה', 'הספה', 'שבאים', 'לשכב',
               'בושה', 'בעיניך', 'סבל', 'מסוג', 'לבטל', 'לעומק', 'לבלות', 'זורם', 'לגלות', 'לזוז', 'מהזה', 'לזהות',
               'בדידות', 'הקרוב', 'סיבוב', 'ההיפך', 'ער', 'משגע', 'תביאי', 'משקיעה', 'תעזוב', 'זקוק', 'הראשונים',
               'הראשונות', 'משקיע', 'בקטנה', 'עצרתי', 'משותף', 'אחיות', 'לסוף', 'לגמור', 'מבשלת', 'מקשה', 'שרוצים',
               'רשימה', 'ואל', 'מכעיס', 'תבין', 'כלי', 'באוויר', 'חלשה', 'מחזיקה', 'קנאה', 'חברתי', 'הודעות', 'להשתנות',
               'יישאר', 'מבחינתו', 'אתעצמי', 'חלומות', 'ז', 'עצב', 'נולדה', 'השארתי', 'העבר', 'שתיהן', 'צעדים', 'שיווק',
               'האישיות', 'שיעשה', 'תיתן', 'סוגר', 'ניסית', 'הארץ', 'הבטן', 'מסויימים', 'הסבר', 'להעריך', 'בראשון',
               'לחשוף', 'גורמת', 'במאה', 'עלו', 'אההה', 'רגילים', 'הטובה', 'וזו', 'בנו', 'מעוניינת', 'תקין', 'הפסיק',
               'לפעם', 'הכירה', 'מוצלח', 'נעימות', 'לתכנן', 'ורבע', 'ולהרגיש', 'עמדתי', 'ללחץ', 'לתפקיד', 'לשעה',
               'להתאמץ', 'בודד', 'שר', 'יזמטאוקי', 'י', 'מפתח', 'דאגה', 'חרדות', 'וההורים', 'כשהיית', 'התקף', 'האהבה',
               'שירים', 'שכדאי', 'הרוב', 'חווית', 'הסיפורים', 'שעשינו', 'ההודעה', 'גרועה', 'יורדת', 'החדשה', 'שעובדים',
               'דירות', 'לטלפון', 'לאח', 'צועק', 'תספרי', 'מבולבלת', 'בדיקה', 'נשוי', 'השעון', 'המעבר', 'מנוחה', 'חנות',
               'להרשות', 'הורדתי', 'דף', 'האופציות', 'איזון', 'בארהב', 'והזה', 'שח', 'המקצועי', 'ראיון', 'ספרי', 'צדק',
               'הרב', 'שבר', 'מדמיינת', 'צרות', 'יפים', 'הפסיכולוגית', 'משלי', 'סלט', 'הצעד', 'זמנים', 'משפחתי',
               'כשהיה', 'הרע', 'שאחר', 'ציונים', 'סמים', 'הבריאות', 'שקוראים', 'איזשהם', 'נופלת', 'אמון', 'נוראית',
               'צחקוק', 'יקבל', 'להתרכז', 'לדחוף', 'האוויר', 'העיר', 'מאכזב', 'ישתנה', 'שקרו', 'להפעיל', 'בעין',
               'הבדיקה', 'לתל', 'האישית', 'מהאנשים', 'אופניים', 'שילוב', 'מהכל', 'אבות', 'החשבון', 'בתכלס', 'אפרופו',
               'הכלבה', 'ההתחלה', 'ואמ', 'נעימים', 'מסיבה', 'מונע', 'מאות', 'בחיי', 'יודעות', 'ענק', 'שתביני', 'כנה',
               'משחקת', 'אפס', 'החלטת', 'מידע', 'שגורם', 'ומתי', 'ההפך', 'מעליב', 'והבן', 'האחות', 'פידבק', 'יצר',
               'לדייט', 'משמרות', 'ובא', 'בגרות', 'לקורס', 'בתוכך', 'קצרה', 'ימשיך', 'ויתרתי', 'בירושלים', 'עזבה',
               'פנימית', 'השלישי', 'נשארה', 'חמישים', 'מספיקה', 'לאיבוד', 'בזכות', 'שכשאני', 'מבט', 'בכי', 'הנקודות',
               'שנמצא', 'השובר', 'מסבירה', 'שעובד', 'שיחת', 'מזמין', 'אחותך', 'ובאיזה', 'סיפוק', 'מעריכים', 'טראומה',
               'היחס', 'המרחב', 'לשמה', 'מבחינתה', 'קריטי', 'הכנסת', 'שנוח', 'בחלק', 'הערות', 'בשיחות', 'חשיבות',
               'אוטומטית', 'קופץ', 'לחתום', 'מעולם', 'הבדידות', 'שעשו', 'באופי', 'בחוסר', 'דעת', 'שיר', 'שוכחת',
               'תוצאות', 'פחדים', 'מתנהל', 'שהדבר', 'ליווי', 'רושמת', 'מעצבנת', 'התחברתי', 'נשארים', 'מפגר', 'משחרר',
               'לנקודה', 'מפעיל', 'המאוד', 'בטירוף', 'קח', 'שניות', 'הר', 'למדת', 'שביום', 'מאבדת', 'לבנק', 'נצטרך',
               'ובזה', 'אנוש', 'בחינה', 'בייביסיטר', 'נטייה', 'הלבד', 'במילה', 'שרואים', 'דלת', 'ואחת', 'שבדרך',
               'בהמון', 'וכך', 'האישי', 'מיטה', 'דפוס', 'מצווה', 'נוכח', 'להודות', 'לשאת', 'מזמט', 'יב', 'זמנית',
               'השואה', 'לחתוך', 'למען', 'מצאה', 'פתרון', 'מצויין', 'פרויקט', 'יעבוד', 'פורים', 'ריב', 'הוציא',
               'הפרצוף', 'נטו', 'הקליניקה', 'ושאלתי', 'חיוך', 'גשם', 'זוגי', 'המשרד', 'שהקשר', 'האימון', 'בהיריון',
               'עגמט', 'האחיות', 'קנה', 'משמעותיים', 'הבינו', 'ברורים', 'וכמו', 'התחתנו', 'הזכיר', 'כספים', 'גדל',
               'מילא', 'ממלאת', 'אלמד', 'הצורה', 'אומץ', 'השינה', 'עמוקה', 'אקרא', 'רגישות', 'קטעים', 'אנטי', 'לטוס',
               'הים', 'מכין', 'מפסיק', 'אשכרה', 'המשקל', 'מוכנים', 'בהתאם', 'שיכולתי', 'הקודמות', 'והולכת', 'שולחן',
               'בנק', 'בגילי', 'רווחה', 'כשאין', 'מתביישת', 'השפעה', 'חשבו', 'אכנס', 'בשתי', 'והדבר', 'גבוהים',
               'תירוצים', 'האף', 'גוף', 'התשובות', 'דומים', 'האמנתי', 'משוגע', 'לסיטואציה', 'שיח', 'בכתה', 'לטובה',
               'יתנו', 'האפשרויות', 'חול', 'מהחדר', 'מחכים', 'שאלונים', 'תירוץ', 'מההתחלה', 'חוזה', 'ולקבל', 'שמנה',
               'המכתב', 'מחוברת', 'בעד', 'בשיא', 'ממישהו', 'X', 'להאשים', 'בעמדה', 'התנאים', 'זהזה', 'נפרדות', 'פוגש',
               'עחקל', 'טיפולי', 'חלילה', 'וסבתא', 'יצליח', 'גרתי', 'שצריכים', 'מלמד', 'מזג', 'ללב', 'פנויה', 'כמות',
               'והמון', 'מתעורר', 'הרכב', 'השאיר', 'ישבה', 'אסתדר', 'מתאימים', 'ומנסה', 'ברצינות', 'שניסיתי', 'התוצאה',
               'לידו', 'להוסיף', 'מאחר', 'תחרות', 'שתיארת', 'כדורגל', 'חיבוק', 'חזרנו', 'לחסוך', 'תיכון', 'המשיך',
               'רזה', 'וי', 'להתרחק', 'בתקופות', 'מתבטא', 'מעבירה', 'מאשימה', 'נשואים', 'חזקים', 'עיתון', 'ובדיוק',
               'לתקופה', 'בוינה', 'שהמקום', 'ואחותי', 'בהכל', 'יגרום', 'מהלימודים', 'והולך', 'נמוכה', 'החום', 'פרצוף',
               'מטריף', 'עלתה', 'מורים', 'מעורב', 'בחתונה', 'פנסיה', 'נסיים', 'דעה', 'משווה', 'נפגשות', 'תצליח', 'נרגע',
               'שיושב', 'אספיק', 'המראה', 'שאיך', 'רחוב', 'הכיוונים', 'השאלונים', 'הסכמתי', 'נוטה', 'להימנע', 'טעיתי',
               'להירגע', 'הכיסא', 'הפלאפון', 'הייתם', 'התאונה', 'מחירים', 'לאחד', 'הדדי', 'המשך', 'חוג', 'הפרטים',
               'נשארו', 'ובאתי', 'מוגן', 'הנשמה', 'מאחרים', 'מהמצב', 'ישיר', 'אשלח', 'דלקת', 'לאפשר', 'מזעזע', 'בשר',
               'להתווכח', 'החליטו', 'לחברים', 'תמשיך', 'הברית', 'האמירה', 'החברתי', 'בעזרת', 'מסביר', 'מורכבת', 'אעבור',
               'מזלזל', 'ביולי', 'שאסור', 'נר', 'אחותו', 'מאבא', 'החוויות', 'הכניס', 'בתי', 'מההורים', 'וחזרתי',
               'ורוצה', 'מתפקדת', 'מרים', 'אבחון', 'העצבים', 'בוגר', 'במוצאי', 'שלפחות', 'ארוחה', 'מתנצלת', 'שהצלחתי',
               'שונא', 'הורה', 'לטוב', 'צאנס', 'קרו', 'בקשה', 'נעבור', 'איום', 'מהנהנת', 'טאק', 'לאזה', 'מטופלים',
               'נכה', 'האוניברסיטה', 'לנתח', 'קראה', 'ואתם', 'למנוע', 'נפלא', 'רוצות', 'להקל', 'תעזור', 'יתחיל', 'פרק',
               'לכלום', 'מפגרת', 'קולטת', 'חובה', 'בבטן', 'שלקחתי', 'ששאלתי', 'לנושא', 'אינטרס', 'טו', 'מכבדת', 'במבחן',
               'בום', 'גה', 'שב', 'באנו', 'מדויק', 'צלצול', 'תדברי', 'בהריון', 'אחריו', 'ולקחת', 'הכניסה', 'נוחה',
               'השפה', 'מעין', 'תלמד', 'ד', 'הגברים', 'מטרות', 'זול', 'מסדרת', 'להשוות', 'היתר', 'קורבן', 'במפגש',
               'הבחירות', 'תשאל', 'הרופאה', 'שליליים', 'משפחות', 'בדקתי', 'הקרובים', 'לקבוצה', 'חשוף', 'בריאים', 'מאי',
               'לאיפה', 'האישיים', 'נפגעתי', 'שאחרים', 'ירגיש', 'מבסוט', 'לשטוף', 'אשכח', 'ועושים', 'שאומרת', 'הרמתי',
               'קבלה', 'שגרתי', 'קרובות', 'המסגרת', 'חשמל', 'שמעה', 'האור', 'שמדברים', 'ברבע', 'מתייחסים', 'כיסא',
               'יתרונות', 'אסיים', 'פרטים', 'שרוב', 'במסעדה', 'המטופל', 'הדמות', 'גבוהות', 'למסעדה', 'הבוסית', 'גלגלים',
               'עקלכן', 'נפלתי', 'שנות', 'וכשאת', 'ומישהו', 'אחרון', 'צק', 'עשייה', 'להתקלח', 'ממי', 'מתמודדים', 'שכמו',
               'סיימנו', 'דורשת', 'לתחום', 'בניגוד', 'ובדרך', 'בסופר', 'חניה', 'בצפון', 'בשמחה', 'החשיבה', 'נרדמתי',
               'מוזרה', 'מטומטמת', 'אינטראקציה', 'מטורפת', 'מדאיג', 'הי', 'תכונה', 'התגובות', 'תישאר', 'נורמאלי',
               'ישיבה', 'בחמש', 'נעליים', 'החרדות', 'שיער', 'להתפתח', 'להיום', 'מציגה', 'טיולים', 'באחת', 'ויכוח',
               'שתעשה', 'יקח', 'ומדברים', 'מגע', 'לבחון', 'ישנים', 'אשלם', 'שהבית', 'בולט', 'אלפים', 'ההתמודדות',
               'דייטים', 'פסיכולוגיה', 'בראיון', 'כרטיסים', 'שגרם', 'כולן', 'שנכנסתי', 'בהלם', 'כאבי', 'שנת', 'הנטייה',
               'המרצה', 'מרצה', 'שעון', 'ניהול', 'מגעילה', 'עזבו', 'נסעו', 'בטעות', 'הפחדים', 'לטעות', 'אוניברסיטה',
               'תפס', 'מעורבת', 'בטן', 'הפנימית', 'לסופר', 'לחנות', 'להרוויח', 'נשבר', 'זבל', 'חתיכת', 'ושמה', 'פוגעת',
               'הבדיקות', 'לפרק', 'האש', 'הזדמנויות', 'השגרה', 'אכתוב', 'כוונה', 'מסלול', 'חיוביים', 'במילא', 'בורח',
               'העלה', 'שרה', 'נכות', 'מרוכזת', 'שהגעת', 'בהתנהגות', 'בסיפור', 'מצוקה', 'דד', 'יגמר', 'רעשי', 'שיתפתי',
               'נכונים', 'ניסו', 'הפנסיה', 'בפירוש', 'הסכימה', 'תנאים', 'תתני', 'מסעדה', 'מהבוקר', 'שהולכים', 'נשב',
               'השקעה', 'לפועל', 'קונקרטי', 'בחורף', 'הפתעה', 'לילות', 'מחויבות', 'קופת', 'רעיונות', 'בדלת',
               'אינטנסיבי', 'להתנצל', 'הופכת', 'בקליניקה', 'בודק', 'שיגיד', 'מוכרת', 'תאמת', 'החיבור', 'מציף', 'מאחורה',
               'בדייט', 'שהטיפול', 'בחלום', 'באות', 'הרצאה', 'בפסח', 'מעיק', 'להתלונן', 'כתוצאה', 'חיצונית', 'החתולים',
               'נוספת', 'עוצרת', 'זלזול', 'שעל', 'והדברים', 'סמסטר', 'סידרתי', 'העבודות', 'חיות', 'מהעבר', 'נפרד',
               'להקים', 'מלפני', 'מיוחדת', 'החוק', 'לשכוח', 'בטיול', 'שידעתי', 'בקצב', 'במייל', 'הגדולים', 'מהסביבה',
               'התלבטתי', 'הניסיון', 'משוגעת', 'אתגר', 'לשה', 'כזקלנכון', 'אעזוב', 'תצטרכי', 'נהדרת', 'הקיץ', 'תעודת',
               'התקשורת', 'פלוס', 'חתולים', 'התנהלות', 'חלקם', 'קבוצת', 'ההזדמנות', 'שנותנים', 'חולצה', 'התוצאות',
               'ותגיד', 'למישהי', 'אובייקטיבית', 'לבטא', 'יוני', 'לעבד', 'הפחות', 'הציעה', 'תר', 'אימונים', 'שותף',
               'ההחלטות', 'בכזה', 'כולו', 'מכבד', 'הביטוח', 'האצבע', 'בלא', 'להיפתח', 'לאוטו', 'נגיע', 'ואח', 'חברתיים',
               'טכני', 'שוק', 'לאוניברסיטה', 'הנפשי', 'מולה', 'משותפת', 'ייאוש', 'בעניינים', 'רצתי', 'טוענת', 'שכתבתי',
               'לטווח', 'תלמידה', 'בשבועות', 'יביא', 'מסיבות', 'להודיע', 'מונית', 'הפתיע', 'ואבוי', 'תתקשר', 'להדליק',
               'שמתאים', 'בשפה', 'הזמינה', 'פוטנציאל', 'יציבות', 'לתחושה', 'הציפיות', 'מאבד', 'שן', 'שמאל', 'בול',
               'תסביר', 'טכנית', 'מתבייש', 'שנכון', 'בגישה', 'בחמישי', 'העמדה', 'קראת', 'פר', 'תעשו', 'במודע', 'לקוח',
               'הזכרת', 'וסיפרתי', 'טון', 'כשבאתי', 'מצאו', 'העומס', 'תרופה', 'זוגות', 'האנרגיות', 'אומרות', 'ויפה',
               'וחוץ', 'בחרת', 'תפקידים', 'לשבור', 'הישג', 'בשלום', 'לאיך', 'וריכוז', 'מסיימים', 'המקרים', 'תורה',
               'מולך', 'הצעה', 'הוגן', 'בשכונה', 'בחג', 'לאי', 'בכסף', 'ההתבגרות', 'הבסיס', 'משרת', 'האנרגיה', 'העברתי',
               'הבלאגן', 'אהב', 'תנו', 'תקחי', 'גדלה', 'במכון', 'בטוב', 'אלימות', 'הצוות', 'נרדמת', 'ותוך', 'לשעבר',
               'תסתכל', 'לאור', 'מוצאים', 'ושום', 'מקסימה', 'לעיתים', 'מטלות', 'ריח', 'קרא', 'נזכר', 'מאפשרת', 'הצליחו',
               'פן', 'תיקחי', 'התמונות', 'שיפור', 'יורק', 'פספסתי', 'ולקחתי', 'רשום', 'מורידה', 'באחד', 'מאוזן',
               'הומור', 'מתכננת', 'מתקרב', 'בחברת', 'מעלות', 'מעשה', 'נכונות', 'וברור', 'בחנות', 'ען', 'התסכול',
               'ולחזור', 'רעב', 'אגו', 'שבי', 'המשיכה', 'משני', 'המרכז', 'ויצאתי', 'מרק', 'הפרעות', 'למזלי', 'זרקתי',
               'לצרכים', 'להפריד', 'חששות', 'אבקש', 'חריג', 'משבוע', 'שהתחלת', 'שבאה', 'מוביל', 'שקודם', 'כף', 'החצי',
               'המאמץ', 'מצפים', 'ולהמשיך', 'שעלה', 'המתח', 'נלחמת', 'ישבו', 'ושבוע', 'מפסיקה', 'מלחיצה', 'ושיש',
               'הנושאים', 'שיכולה', 'קונפליקט', 'באותם', 'התקווה', 'כשמישהו', 'לאק', 'להתאמן', 'מקנחת', 'התרגלתי',
               'ישירות', 'הכנסתי', 'שיעשו', 'ובסופו', 'הצגה', 'בלגן', 'להתקבל', 'לזוגיות', 'מרכז', 'בחרדה', 'דופן',
               'תסתכלי', 'ורואה', 'לוואי', 'שתבוא', 'כשאמרתי', 'בים', 'קיימים', 'שלילית', 'חזרת', 'תפסיקי', 'הצידה',
               'מאשים', 'התשלום', 'ההקלטה', 'סטודנטים', 'דברי', 'כשהתחלתי', 'לחזק', 'אפתח', 'טווח', 'הנוכחי', 'וכשאתה',
               'לצבא', 'שאמר', 'מושלמת', 'הפגיעה', 'הרגשית', 'שהיתי', 'בווטסאפ', 'וודאי', 'ציור', 'כעסה', 'מצפון',
               'שמרתי', 'התעסקות', 'קיץ', 'חוק', 'להפריע', 'ארון', 'לתקשר', 'הרים', 'וכשהוא', 'עבדת', 'בקורס', 'בסיסי',
               'צעקות', 'הוצאות', 'בודדה', 'לשרוד', 'תכנית', 'רצינו', 'האבחון', 'להתעמת', 'מאחרת', 'כואבת', 'שעשה',
               'במראה', 'החלטנו', 'דמעות', 'לתואר', 'שזהו', 'לאותה', 'הדודה', 'ישמע', 'הוריד', 'בסוג', 'אליהן', 'הה',
               'מתנות', 'למציאות', 'שנתתי', 'ומט', 'ית', 'קהל', 'המלחמה', 'שיודע', 'לגן', 'משיכה', 'בפעמים', 'לקחנו',
               'התעצבן', 'להשתלט', 'שיעזור', 'מחליפה', 'נורמלית', 'הציע', 'המקסימום', 'שיא', 'שד', 'ההתלבטות', 'אהא',
               'מענה', 'תשלום', 'ויצא', 'מבקשים', 'תכננתי', 'בישראל', 'סקס', 'אסתכל', 'תחליט', 'שחשבת', 'נסיעות', 'טס',
               'חרד', 'אינטימיות', 'ההשלכות', 'רצף', 'הערך', 'רשת', 'דיון', 'האופן', 'גמורה', 'יא', 'שוכב', 'צרכים',
               'ניקיתי', 'דעתך', 'עול', 'מעשנת', 'מרימה', 'ביומיים', 'ביקורתי', 'מחקר', 'מינימום', 'תתחילי', 'הקו',
               'לראיון', 'מאלה', 'הנשים', 'פנטזיה', 'לדרוש', 'וכשהיא', 'גמרנו', 'תאמיני', 'תובנות', 'בגד', 'חששתי',
               'הראשוני', 'הידע', 'פעיל', 'מלהיות', 'לזמן', 'שהכרתי', 'ששווה', 'בלבול', 'מתנהגים', 'שיוצא', 'במצוקה',
               'תסבירי', 'לרקוד', 'מעוניין', 'נרדם', 'לנסח', 'ויגיד', 'הנוחות', 'התינוק', 'פונה', 'ירידה', 'העייפות',
               'יידע', 'מתלוננת', 'נכנסנו', 'ככ', 'שיקול', 'במקצוע', 'נמשכת', 'הוראה', 'נ', 'קנתה', 'מכלום', 'תבואו',
               'מתאמצת', 'לנתק', 'לחלוק', 'בטענות', 'פינה', 'אתר', 'חשבנו', 'הארון', 'הצעתי', 'מתגעגעת', 'ולהביא',
               'תכונות', 'כלבים', 'מעצמו', 'בילדים', 'שיבואו', 'דתיים', 'לגוף', 'בשנתיים', 'הרגעים', 'והבנתי', 'ששמעתי',
               'סיכום', 'תלמיד', 'סטודנט', 'ני', 'קריירה', 'חלמתי', 'הכאילו', 'ארוכות', 'שאתמול', 'אושר', 'להעמיד',
               'תעבוד', 'הלוואה', 'בשבילם', 'לרמה', 'גופנית', 'מגדיר', 'ויגידו', 'עמט', 'שאה', 'סבלתי', 'החלון',
               'ידענו', 'כללית', 'לחם', 'מהילדות', 'קודמות', 'ששוב', 'האווירה', 'שתדעי', 'סביבי', 'מוגזם', 'ולצאת',
               'לסחוב', 'אופטימית', 'חמה', 'מציע', 'הרס', 'כיוונים', 'הממשלה', 'תתקשרי', 'לשקר', 'אחכה', 'אקום',
               'התקשרו', 'אבין', 'שנהיה', 'שתגיד', 'להפסיד', 'נעלבת', 'הבנים', 'תדאג', 'ואה', 'התפיסה', 'דופק',
               'שהתחלנו', 'ושאתה', 'עמד', 'בוודאות', 'השמה', 'בדקה', 'שיטה', 'יסודי', 'הכיר', 'במתמטיקה', 'להכריח',
               'ילדותי', 'ולהתחיל', 'בזבוז', 'משמעית', 'בשנייה', 'מוחלט', 'כותבים', 'מתפקד', 'פעילה', 'אעזור', 'ששבוע',
               'אחליט', 'טיפשה', 'אש', 'איכות', 'בוגרת', 'דיברתם', 'התלבטות', 'מרץ', 'תעסוקה', 'המבחנים', 'לעתיד',
               'הרגיל', 'התחבר', 'לחבק', 'מXXX', 'מוסיף', 'נהנתי', 'מזדהה', 'שופט', 'אותנטי', 'כבן', 'כמט', 'תיקון',
               'שותפה', 'העורך', 'מכונית', 'והלכנו', 'הפנטזיה', 'כעסים', 'לבריאות', 'עצמאות', 'משתנים', 'צבע', 'ירצו',
               'משדרת', 'שסתם', 'שמרגיש', 'ייעוץ', 'עוגה', 'אנ', 'ולמרות', 'מיותר', 'ומעבר', 'סידורים', 'בפנסיה',
               'לקניות', 'שבאת', 'ובאיזשהו', 'יציבה', 'שווים', 'הקיר', 'אצלהם', 'שמות', 'ושהם', 'מניע', 'לדיכאון',
               'לידך', 'בתקשורת', 'שעברת', 'איפושהו', 'האי', 'נגע', 'יצטרך', 'נתקע', 'איכשהוא', 'הגיונית', 'יחשוב',
               'התחשק', 'בעברית', 'הדוח', 'הלוז', 'יזמטכן', 'שנפגשנו', 'להזכר', 'להתגרש', 'כספית', 'יפגע', 'סמכות',
               'להצטרף', 'שהעבודה', 'מתעניינת', 'ודבר', 'נוגעת', 'צמוד', 'שהילד', 'מוציאים', 'הלחיץ', 'תמשיכי', 'שכמה',
               'שאמרה', 'העצמית', 'התייחסות', 'נסבל', 'נדיר', 'הרגיז', 'בבניין', 'הכיף', 'לתרום', 'והאמת', 'הטיפולים',
               'בתשובה', 'מהפגישה', 'והגעתי', 'גועל', 'טלויזיה', 'רגליים', 'לאישה', 'רחוקה', 'להעיף', 'מכוון',
               'התבאסתי', 'משערת', 'לאאני', 'הספרים', 'הקיבוץ', 'ליין', 'המשכורות', 'האימונים', 'כאליו', 'לרת', 'זזה',
               'יבין', 'האמיתי', 'ביניים', 'הכרה', 'שניכם', 'ארגון', 'אשראי', 'סוגרת', 'המעגל', 'תלות', 'שולטת', 'הדעה',
               'לל', 'הספציפי', 'יתר', 'ברח', 'בתמונה', 'הציעו', 'הרמה', 'מתים', 'שתהיי', 'מפחדים', 'לדברי', 'הקולות',
               'דוח', 'מערער', 'באוגוסט', 'התמיכה', 'ישנו', 'יכלת', 'מתרגש', 'מבולבל', 'תאריך', 'האירועים', 'לנהוג',
               'פניתי', 'ולדעת', 'השיר', 'המסר', 'תעצמי', 'אחכ', 'ששה', 'משמעת', 'הקבלה', 'התכוון', 'כה', 'זעם',
               'וללמוד', 'הזמנים', 'קומה', 'וכתבתי', 'שאכפת', 'משחררת', 'הו', 'מוגבל', 'שבאיזשהו', 'ואיכשהו', 'חלב',
               'הסיום', 'פספוס', 'מתחילת', 'תחזרי', 'קרבה', 'בהצלחה', 'המפגשים', 'יצרתי', 'שמגיעים', 'עורכת', 'המייל',
               'מנהלים', 'חוקים', 'המועד', 'בקניון', 'בקצה', 'מספק', 'המסלול', 'שנותן', 'לגיטימציה', 'עבור', 'לשיחות',
               'to', 'האני', 'כאיל', 'תקבלי', 'הרגיע', 'שאח', 'כןזה', 'מלמעלה', 'ריכוז', 'הלקוח', 'המטופלים', 'שמלווה',
               'התיכון', 'התברר', 'ידיד', 'שקר', 'חתול', 'כימיה', 'באיזו', 'התייחסתי', 'מסיבת', 'כתיבה', 'סביבה',
               'שלוקח', 'מתוסכלת', 'XX', 'לדעתך', 'הסיטואציות', 'גג', 'יציאה', 'יושבות', 'מתקדמת', 'תצליחי', 'שוקולד',
               'לנצח', 'שעת', 'שהזמן', 'ביומיום', 'תקנה', 'הפרדה', 'שתגידי', 'שמפריעים', 'בתוכו', 'תמצאי', 'במתח',
               'תפסיק', 'מתנהלת', 'מובנים', 'כשאמרת', 'גודל', 'לאה', 'שופטת', 'הפכתי', 'האוטובוס', 'כתבת', 'הכביש',
               'הסיכוי', 'מחברת', 'השיער', 'לחקור', 'נוהגת', 'הקשים', 'לשמוח', 'מגדירה', 'רשמה', 'מזיז', 'מגן', 'הדייט',
               'נעלבתי', 'טיפש', 'מפנה', 'להתראות', 'שכואב', 'אמירות', 'השכל', 'העובד', 'דר', 'תדאגי', 'קיצונית',
               'מהיר', 'איעשה', 'בתיק', 'מדמיין', 'מחקל', 'פסדר', 'בארבע', 'מצדי', 'כיתות', 'לעצמם', 'תאונה', 'שישבתי',
               'לתמוך', 'זקנה', 'העליתי', 'המטבח', 'מרכזי', 'שליליות', 'מפריעים', 'דרישות', 'הרצונות', 'לילדה',
               'והשאלה', 'לפרוק', 'יוצרת', 'מחלות', 'ולהסתכל', 'תעבור', 'זרק', 'הארגון', 'ריבים', 'קיבלנו', 'הרוח',
               'דיאטה', 'להליכה', 'כשאמא', 'במטרה', 'מסר', 'רופאים', 'אנשי', 'ולבוא', 'הפרטי', 'לשניה', 'נתראה',
               'הכרטיס', 'ושני', 'קיר', 'בדיחה', 'לכבד', 'משקפיים', 'שבעולם', 'בנוי', 'המחלקה', 'מהחברה', 'משקר',
               'מרחוק', 'מכולם', 'ואממ', 'סיים', 'שהצלחת', 'היכרות', 'בתפיסה', 'נבוך', 'בהתנהלות', 'מייצר', 'טבעית',
               'קונים', 'לחפור', 'אפסיק', 'בגללי', 'הביקורתי', 'דוקא', 'פס', 'בעיתון', 'תשימי', 'דולר', 'לעכשיו',
               'נבהלתי', 'פוחד', 'בעלך', 'צ', 'נהיגה', 'השליטה', 'תאכל', 'לבר', 'תראו', 'מתוסכל', 'ניסע', 'שהחברה',
               'מעצבנים', 'אך', 'מחלקה', 'ליזום', 'עבדו', 'אנושי', 'להרוס', 'בתואר', 'נוקשה', 'הסביר', 'ושיהיה',
               'המשהו', 'אהבת', 'לשיעור', 'הסגנון', 'הומו', 'להוביל', 'הזוג', 'תוקף', 'הקשבתי', 'לחרדה', 'הבכור',
               'הסטרס', 'חמור', 'אובדן', 'יתרון', 'צר', 'מודעים', 'הצעת', 'כלא', 'תשוקה', 'החלומות', 'להתחייב',
               'הוציאה', 'שוכבת', 'מסתיים', 'יפות', 'חופשה', 'התעסקתי', 'מסדר', 'מבטיח', 'שולט', 'חמלה', 'למחשבות',
               'מתקדמים', 'מהילדים', 'חשיפה', 'אלכוהול', 'בגללך', 'מאמצים', 'מתרגשת', 'מהדבר', 'מאיך', 'לשאלה', 'אזור',
               'הפיזי', 'דאגתי', 'חטפתי', 'לקלוט', 'שבהתחלה', 'פותחים', 'האופניים', 'הצעות', 'במשפט', 'נהייתי',
               'להשתתף', 'צפוי', 'נהיית', 'ובמקום', 'מחבר', 'הדימוי', 'עבורי', 'הסתכל', 'לרגשות', 'פיצוץ', 'פגועה',
               'נשיקה', 'הגיב', 'גא', 'הלקוחות', 'להיעזר', 'הקונפליקט', 'מאבק', 'דימוי', 'למחשבה', 'איגיד', 'אתדברים',
               'כשחזרתי', 'פותר', 'ושה', 'the', 'בבסיס', 'ביקשו', 'תגידו', 'מחזור', 'בבתי', 'שנסעתי', 'כשכבר',
               'מתעניין', 'הטריד', 'המסמכים', 'התהליכים', 'מוצלחת', 'לקיים', 'נמנעת', 'הורס', 'ויחד', 'תקני', 'בדרום',
               'בנקודות', 'בעייתית', 'ונכון', 'תצאי', 'אחריה', 'סיכון', 'יו', 'בנפרד', 'זרקה', 'מעירה', 'קטסטרופה',
               'אמפתיה', 'הטבע', 'מחייכת', 'פתרונות', 'התאריך', 'למחוק', 'זמני', 'קרקע', 'לשגרה', 'הדיכאון', 'מהעולם',
               'מותש', 'המתנה', 'מוצאי', 'מתקשה', 'בתוכי', 'בקשרים', 'נתון', 'לסלוח', 'שעלו', 'שמישהי', 'מהטיפול',
               'טוען', 'הנראה', 'השלכות', 'המנכל', 'הוקלד', 'גמרתי', 'שלמים', 'נס', 'תשע', 'ישפיע', 'ברוב', 'האומץ',
               'לאיזשהי', 'להתאבד', 'שעזבתי', 'במרחב', 'המרכזי', 'סדרה', 'הטעם', 'ובינתיים', 'בכלום', 'לחברות',
               'מכיוון', 'מחזק', 'אלו', 'אכלנו', 'פלאפון', 'ומדברת', 'לצייר', 'בתנאים', 'ותגידי', 'השלישית', 'שתים',
               'ואשתו', 'במחלקה', 'שפגשתי', 'אדום', 'נפתחת', 'בעדינות', 'להצביע', 'שעובדת', 'לאחי', 'נהנת', 'שמש',
               'טסה', 'בעלות', 'מאוכזב', 'כשהגעתי', 'המשבר', 'לסמן', 'הגבר', 'אשתך', 'נעצור', 'אילו', 'הגיבה', 'הקצב',
               'עדינה']
    Valence_Negative = ['לא', 'אבל', 'אין', 'נורא', 'קשה', 'ולא', 'שלא', 'פחות', 'לבד', 'בעיה', 'אי', 'למרות', 'אל',
                        'כמעט', 'רע', 'סוף', 'חוסר', 'ואין', 'מפחיד', 'מפריע', 'הבעיה', 'חולים', 'חסר', 'מעצבן', 'חולה',
                        'מוזר', 'בוכה', 'פחד', 'לחץ', 'בעיות', 'מפחדת', 'שקשה', 'כועסת', 'אשמה', 'חרדה', 'קשים', 'הפחד',
                        'מפחד', 'מלחיץ', 'כעס', 'דין', 'גרוע', 'ביקורת', 'ספק', 'לעזוב', 'עצוב', 'אוי', 'עייפה',
                        'לוותר', 'קושי', 'לעצור', 'לאו', 'אסור', 'כאב', 'לחוץ', 'מבאס', 'לפגוע', 'לבכות', 'בלחץ',
                        'החוסר', 'בלתי', 'עייף', 'פוגע', 'כועס', 'הלחץ', 'נפטר', 'להפסיק', 'נמאס', 'פוחדת', 'פחדתי',
                        'ונורא', 'דורש', 'מתסכל', 'טעות', 'הבעיות', 'נגד', 'משעמם', 'שכחתי', 'מטריד', 'טועה', 'קר',
                        'מת', 'סגור', 'כבד', 'ארוכה', 'הכעס', 'מאמץ', 'דואגת', 'הפריע', 'מורכב', 'מתה', 'בעייתי',
                        'מגעיל', 'קשות', 'החרדה', 'לכעוס', 'מתח', 'בלאגן', 'שונאת', 'לברוח', 'האחריות', 'המחלה', 'דוחה',
                        'לסבול', 'חרא', 'רעש', 'עוזב', 'מצטערת', 'מחלה', 'נפטרה', 'נופל', 'מציק', 'נאנח', 'עצבני',
                        'מוותרת', 'לחוצה']
    Valence_Positive = ['כן', 'יש', 'יודעת', 'טוב', 'בסדר', 'נכון', 'יכולה', 'צוחקת', 'אוקיי', 'טובה', 'ויש', 'מעניין',
                        'ביחד', 'אוהבת', 'יפה', 'צוחק', 'קל', 'כיף', 'אוהב', 'מצליחה', 'נחמד', 'וואו', 'טובים', 'נוח',
                        'בטוחה', 'תודה', 'סבבה', 'שמחה', 'מצליח', 'הצלחתי', 'צוחקות', 'שווה', 'בטחון', 'ביטחון', 'יופי',
                        'מצחיק', 'חוויה', 'מאמין', 'מצחקקת', 'שלום', 'יחד', 'חופש', 'שמח', 'משמעותי', 'טובות', 'חזקה',
                        'אהבה', 'מדהים', 'אביב', 'מעולה', 'אהבתי', 'מזל', 'אפשרי', 'חן', 'מיוחד', 'נעימה', 'בריא',
                        'מרוצה', 'אשמח', 'נחמדה', 'מסודר', 'נהנה', 'רגוע', 'תקווה', 'נכונה', 'חדשים', 'חיובי', 'מצוין',
                        'צוחקים', 'בקלות', 'אחלה', 'הטוב', 'חכם', 'בכיף', 'הביטחון', 'הצליח', 'נקי', 'נהנית', 'מגניב',
                        'מתנה', 'שטוב', 'מרגיע', 'חכמה']

    def __iter__(self):
        return self

    def __next__(self):
        self.idx += 1
        try:
            return self.lexicons_names[self.idx -1], getattr(self, self.lexicons_names[self.idx -1])
        except IndexError:
            self.idx = 0
            raise StopIteration

    def __init__(self, load_from_file_system = False):
        self.idx = 0
        self.lexicons_names = ['ConversationTopics_Topic000', 'ConversationTopics_Topic001', 'ConversationTopics_Topic002', 'ConversationTopics_Topic003', 'ConversationTopics_Topic004', 'ConversationTopics_Topic005', 'ConversationTopics_Topic006', 'ConversationTopics_Topic007', 'ConversationTopics_Topic008', 'ConversationTopics_Topic009', 'ConversationTopics_Topic010', 'ConversationTopics_Topic011', 'ConversationTopics_Topic012', 'ConversationTopics_Topic013', 'ConversationTopics_Topic014', 'ConversationTopics_Topic015', 'ConversationTopics_Topic016', 'ConversationTopics_Topic017', 'ConversationTopics_Topic018', 'ConversationTopics_Topic019', 'ConversationTopics_Topic020', 'ConversationTopics_Topic021', 'ConversationTopics_Topic022', 'ConversationTopics_Topic023', 'ConversationTopics_Topic024', 'ConversationTopics_Topic025', 'ConversationTopics_Topic026', 'ConversationTopics_Topic027', 'ConversationTopics_Topic028', 'ConversationTopics_Topic029', 'ConversationTopics_Topic030', 'ConversationTopics_Topic031', 'ConversationTopics_Topic032', 'ConversationTopics_Topic033', 'ConversationTopics_Topic034', 'ConversationTopics_Topic035', 'ConversationTopics_Topic036', 'ConversationTopics_Topic037', 'ConversationTopics_Topic038', 'ConversationTopics_Topic039', 'ConversationTopics_Topic040', 'ConversationTopics_Topic041', 'ConversationTopics_Topic042', 'ConversationTopics_Topic043', 'ConversationTopics_Topic044', 'ConversationTopics_Topic045', 'ConversationTopics_Topic046', 'ConversationTopics_Topic047', 'ConversationTopics_Topic048', 'ConversationTopics_Topic049', 'ConversationTopics_Topic050', 'ConversationTopics_Topic051', 'ConversationTopics_Topic052', 'ConversationTopics_Topic053', 'ConversationTopics_Topic054', 'ConversationTopics_Topic055', 'ConversationTopics_Topic056', 'ConversationTopics_Topic057', 'ConversationTopics_Topic058', 'ConversationTopics_Topic059', 'ConversationTopics_Topic060', 'ConversationTopics_Topic061', 'ConversationTopics_Topic062', 'ConversationTopics_Topic063', 'ConversationTopics_Topic064', 'ConversationTopics_Topic065', 'ConversationTopics_Topic066', 'ConversationTopics_Topic067', 'ConversationTopics_Topic068', 'ConversationTopics_Topic069', 'ConversationTopics_Topic070', 'ConversationTopics_Topic071', 'ConversationTopics_Topic072', 'ConversationTopics_Topic073', 'ConversationTopics_Topic074', 'ConversationTopics_Topic075', 'ConversationTopics_Topic076', 'ConversationTopics_Topic077', 'ConversationTopics_Topic078', 'ConversationTopics_Topic079', 'ConversationTopics_Topic080', 'ConversationTopics_Topic081', 'ConversationTopics_Topic082', 'ConversationTopics_Topic083', 'ConversationTopics_Topic084', 'ConversationTopics_Topic085', 'ConversationTopics_Topic086', 'ConversationTopics_Topic087', 'ConversationTopics_Topic088', 'ConversationTopics_Topic089', 'ConversationTopics_Topic090', 'ConversationTopics_Topic091', 'ConversationTopics_Topic092', 'ConversationTopics_Topic093', 'ConversationTopics_Topic094', 'ConversationTopics_Topic095', 'ConversationTopics_Topic096', 'ConversationTopics_Topic097', 'ConversationTopics_Topic098', 'ConversationTopics_Topic099', 'ConversationTopics_Topic100', 'ConversationTopics_Topic101', 'ConversationTopics_Topic102', 'ConversationTopics_Topic103', 'ConversationTopics_Topic104', 'ConversationTopics_Topic105', 'ConversationTopics_Topic106', 'ConversationTopics_Topic107', 'ConversationTopics_Topic108', 'ConversationTopics_Topic109', 'ConversationTopics_Topic110', 'ConversationTopics_Topic111', 'ConversationTopics_Topic112', 'ConversationTopics_Topic113', 'ConversationTopics_Topic114', 'ConversationTopics_Topic115', 'ConversationTopics_Topic116', 'ConversationTopics_Topic117', 'ConversationTopics_Topic118', 'ConversationTopics_Topic119', 'ConversationTopics_Topic120', 'ConversationTopics_Topic121', 'ConversationTopics_Topic122', 'ConversationTopics_Topic123', 'ConversationTopics_Topic124', 'ConversationTopics_Topic125', 'ConversationTopics_Topic126', 'ConversationTopics_Topic127', 'ConversationTopics_Topic128', 'ConversationTopics_Topic129', 'ConversationTopics_Topic130', 'ConversationTopics_Topic131', 'ConversationTopics_Topic132', 'ConversationTopics_Topic133', 'ConversationTopics_Topic134', 'ConversationTopics_Topic135', 'ConversationTopics_Topic136', 'ConversationTopics_Topic137', 'ConversationTopics_Topic138', 'ConversationTopics_Topic139', 'ConversationTopics_Topic140', 'ConversationTopics_Topic141', 'ConversationTopics_Topic142', 'ConversationTopics_Topic143', 'ConversationTopics_Topic144', 'ConversationTopics_Topic145', 'ConversationTopics_Topic146', 'ConversationTopics_Topic147', 'ConversationTopics_Topic148', 'ConversationTopics_Topic149', 'ConversationTopics_Topic150', 'ConversationTopics_Topic151', 'ConversationTopics_Topic152', 'ConversationTopics_Topic153', 'ConversationTopics_Topic154', 'ConversationTopics_Topic155', 'ConversationTopics_Topic156', 'ConversationTopics_Topic157', 'ConversationTopics_Topic158', 'ConversationTopics_Topic159', 'ConversationTopics_Topic160', 'ConversationTopics_Topic161', 'ConversationTopics_Topic162', 'ConversationTopics_Topic163', 'ConversationTopics_Topic164', 'ConversationTopics_Topic165', 'ConversationTopics_Topic166', 'ConversationTopics_Topic167', 'ConversationTopics_Topic168', 'ConversationTopics_Topic169', 'ConversationTopics_Topic170', 'ConversationTopics_Topic171', 'ConversationTopics_Topic172', 'ConversationTopics_Topic173', 'ConversationTopics_Topic174', 'ConversationTopics_Topic175', 'ConversationTopics_Topic176', 'ConversationTopics_Topic177', 'ConversationTopics_Topic178', 'ConversationTopics_Topic179', 'ConversationTopics_Topic180', 'ConversationTopics_Topic181', 'ConversationTopics_Topic182', 'ConversationTopics_Topic183', 'ConversationTopics_Topic184', 'ConversationTopics_Topic185', 'ConversationTopics_Topic186', 'ConversationTopics_Topic187', 'ConversationTopics_Topic188', 'ConversationTopics_Topic189', 'ConversationTopics_Topic190', 'ConversationTopics_Topic191', 'ConversationTopics_Topic192', 'ConversationTopics_Topic193', 'ConversationTopics_Topic194', 'ConversationTopics_Topic195', 'ConversationTopics_Topic196', 'ConversationTopics_Topic197', 'ConversationTopics_Topic198', 'ConversationTopics_Topic199', 'DataDrivenSupervised_WellBeing_Clinical', 'DataDrivenSupervised_WellBeing_NonClinical', 'DepressiveCharacteristics_But', 'DepressiveCharacteristics_Cursing', 'DepressiveCharacteristics_Direct', 'DepressiveCharacteristics_I', 'DepressiveCharacteristics_Indecision', 'DepressiveCharacteristics_Knowing', 'DepressiveCharacteristics_Meaning', 'DepressiveCharacteristics_Negation', 'DepressiveCharacteristics_NonFluenciesAhEm', 'DepressiveCharacteristics_NonFluenciesLike', 'DepressiveCharacteristics_OK', 'DepressiveCharacteristics_Tentativeness', 'DepressiveCharacteristics_Total', 'DepressiveCharacteristics_UnknownWord', 'EmotionalVariety_Amused', 'EmotionalVariety_Anger', 'EmotionalVariety_Anticipation', 'EmotionalVariety_Anxiety', 'EmotionalVariety_Ashamed', 'EmotionalVariety_Calm', 'EmotionalVariety_Confusion', 'EmotionalVariety_Contentment', 'EmotionalVariety_Disgust', 'EmotionalVariety_Enthusiastic', 'EmotionalVariety_Fatigue', 'EmotionalVariety_Guilty', 'EmotionalVariety_Hostile', 'EmotionalVariety_Interested', 'EmotionalVariety_Joy', 'EmotionalVariety_Nervous', 'EmotionalVariety_NotAmused', 'EmotionalVariety_NotAnger', 'EmotionalVariety_NotAnticipation', 'EmotionalVariety_NotAnxiety', 'EmotionalVariety_NotAshamed', 'EmotionalVariety_NotCalm', 'EmotionalVariety_NotConfusion', 'EmotionalVariety_NotContentment', 'EmotionalVariety_NotDisgust', 'EmotionalVariety_NotEnthusiastic', 'EmotionalVariety_NotFatigue', 'EmotionalVariety_NotGuilty', 'EmotionalVariety_NotHostile', 'EmotionalVariety_NotInterested', 'EmotionalVariety_NotJoy', 'EmotionalVariety_NotNervous', 'EmotionalVariety_NotProud', 'EmotionalVariety_NotSad', 'EmotionalVariety_NotSurprise', 'EmotionalVariety_NotTrust', 'EmotionalVariety_NotVigor', 'EmotionalVariety_Proud', 'EmotionalVariety_Sad', 'EmotionalVariety_Surprise', 'EmotionalVariety_Trust', 'EmotionalVariety_Vigor', 'Paralinguistics_Body', 'Paralinguistics_Crying', 'Paralinguistics_HighTone', 'Paralinguistics_Humming', 'Paralinguistics_ImitationTone', 'Paralinguistics_Joy', 'Paralinguistics_LowTone', 'Paralinguistics_Sarcasm', 'Paralinguistics_Sigh', 'Paralinguistics_Smirk', 'Paralinguistics_TutTut', 'Questions', 'StopWords', 'Top2000', 'Top5000', 'Valence_Negative', 'Valence_Positive']
        if (load_from_file_system):
            self.lexicons_names = []
            path = Constants.LEXICONS_COLLECTION_PATH
            onlyfiles = [f for f in listdir(path) if isfile(join(path, f))]
            for file_name in onlyfiles:
                lexicon_name = file_name.split('.')[0]
                self.lexicons_names.append(lexicon_name)
                setattr(self, lexicon_name, [])
                with open(join(path, file_name), 'r', encoding="utf8") as in_f:
                    for line in in_f:
                        if line.startswith('#'):
                            print('Warnning: Line starts with #, skipping line: {}'.format(line))
                            continue
                        if line.startswith('\n'):
                            #print('Empty line')
                            continue
                        getattr(self, lexicon_name).append(line.strip())


if __name__ == '__main__':
    lexicons = Lexicons(load_from_file_system=True)
    import pandas as pd
    df = pd.DataFrame()
    df['placeholder'] = pd.Series(range(5000))
    for lexicon_name, lexicon_words in lexicons:
        print (lexicon_name + " = " +str(lexicon_words))
        df[lexicon_name] = pd.Series(lexicon_words)
    print(lexicons.lexicons_names)
    df.to_csv('./Resources/For documentation purposes/df_all_lexicons.csv', index=False)
    banana = 1234