#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri May 31 22:32:52 2019

@author: cole roberson
"""

# =============================================================================
# Features 
# =============================================================================
LANGUAGES = ['english','dutch','german']

META_FEATURE_MAP = {'future':'future',
       'present':'present',
       'future_dom':'future',
       'go_future_dom':'future',
       'will_future_dom':'future',
       'particle':'',
       'present_dom':'present',
       'adv_adj_poss':'lexical uncertain',
       'adv_adj_cert':'lexical certain',
       'mental_poss':'lexical uncertain',
       'mental_cert':'lexical certain',
       'particle_poss':'lexical uncertain',
       'particle_cert':'lexical certain',
       'verb_poss':'verbal uncertain',
       'verb_cert':'verbal certain',
       'past':'past',
       'verb_des_int':'verbal bouletic',
       'present_perfect': 'the present perfect',
       'past_perfect':'the past perfect',
       'past_participle':'the past participle'
       
       }

FEATURE_NAME_MAP = {'future':"grammar book ``futures''",
                    'present':"present tense response",
                    'future_dom':"grammar book ``futures''",
                    'go_future_dom':"grammar book ``future'' using ``be going to/gaan'' constructions",
                    'will_future_dom':"grammar book ``future'' auxilaries ``will/shall'',``zullen'', ``werden''",
                    'particle':"modal particles with no epistemic valance",
                    'present_dom':"present tense response",
                    'adv_adj_poss':"adverbs/adjectives/nouns",
                    'adv_adj_cert':"adverbs/adjectives/nouns",
                    'mental_poss':"mental state predicates",
                    'mental_cert':"mental state predicates",
                    'particle_poss':"modal particles",
                    'particle_cert':"modal particles",
                    'verb_poss':"modal verbs",
                    'verb_cert':"modal verbs",
                    'past':'past tense',
                    'verb_des_int':'verbs of desire/intention',
                    'present_perfect': 'the present perfect',
                    'past_perfect':'the past perfect',
                    'past_participle':'the past participle'
                    }

PAST = ['past']

DESIRE = ['verb_des_int']

ASPECTS = ['present_perfect','past_perfect']

PP = ['past_participle']

SUBMISSIVE_FEATURES = ['present','future','will_future','go_future']

DOMINANT_FEATURES = ['verb_poss','verb_cert',
                     'adv_adj_poss','adv_adj_cert',
                     'mental_poss',
                     'particle_poss','particle',
                     'particle_cert']

DOMINATED_FEATURES = ['future_dom','present_dom',
                     'go_future_dom','will_future_dom']

SUMMARY_FEATURES = ['lexi_poss','lexi_cert','uncertain','certain']

EXTRA_FEATURES = ['negated','no_code']

MAIN_FEATURES = ['lexi_poss','lexi_cert','future_dom',
                  'present_dom','verb_poss','verb_cert','uncertain','certain']

FEATURES = DOMINANT_FEATURES + SUBMISSIVE_FEATURES + PAST + DESIRE + ASPECTS
ALL_FEATURES = FEATURES + DOMINATED_FEATURES + SUMMARY_FEATURES + EXTRA_FEATURES + PP

# =============================================================================
# English word lists
# =============================================================================
english = {'present': (
                        [
                        'i s',#typos
                        'im',
                        'blow in','blows in','blowing in',
                        'dine out','dines out','dining out',
                        'swell up','swells up','swelling up',
                        'wear out','wears out','wearing out'
                         ],
                        [
                         "'m",
                         "'re",
                         "'s",
                         'its',
                         'allow',
                         'allows',
                         'allowing',
                         'am',
                         'applies',
                         'apply',
                         'applying',
                         'are',
                         'arrive',
                         'arrives',
                         'arriving',
                         'be',
                         'break',
                         'breaks',
                         'breaking',
                         'buy',
                         'buys',
                         'buying',
                         'begin',
                         'begins',
                         'beginning',
                         'call',
                         'calls',
                         'calling',
                         'cause',
                         'causes',
                         'causing',
                         'climb',
                         'climbs',
                         'climbing',
                         'collapse',
                         'collapses',
                         'collapsing',
                         'come',
                         'comes',
                         'coming',
                         'congradulate',
                         'congradulates',
                         'congradulating',
                         'congratulating',
                         'congratulate',
                         'congratulates',
                         'crash',
                         'crashes',
                         'crashing',
                         'decline',
                         'declining',
                         'declines',
                         'develop',
                         'develops',
                         'developing',
                         'defend',
                         'defends',
                         'defending',
                         'die',
                         'dies',
                         'dying',
                         'do',
                         'doing',
                         'does',
                         'drop',
                         'dropping',
                         'drops',
                         'enrol',
                         'enrols',
                         'enrolling',
                         'expire',
                         'expiring',
                         'expires',
                         'exipires',
                         'fall',
                         'falling',
                         'falls',
                         'feel',
                         'feeling',
                         'feels',
                         'finish',
                         'finishing',
                         'finishes',
                         'flies',
                         'flying',
                         'fly',
                         'forecast',
                         'forecasting',
                         'forecasts',
                         'gaining',
                         'gain',
                         'gains',
                         'garden',
                         'gardenning',
                         'gardens',
                         'getting',
                         'get',
                         'gets',
                         'graduate',
                         'graduates',
                         'graduating',
                         'help',
                         'helping',
                         'helps',
                         'hit',
                         'hitting',
                         'hits',
                         'improve',
                         'improves',
                         'improving',
                         'increase',
                         'increasing',
                         'increases',
                         'insist',
                         'insists',
                         'insisting',
                         'is',
                         'join',
                         'joins',
                         'joining',
                         'kill',
                         'killing',
                         'kills',
                         'leave',
                         'leaving',
                         'leaves',
                         'live',
                         'living',
                         'lives',
                         'lose',
                         'losing',
                         'loses',
                         'make',
                         'makes',
                         'making',
                         'mature',
                         'maturing',
                         'matures',
                         'matues',#typo
                         'move',
                         'moving',
                         'moves',
                         'occurs',
                         'occur',
                         'occurring',
                         'pass',
                         'passing',
                         'passes',
                         'plan',
                         'planning',
                         'plans',
                         'play',
                         'playing',
                         'plays',
                         'plummet',
                         'plummeting',
                         'plummets',
                         'potter',
                         'pottering',
                         'potters',
                         'praise',
                         'praising',
                         'praises',
                         'put',
                         'putting',
                         'puts',
                         'rain',
                         'raining',
                         'rains',
                         'receive',
                         'receiving',
                         'receives',
                         'replace',
                         'replacing',
                         'replaces',
                         'rise',
                         'rising',
                         'rises',
                         'risk',
                         'risking',
                         'risks',
                         'say',
                         'saying',
                         'says',
                         'see',
                         'seeing',
                         'sees',
                         'sit',
                         'sitting',
                         'sits',
                         'snow',
                         'snowing',
                         'snows',
                         'spend',
                         'spending',
                         'spends',
                         'start',
                         'starting',
                         'starts',
                         'stay',
                         'staying',
                         'stays',
                         'suggest',
                         'suggesting',
                         'suggests',
                         'take',
                         'taking',
                         'takes',
                         'thank',
                         'thanking',
                         'thanks',
                         'train',
                         'training',
                         'trains',
                         'travel',
                         'travelling',
                         'traveling',#misspelling
                         'travels',
                         'win',
                         'winning',
                         'wins',
                         'work',
                         'working',
                         'works'
                         ]
                        ),

    'present_perfect':(["youve",
                        "weve",
                        "theyve"],
                       ['has',
                        'have',
                        've'
                        ]),
                       
    'past_perfect':(["i'd",
                     "you'd",
                     "we'd",
                     "they'd",
                     "id",
                     "youd",
                     "theyd"],
                    ['had',
                     'd']),
                    
    'past_participle':([],
                       []),
                       
    'past':([
             'blew in',
             'dined out',
             'swelled up',
             'wore out'
            ],
            [
             'was',
             'were',
             'been',
             'allowed',
             'applied',
             'applied',
             'arrived',
             'bought',
             'bought',
             'broke',
             'began',
             'decided',
             'called',
             'called',
             'came',
             'caused',
             'climbed',
             'collapsed',
             'congradulated',
             'congratulated',
             'crashed',
             'declined',
             'developed',
             'did',
             'died',
             'dropped',
             'defended',
             'enrolled',
             'expired',
             'fell',
             'felt',
             'feeled',
             'finished',
             'flew',
             'forecasted',
             'gained',
             'gardened',
             'gardenned',
             'got',
             'graduated',
             'helped',
             'improved',
             'increased',
             'happened',
             'insisted',
             'joined',
             'killed',
             'left',
             'lived',
             'lived',
             'lost',
             'made',
             'matured',
             'moved',
             'passed',
             'planed',
             'planned',
             'played',
             'plummeted',
             'pottered',
             'praised',
             'rained',
             'risen',
             'received',
             'replaced',
             'risked',
             'rose',
             'seen',
             'said',
             'sat',
             'saw',
             'snowed',
             'spent',
             'started',
             'stayed',
             'suggested',
             'thanked',
             'took',
             'trained',
             'trained',
             'travelled',
             'traveled',
             'went',
             'won',
             'worked']
                    ),
    
    'future':(['about to',
               'set to',
               'on the verge of',
               'is going',
               'are going',
               'am going',
               'going to',
               'gonna',
               'theyll',
               'they`ll',
               "i'll",
               "you'll",
               "he'll",
               "she'll",
               "we'll"
               ],
              ['will',
               'wil',
               'twill',#typos
               'willbe',#typos
               'gonna',
               'shall',
               "'ll",
               "ll",
               "youll",#typos
               "shell",
               'ill']
            ),
    
    'verb_poss':(['likely to'],
                 ['can',
                  'may',
                  'could',
                  'coud',#typo
                  'might',
                  'should',
                  'sould',#typo
                  'ought',
                  'would',#used epistemically in the 'what your brother would do... question, i.e. as a conditional 
                  'wouls'#typo
                  ]
                 ),
    
    'verb_cert':([#'have to',
                  #'got to',
                  #'has to'
                  ],
                 ['must']
                 ),
    
    'adv_adj_poss':(['is a chance',
                     'fairly certain',
                     'rates are shakey'],
                   ['apparently',
                    'dubiously',
                    'expectably',
                    'expectedly',
                    'improbably',
                    'likely',
                    'maybe',
                    'mayhap',
                    'chance',
                    'risk',
                    'perchance',
                    'perhaps',
                    'possibility',
                    'possible',
                    'possibly',
                    'potentially',
                    'presumably',
                    'probable',
                    'probability',
                    'probably',
                    'improbable',
                    'improbability',
                    'improbably',
                    'questionably',
                    'seemingly',
                    'somewhat',
                    'supposedly',
                    'supposed',
                    'unsure',
                    'uncertainly']
                    ),
    
    'adv_adj_cert':(['for sure',
                     'no chance',
                     '100%',
                     'guaranteed to'],
               ['definitely','definetly',#missspelling
                'definite',
                'certainly',
                'certain',
                'certainty',
                'assuredly',
                'assured',
                'positive',
                'clearly',
                'doubtless',
                'indubitably',
                'indubitable',
                'inevitably',
                'infallibly',
                'irrefutably',
                'irrefutable',
                'necessarily',
                'necessary',
                'obviously',
                'obvious',
                'surely',
                'sure',
                'unavoidably',
                'unavoidable',
                'undeniably',
                'undeniable',
                'undoubtedly',
                'undoubted',
                'unquestionably',
                'unquestionable']
               ),
    'mental_poss':(['feel like',
                    'not too sure',
                    'i am not sure',
                    'not certain',
                    'not 100% certain'],
                   ['think',
                    'thinking',
                    'thinks',
                    'thought',
                    'believe',
                    'believes',
                    'believed',
                    'believing',
                    'reckon',
                    'reckons',
                    'reckoned',
                    'reckoning',
                    'expect',
                    'expects',
                    'expected',
                    'expecting',
                    'doubt',
                    'doubts',
                    'doubted',
                    'doubting',
                    'suppose',
                    'supposes',
                    'supposed',
                    'supposing',
                    'guess',
                    'guesses',
                    'guessed',
                    'guessing']
                   ),
                   
    'particle_poss':([],
                     []
                     ),
    
    'particle_cert':([],
                     []
                     ),
    'particle':([],
                []
                ),
    
    'will_future':(['theyll',
                    'they`ll',
                    "i'll",
                    "you'll",
                    "he'll",
                    "she'll",
                    "we'll"
                    "youll",
                    "shell",
                    'ill'],
                   ['will',
                    'willbe',
                    'wil',
                    "'ll",
                    "ll"]
                   ),
    'go_future':(['is going','are going',
                   'am going','going to','gonna'],
                 []
                 ),
    
    'verb_des_int':([],
                   ['want',
                    'wanting',
                    'wants',
                    'hope',
                    'hoping',
                    'hopes',
                    'hopefully',
                    'planning',
                    'plan',
                    'plans'])
    }


# =============================================================================
# Dutch word lists
# =============================================================================
dutch = {'present':(['is het','vallen om','storten in',
                     'en ik in au','het stoort',
                     'contact opnemen',
                     'leuk vindt','leuk vind','leuk vinden',
                     'ze halen het',
                     'val om','stort in','valt om',
                     'storten in','storten inen',
                     'kom aan','komt aan','komen aan','knap op','kom ik',
                     'knapt op','knappen op',
                     'uit eet',
                     'ze halen het','zij halen het','haal het','haalt het','halen het',
                     'kom op','komt op','komen op',
                     'ik ik',#typo
                     'zwel op','zwelt op','zwellen op',
                     'studeer af','studeert af','studeren af',
                     'vraag aan','vraagt aan','vragen aan',
                     'eet uit','eten uit','uit eten',
                     'schrijf in','schrijft in','schrijven in',
                     'loop af','loopt af','lopen af',
                     'geef uit','geeft uit','geven uit',
                     'zich voel','zich voelt','zich voelen'
                     ],

                    ['.is',#typo
                     'ishet',#typo
                     'aanvragen',
                     'aflopen',
                     'afstuderen',
                     'accepteer',
                     'accepteert',
                     'accepteren',
                     'bedank',
                     'bedanken',
                     'bedankt',
                     'bekijk',
                     'bekijkt',
                     'bekijken',
                     'bel',
                     'bellen',
                     'belt',
                     'ben',
                     'bent',
                     'bereik',
                     'bereiken',
                     'bereikt',
                     'begin',
                     'begint',
                     'beginnen',
                     'blijf',
                     'blijven',
                     'blijft',
                     'blijvenb',#typo
                     'breek',
                     'breekt',
                     'breken',
                     'crashen',
                     'crashed',#typo
                     'crahst',#typo 
                     'crasht',
                     'crash',
                     'carsht',#typo
                     'daal',
                     'daalt',
                     'dalen',
                     'dank',
                     'dankt',
                     'danken',
                     'doe',
                     'doet',
                     'doen',
                     'dood',
                     'doodt',
                     'doden',
                     'doodgaan',
                     'duur',
                     'duurt',
                     'duuren',
                     'eindig',
                     'eindigd',#typo
                     'eindigt',
                     'eindigen',
                     'eet',
                     'eten',
                     'explodeer',
                     'explodeert',
                     'exploderen',
                     'geef',
                     'geeft',
                     'geven',
                     'haal',
                     'haalt',
                     'halen',
                     'helen',
                     'heel',
                     'heelt',
                     'help',
                     'helpt',
                     'helpen',
                     'inschrijven',
                     'instorten',
                     'is',
                     'is.',#typo
                     'kijk',
                     'kijken',
                     'kijkt',
                     'knap',
                     'knappen',
                     'knapt',
                     'kom',
                     'komen',
                     'komt',
                     'koop',
                     'koopt',
                     'kpen',#typo
                     'kopen',
                     'krijg',
                     'krijgen',
                     'krijgt',
                     'loopt',
                     'lopen',
                     'loop',
                     'laat',
                     'laten',
                     'latten',#typo
                     'maak',
                     'maaken',
                     'maakt',
                     'maken',
                     'nemen',
                     'neem',
                     'neemt',
                     'omvalt',
                     'omval',
                     'omvalen',
                     'pas',
                     'past',
                     'passen',
                     'regen',
                     'regenen',
                     'regent',
                     'reis',
                     'reist',
                     'reizen',
                     'resit',#misspelled
                     'resideer',
                     'resideert',
                     'resideren',
                     'rij',
                     'rijd',
                     'rijden',
                     'rijdt',
                     'slijt',
                     'slijten',
                     'sneeuw',
                     'sneeuwen',
                     'sneeuwt',
                     'sort',
                     'sorten',
                     'sotrt',#typo
                     'sleet',
                     'sleten',
                     'spaar',
                     'spaart',
                     'sparen',
                     'stel',
                     'stellen',
                     'stelt',
                     'sterf',
                     'sterft',
                     'sterven',
                     'stijg',
                     'stijgen',
                     'stijgt',
                     'dtijgt',#typo
                     'stjgt',#typo
                     'stort',
                     'storten',
                     'strort',#typo
                     'slaag',
                     'slaagt',
                     'slagen',
                     'storm',
                     'stormt',
                     'stormen',
                     'speel',
                     'speelt',
                     'spelen',
                     'uiteten',
                     'uitgeven',
                     'val',
                     'vallen',
                     'valt',
                     'verdedig',
                     'verdedigt',
                     'verdedigen',
                     'verdubbel',
                     'verdubbelen',
                     'verdubbelt',
                     'vervoeg',
                     'vervoegt',
                     'vervoegen',
                     'vergangt',
                     'vergang',
                     'vergangen',
                     'verhuis',
                     'verhuist',
                     'verhuizen',
                     'verlies',
                     'verliest',
                     'verliezen',
                     'verslijten',
                     'verslijt',
                     'verminder',
                     'verminderen',
                     'vermindert',
                     'verslijt',
                     'verslijten',
                     'verslitjen',
                     'verlijten',#common typo
                     'verspil',
                     'verspillen',
                     'verspilt',
                     'vervang',
                     'vervangen',
                     'vervangt',
                     'vertrekken',
                     'vertrek',
                     'vertrekt',
                     'vinden',
                     'vind',
                     'vindt',
                     'voel',
                     'voelen',
                     'voelt',
                     'volg',
                     'volgt',
                     'volgen',
                     'vraag',
                     'vraagt',
                     'vraagen',
                     'verbeter',
                     'verbetert',
                     'verbeteren',
                     'verval',
                     'vervalt',
                     'vervallen',
                     'weetblijft',#typo
                     'werk',
                     'werken',
                     'werkt',
                     'wetkt',#typo
                     'win',
                     'winnen',
                     'wint',
                     'wonen',
                     'woon',
                     'woont',
                     'wwon',#typo 
                     'word',#could indicate future marking, but sentences in frames use  it not as such (i.e. I become fat...)
                     'worden',
                     'wordt',
                     'zie',
                     'zien',
                     'ziet',
                     'zij',
                     'zijn',
                     'zinnen',
                     'zit',
                     'zitten',
                     'zwel',
                     'zwellen',
                     'zwelt',
                     'zeg', #say, and though can be used as mental state pred use (Nuyts, 2000), it is not in our frames, i.e. "I {SAY} no this time..."
                     'zeggen',
                     'zegt']
                    ),
    
    'present_perfect':([],
                       ['heb',
                        'hebt',
                        'hebben',
                        'heeft',
                        'is',
                        'ben',
                        'bent',
                        'zijn']),

    'past_perfect':([],
                    ['had',
                     'hadden',
                     'was',
                     'waren']),
                    
    'past_participle':(['leuk gevonden',
                        'het gehaald',
                        'gezich voeld'],
                        ['ingestort',
                         'omgevald',
                         'aangekomen',
                         'opgeknapt',
                         'uitgeeët',
                         'opgekomen',
                         'opgezweld',
                         'afgestudeerd',
                         'aangevraagd',
                         'ingeschreven',
                         'afgeloopt',
                         'uitgeven',
                         'geweest',
                         'geaccepteerd',
                         'bedankt',
                         'bekeken',
                         'gebeld',
                         'bereikt',
                         'begonnen',
                         'gebleven',
                         'gebroken',
                         'gegreven',
                         'gecrashd',
                         'gedaald',
                         'gedankt',
                         'gedaan',
                         'gedood',
                         'geduurd',
                         'geëindigd',
                         'gegeten',
                         'geëxplodeerd',
                         'gehaald',
                         'geheeld',
                         'geholpen',
                         'gelopen',
                         'ingeschreven',
                         'gekeken',
                         'geknapt',
                         'gekomen',
                         'gekocht',
                         'gekregen',
                         'gelaten',
                         'gemaakt',
                         'gemaakt',
                         'genomen',
                         'gepast',
                         'geregend',
                         'gereisd',
                         'geresideerd',
                         'gereden',
                         'gesleten',
                         'gesneeuwd',
                         'gesort',
                         'gesleet',
                         'gespaard',
                         'gesteld',
                         'gestorven',
                         'gestegen',
                         'gestort',
                         'geslaagd',
                         'gestormd',
                         'gespeeld',
                         'gevallen',
                         'verdedigd',
                         'verdubbeld',
                         'vervoegd',
                         'vergangd',
                         'verhuisd',
                         'verloren',
                         'verminderd',
                         'versleten',
                         'verspild',
                         'vervangen',
                         'vertrokken',
                         'gevonden',
                         'gevoeld',
                         'gevolgd',
                         'gevraagd',
                         'verbeterd',
                         'vervallen',
                         'gewerkt',
                         'gewonnen',
                         'gewoond',
                         'geworden',
                         'gezonnen',
                         'gezeten',
                         'gezwollen',
                         'gezegd']),

        'past':     (
                    ['aamde na',
                     'aamden na',
                     'contact opneemde',
                     'contact opneemden',
                     'eette uit',
                     'eetten uit',
                     'gaf uit',
                     'gaven uit',
                     'ging dood',
                     'gingen dood',
                     'het stortte',
                     'het stortten',
                     'was het',
                     'waren het',
                     'knapte op',
                     'knapten op',
                     'kwam aan',
                     'kwamen aan',
                     'leuk vond',
                     'leuk vonden',
                     'loopte af',
                     'loopten af',
                     'schreef in',
                     'schreven in',
                     'stortte in',
                     'stortten in',
                     'studeerde af',
                     'studeerden af',
                     'vaalde om',
                     'vaalden om',
                     'vraagde aan',
                     'vraagden aan',
                     'vroeg aan',
                     'vroegen aan',
                     'ze haalden het',
                     'zij haalden het',
                     'haalde het',
                     'haalden het',                    
                     'zich voelde',
                     'zich voelden',                     
                     'zwelde op',
                     'zwelden op',
                     ],
                    ['was',
                     'waren',
                     'accepteerde',
                     'accepteerden',                     
                     'bedankte',
                     'bedankten',
                     'begoonde',
                     'begoonden',
                     'begon',
                     'begonnen',
                     'bekeek',
                     'bekeeken',
                     'beldde',
                     'beldden',
                     'bereikte',
                     'bereikten',
                     'bleef',
                     'bleven',
                     'brak',
                     'braken',
                     'crashde',
                     'crashden',
                     'crashte',
                     'daalde',
                     'daalden',
                     'dankte',
                     'dankten',
                     'doodde',
                     'doodden',    
                     'deed',
                     'deden',
                     'duurde',
                     'duurden',
                     'eindigde',
                     'eindigden',
                     'at',
                     'aten',
                     'explodeerde',
                     'explodeerden',
                     'gaf',
                     'gaven',
                     'haalde',
                     'haalden',
                     'had',
                     'hadden',
                     'heelde',
                     'heelden',
                     'hielp',
                     'hielpen',
                     'keek',
                     'keken',
                     'knapte',
                     'knapten',
                     'kwam',
                     'kwamen',
                     'kocht',
                     'kochten',
                     'kreeg',
                     'kregen',
                     'liette',#lietten same as present
                     'liep',
                     'liepen',
                     'maakte',
                     'maakten',
                     'paste',
                     'pasten',
                     'reegde',
                     'reegden',
                     'reisde',
                     'reisden',
                     'resideerde',
                     'resideerden',
                     'reed',
                     'reden',
                     'slaagde',
                     'slaagden',
                     'sleette',
                     'sleetten',
                     'sneeuwde',
                     'sneeuwden',
                     'sortte',
                     'sortten',
                     'spaarde',
                     'spaarden',
                     'speelde',
                     'speelden',
                     'stelde',
                     'stelden',
                     'stierf',
                     'stierven',
                     'steeg',
                     'stegen',
                     'stormde',
                     'stormden',
                     'stortte',
                     'stortten',
                     'slaagde',
                     'slaagden',
                     'viel',
                     'vielen',
                     'verdedigde',
                     'verdedigden',
                     'verbeterde',
                     'verbeterden',
                     'verdubbelde',
                     'verdubbelden',
                     'vergangde',
                     'vergangden',
                     'verhuisde',
                     'verhuisden',
                     'verloor',
                     #'verloren',#same as past participle
                     'verminderde',
                     'verminderden',
                     'versleet',
                     'versleten',
                     'verspilde',
                     'verspilden',
                     'vertrok',
                     'vertrokken',
                     'verviel',
                     'vervielen',
                     'verving',
                     'vervingen',
                     'vervoegde',
                     'vervoegden',
                     'vond',
                     'vonden',
                     'voelde',
                     'voelden',
                     'volgde',
                     'volgden',
                     'vraagde',
                     'vraagden',
                     'werkte',
                     'werkten',
                     'won',
                     'wonnen',
                     'woonde',
                     'woonden',
                     'werd',
                     'werden',
                     'zag',
                     'zagen',
                     'zei',
                     'zegde',
                     'zeien',
                     'zegden',
                     'zat',
                     'zaten',
                     'zwol',
                     'zwollen'
                     ]
                    ),
          'future':(['staat op'],#about to
                   ['ga',
                    'gaat',
                    'gat',#common typo
                    'gaan',
                    'zal', 
                    'zullen',
                    'zult', 
                    'zul',
                    'economie.zal',#typo
                    'gaanverliezen'] #misspelling of gaan verleizen, "going to lose"
                   ),
        'verb_poss':([],
                     ['kunnen',
                      'gekund',
                      'kan',
                      'kun',
                      'kunt',
                      'kon' ,
                      'mag',
                      'mogen', #doesn't have primary epistemic uses, more deontic, Nuyts 2000, but included anyway for exploratory pusposes 
                      'vermogen',
                      'vermoogd',
                      'zou',#past tense form of zullen, translated as 'should'/indicates epistemic modality in Broekhuis (2014) + coders/informants agree 
                      'zouden'
                      ] #i.e. mogen + prefix ver-
                     ),
        'verb_cert':([],
                     ['moeten',
                      'moet',
                      'moest',
                      'gemoeten',
                      'moesten'
                      #'wil',
                      #'wilt',
                      #'willen'#no real epistemic use, i.e. "to want", see Nuyts 2000
                      ]
                     ),
        'adv_adj_poss':(['in aanmerking komend',
                         'niet zeker',
                         'zich vast',
                         'een maand of vijf',#about (more or less) 5 months
                         '50%',
                         'de kans is',
                         'niet duidelijk',
                         'is er een kans',
                         'lijkt erop',#looks/seems like
                         'lijkt alsof',#looks/seems like
                         'naar het schijnt'],#it seems 
                        ['aannemelijk',#predsumably (Nuyts 2000)
                         'allichet',#probably
                         'bedenkelijk',
                         'blijkbaar',
                         'denkelijk',
                         'kans',
                         'geschiktlijkend',
                         'hypothetisch',
                         'misschien',#perhaps
                         'msschien',#typo
                         'mogelijk',#possibly
                         'mogelijkerwijs',#possibly
                         'ongeveer',
                         'onzeker',
                         'ogenschijnlijk',#seemingly/apparently
                         'klaarblijkelijk',
                         'schijnbaar',#seemingly
                         'twijfelachtig',
                         'veelbelovend',
                         'vermoedelijk',
                         'waarschijnlijk',
                         'wellicht'#probably
                         ]
                        ),
        'adv_adj_cert':(['wel degelijk',
                         '100%',#expresses certainty in some (1) response
                         'twijfel er niet'#no doubt
                         ],
                        ['absoluut',
                         'alleszins',
                         'allicht',
                         'bepaald',
                         'beslist',
                         'definitief',
                         'doorgansduidelijk',
                         'duidelijk',
                         'echt',
                         'eenvoudigweg',
                         'essentieel',
                         'evident',
                         'fietelijk',
                         'gedwongen',
                         'gegarandeerd',
                         'glashelder',
                         'hoogstwaarschijnlijk',
                         'helder',
                         'inderdaad',
                         'kennelijk',
                         'klaarblijkelijk',
                         'logisch',
                         'natuurlijk',
                         'nodig',
                         'noodzakelijk',
                         'normaal',
                         'ondenkbaar',
                         'onmiskenbaar',
                         'onmogelijk',
                         'onomstotelijk',
                         'ontwijfelbaar',
                         'onvermijdelijk',
                         'onwaarschijnlijk',
                         'onweerlegbaar',
                         'onwrikbaar',
                         'overduidelijk',
                         'overtuigend',
                         'sowieso',
                         'stellig',
                         'uiteraard',
                         'vanzelfsprekend',
                         'vast',#certain
                         'verplicht',
                         'voorgoed',
                         'werkelijk',
                         'wis',
                         'zeker',
                         'ongetwijfeld']#undoubtedly]
                        ),
        'mental_poss':(['volgens mij',
                        'volgens mijn',
                        'houden voor',
                        'niet weten',
                        'neit weet'],
                        ['denk',
                         'denken',
                         'denkt',
                         'geloven',
                         'gelooft',
                         'geloof',
                         'meen',
                         'ment',
                         'menen',
                         'veronderstellen',#to suppose, epistemic use (Nuyts 2000)
                         'veronderstel',
                         'veronderstelt',
                         'vermoed',
                         'vermoedt',
                         'vermoeden',
                         'gehoord',#to hear, possible epistemic/evidential use (Nuyts, 2000)
                         'horen', #to hear, possible epistemic/evidential
                         'hoor',
                         'hoort',
                         'betwijfel',#to doubt, has epistemic use Nuyts (2000)
                         'betwijfelt',
                         'betwijfelen',
                         'annehm',#to assume, but more clear qualificational use than in English (Nuyts 2000)
                         'annehmt',
                         'annehmen',
                         'verwacht',
                         'verwachten'
                         #'zeg', #say, and though can be used as mental state pred use (Nuyts, 2000), it is not in our frames
                         #'zeggen',
                         #'zegt',                         
                         ]
                        ),
        'particle_poss':(['wel eens'],
                         ['wel']
                         ),
        
        'particle_cert':([],
                         ['toch'] #indicates certainty according to coders, informants
                         ),
        
        'particle':(['nou eenmaal',
                     'nu eenmaal'],
                    ['eens',
                     'effe',
                     'es',
                     'even',
                     'entjes',
                     'gewoon',
                     'hoor',
                     'ja',
                     'maar',
                     'nou',
                     'nu']
                    ),
        'will_future':([],
                       ['zal', 
                        'zult',
                        'zul',
                        'zullen',
                        'economie.zal'#typo
                        ]
                       ),
        'go_future':([],
                     ['ga',
                      'gaat',
                      'gaan',
                      'gat',#typo
                      'gaanverliezen']#typo
                     ),
    'verb_des_int':(['het lijkt zo goed'],
                   ['wil',
                    'wilt',
                    'willen',
                    'hoop',
                    'hoopt',
                    'hopen',
                    'plan',
                    'plant',
                    'plannen'])
        }

# =============================================================================
# German word lists
# =============================================================================
german = {'present':(['nutze ab',
                      'nutzt ab',
                      'nutzen ab',
                      'gehe aus',
                      'gehst aus',
                      'geht aus',
                      'gehen aus',
                      'rufe an',
                      'rufst an',
                      'ruft an',
                      'rufen an',
                      'rufe an',
                      'rufst an',
                      'ruft an',
                      'rufen an',
                      'gehe auf',
                      'gehst auf',
                      'geht auf',
                      'gehen auf',
                      'breche zusammen',
                      'brichst zusammen',
                      'bricht zusammen',
                      'brechen zusammen',
                      'brecht zusammen'],
                     ['bin',
                      'bist', 
                      'ist', 
                      'sind',#typo
                      'seid',#typo
                      'sein',
                      'komme',
                      'kommst',
                      'kommt',
                      'kommen',
                      'steige',
                      'steigst',
                      'steigt',
                      'steigen',
                      'bekomme',
                      'bekommst',
                      'bekommt',
                      'bekommen',
                      'mache',
                      'machst',
                      'macht',
                      'machen',
                      'nutzen',
                      'nutze',
                      'nutzt',
                      'habe',
                      'hast',
                      'hat',
                      'haben',
                      'habt',
                      'arbeite',
                      'arbeitest',
                      'arbeitet',
                      'arbeiten',
                      'fühle',
                      'fühlst',
                      'fühlt',
                      'fühlen',
                      'fuehlst',
                      'gewinne',
                      'gewinnst',
                      'gewinnt',
                      'gewinnen',
                      'regne',
                      'regnest',
                      'regnet',
                      'regnen',
                      'kaufe',
                      'kaufst',
                      'kauft',
                      'kaufen',
                      'sterbe',
                      'stirbst',
                      'stirbt',
                      'sterben',
                      'sterbt',
                      'reise',
                      'reist',
                      'reisen',
                      'ruft',
                      'rufst',
                      'rufe',
                      'rufen',
                      'gehe',
                      'gehst',
                      'geht',
                      'gehen',
                      'liebe',
                      'liebst',
                      'liebt',
                      'lieben',
                      'lebe', 
                      'lebst', 
                      'lebt', 
                      'leben'
                       ]),

    'present_perfect':([],
                       []),#no german aspect (exp. # 5 just on dutch+english)
                       
    'past_perfect':([],
                    []),
                    
    'past_participle':([],
                       []),
                       
    'past':([],
            []),#no german past yet (exp. # 5 just on dutch+english)
            
    'future': ([],
               ['werde',
                'wirst',
                'wird',
                'werden',
                'werdet',
                'werden',
                'wirdt'#typo
                ]
               ),
    'verb_poss':([],
                 [#indicative of können
                  'kann',
                  'kannst',
                  'könnt',
                  'können',
                  
                  #konjunktiv ii of können
                  'könnte',
                  'könntest',
                  'könnten',
                  'könntet',
                  
                  #may have some epistemic use, but not typical, as in english ''should' (Nuyts 2000). Both konjunctiv ii and indicative included    
                  'sollen',
                  'soll',
                  'sollst',
                  'sollt',
                  
                  #konjunktiv ii
                  'sollte',
                  'solltest',
                  'sollten',
                  'solltet',
                  
                  #indicative dürfen cannot have epistemic uses, only deontic (Nuyts, 2000)
                  #'darf',
                  #'darfst',
                  #'dürfen',
                  #'dürft',
                  
                  #konjunktiv ii of ¨dürfen
                  'dürfte',
                  'dürftest',
                  'dürften',
                  'dürftet',
                  
                  #mogen 'may' in the indicative has epistemic uses, but not konjunktiv ii (Nuyts 2000)
                  'mag',
                  'magst',
                  'mögen',
                  'mögt',
                  
                  
                  ##konjuntiv of werden, i.e. 'would' with epistemic uses: according to informant/coder
                  'würde',
                  'würdest',
                  'würden',
                  'würdet',
                  
                  #konjunktiv ii of müssen has epistemic uses, like 'should' (Mortelmans 2000).
                  'müßte',
                  'müßtest',
                  'müßten',
                  'müßtet',
                  'müsste',
                  'müsstest',
                  'müssten',
                  'müsstet']
                 ),
    
    'verb_cert':([],
                 ['muss',
                  'musst',
                  'müssen',
                  'müsst',
                  'muß',
                  'mußt',
                  'müßen',
                  'müßt']
                 ),
    
    'adv_adj_poss':(['unter umständen'],
                    ['annehmbar',#presumably (Nuyts 2000)
                     'eventuell',
                     'anscheinend',
                     'gegebenenfalls',
                     'wahrscheinlichkeit',#probability -- informant coder
                     'möglich',
                     'möglicherweise',
                     'offenbar',
                     'scheinbar',#seemingly
                     #'vielleicht',
                     'vermutlich',#presumably (Nuyts 2000)
                     'wahrscheinlich',
                     'womöglich']#maybe
                    ),
    
    'adv_adj_cert':(['auf jeden fall',
                     'klipp und klar'],
                    ['aufjedenfall',
                     'augenscheinlich',#evidently
                     'bestimmt',#certainly
                     'definitiv',
                     'deutlich',#clearly
                     'eindeutig',
                     'gewiss',
                     'klar',
                     'offensichtlich',#obviously
                     'jedenfalls',
                     'sicher',#certainly (Nuyts 2000)
                     'sicherlich',#certainly
                     'zweifelsohne',#certainly
                     'zweifellos'#certainly
                     ]
                    ),
    
    'mental_poss':(['nehme an',
                    'nimmst an',
                    'nimmt an',
                    'nehmen an',
                    'nehmt an'], #assume, but with more clear qualificational use 
                   ['denke',
                    'denkst',
                    'denkt',
                    'denken',
                    'glaube',
                    'glaubst',
                    'glaubt',
                    'glauben',# Nuyts 2000
                    'meine',
                    'meinst',
                    'meint',
                    'meinen', # to mean, no qualificational use in english, but stronger in german, and menen, too in dutch (Nuyts 2000)
                    'vermuten',#to presume (outdated in engish mostly, (Nuyts, 2000))
                    'vermute',
                    'vermutest',
                    'vermutet',
                    'rechne',#reckon, qulaificational use, (Nuyts 2000)
                    'rechnest',
                    'rechnet',
                    'rechnen',
                    #'sage',#while this can be used epistemically, none of the question frames do so
                    #'sagst',# and do use 'to say' in non epistemic ways
                    #'sagt',
                    #'sagen',
                    'erwarte',
                    'erwartest',
                    'erwartet',
                    'erwarten'
                    ]
                    ),
    
    'particle_poss':([],
                     ['wohl',
                      'vielleicht']
                      ),
    
    'particle_cert':([],
                     []
                     ),
    
    'particle':([],
                 ['aber',
                  'auch',
                  'bloß',
                  'denn',
                  'doch',
                  'eigentlich',
                  'eben',
                  'etwa',
                  'einfach',
                  'erst',
                  'halt',
                  'ja',
                  'nun',
                  'mal',
                  'nur',
                  'schon',
                  'vielleicht',
                  'ruhig']
                 ),
    
    'will_future': ([],
                  ['werde',
                   'wirst',
                   'wird',
                   'werden',
                   'werdet',
                   'werden']),
    
     'go_future':([],
                  []
                   ),
     
     'verb_des_int':([],
                   ['will',
                    'willst',
                    'wollen',
                    'wollt',
                    'wollen',
                    ##konjunktiv ii of mogen meaning to want/would like
                    'möchte',
                    'möchtest',
                    'möchten',
                    'möchtet',
                    'hoffe',#hope
                    'hoffst',
                    'hofft',
                    'hoffen',
                    'plane',
                    'planst',
                    'plant',
                    'plannen'
                    ])
     }

# =============================================================================
# Create master dictionaries
# =============================================================================
WORD_LISTS = {
        'english':english,
        'dutch':dutch,
        'german':german
            }