#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `SETUP_TEMPLATE.py.jinja2` IN the `dev/provider_packages` DIRECTORY

"""Setup.py for the apache-airflow-backport-providers-google package."""

import logging
import os

from os.path import dirname
from setuptools import find_namespace_packages, setup

logger = logging.getLogger(__name__)

version = '2021.2.5rc1'

my_dir = dirname(__file__)

try:
    with open(os.path.join(my_dir, 'README.md'), encoding='utf-8') as f:
        long_description = f.read()
except FileNotFoundError:
    long_description = ''


def do_setup():
    """Perform the package apache-airflow-backport-providers-google setup."""
    setup(
        name='apache-airflow-backport-providers-google',
        description='Backport provider package '
        'apache-airflow-backport-providers-google for Apache Airflow',
        long_description=long_description,
        long_description_content_type='text/markdown',
        license='Apache License 2.0',
        version=version,
        packages=find_namespace_packages(include=['airflow.providers.google', 'airflow.providers.google.*']),
        zip_safe=False,
        include_package_data=True,
        install_requires=[
            'apache-airflow~=1.10',
            'PyOpenSSL',
            'google-ads>=4.0.0,<8.0.0',
            'google-api-core>=1.25.1,<2.0.0',
            'google-api-python-client>=1.6.0,<2.0.0',
            'google-auth-httplib2>=0.0.1',
            'google-auth>=1.0.0,<2.0.0',
            'google-cloud-automl>=2.1.0,<3.0.0',
            'google-cloud-bigquery-datatransfer>=3.0.0,<4.0.0',
            'google-cloud-bigtable>=1.0.0,<2.0.0',
            'google-cloud-container>=0.1.1,<2.0.0',
            'google-cloud-datacatalog>=3.0.0,<4.0.0',
            'google-cloud-dataproc>=2.2.0,<3.0.0',
            'google-cloud-dlp>=0.11.0,<2.0.0',
            'google-cloud-kms>=2.0.0,<3.0.0',
            'google-cloud-language>=1.1.1,<2.0.0',
            'google-cloud-logging>=2.1.1,<3.0.0',
            'google-cloud-memcache>=0.2.0',
            'google-cloud-monitoring>=2.0.0,<3.0.0',
            'google-cloud-os-login>=2.0.0,<3.0.0',
            'google-cloud-pubsub>=2.0.0,<3.0.0',
            'google-cloud-redis>=2.0.0,<3.0.0',
            'google-cloud-secret-manager>=0.2.0,<2.0.0',
            'google-cloud-spanner>=1.10.0,<2.0.0',
            'google-cloud-speech>=0.36.3,<2.0.0',
            'google-cloud-storage>=1.30,<2.0.0',
            'google-cloud-tasks>=2.0.0,<3.0.0',
            'google-cloud-texttospeech>=0.4.0,<2.0.0',
            'google-cloud-translate>=1.5.0,<2.0.0',
            'google-cloud-videointelligence>=1.7.0,<2.0.0',
            'google-cloud-vision>=0.35.2,<2.0.0',
            'google-cloud-workflows>=0.1.0,<2.0.0',
            'grpcio-gcp>=0.2.2',
            'json-merge-patch~=0.2',
            'pandas-gbq',
        ],
        setup_requires=['setuptools', 'wheel'],
        extras_require={
            'amazon': ['apache-airflow-backport-providers-amazon'],
            'apache.beam': ['apache-airflow-backport-providers-apache-beam'],
            'apache.cassandra': ['apache-airflow-backport-providers-apache-cassandra'],
            'cncf.kubernetes': ['apache-airflow-backport-providers-cncf-kubernetes'],
            'facebook': ['apache-airflow-backport-providers-facebook'],
            'microsoft.azure': ['apache-airflow-backport-providers-microsoft-azure'],
            'microsoft.mssql': ['apache-airflow-backport-providers-microsoft-mssql'],
            'mysql': ['apache-airflow-backport-providers-mysql'],
            'oracle': ['apache-airflow-backport-providers-oracle'],
            'postgres': ['apache-airflow-backport-providers-postgres'],
            'presto': ['apache-airflow-backport-providers-presto'],
            'salesforce': ['apache-airflow-backport-providers-salesforce'],
            'sftp': ['apache-airflow-backport-providers-sftp'],
            'ssh': ['apache-airflow-backport-providers-ssh'],
        },
        classifiers=[
            'Development Status :: 5 - Production/Stable',
            'Environment :: Console',
            'Environment :: Web Environment',
            'Intended Audience :: Developers',
            'Intended Audience :: System Administrators',
            'License :: OSI Approved :: Apache Software License',
            'Programming Language :: Python :: 3.6',
            'Programming Language :: Python :: 3.7',
            'Programming Language :: Python :: 3.8',
            'Topic :: System :: Monitoring',
        ],
        author='Apache Software Foundation',
        author_email='dev@airflow.apache.org',
        url='https://airflow.apache.org/',
        download_url='https://archive.apache.org/dist/airflow/backport-providers',
        python_requires='~=3.6',
        project_urls={
            'Documentation': 'https://airflow.apache.org/docs/',
            'Bug Tracker': 'https://github.com/apache/airflow/issues',
            'Source Code': 'https://github.com/apache/airflow',
        },
    )


if __name__ == "__main__":
    do_setup()
