__author__ = "Aleksandr Slepchenkov"
__email__ = "Sl.aleksandr28@gmail.com"

from typing import Any, Optional, Pattern, List, Text, Tuple, Dict, Match, Type, Sequence, Iterable

Tokens = List[Dict[Text, Any]]
# There are too much levels of optional unions of lists of text in cell and align 385 and 396 lines in mistune


def escape(text: Text, quote: bool = ..., smart_amp: bool = ...) -> Text: ...


class BlockGrammar:
    def_links = ...  # type: Pattern
    def_footnotes = ...  # type: Pattern
    newline = ...  # type: Pattern
    block_code = ...  # type: Pattern
    fences = ...  # type: Pattern
    hrule = ...  # type: Pattern
    heading = ...  # type: Pattern
    lheading = ...  # type: Pattern
    block_quote = ...  # type: Pattern
    list_block = ...  # type: Pattern
    list_item = ...  # type: Pattern
    list_bullet = ...  # type: Pattern
    paragraph = ...  # type: Pattern
    block_html = ...  # type: Pattern
    table = ...  # type: Pattern
    nptable = ...  # type: Pattern
    text = ...  # type: Pattern


class BlockLexer:
    grammar_class = ...  # type: Type[BlockGrammar]
    default_rules = ...  # type: List[Text]
    list_rules = ...  # type: Tuple[Text]
    footnote_rules = ...  # type: Tuple[Text]
    tokens = ...  # type: Tokens
    def_links = ...  # type: Dict[Text, Dict[Text, Text]]
    def_footnotes = ...  # type: Dict[Text, int]
    rules = ...  # type: BlockGrammar

    def __init__(self, rules: Optional[BlockGrammar] = ..., **kwargs) -> None: ...

    def __call__(self, text: Text, rules: Optional[Sequence[Text]] = ...) -> Tokens: ...

    def parse(self, text: Text, rules: Optional[Sequence[Text]] = ...) -> Tokens: ...

    def parse_newline(self, m: Match) -> None: ...

    def parse_block_code(self, m: Match) -> None: ...

    def parse_fences(self, m: Match) -> None: ...

    def parse_heading(self, m: Match) -> None: ...

    def parse_lheading(self, m: Match) -> None: ...

    def parse_hrule(self, m: Match) -> None: ...

    def parse_list_block(self, m: Match) -> None: ...

    def parse_block_quote(self, m: Match) -> None: ...

    def parse_def_links(self, m: Match) -> None: ...

    def parse_def_footnotes(self, m: Match) -> None: ...

    def parse_table(self, m: Match) -> None: ...

    def parse_nptable(self, m: Match) -> None: ...

    def parse_block_html(self, m: Match) -> None: ...

    def parse_paragraph(self, m: Match) -> None: ...

    def parse_text(self, m: Match) -> None: ...


class InlineGrammar:
    escape = ...  # type: Pattern
    inline_html = ...  # type: Pattern
    autolink = ...  # type: Pattern
    link = ...  # type: Pattern
    reflink = ...  # type: Pattern
    nolink = ...  # type: Pattern
    url = ...  # type: Pattern
    double_emphasis = ...  # type: Pattern
    emphasis = ...  # type: Pattern
    code = ...  # type: Pattern
    linebreak = ...  # type: Pattern
    strikethrough = ...  # type: Pattern
    footnote = ...  # type: Pattern
    text = ...  # type: Pattern

    def hard_wrap(self) -> None: ...


class InlineLexer:
    grammar_class = ...  # type: Type[InlineGrammar]
    default_rules = ...  # type: List[Text]
    inline_html_rules = ...  # type: List[Text]
    renderer = ...  # type: Renderer
    links = ...  # type: Dict[Any, Dict]
    footnotes = ...  # type: Dict[Text, int]
    footnote_index = ...  # type: int
    _in_link = ...  # type: bool
    _in_footnote = ...  # type: bool
    _parse_inline_html = ...  # type: bool
    rules = ...  # type: InlineGrammar

    def __init__(self, renderer: Renderer, rules: Optional[InlineGrammar] = ..., **kwargs) -> None: ...

    def __call__(self, text: Text, rules: Optional[Sequence[Text]] = ...) -> Text: ...

    def setup(self, links: Optional[Dict[Any, Dict]], footnotes: Optional[Dict[Text, int]]) -> None: ...

    line_match = ...  # type: Match
    line_started = ...  # type: bool

    def output(self, text: Text, rules: Optional[Sequence[Text]] = ...) -> Text: ...

    def output_escape(self, m: Match) -> Text: ...

    def output_autolink(self, m: Match) -> Text: ...

    def output_url(self, m: Match) -> Text: ...

    def output_inline_html(self, m: Match) -> Text: ...

    def output_footnote(self, m: Match) -> Optional[Text]: ...

    def output_link(self, m: Match) -> Text: ...

    def output_reflink(self, m: Match) -> Optional[Text]: ...

    def output_nolink(self, m: Match) -> Optional[Text]: ...

    def output_double_emphasis(self, m: Match) -> Text: ...

    def output_emphasis(self, m: Match) -> Text: ...

    def output_code(self, m: Match) -> Text: ...

    def output_linebreak(self, m: Match) -> Text: ...

    def output_strikethrough(self, m: Match) -> Text: ...

    def output_text(self, m: Match) -> Text: ...


class Renderer:
    options = ...  # type: Dict

    def __init__(self, **kwargs) -> None: ...

    def placeholder(self) -> Text: ...

    def block_code(self, code: Text,
                   lang: Any = ...) -> Text: ...  # It seems that lang should be string, however other types are valid as well

    def block_quote(self, text: Text) -> Text: ...

    def block_html(self, html: Text) -> Text: ...

    def header(self, text: Text, level: int, raw: Optional[Text] = ...) -> Text: ...

    def hrule(self) -> Text: ...

    def list(self, body: Any,
             ordered: bool = ...) -> Text: ...  # body - same reason as for lang above, and for other Any in this class

    def list_item(self, text: Any) -> Text: ...

    def paragraph(self, text: Text) -> Text: ...

    def table(self, header: Any, body: Any) -> Text: ...

    def table_row(self, content: Any) -> Text: ...

    def table_cell(self, content: Any, **flags) -> Text: ...

    def double_emphasis(self, text: Any) -> Text: ...

    def emphasis(self, text: Any) -> Text: ...

    def codespan(self, text: Text) -> Text: ...

    def linebreak(self) -> Text: ...

    def strikethrough(self, text: Any) -> Text: ...

    def text(self, text: Any) -> Text: ...

    def escape(self, text: Any) -> Text: ...

    def autolink(self, link: Any, is_email: bool = ...) -> Text: ...

    def link(self, link: Any, title: Any, text: Any) -> Text: ...

    def image(self, src: Any, title: Any, text: Any) -> Text: ...

    def inline_html(self, html: Any) -> Text: ...

    def newline(self) -> Text: ...

    def footnote_ref(self, key: Any, index: int) -> Text: ...

    def footnote_item(self, key: Any, text: Text) -> Text: ...

    def footnotes(self, text: Any) -> Text: ...


class Markdown:
    renderer = ...  # type: Renderer
    inline = ...  # type: InlineLexer
    block = ...  # type: BlockLexer
    footnotes = ...  # type: List[Dict[Text, Any]]
    tokens = ...  # type: Tokens

    def __init__(self, renderer: Optional[Renderer] = ..., inline: Optional[InlineLexer] = ...,
                 block: Optional[BlockLexer] = ..., **kwargs) -> None: ...

    def __call__(self, text: Text) -> Text: ...

    def render(self, text: Text) -> Text: ...

    def parse(self, text: Text) -> Text: ...

    token = ...  # type: Dict[Text, Any]

    def pop(self) -> Optional[Dict[Text, Any]]: ...

    def peek(self) -> Optional[Dict[Text, Any]]: ...

    def output(self, text: Text, rules: Optional[Sequence[Text]] = ...): ...

    def tok(self) -> Text: ...

    def tok_text(self) -> Text: ...

    def output_newline(self) -> Text: ...

    def output_hrule(self) -> Text: ...

    def output_heading(self) -> Text: ...

    def output_code(self) -> Text: ...

    def output_table(self) -> Text: ...

    def output_block_quote(self) -> Text: ...

    def output_list(self) -> Text: ...

    def output_list_item(self) -> Text: ...

    def output_loose_item(self) -> Text: ...

    def output_footnote(self) -> Text: ...

    def output_close_html(self) -> Text: ...

    def output_open_html(self) -> Text: ...

    def output_paragraph(self) -> Text: ...

    def output_text(self) -> Text: ...


def markdown(text: Text, escape: bool = ..., **kwargs) -> Text: ...