# Stubs for avro.schema (Python 2)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any, Union, Dict, List, Text

PRIMITIVE_TYPES = ... # type: Any
NAMED_TYPES = ... # type: Any
VALID_TYPES = ... # type: Any
SCHEMA_RESERVED_PROPS = ... # type: Any
FIELD_RESERVED_PROPS = ... # type: Any
VALID_FIELD_SORT_ORDERS = ... # type: Any

class AvroException(Exception): ...
class SchemaParseException(AvroException): ...

class Schema:
    type = ... # type: Any
    def __init__(self, type, other_props=None): ...
    props = ... # type: Any
    other_props = ... # type: Any
    def get_prop(self, key): ...
    def set_prop(self, key, value): ...
    def to_json(self, names): ...

class Name:
    def __init__(self, name_attr, space_attr, default_space): ...
    def __eq__(self, other): ...
    fullname = ... # type: Any
    def get_space(self): ...

class Names:
    names = ... # type: Any
    default_namespace = ... # type: Any
    def __init__(self, default_namespace: Union[str, Text] = None) -> None: ...
    def has_name(self, name_attr: Union[str, Text], space_attr: Union[str, Text]) -> bool: ...
    def get_name(self, name_attr: Union[str, Text], space_attr: Union[str, Text]) -> Schema: ...
    def prune_namespace(self, properties): ...
    def add_name(self, name_attr, space_attr, new_schema): ...

class NamedSchema(Schema):
    def __init__(self, type, name, namespace=None, names=None, other_props=None): ...
    def name_ref(self, names): ...
    name = ... # type: Any
    namespace = ... # type: Any
    fullname = ... # type: Any

class Field:
    type = ... # type: Any
    name = ... # type: Any
    def __init__(self, type, name, has_default, default=None, order=None, names=None, doc=None, other_props=None): ...
    default = ... # type: Any
    has_default = ... # type: Any
    order = ... # type: Any
    doc = ... # type: Any
    props = ... # type: Any
    other_props = ... # type: Any
    def get_prop(self, key): ...
    def set_prop(self, key, value): ...
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class PrimitiveSchema(Schema):
    fullname = ... # type: Any
    def __init__(self, type, other_props=None): ...
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class FixedSchema(NamedSchema):
    def __init__(self, name, namespace, size, names=None, other_props=None): ...
    size = ... # type: Any
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class EnumSchema(NamedSchema):
    def __init__(self, name, namespace, symbols, names=None, doc=None, other_props=None): ...
    symbols = ... # type: Any
    doc = ... # type: Any
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class ArraySchema(Schema):
    def __init__(self, items, names=None, other_props=None): ...
    items = ... # type: Any
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class MapSchema(Schema):
    def __init__(self, values, names=None, other_props=None): ...
    values = ... # type: Any
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class UnionSchema(Schema):
    def __init__(self, schemas, names=None): ...
    schemas = ... # type: Any
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

class ErrorUnionSchema(UnionSchema):
    def __init__(self, schemas, names=None): ...
    def to_json(self, names=None): ...

class RecordSchema(NamedSchema):
    @staticmethod
    def make_field_objects(field_data, names): ...
    def __init__(self, name, namespace, fields, names=None, schema_type='', doc=None, other_props=None): ...
    fields = ... # type: Any
    doc = ... # type: Any
    @property
    def fields_dict(self): ...
    def to_json(self, names=None): ...
    def __eq__(self, that): ...

def get_other_props(all_props, reserved_props): ...
def make_avsc_object(json_data: Union[Dict, List, str], names: Names) -> Schema: ...
def parse(json_string): ...
