# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List


class Config(TeaModel):
    """
    Model for initing client
    """
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        security_token: str = None,
        protocol: str = None,
        read_timeout: int = None,
        connect_timeout: int = None,
        http_proxy: str = None,
        https_proxy: str = None,
        endpoint: str = None,
        no_proxy: str = None,
        max_idle_conns: int = None,
        user_agent: str = None,
        socks_5proxy: str = None,
        socks_5net_work: str = None,
        max_idle_time_millis: int = None,
        keep_alive_duration_millis: int = None,
        max_requests: int = None,
        max_requests_per_host: int = None,
    ):
        # accesskey id
        self.access_key_id = access_key_id
        # accesskey secret
        self.access_key_secret = access_key_secret
        # security token
        self.security_token = security_token
        # http protocol
        self.protocol = protocol
        # read timeout
        self.read_timeout = read_timeout
        # connect timeout
        self.connect_timeout = connect_timeout
        # http proxy
        self.http_proxy = http_proxy
        # https proxy
        self.https_proxy = https_proxy
        # endpoint
        self.endpoint = endpoint
        # proxy white list
        self.no_proxy = no_proxy
        # max idle conns
        self.max_idle_conns = max_idle_conns
        # user agent
        self.user_agent = user_agent
        # socks5 proxy
        self.socks_5proxy = socks_5proxy
        # socks5 network
        self.socks_5net_work = socks_5net_work
        # 长链接最大空闲时长
        self.max_idle_time_millis = max_idle_time_millis
        # 长链接最大连接时长
        self.keep_alive_duration_millis = keep_alive_duration_millis
        # 最大连接数（长链接最大总数）
        self.max_requests = max_requests
        # 每个目标主机的最大连接数（分主机域名的长链接最大总数
        self.max_requests_per_host = max_requests_per_host

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.read_timeout is not None:
            result['readTimeout'] = self.read_timeout
        if self.connect_timeout is not None:
            result['connectTimeout'] = self.connect_timeout
        if self.http_proxy is not None:
            result['httpProxy'] = self.http_proxy
        if self.https_proxy is not None:
            result['httpsProxy'] = self.https_proxy
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.no_proxy is not None:
            result['noProxy'] = self.no_proxy
        if self.max_idle_conns is not None:
            result['maxIdleConns'] = self.max_idle_conns
        if self.user_agent is not None:
            result['userAgent'] = self.user_agent
        if self.socks_5proxy is not None:
            result['socks5Proxy'] = self.socks_5proxy
        if self.socks_5net_work is not None:
            result['socks5NetWork'] = self.socks_5net_work
        if self.max_idle_time_millis is not None:
            result['maxIdleTimeMillis'] = self.max_idle_time_millis
        if self.keep_alive_duration_millis is not None:
            result['keepAliveDurationMillis'] = self.keep_alive_duration_millis
        if self.max_requests is not None:
            result['maxRequests'] = self.max_requests
        if self.max_requests_per_host is not None:
            result['maxRequestsPerHost'] = self.max_requests_per_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('readTimeout') is not None:
            self.read_timeout = m.get('readTimeout')
        if m.get('connectTimeout') is not None:
            self.connect_timeout = m.get('connectTimeout')
        if m.get('httpProxy') is not None:
            self.http_proxy = m.get('httpProxy')
        if m.get('httpsProxy') is not None:
            self.https_proxy = m.get('httpsProxy')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('noProxy') is not None:
            self.no_proxy = m.get('noProxy')
        if m.get('maxIdleConns') is not None:
            self.max_idle_conns = m.get('maxIdleConns')
        if m.get('userAgent') is not None:
            self.user_agent = m.get('userAgent')
        if m.get('socks5Proxy') is not None:
            self.socks_5proxy = m.get('socks5Proxy')
        if m.get('socks5NetWork') is not None:
            self.socks_5net_work = m.get('socks5NetWork')
        if m.get('maxIdleTimeMillis') is not None:
            self.max_idle_time_millis = m.get('maxIdleTimeMillis')
        if m.get('keepAliveDurationMillis') is not None:
            self.keep_alive_duration_millis = m.get('keepAliveDurationMillis')
        if m.get('maxRequests') is not None:
            self.max_requests = m.get('maxRequests')
        if m.get('maxRequestsPerHost') is not None:
            self.max_requests_per_host = m.get('maxRequestsPerHost')
        return self


class SchemaMetadataDO(TeaModel):
    def __init__(
        self,
        app: str = None,
        compatibility: str = None,
        coordinate: str = None,
        description: str = None,
        name: str = None,
        namespace: str = None,
        operator: str = None,
        state: str = None,
        sync_sites: str = None,
        tenant: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        serialization: str = None,
    ):
        # app名称
        self.app = app
        # 兼容性
        self.compatibility = compatibility
        # 坐标依赖
        self.coordinate = coordinate
        # 描述
        self.description = description
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 操作人
        self.operator = operator
        # 状态
        self.state = state
        # 同步站点
        self.sync_sites = sync_sites
        # 租户
        self.tenant = tenant
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # Schema指定的序列化方式
        self.serialization = serialization

    def validate(self):
        self.validate_required(self.app, 'app')
        self.validate_required(self.compatibility, 'compatibility')
        self.validate_required(self.coordinate, 'coordinate')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.state, 'state')
        self.validate_required(self.sync_sites, 'sync_sites')
        self.validate_required(self.tenant, 'tenant')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.serialization, 'serialization')

    def to_map(self):
        result = dict()
        if self.app is not None:
            result['app'] = self.app
        if self.compatibility is not None:
            result['compatibility'] = self.compatibility
        if self.coordinate is not None:
            result['coordinate'] = self.coordinate
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operator is not None:
            result['operator'] = self.operator
        if self.state is not None:
            result['state'] = self.state
        if self.sync_sites is not None:
            result['sync_sites'] = self.sync_sites
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.serialization is not None:
            result['serialization'] = self.serialization
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('compatibility') is not None:
            self.compatibility = m.get('compatibility')
        if m.get('coordinate') is not None:
            self.coordinate = m.get('coordinate')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('sync_sites') is not None:
            self.sync_sites = m.get('sync_sites')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('serialization') is not None:
            self.serialization = m.get('serialization')
        return self


class SwitchoverAction(TeaModel):
    def __init__(
        self,
        dest_cell: str = None,
        source_cell: str = None,
    ):
        # 目标单元
        self.dest_cell = dest_cell
        # 来源单元
        self.source_cell = source_cell

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class ResourceLabelsDTO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_type: str = None,
        resource_name: str = None,
        labels: List[str] = None,
    ):
        # 实例 ID（命名空间）
        self.instance_id = instance_id
        # 资源类型：TOPIC、GROUP
        self.resource_type = resource_type
        # 资源名字
        self.resource_name = resource_name
        # 标签
        self.labels = labels

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_name, 'resource_name')
        self.validate_required(self.labels, 'labels')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.resource_name is not None:
            result['resource_name'] = self.resource_name
        if self.labels is not None:
            result['labels'] = self.labels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('resource_name') is not None:
            self.resource_name = m.get('resource_name')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        return self


class SchemaMetadataPageDO(TeaModel):
    def __init__(
        self,
        content: List[SchemaMetadataDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # Metadata列表内容
        self.content = content
        # 页号
        self.page_num = page_num
        # 页大小
        self.page_size = page_size
        # 总个数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = SchemaMetadataDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class SubClientInfoDTO(TeaModel):
    def __init__(
        self,
        client_host: str = None,
        cost_time: int = None,
        reconsume_times: int = None,
        status: str = None,
        sub_group_name: str = None,
        sub_time: int = None,
    ):
        # 消费客户端的客户端地址
        self.client_host = client_host
        # 本次消费耗时，单位毫秒
        self.cost_time = cost_time
        # 本次消费的投递轮次
        self.reconsume_times = reconsume_times
        # 消费状态。取值说明如下：
        # 
        # CONSUME_FAILED：消费失败
        # CONSUME_SUCCESS：消费成功
        # CONSUME_NOT_RETURN：消费未返回结果
        # SEND_UNKNOWN：事务消息未提交
        # SEND_DELAY：定时(延时)消息定时中
        self.status = status
        # 该客户端所属的 Group ID
        self.sub_group_name = sub_group_name
        # 消费开始时间戳
        self.sub_time = sub_time

    def validate(self):
        self.validate_required(self.client_host, 'client_host')
        self.validate_required(self.cost_time, 'cost_time')
        self.validate_required(self.reconsume_times, 'reconsume_times')
        self.validate_required(self.status, 'status')
        self.validate_required(self.sub_group_name, 'sub_group_name')
        self.validate_required(self.sub_time, 'sub_time')

    def to_map(self):
        result = dict()
        if self.client_host is not None:
            result['client_host'] = self.client_host
        if self.cost_time is not None:
            result['cost_time'] = self.cost_time
        if self.reconsume_times is not None:
            result['reconsume_times'] = self.reconsume_times
        if self.status is not None:
            result['status'] = self.status
        if self.sub_group_name is not None:
            result['sub_group_name'] = self.sub_group_name
        if self.sub_time is not None:
            result['sub_time'] = self.sub_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_host') is not None:
            self.client_host = m.get('client_host')
        if m.get('cost_time') is not None:
            self.cost_time = m.get('cost_time')
        if m.get('reconsume_times') is not None:
            self.reconsume_times = m.get('reconsume_times')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_group_name') is not None:
            self.sub_group_name = m.get('sub_group_name')
        if m.get('sub_time') is not None:
            self.sub_time = m.get('sub_time')
        return self


class ComponentContent(TeaModel):
    def __init__(
        self,
        content: str = None,
        url: str = None,
        bold: bool = None,
    ):
        # 文本内容
        self.content = content
        # 超链接
        self.url = url
        # 是否粗体
        self.bold = bold

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.bold, 'bold')

    def to_map(self):
        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.url is not None:
            result['url'] = self.url
        if self.bold is not None:
            result['bold'] = self.bold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('bold') is not None:
            self.bold = m.get('bold')
        return self


class ColumnValue(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 名称
        self.name = name
        # 值
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UIOptionModel(TeaModel):
    def __init__(
        self,
        display: str = None,
        value: str = None,
    ):
        # 选项展示的中文描述
        self.display = display
        # 选项的枚举值
        self.value = value

    def validate(self):
        self.validate_required(self.display, 'display')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.display is not None:
            result['display'] = self.display
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('display') is not None:
            self.display = m.get('display')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ThreadTrackDTO(TeaModel):
    def __init__(
        self,
        thread: str = None,
        track_list: List[str] = None,
    ):
        # 线程名称
        self.thread = thread
        # Jstack 堆栈信息字符串
        self.track_list = track_list

    def validate(self):
        self.validate_required(self.thread, 'thread')
        self.validate_required(self.track_list, 'track_list')

    def to_map(self):
        result = dict()
        if self.thread is not None:
            result['thread'] = self.thread
        if self.track_list is not None:
            result['track_list'] = self.track_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('thread') is not None:
            self.thread = m.get('thread')
        if m.get('track_list') is not None:
            self.track_list = m.get('track_list')
        return self


class SubscriptionDTO(TeaModel):
    def __init__(
        self,
        sub_string: str = None,
        sub_version: int = None,
        tags_set: List[str] = None,
        topic: str = None,
    ):
        # 订阅该 Topic 的子类别 Tag 表达式
        self.sub_string = sub_string
        # 订阅关系版本号，为自增 Long 型
        self.sub_version = sub_version
        # 订阅的 Tag 集合
        self.tags_set = tags_set
        # 订阅的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.sub_string, 'sub_string')
        self.validate_required(self.sub_version, 'sub_version')
        self.validate_required(self.tags_set, 'tags_set')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.sub_string is not None:
            result['sub_string'] = self.sub_string
        if self.sub_version is not None:
            result['sub_version'] = self.sub_version
        if self.tags_set is not None:
            result['tags_set'] = self.tags_set
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sub_string') is not None:
            self.sub_string = m.get('sub_string')
        if m.get('sub_version') is not None:
            self.sub_version = m.get('sub_version')
        if m.get('tags_set') is not None:
            self.tags_set = m.get('tags_set')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ItemComponent(TeaModel):
    def __init__(
        self,
        contents: List[ComponentContent] = None,
    ):
        # 内容
        self.contents = contents

    def validate(self):
        self.validate_required(self.contents, 'contents')
        if self.contents:
            for k in self.contents:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['contents'] = []
        if self.contents is not None:
            for k in self.contents:
                result['contents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contents = []
        if m.get('contents') is not None:
            for k in m.get('contents'):
                temp_model = ComponentContent()
                self.contents.append(temp_model.from_map(k))
        return self


class MessagePropertyDTO(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # Key 名
        self.name = name
        # 值
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ConsumerRunningDataDTO(TeaModel):
    def __init__(
        self,
        diff: int = None,
        failed_count_per_hour: int = None,
        failed_tps: str = None,
        group_id: str = None,
        ok_tps: str = None,
        rt: str = None,
        topic: str = None,
    ):
        # 堆积量
        self.diff = diff
        # 每小时内消费失败的消息数统计
        self.failed_count_per_hour = failed_count_per_hour
        # 消费消息失败的 TPS 统计
        self.failed_tps = failed_tps
        # 订阅方的 Group ID
        self.group_id = group_id
        # 消费消息成功的 TPS 统计
        self.ok_tps = ok_tps
        # 消费 RT 时间，单位 ms
        self.rt = rt
        # 订阅的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.diff, 'diff')
        self.validate_required(self.failed_count_per_hour, 'failed_count_per_hour')
        self.validate_required(self.failed_tps, 'failed_tps')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.ok_tps, 'ok_tps')
        self.validate_required(self.rt, 'rt')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.diff is not None:
            result['diff'] = self.diff
        if self.failed_count_per_hour is not None:
            result['failed_count_per_hour'] = self.failed_count_per_hour
        if self.failed_tps is not None:
            result['failed_tps'] = self.failed_tps
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.ok_tps is not None:
            result['ok_tps'] = self.ok_tps
        if self.rt is not None:
            result['rt'] = self.rt
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('diff') is not None:
            self.diff = m.get('diff')
        if m.get('failed_count_per_hour') is not None:
            self.failed_count_per_hour = m.get('failed_count_per_hour')
        if m.get('failed_tps') is not None:
            self.failed_tps = m.get('failed_tps')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('ok_tps') is not None:
            self.ok_tps = m.get('ok_tps')
        if m.get('rt') is not None:
            self.rt = m.get('rt')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class SubMapDTO(TeaModel):
    def __init__(
        self,
        cell: str = None,
        client_list: List[SubClientInfoDTO] = None,
        fail_count: int = None,
        sub_group_name: str = None,
        success_count: int = None,
    ):
        # cell name
        self.cell = cell
        # 该 Group ID 客户端消费记录的明细列表
        # 
        # 
        self.client_list = client_list
        # 该 Group ID 消费失败次数统计
        self.fail_count = fail_count
        # 消费方 Group ID
        self.sub_group_name = sub_group_name
        # 该 Group ID 消费成功次数统计
        self.success_count = success_count

    def validate(self):
        self.validate_required(self.client_list, 'client_list')
        if self.client_list:
            for k in self.client_list:
                if k:
                    k.validate()
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.sub_group_name, 'sub_group_name')
        self.validate_required(self.success_count, 'success_count')

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        result['client_list'] = []
        if self.client_list is not None:
            for k in self.client_list:
                result['client_list'].append(k.to_map() if k else None)
        if self.fail_count is not None:
            result['fail_count'] = self.fail_count
        if self.sub_group_name is not None:
            result['sub_group_name'] = self.sub_group_name
        if self.success_count is not None:
            result['success_count'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        self.client_list = []
        if m.get('client_list') is not None:
            for k in m.get('client_list'):
                temp_model = SubClientInfoDTO()
                self.client_list.append(temp_model.from_map(k))
        if m.get('fail_count') is not None:
            self.fail_count = m.get('fail_count')
        if m.get('sub_group_name') is not None:
            self.sub_group_name = m.get('sub_group_name')
        if m.get('success_count') is not None:
            self.success_count = m.get('success_count')
        return self


class InstanceDTO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        instance_id: str = None,
        instance_status: int = None,
        tenant_id: str = None,
        user_id: str = None,
        workspace_name: str = None,
        id: int = None,
    ):
        # 集群名
        self.cluster = cluster
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 实例ID
        self.instance_id = instance_id
        # 实例状态。取值说明如下： 0、部署中 1、已欠费
        self.instance_status = instance_status
        # 租户id
        self.tenant_id = tenant_id
        # 用户id
        self.user_id = user_id
        # workspace名
        self.workspace_name = workspace_name
        # 数据库id
        self.id = id

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_status, 'instance_status')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.user_id, 'user_id')
        self.validate_required(self.workspace_name, 'workspace_name')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_status is not None:
            result['instance_status'] = self.instance_status
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.workspace_name is not None:
            result['workspace_name'] = self.workspace_name
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_status') is not None:
            self.instance_status = m.get('instance_status')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('workspace_name') is not None:
            self.workspace_name = m.get('workspace_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class MessageGetDTO(TeaModel):
    def __init__(
        self,
        body: str = None,
        body_crc: int = None,
        born_host: str = None,
        born_timestamp: int = None,
        instance_id: str = None,
        msg_id: str = None,
        property_list: List[MessagePropertyDTO] = None,
        reconsume_times: int = None,
        store_host: str = None,
        store_size: int = None,
        store_timestamp: int = None,
        topic: str = None,
        schema_id: str = None,
    ):
        # 消息体
        self.body = body
        # 消息体 CRC 校验值
        self.body_crc = body_crc
        # 生成该消息的客户端实例
        self.born_host = born_host
        # 生成时间戳
        self.born_timestamp = born_timestamp
        # 实例 ID
        self.instance_id = instance_id
        # 消息 ID，即 Message ID
        self.msg_id = msg_id
        # 消息属性列表
        self.property_list = property_list
        # 消息重试消费的次数
        self.reconsume_times = reconsume_times
        # 存储该消息的服务器实例
        self.store_host = store_host
        # 消息大小
        self.store_size = store_size
        # 被服务端存储的时间戳
        self.store_timestamp = store_timestamp
        # 消息的 Topic
        self.topic = topic
        # 消息的SchemaID
        self.schema_id = schema_id

    def validate(self):
        self.validate_required(self.body, 'body')
        self.validate_required(self.body_crc, 'body_crc')
        self.validate_required(self.born_host, 'born_host')
        self.validate_required(self.born_timestamp, 'born_timestamp')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.property_list, 'property_list')
        if self.property_list:
            for k in self.property_list:
                if k:
                    k.validate()
        self.validate_required(self.reconsume_times, 'reconsume_times')
        self.validate_required(self.store_host, 'store_host')
        self.validate_required(self.store_size, 'store_size')
        self.validate_required(self.store_timestamp, 'store_timestamp')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.schema_id, 'schema_id')

    def to_map(self):
        result = dict()
        if self.body is not None:
            result['body'] = self.body
        if self.body_crc is not None:
            result['body_crc'] = self.body_crc
        if self.born_host is not None:
            result['born_host'] = self.born_host
        if self.born_timestamp is not None:
            result['born_timestamp'] = self.born_timestamp
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        result['property_list'] = []
        if self.property_list is not None:
            for k in self.property_list:
                result['property_list'].append(k.to_map() if k else None)
        if self.reconsume_times is not None:
            result['reconsume_times'] = self.reconsume_times
        if self.store_host is not None:
            result['store_host'] = self.store_host
        if self.store_size is not None:
            result['store_size'] = self.store_size
        if self.store_timestamp is not None:
            result['store_timestamp'] = self.store_timestamp
        if self.topic is not None:
            result['topic'] = self.topic
        if self.schema_id is not None:
            result['schema_id'] = self.schema_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('body_crc') is not None:
            self.body_crc = m.get('body_crc')
        if m.get('born_host') is not None:
            self.born_host = m.get('born_host')
        if m.get('born_timestamp') is not None:
            self.born_timestamp = m.get('born_timestamp')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        self.property_list = []
        if m.get('property_list') is not None:
            for k in m.get('property_list'):
                temp_model = MessagePropertyDTO()
                self.property_list.append(temp_model.from_map(k))
        if m.get('reconsume_times') is not None:
            self.reconsume_times = m.get('reconsume_times')
        if m.get('store_host') is not None:
            self.store_host = m.get('store_host')
        if m.get('store_size') is not None:
            self.store_size = m.get('store_size')
        if m.get('store_timestamp') is not None:
            self.store_timestamp = m.get('store_timestamp')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('schema_id') is not None:
            self.schema_id = m.get('schema_id')
        return self


class TraceMapDTO(TeaModel):
    def __init__(
        self,
        born_host: str = None,
        cell: str = None,
        cost_time: int = None,
        msg_id: str = None,
        msg_key: str = None,
        pub_group_name: str = None,
        pub_time: int = None,
        status: str = None,
        sub_list: List[SubMapDTO] = None,
        tag: str = None,
        topic: str = None,
    ):
        # 消息发送方的客户端地址
        self.born_host = born_host
        # 生产端的cell name
        self.cell = cell
        # 发送耗时，单位毫秒
        self.cost_time = cost_time
        # 消息的 ID，即 Message ID
        self.msg_id = msg_id
        # 消息的 Key ，即 Message Key
        self.msg_key = msg_key
        # 发送方客户端配置的 Group ID
        self.pub_group_name = pub_group_name
        # 消息发送时间
        self.pub_time = pub_time
        # 发送状态。取值说明如下：
        # 
        # SEND_SUCCESS：发送成功
        # SEND_FAILED：发送失败
        # SEND_ROLLBACK：事务消息回滚
        # SEND_UNKNOWN：事务消息未提交
        # SEND_DELAY：定时(延时)消息定时中
        self.status = status
        # 消息的消费轨迹列表
        self.sub_list = sub_list
        # 消息的 Tag，即 Message Tag
        self.tag = tag
        # 消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.born_host, 'born_host')
        self.validate_required(self.cost_time, 'cost_time')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.msg_key, 'msg_key')
        self.validate_required(self.pub_group_name, 'pub_group_name')
        self.validate_required(self.pub_time, 'pub_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.sub_list, 'sub_list')
        if self.sub_list:
            for k in self.sub_list:
                if k:
                    k.validate()
        self.validate_required(self.tag, 'tag')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.born_host is not None:
            result['born_host'] = self.born_host
        if self.cell is not None:
            result['cell'] = self.cell
        if self.cost_time is not None:
            result['cost_time'] = self.cost_time
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.msg_key is not None:
            result['msg_key'] = self.msg_key
        if self.pub_group_name is not None:
            result['pub_group_name'] = self.pub_group_name
        if self.pub_time is not None:
            result['pub_time'] = self.pub_time
        if self.status is not None:
            result['status'] = self.status
        result['sub_list'] = []
        if self.sub_list is not None:
            for k in self.sub_list:
                result['sub_list'].append(k.to_map() if k else None)
        if self.tag is not None:
            result['tag'] = self.tag
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('born_host') is not None:
            self.born_host = m.get('born_host')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('cost_time') is not None:
            self.cost_time = m.get('cost_time')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('msg_key') is not None:
            self.msg_key = m.get('msg_key')
        if m.get('pub_group_name') is not None:
            self.pub_group_name = m.get('pub_group_name')
        if m.get('pub_time') is not None:
            self.pub_time = m.get('pub_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        self.sub_list = []
        if m.get('sub_list') is not None:
            for k in m.get('sub_list'):
                temp_model = SubMapDTO()
                self.sub_list.append(temp_model.from_map(k))
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class TraceDTO(TeaModel):
    def __init__(
        self,
        cell: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        instance_id: str = None,
        msg_id: str = None,
        msg_key: str = None,
        query_id: str = None,
        status: str = None,
        topic: str = None,
    ):
        # 查询的 Cell
        self.cell = cell
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 实例 ID
        self.instance_id = instance_id
        # 消息查询所用的 Message ID
        self.msg_id = msg_id
        # 消息查询所用的 Message Key
        self.msg_key = msg_key
        # 查询 ID
        self.query_id = query_id
        # 状态
        self.status = status
        # 查询的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.query_id, 'query_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.msg_key is not None:
            result['msg_key'] = self.msg_key
        if self.query_id is not None:
            result['query_id'] = self.query_id
        if self.status is not None:
            result['status'] = self.status
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('msg_key') is not None:
            self.msg_key = m.get('msg_key')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class EventSubConfig(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
        event_types: List[str] = None,
        trigger_type: str = None,
        webhook: str = None,
        http_url: str = None,
        topic: str = None,
        tag: str = None,
    ):
        # 配置是否开启
        self.enabled = enabled
        # 事件类型数组
        self.event_types = event_types
        # 事件触发通知类型
        self.trigger_type = trigger_type
        # 钉钉通知的webhook
        self.webhook = webhook
        # http 连接
        self.http_url = http_url
        # topic
        self.topic = topic
        # tag
        self.tag = tag

    def validate(self):
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.event_types, 'event_types')
        self.validate_required(self.trigger_type, 'trigger_type')

    def to_map(self):
        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.event_types is not None:
            result['event_types'] = self.event_types
        if self.trigger_type is not None:
            result['trigger_type'] = self.trigger_type
        if self.webhook is not None:
            result['webhook'] = self.webhook
        if self.http_url is not None:
            result['http_url'] = self.http_url
        if self.topic is not None:
            result['topic'] = self.topic
        if self.tag is not None:
            result['tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('event_types') is not None:
            self.event_types = m.get('event_types')
        if m.get('trigger_type') is not None:
            self.trigger_type = m.get('trigger_type')
        if m.get('webhook') is not None:
            self.webhook = m.get('webhook')
        if m.get('http_url') is not None:
            self.http_url = m.get('http_url')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        return self


class TaskRecordDTO(TeaModel):
    def __init__(
        self,
        end: str = None,
        name: str = None,
        start: str = None,
        time: str = None,
        progress: str = None,
        type: str = None,
    ):
        # 结束时间
        # 
        # 
        self.end = end
        # 任务分区名
        self.name = name
        # 开始时间
        # 
        # 
        self.start = start
        # 耗时 s
        # 
        # 
        self.time = time
        # 任务进度
        # 
        # 
        self.progress = progress
        # 执行成功，执行失败，执行中
        self.type = type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.start, 'start')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.end is not None:
            result['end'] = self.end
        if self.name is not None:
            result['name'] = self.name
        if self.start is not None:
            result['start'] = self.start
        if self.time is not None:
            result['time'] = self.time
        if self.progress is not None:
            result['progress'] = self.progress
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('progress') is not None:
            self.progress = m.get('progress')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UIKeyVauleTemplate(TeaModel):
    def __init__(
        self,
        display: str = None,
        key: str = None,
        value: str = None,
        visible: bool = None,
    ):
        # 中文，描述这个UI元素的key
        self.display = display
        # 对应ui元素的key
        self.key = key
        # 对应UI元素的值
        self.value = value
        # 该配置是否对 用户 可见。
        self.visible = visible

    def validate(self):
        self.validate_required(self.display, 'display')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')
        self.validate_required(self.visible, 'visible')

    def to_map(self):
        result = dict()
        if self.display is not None:
            result['display'] = self.display
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        if self.visible is not None:
            result['visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('display') is not None:
            self.display = m.get('display')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('visible') is not None:
            self.visible = m.get('visible')
        return self


class RouterConfigDO(TeaModel):
    def __init__(
        self,
        consumer_id: str = None,
        consume_from_type: int = None,
        consume_from_value: int = None,
        consume_to_type: int = None,
        consume_to_value: int = None,
        delay_time: str = None,
        description: str = None,
        destination_cell: str = None,
        destination_instance_id: str = None,
        destination_topic: str = None,
        disaster: bool = None,
        disaster_recovery_datacenter: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        source_cell: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
        tag: str = None,
        task_status: int = None,
        task_type: int = None,
    ):
        # 消费端 Group
        self.consumer_id = consumer_id
        # 消费起始位点。取值范围：0：最小位点；1：最大位点；2：时间戳。
        self.consume_from_type = consume_from_type
        # 消费起始位点时间戳，时间戳的值，单位是秒
        self.consume_from_value = consume_from_value
        # 消费终止位点。取值范围：0：最小位点；1：最大位点；2：时间戳。
        self.consume_to_type = consume_to_type
        # 消费终止位点时间戳，时间戳的值，单位是秒
        self.consume_to_value = consume_to_value
        # 延迟时间
        self.delay_time = delay_time
        # 描述信息
        self.description = description
        # 目标单元
        self.destination_cell = destination_cell
        # 目标实例 ID
        self.destination_instance_id = destination_instance_id
        # 目标 Topic
        self.destination_topic = destination_topic
        # 容灾标识
        self.disaster = disaster
        # 容灾机房
        self.disaster_recovery_datacenter = disaster_recovery_datacenter
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 路由任务 ID
        self.id = id
        # 源单元
        self.source_cell = source_cell
        # 源实例 ID
        self.source_instance_id = source_instance_id
        # 源 Topic
        self.source_topic = source_topic
        # 过滤 Tag
        self.tag = tag
        # 任务状态。取值说明：0：初始化；1：工作中；2：停止。
        self.task_status = task_status
        # 任务类型。取值范围： 0：LDC 复制；1：非 LDC；2...
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.consumer_id, 'consumer_id')
        self.validate_required(self.consume_from_type, 'consume_from_type')
        self.validate_required(self.consume_from_value, 'consume_from_value')
        self.validate_required(self.consume_to_type, 'consume_to_type')
        self.validate_required(self.consume_to_value, 'consume_to_value')
        self.validate_required(self.destination_cell, 'destination_cell')
        self.validate_required(self.destination_instance_id, 'destination_instance_id')
        self.validate_required(self.destination_topic, 'destination_topic')
        self.validate_required(self.disaster, 'disaster')
        self.validate_required(self.disaster_recovery_datacenter, 'disaster_recovery_datacenter')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.source_cell, 'source_cell')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_topic, 'source_topic')
        self.validate_required(self.tag, 'tag')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        result = dict()
        if self.consumer_id is not None:
            result['consumer_id'] = self.consumer_id
        if self.consume_from_type is not None:
            result['consume_from_type'] = self.consume_from_type
        if self.consume_from_value is not None:
            result['consume_from_value'] = self.consume_from_value
        if self.consume_to_type is not None:
            result['consume_to_type'] = self.consume_to_type
        if self.consume_to_value is not None:
            result['consume_to_value'] = self.consume_to_value
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.description is not None:
            result['description'] = self.description
        if self.destination_cell is not None:
            result['destination_cell'] = self.destination_cell
        if self.destination_instance_id is not None:
            result['destination_instance_id'] = self.destination_instance_id
        if self.destination_topic is not None:
            result['destination_topic'] = self.destination_topic
        if self.disaster is not None:
            result['disaster'] = self.disaster
        if self.disaster_recovery_datacenter is not None:
            result['disaster_recovery_datacenter'] = self.disaster_recovery_datacenter
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.tag is not None:
            result['tag'] = self.tag
        if self.task_status is not None:
            result['task_status'] = self.task_status
        if self.task_type is not None:
            result['task_type'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consumer_id') is not None:
            self.consumer_id = m.get('consumer_id')
        if m.get('consume_from_type') is not None:
            self.consume_from_type = m.get('consume_from_type')
        if m.get('consume_from_value') is not None:
            self.consume_from_value = m.get('consume_from_value')
        if m.get('consume_to_type') is not None:
            self.consume_to_type = m.get('consume_to_type')
        if m.get('consume_to_value') is not None:
            self.consume_to_value = m.get('consume_to_value')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('destination_cell') is not None:
            self.destination_cell = m.get('destination_cell')
        if m.get('destination_instance_id') is not None:
            self.destination_instance_id = m.get('destination_instance_id')
        if m.get('destination_topic') is not None:
            self.destination_topic = m.get('destination_topic')
        if m.get('disaster') is not None:
            self.disaster = m.get('disaster')
        if m.get('disaster_recovery_datacenter') is not None:
            self.disaster_recovery_datacenter = m.get('disaster_recovery_datacenter')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('task_status') is not None:
            self.task_status = m.get('task_status')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        return self


class SubscriptionTopicDTO(TeaModel):
    def __init__(
        self,
        online: bool = None,
        sub_string: str = None,
        topic: str = None,
    ):
        # 是否在线
        self.online = online
        # 订阅匹配字符串
        self.sub_string = sub_string
        # Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.online, 'online')
        self.validate_required(self.sub_string, 'sub_string')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.online is not None:
            result['online'] = self.online
        if self.sub_string is not None:
            result['sub_string'] = self.sub_string
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('online') is not None:
            self.online = m.get('online')
        if m.get('sub_string') is not None:
            self.sub_string = m.get('sub_string')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ConsumerConnectionInfoDTO(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        connection: str = None,
        consume_type: str = None,
        jstack: List[ThreadTrackDTO] = None,
        language: str = None,
        last_timestamp: int = None,
        message_model: str = None,
        running_data_list: List[ConsumerRunningDataDTO] = None,
        start_timestamp: int = None,
        subscription_set: List[SubscriptionDTO] = None,
        thread_count: int = None,
        version: str = None,
    ):
        # 消费实例的 ID
        self.client_id = client_id
        # 连接信息
        self.connection = connection
        # PUSH/PULL
        self.consume_type = consume_type
        # Jstack 堆栈信息
        self.jstack = jstack
        # 客户端语言
        self.language = language
        # 最后更新时间
        self.last_timestamp = last_timestamp
        # 消费模型，取值说明如下：CLUSTERING：集群消费模式；BROADCASTING：广播消费模式。
        self.message_model = message_model
        # 实时状态统计
        self.running_data_list = running_data_list
        # 开始时间
        self.start_timestamp = start_timestamp
        # 订阅关系集合
        self.subscription_set = subscription_set
        # 消费线程数
        self.thread_count = thread_count
        # 客户端版本号
        self.version = version

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.connection, 'connection')
        self.validate_required(self.consume_type, 'consume_type')
        self.validate_required(self.jstack, 'jstack')
        if self.jstack:
            for k in self.jstack:
                if k:
                    k.validate()
        self.validate_required(self.language, 'language')
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.message_model, 'message_model')
        self.validate_required(self.running_data_list, 'running_data_list')
        if self.running_data_list:
            for k in self.running_data_list:
                if k:
                    k.validate()
        self.validate_required(self.start_timestamp, 'start_timestamp')
        self.validate_required(self.subscription_set, 'subscription_set')
        if self.subscription_set:
            for k in self.subscription_set:
                if k:
                    k.validate()
        self.validate_required(self.thread_count, 'thread_count')
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.connection is not None:
            result['connection'] = self.connection
        if self.consume_type is not None:
            result['consume_type'] = self.consume_type
        result['jstack'] = []
        if self.jstack is not None:
            for k in self.jstack:
                result['jstack'].append(k.to_map() if k else None)
        if self.language is not None:
            result['language'] = self.language
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.message_model is not None:
            result['message_model'] = self.message_model
        result['running_data_list'] = []
        if self.running_data_list is not None:
            for k in self.running_data_list:
                result['running_data_list'].append(k.to_map() if k else None)
        if self.start_timestamp is not None:
            result['start_timestamp'] = self.start_timestamp
        result['subscription_set'] = []
        if self.subscription_set is not None:
            for k in self.subscription_set:
                result['subscription_set'].append(k.to_map() if k else None)
        if self.thread_count is not None:
            result['thread_count'] = self.thread_count
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('connection') is not None:
            self.connection = m.get('connection')
        if m.get('consume_type') is not None:
            self.consume_type = m.get('consume_type')
        self.jstack = []
        if m.get('jstack') is not None:
            for k in m.get('jstack'):
                temp_model = ThreadTrackDTO()
                self.jstack.append(temp_model.from_map(k))
        if m.get('language') is not None:
            self.language = m.get('language')
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('message_model') is not None:
            self.message_model = m.get('message_model')
        self.running_data_list = []
        if m.get('running_data_list') is not None:
            for k in m.get('running_data_list'):
                temp_model = ConsumerRunningDataDTO()
                self.running_data_list.append(temp_model.from_map(k))
        if m.get('start_timestamp') is not None:
            self.start_timestamp = m.get('start_timestamp')
        self.subscription_set = []
        if m.get('subscription_set') is not None:
            for k in m.get('subscription_set'):
                temp_model = SubscriptionDTO()
                self.subscription_set.append(temp_model.from_map(k))
        if m.get('thread_count') is not None:
            self.thread_count = m.get('thread_count')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class CellDO(TeaModel):
    def __init__(
        self,
        cell: str = None,
        cell_type: str = None,
        datacenter: str = None,
        endpoint: str = None,
        endpoint_type: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        room: str = None,
    ):
        # cell
        self.cell = cell
        # cell type
        self.cell_type = cell_type
        # default
        self.datacenter = datacenter
        # endpoint
        self.endpoint = endpoint
        # endpoint type
        self.endpoint_type = endpoint_type
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # room
        self.room = room

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.cell_type is not None:
            result['cell_type'] = self.cell_type
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.endpoint_type is not None:
            result['endpoint_type'] = self.endpoint_type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('cell_type') is not None:
            self.cell_type = m.get('cell_type')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('endpoint_type') is not None:
            self.endpoint_type = m.get('endpoint_type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class TopicDTO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        instance_id: str = None,
        message_type: int = None,
        operator: str = None,
        perm: int = None,
        read_queue_num: int = None,
        remark: str = None,
        topic: str = None,
        write_queue_num: int = None,
        scope: str = None,
        version: int = None,
        delete_mark: str = None,
        schema_mark: bool = None,
        schema_serialization: str = None,
        schema_compatibility: str = None,
        owner: str = None,
    ):
        # 集群名称
        self.cluster = cluster
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 数据库 ID
        self.id = id
        # 实例 ID
        self.instance_id = instance_id
        # 消息类型。取值说明如下：
        # 
        # 0：普通消息
        # 1：分区顺序消息
        # 2：全局顺序消息
        # 4：事务消息
        # 5：定时/延时消息
        self.message_type = message_type
        # 创建人
        self.operator = operator
        # 设置该 Topic 的读写模式。取值说明如下：
        # 
        # 6：同时支持读写
        # 4：禁写
        # 2：禁读
        self.perm = perm
        # 读分区数
        self.read_queue_num = read_queue_num
        # Topic 备注信息
        self.remark = remark
        # Topic 名称
        self.topic = topic
        # 写分区数
        self.write_queue_num = write_queue_num
        # 生效范围
        self.scope = scope
        # 版本号
        self.version = version
        # 删除标志
        self.delete_mark = delete_mark
        # true标识该topic带有schema，否则不带schema
        self.schema_mark = schema_mark
        # Topic对应Schema配置的序列化方式
        self.schema_serialization = schema_serialization
        # Topic对应的Schema的兼容性策略
        self.schema_compatibility = schema_compatibility
        # Topic 所属的应用名称，要求 app name 在 zappinfo 上可查
        self.owner = owner

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.message_type, 'message_type')
        self.validate_required(self.perm, 'perm')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.message_type is not None:
            result['message_type'] = self.message_type
        if self.operator is not None:
            result['operator'] = self.operator
        if self.perm is not None:
            result['perm'] = self.perm
        if self.read_queue_num is not None:
            result['read_queue_num'] = self.read_queue_num
        if self.remark is not None:
            result['remark'] = self.remark
        if self.topic is not None:
            result['topic'] = self.topic
        if self.write_queue_num is not None:
            result['write_queue_num'] = self.write_queue_num
        if self.scope is not None:
            result['scope'] = self.scope
        if self.version is not None:
            result['version'] = self.version
        if self.delete_mark is not None:
            result['delete_mark'] = self.delete_mark
        if self.schema_mark is not None:
            result['schema_mark'] = self.schema_mark
        if self.schema_serialization is not None:
            result['schema_serialization'] = self.schema_serialization
        if self.schema_compatibility is not None:
            result['schema_compatibility'] = self.schema_compatibility
        if self.owner is not None:
            result['owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('message_type') is not None:
            self.message_type = m.get('message_type')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('read_queue_num') is not None:
            self.read_queue_num = m.get('read_queue_num')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('write_queue_num') is not None:
            self.write_queue_num = m.get('write_queue_num')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('delete_mark') is not None:
            self.delete_mark = m.get('delete_mark')
        if m.get('schema_mark') is not None:
            self.schema_mark = m.get('schema_mark')
        if m.get('schema_serialization') is not None:
            self.schema_serialization = m.get('schema_serialization')
        if m.get('schema_compatibility') is not None:
            self.schema_compatibility = m.get('schema_compatibility')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        return self


class MsgTypeDO(TeaModel):
    def __init__(
        self,
        desc: str = None,
        eventcode: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        instance_id: str = None,
        topic: str = None,
        id: int = None,
    ):
        # desc
        self.desc = desc
        # eventcode
        self.eventcode = eventcode
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified
        # instance_id
        self.instance_id = instance_id
        # topic
        self.topic = topic
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class UIControlModel(TeaModel):
    def __init__(
        self,
        display: str = None,
        hint: str = None,
        name: str = None,
        options: List[UIOptionModel] = None,
        place_holder: str = None,
        required: bool = None,
        rule: str = None,
        rule_remark: str = None,
        type: str = None,
        union: bool = None,
        union_control: str = None,
        union_value: str = None,
        value: str = None,
        immutable: bool = None,
    ):
        # 展示给用户查看的描述。
        self.display = display
        # 提示信息，参照Tooltip
        self.hint = hint
        # 控件名称，也是控件绑定的数据 key
        self.name = name
        # 如果本控件是 select 或者 radio 选择框类型，本数组是 所有 选项的具体信息。
        self.options = options
        # input控件独有字段，代表输入框的place holder
        self.place_holder = place_holder
        # 该控件的value是否是必须的
        self.required = required
        # 本控件的值必须满足的规则，例如input，那么可能输入的文本必须满足全英文等；以正则表达式的形式。
        self.rule = rule
        # 当 用户输入的 值与 rule不符合时，提醒用户出错的备注。
        self.rule_remark = rule_remark
        # 控件的类型；支持 Select、Radio、Input、DatePicking
        self.type = type
        # 本控件是否未联动控件，联动控件是否展示 与 union_control和union_value 相关，当联动的父控件union_control的值为union_value时，本控件才可见。
        self.union = union
        # 联动的控件名称，即name
        self.union_control = union_control
        # 当联动空间union_control的值是本字段的值时，本联动控件可以展示。
        self.union_value = union_value
        # 本控件对应的值；如果是input，那么就是输入的值；如果是select/radio，那就是选项的值；如果是option，那么就是自己本身的枚举值。
        self.value = value
        # 该控件的值是否可以修改
        self.immutable = immutable

    def validate(self):
        self.validate_required(self.display, 'display')
        self.validate_required(self.name, 'name')
        if self.options:
            for k in self.options:
                if k:
                    k.validate()
        self.validate_required(self.required, 'required')
        self.validate_required(self.type, 'type')
        self.validate_required(self.union, 'union')
        self.validate_required(self.immutable, 'immutable')

    def to_map(self):
        result = dict()
        if self.display is not None:
            result['display'] = self.display
        if self.hint is not None:
            result['hint'] = self.hint
        if self.name is not None:
            result['name'] = self.name
        result['options'] = []
        if self.options is not None:
            for k in self.options:
                result['options'].append(k.to_map() if k else None)
        if self.place_holder is not None:
            result['place_holder'] = self.place_holder
        if self.required is not None:
            result['required'] = self.required
        if self.rule is not None:
            result['rule'] = self.rule
        if self.rule_remark is not None:
            result['rule_remark'] = self.rule_remark
        if self.type is not None:
            result['type'] = self.type
        if self.union is not None:
            result['union'] = self.union
        if self.union_control is not None:
            result['union_control'] = self.union_control
        if self.union_value is not None:
            result['union_value'] = self.union_value
        if self.value is not None:
            result['value'] = self.value
        if self.immutable is not None:
            result['immutable'] = self.immutable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('display') is not None:
            self.display = m.get('display')
        if m.get('hint') is not None:
            self.hint = m.get('hint')
        if m.get('name') is not None:
            self.name = m.get('name')
        self.options = []
        if m.get('options') is not None:
            for k in m.get('options'):
                temp_model = UIOptionModel()
                self.options.append(temp_model.from_map(k))
        if m.get('place_holder') is not None:
            self.place_holder = m.get('place_holder')
        if m.get('required') is not None:
            self.required = m.get('required')
        if m.get('rule') is not None:
            self.rule = m.get('rule')
        if m.get('rule_remark') is not None:
            self.rule_remark = m.get('rule_remark')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union') is not None:
            self.union = m.get('union')
        if m.get('union_control') is not None:
            self.union_control = m.get('union_control')
        if m.get('union_value') is not None:
            self.union_value = m.get('union_value')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('immutable') is not None:
            self.immutable = m.get('immutable')
        return self


class QueueDescDTO(TeaModel):
    def __init__(
        self,
        asso_app: str = None,
        channel: str = None,
        id: int = None,
        ip: str = None,
        manager: str = None,
        name: str = None,
        port: str = None,
        type: str = None,
    ):
        # 关联应用名
        self.asso_app = asso_app
        # 通道名
        self.channel = channel
        # 队列id
        self.id = id
        # 队列管理器ip
        self.ip = ip
        # 队列管理器名
        self.manager = manager
        # 队列名
        self.name = name
        # 队列管理器端口
        self.port = port
        # 队列类型
        self.type = type

    def validate(self):
        self.validate_required(self.asso_app, 'asso_app')
        self.validate_required(self.channel, 'channel')
        self.validate_required(self.id, 'id')
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.manager, 'manager')
        self.validate_required(self.name, 'name')
        self.validate_required(self.port, 'port')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.asso_app is not None:
            result['asso_app'] = self.asso_app
        if self.channel is not None:
            result['channel'] = self.channel
        if self.id is not None:
            result['id'] = self.id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.manager is not None:
            result['manager'] = self.manager
        if self.name is not None:
            result['name'] = self.name
        if self.port is not None:
            result['port'] = self.port
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('asso_app') is not None:
            self.asso_app = m.get('asso_app')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EndpointsDTO(TeaModel):
    def __init__(
        self,
        http_internal_endpoint: str = None,
        http_internet_endpoint: str = None,
        http_internet_secure_endpoint: str = None,
        tcp_endpoint: str = None,
    ):
        # HTTP 内网接入点
        self.http_internal_endpoint = http_internal_endpoint
        # HTTP 公网接入点
        self.http_internet_endpoint = http_internet_endpoint
        # HTTPS 公网接入点
        self.http_internet_secure_endpoint = http_internet_secure_endpoint
        # TCP 协议接入点
        self.tcp_endpoint = tcp_endpoint

    def validate(self):
        self.validate_required(self.http_internal_endpoint, 'http_internal_endpoint')
        self.validate_required(self.http_internet_endpoint, 'http_internet_endpoint')
        self.validate_required(self.http_internet_secure_endpoint, 'http_internet_secure_endpoint')
        self.validate_required(self.tcp_endpoint, 'tcp_endpoint')

    def to_map(self):
        result = dict()
        if self.http_internal_endpoint is not None:
            result['http_internal_endpoint'] = self.http_internal_endpoint
        if self.http_internet_endpoint is not None:
            result['http_internet_endpoint'] = self.http_internet_endpoint
        if self.http_internet_secure_endpoint is not None:
            result['http_internet_secure_endpoint'] = self.http_internet_secure_endpoint
        if self.tcp_endpoint is not None:
            result['tcp_endpoint'] = self.tcp_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http_internal_endpoint') is not None:
            self.http_internal_endpoint = m.get('http_internal_endpoint')
        if m.get('http_internet_endpoint') is not None:
            self.http_internet_endpoint = m.get('http_internet_endpoint')
        if m.get('http_internet_secure_endpoint') is not None:
            self.http_internet_secure_endpoint = m.get('http_internet_secure_endpoint')
        if m.get('tcp_endpoint') is not None:
            self.tcp_endpoint = m.get('tcp_endpoint')
        return self


class SourceTopic(TeaModel):
    def __init__(
        self,
        source_topic: str = None,
        source_event_code: List[str] = None,
    ):
        # 源端 topic
        self.source_topic = source_topic
        # 此源端 topic 所有的 event code列表
        self.source_event_code = source_event_code

    def validate(self):
        self.validate_required(self.source_topic, 'source_topic')
        self.validate_required(self.source_event_code, 'source_event_code')

    def to_map(self):
        result = dict()
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.source_event_code is not None:
            result['source_event_code'] = self.source_event_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('source_event_code') is not None:
            self.source_event_code = m.get('source_event_code')
        return self


class MessageTrackDTO(TeaModel):
    def __init__(
        self,
        consumer_group: str = None,
        instance_id: str = None,
        track_type: str = None,
    ):
        # 订阅该 Topic 的消费者所对应的 Group ID
        self.consumer_group = consumer_group
        # 需查询的消息所对应的实例 ID
        self.instance_id = instance_id
        # 当前状态。取值说明如下：
        # 
        # CONSUMED：已消费
        # CONSUMED_BUT_FILTERED：已被过滤
        # NOT_CONSUME_YET：暂未消费
        # NOT_ONLINE：客户端不在线
        # UNKNOWN：其他问题
        # 
        self.track_type = track_type

    def validate(self):
        self.validate_required(self.consumer_group, 'consumer_group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.track_type, 'track_type')

    def to_map(self):
        result = dict()
        if self.consumer_group is not None:
            result['consumer_group'] = self.consumer_group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.track_type is not None:
            result['track_type'] = self.track_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consumer_group') is not None:
            self.consumer_group = m.get('consumer_group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('track_type') is not None:
            self.track_type = m.get('track_type')
        return self


class ColumnsValue(TeaModel):
    def __init__(
        self,
        value: List[ColumnValue] = None,
    ):
        # 一行的值
        self.value = value

    def validate(self):
        self.validate_required(self.value, 'value')
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['value'] = []
        if self.value is not None:
            for k in self.value:
                result['value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.value = []
        if m.get('value') is not None:
            for k in m.get('value'):
                temp_model = ColumnValue()
                self.value.append(temp_model.from_map(k))
        return self


class WarnDTO(TeaModel):
    def __init__(
        self,
        alert_time: str = None,
        attribute: str = None,
        block_time: int = None,
        contacts: str = None,
        delay_time: int = None,
        frequency: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_id: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        threshold: int = None,
        topic: str = None,
        warn_level: int = None,
        warn_status: int = None,
        warn_type: int = None,
    ):
        # 报警时间段
        self.alert_time = alert_time
        # 属性字符串
        self.attribute = attribute
        # 消息阻塞时间
        self.block_time = block_time
        # 联系人列表
        self.contacts = contacts
        # 延迟时间
        self.delay_time = delay_time
        # 报警频率，单位分钟
        self.frequency = frequency
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 消费组 ID
        self.group_id = group_id
        # 报警 ID
        self.id = id
        # 实例 ID
        self.instance_id = instance_id
        # 操作者
        self.operator = operator
        # 阈值
        self.threshold = threshold
        # 报警的 Topic
        self.topic = topic
        # 报警级别
        self.warn_level = warn_level
        # 报警状态
        self.warn_status = warn_status
        # 报警类型
        self.warn_type = warn_type

    def validate(self):
        self.validate_required(self.alert_time, 'alert_time')
        self.validate_required(self.attribute, 'attribute')
        self.validate_required(self.block_time, 'block_time')
        self.validate_required(self.contacts, 'contacts')
        self.validate_required(self.delay_time, 'delay_time')
        self.validate_required(self.frequency, 'frequency')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.threshold, 'threshold')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.warn_level, 'warn_level')
        self.validate_required(self.warn_status, 'warn_status')
        self.validate_required(self.warn_type, 'warn_type')

    def to_map(self):
        result = dict()
        if self.alert_time is not None:
            result['alert_time'] = self.alert_time
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.block_time is not None:
            result['block_time'] = self.block_time
        if self.contacts is not None:
            result['contacts'] = self.contacts
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.frequency is not None:
            result['frequency'] = self.frequency
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.threshold is not None:
            result['threshold'] = self.threshold
        if self.topic is not None:
            result['topic'] = self.topic
        if self.warn_level is not None:
            result['warn_level'] = self.warn_level
        if self.warn_status is not None:
            result['warn_status'] = self.warn_status
        if self.warn_type is not None:
            result['warn_type'] = self.warn_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alert_time') is not None:
            self.alert_time = m.get('alert_time')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('block_time') is not None:
            self.block_time = m.get('block_time')
        if m.get('contacts') is not None:
            self.contacts = m.get('contacts')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('frequency') is not None:
            self.frequency = m.get('frequency')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('threshold') is not None:
            self.threshold = m.get('threshold')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('warn_level') is not None:
            self.warn_level = m.get('warn_level')
        if m.get('warn_status') is not None:
            self.warn_status = m.get('warn_status')
        if m.get('warn_type') is not None:
            self.warn_type = m.get('warn_type')
        return self


class ConfigDTO(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        operator: str = None,
        property: str = None,
        target_name: str = None,
        target_type: int = None,
        value: str = None,
        scope: str = None,
        version: int = None,
        delete_mark: str = None,
    ):
        # create time
        self.gmt_create = gmt_create
        # modify time
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # operator
        self.operator = operator
        # key
        self.property = property
        # 目标名
        self.target_name = target_name
        # cluster type or broker type
        self.target_type = target_type
        # value
        self.value = value
        # 生效范围
        self.scope = scope
        # 版本号
        self.version = version
        # 删除标志
        self.delete_mark = delete_mark

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.property, 'property')
        self.validate_required(self.target_name, 'target_name')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.value, 'value')
        self.validate_required(self.scope, 'scope')
        self.validate_required(self.version, 'version')
        self.validate_required(self.delete_mark, 'delete_mark')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.property is not None:
            result['property'] = self.property
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        if self.value is not None:
            result['value'] = self.value
        if self.scope is not None:
            result['scope'] = self.scope
        if self.version is not None:
            result['version'] = self.version
        if self.delete_mark is not None:
            result['delete_mark'] = self.delete_mark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('property') is not None:
            self.property = m.get('property')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('delete_mark') is not None:
            self.delete_mark = m.get('delete_mark')
        return self


class WarnLogDTO(TeaModel):
    def __init__(
        self,
        cell: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_id: str = None,
        instance_id: str = None,
        topic: str = None,
        warn_id: int = None,
        warn_info: str = None,
    ):
        # 单元名称
        self.cell = cell
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # Group ID
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # Topic 名称
        self.topic = topic
        # 报警 ID
        self.warn_id = warn_id
        # 报警信息
        self.warn_info = warn_info

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.warn_id, 'warn_id')
        self.validate_required(self.warn_info, 'warn_info')

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        if self.warn_info is not None:
            result['warn_info'] = self.warn_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        if m.get('warn_info') is not None:
            self.warn_info = m.get('warn_info')
        return self


class NodeDO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        data_center: str = None,
        hostname: str = None,
        node_group: str = None,
        node_type: str = None,
        perm: str = None,
        rip: str = None,
        room: str = None,
        vip: str = None,
        id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        status: str = None,
        env: str = None,
        city: str = None,
    ):
        # cluster
        self.cluster = cluster
        # default
        self.data_center = data_center
        # hostname
        self.hostname = hostname
        # node group
        self.node_group = node_group
        # node type
        self.node_type = node_type
        # node perm
        self.perm = perm
        # rip
        self.rip = rip
        # room
        self.room = room
        # vip
        self.vip = vip
        # id
        self.id = id
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified
        # 节点状态 MASTER|SLAVE|OFFLINE
        self.status = status
        # 节点所属环境
        self.env = env
        # 节点所在城市
        self.city = city

    def validate(self):
        self.validate_required(self.hostname, 'hostname')
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.data_center is not None:
            result['data_center'] = self.data_center
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.node_group is not None:
            result['node_group'] = self.node_group
        if self.node_type is not None:
            result['node_type'] = self.node_type
        if self.perm is not None:
            result['perm'] = self.perm
        if self.rip is not None:
            result['rip'] = self.rip
        if self.room is not None:
            result['room'] = self.room
        if self.vip is not None:
            result['vip'] = self.vip
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.status is not None:
            result['status'] = self.status
        if self.env is not None:
            result['env'] = self.env
        if self.city is not None:
            result['city'] = self.city
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('data_center') is not None:
            self.data_center = m.get('data_center')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('node_group') is not None:
            self.node_group = m.get('node_group')
        if m.get('node_type') is not None:
            self.node_type = m.get('node_type')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('rip') is not None:
            self.rip = m.get('rip')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('env') is not None:
            self.env = m.get('env')
        if m.get('city') is not None:
            self.city = m.get('city')
        return self


class ClientInfoDTO(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_addr: str = None,
        subscriptions: List[SubscriptionDTO] = None,
    ):
        # 客户端ID
        self.client_id = client_id
        # 客户端地址
        self.client_addr = client_addr
        # 订阅详情
        self.subscriptions = subscriptions

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.client_addr, 'client_addr')
        self.validate_required(self.subscriptions, 'subscriptions')
        if self.subscriptions:
            for k in self.subscriptions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.client_addr is not None:
            result['client_addr'] = self.client_addr
        result['subscriptions'] = []
        if self.subscriptions is not None:
            for k in self.subscriptions:
                result['subscriptions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('client_addr') is not None:
            self.client_addr = m.get('client_addr')
        self.subscriptions = []
        if m.get('subscriptions') is not None:
            for k in m.get('subscriptions'):
                temp_model = SubscriptionDTO()
                self.subscriptions.append(temp_model.from_map(k))
        return self


class SubscriptionGroupDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        message_model: str = None,
        sub_string: str = None,
        group_type: str = None,
    ):
        # 消费者所属消费组
        self.group_id = group_id
        # 部署模型
        self.message_model = message_model
        # 订阅字符串
        self.sub_string = sub_string
        # group协议类型
        self.group_type = group_type

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.message_model, 'message_model')
        self.validate_required(self.sub_string, 'sub_string')
        self.validate_required(self.group_type, 'group_type')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.message_model is not None:
            result['message_model'] = self.message_model
        if self.sub_string is not None:
            result['sub_string'] = self.sub_string
        if self.group_type is not None:
            result['group_type'] = self.group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('message_model') is not None:
            self.message_model = m.get('message_model')
        if m.get('sub_string') is not None:
            self.sub_string = m.get('sub_string')
        if m.get('group_type') is not None:
            self.group_type = m.get('group_type')
        return self


class BindingDO(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        group: str = None,
        id: int = None,
        instance_id: str = None,
        persistence: bool = None,
        topic: str = None,
    ):
        # app_name
        self.app_name = app_name
        # eventcode
        self.eventcode = eventcode
        # exchange_type
        self.exchange_type = exchange_type
        # expression
        self.expression = expression
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified
        # group
        self.group = group
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # persistence
        self.persistence = persistence
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.group, 'group')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.persistence, 'persistence')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.group is not None:
            result['group'] = self.group
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.persistence is not None:
            result['persistence'] = self.persistence
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class MsgQueryBatchDO(TeaModel):
    def __init__(
        self,
        eventcode: str = None,
        gmt_create: str = None,
        message_id: str = None,
        status: str = None,
        subscriber_group_undelivery: str = None,
    ):
        # eventcode
        self.eventcode = eventcode
        # gmt_create
        self.gmt_create = gmt_create
        # message_id
        self.message_id = message_id
        # status
        self.status = status
        # subscriber_group_undelivery
        self.subscriber_group_undelivery = subscriber_group_undelivery

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.message_id, 'message_id')

    def to_map(self):
        result = dict()
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.message_id is not None:
            result['message_id'] = self.message_id
        if self.status is not None:
            result['status'] = self.status
        if self.subscriber_group_undelivery is not None:
            result['subscriber_group_undelivery'] = self.subscriber_group_undelivery
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('message_id') is not None:
            self.message_id = m.get('message_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('subscriber_group_undelivery') is not None:
            self.subscriber_group_undelivery = m.get('subscriber_group_undelivery')
        return self


class KVConfigDTO(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        uniform_key: str = None,
        namespace: str = None,
        operator: str = None,
        uniform_value: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # key
        self.uniform_key = uniform_key
        # 命名空间
        self.namespace = namespace
        # 操作人
        self.operator = operator
        # value
        self.uniform_value = uniform_value

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.uniform_key, 'uniform_key')
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.uniform_value, 'uniform_value')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.uniform_key is not None:
            result['uniform_key'] = self.uniform_key
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operator is not None:
            result['operator'] = self.operator
        if self.uniform_value is not None:
            result['uniform_value'] = self.uniform_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('uniform_key') is not None:
            self.uniform_key = m.get('uniform_key')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('uniform_value') is not None:
            self.uniform_value = m.get('uniform_value')
        return self


class ConnectorJobInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        gmt_create: str = None,
        remark: str = None,
        status: str = None,
        app: str = None,
        process_status: str = None,
        sys_labels: List[str] = None,
        user_labels: List[str] = None,
        event_sub_enabled: bool = None,
    ):
        # 任务名称
        self.name = name
        # 任务的调度类型
        self.type = type
        # 创建时间
        self.gmt_create = gmt_create
        # 任务描述
        self.remark = remark
        # 任务状态
        self.status = status
        # 所属应用
        self.app = app
        # 工单状态
        self.process_status = process_status
        # 系统标签
        self.sys_labels = sys_labels
        # 应用标签
        self.user_labels = user_labels
        # 事件订阅是否开启
        self.event_sub_enabled = event_sub_enabled

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.status, 'status')
        self.validate_required(self.app, 'app')
        self.validate_required(self.process_status, 'process_status')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.app is not None:
            result['app'] = self.app
        if self.process_status is not None:
            result['process_status'] = self.process_status
        if self.sys_labels is not None:
            result['sys_labels'] = self.sys_labels
        if self.user_labels is not None:
            result['user_labels'] = self.user_labels
        if self.event_sub_enabled is not None:
            result['event_sub_enabled'] = self.event_sub_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('process_status') is not None:
            self.process_status = m.get('process_status')
        if m.get('sys_labels') is not None:
            self.sys_labels = m.get('sys_labels')
        if m.get('user_labels') is not None:
            self.user_labels = m.get('user_labels')
        if m.get('event_sub_enabled') is not None:
            self.event_sub_enabled = m.get('event_sub_enabled')
        return self


class DetailInTopicDTO(TeaModel):
    def __init__(
        self,
        delay_time: int = None,
        last_timestamp: int = None,
        topic: str = None,
        total_diff: int = None,
    ):
        # 延迟时间
        self.delay_time = delay_time
        # 最后更新时间
        self.last_timestamp = last_timestamp
        # Topic 名称
        self.topic = topic
        # 该 Topic 消费总堆积数
        self.total_diff = total_diff

    def validate(self):
        self.validate_required(self.delay_time, 'delay_time')
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.total_diff, 'total_diff')

    def to_map(self):
        result = dict()
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.topic is not None:
            result['topic'] = self.topic
        if self.total_diff is not None:
            result['total_diff'] = self.total_diff
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('total_diff') is not None:
            self.total_diff = m.get('total_diff')
        return self


class QueueRouteRulesDTO(TeaModel):
    def __init__(
        self,
        app: str = None,
        gmt_modified: str = None,
        id: int = None,
        meth: str = None,
        name: str = None,
        queue_id: int = None,
        status: int = None,
        switch_status: int = None,
        type: str = None,
    ):
        # 应用
        self.app = app
        # 修改时间
        self.gmt_modified = gmt_modified
        # 队列路由规则id
        self.id = id
        # 方法
        self.meth = meth
        # 路由规则名称
        self.name = name
        # 队列id
        self.queue_id = queue_id
        # 状态
        self.status = status
        # 分流开关
        self.switch_status = switch_status
        # 路由类型
        self.type = type

    def validate(self):
        self.validate_required(self.app, 'app')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.meth, 'meth')
        self.validate_required(self.name, 'name')
        self.validate_required(self.queue_id, 'queue_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.switch_status, 'switch_status')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.app is not None:
            result['app'] = self.app
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.meth is not None:
            result['meth'] = self.meth
        if self.name is not None:
            result['name'] = self.name
        if self.queue_id is not None:
            result['queue_id'] = self.queue_id
        if self.status is not None:
            result['status'] = self.status
        if self.switch_status is not None:
            result['switch_status'] = self.switch_status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('meth') is not None:
            self.meth = m.get('meth')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('queue_id') is not None:
            self.queue_id = m.get('queue_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('switch_status') is not None:
            self.switch_status = m.get('switch_status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class WhitelistDO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        topic: str = None,
        id: int = None,
        groupid: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # instance_id
        self.instance_id = instance_id
        # topic
        self.topic = topic
        # id
        self.id = id
        # groupid
        self.groupid = groupid
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.id, 'id')
        self.validate_required(self.groupid, 'groupid')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.id is not None:
            result['id'] = self.id
        if self.groupid is not None:
            result['groupid'] = self.groupid
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('groupid') is not None:
            self.groupid = m.get('groupid')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class SchemaDetailDO(TeaModel):
    def __init__(
        self,
        comment: str = None,
        content: str = None,
        field_validate_rule: str = None,
        name: str = None,
        namespace: str = None,
        serialization: str = None,
        state: str = None,
        tenant: str = None,
        type: str = None,
        uniq_id: str = None,
        version: int = None,
        operator: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
    ):
        # 注释
        self.comment = comment
        # schema内容
        self.content = content
        # 值校验规则
        self.field_validate_rule = field_validate_rule
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 序列化类型
        self.serialization = serialization
        # 状态
        self.state = state
        # 租户
        self.tenant = tenant
        # schema类型
        self.type = type
        # 唯一ID
        self.uniq_id = uniq_id
        # 版本
        self.version = version
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.name, 'name')
        self.validate_required(self.serialization, 'serialization')
        self.validate_required(self.type, 'type')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        result = dict()
        if self.comment is not None:
            result['comment'] = self.comment
        if self.content is not None:
            result['content'] = self.content
        if self.field_validate_rule is not None:
            result['field_validate_rule'] = self.field_validate_rule
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.serialization is not None:
            result['serialization'] = self.serialization
        if self.state is not None:
            result['state'] = self.state
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.type is not None:
            result['type'] = self.type
        if self.uniq_id is not None:
            result['uniq_id'] = self.uniq_id
        if self.version is not None:
            result['version'] = self.version
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('field_validate_rule') is not None:
            self.field_validate_rule = m.get('field_validate_rule')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('serialization') is not None:
            self.serialization = m.get('serialization')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uniq_id') is not None:
            self.uniq_id = m.get('uniq_id')
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class UIComponent(TeaModel):
    def __init__(
        self,
        type: str = None,
        contents: List[ComponentContent] = None,
        list_items: List[ItemComponent] = None,
    ):
        # UI组件类型
        self.type = type
        # UI组件中的 内容组成部分，可以由多个Content对象组成
        self.contents = contents
        # 列表内元素组件集合
        self.list_items = list_items

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.contents, 'contents')
        if self.contents:
            for k in self.contents:
                if k:
                    k.validate()
        if self.list_items:
            for k in self.list_items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['type'] = self.type
        result['contents'] = []
        if self.contents is not None:
            for k in self.contents:
                result['contents'].append(k.to_map() if k else None)
        result['list_items'] = []
        if self.list_items is not None:
            for k in self.list_items:
                result['list_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        self.contents = []
        if m.get('contents') is not None:
            for k in m.get('contents'):
                temp_model = ComponentContent()
                self.contents.append(temp_model.from_map(k))
        self.list_items = []
        if m.get('list_items') is not None:
            for k in m.get('list_items'):
                temp_model = ItemComponent()
                self.list_items.append(temp_model.from_map(k))
        return self


class StatsDataDTO(TeaModel):
    def __init__(
        self,
        x: int = None,
        y: str = None,
    ):
        # 横轴，毫秒时间戳
        self.x = x
        # 纵轴，数据（TPS 或者总量）
        self.y = y

    def validate(self):
        self.validate_required(self.x, 'x')
        self.validate_required(self.y, 'y')

    def to_map(self):
        result = dict()
        if self.x is not None:
            result['x'] = self.x
        if self.y is not None:
            result['y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('x') is not None:
            self.x = m.get('x')
        if m.get('y') is not None:
            self.y = m.get('y')
        return self


class QueueLimitRulesDTO(TeaModel):
    def __init__(
        self,
        gmt_modified: str = None,
        id: int = None,
        l_algorithm: str = None,
        l_operation: str = None,
        meth: str = None,
        name: str = None,
        queue_id: int = None,
        r_mode: str = None,
        status: int = None,
        app: str = None,
    ):
        # 修改时间
        self.gmt_modified = gmt_modified
        # 限流规则id
        self.id = id
        # 限流算法
        self.l_algorithm = l_algorithm
        # 限流后操作
        self.l_operation = l_operation
        # 方法
        self.meth = meth
        # 限流规则名称
        self.name = name
        # 队列id
        self.queue_id = queue_id
        # 运行模式
        self.r_mode = r_mode
        # 状态
        self.status = status
        # 应用名
        self.app = app

    def validate(self):
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.l_algorithm, 'l_algorithm')
        self.validate_required(self.l_operation, 'l_operation')
        self.validate_required(self.meth, 'meth')
        self.validate_required(self.name, 'name')
        self.validate_required(self.queue_id, 'queue_id')
        self.validate_required(self.r_mode, 'r_mode')
        self.validate_required(self.status, 'status')
        self.validate_required(self.app, 'app')

    def to_map(self):
        result = dict()
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.l_algorithm is not None:
            result['l_algorithm'] = self.l_algorithm
        if self.l_operation is not None:
            result['l_operation'] = self.l_operation
        if self.meth is not None:
            result['meth'] = self.meth
        if self.name is not None:
            result['name'] = self.name
        if self.queue_id is not None:
            result['queue_id'] = self.queue_id
        if self.r_mode is not None:
            result['r_mode'] = self.r_mode
        if self.status is not None:
            result['status'] = self.status
        if self.app is not None:
            result['app'] = self.app
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('l_algorithm') is not None:
            self.l_algorithm = m.get('l_algorithm')
        if m.get('l_operation') is not None:
            self.l_operation = m.get('l_operation')
        if m.get('meth') is not None:
            self.meth = m.get('meth')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('queue_id') is not None:
            self.queue_id = m.get('queue_id')
        if m.get('r_mode') is not None:
            self.r_mode = m.get('r_mode')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('app') is not None:
            self.app = m.get('app')
        return self


class AdminUserDTO(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        login_name: str = None,
        nick_name: str = None,
        real_name: str = None,
        user_type: int = None,
        operator: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 数据库id
        self.id = id
        # 登录名
        self.login_name = login_name
        # 昵称
        self.nick_name = nick_name
        # 真实姓名
        self.real_name = real_name
        # 用户类型
        self.user_type = user_type
        # 操作人
        self.operator = operator

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.login_name, 'login_name')
        self.validate_required(self.nick_name, 'nick_name')
        self.validate_required(self.real_name, 'real_name')
        self.validate_required(self.user_type, 'user_type')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.login_name is not None:
            result['login_name'] = self.login_name
        if self.nick_name is not None:
            result['nick_name'] = self.nick_name
        if self.real_name is not None:
            result['real_name'] = self.real_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('login_name') is not None:
            self.login_name = m.get('login_name')
        if m.get('nick_name') is not None:
            self.nick_name = m.get('nick_name')
        if m.get('real_name') is not None:
            self.real_name = m.get('real_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class ConsumeQueueOffset(TeaModel):
    def __init__(
        self,
        topic: str = None,
        broker_name: str = None,
        queue_id: int = None,
        broker_offset: int = None,
        consumer_offset: int = None,
        last_timestamp: int = None,
        client_addr: str = None,
        client_id: str = None,
        accumulate: int = None,
        difference: int = None,
    ):
        # topic
        self.topic = topic
        # queue所在broker的名字
        self.broker_name = broker_name
        # queue id
        self.queue_id = queue_id
        # 消费位点
        self.broker_offset = broker_offset
        # 消费端offset
        self.consumer_offset = consumer_offset
        # 最后时间（时间戳）
        # 
        self.last_timestamp = last_timestamp
        # 消费端地址
        self.client_addr = client_addr
        # 消费者客户端id
        # 
        self.client_id = client_id
        # 消息堆积数
        # 
        self.accumulate = accumulate
        # queue位点和消费端位点差
        self.difference = difference

    def validate(self):
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.broker_name, 'broker_name')
        self.validate_required(self.queue_id, 'queue_id')
        self.validate_required(self.broker_offset, 'broker_offset')
        self.validate_required(self.consumer_offset, 'consumer_offset')
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.client_addr, 'client_addr')
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.accumulate, 'accumulate')
        self.validate_required(self.difference, 'difference')

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['topic'] = self.topic
        if self.broker_name is not None:
            result['broker_name'] = self.broker_name
        if self.queue_id is not None:
            result['queue_id'] = self.queue_id
        if self.broker_offset is not None:
            result['broker_offset'] = self.broker_offset
        if self.consumer_offset is not None:
            result['consumer_offset'] = self.consumer_offset
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.client_addr is not None:
            result['client_addr'] = self.client_addr
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.accumulate is not None:
            result['accumulate'] = self.accumulate
        if self.difference is not None:
            result['difference'] = self.difference
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('broker_name') is not None:
            self.broker_name = m.get('broker_name')
        if m.get('queue_id') is not None:
            self.queue_id = m.get('queue_id')
        if m.get('broker_offset') is not None:
            self.broker_offset = m.get('broker_offset')
        if m.get('consumer_offset') is not None:
            self.consumer_offset = m.get('consumer_offset')
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('client_addr') is not None:
            self.client_addr = m.get('client_addr')
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('accumulate') is not None:
            self.accumulate = m.get('accumulate')
        if m.get('difference') is not None:
            self.difference = m.get('difference')
        return self


class GroupDTO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        delete_mark: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_id: str = None,
        group_type: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        read_enable: bool = None,
        remark: str = None,
        scope: str = None,
        version: int = None,
        retry_read_queue_num: int = None,
        retry_write_queue_num: int = None,
        retry_perm: int = None,
        owner: str = None,
    ):
        # 集群名
        self.cluster = cluster
        # 删除标志
        self.delete_mark = delete_mark
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # Group ID
        self.group_id = group_id
        # 查询的 Group ID 适用的协议。TCP 协议和 HTTP 协议的 Group ID 不可以共用，需要分别创建。取值说明如下：
        # 
        # tcp：表示该 Group ID 仅适用于 TCP 协议的消息收发。
        # http：表示该 Group ID 仅适用于 HTTP 协议的消息收发。
        self.group_type = group_type
        # 数据库 ID
        self.id = id
        # 实例 ID
        self.instance_id = instance_id
        # 操作人
        self.operator = operator
        # 读权限
        self.read_enable = read_enable
        # Group 备注信息
        self.remark = remark
        # 生效范围
        self.scope = scope
        # 版本号
        self.version = version
        # retry topic读队列数
        self.retry_read_queue_num = retry_read_queue_num
        # retry topic写队列数
        self.retry_write_queue_num = retry_write_queue_num
        # retry topic读写权限
        self.retry_perm = retry_perm
        # Group 所属的应用名称，要求应用名在 zappinfo 上可查
        self.owner = owner

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_type, 'group_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.delete_mark is not None:
            result['delete_mark'] = self.delete_mark
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.group_type is not None:
            result['group_type'] = self.group_type
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.read_enable is not None:
            result['read_enable'] = self.read_enable
        if self.remark is not None:
            result['remark'] = self.remark
        if self.scope is not None:
            result['scope'] = self.scope
        if self.version is not None:
            result['version'] = self.version
        if self.retry_read_queue_num is not None:
            result['retry_read_queue_num'] = self.retry_read_queue_num
        if self.retry_write_queue_num is not None:
            result['retry_write_queue_num'] = self.retry_write_queue_num
        if self.retry_perm is not None:
            result['retry_perm'] = self.retry_perm
        if self.owner is not None:
            result['owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('delete_mark') is not None:
            self.delete_mark = m.get('delete_mark')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('group_type') is not None:
            self.group_type = m.get('group_type')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('read_enable') is not None:
            self.read_enable = m.get('read_enable')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('retry_read_queue_num') is not None:
            self.retry_read_queue_num = m.get('retry_read_queue_num')
        if m.get('retry_write_queue_num') is not None:
            self.retry_write_queue_num = m.get('retry_write_queue_num')
        if m.get('retry_perm') is not None:
            self.retry_perm = m.get('retry_perm')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        return self


class ConnectionDTO(TeaModel):
    def __init__(
        self,
        client_addr: str = None,
        client_id: str = None,
        language: str = None,
        remote_ip: str = None,
        version: str = None,
    ):
        # 该消费实例的地址和端口
        self.client_addr = client_addr
        # 消费实例的 ID
        self.client_id = client_id
        # 消费端语言
        self.language = language
        # 宿主机 IP 或公网 IP
        self.remote_ip = remote_ip
        # 消费端版本
        self.version = version

    def validate(self):
        self.validate_required(self.client_addr, 'client_addr')
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.language, 'language')
        self.validate_required(self.remote_ip, 'remote_ip')
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.client_addr is not None:
            result['client_addr'] = self.client_addr
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.language is not None:
            result['language'] = self.language
        if self.remote_ip is not None:
            result['remote_ip'] = self.remote_ip
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_addr') is not None:
            self.client_addr = m.get('client_addr')
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('language') is not None:
            self.language = m.get('language')
        if m.get('remote_ip') is not None:
            self.remote_ip = m.get('remote_ip')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class ColumnConfig(TeaModel):
    def __init__(
        self,
        alias: str = None,
        cast_type: str = None,
        name: str = None,
        type: str = None,
        cast_type_options: List[str] = None,
    ):
        # 别名
        self.alias = alias
        # 转化类型
        self.cast_type = cast_type
        # 名称
        self.name = name
        # 列类型
        self.type = type
        # 当前字段 可转化成的类型选项
        self.cast_type_options = cast_type_options

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.alias is not None:
            result['alias'] = self.alias
        if self.cast_type is not None:
            result['cast_type'] = self.cast_type
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        if self.cast_type_options is not None:
            result['cast_type_options'] = self.cast_type_options
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alias') is not None:
            self.alias = m.get('alias')
        if m.get('cast_type') is not None:
            self.cast_type = m.get('cast_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('cast_type_options') is not None:
            self.cast_type_options = m.get('cast_type_options')
        return self


class ApplicationDTO(TeaModel):
    def __init__(
        self,
        gmt_created: str = None,
        id: int = None,
        name: str = None,
        pub_get_queue: str = None,
        pub_put_queue: str = None,
        pub_rpc_status: int = None,
        sub_get_queue: str = None,
        sub_put_queue: str = None,
        sub_rpc_scale: int = None,
        type: str = None,
    ):
        # 创建时间
        self.gmt_created = gmt_created
        # 应用id
        self.id = id
        # 应用名
        self.name = name
        # 服务端get队列
        self.pub_get_queue = pub_get_queue
        # 服务端put队列
        self.pub_put_queue = pub_put_queue
        # 服务端开关
        self.pub_rpc_status = pub_rpc_status
        # 客户端get队列
        self.sub_get_queue = sub_get_queue
        # 客户端put队列
        self.sub_put_queue = sub_put_queue
        # rpc分流比例
        self.sub_rpc_scale = sub_rpc_scale
        # 服务类型
        self.type = type

    def validate(self):
        self.validate_required(self.gmt_created, 'gmt_created')
        if self.gmt_created is not None:
            self.validate_pattern(self.gmt_created, 'gmt_created', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.gmt_created is not None:
            result['gmt_created'] = self.gmt_created
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.pub_get_queue is not None:
            result['pub_get_queue'] = self.pub_get_queue
        if self.pub_put_queue is not None:
            result['pub_put_queue'] = self.pub_put_queue
        if self.pub_rpc_status is not None:
            result['pub_rpc_status'] = self.pub_rpc_status
        if self.sub_get_queue is not None:
            result['sub_get_queue'] = self.sub_get_queue
        if self.sub_put_queue is not None:
            result['sub_put_queue'] = self.sub_put_queue
        if self.sub_rpc_scale is not None:
            result['sub_rpc_scale'] = self.sub_rpc_scale
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_created') is not None:
            self.gmt_created = m.get('gmt_created')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pub_get_queue') is not None:
            self.pub_get_queue = m.get('pub_get_queue')
        if m.get('pub_put_queue') is not None:
            self.pub_put_queue = m.get('pub_put_queue')
        if m.get('pub_rpc_status') is not None:
            self.pub_rpc_status = m.get('pub_rpc_status')
        if m.get('sub_get_queue') is not None:
            self.sub_get_queue = m.get('sub_get_queue')
        if m.get('sub_put_queue') is not None:
            self.sub_put_queue = m.get('sub_put_queue')
        if m.get('sub_rpc_scale') is not None:
            self.sub_rpc_scale = m.get('sub_rpc_scale')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class NodePageDO(TeaModel):
    def __init__(
        self,
        content: List[NodeDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # nodes
        self.content = content
        # page
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # total
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = NodeDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class JobRecordDTO(TeaModel):
    def __init__(
        self,
        end: str = None,
        id: str = None,
        progress: int = None,
        run_type: str = None,
        start: str = None,
        task_records: List[TaskRecordDTO] = None,
        time: int = None,
        trigger_type: str = None,
        partition: str = None,
        context: str = None,
    ):
        # 结束时间
        self.end = end
        # 任务执行id
        self.id = id
        # 执行总进度
        # 
        # 总的进度为100，这里的进度条如何配置需要，前端同学定一下，我来改
        self.progress = progress
        # 任务执行状态
        self.run_type = run_type
        # 开始时间
        self.start = start
        # 任务执行记录集合
        self.task_records = task_records
        # 执行耗时
        self.time = time
        # 触发类型
        self.trigger_type = trigger_type
        # 分区信息
        self.partition = partition
        # 触发上下文
        self.context = context

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.run_type, 'run_type')
        self.validate_required(self.start, 'start')
        self.validate_required(self.task_records, 'task_records')
        if self.task_records:
            for k in self.task_records:
                if k:
                    k.validate()
        self.validate_required(self.trigger_type, 'trigger_type')
        self.validate_required(self.partition, 'partition')

    def to_map(self):
        result = dict()
        if self.end is not None:
            result['end'] = self.end
        if self.id is not None:
            result['id'] = self.id
        if self.progress is not None:
            result['progress'] = self.progress
        if self.run_type is not None:
            result['run_type'] = self.run_type
        if self.start is not None:
            result['start'] = self.start
        result['task_records'] = []
        if self.task_records is not None:
            for k in self.task_records:
                result['task_records'].append(k.to_map() if k else None)
        if self.time is not None:
            result['time'] = self.time
        if self.trigger_type is not None:
            result['trigger_type'] = self.trigger_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.context is not None:
            result['context'] = self.context
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('progress') is not None:
            self.progress = m.get('progress')
        if m.get('run_type') is not None:
            self.run_type = m.get('run_type')
        if m.get('start') is not None:
            self.start = m.get('start')
        self.task_records = []
        if m.get('task_records') is not None:
            for k in m.get('task_records'):
                temp_model = TaskRecordDTO()
                self.task_records.append(temp_model.from_map(k))
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('trigger_type') is not None:
            self.trigger_type = m.get('trigger_type')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('context') is not None:
            self.context = m.get('context')
        return self


class RoomDO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        endpoint: str = None,
        endpoint_type: str = None,
        region: str = None,
        room: str = None,
        id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # cluster
        self.cluster = cluster
        # endpoint
        self.endpoint = endpoint
        # endpoint_type
        self.endpoint_type = endpoint_type
        # region
        self.region = region
        # room
        self.room = room
        # id
        self.id = id
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.room, 'room')
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.endpoint_type is not None:
            result['endpoint_type'] = self.endpoint_type
        if self.region is not None:
            result['region'] = self.region
        if self.room is not None:
            result['room'] = self.room
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('endpoint_type') is not None:
            self.endpoint_type = m.get('endpoint_type')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class InstanceDigest(TeaModel):
    def __init__(
        self,
        id: str = None,
        partition: str = None,
        gmt_create: str = None,
        state: str = None,
    ):
        # job instance id
        self.id = id
        # 分区信息
        self.partition = partition
        # 时间
        self.gmt_create = gmt_create
        # 任务状态
        self.state = state

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.partition, 'partition')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.state, 'state')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.partition is not None:
            result['partition'] = self.partition
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class WarnLogPageDTO(TeaModel):
    def __init__(
        self,
        content: List[WarnLogDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # 报警日志信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = WarnLogDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ConsumerGetConnectionDTO(TeaModel):
    def __init__(
        self,
        connection_list: List[ConnectionDTO] = None,
    ):
        # 指定 Group ID 的连接信息
        # 
        # 
        self.connection_list = connection_list

    def validate(self):
        self.validate_required(self.connection_list, 'connection_list')
        if self.connection_list:
            for k in self.connection_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['connection_list'] = []
        if self.connection_list is not None:
            for k in self.connection_list:
                result['connection_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connection_list = []
        if m.get('connection_list') is not None:
            for k in m.get('connection_list'):
                temp_model = ConnectionDTO()
                self.connection_list.append(temp_model.from_map(k))
        return self


class BacklogMetricItem(TeaModel):
    def __init__(
        self,
        backlog_cnt: int = None,
        timestamp: int = None,
    ):
        # 积压消息量
        self.backlog_cnt = backlog_cnt
        # 积压数据的时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.backlog_cnt, 'backlog_cnt')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        result = dict()
        if self.backlog_cnt is not None:
            result['backlog_cnt'] = self.backlog_cnt
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('backlog_cnt') is not None:
            self.backlog_cnt = m.get('backlog_cnt')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class ClearOffsetResultDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        topic: str = None,
        result: str = None,
    ):
        # GroupId
        self.group_id = group_id
        # Topic 名称
        self.topic = topic
        # 操作结果
        self.result = result

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.result, 'result')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class ProcessDTO(TeaModel):
    def __init__(
        self,
        process_name: str = None,
        process_status: str = None,
        process_url: str = None,
    ):
        # 工单名称
        self.process_name = process_name
        # 状态
        self.process_status = process_status
        # 工单链接
        self.process_url = process_url

    def validate(self):
        self.validate_required(self.process_name, 'process_name')
        self.validate_required(self.process_status, 'process_status')
        self.validate_required(self.process_url, 'process_url')

    def to_map(self):
        result = dict()
        if self.process_name is not None:
            result['process_name'] = self.process_name
        if self.process_status is not None:
            result['process_status'] = self.process_status
        if self.process_url is not None:
            result['process_url'] = self.process_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('process_name') is not None:
            self.process_name = m.get('process_name')
        if m.get('process_status') is not None:
            self.process_status = m.get('process_status')
        if m.get('process_url') is not None:
            self.process_url = m.get('process_url')
        return self


class CellPageDTO(TeaModel):
    def __init__(
        self,
        content: List[CellDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # cell数据
        self.content = content
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # 总量
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = CellDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ApiInfoDTO(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        owner: str = None,
        path: str = None,
        summary: str = None,
        switch_open: bool = None,
        sofamq_action: str = None,
        user_default_assign: bool = None,
        owner_default_assign: bool = None,
    ):
        # api详细描述
        self.description = description
        # api名
        self.name = name
        # 负责人
        self.owner = owner
        # api路径
        self.path = path
        # api简介
        self.summary = summary
        # 开关
        self.switch_open = switch_open
        # sofamq action 名称
        self.sofamq_action = sofamq_action
        # 是否默认分配给普通用户
        self.user_default_assign = user_default_assign
        # 是否默认分配给 app owner
        self.owner_default_assign = owner_default_assign

    def validate(self):
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.path, 'path')
        self.validate_required(self.summary, 'summary')
        self.validate_required(self.switch_open, 'switch_open')

    def to_map(self):
        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.owner is not None:
            result['owner'] = self.owner
        if self.path is not None:
            result['path'] = self.path
        if self.summary is not None:
            result['summary'] = self.summary
        if self.switch_open is not None:
            result['switch_open'] = self.switch_open
        if self.sofamq_action is not None:
            result['sofamq_action'] = self.sofamq_action
        if self.user_default_assign is not None:
            result['user_default_assign'] = self.user_default_assign
        if self.owner_default_assign is not None:
            result['owner_default_assign'] = self.owner_default_assign
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('summary') is not None:
            self.summary = m.get('summary')
        if m.get('switch_open') is not None:
            self.switch_open = m.get('switch_open')
        if m.get('sofamq_action') is not None:
            self.sofamq_action = m.get('sofamq_action')
        if m.get('user_default_assign') is not None:
            self.user_default_assign = m.get('user_default_assign')
        if m.get('owner_default_assign') is not None:
            self.owner_default_assign = m.get('owner_default_assign')
        return self


class ConsumerAccumulateDTO(TeaModel):
    def __init__(
        self,
        consume_tps: str = None,
        delay_time: int = None,
        detail_in_topic_list: List[DetailInTopicDTO] = None,
        last_timestamp: int = None,
        online: bool = None,
        total_diff: int = None,
    ):
        # 该 Group ID 下消费者实例群组接收消息的总 TPS
        self.consume_tps = consume_tps
        # 该 Topic 所发消息的最大消费延迟时间
        self.delay_time = delay_time
        # 各个 Topic 具体情况
        self.detail_in_topic_list = detail_in_topic_list
        # 该 Topic 中最近一条被消费的信息的生产时间
        self.last_timestamp = last_timestamp
        # 该 Group ID 下是否有消费者实例在线；只要有一个消费者实例在线，该 Group ID 状态即为在线。取值说明如下：
        # 
        # true：状态为在线
        # false：状态为不在线
        self.online = online
        # 该 Topic 的消费堆积数量
        self.total_diff = total_diff

    def validate(self):
        self.validate_required(self.consume_tps, 'consume_tps')
        self.validate_required(self.delay_time, 'delay_time')
        self.validate_required(self.detail_in_topic_list, 'detail_in_topic_list')
        if self.detail_in_topic_list:
            for k in self.detail_in_topic_list:
                if k:
                    k.validate()
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.online, 'online')
        self.validate_required(self.total_diff, 'total_diff')

    def to_map(self):
        result = dict()
        if self.consume_tps is not None:
            result['consume_tps'] = self.consume_tps
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        result['detail_in_topic_list'] = []
        if self.detail_in_topic_list is not None:
            for k in self.detail_in_topic_list:
                result['detail_in_topic_list'].append(k.to_map() if k else None)
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.online is not None:
            result['online'] = self.online
        if self.total_diff is not None:
            result['total_diff'] = self.total_diff
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consume_tps') is not None:
            self.consume_tps = m.get('consume_tps')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        self.detail_in_topic_list = []
        if m.get('detail_in_topic_list') is not None:
            for k in m.get('detail_in_topic_list'):
                temp_model = DetailInTopicDTO()
                self.detail_in_topic_list.append(temp_model.from_map(k))
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('online') is not None:
            self.online = m.get('online')
        if m.get('total_diff') is not None:
            self.total_diff = m.get('total_diff')
        return self


class TrendTpsDTO(TeaModel):
    def __init__(
        self,
        records: List[StatsDataDTO] = None,
        title: str = None,
        x_unit: str = None,
        y_unit: str = None,
    ):
        # 数据集合
        self.records = records
        # Table 的名称
        self.title = title
        # 时间戳，单位毫秒
        self.x_unit = x_unit
        # 纵轴单位
        # 
        self.y_unit = y_unit

    def validate(self):
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()
        self.validate_required(self.title, 'title')
        self.validate_required(self.x_unit, 'x_unit')
        self.validate_required(self.y_unit, 'y_unit')

    def to_map(self):
        result = dict()
        result['records'] = []
        if self.records is not None:
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        if self.x_unit is not None:
            result['x_unit'] = self.x_unit
        if self.y_unit is not None:
            result['y_unit'] = self.y_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.records = []
        if m.get('records') is not None:
            for k in m.get('records'):
                temp_model = StatsDataDTO()
                self.records.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('x_unit') is not None:
            self.x_unit = m.get('x_unit')
        if m.get('y_unit') is not None:
            self.y_unit = m.get('y_unit')
        return self


class ConsumerTimeSpanDTO(TeaModel):
    def __init__(
        self,
        consume_timestamp: int = None,
        instance_id: str = None,
        max_timestamp: int = None,
        min_timestamp: int = None,
        topic: str = None,
    ):
        # 当前 Group 消费该 Topic 的最新的时间
        self.consume_timestamp = consume_timestamp
        # 需查询的消费端 Group ID 所对应的实例 ID
        self.instance_id = instance_id
        # 整个 Topic 目前存储的最早的消息的时间
        self.max_timestamp = max_timestamp
        # 整个 Topic 目前存储的最新的消息的时间
        self.min_timestamp = min_timestamp
        # 需查询的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.consume_timestamp, 'consume_timestamp')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.max_timestamp, 'max_timestamp')
        self.validate_required(self.min_timestamp, 'min_timestamp')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.consume_timestamp is not None:
            result['consume_timestamp'] = self.consume_timestamp
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.max_timestamp is not None:
            result['max_timestamp'] = self.max_timestamp
        if self.min_timestamp is not None:
            result['min_timestamp'] = self.min_timestamp
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('consume_timestamp') is not None:
            self.consume_timestamp = m.get('consume_timestamp')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('max_timestamp') is not None:
            self.max_timestamp = m.get('max_timestamp')
        if m.get('min_timestamp') is not None:
            self.min_timestamp = m.get('min_timestamp')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class Pair(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 键值对中的 键
        self.key = key
        # 键值对中的值
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class Topic(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        desc: str = None,
        eventcode: str = None,
        id: str = None,
        instance_id: str = None,
        topic: str = None,
        update_time: str = None,
    ):
        # creation_time
        self.creation_time = creation_time
        # desc
        self.desc = desc
        # eventcode
        self.eventcode = eventcode
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # topic
        self.topic = topic
        # update_time
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.creation_time is not None:
            result['creation_time'] = self.creation_time
        if self.desc is not None:
            result['desc'] = self.desc
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.update_time is not None:
            result['update_time'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creation_time') is not None:
            self.creation_time = m.get('creation_time')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        return self


class GroupStatsItem(TeaModel):
    def __init__(
        self,
        bpm: int = None,
        dlq: int = None,
        group_id: str = None,
        msg_backlog: int = None,
        ppm: int = None,
        topic: str = None,
        tpm: int = None,
        tpd: int = None,
    ):
        # 每分钟消息大小
        self.bpm = bpm
        # 死信数量
        self.dlq = dlq
        # 消费组 Group ID
        self.group_id = group_id
        # 当前 Group 消息积压的数量
        self.msg_backlog = msg_backlog
        # 当前每分钟 Group ID 拉请求数量
        self.ppm = ppm
        # Topic 名称
        self.topic = topic
        # 每分钟拉取的消息数量
        self.tpm = tpm
        # 每天拉取的消息数量
        self.tpd = tpd

    def validate(self):
        self.validate_required(self.bpm, 'bpm')
        self.validate_required(self.dlq, 'dlq')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.msg_backlog, 'msg_backlog')
        self.validate_required(self.ppm, 'ppm')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.tpm, 'tpm')
        self.validate_required(self.tpd, 'tpd')

    def to_map(self):
        result = dict()
        if self.bpm is not None:
            result['bpm'] = self.bpm
        if self.dlq is not None:
            result['dlq'] = self.dlq
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.msg_backlog is not None:
            result['msg_backlog'] = self.msg_backlog
        if self.ppm is not None:
            result['ppm'] = self.ppm
        if self.topic is not None:
            result['topic'] = self.topic
        if self.tpm is not None:
            result['tpm'] = self.tpm
        if self.tpd is not None:
            result['tpd'] = self.tpd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bpm') is not None:
            self.bpm = m.get('bpm')
        if m.get('dlq') is not None:
            self.dlq = m.get('dlq')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('msg_backlog') is not None:
            self.msg_backlog = m.get('msg_backlog')
        if m.get('ppm') is not None:
            self.ppm = m.get('ppm')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('tpm') is not None:
            self.tpm = m.get('tpm')
        if m.get('tpd') is not None:
            self.tpd = m.get('tpd')
        return self


class QueuePageDescDTO(TeaModel):
    def __init__(
        self,
        page_count: int = None,
        page_current: int = None,
        page_size: int = None,
        records: List[QueueDescDTO] = None,
        row_count: int = None,
    ):
        # 总页数
        self.page_count = page_count
        # 当前页面
        self.page_current = page_current
        # 页面大小
        self.page_size = page_size
        # 队列详情信息
        self.records = records
        # 总记录数
        self.row_count = row_count

    def validate(self):
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_current, 'page_current')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()
        self.validate_required(self.row_count, 'row_count')

    def to_map(self):
        result = dict()
        if self.page_count is not None:
            result['page_count'] = self.page_count
        if self.page_current is not None:
            result['page_current'] = self.page_current
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['records'] = []
        if self.records is not None:
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        if self.row_count is not None:
            result['row_count'] = self.row_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_count') is not None:
            self.page_count = m.get('page_count')
        if m.get('page_current') is not None:
            self.page_current = m.get('page_current')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.records = []
        if m.get('records') is not None:
            for k in m.get('records'):
                temp_model = QueueDescDTO()
                self.records.append(temp_model.from_map(k))
        if m.get('row_count') is not None:
            self.row_count = m.get('row_count')
        return self


class ConfigPageDTO(TeaModel):
    def __init__(
        self,
        content: List[ConfigDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # config page
        self.content = content
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # 总量
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = ConfigDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class WhitelistPageDO(TeaModel):
    def __init__(
        self,
        content: List[WhitelistDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # content
        self.content = content
        # page_num
        self.page_num = page_num
        # page_size
        self.page_size = page_size
        # total
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = WhitelistDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class TopicPageDTO(TeaModel):
    def __init__(
        self,
        content: List[TopicDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # Topic 信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = TopicDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class TraceMapResultDTO(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        instance_id: str = None,
        msg_id: str = None,
        msg_key: str = None,
        query_id: str = None,
        status: str = None,
        topic: str = None,
        trace_list: List[TraceMapDTO] = None,
        update_time: int = None,
        user_id: str = None,
    ):
        # 该查询任务的创建时间
        # 
        # 
        self.create_time = create_time
        # 实例 ID
        self.instance_id = instance_id
        # 该查询任务对应的 Message ID
        self.msg_id = msg_id
        # 该查询任务对应的 Message Key
        self.msg_key = msg_key
        # 查询任务 ID
        self.query_id = query_id
        # 该查询任务的结果。取值说明如下：finish：查询完成；working：查询中；removed：任务已删除。
        self.status = status
        # 该查询任务的 Topic
        self.topic = topic
        # 该查询任务的匹配轨迹列表
        # 
        self.trace_list = trace_list
        # 该查询任务的最后更新时间
        self.update_time = update_time
        # 查询用户 ID
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.msg_key, 'msg_key')
        self.validate_required(self.query_id, 'query_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.trace_list, 'trace_list')
        if self.trace_list:
            for k in self.trace_list:
                if k:
                    k.validate()
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        result = dict()
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.msg_key is not None:
            result['msg_key'] = self.msg_key
        if self.query_id is not None:
            result['query_id'] = self.query_id
        if self.status is not None:
            result['status'] = self.status
        if self.topic is not None:
            result['topic'] = self.topic
        result['trace_list'] = []
        if self.trace_list is not None:
            for k in self.trace_list:
                result['trace_list'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['update_time'] = self.update_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('msg_key') is not None:
            self.msg_key = m.get('msg_key')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        self.trace_list = []
        if m.get('trace_list') is not None:
            for k in m.get('trace_list'):
                temp_model = TraceMapDTO()
                self.trace_list.append(temp_model.from_map(k))
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class DelayInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_type: str = None,
    ):
        # 延迟时间
        self.name = name
        # 值
        self.value = value
        # 值类型
        self.value_type = value_type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')
        self.validate_required(self.value_type, 'value_type')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        if self.value_type is not None:
            result['value_type'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('value_type') is not None:
            self.value_type = m.get('value_type')
        return self


class SloSpec(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        long_running_task: bool = None,
        default_acceptable_execution_interval: int = None,
    ):
        # 是否开启
        self.enable = enable
        # 是否是常驻任务
        self.long_running_task = long_running_task
        # 默认可接受执行时间
        self.default_acceptable_execution_interval = default_acceptable_execution_interval

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.long_running_task, 'long_running_task')
        self.validate_required(self.default_acceptable_execution_interval, 'default_acceptable_execution_interval')

    def to_map(self):
        result = dict()
        if self.enable is not None:
            result['enable'] = self.enable
        if self.long_running_task is not None:
            result['long_running_task'] = self.long_running_task
        if self.default_acceptable_execution_interval is not None:
            result['default_acceptable_execution_interval'] = self.default_acceptable_execution_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('long_running_task') is not None:
            self.long_running_task = m.get('long_running_task')
        if m.get('default_acceptable_execution_interval') is not None:
            self.default_acceptable_execution_interval = m.get('default_acceptable_execution_interval')
        return self


class QueueRouteEditionDTO(TeaModel):
    def __init__(
        self,
        edition: str = None,
        id: int = None,
        route_id: int = None,
        scale: int = None,
    ):
        # 版本
        self.edition = edition
        # 路由版本（插入时可不填）
        self.id = id
        # 路由规则id（插入时可不填）
        self.route_id = route_id
        # 权重
        self.scale = scale

    def validate(self):
        self.validate_required(self.edition, 'edition')
        self.validate_required(self.id, 'id')
        self.validate_required(self.route_id, 'route_id')
        self.validate_required(self.scale, 'scale')

    def to_map(self):
        result = dict()
        if self.edition is not None:
            result['edition'] = self.edition
        if self.id is not None:
            result['id'] = self.id
        if self.route_id is not None:
            result['route_id'] = self.route_id
        if self.scale is not None:
            result['scale'] = self.scale
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('edition') is not None:
            self.edition = m.get('edition')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('route_id') is not None:
            self.route_id = m.get('route_id')
        if m.get('scale') is not None:
            self.scale = m.get('scale')
        return self


class MsgdumpTaskDTO(TeaModel):
    def __init__(
        self,
        remark: str = None,
        source_event_code: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
        status: int = None,
        target_instance_id: str = None,
        target_tag: str = None,
        target_topic: str = None,
        task_id: int = None,
        cell: str = None,
    ):
        # 描述
        self.remark = remark
        # 源 eventcode
        self.source_event_code = source_event_code
        # 源实例 id
        self.source_instance_id = source_instance_id
        # 源 topic
        self.source_topic = source_topic
        # 任务状态
        # 0: 初始化中；1: 运行中；2: 停止中；3: 已停止
        self.status = status
        # 目标实例 id
        self.target_instance_id = target_instance_id
        # 目标 tag
        self.target_tag = target_tag
        # 目标 topic
        self.target_topic = target_topic
        # 任务 id
        self.task_id = task_id
        # 消息同步目标 cell
        self.cell = cell

    def validate(self):
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.source_event_code, 'source_event_code')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_topic, 'source_topic')
        self.validate_required(self.status, 'status')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.target_tag, 'target_tag')
        self.validate_required(self.target_topic, 'target_topic')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.cell, 'cell')

    def to_map(self):
        result = dict()
        if self.remark is not None:
            result['remark'] = self.remark
        if self.source_event_code is not None:
            result['source_event_code'] = self.source_event_code
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.status is not None:
            result['status'] = self.status
        if self.target_instance_id is not None:
            result['target_instance_id'] = self.target_instance_id
        if self.target_tag is not None:
            result['target_tag'] = self.target_tag
        if self.target_topic is not None:
            result['target_topic'] = self.target_topic
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.cell is not None:
            result['cell'] = self.cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('source_event_code') is not None:
            self.source_event_code = m.get('source_event_code')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('target_instance_id') is not None:
            self.target_instance_id = m.get('target_instance_id')
        if m.get('target_tag') is not None:
            self.target_tag = m.get('target_tag')
        if m.get('target_topic') is not None:
            self.target_topic = m.get('target_topic')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        return self


class MsgdumpSourceInfo(TeaModel):
    def __init__(
        self,
        source_instance_id: str = None,
        source_topics: List[SourceTopic] = None,
    ):
        # 源 instance id
        self.source_instance_id = source_instance_id
        # 源端 topic 列表
        self.source_topics = source_topics

    def validate(self):
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_topics, 'source_topics')
        if self.source_topics:
            for k in self.source_topics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        result['source_topics'] = []
        if self.source_topics is not None:
            for k in self.source_topics:
                result['source_topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        self.source_topics = []
        if m.get('source_topics') is not None:
            for k in m.get('source_topics'):
                temp_model = SourceTopic()
                self.source_topics.append(temp_model.from_map(k))
        return self


class AuditorDTO(TeaModel):
    def __init__(
        self,
        action: str = None,
        resource: str = None,
        detail: str = None,
        operator: str = None,
        timestamp: str = None,
    ):
        # 操作名
        self.action = action
        # 资源名
        self.resource = resource
        # 操作详情
        self.detail = detail
        # 操作人
        self.operator = operator
        # 时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.action, 'action')
        self.validate_required(self.resource, 'resource')
        self.validate_required(self.detail, 'detail')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.timestamp, 'timestamp')
        if self.timestamp is not None:
            self.validate_pattern(self.timestamp, 'timestamp', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.resource is not None:
            result['resource'] = self.resource
        if self.detail is not None:
            result['detail'] = self.detail
        if self.operator is not None:
            result['operator'] = self.operator
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        if m.get('detail') is not None:
            self.detail = m.get('detail')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class TopicStatusDTO(TeaModel):
    def __init__(
        self,
        last_timestamp: int = None,
        perm: int = None,
        total_count: int = None,
    ):
        # Topic 的最后更新时间时间戳
        self.last_timestamp = last_timestamp
        # 设置该 Topic 的读写模式。取值说明如下：6：同时支持读写；4：禁写；2：禁读。
        self.perm = perm
        # 消息总量
        self.total_count = total_count

    def validate(self):
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.perm, 'perm')
        self.validate_required(self.total_count, 'total_count')

    def to_map(self):
        result = dict()
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.perm is not None:
            result['perm'] = self.perm
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class TopicSubDetailDTO(TeaModel):
    def __init__(
        self,
        latest_send_time: int = None,
        subscription_data_list: List[SubscriptionGroupDTO] = None,
        topic: str = None,
    ):
        # 最近发送时间
        self.latest_send_time = latest_send_time
        # SubscriptionData 数组
        self.subscription_data_list = subscription_data_list
        # Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.latest_send_time, 'latest_send_time')
        self.validate_required(self.subscription_data_list, 'subscription_data_list')
        if self.subscription_data_list:
            for k in self.subscription_data_list:
                if k:
                    k.validate()
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.latest_send_time is not None:
            result['latest_send_time'] = self.latest_send_time
        result['subscription_data_list'] = []
        if self.subscription_data_list is not None:
            for k in self.subscription_data_list:
                result['subscription_data_list'].append(k.to_map() if k else None)
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('latest_send_time') is not None:
            self.latest_send_time = m.get('latest_send_time')
        self.subscription_data_list = []
        if m.get('subscription_data_list') is not None:
            for k in m.get('subscription_data_list'):
                temp_model = SubscriptionGroupDTO()
                self.subscription_data_list.append(temp_model.from_map(k))
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class LinkDTO(TeaModel):
    def __init__(
        self,
        demo_project: str = None,
        product_doc: str = None,
        quick_start: str = None,
    ):
        # demo工程
        self.demo_project = demo_project
        # 产品文档
        self.product_doc = product_doc
        # 快速开始文档
        self.quick_start = quick_start

    def validate(self):
        self.validate_required(self.demo_project, 'demo_project')
        self.validate_required(self.product_doc, 'product_doc')
        self.validate_required(self.quick_start, 'quick_start')

    def to_map(self):
        result = dict()
        if self.demo_project is not None:
            result['demo_project'] = self.demo_project
        if self.product_doc is not None:
            result['product_doc'] = self.product_doc
        if self.quick_start is not None:
            result['quick_start'] = self.quick_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('demo_project') is not None:
            self.demo_project = m.get('demo_project')
        if m.get('product_doc') is not None:
            self.product_doc = m.get('product_doc')
        if m.get('quick_start') is not None:
            self.quick_start = m.get('quick_start')
        return self


class InstanceCreateDTO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_type: int = None,
    ):
        # instance id
        self.instance_id = instance_id
        # 实例类型
        self.instance_type = instance_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_type is not None:
            result['instance_type'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_type') is not None:
            self.instance_type = m.get('instance_type')
        return self


class Binding(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        creation_time: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        group: str = None,
        id: str = None,
        instance_id: str = None,
        persistence: bool = None,
        topic: str = None,
        update_time: str = None,
    ):
        # appName
        self.app_name = app_name
        # creation_time
        self.creation_time = creation_time
        # eventcode
        self.eventcode = eventcode
        # exchangeType
        self.exchange_type = exchange_type
        # expression
        self.expression = expression
        # group
        self.group = group
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # persistence
        self.persistence = persistence
        # topic
        self.topic = topic
        # update_time
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.creation_time is not None:
            result['creation_time'] = self.creation_time
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.group is not None:
            result['group'] = self.group
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.persistence is not None:
            result['persistence'] = self.persistence
        if self.topic is not None:
            result['topic'] = self.topic
        if self.update_time is not None:
            result['update_time'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('creation_time') is not None:
            self.creation_time = m.get('creation_time')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        return self


class StringDataDo(TeaModel):
    def __init__(
        self,
        data: str = None,
    ):
        # data
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GroupSubDetailDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        message_model: str = None,
        online: bool = None,
        subscription_data_list: List[SubscriptionTopicDTO] = None,
    ):
        # Group ID
        self.group_id = group_id
        # 部署模型
        self.message_model = message_model
        # 是否在线
        self.online = online
        # 订阅信息列表
        self.subscription_data_list = subscription_data_list

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.message_model, 'message_model')
        self.validate_required(self.online, 'online')
        self.validate_required(self.subscription_data_list, 'subscription_data_list')
        if self.subscription_data_list:
            for k in self.subscription_data_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.message_model is not None:
            result['message_model'] = self.message_model
        if self.online is not None:
            result['online'] = self.online
        result['subscription_data_list'] = []
        if self.subscription_data_list is not None:
            for k in self.subscription_data_list:
                result['subscription_data_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('message_model') is not None:
            self.message_model = m.get('message_model')
        if m.get('online') is not None:
            self.online = m.get('online')
        self.subscription_data_list = []
        if m.get('subscription_data_list') is not None:
            for k in m.get('subscription_data_list'):
                temp_model = SubscriptionTopicDTO()
                self.subscription_data_list.append(temp_model.from_map(k))
        return self


class DataCenterDO(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        datacenter: str = None,
        room: str = None,
        id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # cluster
        self.cluster = cluster
        # datacenter
        self.datacenter = datacenter
        # room
        self.room = room
        # id
        self.id = id
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.datacenter, 'datacenter')
        self.validate_required(self.room, 'room')
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.room is not None:
            result['room'] = self.room
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class ConnectorJob(TeaModel):
    def __init__(
        self,
        cron: str = None,
        filter: str = None,
        name: str = None,
        rate: int = None,
        remark: str = None,
        sink_configs: List[UIKeyVauleTemplate] = None,
        sink_type: str = None,
        source_configs: List[UIKeyVauleTemplate] = None,
        source_type: str = None,
        time: str = None,
        transformation: List[ColumnConfig] = None,
        type: str = None,
        gmt_create: str = None,
        app: str = None,
        stepflow_template_id: str = None,
        singleton: bool = None,
        event_sub_enabled: bool = None,
        event_sub_configs: List[EventSubConfig] = None,
        acceptable_execution_interval: int = None,
        status: str = None,
        process_status: str = None,
        auto_recycle_instance: bool = None,
    ):
        # cron表达式描述任务的触发详情。
        self.cron = cron
        # sql过滤
        self.filter = filter
        # 任务名称
        self.name = name
        # 限流值
        self.rate = rate
        # 描述这个任务的具体详情
        self.remark = remark
        # 去向信息的配置
        self.sink_configs = sink_configs
        # 去向类型
        self.sink_type = sink_type
        # 数据源的配置项列表
        self.source_configs = source_configs
        # 来源类型
        self.source_type = source_type
        # 当任务类型选择为once时，会有本字段，表示具体执行的时间
        self.time = time
        # 数据转化
        self.transformation = transformation
        # 任务的调度类型
        self.type = type
        # 创建时间
        self.gmt_create = gmt_create
        # 任务所有者
        self.app = app
        # stepflow平台的某个模板的编号
        self.stepflow_template_id = stepflow_template_id
        # 单例模式
        self.singleton = singleton
        # 事件订阅是否开启
        self.event_sub_enabled = event_sub_enabled
        # 事件订阅的配置集合
        self.event_sub_configs = event_sub_configs
        # 可接受延迟时间
        self.acceptable_execution_interval = acceptable_execution_interval
        # 状态
        self.status = status
        # 工单状态
        self.process_status = process_status
        # 是否自动回收实例
        self.auto_recycle_instance = auto_recycle_instance

    def validate(self):
        self.validate_required(self.name, 'name')
        if self.rate is not None:
            self.validate_minimum(self.rate, 'rate', 0)
        if self.remark is not None:
            self.validate_max_length(self.remark, 'remark', 128)
        self.validate_required(self.sink_configs, 'sink_configs')
        if self.sink_configs:
            for k in self.sink_configs:
                if k:
                    k.validate()
        self.validate_required(self.sink_type, 'sink_type')
        self.validate_required(self.source_configs, 'source_configs')
        if self.source_configs:
            for k in self.source_configs:
                if k:
                    k.validate()
        self.validate_required(self.source_type, 'source_type')
        if self.time is not None:
            self.validate_pattern(self.time, 'time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.transformation:
            for k in self.transformation:
                if k:
                    k.validate()
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.singleton, 'singleton')
        if self.event_sub_configs:
            for k in self.event_sub_configs:
                if k:
                    k.validate()
        self.validate_required(self.auto_recycle_instance, 'auto_recycle_instance')

    def to_map(self):
        result = dict()
        if self.cron is not None:
            result['cron'] = self.cron
        if self.filter is not None:
            result['filter'] = self.filter
        if self.name is not None:
            result['name'] = self.name
        if self.rate is not None:
            result['rate'] = self.rate
        if self.remark is not None:
            result['remark'] = self.remark
        result['sink_configs'] = []
        if self.sink_configs is not None:
            for k in self.sink_configs:
                result['sink_configs'].append(k.to_map() if k else None)
        if self.sink_type is not None:
            result['sink_type'] = self.sink_type
        result['source_configs'] = []
        if self.source_configs is not None:
            for k in self.source_configs:
                result['source_configs'].append(k.to_map() if k else None)
        if self.source_type is not None:
            result['source_type'] = self.source_type
        if self.time is not None:
            result['time'] = self.time
        result['transformation'] = []
        if self.transformation is not None:
            for k in self.transformation:
                result['transformation'].append(k.to_map() if k else None)
        if self.type is not None:
            result['type'] = self.type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.app is not None:
            result['app'] = self.app
        if self.stepflow_template_id is not None:
            result['stepflow_template_id'] = self.stepflow_template_id
        if self.singleton is not None:
            result['singleton'] = self.singleton
        if self.event_sub_enabled is not None:
            result['event_sub_enabled'] = self.event_sub_enabled
        result['event_sub_configs'] = []
        if self.event_sub_configs is not None:
            for k in self.event_sub_configs:
                result['event_sub_configs'].append(k.to_map() if k else None)
        if self.acceptable_execution_interval is not None:
            result['acceptable_execution_interval'] = self.acceptable_execution_interval
        if self.status is not None:
            result['status'] = self.status
        if self.process_status is not None:
            result['process_status'] = self.process_status
        if self.auto_recycle_instance is not None:
            result['auto_recycle_instance'] = self.auto_recycle_instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('filter') is not None:
            self.filter = m.get('filter')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        self.sink_configs = []
        if m.get('sink_configs') is not None:
            for k in m.get('sink_configs'):
                temp_model = UIKeyVauleTemplate()
                self.sink_configs.append(temp_model.from_map(k))
        if m.get('sink_type') is not None:
            self.sink_type = m.get('sink_type')
        self.source_configs = []
        if m.get('source_configs') is not None:
            for k in m.get('source_configs'):
                temp_model = UIKeyVauleTemplate()
                self.source_configs.append(temp_model.from_map(k))
        if m.get('source_type') is not None:
            self.source_type = m.get('source_type')
        if m.get('time') is not None:
            self.time = m.get('time')
        self.transformation = []
        if m.get('transformation') is not None:
            for k in m.get('transformation'):
                temp_model = ColumnConfig()
                self.transformation.append(temp_model.from_map(k))
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('stepflow_template_id') is not None:
            self.stepflow_template_id = m.get('stepflow_template_id')
        if m.get('singleton') is not None:
            self.singleton = m.get('singleton')
        if m.get('event_sub_enabled') is not None:
            self.event_sub_enabled = m.get('event_sub_enabled')
        self.event_sub_configs = []
        if m.get('event_sub_configs') is not None:
            for k in m.get('event_sub_configs'):
                temp_model = EventSubConfig()
                self.event_sub_configs.append(temp_model.from_map(k))
        if m.get('acceptable_execution_interval') is not None:
            self.acceptable_execution_interval = m.get('acceptable_execution_interval')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('process_status') is not None:
            self.process_status = m.get('process_status')
        if m.get('auto_recycle_instance') is not None:
            self.auto_recycle_instance = m.get('auto_recycle_instance')
        return self


class ErrorReport(TeaModel):
    def __init__(
        self,
        components: List[UIComponent] = None,
    ):
        # 组件 数组
        self.components = components

    def validate(self):
        self.validate_required(self.components, 'components')
        if self.components:
            for k in self.components:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['components'] = []
        if self.components is not None:
            for k in self.components:
                result['components'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.components = []
        if m.get('components') is not None:
            for k in m.get('components'):
                temp_model = UIComponent()
                self.components.append(temp_model.from_map(k))
        return self


class ConnectorJobPartitionStatusPageResult(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total_size: int = None,
        content: List[ColumnsValue] = None,
    ):
        # 页码
        self.page_num = page_num
        # 每页数量
        self.page_size = page_size
        # 数据总数
        self.total_size = total_size
        # 分区状态
        self.content = content

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_size is not None:
            result['total_size'] = self.total_size
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = ColumnsValue()
                self.content.append(temp_model.from_map(k))
        return self


class MessageTraceDTO(TeaModel):
    def __init__(
        self,
        track_list: List[MessageTrackDTO] = None,
    ):
        # 查询结果
        self.track_list = track_list

    def validate(self):
        self.validate_required(self.track_list, 'track_list')
        if self.track_list:
            for k in self.track_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['track_list'] = []
        if self.track_list is not None:
            for k in self.track_list:
                result['track_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.track_list = []
        if m.get('track_list') is not None:
            for k in m.get('track_list'):
                temp_model = MessageTrackDTO()
                self.track_list.append(temp_model.from_map(k))
        return self


class NamespaceDO(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_type: str = None,
        namespace_name: str = None,
        workspace: str = None,
        workspace_group: str = None,
        ldc_mode: int = None,
    ):
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # instance type
        self.instance_type = instance_type
        # namespace name
        self.namespace_name = namespace_name
        # workspace
        self.workspace = workspace
        # workspace group
        self.workspace_group = workspace_group
        # ldcMode
        self.ldc_mode = ldc_mode

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.namespace_name, 'namespace_name')
        self.validate_required(self.ldc_mode, 'ldc_mode')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_type is not None:
            result['instance_type'] = self.instance_type
        if self.namespace_name is not None:
            result['namespace_name'] = self.namespace_name
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.workspace_group is not None:
            result['workspace_group'] = self.workspace_group
        if self.ldc_mode is not None:
            result['ldc_mode'] = self.ldc_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_type') is not None:
            self.instance_type = m.get('instance_type')
        if m.get('namespace_name') is not None:
            self.namespace_name = m.get('namespace_name')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('workspace_group') is not None:
            self.workspace_group = m.get('workspace_group')
        if m.get('ldc_mode') is not None:
            self.ldc_mode = m.get('ldc_mode')
        return self


class UnionControlModel(TeaModel):
    def __init__(
        self,
        control: UIControlModel = None,
        union_control: str = None,
        value: str = None,
    ):
        # 具体的联动 控件模型
        self.control = control
        # 本联动控件对应的父控件的名称，例如本联动控件是input，父控件是select，想要做到select选择某个特定选项后展示input控件，那么本字段就是 select控件的name。
        self.union_control = union_control
        # 对应父控件的value为本字段的值时，本联动控件会展示出来。例如：当topicConfig这个select控件的值是 customized时，本联动控件input就能展示了。
        self.value = value

    def validate(self):
        self.validate_required(self.control, 'control')
        if self.control:
            self.control.validate()
        self.validate_required(self.union_control, 'union_control')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.control is not None:
            result['control'] = self.control.to_map()
        if self.union_control is not None:
            result['union_control'] = self.union_control
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('control') is not None:
            temp_model = UIControlModel()
            self.control = temp_model.from_map(m['control'])
        if m.get('union_control') is not None:
            self.union_control = m.get('union_control')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class TracePageDTO(TeaModel):
    def __init__(
        self,
        content: List[TraceDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # Trace 信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = TraceDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class MsgTypePageDO(TeaModel):
    def __init__(
        self,
        content: List[MsgTypeDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # msgtypes
        self.content = content
        # page_num
        self.page_num = page_num
        # page_size
        self.page_size = page_size
        # total
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = MsgTypeDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ProcessQueryDTO(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # 任务名称
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ColumnName(TeaModel):
    def __init__(
        self,
        name: str = None,
        id: str = None,
        value_type: str = None,
    ):
        # 名称
        self.name = name
        # 唯一ID
        self.id = id
        # 值类型
        self.value_type = value_type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.value_type, 'value_type')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.id is not None:
            result['id'] = self.id
        if self.value_type is not None:
            result['value_type'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('value_type') is not None:
            self.value_type = m.get('value_type')
        return self


class MsgTypeDTO(TeaModel):
    def __init__(
        self,
        topic: str = None,
        eventcode: str = None,
        desc: str = None,
    ):
        # topic name
        self.topic = topic
        # eventcode
        self.eventcode = eventcode
        # desc
        self.desc = desc

    def validate(self):
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.eventcode, 'eventcode')

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['topic'] = self.topic
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.desc is not None:
            result['desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        return self


class SchemaDetailPageDO(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
        content: List[SchemaDetailDO] = None,
    ):
        # 页面数量
        self.page_num = page_num
        # 页大小
        self.page_size = page_size
        # 总数
        self.total = total
        # 内容
        self.content = content

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = SchemaDetailDO()
                self.content.append(temp_model.from_map(k))
        return self


class TopicStatsItem(TeaModel):
    def __init__(
        self,
        bpm: int = None,
        topic: str = None,
        tpm: int = None,
        tpd: int = None,
        bpd: int = None,
    ):
        # 该 Topic 每分钟发送的消息大小（byte）
        self.bpm = bpm
        # Topic 名称
        self.topic = topic
        # 该 Topic 每分钟发送的消息数量
        self.tpm = tpm
        # 该 Topic 每天发送的消息数量
        # 
        self.tpd = tpd
        # 该 Topic 每天发送的消息大小（byte）
        # 
        self.bpd = bpd

    def validate(self):
        self.validate_required(self.bpm, 'bpm')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.tpm, 'tpm')
        self.validate_required(self.tpd, 'tpd')
        self.validate_required(self.bpd, 'bpd')

    def to_map(self):
        result = dict()
        if self.bpm is not None:
            result['bpm'] = self.bpm
        if self.topic is not None:
            result['topic'] = self.topic
        if self.tpm is not None:
            result['tpm'] = self.tpm
        if self.tpd is not None:
            result['tpd'] = self.tpd
        if self.bpd is not None:
            result['bpd'] = self.bpd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bpm') is not None:
            self.bpm = m.get('bpm')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('tpm') is not None:
            self.tpm = m.get('tpm')
        if m.get('tpd') is not None:
            self.tpd = m.get('tpd')
        if m.get('bpd') is not None:
            self.bpd = m.get('bpd')
        return self


class TopicMetricItem(TeaModel):
    def __init__(
        self,
        recv_cnt: int = None,
        recv_traffic: int = None,
        send_cnt: int = None,
        send_traffic: int = None,
        timestamp: int = None,
    ):
        # 当前时间点 Topic 消费的消息数量
        self.recv_cnt = recv_cnt
        # 当前时间点 Topic 消费的消息流量（byte）
        self.recv_traffic = recv_traffic
        # 当前时间点 Topic 发送的消息数量
        self.send_cnt = send_cnt
        # 当前时间点 Topic 发送的消息流量（byte）
        self.send_traffic = send_traffic
        # 数据点的时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.recv_cnt, 'recv_cnt')
        self.validate_required(self.recv_traffic, 'recv_traffic')
        self.validate_required(self.send_cnt, 'send_cnt')
        self.validate_required(self.send_traffic, 'send_traffic')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        result = dict()
        if self.recv_cnt is not None:
            result['recv_cnt'] = self.recv_cnt
        if self.recv_traffic is not None:
            result['recv_traffic'] = self.recv_traffic
        if self.send_cnt is not None:
            result['send_cnt'] = self.send_cnt
        if self.send_traffic is not None:
            result['send_traffic'] = self.send_traffic
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('recv_cnt') is not None:
            self.recv_cnt = m.get('recv_cnt')
        if m.get('recv_traffic') is not None:
            self.recv_traffic = m.get('recv_traffic')
        if m.get('send_cnt') is not None:
            self.send_cnt = m.get('send_cnt')
        if m.get('send_traffic') is not None:
            self.send_traffic = m.get('send_traffic')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GroupPageDTO(TeaModel):
    def __init__(
        self,
        content: List[GroupDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # Group 信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = GroupDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class EndpointDTO(TeaModel):
    def __init__(
        self,
        doc: str = None,
        https_internet: str = None,
        http_internal: str = None,
        http_internet: str = None,
        tcp: str = None,
    ):
        # endpoint接口相关的文档
        self.doc = doc
        # https类型公网的endpoint接入点
        self.https_internet = https_internet
        # http类型内网的endpoint接口
        self.http_internal = http_internal
        # http类型的公网接入点
        self.http_internet = http_internet
        # tcp类型的endpoint接口
        self.tcp = tcp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.doc is not None:
            result['doc'] = self.doc
        if self.https_internet is not None:
            result['https_internet'] = self.https_internet
        if self.http_internal is not None:
            result['http_internal'] = self.http_internal
        if self.http_internet is not None:
            result['http_internet'] = self.http_internet
        if self.tcp is not None:
            result['tcp'] = self.tcp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('doc') is not None:
            self.doc = m.get('doc')
        if m.get('https_internet') is not None:
            self.https_internet = m.get('https_internet')
        if m.get('http_internal') is not None:
            self.http_internal = m.get('http_internal')
        if m.get('http_internet') is not None:
            self.http_internet = m.get('http_internet')
        if m.get('tcp') is not None:
            self.tcp = m.get('tcp')
        return self


class ConsumerJstackDTO(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        jstack: List[ThreadTrackDTO] = None,
    ):
        # 消费端 Client ID
        self.client_id = client_id
        # Jstack 堆栈信息
        self.jstack = jstack

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.jstack, 'jstack')
        if self.jstack:
            for k in self.jstack:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['client_id'] = self.client_id
        result['jstack'] = []
        if self.jstack is not None:
            for k in self.jstack:
                result['jstack'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        self.jstack = []
        if m.get('jstack') is not None:
            for k in m.get('jstack'):
                temp_model = ThreadTrackDTO()
                self.jstack.append(temp_model.from_map(k))
        return self


class InstancePageDTO(TeaModel):
    def __init__(
        self,
        content: List[InstanceDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # topic page
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = InstanceDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ConsumeLimiterDTO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        limiter_type: str = None,
        name: str = None,
        tps: str = None,
    ):
        # 实例ID
        # 
        self.instance_id = instance_id
        # 限流类型
        # - UNIT：单元限流，指定单元/CELL限流
        # 
        self.limiter_type = limiter_type
        # 限流资源名，由 GROUP@TOPIC 组成
        # 
        self.name = name
        # 限流值配置，BASE 为基准限流值。
        self.tps = tps

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.limiter_type, 'limiter_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tps, 'tps')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.limiter_type is not None:
            result['limiter_type'] = self.limiter_type
        if self.name is not None:
            result['name'] = self.name
        if self.tps is not None:
            result['tps'] = self.tps
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('limiter_type') is not None:
            self.limiter_type = m.get('limiter_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('tps') is not None:
            self.tps = m.get('tps')
        return self


class QueueRouteRulesPageDTO(TeaModel):
    def __init__(
        self,
        records: List[QueueRouteRulesDTO] = None,
        page_size: int = None,
        page_current: int = None,
        page_count: int = None,
        row_count: int = None,
    ):
        # 规则信息
        self.records = records
        # 页面大小
        self.page_size = page_size
        # 当前页
        self.page_current = page_current
        # 总页数
        self.page_count = page_count
        # 总记录数
        self.row_count = row_count

    def validate(self):
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_current, 'page_current')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.row_count, 'row_count')

    def to_map(self):
        result = dict()
        result['records'] = []
        if self.records is not None:
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.page_current is not None:
            result['page_current'] = self.page_current
        if self.page_count is not None:
            result['page_count'] = self.page_count
        if self.row_count is not None:
            result['row_count'] = self.row_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.records = []
        if m.get('records') is not None:
            for k in m.get('records'):
                temp_model = QueueRouteRulesDTO()
                self.records.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('page_current') is not None:
            self.page_current = m.get('page_current')
        if m.get('page_count') is not None:
            self.page_count = m.get('page_count')
        if m.get('row_count') is not None:
            self.row_count = m.get('row_count')
        return self


class WarnPageDTO(TeaModel):
    def __init__(
        self,
        content: List[WarnDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # 报警规则信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = WarnDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ApplicationServiceDTO(TeaModel):
    def __init__(
        self,
        id: int = None,
        service_id: str = None,
        name: str = None,
        app_id: int = None,
        type: str = None,
    ):
        # 应用服务id
        self.id = id
        # 应用serviceid
        self.service_id = service_id
        # 应用服务名
        self.name = name
        # 应用id
        self.app_id = app_id
        # 区分客户端的serviceid和服务端的service_id
        self.type = type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.service_id is not None:
            result['service_id'] = self.service_id
        if self.name is not None:
            result['name'] = self.name
        if self.app_id is not None:
            result['app_id'] = self.app_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('service_id') is not None:
            self.service_id = m.get('service_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('app_id') is not None:
            self.app_id = m.get('app_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplicationPageDescDTO(TeaModel):
    def __init__(
        self,
        page_count: int = None,
        page_current: int = None,
        page_size: int = None,
        records: List[ApplicationDTO] = None,
        row_count: int = None,
    ):
        # 总页数
        self.page_count = page_count
        # 当前页
        self.page_current = page_current
        # 页面显示数
        self.page_size = page_size
        # 页面记录
        self.records = records
        # 总记录数
        self.row_count = row_count

    def validate(self):
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_current, 'page_current')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()
        self.validate_required(self.row_count, 'row_count')

    def to_map(self):
        result = dict()
        if self.page_count is not None:
            result['page_count'] = self.page_count
        if self.page_current is not None:
            result['page_current'] = self.page_current
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['records'] = []
        if self.records is not None:
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        if self.row_count is not None:
            result['row_count'] = self.row_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_count') is not None:
            self.page_count = m.get('page_count')
        if m.get('page_current') is not None:
            self.page_current = m.get('page_current')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.records = []
        if m.get('records') is not None:
            for k in m.get('records'):
                temp_model = ApplicationDTO()
                self.records.append(temp_model.from_map(k))
        if m.get('row_count') is not None:
            self.row_count = m.get('row_count')
        return self


class TopicGroupHistoryStatsItem(TeaModel):
    def __init__(
        self,
        dlq: int = None,
        msg_backlog: int = None,
        recv_bpm: int = None,
        recv_ppm: int = None,
        recv_tpm: int = None,
        send_bpm: int = None,
        send_tpm: int = None,
        timestamp: int = None,
    ):
        # 当前时间点的死信数量
        self.dlq = dlq
        # 当前时间点的消息积压量
        self.msg_backlog = msg_backlog
        # 每分钟消费数据大小
        self.recv_bpm = recv_bpm
        # 每分钟拉请求数量
        self.recv_ppm = recv_ppm
        # 消费 TPM
        self.recv_tpm = recv_tpm
        # 每分钟发送消息大小
        self.send_bpm = send_bpm
        # 发送 TPM
        self.send_tpm = send_tpm
        # Unix 时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.dlq, 'dlq')
        self.validate_required(self.msg_backlog, 'msg_backlog')
        self.validate_required(self.recv_bpm, 'recv_bpm')
        self.validate_required(self.recv_ppm, 'recv_ppm')
        self.validate_required(self.recv_tpm, 'recv_tpm')
        self.validate_required(self.send_bpm, 'send_bpm')
        self.validate_required(self.send_tpm, 'send_tpm')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        result = dict()
        if self.dlq is not None:
            result['dlq'] = self.dlq
        if self.msg_backlog is not None:
            result['msg_backlog'] = self.msg_backlog
        if self.recv_bpm is not None:
            result['recv_bpm'] = self.recv_bpm
        if self.recv_ppm is not None:
            result['recv_ppm'] = self.recv_ppm
        if self.recv_tpm is not None:
            result['recv_tpm'] = self.recv_tpm
        if self.send_bpm is not None:
            result['send_bpm'] = self.send_bpm
        if self.send_tpm is not None:
            result['send_tpm'] = self.send_tpm
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dlq') is not None:
            self.dlq = m.get('dlq')
        if m.get('msg_backlog') is not None:
            self.msg_backlog = m.get('msg_backlog')
        if m.get('recv_bpm') is not None:
            self.recv_bpm = m.get('recv_bpm')
        if m.get('recv_ppm') is not None:
            self.recv_ppm = m.get('recv_ppm')
        if m.get('recv_tpm') is not None:
            self.recv_tpm = m.get('recv_tpm')
        if m.get('send_bpm') is not None:
            self.send_bpm = m.get('send_bpm')
        if m.get('send_tpm') is not None:
            self.send_tpm = m.get('send_tpm')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class ConnectorJobPageResult(TeaModel):
    def __init__(
        self,
        content: List[ConnectorJobInfo] = None,
        page_num: int = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # 任务信息列表
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页的数量
        self.page_size = page_size
        # 数据总数
        self.total_size = total_size

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_size, 'total_size')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = ConnectorJobInfo()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class MsgQueryPageDO(TeaModel):
    def __init__(
        self,
        content: List[MsgQueryBatchDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # data
        self.content = content
        # page_num
        self.page_num = page_num
        # page_size
        self.page_size = page_size
        # total
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = MsgQueryBatchDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ConfigDO(TeaModel):
    def __init__(
        self,
        property: str = None,
        target_name: str = None,
        target_type: str = None,
        value: str = None,
        id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # key
        self.property = property
        # target name
        self.target_name = target_name
        # cluster type or broker type
        self.target_type = target_type
        # value
        self.value = value
        # id
        self.id = id
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.property, 'property')
        self.validate_required(self.target_name, 'target_name')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.value, 'value')
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.property is not None:
            result['property'] = self.property
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        if self.value is not None:
            result['value'] = self.value
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('property') is not None:
            self.property = m.get('property')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class ConnectorJobQuery(TeaModel):
    def __init__(
        self,
        name: str = None,
        status: str = None,
        sort_column: str = None,
        sort_type: str = None,
        app: str = None,
        process_status: str = None,
    ):
        # 任务名称
        self.name = name
        # 任务状态
        self.status = status
        # 排序的列
        self.sort_column = sort_column
        # increment代表升序排序，decrement代表降序排序。
        # 
        self.sort_type = sort_type
        # 应用名
        self.app = app
        # 审批状态
        self.process_status = process_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.status is not None:
            result['status'] = self.status
        if self.sort_column is not None:
            result['sort_column'] = self.sort_column
        if self.sort_type is not None:
            result['sort_type'] = self.sort_type
        if self.app is not None:
            result['app'] = self.app
        if self.process_status is not None:
            result['process_status'] = self.process_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sort_column') is not None:
            self.sort_column = m.get('sort_column')
        if m.get('sort_type') is not None:
            self.sort_type = m.get('sort_type')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('process_status') is not None:
            self.process_status = m.get('process_status')
        return self


class MessagePayloadDTO(TeaModel):
    def __init__(
        self,
        schema_id: str = None,
        payload: str = None,
    ):
        # 消息对应的Schema的唯一ID
        self.schema_id = schema_id
        # 消息体内容的展现
        self.payload = payload

    def validate(self):
        self.validate_required(self.schema_id, 'schema_id')
        self.validate_required(self.payload, 'payload')

    def to_map(self):
        result = dict()
        if self.schema_id is not None:
            result['schema_id'] = self.schema_id
        if self.payload is not None:
            result['payload'] = self.payload
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('schema_id') is not None:
            self.schema_id = m.get('schema_id')
        if m.get('payload') is not None:
            self.payload = m.get('payload')
        return self


class QueueLimitValueDTO(TeaModel):
    def __init__(
        self,
        c_mode: str = None,
        id: int = None,
        limit_id: int = None,
        l_value: str = None,
        u_time: str = None,
    ):
        # 条件模式
        self.c_mode = c_mode
        # 限流域值id(新增限流规则时不填）
        self.id = id
        # 限流规则id(新增限流规则时不填）
        self.limit_id = limit_id
        # 限流域值
        self.l_value = l_value
        # 单位时间
        self.u_time = u_time

    def validate(self):
        self.validate_required(self.c_mode, 'c_mode')
        self.validate_required(self.id, 'id')
        self.validate_required(self.limit_id, 'limit_id')
        self.validate_required(self.l_value, 'l_value')
        self.validate_required(self.u_time, 'u_time')

    def to_map(self):
        result = dict()
        if self.c_mode is not None:
            result['c_mode'] = self.c_mode
        if self.id is not None:
            result['id'] = self.id
        if self.limit_id is not None:
            result['limit_id'] = self.limit_id
        if self.l_value is not None:
            result['l_value'] = self.l_value
        if self.u_time is not None:
            result['u_time'] = self.u_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('c_mode') is not None:
            self.c_mode = m.get('c_mode')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('limit_id') is not None:
            self.limit_id = m.get('limit_id')
        if m.get('l_value') is not None:
            self.l_value = m.get('l_value')
        if m.get('u_time') is not None:
            self.u_time = m.get('u_time')
        return self


class RouterPageDO(TeaModel):
    def __init__(
        self,
        content: List[RouterConfigDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # 消息路由信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = RouterConfigDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class TopicQueueDTO(TeaModel):
    def __init__(
        self,
        topic: str = None,
        broker_name: str = None,
        broker_addr_str: str = None,
        last_update_timestamp: int = None,
        max_offset: int = None,
        min_offset: int = None,
        queue_id: int = None,
    ):
        # Topic 名称
        self.topic = topic
        # Broker 名称
        self.broker_name = broker_name
        # brokerip地址
        self.broker_addr_str = broker_addr_str
        # 最后更新时间
        self.last_update_timestamp = last_update_timestamp
        # 最大 offset 位点
        self.max_offset = max_offset
        # 最小位点
        self.min_offset = min_offset
        # 队列 ID
        self.queue_id = queue_id

    def validate(self):
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.broker_name, 'broker_name')
        self.validate_required(self.broker_addr_str, 'broker_addr_str')
        self.validate_required(self.last_update_timestamp, 'last_update_timestamp')
        self.validate_required(self.max_offset, 'max_offset')
        self.validate_required(self.min_offset, 'min_offset')
        self.validate_required(self.queue_id, 'queue_id')

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['topic'] = self.topic
        if self.broker_name is not None:
            result['broker_name'] = self.broker_name
        if self.broker_addr_str is not None:
            result['broker_addr_str'] = self.broker_addr_str
        if self.last_update_timestamp is not None:
            result['last_update_timestamp'] = self.last_update_timestamp
        if self.max_offset is not None:
            result['max_offset'] = self.max_offset
        if self.min_offset is not None:
            result['min_offset'] = self.min_offset
        if self.queue_id is not None:
            result['queue_id'] = self.queue_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('broker_name') is not None:
            self.broker_name = m.get('broker_name')
        if m.get('broker_addr_str') is not None:
            self.broker_addr_str = m.get('broker_addr_str')
        if m.get('last_update_timestamp') is not None:
            self.last_update_timestamp = m.get('last_update_timestamp')
        if m.get('max_offset') is not None:
            self.max_offset = m.get('max_offset')
        if m.get('min_offset') is not None:
            self.min_offset = m.get('min_offset')
        if m.get('queue_id') is not None:
            self.queue_id = m.get('queue_id')
        return self


class QueueLimitRulesPageDTO(TeaModel):
    def __init__(
        self,
        page_count: int = None,
        page_current: int = None,
        page_size: int = None,
        row_count: int = None,
        records: List[QueueLimitRulesDTO] = None,
    ):
        # 总页数
        self.page_count = page_count
        # 当前页
        self.page_current = page_current
        # 每页条数
        self.page_size = page_size
        # 总记录数
        self.row_count = row_count
        # 队列规则信息
        self.records = records

    def validate(self):
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_current, 'page_current')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.row_count, 'row_count')
        self.validate_required(self.records, 'records')
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.page_count is not None:
            result['page_count'] = self.page_count
        if self.page_current is not None:
            result['page_current'] = self.page_current
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.row_count is not None:
            result['row_count'] = self.row_count
        result['records'] = []
        if self.records is not None:
            for k in self.records:
                result['records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_count') is not None:
            self.page_count = m.get('page_count')
        if m.get('page_current') is not None:
            self.page_current = m.get('page_current')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('row_count') is not None:
            self.row_count = m.get('row_count')
        self.records = []
        if m.get('records') is not None:
            for k in m.get('records'):
                temp_model = QueueLimitRulesDTO()
                self.records.append(temp_model.from_map(k))
        return self


class KVConfigPageDTO(TeaModel):
    def __init__(
        self,
        content: List[KVConfigDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # config page
        self.content = content
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # 总量
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = KVConfigDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class InstanceBaseInfoDTO(TeaModel):
    def __init__(
        self,
        endpoints: EndpointsDTO = None,
        independent_naming: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        instance_status: int = None,
        instance_type: int = None,
        release_time: int = None,
        remark: str = None,
    ):
        # 各个协议的接入点
        self.endpoints = endpoints
        # 实例是否有命名空间。取值说明如下：
        # 
        # true：拥有独立命名空间，资源命名确保实例内唯一，跨实例之间可重名
        # false：无独立命名空间，实例内或者跨实例之间，资源命名必须全局唯一
        self.independent_naming = independent_naming
        # 实例 ID
        self.instance_id = instance_id
        # 实例名称
        self.instance_name = instance_name
        # 实例状态。取值说明如下：
        # 
        # 0：铂金版实例部署中
        # 2：后付费实例已欠费
        # 5：后付费实例或铂金版实例服务中
        # 7：铂金版实例升级中且服务可用
        self.instance_status = instance_status
        # 实例类型。取值说明如下：
        # 
        # 1：后付费实例
        # 2：铂金版实例
        self.instance_type = instance_type
        # 铂金版实例过期时间
        # 
        # 
        self.release_time = release_time
        # 备注
        self.remark = remark

    def validate(self):
        self.validate_required(self.endpoints, 'endpoints')
        if self.endpoints:
            self.endpoints.validate()
        self.validate_required(self.independent_naming, 'independent_naming')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.instance_status, 'instance_status')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        result = dict()
        if self.endpoints is not None:
            result['endpoints'] = self.endpoints.to_map()
        if self.independent_naming is not None:
            result['independent_naming'] = self.independent_naming
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_name is not None:
            result['instance_name'] = self.instance_name
        if self.instance_status is not None:
            result['instance_status'] = self.instance_status
        if self.instance_type is not None:
            result['instance_type'] = self.instance_type
        if self.release_time is not None:
            result['release_time'] = self.release_time
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endpoints') is not None:
            temp_model = EndpointsDTO()
            self.endpoints = temp_model.from_map(m['endpoints'])
        if m.get('independent_naming') is not None:
            self.independent_naming = m.get('independent_naming')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_name') is not None:
            self.instance_name = m.get('instance_name')
        if m.get('instance_status') is not None:
            self.instance_status = m.get('instance_status')
        if m.get('instance_type') is not None:
            self.instance_type = m.get('instance_type')
        if m.get('release_time') is not None:
            self.release_time = m.get('release_time')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class BindingDTO(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        group: str = None,
        topic: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        persistence: bool = None,
    ):
        # app_name
        self.app_name = app_name
        # group
        self.group = group
        # topic
        self.topic = topic
        # eventcode
        self.eventcode = eventcode
        # exchange_type
        self.exchange_type = exchange_type
        # expression
        self.expression = expression
        # persistence
        self.persistence = persistence

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.group, 'group')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.persistence, 'persistence')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.group is not None:
            result['group'] = self.group
        if self.topic is not None:
            result['topic'] = self.topic
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.persistence is not None:
            result['persistence'] = self.persistence
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        return self


class DelayDetail(TeaModel):
    def __init__(
        self,
        delay_time: str = None,
        store_pull_delay: str = None,
        light_write_delay: str = None,
        backlog: int = None,
    ):
        # 延迟时间
        self.delay_time = delay_time
        # store拉取延迟时间
        self.store_pull_delay = store_pull_delay
        # 延迟时间
        self.light_write_delay = light_write_delay
        # 积压数量
        self.backlog = backlog

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.store_pull_delay is not None:
            result['store_pull_delay'] = self.store_pull_delay
        if self.light_write_delay is not None:
            result['light_write_delay'] = self.light_write_delay
        if self.backlog is not None:
            result['backlog'] = self.backlog
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('store_pull_delay') is not None:
            self.store_pull_delay = m.get('store_pull_delay')
        if m.get('light_write_delay') is not None:
            self.light_write_delay = m.get('light_write_delay')
        if m.get('backlog') is not None:
            self.backlog = m.get('backlog')
        return self


class ConnectorConfigs(TeaModel):
    def __init__(
        self,
        control: str = None,
        description: str = None,
        name: str = None,
        select_options: List[str] = None,
        radio_options: List[str] = None,
        child: str = None,
        visible: bool = None,
        parent: str = None,
    ):
        # 前端控件类型
        self.control = control
        # 控件描述：中文、展示给用户
        self.description = description
        # 配置项名称
        self.name = name
        # 选项控件的所有选项
        self.select_options = select_options
        # radio控件的所有选项
        self.radio_options = radio_options
        # 描述本配置的子配置名称，如果本配置是 选项类型，那么如果本选项被选中后，子控件才可见。
        self.child = child
        # 本配置是否可见，也即控件是否被用户可见
        self.visible = visible
        # 代表 本配置 的 父配置名称，便于做 控件间联动
        self.parent = parent

    def validate(self):
        self.validate_required(self.control, 'control')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.visible, 'visible')

    def to_map(self):
        result = dict()
        if self.control is not None:
            result['control'] = self.control
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.select_options is not None:
            result['select_options'] = self.select_options
        if self.radio_options is not None:
            result['radio_options'] = self.radio_options
        if self.child is not None:
            result['child'] = self.child
        if self.visible is not None:
            result['visible'] = self.visible
        if self.parent is not None:
            result['parent'] = self.parent
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('control') is not None:
            self.control = m.get('control')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('select_options') is not None:
            self.select_options = m.get('select_options')
        if m.get('radio_options') is not None:
            self.radio_options = m.get('radio_options')
        if m.get('child') is not None:
            self.child = m.get('child')
        if m.get('visible') is not None:
            self.visible = m.get('visible')
        if m.get('parent') is not None:
            self.parent = m.get('parent')
        return self


class ClusterDO(TeaModel):
    def __init__(
        self,
        appkey: str = None,
        cluster: str = None,
        cluster_type: str = None,
        deploy_mode: str = None,
        ldc_mode: str = None,
        remark: str = None,
        id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # appkey
        self.appkey = appkey
        # cluster
        self.cluster = cluster
        # cluster cluster
        self.cluster_type = cluster_type
        # 0:单机房
        self.deploy_mode = deploy_mode
        # ldc模式
        self.ldc_mode = ldc_mode
        # remark
        self.remark = remark
        # id
        self.id = id
        # create
        self.gmt_create = gmt_create
        # gmt_modified
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.id, 'id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.appkey is not None:
            result['appkey'] = self.appkey
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.cluster_type is not None:
            result['cluster_type'] = self.cluster_type
        if self.deploy_mode is not None:
            result['deploy_mode'] = self.deploy_mode
        if self.ldc_mode is not None:
            result['ldc_mode'] = self.ldc_mode
        if self.remark is not None:
            result['remark'] = self.remark
        if self.id is not None:
            result['id'] = self.id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appkey') is not None:
            self.appkey = m.get('appkey')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('cluster_type') is not None:
            self.cluster_type = m.get('cluster_type')
        if m.get('deploy_mode') is not None:
            self.deploy_mode = m.get('deploy_mode')
        if m.get('ldc_mode') is not None:
            self.ldc_mode = m.get('ldc_mode')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class AdminUserPageDTO(TeaModel):
    def __init__(
        self,
        content: List[AdminUserDTO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # admin user page
        self.content = content
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # 总条数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = AdminUserDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ResetJobOffsetRequest(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
    ):
        # 时间戳(单位为s)
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class ConsumptionStatusDTO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        group_id: str = None,
        cell: str = None,
        online: bool = None,
        total_diff: int = None,
        subscriptions: List[SubscriptionDTO] = None,
        consumption_status: List[ConsumeQueueOffset] = None,
        clients: List[ClientInfoDTO] = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 消费端groupId
        self.group_id = group_id
        # 单元化cell
        self.cell = cell
        # 消费端是否在线
        self.online = online
        # 总的位点差
        self.total_diff = total_diff
        # 所有订阅关系
        self.subscriptions = subscriptions
        # 消费者-队列状态
        self.consumption_status = consumption_status
        # 消费者客户端状态
        self.clients = clients

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.online, 'online')
        self.validate_required(self.total_diff, 'total_diff')
        self.validate_required(self.subscriptions, 'subscriptions')
        if self.subscriptions:
            for k in self.subscriptions:
                if k:
                    k.validate()
        self.validate_required(self.consumption_status, 'consumption_status')
        if self.consumption_status:
            for k in self.consumption_status:
                if k:
                    k.validate()
        self.validate_required(self.clients, 'clients')
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.online is not None:
            result['online'] = self.online
        if self.total_diff is not None:
            result['total_diff'] = self.total_diff
        result['subscriptions'] = []
        if self.subscriptions is not None:
            for k in self.subscriptions:
                result['subscriptions'].append(k.to_map() if k else None)
        result['consumption_status'] = []
        if self.consumption_status is not None:
            for k in self.consumption_status:
                result['consumption_status'].append(k.to_map() if k else None)
        result['clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['clients'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('online') is not None:
            self.online = m.get('online')
        if m.get('total_diff') is not None:
            self.total_diff = m.get('total_diff')
        self.subscriptions = []
        if m.get('subscriptions') is not None:
            for k in m.get('subscriptions'):
                temp_model = SubscriptionDTO()
                self.subscriptions.append(temp_model.from_map(k))
        self.consumption_status = []
        if m.get('consumption_status') is not None:
            for k in m.get('consumption_status'):
                temp_model = ConsumeQueueOffset()
                self.consumption_status.append(temp_model.from_map(k))
        self.clients = []
        if m.get('clients') is not None:
            for k in m.get('clients'):
                temp_model = ClientInfoDTO()
                self.clients.append(temp_model.from_map(k))
        return self


class ConsumerStatusDTO(TeaModel):
    def __init__(
        self,
        connection_set: List[ConnectionDTO] = None,
        consumer_connection_info_list: List[ConsumerConnectionInfoDTO] = None,
        consume_model: str = None,
        consume_tps: str = None,
        delay_time: int = None,
        detail_in_topic_list: List[DetailInTopicDTO] = None,
        instance_id: str = None,
        last_timestamp: int = None,
        online: bool = None,
        rebalance_ok: bool = None,
        subscription_same: bool = None,
        total_diff: int = None,
    ):
        # 该集群当前在线客户端信息
        self.connection_set = connection_set
        # 该集群在线客户端详细信息，包含 Jstack、消费 RT 时间等信息
        self.consumer_connection_info_list = consumer_connection_info_list
        # 消费模型。取值说明如下：CLUSTERING：集群消费模式；BROADCASTING：广播消费模式。
        self.consume_model = consume_model
        # 总消费 TPS
        self.consume_tps = consume_tps
        # 延迟时间
        self.delay_time = delay_time
        # 各个 Topic 的消费情况
        self.detail_in_topic_list = detail_in_topic_list
        # 实例 ID
        self.instance_id = instance_id
        # 最后更新时间
        self.last_timestamp = last_timestamp
        # 是否在线
        self.online = online
        # 客户端 Rebalance 是否正常。取值说明如下：true：正常；false：不正常。
        self.rebalance_ok = rebalance_ok
        # 订阅关系是否一致
        self.subscription_same = subscription_same
        # 集群总的消费堆积
        self.total_diff = total_diff

    def validate(self):
        self.validate_required(self.connection_set, 'connection_set')
        if self.connection_set:
            for k in self.connection_set:
                if k:
                    k.validate()
        self.validate_required(self.consumer_connection_info_list, 'consumer_connection_info_list')
        if self.consumer_connection_info_list:
            for k in self.consumer_connection_info_list:
                if k:
                    k.validate()
        self.validate_required(self.consume_model, 'consume_model')
        self.validate_required(self.consume_tps, 'consume_tps')
        self.validate_required(self.delay_time, 'delay_time')
        self.validate_required(self.detail_in_topic_list, 'detail_in_topic_list')
        if self.detail_in_topic_list:
            for k in self.detail_in_topic_list:
                if k:
                    k.validate()
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.last_timestamp, 'last_timestamp')
        self.validate_required(self.online, 'online')
        self.validate_required(self.rebalance_ok, 'rebalance_ok')
        self.validate_required(self.subscription_same, 'subscription_same')
        self.validate_required(self.total_diff, 'total_diff')

    def to_map(self):
        result = dict()
        result['connection_set'] = []
        if self.connection_set is not None:
            for k in self.connection_set:
                result['connection_set'].append(k.to_map() if k else None)
        result['consumer_connection_info_list'] = []
        if self.consumer_connection_info_list is not None:
            for k in self.consumer_connection_info_list:
                result['consumer_connection_info_list'].append(k.to_map() if k else None)
        if self.consume_model is not None:
            result['consume_model'] = self.consume_model
        if self.consume_tps is not None:
            result['consume_tps'] = self.consume_tps
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        result['detail_in_topic_list'] = []
        if self.detail_in_topic_list is not None:
            for k in self.detail_in_topic_list:
                result['detail_in_topic_list'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.last_timestamp is not None:
            result['last_timestamp'] = self.last_timestamp
        if self.online is not None:
            result['online'] = self.online
        if self.rebalance_ok is not None:
            result['rebalance_ok'] = self.rebalance_ok
        if self.subscription_same is not None:
            result['subscription_same'] = self.subscription_same
        if self.total_diff is not None:
            result['total_diff'] = self.total_diff
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connection_set = []
        if m.get('connection_set') is not None:
            for k in m.get('connection_set'):
                temp_model = ConnectionDTO()
                self.connection_set.append(temp_model.from_map(k))
        self.consumer_connection_info_list = []
        if m.get('consumer_connection_info_list') is not None:
            for k in m.get('consumer_connection_info_list'):
                temp_model = ConsumerConnectionInfoDTO()
                self.consumer_connection_info_list.append(temp_model.from_map(k))
        if m.get('consume_model') is not None:
            self.consume_model = m.get('consume_model')
        if m.get('consume_tps') is not None:
            self.consume_tps = m.get('consume_tps')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        self.detail_in_topic_list = []
        if m.get('detail_in_topic_list') is not None:
            for k in m.get('detail_in_topic_list'):
                temp_model = DetailInTopicDTO()
                self.detail_in_topic_list.append(temp_model.from_map(k))
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('last_timestamp') is not None:
            self.last_timestamp = m.get('last_timestamp')
        if m.get('online') is not None:
            self.online = m.get('online')
        if m.get('rebalance_ok') is not None:
            self.rebalance_ok = m.get('rebalance_ok')
        if m.get('subscription_same') is not None:
            self.subscription_same = m.get('subscription_same')
        if m.get('total_diff') is not None:
            self.total_diff = m.get('total_diff')
        return self


class MessageGetPageDTO(TeaModel):
    def __init__(
        self,
        content: List[MessageGetDTO] = None,
        page_num: int = None,
        page_size: int = None,
        task_id: str = None,
        total: int = None,
    ):
        # 消息的详细信息
        self.content = content
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 第一次新建查询时返回的查询任务 ID，用于后续获取消息。
        self.task_id = task_id
        # 总页数
        self.total = total

    def validate(self):
        self.validate_required(self.content, 'content')
        if self.content:
            for k in self.content:
                if k:
                    k.validate()
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = MessageGetDTO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class PartitionStatus(TeaModel):
    def __init__(
        self,
        id: str = None,
        consume_offset: int = None,
        consume_time: str = None,
        backlog_num: int = None,
    ):
        # 分区ID
        self.id = id
        # 消费位点
        self.consume_offset = consume_offset
        # 延迟时间
        self.consume_time = consume_time
        # 积压数量
        self.backlog_num = backlog_num

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.consume_offset is not None:
            result['consume_offset'] = self.consume_offset
        if self.consume_time is not None:
            result['consume_time'] = self.consume_time
        if self.backlog_num is not None:
            result['backlog_num'] = self.backlog_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('consume_offset') is not None:
            self.consume_offset = m.get('consume_offset')
        if m.get('consume_time') is not None:
            self.consume_time = m.get('consume_time')
        if m.get('backlog_num') is not None:
            self.backlog_num = m.get('backlog_num')
        return self


class BindingPageDO(TeaModel):
    def __init__(
        self,
        content: List[BindingDO] = None,
        page_num: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # binds
        self.content = content
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # total
        self.total = total

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['content'] = []
        if self.content is not None:
            for k in self.content:
                result['content'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('content') is not None:
            for k in m.get('content'):
                temp_model = BindingDO()
                self.content.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class MsgQueryDO(TeaModel):
    def __init__(
        self,
        delivery_count: int = None,
        eventcode: str = None,
        gmt_create: str = None,
        gmt_last_delivery: str = None,
        gmt_next_delivery: str = None,
        message_id: str = None,
        publisher_group: str = None,
        status: str = None,
        topic: str = None,
        transaction: bool = None,
        subscriber_group_delivery: str = None,
        subscriber_group_undelivery: str = None,
    ):
        # delivery_count
        self.delivery_count = delivery_count
        # eventcode
        self.eventcode = eventcode
        # gmt_create
        self.gmt_create = gmt_create
        # gmt_last_delivery
        self.gmt_last_delivery = gmt_last_delivery
        # gmt_next_delivery
        self.gmt_next_delivery = gmt_next_delivery
        # message_id
        self.message_id = message_id
        # publisher_group
        self.publisher_group = publisher_group
        # status
        self.status = status
        # topic
        self.topic = topic
        # transaction
        self.transaction = transaction
        # subscriber_group_delivery
        self.subscriber_group_delivery = subscriber_group_delivery
        # subscriber_group_undelivery
        self.subscriber_group_undelivery = subscriber_group_undelivery

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_last_delivery, 'gmt_last_delivery')
        self.validate_required(self.gmt_next_delivery, 'gmt_next_delivery')
        self.validate_required(self.message_id, 'message_id')
        self.validate_required(self.publisher_group, 'publisher_group')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.delivery_count is not None:
            result['delivery_count'] = self.delivery_count
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_last_delivery is not None:
            result['gmt_last_delivery'] = self.gmt_last_delivery
        if self.gmt_next_delivery is not None:
            result['gmt_next_delivery'] = self.gmt_next_delivery
        if self.message_id is not None:
            result['message_id'] = self.message_id
        if self.publisher_group is not None:
            result['publisher_group'] = self.publisher_group
        if self.status is not None:
            result['status'] = self.status
        if self.topic is not None:
            result['topic'] = self.topic
        if self.transaction is not None:
            result['transaction'] = self.transaction
        if self.subscriber_group_delivery is not None:
            result['subscriber_group_delivery'] = self.subscriber_group_delivery
        if self.subscriber_group_undelivery is not None:
            result['subscriber_group_undelivery'] = self.subscriber_group_undelivery
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('delivery_count') is not None:
            self.delivery_count = m.get('delivery_count')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_last_delivery') is not None:
            self.gmt_last_delivery = m.get('gmt_last_delivery')
        if m.get('gmt_next_delivery') is not None:
            self.gmt_next_delivery = m.get('gmt_next_delivery')
        if m.get('message_id') is not None:
            self.message_id = m.get('message_id')
        if m.get('publisher_group') is not None:
            self.publisher_group = m.get('publisher_group')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('transaction') is not None:
            self.transaction = m.get('transaction')
        if m.get('subscriber_group_delivery') is not None:
            self.subscriber_group_delivery = m.get('subscriber_group_delivery')
        if m.get('subscriber_group_undelivery') is not None:
            self.subscriber_group_undelivery = m.get('subscriber_group_undelivery')
        return self


class CellGroupDO(TeaModel):
    def __init__(
        self,
        cell_type: str = None,
        data: List[str] = None,
    ):
        # cell_type
        self.cell_type = cell_type
        # cells
        self.data = data

    def validate(self):
        self.validate_required(self.cell_type, 'cell_type')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.cell_type is not None:
            result['cell_type'] = self.cell_type
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell_type') is not None:
            self.cell_type = m.get('cell_type')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class StatusMqMessageUndeliveryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class StatusMqMessageUndeliveryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UndeliverMessageStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        eventcode: str = None,
        group: str = None,
        instance_id: str = None,
        interval_in_second: int = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # message type: eventcode
        self.eventcode = eventcode
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # interval in seconds to the current time
        self.interval_in_second = interval_in_second
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.interval_in_second, 'interval_in_second')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.interval_in_second is not None:
            result['interval_in_second'] = self.interval_in_second
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('interval_in_second') is not None:
            self.interval_in_second = m.get('interval_in_second')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class UndeliverMessageStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # status of undelivery message
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class AddMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: str = None,
        eventcode: str = None,
        instance_id: str = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # description of message type
        self.desc = desc
        # message type: eventcode
        self.eventcode = eventcode
        # middleware instance id
        self.instance_id = instance_id
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class AddMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: str = None,
        eventcode: str = None,
        instance_id: str = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # description of message type
        self.desc = desc
        # message type: eventcode
        self.eventcode = eventcode
        # middleware instance id
        self.instance_id = instance_id
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class UpdateMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        eventcode: str = None,
        instance_id: str = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # message type: eventcode
        self.eventcode = eventcode
        # middleware instance id
        self.instance_id = instance_id
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class DeleteMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QueryMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        count: int = None,
        eventcode: str = None,
        instance_id: str = None,
        offset: int = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # count value
        self.count = count
        # message type: eventcode
        self.eventcode = eventcode
        # middleware instance id
        self.instance_id = instance_id
        # offset value
        self.offset = offset
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.count is not None:
            result['count'] = self.count
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.offset is not None:
            result['offset'] = self.offset
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class QueryMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class AddBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        group: str = None,
        instance_id: str = None,
        persistence: bool = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
        zone: str = None,
        zone_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # application name
        self.app_name = app_name
        # message type: eventcode
        self.eventcode = eventcode
        # binding: exchangeType, "DIRECT" or "HEADER"
        self.exchange_type = exchange_type
        # binding: expression
        self.expression = expression
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # binding: expression
        self.persistence = persistence
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace
        # zone info
        self.zone = zone
        # zone mode
        self.zone_mode = zone_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.persistence, 'persistence')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.persistence is not None:
            result['persistence'] = self.persistence
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.zone is not None:
            result['zone'] = self.zone
        if self.zone_mode is not None:
            result['zone_mode'] = self.zone_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        if m.get('zone_mode') is not None:
            self.zone_mode = m.get('zone_mode')
        return self


class AddBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        group: str = None,
        instance_id: str = None,
        persistence: bool = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
        zone: str = None,
        zone_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # application name
        self.app_name = app_name
        # message type: eventcode
        self.eventcode = eventcode
        # binding: exchangeType, "DIRECT" or "HEADER"
        self.exchange_type = exchange_type
        # binding: expression
        self.expression = expression
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # binding: expression
        self.persistence = persistence
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace
        # zone info
        self.zone = zone
        # zone mode
        self.zone_mode = zone_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.persistence, 'persistence')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.persistence is not None:
            result['persistence'] = self.persistence
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.zone is not None:
            result['zone'] = self.zone
        if self.zone_mode is not None:
            result['zone_mode'] = self.zone_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        if m.get('zone_mode') is not None:
            self.zone_mode = m.get('zone_mode')
        return self


class UpdateBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        eventcode: str = None,
        group: str = None,
        instance_id: str = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
        zone: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # message type: eventcode
        self.eventcode = eventcode
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace
        # zone info
        self.zone = zone

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class DeleteBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QueryBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        count: int = None,
        eventcode: str = None,
        group: str = None,
        instance_id: str = None,
        offset: int = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
        zone: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # application name
        self.app_name = app_name
        # count value
        self.count = count
        # message type: eventcode
        self.eventcode = eventcode
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # offset value
        self.offset = offset
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace
        # zone info
        self.zone = zone

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.count is not None:
            result['count'] = self.count
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.offset is not None:
            result['offset'] = self.offset
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class QueryBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ExecuteSwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        dest_cell: str = None,
        instance_id: str = None,
        source_cell: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # target zone
        self.dest_cell = dest_cell
        # instance id
        self.instance_id = instance_id
        # source zone
        self.source_cell = source_cell

    def validate(self):
        self.validate_required(self.dest_cell, 'dest_cell')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_cell, 'source_cell')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class ExecuteSwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CancelSwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        dest_cell: str = None,
        instance_id: str = None,
        source_cell: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # target zone
        self.dest_cell = dest_cell
        # instance id
        self.instance_id = instance_id
        # source zone
        self.source_cell = source_cell

    def validate(self):
        self.validate_required(self.dest_cell, 'dest_cell')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_cell, 'source_cell')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class CancelSwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QuerySwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        actions: List[SwitchoverAction] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # unit list
        self.actions = actions

    def validate(self):
        self.validate_required(self.actions, 'actions')
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = SwitchoverAction()
                self.actions.append(temp_model.from_map(k))
        return self


class GetMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        count: int = None,
        eventcode: str = None,
        instance_id: str = None,
        offset: int = None,
        tenant: str = None,
        topic: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # count value
        self.count = count
        # message type: eventcode
        self.eventcode = eventcode
        # middleware instance id
        self.instance_id = instance_id
        # offset value
        self.offset = offset
        # tenant id
        self.tenant = tenant
        # message type: topic
        self.topic = topic
        # workspace id
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.count is not None:
            result['count'] = self.count
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.offset is not None:
            result['offset'] = self.offset
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.topic is not None:
            result['topic'] = self.topic
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class GetMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # request result
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UndeliveryMessageStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        end_time: int = None,
        eventcode: str = None,
        group: str = None,
        instance_id: str = None,
        status: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # end time
        self.end_time = end_time
        # message type: eventcode
        self.eventcode = eventcode
        # group of subscriber
        self.group = group
        # middleware instance id
        self.instance_id = instance_id
        # stauts
        self.status = status
        # message type: topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.status is not None:
            result['status'] = self.status
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class UndeliveryMessageStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # count of undelivery message
        self.total_count = total_count

    def validate(self):
        self.validate_required(self.total_count, 'total_count')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryTopicsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        eventcode: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # eventcode
        self.eventcode = eventcode
        # instance id
        self.instance_id = instance_id
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryTopicsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        page_num: int = None,
        page_size: int = None,
        topics: List[Topic] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # list
        self.topics = topics
        # total count
        self.total_count = total_count

    def validate(self):
        self.validate_required(self.topics, 'topics')
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['topics'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.topics = []
        if m.get('topics') is not None:
            for k in m.get('topics'):
                temp_model = Topic()
                self.topics.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class IdTopicQueryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class IdTopicQueryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        topic: Topic = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.topic, 'topic')
        if self.topic:
            self.topic.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.topic is not None:
            result['topic'] = self.topic.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('topic') is not None:
            temp_model = Topic()
            self.topic = temp_model.from_map(m['topic'])
        return self


class AddTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: str = None,
        eventcode: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # desc
        self.desc = desc
        # eventcode
        self.eventcode = eventcode
        # instance id
        self.instance_id = instance_id
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class AddTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class UpdateTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # desc
        self.desc = desc
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class UpdateTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryBindingsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        eventcode: str = None,
        group: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # appname
        self.app_name = app_name
        # eventcode
        self.eventcode = eventcode
        # group
        self.group = group
        # instance id
        self.instance_id = instance_id
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryBindingsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        bindings: List[Binding] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # list
        self.bindings = bindings
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size
        # total count
        self.total_count = total_count

    def validate(self):
        self.validate_required(self.bindings, 'bindings')
        if self.bindings:
            for k in self.bindings:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['bindings'] = []
        if self.bindings is not None:
            for k in self.bindings:
                result['bindings'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.bindings = []
        if m.get('bindings') is not None:
            for k in m.get('bindings'):
                temp_model = Binding()
                self.bindings.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class IdBindingQueryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class IdBindingQueryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        binding: Binding = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # binding
        self.binding = binding

    def validate(self):
        self.validate_required(self.binding, 'binding')
        if self.binding:
            self.binding.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.binding is not None:
            result['binding'] = self.binding.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('binding') is not None:
            temp_model = Binding()
            self.binding = temp_model.from_map(m['binding'])
        return self


class ListSofamqTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需获取的 Topic 信息列表所对应的实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 查询指定 Topic 时设置，否则查询所有 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ListSofamqTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TopicPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回所有查询到的 Topic 信息列表
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TopicPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        message_type: int = None,
        remark: str = None,
        topic: str = None,
        schema_compatibility: str = None,
        schema_serialization: str = None,
        owner: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需创建的 Topic 所对应的实例 ID
        self.instance_id = instance_id
        # 消息类型。取值说明如下：0：普通消息；1：分区顺序消息；2：全局顺序消息；4：事务消息；5：定时/延时消息。
        self.message_type = message_type
        # Topic 的备注信息
        self.remark = remark
        # 需创建的 Topic 的名称
        self.topic = topic
        # Topic对应Schema的兼容性策略
        self.schema_compatibility = schema_compatibility
        # Topic对应Schema的序列化方式
        self.schema_serialization = schema_serialization
        # Topic 所属的应用名称，要求 app name 在 zappinfo 上可查
        self.owner = owner

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.message_type, 'message_type')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.message_type is not None:
            result['message_type'] = self.message_type
        if self.remark is not None:
            result['remark'] = self.remark
        if self.topic is not None:
            result['topic'] = self.topic
        if self.schema_compatibility is not None:
            result['schema_compatibility'] = self.schema_compatibility
        if self.schema_serialization is not None:
            result['schema_serialization'] = self.schema_serialization
        if self.owner is not None:
            result['owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('message_type') is not None:
            self.message_type = m.get('message_type')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('schema_compatibility') is not None:
            self.schema_compatibility = m.get('schema_compatibility')
        if m.get('schema_serialization') is not None:
            self.schema_serialization = m.get('schema_serialization')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        return self


class CreateSofamqTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需删除的 Topic 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 指定删除的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class DeleteSofamqTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        perm: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需更新读写权限的 Topic 所对应的实例 ID
        self.instance_id = instance_id
        # 设置该 Topic 的读写模式。取值说明：6：同时支持读写；4：禁写；2：禁读。
        self.perm = perm
        # 需更新读写权限的 Topic 名称。一个用户下不可重复。
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.perm, 'perm')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.perm is not None:
            result['perm'] = self.perm
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class UpdateSofamqTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        instance_id: str = None,
        user_id: str = None,
        cluster: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 页号
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 实例ID
        self.instance_id = instance_id
        # 用户id
        self.user_id = user_id
        # 集群名
        self.cluster = cluster

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        return self


class ListSofamqInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: InstancePageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # instance list
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = InstancePageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_name: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例名称，长度为 3-64，取值可为中英文
        self.instance_name = instance_name
        # 备注信息
        self.remark = remark

    def validate(self):
        self.validate_required(self.instance_name, 'instance_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_name is not None:
            result['instance_name'] = self.instance_name
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_name') is not None:
            self.instance_name = m.get('instance_name')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class CreateSofamqInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: InstanceCreateDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # InstanceCreate返回数据
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = InstanceCreateDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteSofamqInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        instance_name: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id
        # 实例名
        self.instance_name = instance_name
        # 实例描述
        self.remark = remark

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_name, 'instance_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_name is not None:
            result['instance_name'] = self.instance_name
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_name') is not None:
            self.instance_name = m.get('instance_name')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class UpdateSofamqInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqGroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        remark: str = None,
        group_type: str = None,
        owner: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 创建的消息端 Group ID
        self.group_id = group_id
        # 需创建的 Group ID 所对应的实例 ID
        self.instance_id = instance_id
        # Group ID 描述信息
        self.remark = remark
        # 指定创建的 Group ID 适用的协议。TCP 协议和 HTTP 协议的 Group ID 不可以共用，需要分别创建。取值说明如下：
        # 
        # tcp：默认值，表示创建的 Group ID 仅适用于 TCP 协议的消息收发。
        # http：表示创建的 Group ID 仅适用于 HTTP 协议的消息收发。
        self.group_type = group_type
        # Group 所属的应用名称，要求 app name 在 zappinfo 上可查
        self.owner = owner

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.remark is not None:
            result['remark'] = self.remark
        if self.group_type is not None:
            result['group_type'] = self.group_type
        if self.owner is not None:
            result['owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('group_type') is not None:
            self.group_type = m.get('group_type')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        return self


class CreateSofamqGroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqGroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        group_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询指定 Group ID 时设置，否则查询所有 Group ID
        self.group_id = group_id
        # 需获取 Group ID 所对应的实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示数量
        self.page_size = page_size
        # 查询的 Group ID 适用的协议。TCP 协议和 HTTP 协议的 Group ID 不可以共用，需要分别创建。取值说明如下：
        # 
        # tcp：默认值，表示该 Group ID 仅适用于 TCP 协议的消息收发。
        # http：表示该 Group ID 仅适用于 HTTP 协议的消息收发。
        self.group_type = group_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.group_type is not None:
            result['group_type'] = self.group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('group_type') is not None:
            self.group_type = m.get('group_type')
        return self


class ListSofamqGroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: GroupPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询到的订阅关系集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = GroupPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteSofamqGroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要删除的消息消费集群的 Group ID
        self.group_id = group_id
        # 需删除的 Group ID 对应的实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqGroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqGroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        read_enable: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需配置的 Group ID
        self.group_id = group_id
        # 需配置的 Group ID 所对应的实例 ID
        self.instance_id = instance_id
        # 设置读消息开关
        self.read_enable = read_enable

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.read_enable, 'read_enable')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.read_enable is not None:
            result['read_enable'] = self.read_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('read_enable') is not None:
            self.read_enable = m.get('read_enable')
        return self


class UpdateSofamqGroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqTopicstatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的 Topic 所在的 Cell
        self.cell = cell
        # 需查询的 Topic 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTopicstatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TopicStatusDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询到的 Topic 的信息存储数据结构
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TopicStatusDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqTopicsubdetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的 Topic 所在的单元
        self.cell = cell
        # 需查询的 Topic 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTopicsubdetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TopicSubDetailDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回 Data 对象
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TopicSubDetailDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ListSofamqNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        data_center: str = None,
        hostname: str = None,
        node_group: str = None,
        room: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # data_center
        self.data_center = data_center
        # hostname
        self.hostname = hostname
        # node_group
        self.node_group = node_group
        # room
        self.room = room
        # page num
        self.page_num = page_num
        # page size
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.data_center is not None:
            result['data_center'] = self.data_center
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.node_group is not None:
            result['node_group'] = self.node_group
        if self.room is not None:
            result['room'] = self.room
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('data_center') is not None:
            self.data_center = m.get('data_center')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('node_group') is not None:
            self.node_group = m.get('node_group')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSofamqNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: NodePageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # node list
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = NodePageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        hostname: str = None,
        node_group: str = None,
        node_type: str = None,
        perm: str = None,
        rip: str = None,
        room: str = None,
        vip: str = None,
        data_center: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # hostname
        self.hostname = hostname
        # node_group
        self.node_group = node_group
        # node_type
        self.node_type = node_type
        # perm
        self.perm = perm
        # rip
        self.rip = rip
        # room
        self.room = room
        # vip
        self.vip = vip
        # default
        self.data_center = data_center

    def validate(self):
        self.validate_required(self.hostname, 'hostname')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.node_group is not None:
            result['node_group'] = self.node_group
        if self.node_type is not None:
            result['node_type'] = self.node_type
        if self.perm is not None:
            result['perm'] = self.perm
        if self.rip is not None:
            result['rip'] = self.rip
        if self.room is not None:
            result['room'] = self.room
        if self.vip is not None:
            result['vip'] = self.vip
        if self.data_center is not None:
            result['data_center'] = self.data_center
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('node_group') is not None:
            self.node_group = m.get('node_group')
        if m.get('node_type') is not None:
            self.node_type = m.get('node_type')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('rip') is not None:
            self.rip = m.get('rip')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        if m.get('data_center') is not None:
            self.data_center = m.get('data_center')
        return self


class CreateSofamqNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqRoomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        endpoint: str = None,
        endpoint_type: str = None,
        region: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # endpoint
        self.endpoint = endpoint
        # endpoint_type
        self.endpoint_type = endpoint_type
        # region
        self.region = region
        # room
        self.room = room

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.room, 'room')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.endpoint_type is not None:
            result['endpoint_type'] = self.endpoint_type
        if self.region is not None:
            result['region'] = self.region
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('endpoint_type') is not None:
            self.endpoint_type = m.get('endpoint_type')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class CreateSofamqRoomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        cell_type: str = None,
        datacenter: str = None,
        endpoint: str = None,
        endpoint_type: str = None,
        instance_id: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cell
        self.cell = cell
        # cell_type
        self.cell_type = cell_type
        # default
        self.datacenter = datacenter
        # endpoint
        self.endpoint = endpoint
        # endpoint_type
        self.endpoint_type = endpoint_type
        # ns id
        self.instance_id = instance_id
        # room
        self.room = room

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.cell_type is not None:
            result['cell_type'] = self.cell_type
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.endpoint_type is not None:
            result['endpoint_type'] = self.endpoint_type
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('cell_type') is not None:
            self.cell_type = m.get('cell_type')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('endpoint_type') is not None:
            self.endpoint_type = m.get('endpoint_type')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class CreateSofamqCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqClusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        appkey: str = None,
        cluster: str = None,
        cluster_type: str = None,
        deploy_mode: str = None,
        ldc_mode: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # appkey
        self.appkey = appkey
        # cluster
        self.cluster = cluster
        # cluster_type
        self.cluster_type = cluster_type
        # 0:单机房,1:本地优先,2:交叉部署,3:独占LDC
        self.deploy_mode = deploy_mode
        # unshared: 独占
        # shared: 共享
        self.ldc_mode = ldc_mode
        # remark
        self.remark = remark

    def validate(self):
        self.validate_required(self.cluster, 'cluster')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.appkey is not None:
            result['appkey'] = self.appkey
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.cluster_type is not None:
            result['cluster_type'] = self.cluster_type
        if self.deploy_mode is not None:
            result['deploy_mode'] = self.deploy_mode
        if self.ldc_mode is not None:
            result['ldc_mode'] = self.ldc_mode
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('appkey') is not None:
            self.appkey = m.get('appkey')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('cluster_type') is not None:
            self.cluster_type = m.get('cluster_type')
        if m.get('deploy_mode') is not None:
            self.deploy_mode = m.get('deploy_mode')
        if m.get('ldc_mode') is not None:
            self.ldc_mode = m.get('ldc_mode')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class CreateSofamqClusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateSofamqNamespaceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        instance_type: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        workspace: str = None,
        workspace_group: str = None,
        ldc_mode: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id
        # instance_type
        self.instance_type = instance_type
        # nsid
        self.namespace_id = namespace_id
        # namespace_name
        self.namespace_name = namespace_name
        # workspace
        self.workspace = workspace
        # workspace_group
        self.workspace_group = workspace_group
        # ldcMode
        self.ldc_mode = ldc_mode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.namespace_id, 'namespace_id')
        self.validate_required(self.namespace_name, 'namespace_name')
        self.validate_required(self.ldc_mode, 'ldc_mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_type is not None:
            result['instance_type'] = self.instance_type
        if self.namespace_id is not None:
            result['namespace_id'] = self.namespace_id
        if self.namespace_name is not None:
            result['namespace_name'] = self.namespace_name
        if self.workspace is not None:
            result['workspace'] = self.workspace
        if self.workspace_group is not None:
            result['workspace_group'] = self.workspace_group
        if self.ldc_mode is not None:
            result['ldc_mode'] = self.ldc_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_type') is not None:
            self.instance_type = m.get('instance_type')
        if m.get('namespace_id') is not None:
            self.namespace_id = m.get('namespace_id')
        if m.get('namespace_name') is not None:
            self.namespace_name = m.get('namespace_name')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        if m.get('workspace_group') is not None:
            self.workspace_group = m.get('workspace_group')
        if m.get('ldc_mode') is not None:
            self.ldc_mode = m.get('ldc_mode')
        return self


class CreateSofamqNamespaceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqRoomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        region: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # region
        self.region = region
        # room
        self.room = room

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.region is not None:
            result['region'] = self.region
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class ListSofamqRoomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[RoomDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # room
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RoomDO()
                self.data.append(temp_model.from_map(k))
        return self


class ListSofamqCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cell名
        self.cell = cell
        # 需查询的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSofamqCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CellPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # cell
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CellPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ListSofamqClusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        appkey: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # appkey
        self.appkey = appkey

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.appkey is not None:
            result['appkey'] = self.appkey
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('appkey') is not None:
            self.appkey = m.get('appkey')
        return self


class ListSofamqClusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[ClusterDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # list cell
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ClusterDO()
                self.data.append(temp_model.from_map(k))
        return self


class QuerySofamqGroupsubdetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的 Group ID 所在的 Cell
        self.cell = cell
        # 需查询的 Group ID
        self.group_id = group_id
        # 需查询的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqGroupsubdetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: GroupSubDetailDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回 Data 信息
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = GroupSubDetailDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class GetSofamqInstancebaseinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSofamqInstancebaseinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: InstanceBaseInfoDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实例信息对象
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = InstanceBaseInfoDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ExecSofamqConsumerresetoffsetRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        reset_timestamp: int = None,
        topic: str = None,
        type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        # 
        # 
        self.cell = cell
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 重置位点到指定的时间戳，仅在 Type 为 1 时生效。
        self.reset_timestamp = reset_timestamp
        # 需重置位点的 Topic 名称
        self.topic = topic
        # 消息清理类型。取值说明如下：
        # 
        # 0：清除所有消息
        # 1：清理到指定时间
        self.type = type

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.reset_timestamp is not None:
            result['reset_timestamp'] = self.reset_timestamp
        if self.topic is not None:
            result['topic'] = self.topic
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('reset_timestamp') is not None:
            self.reset_timestamp = m.get('reset_timestamp')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ExecSofamqConsumerresetoffsetResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqConsumeraccumulateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        detail: bool = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的 Group ID 所在的单元
        self.cell = cell
        # 是否查询详细信息。取值说明如下：true：要查询详细信息；false：不查询详细信息（默认值）。
        self.detail = detail
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.detail is not None:
            result['detail'] = self.detail
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('detail') is not None:
            self.detail = m.get('detail')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqConsumeraccumulateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConsumerAccumulateDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 指定 Consumer 的消费堆积情况
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConsumerAccumulateDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqConsumerconnectionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的 Group ID 所在的单元
        self.cell = cell
        # 需查询的 Group ID
        self.group_id = group_id
        # 需查询的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqConsumerconnectionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConsumerGetConnectionDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 指定 Group ID 的连接信息
        # 
        # 
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConsumerGetConnectionDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqConsumertimespanRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的消费端 Group ID 所在的 Cell
        self.cell = cell
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询的消费端 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消费端 Group ID 订阅的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqConsumertimespanResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConsumerTimeSpanDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConsumerTimeSpanDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqMessagetraceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        msg_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的Cell名
        self.cell = cell
        # 需查询的消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询消息轨迹的消息 ID，即 Message ID
        self.msg_id = msg_id
        # 消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqMessagetraceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MessageTraceDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MessageTraceDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class GetSofamqMessagebymsgidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        msg_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的消息所在的单元
        self.cell = cell
        # 需查询消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消息的 ID，即 Message ID
        self.msg_id = msg_id
        # 需查询的消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class GetSofamqMessagebymsgidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MessageGetDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MessageGetDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqMessagebykeyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        key: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的消息所在的单元
        self.cell = cell
        # 需查询的消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消息的 Message Key
        self.key = key
        # 需查询的消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.key, 'key')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.key is not None:
            result['key'] = self.key
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqMessagebykeyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[MessageGetDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = MessageGetDTO()
                self.data.append(temp_model.from_map(k))
        return self


class GetSofamqTracebymsgidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        instance_id: str = None,
        msg_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询的时间范围的起始时间点
        self.begin_time = begin_time
        # 需要查询的单元
        self.cell = cell
        # 查询的时间范围的结束时间点
        self.end_time = end_time
        # 需查询的消息的 Topic 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消息的 ID，即 Message ID
        self.msg_id = msg_id
        # 需查询的消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class GetSofamqTracebymsgidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 该查询任务的 ID。可根据该任务 ID，再调用 GetMqSofamqTraceResult 接口获取详细结果。
        self.query_id = query_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_id is not None:
            result['query_id'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        return self


class QuerySofamqTracebymsgkeyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        instance_id: str = None,
        msg_key: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询的时间范围的起始时间点
        self.begin_time = begin_time
        # 需要查询的单元
        self.cell = cell
        # 查询的时间范围的结束时间点
        self.end_time = end_time
        # 需查询的消息的 Topic 所对应的实例 ID
        self.instance_id = instance_id
        # 需查询的消息的 Message Key
        self.msg_key = msg_key
        # 需查询的消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_key, 'msg_key')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_key is not None:
            result['msg_key'] = self.msg_key
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_key') is not None:
            self.msg_key = m.get('msg_key')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTracebymsgkeyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 该查询任务的 ID。可根据该任务 ID，再调用 GetMqSofamqTraceResult 接口获取详细结果。
        self.query_id = query_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_id is not None:
            result['query_id'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        return self


class GetSofamqTraceresultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        query_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 消息轨迹查询的任务 ID
        self.query_id = query_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.query_id, 'query_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.query_id is not None:
            result['query_id'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        return self


class GetSofamqTraceresultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TraceMapResultDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 该查询任务的结果明细
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TraceMapResultDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqInputtpsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        instance_id: str = None,
        period: int = None,
        topic: str = None,
        type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询区间起始毫秒时间戳
        self.begin_time = begin_time
        # 需要查询的Cell名
        self.cell = cell
        # 查询区间终止毫秒时间戳
        self.end_time = end_time
        # 指定的 Topic 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 采样周期，单位分钟，取值可为 1、5、10
        self.period = period
        # 需查询的 Topic 名称
        self.topic = topic
        # 查询的类型。取值说明如下：
        # 
        # 0：查询指定时间段内 Topic 的写入量
        # 1：查询指定时间段内 Topic 的 TPS 曲线数据
        self.type = type

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.period is not None:
            result['period'] = self.period
        if self.topic is not None:
            result['topic'] = self.topic
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QuerySofamqInputtpsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TrendTpsDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 数据集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TrendTpsDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqOutputtpsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: str = None,
        cell: str = None,
        end_time: str = None,
        group_id: str = None,
        instance_id: str = None,
        period: int = None,
        topic: str = None,
        type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询区间起始毫秒时间戳
        self.begin_time = begin_time
        # 需要查询的Cell名
        self.cell = cell
        # 查询区间终止毫秒时间戳
        self.end_time = end_time
        # 需要查询的 Group ID
        self.group_id = group_id
        # 需统计数据的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 采样周期，单位分钟，取值可为 1、5、10
        self.period = period
        # 需要查询的 Topic 名称
        self.topic = topic
        # 查询的类型。取值说明如下：
        # 
        # 0：查询消费消息总量的统计曲线
        # 1：查询消费消息 TPS 的统计曲线
        self.type = type

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.period is not None:
            result['period'] = self.period
        if self.topic is not None:
            result['topic'] = self.topic
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QuerySofamqOutputtpsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TrendTpsDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 数据集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TrendTpsDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class GetSofamqDlqbyidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        msg_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        self.cell = cell
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消息的 ID，即 Message ID
        self.msg_id = msg_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        return self


class GetSofamqDlqbyidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MessageGetDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MessageGetDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ExecSofamqDlqresendbyidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        msg_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        self.cell = cell
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 需查询的消息的 ID，即 Message ID
        self.msg_id = msg_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        return self


class ExecSofamqDlqresendbyidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqNamespaceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSofamqNamespaceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[NamespaceDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # ns
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = NamespaceDO()
                self.data.append(temp_model.from_map(k))
        return self


class SendSofamqMessageRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        key: str = None,
        message: str = None,
        tag: str = None,
        topic: str = None,
        schema_version: int = None,
        properties: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目标单元
        self.cell = cell
        # 实例 ID
        self.instance_id = instance_id
        # 消息的 Message Key
        self.key = key
        # 消息内容
        self.message = message
        # 消息 Tag
        self.tag = tag
        # 需要发送的 Topic 名称
        self.topic = topic
        # 使用的Schema的版本号
        self.schema_version = schema_version
        # 消息属性 key-value
        self.properties = properties

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.message, 'message')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.key is not None:
            result['key'] = self.key
        if self.message is not None:
            result['message'] = self.message
        if self.tag is not None:
            result['tag'] = self.tag
        if self.topic is not None:
            result['topic'] = self.topic
        if self.schema_version is not None:
            result['schema_version'] = self.schema_version
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('schema_version') is not None:
            self.schema_version = m.get('schema_version')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class SendSofamqMessageResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        msg_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息的 Message ID
        self.msg_id = msg_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        return self


class PushSofamqMessageRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        client_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        msg_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 单元名称
        self.cell = cell
        # 需要接收消息的 Client ID
        self.client_id = client_id
        # 需要 push 的消费组 Group ID
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 需要 push 的消息 Message ID
        self.msg_id = msg_id
        # 需要发送的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class PushSofamqMessageResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqNodebynamespaceidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instanceid
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqNodebynamespaceidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[NodeDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # ndoes
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = NodeDO()
                self.data.append(temp_model.from_map(k))
        return self


class QuerySofamqRoombynamespaceidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqRoombynamespaceidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[RoomDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # rooms
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RoomDO()
                self.data.append(temp_model.from_map(k))
        return self


class QuerySofamqMessagebytopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        task_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询范围的起始时间戳
        self.begin_time = begin_time
        # 需查询的单元
        self.cell = cell
        # 查询范围的终止时间戳
        self.end_time = end_time
        # 需查询的消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 查询任务的 ID。首次查询不需要输入，后续取消息必须传入，根据前一次的返回结果取出该字段。
        self.task_id = task_id
        # 需查询的消息的 Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqMessagebytopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MessageGetPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 分页查询Message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MessageGetPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqDlqbygroupidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        group_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        task_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询范围的起始时间戳
        # 
        # 
        self.begin_time = begin_time
        # 需要查询的单元
        self.cell = cell
        # 查询范围的终止时间戳
        self.end_time = end_time
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询的消息所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页条数
        self.page_size = page_size
        # 查询任务的 ID。首次查询不需要输入，后续获取消息必须传入，根据前一次的返回结果取出该字段。
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.task_id is not None:
            result['task_id'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        return self


class QuerySofamqDlqbygroupidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MessageGetPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息内容
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MessageGetPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class GetSofamqConsumerstatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        detail: bool = None,
        group_id: str = None,
        instance_id: str = None,
        need_jstack: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        self.cell = cell
        # 是否查询详细信息。取值说明如下：true：要查询详细信息；false：不查询详细信息。
        self.detail = detail
        # 需要查询的消费端 Group ID
        self.group_id = group_id
        # 需查询的 Group ID 所对应的实例 ID。针对有独立命名空间的实例，该参数为必填。
        self.instance_id = instance_id
        # 是否打印 Jstack 信息
        self.need_jstack = need_jstack

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.detail is not None:
            result['detail'] = self.detail
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.need_jstack is not None:
            result['need_jstack'] = self.need_jstack
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('detail') is not None:
            self.detail = m.get('detail')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('need_jstack') is not None:
            self.need_jstack = m.get('need_jstack')
        return self


class GetSofamqConsumerstatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConsumerStatusDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConsumerStatusDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateSofamqTopicremarkRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        remark: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # Topic 描述信息
        self.remark = remark
        # 需更新的 Topic 名称，一个用户下不可重复。
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.remark is not None:
            result['remark'] = self.remark
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class UpdateSofamqTopicremarkResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqDatacenterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        datacenter: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster
        self.cluster = cluster
        # datacenter
        self.datacenter = datacenter
        # room
        self.room = room

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class CreateSofamqDatacenterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqDatacenterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        cluster: str = None,
        datacenter: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id
        # cluster
        self.cluster = cluster
        # datacenter
        self.datacenter = datacenter
        # room
        self.room = room

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class ListSofamqDatacenterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[DataCenterDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # datacenter
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = DataCenterDO()
                self.data.append(temp_model.from_map(k))
        return self


class ListSofamqConfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        property: str = None,
        target_name: str = None,
        target_type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # key
        self.property = property
        # target name
        self.target_name = target_name
        # cluster or broker type
        self.target_type = target_type

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.property is not None:
            result['property'] = self.property
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('property') is not None:
            self.property = m.get('property')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        return self


class ListSofamqConfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConfigPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # configs
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConfigPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateSofamqGroupremarkRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需配置更新的 Group ID
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 描述信息
        self.remark = remark

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.remark, 'remark')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class UpdateSofamqGroupremarkResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DownloadSofamqMessageRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        topic: str = None,
        msg_id: str = None,
        cell: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需配置的 Group ID 所对应的实例 ID
        self.instance_id = instance_id
        # topic名
        self.topic = topic
        # 需查询的消息的 ID，即 Message ID
        self.msg_id = msg_id
        # 需要查询的Cell名
        self.cell = cell

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.msg_id, 'msg_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.cell is not None:
            result['cell'] = self.cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        return self


class DownloadSofamqMessageResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryMetricsTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        end_time: int = None,
        instance_id: str = None,
        start_time: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 结束时间
        # 
        self.end_time = end_time
        # 实例 ID
        self.instance_id = instance_id
        # 开始时间
        self.start_time = start_time
        # 需要查询的 Topic 名称。如果 Topic 为 "ALL"，则查询当前租户下所有的 Topic 的数据。
        self.topic = topic

    def validate(self):
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryMetricsTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        end_time: int = None,
        interval: int = None,
        metrics: List[TopicMetricItem] = None,
        start_time: int = None,
        topic: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 结束时间
        # 
        self.end_time = end_time
        # 每个数据点间隔（毫秒）
        self.interval = interval
        # 数据点列表
        # 
        self.metrics = metrics
        # 开始时间
        # 
        self.start_time = start_time
        # Topic 名称
        self.topic = topic

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.interval is not None:
            result['interval'] = self.interval
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = TopicMetricItem()
                self.metrics.append(temp_model.from_map(k))
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryMetricsBacklogRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        end_time: int = None,
        instance_id: str = None,
        start_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 结束时间
        # 
        self.end_time = end_time
        # 实例 ID
        # 
        self.instance_id = instance_id
        # 开始时间
        self.start_time = start_time

    def validate(self):
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryMetricsBacklogResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        end_time: int = None,
        interval: int = None,
        metrics: List[BacklogMetricItem] = None,
        start_time: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 结束时间
        self.end_time = end_time
        # 每个时间点间隔（毫秒）
        self.interval = interval
        # 数据点
        # 
        self.metrics = metrics
        # 开始时间
        self.start_time = start_time

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.interval is not None:
            result['interval'] = self.interval
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = BacklogMetricItem()
                self.metrics.append(temp_model.from_map(k))
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryMetricsOverviewRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryMetricsOverviewResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        backlog_num: int = None,
        dlq_num: int = None,
        group_num: int = None,
        subscription_num: int = None,
        topic_num: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息堆积数量
        self.backlog_num = backlog_num
        # 死信消息数量
        self.dlq_num = dlq_num
        # 当前租户消费组数量
        self.group_num = group_num
        # 订阅关系数量
        self.subscription_num = subscription_num
        # 当前租户下的 Topic 数量
        self.topic_num = topic_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.backlog_num is not None:
            result['backlog_num'] = self.backlog_num
        if self.dlq_num is not None:
            result['dlq_num'] = self.dlq_num
        if self.group_num is not None:
            result['group_num'] = self.group_num
        if self.subscription_num is not None:
            result['subscription_num'] = self.subscription_num
        if self.topic_num is not None:
            result['topic_num'] = self.topic_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('backlog_num') is not None:
            self.backlog_num = m.get('backlog_num')
        if m.get('dlq_num') is not None:
            self.dlq_num = m.get('dlq_num')
        if m.get('group_num') is not None:
            self.group_num = m.get('group_num')
        if m.get('subscription_num') is not None:
            self.subscription_num = m.get('subscription_num')
        if m.get('topic_num') is not None:
            self.topic_num = m.get('topic_num')
        return self


class ListSofamqRouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        destination_cell: str = None,
        destination_instance_id: str = None,
        destination_topic: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        source_cell: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目标单元
        self.destination_cell = destination_cell
        # 目标实例 ID
        self.destination_instance_id = destination_instance_id
        # 目标 Topic
        self.destination_topic = destination_topic
        # 实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 源单元
        self.source_cell = source_cell
        # 源实例 ID
        self.source_instance_id = source_instance_id
        # 源 Topic
        self.source_topic = source_topic

    def validate(self):
        self.validate_required(self.destination_instance_id, 'destination_instance_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.source_instance_id, 'source_instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.destination_cell is not None:
            result['destination_cell'] = self.destination_cell
        if self.destination_instance_id is not None:
            result['destination_instance_id'] = self.destination_instance_id
        if self.destination_topic is not None:
            result['destination_topic'] = self.destination_topic
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('destination_cell') is not None:
            self.destination_cell = m.get('destination_cell')
        if m.get('destination_instance_id') is not None:
            self.destination_instance_id = m.get('destination_instance_id')
        if m.get('destination_topic') is not None:
            self.destination_topic = m.get('destination_topic')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        return self


class ListSofamqRouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: RouterPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息路由任务列表页
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = RouterPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqRouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        consumer_id: str = None,
        consume_from_type: int = None,
        consume_from_value: int = None,
        consume_to_type: int = None,
        consume_to_value: int = None,
        description: str = None,
        destination_cell: str = None,
        destination_instance_id: str = None,
        destination_topic: str = None,
        disaster: bool = None,
        disaster_recovery_datacenter: str = None,
        instance_id: str = None,
        source_cell: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
        tag: str = None,
        task_status: int = None,
        task_type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 消费端 Group
        self.consumer_id = consumer_id
        # 消费起始位点。取值范围：0：最小位点；1：最大位点；2：时间戳。
        self.consume_from_type = consume_from_type
        # 消费起始位点时间戳，时间戳的值，单位是秒
        self.consume_from_value = consume_from_value
        # 消费终止位点。取值范围：0：最小位点；1：最大位点；2：时间戳。
        self.consume_to_type = consume_to_type
        # 消费终止位点时间戳，时间戳的值，单位是秒
        self.consume_to_value = consume_to_value
        # 描述信息
        self.description = description
        # 目标单元
        self.destination_cell = destination_cell
        # 目标实例 ID
        self.destination_instance_id = destination_instance_id
        # 目标 Topic
        self.destination_topic = destination_topic
        # 容灾标识
        self.disaster = disaster
        # 容灾机房
        self.disaster_recovery_datacenter = disaster_recovery_datacenter
        # 实例 ID
        self.instance_id = instance_id
        # 源单元
        self.source_cell = source_cell
        # 源实例 ID
        self.source_instance_id = source_instance_id
        # 源 Topic
        self.source_topic = source_topic
        # 过滤 Tag
        self.tag = tag
        # 任务状态。取值说明：0：初始化；1：工作中；2：停止。
        self.task_status = task_status
        # 任务类型。取值范围： 0：LDC 复制；1：非 LDC；2：LDC 容灾。
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.consume_from_type, 'consume_from_type')
        self.validate_required(self.destination_cell, 'destination_cell')
        self.validate_required(self.destination_instance_id, 'destination_instance_id')
        self.validate_required(self.destination_topic, 'destination_topic')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_cell, 'source_cell')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_topic, 'source_topic')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.consumer_id is not None:
            result['consumer_id'] = self.consumer_id
        if self.consume_from_type is not None:
            result['consume_from_type'] = self.consume_from_type
        if self.consume_from_value is not None:
            result['consume_from_value'] = self.consume_from_value
        if self.consume_to_type is not None:
            result['consume_to_type'] = self.consume_to_type
        if self.consume_to_value is not None:
            result['consume_to_value'] = self.consume_to_value
        if self.description is not None:
            result['description'] = self.description
        if self.destination_cell is not None:
            result['destination_cell'] = self.destination_cell
        if self.destination_instance_id is not None:
            result['destination_instance_id'] = self.destination_instance_id
        if self.destination_topic is not None:
            result['destination_topic'] = self.destination_topic
        if self.disaster is not None:
            result['disaster'] = self.disaster
        if self.disaster_recovery_datacenter is not None:
            result['disaster_recovery_datacenter'] = self.disaster_recovery_datacenter
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.tag is not None:
            result['tag'] = self.tag
        if self.task_status is not None:
            result['task_status'] = self.task_status
        if self.task_type is not None:
            result['task_type'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('consumer_id') is not None:
            self.consumer_id = m.get('consumer_id')
        if m.get('consume_from_type') is not None:
            self.consume_from_type = m.get('consume_from_type')
        if m.get('consume_from_value') is not None:
            self.consume_from_value = m.get('consume_from_value')
        if m.get('consume_to_type') is not None:
            self.consume_to_type = m.get('consume_to_type')
        if m.get('consume_to_value') is not None:
            self.consume_to_value = m.get('consume_to_value')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('destination_cell') is not None:
            self.destination_cell = m.get('destination_cell')
        if m.get('destination_instance_id') is not None:
            self.destination_instance_id = m.get('destination_instance_id')
        if m.get('destination_topic') is not None:
            self.destination_topic = m.get('destination_topic')
        if m.get('disaster') is not None:
            self.disaster = m.get('disaster')
        if m.get('disaster_recovery_datacenter') is not None:
            self.disaster_recovery_datacenter = m.get('disaster_recovery_datacenter')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('task_status') is not None:
            self.task_status = m.get('task_status')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        return self


class CreateSofamqRouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteSofamqNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqRoomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteSofamqRoomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqClusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteSofamqClusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqNamespaceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqNamespaceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqDatacenterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteSofamqDatacenterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqRouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        router_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 路由任务 ID
        self.router_id = router_id
        # 实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.router_id, 'router_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.router_id is not None:
            result['router_id'] = self.router_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('router_id') is not None:
            self.router_id = m.get('router_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqRouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqConfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        property: str = None,
        target_name: str = None,
        target_type: int = None,
        value: str = None,
        scope: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # property
        self.property = property
        # target_name
        self.target_name = target_name
        # target_type
        self.target_type = target_type
        # value
        self.value = value
        # 生效范围，三板斧使用
        self.scope = scope

    def validate(self):
        self.validate_required(self.property, 'property')
        self.validate_required(self.target_name, 'target_name')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.property is not None:
            result['property'] = self.property
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        if self.value is not None:
            result['value'] = self.value
        if self.scope is not None:
            result['scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('property') is not None:
            self.property = m.get('property')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        return self


class CreateSofamqConfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[CellDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # cells
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = CellDO()
                self.data.append(temp_model.from_map(k))
        return self


class QuerySofamqRouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqRouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[RouterConfigDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # router
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RouterConfigDO()
                self.data.append(temp_model.from_map(k))
        return self


class GetMiddlewareInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        curr_tenant: str = None,
        curr_workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # curr_tenant
        self.curr_tenant = curr_tenant
        # curr_workspace
        self.curr_workspace = curr_workspace

    def validate(self):
        self.validate_required(self.curr_tenant, 'curr_tenant')
        self.validate_required(self.curr_workspace, 'curr_workspace')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.curr_tenant is not None:
            result['curr_tenant'] = self.curr_tenant
        if self.curr_workspace is not None:
            result['curr_workspace'] = self.curr_workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('curr_tenant') is not None:
            self.curr_tenant = m.get('curr_tenant')
        if m.get('curr_workspace') is not None:
            self.curr_workspace = m.get('curr_workspace')
        return self


class GetMiddlewareInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # instanceid
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetMiddlewareEndpointRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetMiddlewareEndpointResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # endpoint
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QuerySofamqCellbytypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqCellbytypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[CellGroupDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # cells
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = CellGroupDO()
                self.data.append(temp_model.from_map(k))
        return self


class ListSofamqTraceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        query_item: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 模糊查询项，可以为 Topic、Message ID 或 Message Key。
        self.query_item = query_item

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.query_item is not None:
            result['query_item'] = self.query_item
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('query_item') is not None:
            self.query_item = m.get('query_item')
        return self


class ListSofamqTraceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TracePageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询返回的数据集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TracePageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteSofamqTraceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        query_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 待删除的消息轨迹查询任务 ID
        self.query_id = query_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.query_id, 'query_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.query_id is not None:
            result['query_id'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        return self


class DeleteSofamqTraceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqTracebytopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        begin_time: int = None,
        cell: str = None,
        end_time: int = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询的时间范围的起始时间点
        self.begin_time = begin_time
        # 需要查询的单元
        self.cell = cell
        # 查询的时间范围的结束时间点
        self.end_time = end_time
        # 实例 ID
        self.instance_id = instance_id
        # 需查询的消息的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.begin_time is not None:
            result['begin_time'] = self.begin_time
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('begin_time') is not None:
            self.begin_time = m.get('begin_time')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTracebytopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 该消息轨迹查询任务的 ID
        self.query_id = query_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_id is not None:
            result['query_id'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        return self


class PushSpiPaycallbackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
        request_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # JSON data
        self.data = data
        # request_id
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['request_id'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        return self


class PushSpiPaycallbackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        data: str = None,
        message: str = None,
        success: bool = None,
        synchro: str = None,
        request_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回 code
        self.code = code
        # json data
        self.data = data
        # 返回 message
        self.message = message
        # 请求是否成功
        self.success = success
        # synchro
        self.synchro = synchro
        # request_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.success is not None:
            result['success'] = self.success
        if self.synchro is not None:
            result['synchro'] = self.synchro
        if self.request_id is not None:
            result['request_id'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('synchro') is not None:
            self.synchro = m.get('synchro')
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        return self


class PushSpiCompletecommodityRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # data
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class PushSpiCompletecommodityResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        data: str = None,
        message: str = None,
        success: bool = None,
        synchro: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # code
        self.code = code
        # data
        self.data = data
        # message
        self.message = message
        # success
        self.success = success
        # synchro
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.success is not None:
            result['success'] = self.success
        if self.synchro is not None:
            result['synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('synchro') is not None:
            self.synchro = m.get('synchro')
        return self


class PushSpiOrderverifyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # data
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class PushSpiOrderverifyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        code: str = None,
        message: str = None,
        data: str = None,
        synchro: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # success
        self.success = success
        # code
        self.code = code
        # message
        self.message = message
        # data
        self.data = data
        # synchro
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        if self.synchro is not None:
            result['synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('synchro') is not None:
            self.synchro = m.get('synchro')
        return self


class PushSpiOpencallbackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # data
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class PushSpiOpencallbackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        code: str = None,
        message: str = None,
        data: str = None,
        synchro: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # success
        self.success = success
        # code
        self.code = code
        # message
        self.message = message
        # data
        self.data = data
        # synchro
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        if self.synchro is not None:
            result['synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('synchro') is not None:
            self.synchro = m.get('synchro')
        return self


class GetSofamqLdcbynamespaceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # namespace_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSofamqLdcbynamespaceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # true
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateSofamqRouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        current_status: int = None,
        description: str = None,
        router_id: int = None,
        instance_id: str = None,
        target_status: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 当前状态
        self.current_status = current_status
        # 路由任务描述信息
        self.description = description
        # 路由任务 ID
        self.router_id = router_id
        # 实例 ID
        self.instance_id = instance_id
        # 目标状态
        self.target_status = target_status

    def validate(self):
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.description, 'description')
        self.validate_required(self.router_id, 'router_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.target_status, 'target_status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.current_status is not None:
            result['current_status'] = self.current_status
        if self.description is not None:
            result['description'] = self.description
        if self.router_id is not None:
            result['router_id'] = self.router_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.target_status is not None:
            result['target_status'] = self.target_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('current_status') is not None:
            self.current_status = m.get('current_status')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('router_id') is not None:
            self.router_id = m.get('router_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('target_status') is not None:
            self.target_status = m.get('target_status')
        return self


class UpdateSofamqRouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ExecSofamqDlqresendbatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        msg_ids: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        self.cell = cell
        # 需查询的消费端 Group ID
        self.group_id = group_id
        # 需查询消息所对应的实例 ID。
        self.instance_id = instance_id
        # 需重发的消息的 ID，即 Message ID，多个消息使用英文逗号分隔
        self.msg_ids = msg_ids

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.msg_ids, 'msg_ids')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.msg_ids is not None:
            result['msg_ids'] = self.msg_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('msg_ids') is not None:
            self.msg_ids = m.get('msg_ids')
        return self


class ExecSofamqDlqresendbatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 发送失败的消息的 ID，即 Message ID
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ListSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询指定 Group 的报警规则时设置
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 查询指定 Topic 的报警规则时设置
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ListSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: WarnPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询到的告警规则集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = WarnPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        alert_time: str = None,
        contacts: str = None,
        delay_time: int = None,
        frequency: int = None,
        group_id: str = None,
        instance_id: str = None,
        threshold: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 报警时间范围
        self.alert_time = alert_time
        # 报警通知人信息
        self.contacts = contacts
        # 延迟多少秒报报警
        self.delay_time = delay_time
        # 报警频率
        self.frequency = frequency
        # 查询指定 Group 时设置
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 堆积阈值
        self.threshold = threshold
        # 查询指定 Topic 时设置
        self.topic = topic

    def validate(self):
        self.validate_required(self.alert_time, 'alert_time')
        self.validate_required(self.contacts, 'contacts')
        self.validate_required(self.delay_time, 'delay_time')
        self.validate_required(self.frequency, 'frequency')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.threshold, 'threshold')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.alert_time is not None:
            result['alert_time'] = self.alert_time
        if self.contacts is not None:
            result['contacts'] = self.contacts
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.frequency is not None:
            result['frequency'] = self.frequency
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.threshold is not None:
            result['threshold'] = self.threshold
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('alert_time') is not None:
            self.alert_time = m.get('alert_time')
        if m.get('contacts') is not None:
            self.contacts = m.get('contacts')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('frequency') is not None:
            self.frequency = m.get('frequency')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('threshold') is not None:
            self.threshold = m.get('threshold')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class CreateSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        warn_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 待删除的报警规则 ID
        self.warn_id = warn_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.warn_id, 'warn_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        return self


class DeleteSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        alert_time: str = None,
        contacts: str = None,
        delay_time: int = None,
        frequency: int = None,
        instance_id: str = None,
        threshold: int = None,
        warn_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 报警时间范围
        self.alert_time = alert_time
        # 报警通知人信息
        self.contacts = contacts
        # 延迟多少秒报警
        self.delay_time = delay_time
        # 报警频率
        self.frequency = frequency
        # 实例 ID
        self.instance_id = instance_id
        # 阈值
        self.threshold = threshold
        # 指定修改的报警规则
        self.warn_id = warn_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.warn_id, 'warn_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.alert_time is not None:
            result['alert_time'] = self.alert_time
        if self.contacts is not None:
            result['contacts'] = self.contacts
        if self.delay_time is not None:
            result['delay_time'] = self.delay_time
        if self.frequency is not None:
            result['frequency'] = self.frequency
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.threshold is not None:
            result['threshold'] = self.threshold
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('alert_time') is not None:
            self.alert_time = m.get('alert_time')
        if m.get('contacts') is not None:
            self.contacts = m.get('contacts')
        if m.get('delay_time') is not None:
            self.delay_time = m.get('delay_time')
        if m.get('frequency') is not None:
            self.frequency = m.get('frequency')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('threshold') is not None:
            self.threshold = m.get('threshold')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        return self


class UpdateSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        warn_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 待开启的报警规则 ID
        self.warn_id = warn_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.warn_id, 'warn_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        return self


class EnableSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DisableSofamqWarnRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        warn_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id
        # 待关闭的报警规则 ID
        self.warn_id = warn_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.warn_id, 'warn_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        return self


class DisableSofamqWarnResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqWarnlogRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
        warn_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目标单元
        self.cell = cell
        # Group ID
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # Topic 名称
        self.topic = topic
        # 报警规则 ID
        self.warn_id = warn_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        if self.warn_id is not None:
            result['warn_id'] = self.warn_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('warn_id') is not None:
            self.warn_id = m.get('warn_id')
        return self


class ListSofamqWarnlogResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: WarnLogPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询到的报警日志集合
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = WarnLogPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ListSofamqAdmintopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        cluster: str = None,
        topic: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id
        # 集群名
        self.cluster = cluster
        # topic名
        self.topic = topic
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.topic is not None:
            result['topic'] = self.topic
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSofamqAdmintopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TopicPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # topic list
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TopicPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryMetricsTginstantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 要查询的单元
        self.cell = cell
        # Group ID
        self.group = group
        # 实例 ID
        self.instance_id = instance_id
        # Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryMetricsTginstantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        dlq: int = None,
        msg_backlog: int = None,
        recv_bpm: int = None,
        recv_ppm: int = None,
        recv_tpm: int = None,
        send_bpm: int = None,
        send_tpm: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前 Group 死信
        self.dlq = dlq
        # 当前消息积压
        self.msg_backlog = msg_backlog
        # 每分钟消费数据大小
        self.recv_bpm = recv_bpm
        # 每分钟拉请求数量
        self.recv_ppm = recv_ppm
        # 消费 TPM
        self.recv_tpm = recv_tpm
        # 每分钟发送消息大小
        self.send_bpm = send_bpm
        # 发送 TPM
        self.send_tpm = send_tpm

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.dlq is not None:
            result['dlq'] = self.dlq
        if self.msg_backlog is not None:
            result['msg_backlog'] = self.msg_backlog
        if self.recv_bpm is not None:
            result['recv_bpm'] = self.recv_bpm
        if self.recv_ppm is not None:
            result['recv_ppm'] = self.recv_ppm
        if self.recv_tpm is not None:
            result['recv_tpm'] = self.recv_tpm
        if self.send_bpm is not None:
            result['send_bpm'] = self.send_bpm
        if self.send_tpm is not None:
            result['send_tpm'] = self.send_tpm
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('dlq') is not None:
            self.dlq = m.get('dlq')
        if m.get('msg_backlog') is not None:
            self.msg_backlog = m.get('msg_backlog')
        if m.get('recv_bpm') is not None:
            self.recv_bpm = m.get('recv_bpm')
        if m.get('recv_ppm') is not None:
            self.recv_ppm = m.get('recv_ppm')
        if m.get('recv_tpm') is not None:
            self.recv_tpm = m.get('recv_tpm')
        if m.get('send_bpm') is not None:
            self.send_bpm = m.get('send_bpm')
        if m.get('send_tpm') is not None:
            self.send_tpm = m.get('send_tpm')
        return self


class QueryMetricsTghistoryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        end_time: int = None,
        group: str = None,
        instance_id: str = None,
        start_time: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 要查询的单元
        self.cell = cell
        # 结束时间
        self.end_time = end_time
        # 消费组 Group ID
        self.group = group
        # 实例 ID
        self.instance_id = instance_id
        # 开始时间
        self.start_time = start_time
        # Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryMetricsTghistoryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        end_time: int = None,
        interval: int = None,
        metrics: List[TopicGroupHistoryStatsItem] = None,
        start_time: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 结束时间
        self.end_time = end_time
        # 消息点之间的时间间隔（秒），默认为 1
        self.interval = interval
        # 具体的统计值
        self.metrics = metrics
        # 开始时间
        self.start_time = start_time

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.interval is not None:
            result['interval'] = self.interval
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = TopicGroupHistoryStatsItem()
                self.metrics.append(temp_model.from_map(k))
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryMetricsInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryMetricsInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        backlog_num: int = None,
        dlq_num: int = None,
        group_num: int = None,
        subscription_num: int = None,
        topic_num: int = None,
        update_at: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息积压数量
        self.backlog_num = backlog_num
        # 死信数量
        self.dlq_num = dlq_num
        # 消费组数量
        self.group_num = group_num
        # 订阅关系数量
        self.subscription_num = subscription_num
        # Topic 数量
        self.topic_num = topic_num
        # 数据更新时间戳
        self.update_at = update_at

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.backlog_num is not None:
            result['backlog_num'] = self.backlog_num
        if self.dlq_num is not None:
            result['dlq_num'] = self.dlq_num
        if self.group_num is not None:
            result['group_num'] = self.group_num
        if self.subscription_num is not None:
            result['subscription_num'] = self.subscription_num
        if self.topic_num is not None:
            result['topic_num'] = self.topic_num
        if self.update_at is not None:
            result['update_at'] = self.update_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('backlog_num') is not None:
            self.backlog_num = m.get('backlog_num')
        if m.get('dlq_num') is not None:
            self.dlq_num = m.get('dlq_num')
        if m.get('group_num') is not None:
            self.group_num = m.get('group_num')
        if m.get('subscription_num') is not None:
            self.subscription_num = m.get('subscription_num')
        if m.get('topic_num') is not None:
            self.topic_num = m.get('topic_num')
        if m.get('update_at') is not None:
            self.update_at = m.get('update_at')
        return self


class QueryMetricsInstancehistoryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        end_time: int = None,
        instance_id: str = None,
        start_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 结束时间（Unix 时间戳）
        self.end_time = end_time
        # 实例 ID
        self.instance_id = instance_id
        # 开始时间（Unix 时间戳）
        self.start_time = start_time

    def validate(self):
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryMetricsInstancehistoryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        metrics: List[TopicGroupHistoryStatsItem] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 历史统计数据
        self.metrics = metrics

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = TopicGroupHistoryStatsItem()
                self.metrics.append(temp_model.from_map(k))
        return self


class QueryStatsTopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: bool = None,
        instance_id: str = None,
        order_index: int = None,
        page_num: int = None,
        page_size: int = None,
        timestamp_sec: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否降序
        self.desc = desc
        # 实例 ID
        self.instance_id = instance_id
        # 排序字段
        self.order_index = order_index
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # Unix 时间戳
        self.timestamp_sec = timestamp_sec
        # 过滤查询的 Topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.timestamp_sec, 'timestamp_sec')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.order_index is not None:
            result['order_index'] = self.order_index
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.timestamp_sec is not None:
            result['timestamp_sec'] = self.timestamp_sec
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('order_index') is not None:
            self.order_index = m.get('order_index')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('timestamp_sec') is not None:
            self.timestamp_sec = m.get('timestamp_sec')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryStatsTopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        metrics: List[TopicStatsItem] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        updated_at: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Topic 统计详情
        self.metrics = metrics
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total_count = total_count
        # 报表数据更新的 Unix 时间戳
        self.updated_at = updated_at

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        if self.updated_at is not None:
            result['updated_at'] = self.updated_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = TopicStatsItem()
                self.metrics.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        if m.get('updated_at') is not None:
            self.updated_at = m.get('updated_at')
        return self


class QueryStatsGroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: bool = None,
        group_id: str = None,
        instance_id: str = None,
        order_index: int = None,
        page_num: int = None,
        page_size: int = None,
        timestamp_sec: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否降序，默认为降序
        self.desc = desc
        # Group ID 过滤
        self.group_id = group_id
        # 实例 ID
        self.instance_id = instance_id
        # 排序字段
        self.order_index = order_index
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # Unix 时间戳
        self.timestamp_sec = timestamp_sec
        # Topic 过滤
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.timestamp_sec, 'timestamp_sec')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.order_index is not None:
            result['order_index'] = self.order_index
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.timestamp_sec is not None:
            result['timestamp_sec'] = self.timestamp_sec
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('order_index') is not None:
            self.order_index = m.get('order_index')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('timestamp_sec') is not None:
            self.timestamp_sec = m.get('timestamp_sec')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QueryStatsGroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        metrics: List[GroupStatsItem] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        updated_at: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前实例的所有 Group 统计信息
        self.metrics = metrics
        # 页码
        self.page_num = page_num
        # 每页显示条数
        self.page_size = page_size
        # 总条数
        self.total_count = total_count
        # 报表数据更新的 Unix 时间戳
        self.updated_at = updated_at

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['metrics'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        if self.updated_at is not None:
            result['updated_at'] = self.updated_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.metrics = []
        if m.get('metrics') is not None:
            for k in m.get('metrics'):
                temp_model = GroupStatsItem()
                self.metrics.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        if m.get('updated_at') is not None:
            self.updated_at = m.get('updated_at')
        return self


class ListSofamqAdmingroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        group_id: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        show_router: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群名
        self.cluster = cluster
        # 组名
        self.group_id = group_id
        # 实例ID
        self.instance_id = instance_id
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size
        # 是否显示router group
        self.show_router = show_router

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.show_router is not None:
            result['show_router'] = self.show_router
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('show_router') is not None:
            self.show_router = m.get('show_router')
        return self


class ListSofamqAdmingroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: GroupPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # group list
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = GroupPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ListSofamqKvconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        key: str = None,
        namespace: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # key
        self.key = key
        # 命名空间
        self.namespace = namespace
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.key is not None:
            result['key'] = self.key
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSofamqKvconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: KVConfigPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # kv config page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = KVConfigPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqKvconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        namespace: str = None,
        key: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 命名空间
        self.namespace = namespace
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CreateSofamqKvconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqKvconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        namespace: str = None,
        key: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 命名空间
        self.namespace = namespace
        # key
        self.key = key

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.key is not None:
            result['key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('key') is not None:
            self.key = m.get('key')
        return self


class DeleteSofamqKvconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqKvconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        namespace: str = None,
        key: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 命名空间
        self.namespace = namespace
        # key
        self.key = key
        # 值
        self.value = value

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateSofamqKvconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqConfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        target_name: str = None,
        target_type: int = None,
        property: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目标名
        self.target_name = target_name
        # 目标类型
        self.target_type = target_type
        # 属性名
        self.property = property

    def validate(self):
        self.validate_required(self.target_name, 'target_name')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.property, 'property')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        if self.property is not None:
            result['property'] = self.property
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        if m.get('property') is not None:
            self.property = m.get('property')
        return self


class DeleteSofamqConfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqConfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        target_name: str = None,
        target_type: int = None,
        property: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目标名
        self.target_name = target_name
        # 目标类型
        self.target_type = target_type
        # 配置名
        self.property = property
        # 配置值
        self.value = value

    def validate(self):
        self.validate_required(self.target_name, 'target_name')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.property, 'property')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.target_name is not None:
            result['target_name'] = self.target_name
        if self.target_type is not None:
            result['target_type'] = self.target_type
        if self.property is not None:
            result['property'] = self.property
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('target_name') is not None:
            self.target_name = m.get('target_name')
        if m.get('target_type') is not None:
            self.target_type = m.get('target_type')
        if m.get('property') is not None:
            self.property = m.get('property')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateSofamqConfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqClusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        appkey: str = None,
        cluster: str = None,
        deploy_mode: str = None,
        remark: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # appkey
        self.appkey = appkey
        # cluster
        self.cluster = cluster
        # deploy_mode
        self.deploy_mode = deploy_mode
        # remark
        self.remark = remark

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.appkey is not None:
            result['appkey'] = self.appkey
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.deploy_mode is not None:
            result['deploy_mode'] = self.deploy_mode
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('appkey') is not None:
            self.appkey = m.get('appkey')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('deploy_mode') is not None:
            self.deploy_mode = m.get('deploy_mode')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class UpdateSofamqClusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqDatacenterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        datacenter: str = None,
        room: str = None,
        cluster: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # datacenter
        self.datacenter = datacenter
        # room
        self.room = room
        # cluster
        self.cluster = cluster

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.datacenter is not None:
            result['datacenter'] = self.datacenter
        if self.room is not None:
            result['room'] = self.room
        if self.cluster is not None:
            result['cluster'] = self.cluster
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('datacenter') is not None:
            self.datacenter = m.get('datacenter')
        if m.get('room') is not None:
            self.room = m.get('room')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        return self


class UpdateSofamqDatacenterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqRoomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        cluster: str = None,
        endpoint: str = None,
        region: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # cluster
        self.cluster = cluster
        # endpoint
        self.endpoint = endpoint
        # region
        self.region = region
        # room
        self.room = room

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.region is not None:
            result['region'] = self.region
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class UpdateSofamqRoomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSofamqNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        cluster: str = None,
        data_center: str = None,
        hostname: str = None,
        node_group: str = None,
        perm: str = None,
        rip: str = None,
        vip: str = None,
        room: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # cluster
        self.cluster = cluster
        # data_center
        self.data_center = data_center
        # hostname
        self.hostname = hostname
        # node_group
        self.node_group = node_group
        # perm
        self.perm = perm
        # rip
        self.rip = rip
        # vip
        self.vip = vip
        # room
        self.room = room

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.data_center is not None:
            result['data_center'] = self.data_center
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.node_group is not None:
            result['node_group'] = self.node_group
        if self.perm is not None:
            result['perm'] = self.perm
        if self.rip is not None:
            result['rip'] = self.rip
        if self.vip is not None:
            result['vip'] = self.vip
        if self.room is not None:
            result['room'] = self.room
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('data_center') is not None:
            self.data_center = m.get('data_center')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('node_group') is not None:
            self.node_group = m.get('node_group')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('rip') is not None:
            self.rip = m.get('rip')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        if m.get('room') is not None:
            self.room = m.get('room')
        return self


class UpdateSofamqNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqTopicqueueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询的 Topic 所在的 Cell
        self.cell = cell
        # 需查询的 Topic 所对应的实例 ID
        self.instance_id = instance_id
        # Topic 名称
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTopicqueueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[TopicQueueDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Topic 队列列表
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = TopicQueueDTO()
                self.data.append(temp_model.from_map(k))
        return self


class QuerySofamqAdmingroupsubdetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cell名
        self.cell = cell
        # 需查询的 Group ID
        self.group_id = group_id
        # 需查询的 Topic 所对应的实例 ID。
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqAdmingroupsubdetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: GroupSubDetailDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回data信息
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = GroupSubDetailDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class ListSofamqAdminuserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        login_name: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户名
        self.login_name = login_name
        # 页号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.login_name is not None:
            result['login_name'] = self.login_name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('login_name') is not None:
            self.login_name = m.get('login_name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSofamqAdminuserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: AdminUserPageDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 管理员用户分页数据
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = AdminUserPageDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSofamqAdminuserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        login_name: str = None,
        password: str = None,
        user_type: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 登录名
        self.login_name = login_name
        # 用户密码
        self.password = password
        # 用户类型
        self.user_type = user_type

    def validate(self):
        self.validate_required(self.login_name, 'login_name')
        self.validate_required(self.password, 'password')
        self.validate_required(self.user_type, 'user_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.login_name is not None:
            result['login_name'] = self.login_name
        if self.password is not None:
            result['password'] = self.password
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('login_name') is not None:
            self.login_name = m.get('login_name')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CreateSofamqAdminuserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofamqAdminuserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        login_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 管理员用户名
        self.login_name = login_name

    def validate(self):
        self.validate_required(self.login_name, 'login_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.login_name is not None:
            result['login_name'] = self.login_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('login_name') is not None:
            self.login_name = m.get('login_name')
        return self


class DeleteSofamqAdminuserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofamqAdminapiRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        show_create: bool = None,
        show_delete: bool = None,
        show_retrieve: bool = None,
        show_update: bool = None,
        show_operation: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否显示创建接口
        self.show_create = show_create
        # 是否显示删除接口
        self.show_delete = show_delete
        # 是否显示查询接口
        self.show_retrieve = show_retrieve
        # 是否显示更新接口
        self.show_update = show_update
        # 是否显示操作类接口
        self.show_operation = show_operation

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.show_create is not None:
            result['show_create'] = self.show_create
        if self.show_delete is not None:
            result['show_delete'] = self.show_delete
        if self.show_retrieve is not None:
            result['show_retrieve'] = self.show_retrieve
        if self.show_update is not None:
            result['show_update'] = self.show_update
        if self.show_operation is not None:
            result['show_operation'] = self.show_operation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('show_create') is not None:
            self.show_create = m.get('show_create')
        if m.get('show_delete') is not None:
            self.show_delete = m.get('show_delete')
        if m.get('show_retrieve') is not None:
            self.show_retrieve = m.get('show_retrieve')
        if m.get('show_update') is not None:
            self.show_update = m.get('show_update')
        if m.get('show_operation') is not None:
            self.show_operation = m.get('show_operation')
        return self


class ListSofamqAdminapiResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[ApiInfoDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ApiInfoDTO()
                self.data.append(temp_model.from_map(k))
        return self


class SwitchSofamqAdminapiRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        switch_open: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # api接口名
        self.name = name
        # 开关是否打开
        self.switch_open = switch_open

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.switch_open, 'switch_open')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.switch_open is not None:
            result['switch_open'] = self.switch_open
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('switch_open') is not None:
            self.switch_open = m.get('switch_open')
        return self


class SwitchSofamqAdminapiResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        topic: str = None,
        eventcode: str = None,
        desc: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # topic
        self.topic = topic
        # eventcode
        self.eventcode = eventcode
        # desc
        self.desc = desc

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.eventcode, 'eventcode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.desc is not None:
            result['desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        return self


class AddDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        page_num: int = None,
        eventcode: str = None,
        instance_id: str = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # currentPage
        self.page_num = page_num
        # eventcode
        self.eventcode = eventcode
        # instance_id
        self.instance_id = instance_id
        # page size
        self.page_size = page_size
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ListDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MsgTypePageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # msgtypes
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MsgTypePageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        group: str = None,
        instance_id: str = None,
        persistence: bool = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # appname
        self.app_name = app_name
        # eventcode
        self.eventcode = eventcode
        # exchange_type
        self.exchange_type = exchange_type
        # expression
        self.expression = expression
        # groupid
        self.group = group
        # instance_id
        self.instance_id = instance_id
        # persistence
        self.persistence = persistence
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.persistence, 'persistence')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.persistence is not None:
            result['persistence'] = self.persistence
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class CreateDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        eventcode: str = None,
        group: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # appname
        self.app_name = app_name
        # eventcode
        self.eventcode = eventcode
        # groupid
        self.group = group
        # current_page
        self.page_num = page_num
        # page_size
        self.page_size = page_size
        # topic
        self.topic = topic
        # ins
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.group is not None:
            result['group'] = self.group
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: BindingPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = BindingPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
        eventcode: str = None,
        desc: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # eventcode
        self.eventcode = eventcode
        # desc
        self.desc = desc

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.eventcode, 'eventcode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.desc is not None:
            result['desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        return self


class UpdateDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
        eventcode: str = None,
        exchange_type: str = None,
        expression: str = None,
        persistence: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id
        # eventcode
        self.eventcode = eventcode
        # exchange_type
        self.exchange_type = exchange_type
        # expression
        self.expression = expression
        # persistence
        self.persistence = persistence

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.exchange_type, 'exchange_type')
        self.validate_required(self.persistence, 'persistence')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.exchange_type is not None:
            result['exchange_type'] = self.exchange_type
        if self.expression is not None:
            result['expression'] = self.expression
        if self.persistence is not None:
            result['persistence'] = self.persistence
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('exchange_type') is not None:
            self.exchange_type = m.get('exchange_type')
        if m.get('expression') is not None:
            self.expression = m.get('expression')
        if m.get('persistence') is not None:
            self.persistence = m.get('persistence')
        return self


class UpdateDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDmsMsgRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryDmsMsgResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MsgQueryDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MsgQueryDO()
            self.data = temp_model.from_map(m['data'])
        return self


class BatchqueryDmsMsgRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        born_time_begin: str = None,
        born_time_end: str = None,
        page_num: int = None,
        eventcode: str = None,
        instance_id: str = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # born_time_begin
        self.born_time_begin = born_time_begin
        # born_time_end
        self.born_time_end = born_time_end
        # current_page
        self.page_num = page_num
        # eventcode
        self.eventcode = eventcode
        # instance_id
        self.instance_id = instance_id
        # page_size
        self.page_size = page_size
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.born_time_begin, 'born_time_begin')
        self.validate_required(self.born_time_end, 'born_time_end')
        self.validate_required(self.eventcode, 'eventcode')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.born_time_begin is not None:
            result['born_time_begin'] = self.born_time_begin
        if self.born_time_end is not None:
            result['born_time_end'] = self.born_time_end
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('born_time_begin') is not None:
            self.born_time_begin = m.get('born_time_begin')
        if m.get('born_time_end') is not None:
            self.born_time_end = m.get('born_time_end')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class BatchqueryDmsMsgResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: MsgQueryPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = MsgQueryPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteDmsMsgRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDmsMsgResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class BatchdeleteDmsMsgRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class BatchdeleteDmsMsgResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ExportDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ids: str = None,
        field: str = None,
        order: str = None,
        topic: str = None,
        eventcode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # id列表，为空则表示导出当前instance_id全部数据
        self.ids = ids
        # field
        self.field = field
        # order
        self.order = order
        # topic
        self.topic = topic
        # eventcode
        self.eventcode = eventcode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ids is not None:
            result['ids'] = self.ids
        if self.field is not None:
            result['field'] = self.field
        if self.order is not None:
            result['order'] = self.order
        if self.topic is not None:
            result['topic'] = self.topic
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        return self


class ExportDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        msg_type_list: List[MsgTypeDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回的导出结果具体数据
        self.msg_type_list = msg_type_list

    def validate(self):
        if self.msg_type_list:
            for k in self.msg_type_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['msg_type_list'] = []
        if self.msg_type_list is not None:
            for k in self.msg_type_list:
                result['msg_type_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.msg_type_list = []
        if m.get('msg_type_list') is not None:
            for k in m.get('msg_type_list'):
                temp_model = MsgTypeDTO()
                self.msg_type_list.append(temp_model.from_map(k))
        return self


class ImportDmsMsgtypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 导入的excel文件转换成的具体json字符串内容
        self.content = content
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content is not None:
            result['content'] = self.content
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ImportDmsMsgtypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total_count: int = None,
        success_count: int = None,
        exist_records: List[MsgTypeDTO] = None,
        process_error_records: List[MsgTypeDTO] = None,
        format_error_records: List[MsgTypeDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导入内容总条数
        self.total_count = total_count
        # 导入成功数量
        self.success_count = success_count
        # 已经存在的记录总数
        self.exist_records = exist_records
        # 导入失败的记录详情
        self.process_error_records = process_error_records
        # 格式错误的记录
        self.format_error_records = format_error_records

    def validate(self):
        if self.exist_records:
            for k in self.exist_records:
                if k:
                    k.validate()
        if self.process_error_records:
            for k in self.process_error_records:
                if k:
                    k.validate()
        if self.format_error_records:
            for k in self.format_error_records:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total_count is not None:
            result['total_count'] = self.total_count
        if self.success_count is not None:
            result['success_count'] = self.success_count
        result['exist_records'] = []
        if self.exist_records is not None:
            for k in self.exist_records:
                result['exist_records'].append(k.to_map() if k else None)
        result['process_error_records'] = []
        if self.process_error_records is not None:
            for k in self.process_error_records:
                result['process_error_records'].append(k.to_map() if k else None)
        result['format_error_records'] = []
        if self.format_error_records is not None:
            for k in self.format_error_records:
                result['format_error_records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        if m.get('success_count') is not None:
            self.success_count = m.get('success_count')
        self.exist_records = []
        if m.get('exist_records') is not None:
            for k in m.get('exist_records'):
                temp_model = MsgTypeDTO()
                self.exist_records.append(temp_model.from_map(k))
        self.process_error_records = []
        if m.get('process_error_records') is not None:
            for k in m.get('process_error_records'):
                temp_model = MsgTypeDTO()
                self.process_error_records.append(temp_model.from_map(k))
        self.format_error_records = []
        if m.get('format_error_records') is not None:
            for k in m.get('format_error_records'):
                temp_model = MsgTypeDTO()
                self.format_error_records.append(temp_model.from_map(k))
        return self


class ExportDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ids: str = None,
        field: str = None,
        order: str = None,
        app_name: str = None,
        group: str = None,
        topic: str = None,
        eventcode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # ids
        self.ids = ids
        # field
        self.field = field
        # order
        self.order = order
        # appname
        self.app_name = app_name
        # groupid
        self.group = group
        # topic
        self.topic = topic
        # eventcode
        self.eventcode = eventcode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ids is not None:
            result['ids'] = self.ids
        if self.field is not None:
            result['field'] = self.field
        if self.order is not None:
            result['order'] = self.order
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.group is not None:
            result['group'] = self.group
        if self.topic is not None:
            result['topic'] = self.topic
        if self.eventcode is not None:
            result['eventcode'] = self.eventcode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ids') is not None:
            self.ids = m.get('ids')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('eventcode') is not None:
            self.eventcode = m.get('eventcode')
        return self


class ExportDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        binding_list: List[BindingDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导出数据列表
        self.binding_list = binding_list

    def validate(self):
        if self.binding_list:
            for k in self.binding_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['binding_list'] = []
        if self.binding_list is not None:
            for k in self.binding_list:
                result['binding_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.binding_list = []
        if m.get('binding_list') is not None:
            for k in m.get('binding_list'):
                temp_model = BindingDTO()
                self.binding_list.append(temp_model.from_map(k))
        return self


class ImportDmsBindingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # 导入的excel文件转换成的具体json字符串内容
        self.content = content

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class ImportDmsBindingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total_count: int = None,
        success_count: int = None,
        format_error_records: List[BindingDTO] = None,
        process_error_records: List[BindingDTO] = None,
        exist_records: List[BindingDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导入总数
        self.total_count = total_count
        # 导入成功总数
        self.success_count = success_count
        # 格式化或者参数错误元素列表
        self.format_error_records = format_error_records
        # 导入错误元素列表
        self.process_error_records = process_error_records
        # 已存在元素列表
        self.exist_records = exist_records

    def validate(self):
        if self.format_error_records:
            for k in self.format_error_records:
                if k:
                    k.validate()
        if self.process_error_records:
            for k in self.process_error_records:
                if k:
                    k.validate()
        if self.exist_records:
            for k in self.exist_records:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total_count is not None:
            result['total_count'] = self.total_count
        if self.success_count is not None:
            result['success_count'] = self.success_count
        result['format_error_records'] = []
        if self.format_error_records is not None:
            for k in self.format_error_records:
                result['format_error_records'].append(k.to_map() if k else None)
        result['process_error_records'] = []
        if self.process_error_records is not None:
            for k in self.process_error_records:
                result['process_error_records'].append(k.to_map() if k else None)
        result['exist_records'] = []
        if self.exist_records is not None:
            for k in self.exist_records:
                result['exist_records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        if m.get('success_count') is not None:
            self.success_count = m.get('success_count')
        self.format_error_records = []
        if m.get('format_error_records') is not None:
            for k in m.get('format_error_records'):
                temp_model = BindingDTO()
                self.format_error_records.append(temp_model.from_map(k))
        self.process_error_records = []
        if m.get('process_error_records') is not None:
            for k in m.get('process_error_records'):
                temp_model = BindingDTO()
                self.process_error_records.append(temp_model.from_map(k))
        self.exist_records = []
        if m.get('exist_records') is not None:
            for k in m.get('exist_records'):
                temp_model = BindingDTO()
                self.exist_records.append(temp_model.from_map(k))
        return self


class ListDmsWhitelistRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # groupid
        self.group = group
        # instance_id
        self.instance_id = instance_id
        # page_num
        self.page_num = page_num
        # page_size
        self.page_size = page_size
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class ListDmsWhitelistResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: WhitelistPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = WhitelistPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class AddDmsWhitelistRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group: str = None,
        instance_id: str = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # groupid
        self.group = group
        # instance_id
        self.instance_id = instance_id
        # topic
        self.topic = topic

    def validate(self):
        self.validate_required(self.group, 'group')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class AddDmsWhitelistResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteDmsWhitelistRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # id
        self.id = id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class DeleteDmsWhitelistResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class GetDmsTopicsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        group: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ins
        self.instance_id = instance_id
        # group
        self.group = group

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.group, 'group')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.group is not None:
            result['group'] = self.group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('group') is not None:
            self.group = m.get('group')
        return self


class GetDmsTopicsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetSofamqConsumerjstackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        client_id: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的单元
        self.cell = cell
        # 需要查询的消费端 Client ID
        self.client_id = client_id
        # 需要查询的消费端的 Group ID
        self.group_id = group_id
        # 需要查询的消费者对应的实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.client_id is not None:
            result['client_id'] = self.client_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('client_id') is not None:
            self.client_id = m.get('client_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSofamqConsumerjstackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConsumerJstackDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消费端 Jstack 堆栈信息
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConsumerJstackDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDmsUploadurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_name: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # file_name
        self.file_name = file_name
        # instance_id
        self.instance_id = instance_id
        # type
        self.type = type

    def validate(self):
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QueryDmsUploadurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetDmsMsgtypetemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDmsMsgtypetemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetDmsBindingtemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ins
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDmsBindingtemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QueryMsgdumpSourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 当前 instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryMsgdumpSourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[MsgdumpSourceInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 消息同步源端信息
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = MsgdumpSourceInfo()
                self.data.append(temp_model.from_map(k))
        return self


class CreateMsgdumpTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        remark: str = None,
        source_event_code: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
        target_tag: str = None,
        target_topic: str = None,
        target_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cell
        self.cell = cell
        # 对消息同步任务的描述
        self.remark = remark
        # 源端 event code
        self.source_event_code = source_event_code
        # 源端实例 id
        self.source_instance_id = source_instance_id
        # 源端 topic
        self.source_topic = source_topic
        # 目标 tag
        self.target_tag = target_tag
        # 目标 topic
        self.target_topic = target_topic
        # 目标 instance id
        self.target_instance_id = target_instance_id

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.source_event_code, 'source_event_code')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_topic, 'source_topic')
        self.validate_required(self.target_tag, 'target_tag')
        self.validate_required(self.target_topic, 'target_topic')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.remark is not None:
            result['remark'] = self.remark
        if self.source_event_code is not None:
            result['source_event_code'] = self.source_event_code
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.target_tag is not None:
            result['target_tag'] = self.target_tag
        if self.target_topic is not None:
            result['target_topic'] = self.target_topic
        if self.target_instance_id is not None:
            result['target_instance_id'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('source_event_code') is not None:
            self.source_event_code = m.get('source_event_code')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('target_tag') is not None:
            self.target_tag = m.get('target_tag')
        if m.get('target_topic') is not None:
            self.target_topic = m.get('target_topic')
        if m.get('target_instance_id') is not None:
            self.target_instance_id = m.get('target_instance_id')
        return self


class CreateMsgdumpTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryMsgdumpTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        source_event_code: str = None,
        source_instance_id: str = None,
        source_topic: str = None,
        status: int = None,
        target_instance_id: str = None,
        target_tag: str = None,
        target_topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 源 event code
        self.source_event_code = source_event_code
        # 源实例 id
        self.source_instance_id = source_instance_id
        # 源 topic
        self.source_topic = source_topic
        # 任务状态
        self.status = status
        # 目标 instance id
        self.target_instance_id = target_instance_id
        # 目标 tag
        self.target_tag = target_tag
        # 目标 topic
        self.target_topic = target_topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.source_event_code is not None:
            result['source_event_code'] = self.source_event_code
        if self.source_instance_id is not None:
            result['source_instance_id'] = self.source_instance_id
        if self.source_topic is not None:
            result['source_topic'] = self.source_topic
        if self.status is not None:
            result['status'] = self.status
        if self.target_instance_id is not None:
            result['target_instance_id'] = self.target_instance_id
        if self.target_tag is not None:
            result['target_tag'] = self.target_tag
        if self.target_topic is not None:
            result['target_topic'] = self.target_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('source_event_code') is not None:
            self.source_event_code = m.get('source_event_code')
        if m.get('source_instance_id') is not None:
            self.source_instance_id = m.get('source_instance_id')
        if m.get('source_topic') is not None:
            self.source_topic = m.get('source_topic')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('target_instance_id') is not None:
            self.target_instance_id = m.get('target_instance_id')
        if m.get('target_tag') is not None:
            self.target_tag = m.get('target_tag')
        if m.get('target_topic') is not None:
            self.target_topic = m.get('target_topic')
        return self


class QueryMsgdumpTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[MsgdumpTaskDTO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务列表
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = MsgdumpTaskDTO()
                self.data.append(temp_model.from_map(k))
        return self


class DeleteMsgdumpTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        task_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务 id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        return self


class DeleteMsgdumpTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableMsgdumpTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        task_id: int = None,
        enable: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务 id
        self.task_id = task_id
        # true: 启动任务
        # false: 停止任务
        self.enable = enable

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.enable, 'enable')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.enable is not None:
            result['enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        return self


class EnableMsgdumpTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSchemaAdminmetadataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        page_num: int = None,
        page_size: int = None,
        schema_tenant: str = None,
        schema_namespace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ的实例ID
        self.instance_id = instance_id
        # 名称
        self.name = name
        # 页号
        self.page_num = page_num
        # 页大小
        self.page_size = page_size
        # schema的租户信息
        self.schema_tenant = schema_tenant
        # schema的命名空间
        self.schema_namespace = schema_namespace

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        if self.schema_namespace is not None:
            result['schema_namespace'] = self.schema_namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        if m.get('schema_namespace') is not None:
            self.schema_namespace = m.get('schema_namespace')
        return self


class ListSchemaAdminmetadataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: SchemaMetadataPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 数据
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = SchemaMetadataPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSchemaAdminmetadataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        app: str = None,
        compatibility: str = None,
        description: str = None,
        name: str = None,
        namespace: str = None,
        schema_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ实例ID
        self.instance_id = instance_id
        # 应用名称
        self.app = app
        # 兼容性策略
        self.compatibility = compatibility
        # 描述
        # 
        self.description = description
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 租户
        self.schema_tenant = schema_tenant

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.app, 'app')
        self.validate_required(self.compatibility, 'compatibility')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app is not None:
            result['app'] = self.app
        if self.compatibility is not None:
            result['compatibility'] = self.compatibility
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('compatibility') is not None:
            self.compatibility = m.get('compatibility')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        return self


class CreateSchemaAdminmetadataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSchemaAdminmetadataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        app: str = None,
        compatibility: str = None,
        coordinate: str = None,
        description: str = None,
        name: str = None,
        namespace: str = None,
        schema_tenant: str = None,
        state: str = None,
        sync_sites: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ实例ID
        self.instance_id = instance_id
        # 应用名
        self.app = app
        # 兼容性
        self.compatibility = compatibility
        # 依赖坐标
        self.coordinate = coordinate
        # 描述
        self.description = description
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 租户
        self.schema_tenant = schema_tenant
        # 状态
        self.state = state
        # 同步站点
        self.sync_sites = sync_sites

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app is not None:
            result['app'] = self.app
        if self.compatibility is not None:
            result['compatibility'] = self.compatibility
        if self.coordinate is not None:
            result['coordinate'] = self.coordinate
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        if self.state is not None:
            result['state'] = self.state
        if self.sync_sites is not None:
            result['sync_sites'] = self.sync_sites
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('compatibility') is not None:
            self.compatibility = m.get('compatibility')
        if m.get('coordinate') is not None:
            self.coordinate = m.get('coordinate')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('sync_sites') is not None:
            self.sync_sites = m.get('sync_sites')
        return self


class UpdateSchemaAdminmetadataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSchemaAdminmetadataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        namespace: str = None,
        schema_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ的实例ID
        self.instance_id = instance_id
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 租户
        self.schema_tenant = schema_tenant

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        return self


class DeleteSchemaAdminmetadataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSchemaAdmindetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ的实例ID
        self.instance_id = instance_id
        # schema 名称
        self.name = name
        # 页面编号
        self.page_num = page_num
        # 页面大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class ListSchemaAdmindetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: SchemaDetailPageDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 分页返回值
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = SchemaDetailPageDO()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateSchemaAdmindetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        content: str = None,
        field_validate_rule: str = None,
        name: str = None,
        namespace: str = None,
        schema_tenant: str = None,
        serialization: str = None,
        schema_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ的实例ID
        self.instance_id = instance_id
        # 内容
        self.content = content
        # 值校验
        self.field_validate_rule = field_validate_rule
        # 名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 租户
        self.schema_tenant = schema_tenant
        # 序列化方式
        self.serialization = serialization
        # 类型
        self.schema_type = schema_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.name, 'name')
        self.validate_required(self.serialization, 'serialization')
        self.validate_required(self.schema_type, 'schema_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.content is not None:
            result['content'] = self.content
        if self.field_validate_rule is not None:
            result['field_validate_rule'] = self.field_validate_rule
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        if self.serialization is not None:
            result['serialization'] = self.serialization
        if self.schema_type is not None:
            result['schema_type'] = self.schema_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('field_validate_rule') is not None:
            self.field_validate_rule = m.get('field_validate_rule')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        if m.get('serialization') is not None:
            self.serialization = m.get('serialization')
        if m.get('schema_type') is not None:
            self.schema_type = m.get('schema_type')
        return self


class CreateSchemaAdmindetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSchemaAdmindetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        uniq_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # uniq_id
        self.uniq_id = uniq_id

    def validate(self):
        self.validate_required(self.uniq_id, 'uniq_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.uniq_id is not None:
            result['uniq_id'] = self.uniq_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('uniq_id') is not None:
            self.uniq_id = m.get('uniq_id')
        return self


class DeleteSchemaAdmindetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqEndpointRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqEndpointResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: EndpointDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 接入点列表信息
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = EndpointDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySchemaAdminmetadataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        namespace: str = None,
        schema_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SOFAMQ实例ID
        self.instance_id = instance_id
        # schema名称
        self.name = name
        # 命名空间
        self.namespace = namespace
        # 租户
        self.schema_tenant = schema_tenant

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.schema_tenant is not None:
            result['schema_tenant'] = self.schema_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('schema_tenant') is not None:
            self.schema_tenant = m.get('schema_tenant')
        return self


class QuerySchemaAdminmetadataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: SchemaMetadataDO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # schema元数据
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = SchemaMetadataDO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySchemaAdminconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        config_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 配置类型
        self.config_type = config_type

    def validate(self):
        self.validate_required(self.config_type, 'config_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.config_type is not None:
            result['config_type'] = self.config_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('config_type') is not None:
            self.config_type = m.get('config_type')
        return self


class QuerySchemaAdminconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 配置列表
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QuerySofamqLinkRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofamqLinkResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: LinkDTO = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链接信息
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = LinkDTO()
            self.data = temp_model.from_map(m['data'])
        return self


class QuerySofamqTopicnameRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        num: int = None,
        topic: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例ID
        self.instance_id = instance_id
        # 查询数量
        self.num = num
        # 用于模糊搜索的 topic 关键字
        self.topic = topic

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.num is not None:
            result['num'] = self.num
        if self.topic is not None:
            result['topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('num') is not None:
            self.num = m.get('num')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        return self


class QuerySofamqTopicnameResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # topic列表
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QuerySofamqGroupnameRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        num: int = None,
        group_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # 查询最大数量
        self.num = num
        # 用于模糊搜索的 groupId 关键字
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.num is not None:
            result['num'] = self.num
        if self.group_id is not None:
            result['group_id'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('num') is not None:
            self.num = m.get('num')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        return self


class QuerySofamqGroupnameResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # group列表
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateSofamqAdmintopicRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        instance_id: str = None,
        message_type: int = None,
        remark: str = None,
        scope: str = None,
        topic: str = None,
        perm: str = None,
        owner: str = None,
        priority: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群名
        self.cluster = cluster
        # 需创建的 Topic 所对应的实例 ID
        self.instance_id = instance_id
        # 消息类型。取值说明如下：0：普通消息；1：分区顺序消息；2：全局顺序消息；4：事务消息；5：定时/延时消息。
        self.message_type = message_type
        # Topic 的备注信息
        self.remark = remark
        # 生效范围，为三板斧使用
        self.scope = scope
        # 需创建的 Topic 的名称
        self.topic = topic
        # Topic 权限，6为可读可写，4为可读
        self.perm = perm
        # Topic 所属的应用名称，要求 app name 在 appinfo 上可查
        self.owner = owner
        # 标识该 topic 的消息是否具有优先级
        self.priority = priority

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.message_type, 'message_type')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.message_type is not None:
            result['message_type'] = self.message_type
        if self.remark is not None:
            result['remark'] = self.remark
        if self.scope is not None:
            result['scope'] = self.scope
        if self.topic is not None:
            result['topic'] = self.topic
        if self.perm is not None:
            result['perm'] = self.perm
        if self.owner is not None:
            result['owner'] = self.owner
        if self.priority is not None:
            result['priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('message_type') is not None:
            self.message_type = m.get('message_type')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('topic') is not None:
            self.topic = m.get('topic')
        if m.get('perm') is not None:
            self.perm = m.get('perm')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        return self


class CreateSofamqAdmintopicResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateSofamqAdmingroupRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster: str = None,
        group_id: str = None,
        group_type: str = None,
        instance_id: str = None,
        remark: str = None,
        scope: str = None,
        owner: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群名
        self.cluster = cluster
        # Group ID
        self.group_id = group_id
        # group协议类型
        self.group_type = group_type
        # 实例ID
        self.instance_id = instance_id
        # Group ID 描述信息
        self.remark = remark
        # 生效范围，三板斧使用
        self.scope = scope
        # Group 所属的应用名称，要求 app name 在 zappinfo 上可查
        self.owner = owner

    def validate(self):
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster is not None:
            result['cluster'] = self.cluster
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.group_type is not None:
            result['group_type'] = self.group_type
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.remark is not None:
            result['remark'] = self.remark
        if self.scope is not None:
            result['scope'] = self.scope
        if self.owner is not None:
            result['owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster') is not None:
            self.cluster = m.get('cluster')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('group_type') is not None:
            self.group_type = m.get('group_type')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('owner') is not None:
            self.owner = m.get('owner')
        return self


class CreateSofamqAdmingroupResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务名称
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class QuerySofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConnectorJob = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 连接器任务实体
        self.data = data
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.data:
            self.data.validate()
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConnectorJob()
            self.data = temp_model.from_map(m['data'])
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class CreateSofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cron: str = None,
        filter: str = None,
        instance_id: str = None,
        name: str = None,
        rate: int = None,
        remark: str = None,
        sink_configs: str = None,
        sink_type: str = None,
        source_configs: str = None,
        source_type: str = None,
        time: int = None,
        transformation: str = None,
        type: str = None,
        app: str = None,
        stepflow_template_id: str = None,
        event_sub_configs: str = None,
        event_sub_enabled: bool = None,
        acceptable_execution_interval: int = None,
        auto_recycle_instance: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cron表达式描述任务触发，如果类型是cron的话
        self.cron = cron
        # 数据过滤，支持SQL92过滤
        self.filter = filter
        # 实例编号
        self.instance_id = instance_id
        # 任务名称
        self.name = name
        # 限流值
        self.rate = rate
        # 描述任务
        self.remark = remark
        # 去向信息的配置, kv结构的数组 的 JSON String
        self.sink_configs = sink_configs
        # 去向类型
        self.sink_type = sink_type
        # 来源的配置项列表， kv结构数组 的 JSON String
        self.source_configs = source_configs
        # 来源类型
        self.source_type = source_type
        # 如果类型是once的话，给定一个unix时间戳
        self.time = time
        # 数据转化配置。数据转化配置的数组 的JSON String
        self.transformation = transformation
        # 任务调度类型
        self.type = type
        # 任务所有者，一般是app维度
        self.app = app
        # stepflow平台上的某个 模板编号
        self.stepflow_template_id = stepflow_template_id
        # 时间订阅的配置，json格式
        self.event_sub_configs = event_sub_configs
        # 事件订阅是否开启
        self.event_sub_enabled = event_sub_enabled
        # 预期完成时间(s)
        self.acceptable_execution_interval = acceptable_execution_interval
        # 是否自动回收实例
        self.auto_recycle_instance = auto_recycle_instance

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        if self.rate is not None:
            self.validate_minimum(self.rate, 'rate', 0)
        self.validate_required(self.sink_configs, 'sink_configs')
        self.validate_required(self.sink_type, 'sink_type')
        self.validate_required(self.source_configs, 'source_configs')
        self.validate_required(self.source_type, 'source_type')
        self.validate_required(self.type, 'type')
        self.validate_required(self.app, 'app')
        self.validate_required(self.event_sub_enabled, 'event_sub_enabled')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cron is not None:
            result['cron'] = self.cron
        if self.filter is not None:
            result['filter'] = self.filter
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.rate is not None:
            result['rate'] = self.rate
        if self.remark is not None:
            result['remark'] = self.remark
        if self.sink_configs is not None:
            result['sink_configs'] = self.sink_configs
        if self.sink_type is not None:
            result['sink_type'] = self.sink_type
        if self.source_configs is not None:
            result['source_configs'] = self.source_configs
        if self.source_type is not None:
            result['source_type'] = self.source_type
        if self.time is not None:
            result['time'] = self.time
        if self.transformation is not None:
            result['transformation'] = self.transformation
        if self.type is not None:
            result['type'] = self.type
        if self.app is not None:
            result['app'] = self.app
        if self.stepflow_template_id is not None:
            result['stepflow_template_id'] = self.stepflow_template_id
        if self.event_sub_configs is not None:
            result['event_sub_configs'] = self.event_sub_configs
        if self.event_sub_enabled is not None:
            result['event_sub_enabled'] = self.event_sub_enabled
        if self.acceptable_execution_interval is not None:
            result['acceptable_execution_interval'] = self.acceptable_execution_interval
        if self.auto_recycle_instance is not None:
            result['auto_recycle_instance'] = self.auto_recycle_instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('filter') is not None:
            self.filter = m.get('filter')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('sink_configs') is not None:
            self.sink_configs = m.get('sink_configs')
        if m.get('sink_type') is not None:
            self.sink_type = m.get('sink_type')
        if m.get('source_configs') is not None:
            self.source_configs = m.get('source_configs')
        if m.get('source_type') is not None:
            self.source_type = m.get('source_type')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('transformation') is not None:
            self.transformation = m.get('transformation')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('stepflow_template_id') is not None:
            self.stepflow_template_id = m.get('stepflow_template_id')
        if m.get('event_sub_configs') is not None:
            self.event_sub_configs = m.get('event_sub_configs')
        if m.get('event_sub_enabled') is not None:
            self.event_sub_enabled = m.get('event_sub_enabled')
        if m.get('acceptable_execution_interval') is not None:
            self.acceptable_execution_interval = m.get('acceptable_execution_interval')
        if m.get('auto_recycle_instance') is not None:
            self.auto_recycle_instance = m.get('auto_recycle_instance')
        return self


class CreateSofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class ListSofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        query: ConnectorJobQuery = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 页码
        self.page_num = page_num
        # 每页大小
        self.page_size = page_size
        # 任务查询条件
        self.query = query
        # 租户实例编号
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        if self.query:
            self.query.validate()
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.query is not None:
            result['query'] = self.query.to_map()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('query') is not None:
            temp_model = ConnectorJobQuery()
            self.query = temp_model.from_map(m['query'])
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ConnectorJobPageResult = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 连接器分页查询结果
        self.data = data
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.data:
            self.data.validate()
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ConnectorJobPageResult()
            self.data = temp_model.from_map(m['data'])
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class DeleteSofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务名称
        self.name = name
        # 租户实例编号
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class EnableSofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务名称
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class EnableSofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        name: str = None,
        instance_id: str = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务名称
        self.name = name
        # 租户实例编号
        self.instance_id = instance_id
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.name is not None:
            result['name'] = self.name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class DisableSofamqConnectorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务名称
        self.name = name
        # 租户实例
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DisableSofamqConnectorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class ListSofamqConnectorscheuletypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class ListSofamqConnectorscheuletypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务的调度类型 列表
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ListSofamqConnectorsourcetypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class ListSofamqConnectorsourcetypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 所有支持的来源类型
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ListSofamqConnectorsinktypeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        return self


class ListSofamqConnectorsinktypeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 所有支持的去向类型
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class LoadSofamqConnectorconfigsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        type: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 数据源的类型，代表是来源还是去向，只有两种，对应的值是source 和 sink
        self.type = type
        # 具体的来源或者去向的类型
        self.value = value

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class LoadSofamqConnectorconfigsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[UIControlModel] = None,
        error_report: ErrorReport = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 连接器来源或者去向的 配置详情
        self.data = data
        # 错误报告
        self.error_report = error_report

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        if self.error_report:
            self.error_report.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.error_report is not None:
            result['error_report'] = self.error_report.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = UIControlModel()
                self.data.append(temp_model.from_map(k))
        if m.get('error_report') is not None:
            temp_model = ErrorReport()
            self.error_report = temp_model.from_map(m['error_report'])
        return self


class QuerySofamqConnectordateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 任务名称
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_