# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PackagingGroupArgs', 'PackagingGroup']

@pulumi.input_type
class PackagingGroupArgs:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input['PackagingGroupAuthorizationArgs']] = None,
                 egress_access_logs: Optional[pulumi.Input['PackagingGroupLogConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['PackagingGroupTagArgs']]]] = None):
        """
        The set of arguments for constructing a PackagingGroup resource.
        :param pulumi.Input['PackagingGroupAuthorizationArgs'] authorization: CDN Authorization
        :param pulumi.Input['PackagingGroupLogConfigurationArgs'] egress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input[Sequence[pulumi.Input['PackagingGroupTagArgs']]] tags: A collection of tags associated with a resource
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if egress_access_logs is not None:
            pulumi.set(__self__, "egress_access_logs", egress_access_logs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['PackagingGroupAuthorizationArgs']]:
        """
        CDN Authorization
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['PackagingGroupAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="egressAccessLogs")
    def egress_access_logs(self) -> Optional[pulumi.Input['PackagingGroupLogConfigurationArgs']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "egress_access_logs")

    @egress_access_logs.setter
    def egress_access_logs(self, value: Optional[pulumi.Input['PackagingGroupLogConfigurationArgs']]):
        pulumi.set(self, "egress_access_logs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PackagingGroupTagArgs']]]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PackagingGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)


class PackagingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['PackagingGroupAuthorizationArgs']]] = None,
                 egress_access_logs: Optional[pulumi.Input[pulumi.InputType['PackagingGroupLogConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PackagingGroupTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaPackage::PackagingGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['PackagingGroupAuthorizationArgs']] authorization: CDN Authorization
        :param pulumi.Input[pulumi.InputType['PackagingGroupLogConfigurationArgs']] egress_access_logs: The configuration parameters for egress access logging.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PackagingGroupTagArgs']]]] tags: A collection of tags associated with a resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PackagingGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaPackage::PackagingGroup

        :param str resource_name: The name of the resource.
        :param PackagingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PackagingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['PackagingGroupAuthorizationArgs']]] = None,
                 egress_access_logs: Optional[pulumi.Input[pulumi.InputType['PackagingGroupLogConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PackagingGroupTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PackagingGroupArgs.__new__(PackagingGroupArgs)

            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["egress_access_logs"] = egress_access_logs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_name"] = None
        super(PackagingGroup, __self__).__init__(
            'aws-native:mediapackage:PackagingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PackagingGroup':
        """
        Get an existing PackagingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PackagingGroupArgs.__new__(PackagingGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["authorization"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["egress_access_logs"] = None
        __props__.__dict__["tags"] = None
        return PackagingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the PackagingGroup.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional['outputs.PackagingGroupAuthorization']]:
        """
        CDN Authorization
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name for Assets in the PackagingGroup.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="egressAccessLogs")
    def egress_access_logs(self) -> pulumi.Output[Optional['outputs.PackagingGroupLogConfiguration']]:
        """
        The configuration parameters for egress access logging.
        """
        return pulumi.get(self, "egress_access_logs")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.PackagingGroupTag']]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

