# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetInferenceSchedulerResult',
    'AwaitableGetInferenceSchedulerResult',
    'get_inference_scheduler',
    'get_inference_scheduler_output',
]

@pulumi.output_type
class GetInferenceSchedulerResult:
    def __init__(__self__, data_delay_offset_in_minutes=None, data_input_configuration=None, data_output_configuration=None, data_upload_frequency=None, inference_scheduler_arn=None, role_arn=None, tags=None):
        if data_delay_offset_in_minutes and not isinstance(data_delay_offset_in_minutes, int):
            raise TypeError("Expected argument 'data_delay_offset_in_minutes' to be a int")
        pulumi.set(__self__, "data_delay_offset_in_minutes", data_delay_offset_in_minutes)
        if data_input_configuration and not isinstance(data_input_configuration, dict):
            raise TypeError("Expected argument 'data_input_configuration' to be a dict")
        pulumi.set(__self__, "data_input_configuration", data_input_configuration)
        if data_output_configuration and not isinstance(data_output_configuration, dict):
            raise TypeError("Expected argument 'data_output_configuration' to be a dict")
        pulumi.set(__self__, "data_output_configuration", data_output_configuration)
        if data_upload_frequency and not isinstance(data_upload_frequency, str):
            raise TypeError("Expected argument 'data_upload_frequency' to be a str")
        pulumi.set(__self__, "data_upload_frequency", data_upload_frequency)
        if inference_scheduler_arn and not isinstance(inference_scheduler_arn, str):
            raise TypeError("Expected argument 'inference_scheduler_arn' to be a str")
        pulumi.set(__self__, "inference_scheduler_arn", inference_scheduler_arn)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataDelayOffsetInMinutes")
    def data_delay_offset_in_minutes(self) -> Optional[int]:
        """
        A period of time (in minutes) by which inference on the data is delayed after the data starts.
        """
        return pulumi.get(self, "data_delay_offset_in_minutes")

    @property
    @pulumi.getter(name="dataInputConfiguration")
    def data_input_configuration(self) -> Optional['outputs.DataInputConfigurationProperties']:
        """
        Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        """
        return pulumi.get(self, "data_input_configuration")

    @property
    @pulumi.getter(name="dataOutputConfiguration")
    def data_output_configuration(self) -> Optional['outputs.DataOutputConfigurationProperties']:
        """
        Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        """
        return pulumi.get(self, "data_output_configuration")

    @property
    @pulumi.getter(name="dataUploadFrequency")
    def data_upload_frequency(self) -> Optional['InferenceSchedulerDataUploadFrequency']:
        """
        How often data is uploaded to the source S3 bucket for the input data.
        """
        return pulumi.get(self, "data_upload_frequency")

    @property
    @pulumi.getter(name="inferenceSchedulerArn")
    def inference_scheduler_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the inference scheduler being created.
        """
        return pulumi.get(self, "inference_scheduler_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.InferenceSchedulerTag']]:
        """
        Any tags associated with the inference scheduler.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInferenceSchedulerResult(GetInferenceSchedulerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInferenceSchedulerResult(
            data_delay_offset_in_minutes=self.data_delay_offset_in_minutes,
            data_input_configuration=self.data_input_configuration,
            data_output_configuration=self.data_output_configuration,
            data_upload_frequency=self.data_upload_frequency,
            inference_scheduler_arn=self.inference_scheduler_arn,
            role_arn=self.role_arn,
            tags=self.tags)


def get_inference_scheduler(inference_scheduler_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInferenceSchedulerResult:
    """
    Resource schema for LookoutEquipment InferenceScheduler.


    :param str inference_scheduler_name: The name of the inference scheduler being created.
    """
    __args__ = dict()
    __args__['inferenceSchedulerName'] = inference_scheduler_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:lookoutequipment:getInferenceScheduler', __args__, opts=opts, typ=GetInferenceSchedulerResult).value

    return AwaitableGetInferenceSchedulerResult(
        data_delay_offset_in_minutes=__ret__.data_delay_offset_in_minutes,
        data_input_configuration=__ret__.data_input_configuration,
        data_output_configuration=__ret__.data_output_configuration,
        data_upload_frequency=__ret__.data_upload_frequency,
        inference_scheduler_arn=__ret__.inference_scheduler_arn,
        role_arn=__ret__.role_arn,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_inference_scheduler)
def get_inference_scheduler_output(inference_scheduler_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInferenceSchedulerResult]:
    """
    Resource schema for LookoutEquipment InferenceScheduler.


    :param str inference_scheduler_name: The name of the inference scheduler being created.
    """
    ...
