# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = ['RouteCalculatorArgs', 'RouteCalculator']

@pulumi.input_type
class RouteCalculatorArgs:
    def __init__(__self__, *,
                 calculator_name: pulumi.Input[str],
                 data_source: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None):
        """
        The set of arguments for constructing a RouteCalculator resource.
        """
        pulumi.set(__self__, "calculator_name", calculator_name)
        pulumi.set(__self__, "data_source", data_source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)

    @property
    @pulumi.getter(name="calculatorName")
    def calculator_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "calculator_name")

    @calculator_name.setter
    def calculator_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "calculator_name", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[str]:
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input['RouteCalculatorPricingPlan']]:
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input['RouteCalculatorPricingPlan']]):
        pulumi.set(self, "pricing_plan", value)


class RouteCalculator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculator_name: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None,
                 __props__=None):
        """
        Definition of AWS::Location::RouteCalculator Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteCalculatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Location::RouteCalculator Resource Type

        :param str resource_name: The name of the resource.
        :param RouteCalculatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteCalculatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculator_name: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteCalculatorArgs.__new__(RouteCalculatorArgs)

            if calculator_name is None and not opts.urn:
                raise TypeError("Missing required property 'calculator_name'")
            __props__.__dict__["calculator_name"] = calculator_name
            if data_source is None and not opts.urn:
                raise TypeError("Missing required property 'data_source'")
            __props__.__dict__["data_source"] = data_source
            __props__.__dict__["description"] = description
            __props__.__dict__["pricing_plan"] = pricing_plan
            __props__.__dict__["arn"] = None
            __props__.__dict__["calculator_arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(RouteCalculator, __self__).__init__(
            'aws-native:location:RouteCalculator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RouteCalculator':
        """
        Get an existing RouteCalculator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RouteCalculatorArgs.__new__(RouteCalculatorArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["calculator_arn"] = None
        __props__.__dict__["calculator_name"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["data_source"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["pricing_plan"] = None
        __props__.__dict__["update_time"] = None
        return RouteCalculator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="calculatorArn")
    def calculator_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "calculator_arn")

    @property
    @pulumi.getter(name="calculatorName")
    def calculator_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "calculator_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[str]:
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> pulumi.Output[Optional['RouteCalculatorPricingPlan']]:
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "update_time")

