# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetDestinationResult',
    'AwaitableGetDestinationResult',
    'get_destination',
    'get_destination_output',
]

@pulumi.output_type
class GetDestinationResult:
    def __init__(__self__, arn=None, description=None, expression=None, expression_type=None, role_arn=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if expression_type and not isinstance(expression_type, str):
            raise TypeError("Expected argument 'expression_type' to be a str")
        pulumi.set(__self__, "expression_type", expression_type)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Destination arn. Returned after successful create.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Destination description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Destination expression
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="expressionType")
    def expression_type(self) -> Optional['DestinationExpressionType']:
        """
        Must be RuleName
        """
        return pulumi.get(self, "expression_type")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        AWS role ARN that grants access
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DestinationTag']]:
        """
        A list of key-value pairs that contain metadata for the destination.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDestinationResult(GetDestinationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDestinationResult(
            arn=self.arn,
            description=self.description,
            expression=self.expression,
            expression_type=self.expression_type,
            role_arn=self.role_arn,
            tags=self.tags)


def get_destination(name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDestinationResult:
    """
    Destination's resource schema demonstrating some basic constructs and validation rules.


    :param str name: Unique name of destination
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:iotwireless:getDestination', __args__, opts=opts, typ=GetDestinationResult).value

    return AwaitableGetDestinationResult(
        arn=__ret__.arn,
        description=__ret__.description,
        expression=__ret__.expression,
        expression_type=__ret__.expression_type,
        role_arn=__ret__.role_arn,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_destination)
def get_destination_output(name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDestinationResult]:
    """
    Destination's resource schema demonstrating some basic constructs and validation rules.


    :param str name: Unique name of destination
    """
    ...
