# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAlarmModelResult',
    'AwaitableGetAlarmModelResult',
    'get_alarm_model',
    'get_alarm_model_output',
]

@pulumi.output_type
class GetAlarmModelResult:
    def __init__(__self__, alarm_capabilities=None, alarm_event_actions=None, alarm_model_description=None, alarm_rule=None, role_arn=None, severity=None, tags=None):
        if alarm_capabilities and not isinstance(alarm_capabilities, dict):
            raise TypeError("Expected argument 'alarm_capabilities' to be a dict")
        pulumi.set(__self__, "alarm_capabilities", alarm_capabilities)
        if alarm_event_actions and not isinstance(alarm_event_actions, dict):
            raise TypeError("Expected argument 'alarm_event_actions' to be a dict")
        pulumi.set(__self__, "alarm_event_actions", alarm_event_actions)
        if alarm_model_description and not isinstance(alarm_model_description, str):
            raise TypeError("Expected argument 'alarm_model_description' to be a str")
        pulumi.set(__self__, "alarm_model_description", alarm_model_description)
        if alarm_rule and not isinstance(alarm_rule, dict):
            raise TypeError("Expected argument 'alarm_rule' to be a dict")
        pulumi.set(__self__, "alarm_rule", alarm_rule)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if severity and not isinstance(severity, int):
            raise TypeError("Expected argument 'severity' to be a int")
        pulumi.set(__self__, "severity", severity)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="alarmCapabilities")
    def alarm_capabilities(self) -> Optional['outputs.AlarmModelAlarmCapabilities']:
        return pulumi.get(self, "alarm_capabilities")

    @property
    @pulumi.getter(name="alarmEventActions")
    def alarm_event_actions(self) -> Optional['outputs.AlarmModelAlarmEventActions']:
        return pulumi.get(self, "alarm_event_actions")

    @property
    @pulumi.getter(name="alarmModelDescription")
    def alarm_model_description(self) -> Optional[str]:
        """
        A brief description of the alarm model.
        """
        return pulumi.get(self, "alarm_model_description")

    @property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> Optional['outputs.AlarmModelAlarmRule']:
        return pulumi.get(self, "alarm_rule")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the role that grants permission to AWS IoT Events to perform its operations.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def severity(self) -> Optional[int]:
        """
        A non-negative integer that reflects the severity level of the alarm.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AlarmModelTag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")


class AwaitableGetAlarmModelResult(GetAlarmModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmModelResult(
            alarm_capabilities=self.alarm_capabilities,
            alarm_event_actions=self.alarm_event_actions,
            alarm_model_description=self.alarm_model_description,
            alarm_rule=self.alarm_rule,
            role_arn=self.role_arn,
            severity=self.severity,
            tags=self.tags)


def get_alarm_model(alarm_model_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmModelResult:
    """
    The AWS::IoTEvents::AlarmModel resource creates a alarm model. AWS IoT Events alarms help you monitor your data for changes. The data can be metrics that you measure for your equipment and processes. You can create alarms that send notifications when a threshold is breached. Alarms help you detect issues, streamline maintenance, and optimize performance of your equipment and processes.

    Alarms are instances of alarm models. The alarm model specifies what to detect, when to send notifications, who gets notified, and more. You can also specify one or more supported actions that occur when the alarm state changes. AWS IoT Events routes input attributes derived from your data to the appropriate alarms. If the data that you're monitoring is outside the specified range, the alarm is invoked. You can also acknowledge the alarms or set them to the snooze mode.


    :param str alarm_model_name: The name of the alarm model.
    """
    __args__ = dict()
    __args__['alarmModelName'] = alarm_model_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:iotevents:getAlarmModel', __args__, opts=opts, typ=GetAlarmModelResult).value

    return AwaitableGetAlarmModelResult(
        alarm_capabilities=__ret__.alarm_capabilities,
        alarm_event_actions=__ret__.alarm_event_actions,
        alarm_model_description=__ret__.alarm_model_description,
        alarm_rule=__ret__.alarm_rule,
        role_arn=__ret__.role_arn,
        severity=__ret__.severity,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_alarm_model)
def get_alarm_model_output(alarm_model_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmModelResult]:
    """
    The AWS::IoTEvents::AlarmModel resource creates a alarm model. AWS IoT Events alarms help you monitor your data for changes. The data can be metrics that you measure for your equipment and processes. You can create alarms that send notifications when a threshold is breached. Alarms help you detect issues, streamline maintenance, and optimize performance of your equipment and processes.

    Alarms are instances of alarm models. The alarm model specifies what to detect, when to send notifications, who gets notified, and more. You can also specify one or more supported actions that occur when the alarm state changes. AWS IoT Events routes input attributes derived from your data to the appropriate alarms. If the data that you're monitoring is outside the specified range, the alarm is invoked. You can also acknowledge the alarms or set them to the snooze mode.


    :param str alarm_model_name: The name of the alarm model.
    """
    ...
