# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssessmentAWSAccount',
    'AssessmentAWSService',
    'AssessmentDelegation',
    'AssessmentReportsDestination',
    'AssessmentRole',
    'AssessmentScope',
    'AssessmentTag',
]

@pulumi.output_type
class AssessmentAWSAccount(dict):
    """
    The AWS account associated with the assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentAWSAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentAWSAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentAWSAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The AWS account associated with the assessment.
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[str]:
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class AssessmentAWSService(dict):
    """
    An AWS service such as Amazon S3, AWS CloudTrail, and so on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentAWSService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentAWSService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentAWSService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[str] = None):
        """
        An AWS service such as Amazon S3, AWS CloudTrail, and so on.
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        return pulumi.get(self, "service_name")


@pulumi.output_type
class AssessmentDelegation(dict):
    """
    The assignment of a control set to a delegate for review.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentId":
            suggest = "assessment_id"
        elif key == "assessmentName":
            suggest = "assessment_name"
        elif key == "controlSetId":
            suggest = "control_set_id"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentDelegation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentDelegation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentDelegation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_id: Optional[str] = None,
                 assessment_name: Optional[str] = None,
                 comment: Optional[str] = None,
                 control_set_id: Optional[str] = None,
                 created_by: Optional[str] = None,
                 creation_time: Optional[float] = None,
                 id: Optional[str] = None,
                 last_updated: Optional[float] = None,
                 role_arn: Optional[str] = None,
                 role_type: Optional['AssessmentRoleType'] = None,
                 status: Optional['AssessmentDelegationStatus'] = None):
        """
        The assignment of a control set to a delegate for review.
        """
        if assessment_id is not None:
            pulumi.set(__self__, "assessment_id", assessment_id)
        if assessment_name is not None:
            pulumi.set(__self__, "assessment_name", assessment_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if control_set_id is not None:
            pulumi.set(__self__, "control_set_id", control_set_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[str]:
        return pulumi.get(self, "assessment_id")

    @property
    @pulumi.getter(name="assessmentName")
    def assessment_name(self) -> Optional[str]:
        return pulumi.get(self, "assessment_name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> Optional[str]:
        return pulumi.get(self, "control_set_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[float]:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[float]:
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional['AssessmentRoleType']:
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['AssessmentDelegationStatus']:
        return pulumi.get(self, "status")


@pulumi.output_type
class AssessmentReportsDestination(dict):
    """
    The destination in which evidence reports are stored for the specified assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentReportsDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentReportsDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentReportsDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 destination_type: Optional['AssessmentReportDestinationType'] = None):
        """
        The destination in which evidence reports are stored for the specified assessment.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional['AssessmentReportDestinationType']:
        return pulumi.get(self, "destination_type")


@pulumi.output_type
class AssessmentRole(dict):
    """
    The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[str] = None,
                 role_type: Optional['AssessmentRoleType'] = None):
        """
        The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional['AssessmentRoleType']:
        return pulumi.get(self, "role_type")


@pulumi.output_type
class AssessmentScope(dict):
    """
    The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccounts":
            suggest = "aws_accounts"
        elif key == "awsServices":
            suggest = "aws_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_accounts: Optional[Sequence['outputs.AssessmentAWSAccount']] = None,
                 aws_services: Optional[Sequence['outputs.AssessmentAWSService']] = None):
        """
        The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
        :param Sequence['AssessmentAWSAccount'] aws_accounts: The AWS accounts included in scope.
        :param Sequence['AssessmentAWSService'] aws_services: The AWS services included in scope.
        """
        if aws_accounts is not None:
            pulumi.set(__self__, "aws_accounts", aws_accounts)
        if aws_services is not None:
            pulumi.set(__self__, "aws_services", aws_services)

    @property
    @pulumi.getter(name="awsAccounts")
    def aws_accounts(self) -> Optional[Sequence['outputs.AssessmentAWSAccount']]:
        """
        The AWS accounts included in scope.
        """
        return pulumi.get(self, "aws_accounts")

    @property
    @pulumi.getter(name="awsServices")
    def aws_services(self) -> Optional[Sequence['outputs.AssessmentAWSService']]:
        """
        The AWS services included in scope.
        """
        return pulumi.get(self, "aws_services")


@pulumi.output_type
class AssessmentTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 127 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 1 to 255 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


