# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['performance_analysis']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.23.1,<2.0.0', 'pandas>=1.4.3,<2.0.0', 'plotly>=5.9.0,<6.0.0']

extras_require = \
{':python_version >= "3.8" and python_version < "3.11"': ['scipy>=1.8.1,<2.0.0']}

setup_kwargs = {
    'name': 'performance-analysis',
    'version': '0.1.6',
    'description': 'Performance indicators calculation and Time series visualization',
    'long_description': 'performance-analysis\n====================\n\n\nFeatures\n--------\n\n* Performance indicators calculation\n* Supports single time series data and multiple time series data with different time spans\n* Time series visualization\n\n\nInstallation\n------------\n\nYou can install "performance-analysis" via \'pip\'_ from \'PyPI\'_::\n\n    $ pip install performance-analysis\n\n\nUsage\n-----\n\n* Performance part\n\n.. code-block:: python\n\n    from performance_analysis.Performance import Performance\n    # Input return data\n    raw_return_data = pd.read_csv("./raw_return_data.csv")\n    # Just some examples. For more functions, you can explore the package\n    ann_rtn = Performance.annualized_return(raw_return_data, period = Constant.DAILY, logreturn = False)\n    var = Performance.value_at_risk(raw_return_data, significance_level = 0.05)\n    sharpe = Performance.sharpe_ratio(raw_return_data, risk_free = 0., logreturn = False)\n    calmar = Performance.calmar_ratio(raw_return_data, period = Constant.DAILY, logreturn = False)\n\n* Computes personal specified indicators\n\n.. code-block:: python\n\n    \'\'\'\n    indicators = {\n            0 : annualized_return,\n            1 : annualized_sd,\n            2 : max_drawdown,\n            3 : sharpe_ratio,\n            4 : calmar_ratio,\n            5 : burke_ratio,\n            6 : downside_risk,\n            7 : sortino_ratio,\n            8 : tracking_error,\n            9 : information_ratio,\n            10 : capm_beta,\n            11 : capm_alpha,\n            12 : treynor_ratio,\n            13 : skewness,\n            14 : kurtosis,\n            15 : value_at_risk,\n            16 : conditional_value_at_risk,\n            17 : omega_ratio,\n            18 : tail_dependence,\n            19 : TDC,\n        }\n    \'\'\'\n\n    args = (0,1,2,3,4)\n    kwargs = {\n        "annualized_return" : {"returns" : single_return_data},\n        "annualized_sd" : {"returns" : single_return_data},\n        "max_drawdown" : {"returns" : single_return_data},\n        "sharpe_ratio" : {"returns" : single_return_data},\n        "calmar_ratio" : {"returns" : single_return_data}\n    }\n    performance = Performance.performance_dashboard(*args, **kwargs)\n\n* Plotting part\n\n.. code-block:: python\n\n    from performance_analysis.Plotting import Plotting\n    # read data, set index and convert to datatime\n    single_return_data = pd.read_csv("./single_return_data.csv")\n    single_return_data.set_index([\'Date\'],inplace=True)\n    single_return_data.index = pd.to_datetime(single_return_data.index, format=\'%Y%m%d\', errors=\'coerce\')\n\n    Plotting.plot_cum_return_and_drawdown(single_return_data)\n    Plotting.plot_monthly_return_heatmap(single_return_data, show_text = True)\n    Plotting.plot_seasonal_effect(single_return_data)\n\n\nLicense\n-------\n\nDistributed under the terms of the \'MIT\'_ license, "performance-analysis" is free and open source software\n',
    'author': 'DarrenH8848',
    'author_email': 'DarrenH8848@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
