# ------------------------------------------------------------ Imports ----------------------------------------------------------- #

# Pip
from web3 import eth as Eth

# Local
from ...core import PredefinedERC20, PredefinedERC20Constants

# -------------------------------------------------------------------------------------------------------------------------------- #



# ---------------------------------------------------------- class: Weth --------------------------------------------------------- #

class Weth(PredefinedERC20):

    # --------------------------------------------------------- Init --------------------------------------------------------- #

    def __init__(
        self,
        eth: Eth
    ):
        super().__init__(
            eth=eth,
            costants=PredefinedERC20Constants(
                address  = '0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2',
                name     = 'Wrapped Ether',
                symbol   = 'WETH',
                decimals = 18
            )
        )


# -------------------------------------------------------------------------------------------------------------------------------- #