# ------------------------------------------------------------ Imports ----------------------------------------------------------- #

# Pip
from web3 import eth as Eth

# Local
from ...core import PredefinedERC20, PredefinedERC20Constants

# -------------------------------------------------------------------------------------------------------------------------------- #



# ---------------------------------------------------------- class: Dai ---------------------------------------------------------- #

class Dai(PredefinedERC20):

    # --------------------------------------------------------- Init --------------------------------------------------------- #

    def __init__(
        self,
        eth: Eth
    ):
        super().__init__(
            eth=eth,
            costants=PredefinedERC20Constants(
                address  = '0x6b175474e89094c44da98b954eedeac495271d0f',
                name     = 'Dai Stablecoin',
                symbol   = 'DAI',
                decimals = 18
            )
        )


# -------------------------------------------------------------------------------------------------------------------------------- #