"""
BLOSUM data dictionary.
Gathered from https://www.ncbi.nlm.nih.gov/IEB/ToolBox/C_DOC/lxr/source/data/.
"""


default_blosum = {
    45: {
        "A": {
            "A": 5.0,
            "R": -2.0,
            "N": -1.0,
            "D": -2.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": 0.0,
            "H": -2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -2.0,
            "P": -1.0,
            "S": 1.0,
            "T": 0.0,
            "W": -2.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "R": {
            "A": -2.0,
            "R": 7.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -2.0,
            "K": 3.0,
            "M": -1.0,
            "F": -2.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": -2.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "N": {
            "A": -1.0,
            "R": 0.0,
            "N": 6.0,
            "D": 2.0,
            "C": -2.0,
            "Q": 0.0,
            "E": 0.0,
            "G": 0.0,
            "H": 1.0,
            "I": -2.0,
            "L": -3.0,
            "K": 0.0,
            "M": -2.0,
            "F": -2.0,
            "P": -2.0,
            "S": 1.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 5.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "D": {
            "A": -2.0,
            "R": -1.0,
            "N": 2.0,
            "D": 7.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 2.0,
            "G": -1.0,
            "H": 0.0,
            "I": -4.0,
            "L": -3.0,
            "K": 0.0,
            "M": -3.0,
            "F": -4.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 6.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "C": {
            "A": -1.0,
            "R": -3.0,
            "N": -2.0,
            "D": -3.0,
            "C": 12.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -3.0,
            "H": -3.0,
            "I": -3.0,
            "L": -2.0,
            "K": -3.0,
            "M": -2.0,
            "F": -2.0,
            "P": -4.0,
            "S": -1.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -1.0,
            "B": -2.0,
            "J": -2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Q": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": 0.0,
            "C": -3.0,
            "Q": 6.0,
            "E": 2.0,
            "G": -2.0,
            "H": 1.0,
            "I": -2.0,
            "L": -2.0,
            "K": 1.0,
            "M": 0.0,
            "F": -4.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": -3.0,
            "B": 0.0,
            "J": -2.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -5.0,
        },
        "E": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 2.0,
            "C": -3.0,
            "Q": 2.0,
            "E": 6.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -2.0,
            "K": 1.0,
            "M": -2.0,
            "F": -3.0,
            "P": 0.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 1.0,
            "J": -3.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -5.0,
        },
        "G": {
            "A": 0.0,
            "R": -2.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": -2.0,
            "E": -2.0,
            "G": 7.0,
            "H": -2.0,
            "I": -4.0,
            "L": -3.0,
            "K": -2.0,
            "M": -2.0,
            "F": -3.0,
            "P": -2.0,
            "S": 0.0,
            "T": -2.0,
            "W": -2.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "H": {
            "A": -2.0,
            "R": 0.0,
            "N": 1.0,
            "D": 0.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -2.0,
            "H": 10.0,
            "I": -3.0,
            "L": -2.0,
            "K": -1.0,
            "M": 0.0,
            "F": -2.0,
            "P": -2.0,
            "S": -1.0,
            "T": -2.0,
            "W": -3.0,
            "Y": 2.0,
            "V": -3.0,
            "B": 0.0,
            "J": -2.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "I": {
            "A": -1.0,
            "R": -3.0,
            "N": -2.0,
            "D": -4.0,
            "C": -3.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 5.0,
            "L": 2.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -2.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": 0.0,
            "V": 3.0,
            "B": -3.0,
            "J": 4.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "L": {
            "A": -1.0,
            "R": -2.0,
            "N": -3.0,
            "D": -3.0,
            "C": -2.0,
            "Q": -2.0,
            "E": -2.0,
            "G": -3.0,
            "H": -2.0,
            "I": 2.0,
            "L": 5.0,
            "K": -3.0,
            "M": 2.0,
            "F": 1.0,
            "P": -3.0,
            "S": -3.0,
            "T": -1.0,
            "W": -2.0,
            "Y": 0.0,
            "V": 1.0,
            "B": -3.0,
            "J": 4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "K": {
            "A": -1.0,
            "R": 3.0,
            "N": 0.0,
            "D": 0.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -1.0,
            "I": -3.0,
            "L": -3.0,
            "K": 5.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "M": {
            "A": -1.0,
            "R": -1.0,
            "N": -2.0,
            "D": -3.0,
            "C": -2.0,
            "Q": 0.0,
            "E": -2.0,
            "G": -2.0,
            "H": 0.0,
            "I": 2.0,
            "L": 2.0,
            "K": -1.0,
            "M": 6.0,
            "F": 0.0,
            "P": -2.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": 0.0,
            "V": 1.0,
            "B": -2.0,
            "J": 2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "F": {
            "A": -2.0,
            "R": -2.0,
            "N": -2.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -4.0,
            "E": -3.0,
            "G": -3.0,
            "H": -2.0,
            "I": 0.0,
            "L": 1.0,
            "K": -3.0,
            "M": 0.0,
            "F": 8.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": 1.0,
            "Y": 3.0,
            "V": 0.0,
            "B": -3.0,
            "J": 1.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "P": {
            "A": -1.0,
            "R": -2.0,
            "N": -2.0,
            "D": -1.0,
            "C": -4.0,
            "Q": -1.0,
            "E": 0.0,
            "G": -2.0,
            "H": -2.0,
            "I": -2.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -3.0,
            "P": 9.0,
            "S": -1.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -2.0,
            "J": -3.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "S": {
            "A": 1.0,
            "R": -1.0,
            "N": 1.0,
            "D": 0.0,
            "C": -1.0,
            "Q": 0.0,
            "E": 0.0,
            "G": 0.0,
            "H": -1.0,
            "I": -2.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -2.0,
            "P": -1.0,
            "S": 4.0,
            "T": 2.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -1.0,
            "B": 0.0,
            "J": -2.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "T": {
            "A": 0.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": 2.0,
            "T": 5.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 0.0,
            "B": 0.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "W": {
            "A": -2.0,
            "R": -2.0,
            "N": -4.0,
            "D": -4.0,
            "C": -5.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -2.0,
            "H": -3.0,
            "I": -2.0,
            "L": -2.0,
            "K": -2.0,
            "M": -2.0,
            "F": 1.0,
            "P": -3.0,
            "S": -4.0,
            "T": -3.0,
            "W": 15.0,
            "Y": 3.0,
            "V": -3.0,
            "B": -4.0,
            "J": -2.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Y": {
            "A": -2.0,
            "R": -1.0,
            "N": -2.0,
            "D": -2.0,
            "C": -3.0,
            "Q": -1.0,
            "E": -2.0,
            "G": -3.0,
            "H": 2.0,
            "I": 0.0,
            "L": 0.0,
            "K": -1.0,
            "M": 0.0,
            "F": 3.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": 3.0,
            "Y": 8.0,
            "V": -1.0,
            "B": -2.0,
            "J": 0.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "V": {
            "A": 0.0,
            "R": -2.0,
            "N": -3.0,
            "D": -3.0,
            "C": -1.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -3.0,
            "H": -3.0,
            "I": 3.0,
            "L": 1.0,
            "K": -2.0,
            "M": 1.0,
            "F": 0.0,
            "P": -3.0,
            "S": -1.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 5.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "B": {
            "A": -1.0,
            "R": -1.0,
            "N": 5.0,
            "D": 6.0,
            "C": -2.0,
            "Q": 0.0,
            "E": 1.0,
            "G": -1.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 0.0,
            "M": -2.0,
            "F": -3.0,
            "P": -2.0,
            "S": 0.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 5.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "J": {
            "A": -1.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": -2.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": -2.0,
            "I": 4.0,
            "L": 4.0,
            "K": -3.0,
            "M": 2.0,
            "F": 1.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": 0.0,
            "V": 2.0,
            "B": -3.0,
            "J": 4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Z": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": 1.0,
            "C": -3.0,
            "Q": 4.0,
            "E": 5.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -2.0,
            "K": 1.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 1.0,
            "J": -2.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -5.0,
        },
        "X": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -1.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "*": {
            "A": -5.0,
            "R": -5.0,
            "N": -5.0,
            "D": -5.0,
            "C": -5.0,
            "Q": -5.0,
            "E": -5.0,
            "G": -5.0,
            "H": -5.0,
            "I": -5.0,
            "L": -5.0,
            "K": -5.0,
            "M": -5.0,
            "F": -5.0,
            "P": -5.0,
            "S": -5.0,
            "T": -5.0,
            "W": -5.0,
            "Y": -5.0,
            "V": -5.0,
            "B": -5.0,
            "J": -5.0,
            "Z": -5.0,
            "X": -5.0,
            "*": 1.0,
        },
    },
    50: {
        "A": {
            "A": 5.0,
            "R": -2.0,
            "N": -1.0,
            "D": -2.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": 0.0,
            "H": -2.0,
            "I": -1.0,
            "L": -2.0,
            "K": -1.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": 1.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -2.0,
            "J": -2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "R": {
            "A": -2.0,
            "R": 7.0,
            "N": -1.0,
            "D": -2.0,
            "C": -4.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -3.0,
            "K": 3.0,
            "M": -2.0,
            "F": -3.0,
            "P": -3.0,
            "S": -1.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -1.0,
            "V": -3.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "N": {
            "A": -1.0,
            "R": -1.0,
            "N": 7.0,
            "D": 2.0,
            "C": -2.0,
            "Q": 0.0,
            "E": 0.0,
            "G": 0.0,
            "H": 1.0,
            "I": -3.0,
            "L": -4.0,
            "K": 0.0,
            "M": -2.0,
            "F": -4.0,
            "P": -2.0,
            "S": 1.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 5.0,
            "J": -4.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "D": {
            "A": -2.0,
            "R": -2.0,
            "N": 2.0,
            "D": 8.0,
            "C": -4.0,
            "Q": 0.0,
            "E": 2.0,
            "G": -1.0,
            "H": -1.0,
            "I": -4.0,
            "L": -4.0,
            "K": -1.0,
            "M": -4.0,
            "F": -5.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -4.0,
            "B": 6.0,
            "J": -4.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "C": {
            "A": -1.0,
            "R": -4.0,
            "N": -2.0,
            "D": -4.0,
            "C": 13.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -3.0,
            "H": -3.0,
            "I": -2.0,
            "L": -2.0,
            "K": -3.0,
            "M": -2.0,
            "F": -2.0,
            "P": -4.0,
            "S": -1.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -1.0,
            "B": -3.0,
            "J": -2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Q": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": 0.0,
            "C": -3.0,
            "Q": 7.0,
            "E": 2.0,
            "G": -2.0,
            "H": 1.0,
            "I": -3.0,
            "L": -2.0,
            "K": 2.0,
            "M": 0.0,
            "F": -4.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -3.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -5.0,
        },
        "E": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 2.0,
            "C": -3.0,
            "Q": 2.0,
            "E": 6.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -3.0,
            "K": 1.0,
            "M": -2.0,
            "F": -3.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 1.0,
            "J": -3.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -5.0,
        },
        "G": {
            "A": 0.0,
            "R": -3.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": -2.0,
            "E": -3.0,
            "G": 8.0,
            "H": -2.0,
            "I": -4.0,
            "L": -4.0,
            "K": -2.0,
            "M": -3.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": -2.0,
            "W": -3.0,
            "Y": -3.0,
            "V": -4.0,
            "B": -1.0,
            "J": -4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "H": {
            "A": -2.0,
            "R": 0.0,
            "N": 1.0,
            "D": -1.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -2.0,
            "H": 10.0,
            "I": -4.0,
            "L": -3.0,
            "K": 0.0,
            "M": -1.0,
            "F": -1.0,
            "P": -2.0,
            "S": -1.0,
            "T": -2.0,
            "W": -3.0,
            "Y": 2.0,
            "V": -4.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "I": {
            "A": -1.0,
            "R": -4.0,
            "N": -3.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -4.0,
            "H": -4.0,
            "I": 5.0,
            "L": 2.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -3.0,
            "S": -3.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 4.0,
            "B": -4.0,
            "J": 4.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "L": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 2.0,
            "L": 5.0,
            "K": -3.0,
            "M": 3.0,
            "F": 1.0,
            "P": -4.0,
            "S": -3.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": 1.0,
            "B": -4.0,
            "J": 4.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "K": {
            "A": -1.0,
            "R": 3.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": 2.0,
            "E": 1.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 6.0,
            "M": -2.0,
            "F": -4.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "M": {
            "A": -1.0,
            "R": -2.0,
            "N": -2.0,
            "D": -4.0,
            "C": -2.0,
            "Q": 0.0,
            "E": -2.0,
            "G": -3.0,
            "H": -1.0,
            "I": 2.0,
            "L": 3.0,
            "K": -2.0,
            "M": 7.0,
            "F": 0.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -1.0,
            "Y": 0.0,
            "V": 1.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "F": {
            "A": -3.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -4.0,
            "E": -3.0,
            "G": -4.0,
            "H": -1.0,
            "I": 0.0,
            "L": 1.0,
            "K": -4.0,
            "M": 0.0,
            "F": 8.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": 1.0,
            "Y": 4.0,
            "V": -1.0,
            "B": -4.0,
            "J": 1.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -5.0,
        },
        "P": {
            "A": -1.0,
            "R": -3.0,
            "N": -2.0,
            "D": -1.0,
            "C": -4.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -3.0,
            "L": -4.0,
            "K": -1.0,
            "M": -3.0,
            "F": -4.0,
            "P": 10.0,
            "S": -1.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -2.0,
            "J": -3.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "S": {
            "A": 1.0,
            "R": -1.0,
            "N": 1.0,
            "D": 0.0,
            "C": -1.0,
            "Q": 0.0,
            "E": -1.0,
            "G": 0.0,
            "H": -1.0,
            "I": -3.0,
            "L": -3.0,
            "K": 0.0,
            "M": -2.0,
            "F": -3.0,
            "P": -1.0,
            "S": 5.0,
            "T": 2.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -5.0,
        },
        "T": {
            "A": 0.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -2.0,
            "P": -1.0,
            "S": 2.0,
            "T": 5.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 0.0,
            "B": 0.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "W": {
            "A": -3.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -5.0,
            "Q": -1.0,
            "E": -3.0,
            "G": -3.0,
            "H": -3.0,
            "I": -3.0,
            "L": -2.0,
            "K": -3.0,
            "M": -1.0,
            "F": 1.0,
            "P": -4.0,
            "S": -4.0,
            "T": -3.0,
            "W": 15.0,
            "Y": 2.0,
            "V": -3.0,
            "B": -5.0,
            "J": -2.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Y": {
            "A": -2.0,
            "R": -1.0,
            "N": -2.0,
            "D": -3.0,
            "C": -3.0,
            "Q": -1.0,
            "E": -2.0,
            "G": -3.0,
            "H": 2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -2.0,
            "M": 0.0,
            "F": 4.0,
            "P": -3.0,
            "S": -2.0,
            "T": -2.0,
            "W": 2.0,
            "Y": 8.0,
            "V": -1.0,
            "B": -3.0,
            "J": -1.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -5.0,
        },
        "V": {
            "A": 0.0,
            "R": -3.0,
            "N": -3.0,
            "D": -4.0,
            "C": -1.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -4.0,
            "H": -4.0,
            "I": 4.0,
            "L": 1.0,
            "K": -3.0,
            "M": 1.0,
            "F": -1.0,
            "P": -3.0,
            "S": -2.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 5.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "B": {
            "A": -2.0,
            "R": -1.0,
            "N": 5.0,
            "D": 6.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 1.0,
            "G": -1.0,
            "H": 0.0,
            "I": -4.0,
            "L": -4.0,
            "K": 0.0,
            "M": -3.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": 0.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 6.0,
            "J": -4.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "J": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 4.0,
            "L": 4.0,
            "K": -3.0,
            "M": 2.0,
            "F": 1.0,
            "P": -3.0,
            "S": -3.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": 2.0,
            "B": -4.0,
            "J": 4.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -5.0,
        },
        "Z": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 1.0,
            "C": -3.0,
            "Q": 4.0,
            "E": 5.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 1.0,
            "M": -1.0,
            "F": -4.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 1.0,
            "J": -3.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -5.0,
        },
        "X": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -1.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -5.0,
        },
        "*": {
            "A": -5.0,
            "R": -5.0,
            "N": -5.0,
            "D": -5.0,
            "C": -5.0,
            "Q": -5.0,
            "E": -5.0,
            "G": -5.0,
            "H": -5.0,
            "I": -5.0,
            "L": -5.0,
            "K": -5.0,
            "M": -5.0,
            "F": -5.0,
            "P": -5.0,
            "S": -5.0,
            "T": -5.0,
            "W": -5.0,
            "Y": -5.0,
            "V": -5.0,
            "B": -5.0,
            "J": -5.0,
            "Z": -5.0,
            "X": -5.0,
            "*": 1.0,
        },
    },
    62: {
        "A": {
            "A": 4.0,
            "R": -1.0,
            "N": -2.0,
            "D": -2.0,
            "C": 0.0,
            "Q": -1.0,
            "E": -1.0,
            "G": 0.0,
            "H": -2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -2.0,
            "P": -1.0,
            "S": 1.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -2.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "R": {
            "A": -1.0,
            "R": 5.0,
            "N": 0.0,
            "D": -2.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -2.0,
            "K": 2.0,
            "M": -1.0,
            "F": -3.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -3.0,
            "B": -1.0,
            "J": -2.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -4.0,
        },
        "N": {
            "A": -2.0,
            "R": 0.0,
            "N": 6.0,
            "D": 1.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 0.0,
            "G": 0.0,
            "H": 1.0,
            "I": -3.0,
            "L": -3.0,
            "K": 0.0,
            "M": -2.0,
            "F": -3.0,
            "P": -2.0,
            "S": 1.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 4.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -4.0,
        },
        "D": {
            "A": -2.0,
            "R": -2.0,
            "N": 1.0,
            "D": 6.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 2.0,
            "G": -1.0,
            "H": -1.0,
            "I": -3.0,
            "L": -4.0,
            "K": -1.0,
            "M": -3.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 4.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "C": {
            "A": 0.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": 9.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -3.0,
            "H": -3.0,
            "I": -1.0,
            "L": -1.0,
            "K": -3.0,
            "M": -1.0,
            "F": -2.0,
            "P": -3.0,
            "S": -1.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": -1.0,
            "B": -3.0,
            "J": -1.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -4.0,
        },
        "Q": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": 0.0,
            "C": -3.0,
            "Q": 5.0,
            "E": 2.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -2.0,
            "K": 1.0,
            "M": 0.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": -2.0,
            "B": 0.0,
            "J": -2.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -4.0,
        },
        "E": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 2.0,
            "C": -4.0,
            "Q": 2.0,
            "E": 5.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 1.0,
            "M": -2.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 1.0,
            "J": -3.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -4.0,
        },
        "G": {
            "A": 0.0,
            "R": -2.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": -2.0,
            "E": -2.0,
            "G": 6.0,
            "H": -2.0,
            "I": -4.0,
            "L": -4.0,
            "K": -2.0,
            "M": -3.0,
            "F": -3.0,
            "P": -2.0,
            "S": 0.0,
            "T": -2.0,
            "W": -2.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -4.0,
        },
        "H": {
            "A": -2.0,
            "R": 0.0,
            "N": 1.0,
            "D": -1.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 0.0,
            "G": -2.0,
            "H": 8.0,
            "I": -3.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -1.0,
            "P": -2.0,
            "S": -1.0,
            "T": -2.0,
            "W": -2.0,
            "Y": 2.0,
            "V": -3.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -4.0,
        },
        "I": {
            "A": -1.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": -1.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 4.0,
            "L": 2.0,
            "K": -3.0,
            "M": 1.0,
            "F": 0.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 3.0,
            "B": -3.0,
            "J": 3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -4.0,
        },
        "L": {
            "A": -1.0,
            "R": -2.0,
            "N": -3.0,
            "D": -4.0,
            "C": -1.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 2.0,
            "L": 4.0,
            "K": -2.0,
            "M": 2.0,
            "F": 0.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": 1.0,
            "B": -4.0,
            "J": 3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -4.0,
        },
        "K": {
            "A": -1.0,
            "R": 2.0,
            "N": 0.0,
            "D": -1.0,
            "C": -3.0,
            "Q": 1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -1.0,
            "I": -3.0,
            "L": -2.0,
            "K": 5.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "M": {
            "A": -1.0,
            "R": -1.0,
            "N": -2.0,
            "D": -3.0,
            "C": -1.0,
            "Q": 0.0,
            "E": -2.0,
            "G": -3.0,
            "H": -2.0,
            "I": 1.0,
            "L": 2.0,
            "K": -1.0,
            "M": 5.0,
            "F": 0.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": 1.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "F": {
            "A": -2.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -3.0,
            "H": -1.0,
            "I": 0.0,
            "L": 0.0,
            "K": -3.0,
            "M": 0.0,
            "F": 6.0,
            "P": -4.0,
            "S": -2.0,
            "T": -2.0,
            "W": 1.0,
            "Y": 3.0,
            "V": -1.0,
            "B": -3.0,
            "J": 0.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -4.0,
        },
        "P": {
            "A": -1.0,
            "R": -2.0,
            "N": -2.0,
            "D": -1.0,
            "C": -3.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -3.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -4.0,
            "P": 7.0,
            "S": -1.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -2.0,
            "B": -2.0,
            "J": -3.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "S": {
            "A": 1.0,
            "R": -1.0,
            "N": 1.0,
            "D": 0.0,
            "C": -1.0,
            "Q": 0.0,
            "E": 0.0,
            "G": 0.0,
            "H": -1.0,
            "I": -2.0,
            "L": -2.0,
            "K": 0.0,
            "M": -1.0,
            "F": -2.0,
            "P": -1.0,
            "S": 4.0,
            "T": 1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 0.0,
            "J": -2.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -4.0,
        },
        "T": {
            "A": 0.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -2.0,
            "P": -1.0,
            "S": 1.0,
            "T": 5.0,
            "W": -2.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "W": {
            "A": -3.0,
            "R": -3.0,
            "N": -4.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -2.0,
            "H": -2.0,
            "I": -3.0,
            "L": -2.0,
            "K": -3.0,
            "M": -1.0,
            "F": 1.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": 11.0,
            "Y": 2.0,
            "V": -3.0,
            "B": -4.0,
            "J": -2.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -4.0,
        },
        "Y": {
            "A": -2.0,
            "R": -2.0,
            "N": -2.0,
            "D": -3.0,
            "C": -2.0,
            "Q": -1.0,
            "E": -2.0,
            "G": -3.0,
            "H": 2.0,
            "I": -1.0,
            "L": -1.0,
            "K": -2.0,
            "M": -1.0,
            "F": 3.0,
            "P": -3.0,
            "S": -2.0,
            "T": -2.0,
            "W": 2.0,
            "Y": 7.0,
            "V": -1.0,
            "B": -3.0,
            "J": -1.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -4.0,
        },
        "V": {
            "A": 0.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": -1.0,
            "Q": -2.0,
            "E": -2.0,
            "G": -3.0,
            "H": -3.0,
            "I": 3.0,
            "L": 1.0,
            "K": -2.0,
            "M": 1.0,
            "F": -1.0,
            "P": -2.0,
            "S": -2.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -1.0,
            "V": 4.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -4.0,
        },
        "B": {
            "A": -2.0,
            "R": -1.0,
            "N": 4.0,
            "D": 4.0,
            "C": -3.0,
            "Q": 0.0,
            "E": 1.0,
            "G": -1.0,
            "H": 0.0,
            "I": -3.0,
            "L": -4.0,
            "K": 0.0,
            "M": -3.0,
            "F": -3.0,
            "P": -2.0,
            "S": 0.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 4.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -4.0,
        },
        "J": {
            "A": -1.0,
            "R": -2.0,
            "N": -3.0,
            "D": -3.0,
            "C": -1.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 3.0,
            "L": 3.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -1.0,
            "V": 2.0,
            "B": -3.0,
            "J": 3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -4.0,
        },
        "Z": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 1.0,
            "C": -3.0,
            "Q": 4.0,
            "E": 4.0,
            "G": -2.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 1.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": 0.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -4.0,
        },
        "X": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -1.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -4.0,
        },
        "*": {
            "A": -4.0,
            "R": -4.0,
            "N": -4.0,
            "D": -4.0,
            "C": -4.0,
            "Q": -4.0,
            "E": -4.0,
            "G": -4.0,
            "H": -4.0,
            "I": -4.0,
            "L": -4.0,
            "K": -4.0,
            "M": -4.0,
            "F": -4.0,
            "P": -4.0,
            "S": -4.0,
            "T": -4.0,
            "W": -4.0,
            "Y": -4.0,
            "V": -4.0,
            "B": -4.0,
            "J": -4.0,
            "Z": -4.0,
            "X": -4.0,
            "*": 1.0,
        },
    },
    80: {
        "A": {
            "A": 5.0,
            "R": -2.0,
            "N": -2.0,
            "D": -2.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": 0.0,
            "H": -2.0,
            "I": -2.0,
            "L": -2.0,
            "K": -1.0,
            "M": -1.0,
            "F": -3.0,
            "P": -1.0,
            "S": 1.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -2.0,
            "J": -2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "R": {
            "A": -2.0,
            "R": 6.0,
            "N": -1.0,
            "D": -2.0,
            "C": -4.0,
            "Q": 1.0,
            "E": -1.0,
            "G": -3.0,
            "H": 0.0,
            "I": -3.0,
            "L": -3.0,
            "K": 2.0,
            "M": -2.0,
            "F": -4.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "N": {
            "A": -2.0,
            "R": -1.0,
            "N": 6.0,
            "D": 1.0,
            "C": -3.0,
            "Q": 0.0,
            "E": -1.0,
            "G": -1.0,
            "H": 0.0,
            "I": -4.0,
            "L": -4.0,
            "K": 0.0,
            "M": -3.0,
            "F": -4.0,
            "P": -3.0,
            "S": 0.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -4.0,
            "B": 5.0,
            "J": -4.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "D": {
            "A": -2.0,
            "R": -2.0,
            "N": 1.0,
            "D": 6.0,
            "C": -4.0,
            "Q": -1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -4.0,
            "L": -5.0,
            "K": -1.0,
            "M": -4.0,
            "F": -4.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -6.0,
            "Y": -4.0,
            "V": -4.0,
            "B": 5.0,
            "J": -5.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "C": {
            "A": -1.0,
            "R": -4.0,
            "N": -3.0,
            "D": -4.0,
            "C": 9.0,
            "Q": -4.0,
            "E": -5.0,
            "G": -4.0,
            "H": -4.0,
            "I": -2.0,
            "L": -2.0,
            "K": -4.0,
            "M": -2.0,
            "F": -3.0,
            "P": -4.0,
            "S": -2.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -3.0,
            "V": -1.0,
            "B": -4.0,
            "J": -2.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Q": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -4.0,
            "Q": 6.0,
            "E": 2.0,
            "G": -2.0,
            "H": 1.0,
            "I": -3.0,
            "L": -3.0,
            "K": 1.0,
            "M": 0.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": -3.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "E": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": 1.0,
            "C": -5.0,
            "Q": 2.0,
            "E": 6.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -4.0,
            "K": 1.0,
            "M": -2.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 1.0,
            "J": -4.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "G": {
            "A": 0.0,
            "R": -3.0,
            "N": -1.0,
            "D": -2.0,
            "C": -4.0,
            "Q": -2.0,
            "E": -3.0,
            "G": 6.0,
            "H": -3.0,
            "I": -5.0,
            "L": -4.0,
            "K": -2.0,
            "M": -4.0,
            "F": -4.0,
            "P": -3.0,
            "S": -1.0,
            "T": -2.0,
            "W": -4.0,
            "Y": -4.0,
            "V": -4.0,
            "B": -1.0,
            "J": -5.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "H": {
            "A": -2.0,
            "R": 0.0,
            "N": 0.0,
            "D": -2.0,
            "C": -4.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -3.0,
            "H": 8.0,
            "I": -4.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -2.0,
            "P": -3.0,
            "S": -1.0,
            "T": -2.0,
            "W": -3.0,
            "Y": 2.0,
            "V": -4.0,
            "B": -1.0,
            "J": -4.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "I": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -4.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -5.0,
            "H": -4.0,
            "I": 5.0,
            "L": 1.0,
            "K": -3.0,
            "M": 1.0,
            "F": -1.0,
            "P": -4.0,
            "S": -3.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 3.0,
            "B": -4.0,
            "J": 3.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "L": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -4.0,
            "H": -3.0,
            "I": 1.0,
            "L": 4.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -3.0,
            "S": -3.0,
            "T": -2.0,
            "W": -2.0,
            "Y": -2.0,
            "V": 1.0,
            "B": -4.0,
            "J": 3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "K": {
            "A": -1.0,
            "R": 2.0,
            "N": 0.0,
            "D": -1.0,
            "C": -4.0,
            "Q": 1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -1.0,
            "I": -3.0,
            "L": -3.0,
            "K": 5.0,
            "M": -2.0,
            "F": -4.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "M": {
            "A": -1.0,
            "R": -2.0,
            "N": -3.0,
            "D": -4.0,
            "C": -2.0,
            "Q": 0.0,
            "E": -2.0,
            "G": -4.0,
            "H": -2.0,
            "I": 1.0,
            "L": 2.0,
            "K": -2.0,
            "M": 6.0,
            "F": 0.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": 1.0,
            "B": -3.0,
            "J": 2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "F": {
            "A": -3.0,
            "R": -4.0,
            "N": -4.0,
            "D": -4.0,
            "C": -3.0,
            "Q": -4.0,
            "E": -4.0,
            "G": -4.0,
            "H": -2.0,
            "I": -1.0,
            "L": 0.0,
            "K": -4.0,
            "M": 0.0,
            "F": 6.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": 0.0,
            "Y": 3.0,
            "V": -1.0,
            "B": -4.0,
            "J": 0.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "P": {
            "A": -1.0,
            "R": -2.0,
            "N": -3.0,
            "D": -2.0,
            "C": -4.0,
            "Q": -2.0,
            "E": -2.0,
            "G": -3.0,
            "H": -3.0,
            "I": -4.0,
            "L": -3.0,
            "K": -1.0,
            "M": -3.0,
            "F": -4.0,
            "P": 8.0,
            "S": -1.0,
            "T": -2.0,
            "W": -5.0,
            "Y": -4.0,
            "V": -3.0,
            "B": -2.0,
            "J": -4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -6.0,
        },
        "S": {
            "A": 1.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -2.0,
            "Q": 0.0,
            "E": 0.0,
            "G": -1.0,
            "H": -1.0,
            "I": -3.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -3.0,
            "P": -1.0,
            "S": 5.0,
            "T": 1.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "T": {
            "A": 0.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -1.0,
            "L": -2.0,
            "K": -1.0,
            "M": -1.0,
            "F": -2.0,
            "P": -2.0,
            "S": 1.0,
            "T": 5.0,
            "W": -4.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "W": {
            "A": -3.0,
            "R": -4.0,
            "N": -4.0,
            "D": -6.0,
            "C": -3.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -4.0,
            "H": -3.0,
            "I": -3.0,
            "L": -2.0,
            "K": -4.0,
            "M": -2.0,
            "F": 0.0,
            "P": -5.0,
            "S": -4.0,
            "T": -4.0,
            "W": 11.0,
            "Y": 2.0,
            "V": -3.0,
            "B": -5.0,
            "J": -3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Y": {
            "A": -2.0,
            "R": -3.0,
            "N": -3.0,
            "D": -4.0,
            "C": -3.0,
            "Q": -2.0,
            "E": -3.0,
            "G": -4.0,
            "H": 2.0,
            "I": -2.0,
            "L": -2.0,
            "K": -3.0,
            "M": -2.0,
            "F": 3.0,
            "P": -4.0,
            "S": -2.0,
            "T": -2.0,
            "W": 2.0,
            "Y": 7.0,
            "V": -2.0,
            "B": -3.0,
            "J": -2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "V": {
            "A": 0.0,
            "R": -3.0,
            "N": -4.0,
            "D": -4.0,
            "C": -1.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -4.0,
            "H": -4.0,
            "I": 3.0,
            "L": 1.0,
            "K": -3.0,
            "M": 1.0,
            "F": -1.0,
            "P": -3.0,
            "S": -2.0,
            "T": 0.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 4.0,
            "B": -4.0,
            "J": 2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "B": {
            "A": -2.0,
            "R": -1.0,
            "N": 5.0,
            "D": 5.0,
            "C": -4.0,
            "Q": 0.0,
            "E": 1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -4.0,
            "L": -4.0,
            "K": -1.0,
            "M": -3.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -4.0,
            "B": 5.0,
            "J": -4.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "J": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -5.0,
            "H": -4.0,
            "I": 3.0,
            "L": 3.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -4.0,
            "S": -3.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 2.0,
            "B": -4.0,
            "J": 3.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Z": {
            "A": -1.0,
            "R": 0.0,
            "N": 0.0,
            "D": 1.0,
            "C": -4.0,
            "Q": 4.0,
            "E": 5.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -3.0,
            "K": 1.0,
            "M": -1.0,
            "F": -4.0,
            "P": -2.0,
            "S": 0.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 0.0,
            "J": -3.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "X": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -1.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "*": {
            "A": -6.0,
            "R": -6.0,
            "N": -6.0,
            "D": -6.0,
            "C": -6.0,
            "Q": -6.0,
            "E": -6.0,
            "G": -6.0,
            "H": -6.0,
            "I": -6.0,
            "L": -6.0,
            "K": -6.0,
            "M": -6.0,
            "F": -6.0,
            "P": -6.0,
            "S": -6.0,
            "T": -6.0,
            "W": -6.0,
            "Y": -6.0,
            "V": -6.0,
            "B": -6.0,
            "J": -6.0,
            "Z": -6.0,
            "X": -6.0,
            "*": 1.0,
        },
    },
    90: {
        "A": {
            "A": 5.0,
            "R": -2.0,
            "N": -2.0,
            "D": -3.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": 0.0,
            "H": -2.0,
            "I": -2.0,
            "L": -2.0,
            "K": -1.0,
            "M": -2.0,
            "F": -3.0,
            "P": -1.0,
            "S": 1.0,
            "T": 0.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -1.0,
            "B": -2.0,
            "J": -2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "R": {
            "A": -2.0,
            "R": 6.0,
            "N": -1.0,
            "D": -3.0,
            "C": -5.0,
            "Q": 1.0,
            "E": -1.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -3.0,
            "K": 2.0,
            "M": -2.0,
            "F": -4.0,
            "P": -3.0,
            "S": -1.0,
            "T": -2.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -2.0,
            "J": -3.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "N": {
            "A": -2.0,
            "R": -1.0,
            "N": 7.0,
            "D": 1.0,
            "C": -4.0,
            "Q": 0.0,
            "E": -1.0,
            "G": -1.0,
            "H": 0.0,
            "I": -4.0,
            "L": -4.0,
            "K": 0.0,
            "M": -3.0,
            "F": -4.0,
            "P": -3.0,
            "S": 0.0,
            "T": 0.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -4.0,
            "B": 5.0,
            "J": -4.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "D": {
            "A": -3.0,
            "R": -3.0,
            "N": 1.0,
            "D": 7.0,
            "C": -5.0,
            "Q": -1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -2.0,
            "I": -5.0,
            "L": -5.0,
            "K": -1.0,
            "M": -4.0,
            "F": -5.0,
            "P": -3.0,
            "S": -1.0,
            "T": -2.0,
            "W": -6.0,
            "Y": -4.0,
            "V": -5.0,
            "B": 5.0,
            "J": -5.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "C": {
            "A": -1.0,
            "R": -5.0,
            "N": -4.0,
            "D": -5.0,
            "C": 9.0,
            "Q": -4.0,
            "E": -6.0,
            "G": -4.0,
            "H": -5.0,
            "I": -2.0,
            "L": -2.0,
            "K": -4.0,
            "M": -2.0,
            "F": -3.0,
            "P": -4.0,
            "S": -2.0,
            "T": -2.0,
            "W": -4.0,
            "Y": -4.0,
            "V": -2.0,
            "B": -4.0,
            "J": -2.0,
            "Z": -5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Q": {
            "A": -1.0,
            "R": 1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -4.0,
            "Q": 7.0,
            "E": 2.0,
            "G": -3.0,
            "H": 1.0,
            "I": -4.0,
            "L": -3.0,
            "K": 1.0,
            "M": 0.0,
            "F": -4.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "E": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": 1.0,
            "C": -6.0,
            "Q": 2.0,
            "E": 6.0,
            "G": -3.0,
            "H": -1.0,
            "I": -4.0,
            "L": -4.0,
            "K": 0.0,
            "M": -3.0,
            "F": -5.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -4.0,
            "V": -3.0,
            "B": 1.0,
            "J": -4.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "G": {
            "A": 0.0,
            "R": -3.0,
            "N": -1.0,
            "D": -2.0,
            "C": -4.0,
            "Q": -3.0,
            "E": -3.0,
            "G": 6.0,
            "H": -3.0,
            "I": -5.0,
            "L": -5.0,
            "K": -2.0,
            "M": -4.0,
            "F": -5.0,
            "P": -3.0,
            "S": -1.0,
            "T": -3.0,
            "W": -4.0,
            "Y": -5.0,
            "V": -5.0,
            "B": -2.0,
            "J": -5.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "H": {
            "A": -2.0,
            "R": 0.0,
            "N": 0.0,
            "D": -2.0,
            "C": -5.0,
            "Q": 1.0,
            "E": -1.0,
            "G": -3.0,
            "H": 8.0,
            "I": -4.0,
            "L": -4.0,
            "K": -1.0,
            "M": -3.0,
            "F": -2.0,
            "P": -3.0,
            "S": -2.0,
            "T": -2.0,
            "W": -3.0,
            "Y": 1.0,
            "V": -4.0,
            "B": -1.0,
            "J": -4.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "I": {
            "A": -2.0,
            "R": -4.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -4.0,
            "E": -4.0,
            "G": -5.0,
            "H": -4.0,
            "I": 5.0,
            "L": 1.0,
            "K": -4.0,
            "M": 1.0,
            "F": -1.0,
            "P": -4.0,
            "S": -3.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -2.0,
            "V": 3.0,
            "B": -5.0,
            "J": 3.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "L": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -5.0,
            "H": -4.0,
            "I": 1.0,
            "L": 5.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -5.0,
            "J": 4.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "K": {
            "A": -1.0,
            "R": 2.0,
            "N": 0.0,
            "D": -1.0,
            "C": -4.0,
            "Q": 1.0,
            "E": 0.0,
            "G": -2.0,
            "H": -1.0,
            "I": -4.0,
            "L": -3.0,
            "K": 6.0,
            "M": -2.0,
            "F": -4.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -5.0,
            "Y": -3.0,
            "V": -3.0,
            "B": -1.0,
            "J": -3.0,
            "Z": 1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "M": {
            "A": -2.0,
            "R": -2.0,
            "N": -3.0,
            "D": -4.0,
            "C": -2.0,
            "Q": 0.0,
            "E": -3.0,
            "G": -4.0,
            "H": -3.0,
            "I": 1.0,
            "L": 2.0,
            "K": -2.0,
            "M": 7.0,
            "F": -1.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -2.0,
            "Y": -2.0,
            "V": 0.0,
            "B": -4.0,
            "J": 2.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -6.0,
        },
        "F": {
            "A": -3.0,
            "R": -4.0,
            "N": -4.0,
            "D": -5.0,
            "C": -3.0,
            "Q": -4.0,
            "E": -5.0,
            "G": -5.0,
            "H": -2.0,
            "I": -1.0,
            "L": 0.0,
            "K": -4.0,
            "M": -1.0,
            "F": 7.0,
            "P": -4.0,
            "S": -3.0,
            "T": -3.0,
            "W": 0.0,
            "Y": 3.0,
            "V": -2.0,
            "B": -4.0,
            "J": 0.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "P": {
            "A": -1.0,
            "R": -3.0,
            "N": -3.0,
            "D": -3.0,
            "C": -4.0,
            "Q": -2.0,
            "E": -2.0,
            "G": -3.0,
            "H": -3.0,
            "I": -4.0,
            "L": -4.0,
            "K": -2.0,
            "M": -3.0,
            "F": -4.0,
            "P": 8.0,
            "S": -2.0,
            "T": -2.0,
            "W": -5.0,
            "Y": -4.0,
            "V": -3.0,
            "B": -3.0,
            "J": -4.0,
            "Z": -2.0,
            "X": -1.0,
            "*": -6.0,
        },
        "S": {
            "A": 1.0,
            "R": -1.0,
            "N": 0.0,
            "D": -1.0,
            "C": -2.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -2.0,
            "I": -3.0,
            "L": -3.0,
            "K": -1.0,
            "M": -2.0,
            "F": -3.0,
            "P": -2.0,
            "S": 5.0,
            "T": 1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -2.0,
            "B": 0.0,
            "J": -3.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "T": {
            "A": 0.0,
            "R": -2.0,
            "N": 0.0,
            "D": -2.0,
            "C": -2.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -3.0,
            "H": -2.0,
            "I": -1.0,
            "L": -2.0,
            "K": -1.0,
            "M": -1.0,
            "F": -3.0,
            "P": -2.0,
            "S": 1.0,
            "T": 6.0,
            "W": -4.0,
            "Y": -2.0,
            "V": -1.0,
            "B": -1.0,
            "J": -2.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "W": {
            "A": -4.0,
            "R": -4.0,
            "N": -5.0,
            "D": -6.0,
            "C": -4.0,
            "Q": -3.0,
            "E": -5.0,
            "G": -4.0,
            "H": -3.0,
            "I": -4.0,
            "L": -3.0,
            "K": -5.0,
            "M": -2.0,
            "F": 0.0,
            "P": -5.0,
            "S": -4.0,
            "T": -4.0,
            "W": 11.0,
            "Y": 2.0,
            "V": -3.0,
            "B": -6.0,
            "J": -3.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Y": {
            "A": -3.0,
            "R": -3.0,
            "N": -3.0,
            "D": -4.0,
            "C": -4.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -5.0,
            "H": 1.0,
            "I": -2.0,
            "L": -2.0,
            "K": -3.0,
            "M": -2.0,
            "F": 3.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": 2.0,
            "Y": 8.0,
            "V": -3.0,
            "B": -4.0,
            "J": -2.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "V": {
            "A": -1.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -3.0,
            "G": -5.0,
            "H": -4.0,
            "I": 3.0,
            "L": 0.0,
            "K": -3.0,
            "M": 0.0,
            "F": -2.0,
            "P": -3.0,
            "S": -2.0,
            "T": -1.0,
            "W": -3.0,
            "Y": -3.0,
            "V": 5.0,
            "B": -4.0,
            "J": 1.0,
            "Z": -3.0,
            "X": -1.0,
            "*": -6.0,
        },
        "B": {
            "A": -2.0,
            "R": -2.0,
            "N": 5.0,
            "D": 5.0,
            "C": -4.0,
            "Q": -1.0,
            "E": 1.0,
            "G": -2.0,
            "H": -1.0,
            "I": -5.0,
            "L": -5.0,
            "K": -1.0,
            "M": -4.0,
            "F": -4.0,
            "P": -3.0,
            "S": 0.0,
            "T": -1.0,
            "W": -6.0,
            "Y": -4.0,
            "V": -4.0,
            "B": 5.0,
            "J": -5.0,
            "Z": 0.0,
            "X": -1.0,
            "*": -6.0,
        },
        "J": {
            "A": -2.0,
            "R": -3.0,
            "N": -4.0,
            "D": -5.0,
            "C": -2.0,
            "Q": -3.0,
            "E": -4.0,
            "G": -5.0,
            "H": -4.0,
            "I": 3.0,
            "L": 4.0,
            "K": -3.0,
            "M": 2.0,
            "F": 0.0,
            "P": -4.0,
            "S": -3.0,
            "T": -2.0,
            "W": -3.0,
            "Y": -2.0,
            "V": 1.0,
            "B": -5.0,
            "J": 4.0,
            "Z": -4.0,
            "X": -1.0,
            "*": -6.0,
        },
        "Z": {
            "A": -1.0,
            "R": 0.0,
            "N": -1.0,
            "D": 1.0,
            "C": -5.0,
            "Q": 5.0,
            "E": 5.0,
            "G": -3.0,
            "H": 0.0,
            "I": -4.0,
            "L": -4.0,
            "K": 1.0,
            "M": -2.0,
            "F": -4.0,
            "P": -2.0,
            "S": -1.0,
            "T": -1.0,
            "W": -4.0,
            "Y": -3.0,
            "V": -3.0,
            "B": 0.0,
            "J": -4.0,
            "Z": 5.0,
            "X": -1.0,
            "*": -6.0,
        },
        "X": {
            "A": -1.0,
            "R": -1.0,
            "N": -1.0,
            "D": -1.0,
            "C": -1.0,
            "Q": -1.0,
            "E": -1.0,
            "G": -1.0,
            "H": -1.0,
            "I": -1.0,
            "L": -1.0,
            "K": -1.0,
            "M": -1.0,
            "F": -1.0,
            "P": -1.0,
            "S": -1.0,
            "T": -1.0,
            "W": -1.0,
            "Y": -1.0,
            "V": -1.0,
            "B": -1.0,
            "J": -1.0,
            "Z": -1.0,
            "X": -1.0,
            "*": -6.0,
        },
        "*": {
            "A": -6.0,
            "R": -6.0,
            "N": -6.0,
            "D": -6.0,
            "C": -6.0,
            "Q": -6.0,
            "E": -6.0,
            "G": -6.0,
            "H": -6.0,
            "I": -6.0,
            "L": -6.0,
            "K": -6.0,
            "M": -6.0,
            "F": -6.0,
            "P": -6.0,
            "S": -6.0,
            "T": -6.0,
            "W": -6.0,
            "Y": -6.0,
            "V": -6.0,
            "B": -6.0,
            "J": -6.0,
            "Z": -6.0,
            "X": -6.0,
            "*": 1.0,
        },
    },
}
