# AUTOGENERATED! DO NOT EDIT! File to edit: ../05_transformer.ipynb.

# %% auto 0
__all__ = ['DataFrameTransformer']

# %% ../05_transformer.ipynb 1
from fastcore.all import *
import pandas as pd
from scipy.sparse import issparse
from sklearn.base import BaseEstimator, TransformerMixin

# %% ../05_transformer.ipynb 2
class DataFrameTransformer(TransformerMixin, BaseEstimator):
    """Applies a transformer to a set of columns of pandas DataFrame and it outputs a DataFrame too."""

    def __init__(self, transformer=None, input_cols=None, output_cols=None, prev_step=None, append=False,
                 print_input_cols=False, print_output_cols=False, print_out_df_cols=False):
        store_attr()

    def before_fit(self):
        if not self.prev_step is None and self.input_cols is None:
            if hasattr(self.prev_step, 'output_cols'):
                self.input_cols = self.prev_step.output_cols
        if self.print_input_cols: print(L(self.input_cols, use_list=not isinstance(self.input_cols, str)))

    def after_fit(self):
        if self.output_cols is None and hasattr(self.transformer, 'get_feature_names_out'):
            self.output_cols = self.transformer.get_feature_names_out()
        if self.print_output_cols: print(L(self.output_cols, use_list=not isinstance(self.output_cols, str)))
    
    def after_transform(self, out, X):
        if issparse(out): out = out.todense()
        out_df = pd.DataFrame(out, columns=self.output_cols, index=X.index)
        if self.append: out_df = pd.concat([X, out_df], axis=1)
        if self.print_out_df_cols: print(L(out_df.columns, use_list=True))
        return out_df

    def transform(self, X):
        out = self.transformer.transform(X[self.input_cols])
        out_df = self.after_transform(out, X)
        return out_df
    
    def fit(self, X, y=None): 
        self.before_fit()
        out = self.transformer.fit(X[self.input_cols], y=y)
        self.after_fit()
        return out
    
    def fit_transform(self, X, y=None):
        self.before_fit()
        out = self.transformer.fit_transform(X[self.input_cols], y=y)
        self.after_fit()
        out_df = self.after_transform(out, X)
        return out_df
