# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hydra_plugins',
 'mephisto',
 'mephisto.abstractions',
 'mephisto.abstractions._subcomponents',
 'mephisto.abstractions.architects',
 'mephisto.abstractions.architects.channels',
 'mephisto.abstractions.architects.ec2',
 'mephisto.abstractions.architects.ec2.fallback_server',
 'mephisto.abstractions.architects.router',
 'mephisto.abstractions.architects.router.flask',
 'mephisto.abstractions.blueprints',
 'mephisto.abstractions.blueprints.abstract',
 'mephisto.abstractions.blueprints.abstract.static_task',
 'mephisto.abstractions.blueprints.mixins',
 'mephisto.abstractions.blueprints.mock',
 'mephisto.abstractions.blueprints.parlai_chat',
 'mephisto.abstractions.blueprints.remote_procedure',
 'mephisto.abstractions.blueprints.static_html_task',
 'mephisto.abstractions.blueprints.static_react_task',
 'mephisto.abstractions.databases',
 'mephisto.abstractions.providers',
 'mephisto.abstractions.providers.mock',
 'mephisto.abstractions.providers.mturk',
 'mephisto.abstractions.providers.mturk.utils',
 'mephisto.abstractions.providers.mturk_sandbox',
 'mephisto.abstractions.test',
 'mephisto.client',
 'mephisto.client.full',
 'mephisto.client.review',
 'mephisto.data_model',
 'mephisto.data_model.constants',
 'mephisto.operations',
 'mephisto.scripts',
 'mephisto.scripts.heroku',
 'mephisto.scripts.local_db',
 'mephisto.scripts.local_db.gh_actions',
 'mephisto.scripts.metrics',
 'mephisto.scripts.mturk',
 'mephisto.tools',
 'mephisto.utils']

package_data = \
{'': ['*'],
 'mephisto.abstractions.architects.ec2': ['keypairs/*',
                                          'run_scripts/flask/*',
                                          'run_scripts/node/*',
                                          'servers/*'],
 'mephisto.abstractions.architects.ec2.fallback_server': ['access_logs/*',
                                                          'scripts/*',
                                                          'templates/*'],
 'mephisto.abstractions.architects.router': ['node/*',
                                             'node/static/*',
                                             'node/uploads/*'],
 'mephisto.abstractions.architects.router.flask': ['static/*'],
 'mephisto.abstractions.blueprints.parlai_chat': ['webapp/*',
                                                  'webapp/src/*',
                                                  'webapp/src/static/*'],
 'mephisto.abstractions.blueprints.static_html_task': ['source/*',
                                                       'source/cypress/e2e/*',
                                                       'source/cypress/fixtures/*',
                                                       'source/cypress/support/*',
                                                       'source/dev/*'],
 'mephisto.client.full': ['webapp/*',
                          'webapp/public/*',
                          'webapp/src/*',
                          'webapp/src/lib/*',
                          'webapp/src/widgets/*',
                          'webapp/src/widgets/components/*'],
 'mephisto.client.review': ['default-ui/*',
                            'default-ui/static/css/*',
                            'default-ui/static/js/*',
                            'default-ui/static/media/*'],
 'mephisto.scripts.metrics': ['resources/*']}

install_requires = \
['boto3>=1.17,<2.0',
 'botocore>=1.20.95,<2.0.0',
 'click>=7.0,<8.0',
 'click_default_group>=1.2,<2.0',
 'detoxify>=0.5.0,<0.6.0',
 'flask>=1.1,<2.0',
 'gevent-websocket>=0.10.1,<0.11.0',
 'hydra-core>=1.2.0,<2.0.0',
 'markupsafe==2.0.1',
 'prometheus-client>=0.13.1,<0.14.0',
 'requests>=2.22,<3.0',
 'rich-click>=1.5.1,<2.0.0',
 'rich>=12.5.1,<13.0.0',
 'sh>=1.12,<2.0',
 'tabulate>=0.8.7,<0.9.0',
 'tornado>=6.0,<7.0',
 'tqdm>=4.50.2,<5.0.0',
 'websockets>=10.1,<11.0',
 'werkzeug>=1.0.1,<2.0.0',
 'xmltodict>=0.12.0,<0.13.0']

extras_require = \
{':extra == "parlai"': ['pyyaml>=5.4.0,<6.0.0',
                        'parlai>=1.7.0,<2.0.0',
                        'torch>=1.4.0,<2.0.0']}

entry_points = \
{'console_scripts': ['mephisto = mephisto.client.cli:cli']}

setup_kwargs = {
    'name': 'mephisto',
    'version': '1.1.1',
    'description': 'Crowdsourcing made simpler.',
    'long_description': '<p align="center">\n <h1>\n  <img width="250px" src="docs/web/static/img/logo.svg" alt="Mephisto" />\n </h1>\n</p>\n\n[![code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg)](https://github.com/prettier/prettier)\n\nMephisto makes crowdsourcing easier.\n\nWe provide a platform for launching, monitoring, and reviewing your crowdsourcing tasks. Tasks made on Mephisto can easily be open sourced as part of other projects. Like the [chess-playing automaton](https://en.wikipedia.org/wiki/Mephisto_(automaton)) we\'ve adopted the name from, Mephisto hides the complexity of projects that need human interaction or input.\n\nYou can find complete details about the project on our [docs website](https://mephisto.ai).\n\n## Quickstart\n\n[Get started in 10 minutes](https://mephisto.ai/docs/guides/quickstart)\n\n## Changelog\n\n## Want to help?\n\nCheck out our [guidelines for contributing](https://github.com/facebookresearch/Mephisto/blob/main/CONTRIBUTING.md) and then take a look at some of our tagged issues: [good first issue](https://github.com/facebookresearch/Mephisto/labels/good%20first%20issue), [help wanted](https://github.com/facebookresearch/Mephisto/labels/help%20wanted).\n\nFor library authors, you may also find the [how to contribute](https://mephisto.ai/docs/guides/how_to_contribute/getting_started) documentation helpful.\n\n\n## License\nMephisto is MIT licensed. See the LICENSE file for details.\n',
    'author': 'Jack Urbanek',
    'author_email': 'jju@fb.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://mephisto.ai/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
