/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarp/test/DemoExtended.h>

#include <yarp/os/idl/WireTypes.h>

namespace yarp {
namespace test {

class DemoExtended_multiply_point_helper :
        public yarp::os::Portable
{
public:
    explicit DemoExtended_multiply_point_helper(const Point3D& x, const double factor);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    Point3D m_x;
    double m_factor;

    thread_local static Point3D s_return_helper;
};

thread_local Point3D DemoExtended_multiply_point_helper::s_return_helper = {};

DemoExtended_multiply_point_helper::DemoExtended_multiply_point_helper(const Point3D& x, const double factor) :
        m_x{x},
        m_factor{factor}
{
}

bool DemoExtended_multiply_point_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(4)) {
        return false;
    }
    if (!writer.writeTag("multiply_point", 1, 2)) {
        return false;
    }
    if (!writer.write(m_x)) {
        return false;
    }
    if (!writer.writeFloat64(m_factor)) {
        return false;
    }
    return true;
}

bool DemoExtended_multiply_point_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.read(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

// Constructor
DemoExtended::DemoExtended()
{
    yarp().setOwner(*this);
}

Point3D DemoExtended::multiply_point(const Point3D& x, const double factor)
{
    DemoExtended_multiply_point_helper helper{x, factor};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "Point3D DemoExtended::multiply_point(const Point3D& x, const double factor)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? DemoExtended_multiply_point_helper::s_return_helper : Point3D{};
}

// help method
std::vector<std::string> DemoExtended::help(const std::string& functionName)
{
    bool showAll = (functionName == "--all");
    std::vector<std::string> helpString;
    if (showAll) {
        helpString.emplace_back("*** Available commands:");
        helpString.emplace_back("multiply_point");
        helpString.emplace_back("help");
    } else {
        if (functionName == "multiply_point") {
            helpString.emplace_back("Point3D multiply_point(const Point3D& x, const double factor) ");
        }
        if (functionName == "help") {
            helpString.emplace_back("std::vector<std::string> help(const std::string& functionName = \"--all\")");
            helpString.emplace_back("Return list of available commands, or help message for a specific function");
            helpString.emplace_back("@param functionName name of command for which to get a detailed description. If none or '--all' is provided, print list of available commands");
            helpString.emplace_back("@return list of strings (one string per line)");
        }
    }
    if (helpString.empty()) {
        helpString.emplace_back("Command not found");
    }
    return helpString;
}

// read from ConnectionReader
bool DemoExtended::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }

    std::string tag = reader.readTag();
    bool direct = (tag == "__direct__");
    if (direct) {
        tag = reader.readTag();
    }
    while (!reader.isError()) {
        if (tag == "multiply_point") {
            Point3D x;
            double factor;
            if (!reader.read(x)) {
                reader.fail();
                return false;
            }
            if (!reader.readFloat64(factor)) {
                reader.fail();
                return false;
            }
            DemoExtended_multiply_point_helper::s_return_helper = multiply_point(x, factor);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.write(DemoExtended_multiply_point_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "help") {
            std::string functionName;
            if (!reader.readString(functionName)) {
                functionName = "--all";
            }
            auto help_strings = help(functionName);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeTag("many", 1, 0)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_INT32, static_cast<uint32_t>(help_strings.size()))) {
                    return false;
                }
                for (const auto& help_string : help_strings) {
                    if (!writer.writeString(help_string)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (reader.noMore()) {
            reader.fail();
            return false;
        }
        std::string next_tag = reader.readTag();
        if (next_tag == "") {
            break;
        }
        tag.append("_").append(next_tag);
    }
    return false;
}

} // namespace yarp
} // namespace test
