"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCallBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for an ApiCall
 */
class ApiCallBase extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.flattenResponse = 'false';
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        this.expectedResult = expected.result;
        return this;
    }
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        next.node.addDependency(this);
        return next;
    }
}
exports.ApiCallBase = ApiCallBase;
_a = JSII_RTTI_SYMBOL_1;
ApiCallBase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ApiCallBase", version: "2.64.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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