"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentSynchronizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const simple_git_1 = require("simple-git");
/**
 * Ensures that component dependencies are downloaded and available.
 *
 * @stability stable
 */
class ComponentSynchronizer {
    constructor() {
        /**
         * @stability stable
         */
        this.cacheDir = 'component_cache';
    }
    /**
     * @stability stable
     */
    async synchronize(componentDefs) {
        const git = simple_git_1.default();
        // Ensure component cache directory exists
        if (!fs.existsSync(this.cacheDir)) {
            fs.mkdirSync(this.cacheDir);
        }
        const gitDefs = componentDefs.filter((x) => x.type == 'git');
        // Pull in all the git component dependencies
        for (let componentConfig of gitDefs) {
            const destination = componentConfig.name;
            if (!fs.existsSync(path.join(this.cacheDir, destination))) {
                await git.cwd(this.cacheDir)
                    .clone(componentConfig.url, destination, {
                    '--branch': componentConfig.branch,
                })
                    .cwd('../../')
                    .catch(e => {
                    console.error(e);
                    throw new Error(e);
                });
            }
            else {
                await git.cwd(path.join(this.cacheDir, destination))
                    .fetch()
                    .checkout(componentConfig.branch)
                    .pull('origin', componentConfig.branch)
                    .cwd('../../')
                    .catch(e => {
                    console.error(e);
                    throw new Error(e);
                });
            }
        }
        return 'OK';
    }
}
exports.ComponentSynchronizer = ComponentSynchronizer;
_a = JSII_RTTI_SYMBOL_1;
ComponentSynchronizer[_a] = { fqn: "halloumi-ami-pipelines.ComponentSynchronizer", version: "0.0.27" };
//# sourceMappingURL=data:application/json;base64,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