# TikLocal

**TikLocal** is a **mobile and tablet** **web application** built on **Flask**. It allows you to browse and manage your local videos and images in a way similar to TikTok and Pinterest.

[中文](./README_zh.md)

## Introduction

TikLocal's main features include:

* **A TikTok-like swipe-up browsing experience** that allows you to easily and quickly browse local video files.
* **A file manager-like directory browsing** feature that allows you to easily find and manage local video files.
* **A Pinterest-like grid layout** feature that allows you to enjoy local images.
* **Support for light and dark modes** to suit your personal preferences.

## Use cases

TikLocal is suitable for the following use cases:

* You don't trust TikTok's teen mode and want to provide your child with completely controllable video content.
* You want to browse and manage your local videos and images locally, but don't want to use third-party cloud services.
* You want to use a TikTok-style video browsing experience on your phone or tablet.
* You want to use a Pinterest-style image browsing experience on your phone or tablet.

## How to use

### Installation

TikLocal is a Python application that you can install using the following command:

```
pip install tiklocal
```

### Usage

Starting TikLocal is very simple, just run the following command:

```
tiklocal ~/Videos/
```

You can specify any media folder.

To close, press `Ctrl + C`.

### Configuration

TikLocal provides some configuration options that you can adjust to your needs.

* **Light and dark modes:** You can choose to use light or dark mode.
* **Video playback speed:** You can adjust the video playback speed.


## TODO

* [ ] Add search
* [ ] Add more management operations, such as moving files and creating folders
* [ ] Add basic login control
* [ ] Add a bookmarking feature
* [ ] Add a Docker image
* [ ] Add a tagging feature
* [ ] Use recommendation algorithms

## Contribution

TikLocal is an open source project that you can contribute to in the following ways:

* Submit code or documentation improvements.
* Report bugs.
* Suggest new features.

## Contact us

If you have any questions or suggestions, you can contact us in the following ways:

* GitHub project page: [https://github.com/ChanMo/TikLocal/](https://github.com/ChanMo/TikLocal/)
* Email: [chan.mo@outlook.com]
