# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['DHParser',
 'DHParser.externallibs',
 'DHParser.scripts',
 'documentation_src',
 'documentation_src.doc_examples',
 'tests']

package_data = \
{'': ['*'],
 'DHParser': ['templates/*'],
 'documentation_src': ['Presentations/deRSE2019/*']}

entry_points = \
{'console_scripts': ['dhparser = DHParser.scripts.dhparser:main',
                     'dhparser_build_cython = '
                     'DHParser.scripts.dhparser_build_cython:main']}

setup_kwargs = {
    'name': 'dhparser',
    'version': '0.9.7',
    'description': 'Parser Generator and DSL-construction-kit',
    'long_description': 'DHParser\n========\n\nDHParser - A parser generator and domain specific language (DSL)\nconstruction kit for the Digital Humanities\n\n\nFeatures\n--------\n\n* *Based on parsings expression grammars; handles all context-free\n  grammers including left-recursive grammars*\n\n* full unicode support\n\n* *Unit testing framework and post-mortem debugger for grammars*\n\n* *Customizable error reporting*\n\n* *supports for fail-tolerant parsing*\n\n* *Language-server-support* (https://microsoft.github.io/language-server-protocol/)\n\n* *Beginner friendly*\n\n* *Digital Humanities oriented* (optional XML-workflows!), but open for any application domain\n\n* *Python-based*\n\n\nEase of use\n-----------\n\nkey_value_store.py:\npython \n    # A mini-DSL for a key value store\n    from DHParser import *\n\n    # specify the grammar of your DSL in EBNF-notation\n    grammar = \'\'\'@ drop = whitespace, strings\n    key_store   = ~ { entry }\n    entry       = key "="~ value          # ~ means: insignificant whitespace \n    key         = /\\w+/~                  # Scannerless parsing: Use regular\n    value       = /\\"[^"\\n]*\\"/~          # expressions wherever you like\'\'\'\n\n    # generating a parser is almost as simple as compiling a regular expression\n    parser = create_parser(grammar)       # parser factory for thread-safety\n\nNow, parse some text and extract the data from the Python-shell:\n\n    >>> from key_value_store import parser\n    >>> text = \'\'\'\n            title    = "Odysee 2001"\n            director = "Stanley Kubrick"\n        \'\'\'\n    >>> data = parser(text)\n    >>> for entry in data.select(\'entry\'):\n            print(entry[\'key\'], entry[\'value\'])\n\n    title "Odysee 2001"\n    director "Stanley Kubrick"\n\nOr, serialize as XML:\n\n    >>> print(data.as_xml())\n\n    <key_store>\n      <entry>\n        <key>title</key>\n        <value>"Odysee 2001"</value>\n      </entry>\n      <entry>\n        <key>director</key>\n        <value>"Stanley Kubrick"</value>\n      </entry>\n    </key_store>\n\n\nInstallation\n------------\n\nYou can install DHParser from the Python package index (https://pypi.org)*:\n\n    python -m pip install --user DHParser\n\nHowever, as the software is still in an early beta stage, it is\nrecommended that you pull it directly from gitlab (see below).\n\n\nGetting Started\n---------------\n\nSee [Introduction.md](https://gitlab.lrz.de/badw-it/DHParser/blob/master/Introduction.md) for the\nmotivation and an overview how DHParser works or jump right into the\n[Step by Step Guide](https://gitlab.lrz.de/badw-it/DHParser/blob/master/documentation_src/StepByStepGuide.rst) to\nlearn how to setup and use DHParser.\n\nDocumentation\n-------------\n\nFor the full documentation see: [dhparser.readthedocs.io](https://dhparser.readthedocs.io/en/latest/)\n\nLicense\n-------\n\nDHParser is open source software under the [Apache 2.0 License](https://www.apache.org/licenses/LICENSE-2.0).\n\nCopyright 2016-2019  Eckhart Arnold, Bavarian Academy of Sciences and Humanities\n\nLicensed under the Apache License, Version 2.0 (the "License");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    https://www.apache.org/licenses/LICENSE-2.0e\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an "AS IS" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n\nOptional Post-Installaton\n-------------------------\n\nIt is recommended that you install the `regex`-module\n(https://bitbucket.org/mrabarnett/mrab-regex). If present, DHParser\nwill use `regex` instead of the built-in `re`-module for regular\nexpressions. `regex` is faster and more powerful than `re`.\n\nIn order to speed up DHParser even more, it can be compiled with\nthe Python to C compiler [Cython](https://cython.org). First,\nyou mustt install cython with the command:\n\n    pip install cython\n \nOnce cython is installed, you can run the `dhparser_build_cython`\nscript from the command line:\n\n    dhparser_build_cython\n       \nAlternatively, if you have cloned DHParser from the git-Repository,\nyou can run the `buildpackages.sh`-script (or `buildpackages.bat` on\nWindows-systems) after installation.\n\nThe Cython-compiled version is about 2-3 times faster than the \nCPython interpreted version.\n\nDepending on the use case, e.g. when parsing large files, \n[PyPy3](https://www.pypy.org/) yields even more impressive speed-ups,\nup to 8 times faster than CPython. To circumvent the longer startup\ntimes of pypy3 in comparison to CPython, it is recommended to use\nthe xxxServer.py-scripts rather than calling the xxxParser.py-script\neach time when parsing many documents subsequently.\n\n\nSources\n-------\n\nFind the sources on [gitlab.lrz.de/badw-it/DHParser](https://gitlab.lrz.de/badw-it/DHParser) .\nGet them with:\n\n    git clone https://gitlab.lrz.de/badw-it/DHParser\n\nThere exists a mirror of this repository on github:\nhttps://github.com/jecki/DHParser Be aware, though, that the github-mirror\nmay occasionally lag behind a few commits.\n\nPlease contact me, if you are intested in contributing to the\ndevelopment or just using DHParser.\n\n\nPurpose\n-------\n\nDHParser is a parser-combinator-based parsing and compiling\ninfrastructure for domain specific languages (DSL) in Digital\nHumanities projects. It leverages the power of Domain specific\nlanguages for the Digital Humanities.\n\nDomain specific languages are widespread in\ncomputer sciences, but seem to be underused in the Digital Humanities.\nWhile DSLs are sometimes introduced to Digital-Humanities-projects as\n[practical adhoc-solution][Müller_2016], these solutions are often\nsomewhat "quick and dirty". In other words they are more of a hack\nthan a technology. The purpose of DHParser is to introduce\n[DSLs as a technology][Arnold_2016] to the Digital Humanities. It is\nbased on the well known technology of [EBNF][ISO_IEC_14977]-based\nparser generators, but employs the more modern form called\n"[parsing expression grammar][Ford_2004]" and\n[parser combinators][Ford_20XX] as a variant of the classical\nrecursive descent parser.\n\nWhy another parser generator? There are plenty of good parser\ngenerators out there, e.g. [Añez\'s grako parser generator][Añez_2017],\n[Eclipse XText][XText_Website]. However, DHParser is\nintended as a tool that is specifically geared towards digital\nhumanities applications, while most existing parser generators come\nfrom compiler construction toolkits for programming languages.\nWhile I expect DSLs in computer science and DSLs in the Digital\nHumanities to be quite similar as far as the technological realization\nis concerned, the use cases, requirements and challenges are somewhat\ndifferent. For example, in the humanities annotating text is a central\nuse case, which is mostly absent in computer science treatments.\nThese differences might sooner or later require to develop the\nDSL-construction toolkits in a different direction. Also DHParser\nemphasizes and evolutionary development model for grammars with\nunit-testing support, which fits the typical use cases in DH where DSLs\nevolve in a discussion process between technicians and humanists.\nBecause the users of DSLs in the humanities are not necessarily very\ntechnically mindes people, DHParser supports the construction of\nfail-tolerant parsers with good error reporting in terms of locating\nthe errors at the right spot and giving useful error messages.\n\nAlso,\nDHParser shall (in the future) serve as a teaching tool, which\ninfluences some of its design decisions such as, for example, clearly\nseparating the parsing, syntax-tree-transformation and compilation\nstages. Finally, DHParser is intended as a tool to experiment with.  One\npossible research area is, how non\n[context-free grammars](https://en.wikipedia.org/wiki/Context-free_grammar)\nsuch as the grammars of [TeX][tex_stackexchange_no_bnf] or\n[CommonMark][MacFarlane_et_al_2017] can be described with declarative\nlangauges in the spirit of but beyond EBNF, and what extensions of the\nparsing technology are necessary to capture such languages.\n\nPrimary use case at the Bavarian Academy of Sciences and Humanities\n(for the time being): A DSL for the\n"[Mittellateinische Wörterbuch](http://www.mlw.badw.de/)"!\n\nFurther (intended) use cases are:\n\n* LaTeX -> XML/HTML conversion. See this\n  [discussion on why an EBNF-parser for the complete TeX/LaTeX-grammar][tex_stackexchange_no_bnf]\n  is not possible.\n* [CommonMark][MacFarlane_et_al_2017] and other DSLs for cross media\n  publishing of scientific literature, e.g. journal articles.  (Common\n  Mark and Markdown also go beyond what is feasible with pure\n  EBNF-based-parsers.)\n* EBNF itself. DHParser is already self-hosting ;-)\n* XML-parser, just for the fun of it ;-)\n* Digital and cross-media editions\n* Digital dictionaries\n\nFor a simple self-test run `dhparser.py` from the command line. This\ncompiles the EBNF-Grammer in `examples/EBNF/EBNF.ebnf` and outputs the\nPython-based parser class representing that grammar. The concrete and\nabstract syntax tree as well as a full and abbreviated log of the\nparsing process will be stored in a sub-directory named "LOG".\n\n\nAuthor\n------\n\nAuthor: Eckhart Arnold, Bavarian Academy of Sciences\nEmail:  arnold@badw.de\n\n\nReferences and Acknowledgement\n------------------------------\n\nJuancarlo Añez: grako, a PEG parser generator in Python, 2017. URL:\n[bitbucket.org/apalala/grako][Añez_2017]\n\n[Añez_2017]: https://bitbucket.org/apalala/grako\n\nEckhart Arnold: Domänenspezifische Notationen. Eine (noch)\nunterschätzte Technologie in den Digitalen Geisteswissenschaften,\nPräsentation auf dem\n[dhmuc-Workshop: Digitale Editionen und Auszeichnungssprachen](https://dhmuc.hypotheses.org/workshop-digitale-editionen-und-auszeichnungssprachen),\nMünchen 2016. Short-URL: [tiny.badw.de/2JVT][Arnold_2016]\n\n[Arnold_2016]: https://f.hypotheses.org/wp-content/blogs.dir/1856/files/2016/12/EA_Pr%C3%A4sentation_Auszeichnungssprachen.pdf\n\nBrian Ford: Parsing Expression Grammars: A Recognition-Based Syntactic\nFoundation, Cambridge\nMassachusetts, 2004. Short-URL:[t1p.de/jihs][Ford_2004]\n\n[Ford_2004]: https://pdos.csail.mit.edu/~baford/packrat/popl04/peg-popl04.pdf\n\n[Ford_20XX]: http://bford.info/packrat/\n\nRichard A. Frost, Rahmatullah Hafiz and Paul Callaghan: Parser\nCombinators for Ambiguous Left-Recursive Grammars, in: P. Hudak and\nD.S. Warren (Eds.): PADL 2008, LNCS 4902, pp. 167–181, Springer-Verlag\nBerlin Heidelberg 2008.\n\nElizabeth Scott and Adrian Johnstone, GLL Parsing,\nin: Electronic Notes in Theoretical Computer Science 253 (2010) 177–189,\n[dotat.at/tmp/gll.pdf][scott_johnstone_2010]\n\n[scott_johnstone_2010]: http://dotat.at/tmp/gll.pdf\n\nDominikus Herzberg: Objekt-orientierte Parser-Kombinatoren in Python,\nBlog-Post, September, 18th 2008 on denkspuren. gedanken, ideen,\nanregungen und links rund um informatik-themen, short-URL:\n[t1p.de/bm3k][Herzberg_2008a]\n\n[Herzberg_2008a]: http://denkspuren.blogspot.de/2008/09/objekt-orientierte-parser-kombinatoren.html\n\nDominikus Herzberg: Eine einfache Grammatik für LaTeX, Blog-Post,\nSeptember, 18th 2008 on denkspuren. gedanken, ideen, anregungen und\nlinks rund um informatik-themen, short-URL:\n[t1p.de/7jzh][Herzberg_2008b]\n\n[Herzberg_2008b]: http://denkspuren.blogspot.de/2008/09/eine-einfache-grammatik-fr-latex.html\n\nDominikus Herzberg: Uniform Syntax, Blog-Post, February, 27th 2007 on\ndenkspuren. gedanken, ideen, anregungen und links rund um\ninformatik-themen, short-URL: [t1p.de/s0zk][Herzberg_2007]\n\n[Herzberg_2007]: http://denkspuren.blogspot.de/2007/02/uniform-syntax.html\n\n[ISO_IEC_14977]: http://www.cl.cam.ac.uk/~mgk25/iso-14977.pdf\n\nJohn MacFarlane, David Greenspan, Vicent Marti, Neil Williams,\nBenjamin Dumke-von der Ehe, Jeff Atwood: CommonMark. A strongly\ndefined, highly compatible specification of\nMarkdown, 2017. [commonmark.org][MacFarlane_et_al_2017]\n\n[MacFarlane_et_al_2017]: http://commonmark.org/\n\nStefan Müller: DSLs in den digitalen Geisteswissenschaften,\nPräsentation auf dem\n[dhmuc-Workshop: Digitale Editionen und Auszeichnungssprachen](https://dhmuc.hypotheses.org/workshop-digitale-editionen-und-auszeichnungssprachen),\nMünchen 2016. Short-URL: [tiny.badw.de/2JVy][Müller_2016]\n\n[Müller_2016]: https://f.hypotheses.org/wp-content/blogs.dir/1856/files/2016/12/Mueller_Anzeichnung_10_Vortrag_M%C3%BCnchen.pdf\n\nMarkus Voelter, Sbastian Benz, Christian Dietrich, Birgit Engelmann,\nMats Helander, Lennart Kats, Eelco Visser, Guido Wachsmuth:\nDSL Engineering. Designing, Implementing and Using Domain-Specific Languages, 2013.\n[dslbook.org/][Voelter_2013]\n\nChristopher Seaton: A Programming Language Where the Syntax and Semantics\nare Mutuable at Runtime, University of Bristol 2007,\n[chrisseaton.com/katahdin/katahdin.pdf][seaton_2007]\n\nVegard Øye: General Parser Combinators in Racket, 2012,\n[epsil.github.io/gll/][vegard_2012]\n\n[vegard_2012]: https://epsil.github.io/gll/\n\n[seaton_2007]: http://chrisseaton.com/katahdin/katahdin.pdf\n\n[voelter_2013]: http://dslbook.org/\n\n[tex_stackexchange_no_bnf]: http://tex.stackexchange.com/questions/4201/is-there-a-bnf-grammar-of-the-tex-language\n\n[tex_stackexchange_latex_parsers]: http://tex.stackexchange.com/questions/4223/what-parsers-for-latex-mathematics-exist-outside-of-the-tex-engines\n\n[XText_website]: https://www.eclipse.org/Xtext/\n',
    'author': 'Eckhart Arnold',
    'author_email': 'eckhart.arnold@posteo.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.lrz.de/badw-it/DHParser',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
