# FlaxFile

基于 ZeroMQ 的高性能跨网络文件传输系统。

## 核心特性

- **高性能传输**：多Socket并发 + 滑动窗口协议，上传/下载速度可达 1.5+ GB/s
- **安全加密**：支持 CurveZMQ (NaCl) 端到端加密传输
- **增量同步**：基于 xxHash3-64 快速哈希，智能跳过未修改文件
- **异步架构**：单端口异步服务器，高并发低延迟
- **友好界面**：Rich 终端进度条，实时显示传输状态

## 快速开始

### 安装

```bash
pip install -e .
```

### 启动服务器

```bash
# 默认配置启动
flaxfile serve

# 指定端口和存储目录
flaxfile serve --host 0.0.0.0 --port 25555

# 启用加密（推荐）
export FLAXFILE_PASSWORD="your_password"
flaxfile serve
```

### 客户端操作

```bash
# 上传文件
flaxfile set /path/to/file.bin [key]

# 下载文件
flaxfile get key [output_path]

# 目录同步（增量）
flaxfile push /local/dir remote_dir
flaxfile pull remote_dir /local/dir

# 列出文件
flaxfile list [prefix]

# 删除文件
flaxfile delete key
```

## Python API

### 异步 API（推荐）

```python
import asyncio
from flaxfile import MultiSocketFlaxFileClient

async def main():
    client = MultiSocketFlaxFileClient(
        server_host="127.0.0.1",
        port=25555,
        password="your_password"  # 可选
    )

    # 上传/下载（自适应选择最优Socket数量）
    await client.upload_file("video.mp4", "my_video", show_progress=True)
    await client.download_file("my_video", "output.mp4", show_progress=True)

    await client.close()

asyncio.run(main())
```

### 同步 API

```python
from flaxfile import MultiSocketFlaxFileClientSync

client = MultiSocketFlaxFileClientSync(server_host="127.0.0.1", port=25555)
try:
    client.upload_file("video.mp4", "my_video", show_progress=True)
    client.download_file("my_video", "output.mp4", show_progress=True)
finally:
    client.close()
```

## 配置文件

在项目目录或家目录创建 `flaxfile.toml`：

```toml
[client]
default_server = "prod"

[server]
host = "0.0.0.0"
port = 25555
storage_dir = "./zmq_streaming_storage"

[servers.prod]
host = "192.168.1.100"
port = 25555
```

## 性能特性

- **自适应传输策略**：根据文件大小自动调整Socket数量和窗口大小
- **滑动窗口协议**：多个chunk并发传输，充分利用网络带宽
- **异步I/O**：aiofiles避免阻塞，保持高并发性能
- **智能缓存**：乱序chunk缓存机制，确保数据正确性

## 许可证

MIT License
