# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.connection import Connection  # noqa: F401,E501
from odahuflow.sdk.models.input_data_binding_dir import InputDataBindingDir  # noqa: F401,E501
from odahuflow.sdk.models.model_training import ModelTraining  # noqa: F401,E501
from odahuflow.sdk.models.toolchain_integration import ToolchainIntegration  # noqa: F401,E501
from odahuflow.sdk.models import util


class K8sTrainer(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, algorithm_source_connection: Connection=None, input_data: List[InputDataBindingDir]=None, model_training: ModelTraining=None, output_conn: Connection=None, toolchain_integration: ToolchainIntegration=None):  # noqa: E501
        """K8sTrainer - a model defined in Swagger

        :param algorithm_source_connection: The algorithm_source_connection of this K8sTrainer.  # noqa: E501
        :type algorithm_source_connection: Connection
        :param input_data: The input_data of this K8sTrainer.  # noqa: E501
        :type input_data: List[InputDataBindingDir]
        :param model_training: The model_training of this K8sTrainer.  # noqa: E501
        :type model_training: ModelTraining
        :param output_conn: The output_conn of this K8sTrainer.  # noqa: E501
        :type output_conn: Connection
        :param toolchain_integration: The toolchain_integration of this K8sTrainer.  # noqa: E501
        :type toolchain_integration: ToolchainIntegration
        """
        self.swagger_types = {
            'algorithm_source_connection': Connection,
            'input_data': List[InputDataBindingDir],
            'model_training': ModelTraining,
            'output_conn': Connection,
            'toolchain_integration': ToolchainIntegration
        }

        self.attribute_map = {
            'algorithm_source_connection': 'algorithmSourceConnection',
            'input_data': 'inputData',
            'model_training': 'modelTraining',
            'output_conn': 'outputConn',
            'toolchain_integration': 'toolchainIntegration'
        }

        self._algorithm_source_connection = algorithm_source_connection
        self._input_data = input_data
        self._model_training = model_training
        self._output_conn = output_conn
        self._toolchain_integration = toolchain_integration

    @classmethod
    def from_dict(cls, dikt) -> 'K8sTrainer':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The K8sTrainer of this K8sTrainer.  # noqa: E501
        :rtype: K8sTrainer
        """
        return util.deserialize_model(dikt, cls)

    @property
    def algorithm_source_connection(self) -> Connection:
        """Gets the algorithm_source_connection of this K8sTrainer.

        Connection for source code  # noqa: E501

        :return: The algorithm_source_connection of this K8sTrainer.
        :rtype: Connection
        """
        return self._algorithm_source_connection

    @algorithm_source_connection.setter
    def algorithm_source_connection(self, algorithm_source_connection: Connection):
        """Sets the algorithm_source_connection of this K8sTrainer.

        Connection for source code  # noqa: E501

        :param algorithm_source_connection: The algorithm_source_connection of this K8sTrainer.
        :type algorithm_source_connection: Connection
        """

        self._algorithm_source_connection = algorithm_source_connection

    @property
    def input_data(self) -> List[InputDataBindingDir]:
        """Gets the input_data of this K8sTrainer.

        Connection for training data  # noqa: E501

        :return: The input_data of this K8sTrainer.
        :rtype: List[InputDataBindingDir]
        """
        return self._input_data

    @input_data.setter
    def input_data(self, input_data: List[InputDataBindingDir]):
        """Sets the input_data of this K8sTrainer.

        Connection for training data  # noqa: E501

        :param input_data: The input_data of this K8sTrainer.
        :type input_data: List[InputDataBindingDir]
        """

        self._input_data = input_data

    @property
    def model_training(self) -> ModelTraining:
        """Gets the model_training of this K8sTrainer.

        Model training  # noqa: E501

        :return: The model_training of this K8sTrainer.
        :rtype: ModelTraining
        """
        return self._model_training

    @model_training.setter
    def model_training(self, model_training: ModelTraining):
        """Sets the model_training of this K8sTrainer.

        Model training  # noqa: E501

        :param model_training: The model_training of this K8sTrainer.
        :type model_training: ModelTraining
        """

        self._model_training = model_training

    @property
    def output_conn(self) -> Connection:
        """Gets the output_conn of this K8sTrainer.

        Connection for trained model artifact  # noqa: E501

        :return: The output_conn of this K8sTrainer.
        :rtype: Connection
        """
        return self._output_conn

    @output_conn.setter
    def output_conn(self, output_conn: Connection):
        """Sets the output_conn of this K8sTrainer.

        Connection for trained model artifact  # noqa: E501

        :param output_conn: The output_conn of this K8sTrainer.
        :type output_conn: Connection
        """

        self._output_conn = output_conn

    @property
    def toolchain_integration(self) -> ToolchainIntegration:
        """Gets the toolchain_integration of this K8sTrainer.

        Toolchain integration  # noqa: E501

        :return: The toolchain_integration of this K8sTrainer.
        :rtype: ToolchainIntegration
        """
        return self._toolchain_integration

    @toolchain_integration.setter
    def toolchain_integration(self, toolchain_integration: ToolchainIntegration):
        """Sets the toolchain_integration of this K8sTrainer.

        Toolchain integration  # noqa: E501

        :param toolchain_integration: The toolchain_integration of this K8sTrainer.
        :type toolchain_integration: ToolchainIntegration
        """

        self._toolchain_integration = toolchain_integration
