# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ConnectionReference(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, connection: str=None, path: str=None):  # noqa: E501
        """ConnectionReference - a model defined in Swagger

        :param connection: The connection of this ConnectionReference.  # noqa: E501
        :type connection: str
        :param path: The path of this ConnectionReference.  # noqa: E501
        :type path: str
        """
        self.swagger_types = {
            'connection': str,
            'path': str
        }

        self.attribute_map = {
            'connection': 'connection',
            'path': 'path'
        }

        self._connection = connection
        self._path = path

    @classmethod
    def from_dict(cls, dikt) -> 'ConnectionReference':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ConnectionReference of this ConnectionReference.  # noqa: E501
        :rtype: ConnectionReference
        """
        return util.deserialize_model(dikt, cls)

    @property
    def connection(self) -> str:
        """Gets the connection of this ConnectionReference.

        ODAHU Connection  # noqa: E501

        :return: The connection of this ConnectionReference.
        :rtype: str
        """
        return self._connection

    @connection.setter
    def connection(self, connection: str):
        """Sets the connection of this ConnectionReference.

        ODAHU Connection  # noqa: E501

        :param connection: The connection of this ConnectionReference.
        :type connection: str
        """

        self._connection = connection

    @property
    def path(self) -> str:
        """Gets the path of this ConnectionReference.

        User can override path otherwise Connection path will be used. For dataSource: Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object). For outputDestination: Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object). nFor modelSource: If path has .zip / .tar.gz suffix then it will be unpacked before delivering to user predictor container. Otherwise its considered and a directory and will be delivered to user predictor container AS-IS  # noqa: E501

        :return: The path of this ConnectionReference.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path: str):
        """Sets the path of this ConnectionReference.

        User can override path otherwise Connection path will be used. For dataSource: Input data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-request-json-object). For outputDestination: Output data files must have .json extension and be valid JSON files that follows [Predict Protocol - Version 2](https://github.com/kubeflow/kfserving/blob/v0.5.1/docs/predict-api/v2/required_api.md#inference-response-json-object). nFor modelSource: If path has .zip / .tar.gz suffix then it will be unpacked before delivering to user predictor container. Otherwise its considered and a directory and will be delivered to user predictor container AS-IS  # noqa: E501

        :param path: The path of this ConnectionReference.
        :type path: str
        """

        self._path = path
