# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.node_pool import NodePool  # noqa: F401,E501
from odahuflow.sdk.models import util


class BatchConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, enabled: bool=None, namespace: str=None, node_pools: List[NodePool]=None, rclone_image: str=None, service_account_name: str=None, timeout: str=None, tolerations: str=None, tools_image: str=None, tools_secret: str=None):  # noqa: E501
        """BatchConfig - a model defined in Swagger

        :param enabled: The enabled of this BatchConfig.  # noqa: E501
        :type enabled: bool
        :param namespace: The namespace of this BatchConfig.  # noqa: E501
        :type namespace: str
        :param node_pools: The node_pools of this BatchConfig.  # noqa: E501
        :type node_pools: List[NodePool]
        :param rclone_image: The rclone_image of this BatchConfig.  # noqa: E501
        :type rclone_image: str
        :param service_account_name: The service_account_name of this BatchConfig.  # noqa: E501
        :type service_account_name: str
        :param timeout: The timeout of this BatchConfig.  # noqa: E501
        :type timeout: str
        :param tolerations: The tolerations of this BatchConfig.  # noqa: E501
        :type tolerations: str
        :param tools_image: The tools_image of this BatchConfig.  # noqa: E501
        :type tools_image: str
        :param tools_secret: The tools_secret of this BatchConfig.  # noqa: E501
        :type tools_secret: str
        """
        self.swagger_types = {
            'enabled': bool,
            'namespace': str,
            'node_pools': List[NodePool],
            'rclone_image': str,
            'service_account_name': str,
            'timeout': str,
            'tolerations': str,
            'tools_image': str,
            'tools_secret': str
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'namespace': 'namespace',
            'node_pools': 'nodePools',
            'rclone_image': 'rcloneImage',
            'service_account_name': 'serviceAccountName',
            'timeout': 'timeout',
            'tolerations': 'tolerations',
            'tools_image': 'toolsImage',
            'tools_secret': 'toolsSecret'
        }

        self._enabled = enabled
        self._namespace = namespace
        self._node_pools = node_pools
        self._rclone_image = rclone_image
        self._service_account_name = service_account_name
        self._timeout = timeout
        self._tolerations = tolerations
        self._tools_image = tools_image
        self._tools_secret = tools_secret

    @classmethod
    def from_dict(cls, dikt) -> 'BatchConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The BatchConfig of this BatchConfig.  # noqa: E501
        :rtype: BatchConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def enabled(self) -> bool:
        """Gets the enabled of this BatchConfig.

        Enable batch API/operator  # noqa: E501

        :return: The enabled of this BatchConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool):
        """Sets the enabled of this BatchConfig.

        Enable batch API/operator  # noqa: E501

        :param enabled: The enabled of this BatchConfig.
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def namespace(self) -> str:
        """Gets the namespace of this BatchConfig.

        Kubernetes namespace, where BatchInferenceService and BatchInferenceJob will be created  # noqa: E501

        :return: The namespace of this BatchConfig.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str):
        """Sets the namespace of this BatchConfig.

        Kubernetes namespace, where BatchInferenceService and BatchInferenceJob will be created  # noqa: E501

        :param namespace: The namespace of this BatchConfig.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def node_pools(self) -> List[NodePool]:
        """Gets the node_pools of this BatchConfig.

        Node pools to run batch jobs  # noqa: E501

        :return: The node_pools of this BatchConfig.
        :rtype: List[NodePool]
        """
        return self._node_pools

    @node_pools.setter
    def node_pools(self, node_pools: List[NodePool]):
        """Sets the node_pools of this BatchConfig.

        Node pools to run batch jobs  # noqa: E501

        :param node_pools: The node_pools of this BatchConfig.
        :type node_pools: List[NodePool]
        """

        self._node_pools = node_pools

    @property
    def rclone_image(self) -> str:
        """Gets the rclone_image of this BatchConfig.

        RClone image that will be used to sync data with object storage  # noqa: E501

        :return: The rclone_image of this BatchConfig.
        :rtype: str
        """
        return self._rclone_image

    @rclone_image.setter
    def rclone_image(self, rclone_image: str):
        """Sets the rclone_image of this BatchConfig.

        RClone image that will be used to sync data with object storage  # noqa: E501

        :param rclone_image: The rclone_image of this BatchConfig.
        :type rclone_image: str
        """

        self._rclone_image = rclone_image

    @property
    def service_account_name(self) -> str:
        """Gets the service_account_name of this BatchConfig.

        Specifies a ServiceAccount object that provides custom credentials for executing the TaskRun  # noqa: E501

        :return: The service_account_name of this BatchConfig.
        :rtype: str
        """
        return self._service_account_name

    @service_account_name.setter
    def service_account_name(self, service_account_name: str):
        """Sets the service_account_name of this BatchConfig.

        Specifies a ServiceAccount object that provides custom credentials for executing the TaskRun  # noqa: E501

        :param service_account_name: The service_account_name of this BatchConfig.
        :type service_account_name: str
        """

        self._service_account_name = service_account_name

    @property
    def timeout(self) -> str:
        """Gets the timeout of this BatchConfig.

        Timeout for full batch process  # noqa: E501

        :return: The timeout of this BatchConfig.
        :rtype: str
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout: str):
        """Sets the timeout of this BatchConfig.

        Timeout for full batch process  # noqa: E501

        :param timeout: The timeout of this BatchConfig.
        :type timeout: str
        """

        self._timeout = timeout

    @property
    def tolerations(self) -> str:
        """Gets the tolerations of this BatchConfig.

        Kubernetes tolerations for batch jobs  # noqa: E501

        :return: The tolerations of this BatchConfig.
        :rtype: str
        """
        return self._tolerations

    @tolerations.setter
    def tolerations(self, tolerations: str):
        """Sets the tolerations of this BatchConfig.

        Kubernetes tolerations for batch jobs  # noqa: E501

        :param tolerations: The tolerations of this BatchConfig.
        :type tolerations: str
        """

        self._tolerations = tolerations

    @property
    def tools_image(self) -> str:
        """Gets the tools_image of this BatchConfig.

        ODAHU tools image  # noqa: E501

        :return: The tools_image of this BatchConfig.
        :rtype: str
        """
        return self._tools_image

    @tools_image.setter
    def tools_image(self, tools_image: str):
        """Sets the tools_image of this BatchConfig.

        ODAHU tools image  # noqa: E501

        :param tools_image: The tools_image of this BatchConfig.
        :type tools_image: str
        """

        self._tools_image = tools_image

    @property
    def tools_secret(self) -> str:
        """Gets the tools_secret of this BatchConfig.

        ODAHU tools image  # noqa: E501

        :return: The tools_secret of this BatchConfig.
        :rtype: str
        """
        return self._tools_secret

    @tools_secret.setter
    def tools_secret(self, tools_secret: str):
        """Sets the tools_secret of this BatchConfig.

        ODAHU tools image  # noqa: E501

        :param tools_secret: The tools_secret of this BatchConfig.
        :type tools_secret: str
        """

        self._tools_secret = tools_secret
