# generated by datamodel-codegen:
#   filename:  All.json

from __future__ import annotations

from datetime import date, datetime
from typing import Any, Literal
from uuid import UUID

from pydantic import Field

from pyconnectwise.models.base.connectwise_model import ConnectWiseModel


class AccountingBatch(ConnectWiseModel):
    id: int | None = None
    batch_identifier: str | None = Field(default=None, alias='batchIdentifier')
    export_invoices_flag: bool | None = Field(default=None, alias='exportInvoicesFlag')
    export_expenses_flag: bool | None = Field(default=None, alias='exportExpensesFlag')
    export_products_flag: bool | None = Field(default=None, alias='exportProductsFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AccountingPackage(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None


class AccountingPackageReference(ConnectWiseModel):
    id: int | None = None
    identifier: Literal[
        'QB99', 'Mas200', 'GPlains', 'SBA', 'Mas200v4', 'Other'
    ] | None = None
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AccountingPackageSetup(ConnectWiseModel):
    id: int | None = None
    accounting_package: AccountingPackageReference | None = Field(
        default=None, alias='accountingPackage'
    )
    direct_transfer_flag: bool | None = Field(default=None, alias='directTransferFlag')
    include_invoices_flag: bool | None = Field(
        default=None, alias='includeInvoicesFlag'
    )
    invoice_format: Literal['Default', 'Condensed', 'Detailed'] | None = Field(
        default=None, alias='invoiceFormat'
    )
    include_expenses_flag: bool | None = Field(
        default=None, alias='includeExpensesFlag'
    )
    transfer_expenses_as_bill_flag: bool | None = Field(
        default=None, alias='transferExpensesAsBillFlag'
    )
    expense_format: Literal['Default', 'Condensed'] | None = Field(
        default=None, alias='expenseFormat'
    )
    suppress_memo_flag: bool | None = Field(default=None, alias='suppressMemoFlag')
    sync_payment_info_flag: bool | None = Field(
        default=None, alias='syncPaymentInfoFlag'
    )
    sync_wise_pay_payment_info_flag: bool | None = Field(
        default=None, alias='syncWisePayPaymentInfoFlag'
    )
    wise_pay_lab_flag: bool | None = Field(default=None, alias='wisePayLabFlag')
    include_sales_tax_flag: bool | None = Field(
        default=None, alias='includeSalesTaxFlag'
    )
    enable_tax_groups_flag: bool | None = Field(
        default=None, alias='enableTaxGroupsFlag'
    )
    zero_dollar_tax_amounts_flag: bool | None = Field(
        default=None, alias='zeroDollarTaxAmountsFlag'
    )
    include_items_flag: bool | None = Field(default=None, alias='includeItemsFlag')
    inventory_soh_flag: bool | None = Field(default=None, alias='inventorySOHFlag')
    send_component_amount_flag: bool | None = Field(
        default=None, alias='sendComponentAmountFlag'
    )
    send_uom_flag: bool | None = Field(default=None, alias='sendUomFlag')
    include_cogs_entries_flag: bool | None = Field(
        default=None, alias='includeCogsEntriesFlag'
    )
    include_cogs_drop_ship_flag: bool | None = Field(
        default=None, alias='includeCogsDropShipFlag'
    )


class ActivityReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ActivityStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    spawn_followup_flag: bool | None = Field(default=None, alias='spawnFollowupFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ActivityStatusInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ActivityStatusReference(ActivityReference):
    pass


class ActivityType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    points: int | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    email_flag: bool | None = Field(default=None, alias='emailFlag')
    memo_flag: bool | None = Field(default=None, alias='memoFlag')
    history_flag: bool | None = Field(default=None, alias='historyFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ActivityTypeReference(ActivityReference):
    pass


class AddressFormat(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    format: str
    """
     Max length: 250;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    country_ids: list[int] | None = Field(default=None, alias='countryIds')
    add_all_countries: bool | None = Field(default=None, alias='addAllCountries')
    remove_all_countries: bool | None = Field(default=None, alias='removeAllCountries')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AddressFormatInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AddressFormatReference(ActivityReference):
    pass


class AdjustmentDetailReference(ActivityReference):
    pass


class AdjustmentReference(ActivityReference):
    pass


class AdjustmentType(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 50;
    """
    name: str | None = None
    """
     Max length: 100;
    """
    audit_trail_flag: bool | None = Field(default=None, alias='auditTrailFlag')
    date_created: datetime | None = Field(default=None, alias='dateCreated')
    created_by: str | None = Field(default=None, alias='createdBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AdjustmentTypeInfo(ActivityReference):
    pass


class AdjustmentTypeReference(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementApplicationAviablePer(ConnectWiseModel):
    id: int | None = None
    tag: str | None = None
    name: str | None = None


class AgreementApplicationBillingCycle(AgreementApplicationAviablePer):
    pass


class AgreementApplicationLimit(AgreementApplicationAviablePer):
    pass


class AgreementApplicationUnit(AgreementApplicationAviablePer):
    pass


class AgreementBatchSetup(ConnectWiseModel):
    id: int | None = None
    next_run_date: datetime = Field(..., alias='nextRunDate')
    days_in_advance: int = Field(..., alias='daysInAdvance')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementBillingInfo(ConnectWiseModel):
    agreement_name: str | None = Field(default=None, alias='agreementName')
    agreement_type: str | None = Field(default=None, alias='agreementType')
    agreement_amount: float | None = Field(default=None, alias='agreementAmount')
    agreement_rec_id: int | None = Field(default=None, alias='agreementRecId')
    parent_rec_id: int | None = Field(default=None, alias='parentRecId')


class AgreementRecap(ConnectWiseModel):
    id: int | None = None
    adjustment_amount: float | None = Field(default=None, alias='adjustmentAmount')
    agreement_status: str | None = Field(default=None, alias='agreementStatus')
    name: str | None = None
    available_amount: float | None = Field(default=None, alias='availableAmount')
    company_name: str | None = Field(default=None, alias='companyName')
    is_unlimited: str | None = Field(default=None, alias='isUnlimited')
    last_invoice_amount: str | None = Field(default=None, alias='lastInvoiceAmount')
    last_invoice_date: str | None = Field(default=None, alias='lastInvoiceDate')
    last_invoice_number: str | None = Field(default=None, alias='lastInvoiceNumber')
    next_invoice_amount: float | None = Field(default=None, alias='nextInvoiceAmount')
    next_invoice_date: str | None = Field(default=None, alias='nextInvoiceDate')
    overrun_amount: float | None = Field(default=None, alias='overrunAmount')
    remaining_amount: float | None = Field(default=None, alias='remainingAmount')
    starting_amount: float | None = Field(default=None, alias='startingAmount')
    unbilled_overage_amount: float | None = Field(
        default=None, alias='unbilledOverageAmount'
    )
    unbilled_periods: int | None = Field(default=None, alias='unbilledPeriods')
    used_amount: float | None = Field(default=None, alias='usedAmount')


class AgreementReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    type: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementRevenueReference(ConnectWiseModel):
    id: int | None = None
    revenue: float | None = None
    cost: float | None = None
    margin: float | None = None
    percentage: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    application_units: Literal['Amount', 'Hours', 'Incidents'] | None = Field(
        default=None, alias='applicationUnits'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeReference(ActivityReference):
    pass


class AllowedFileType(ConnectWiseModel):
    id: int | None = None
    file_type: str = Field(..., alias='fileType')
    size_limit: int | None = Field(default=None, alias='sizeLimit')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AllowedOrigin(ConnectWiseModel):
    id: int | None = None
    origin: str
    """
     Max length: 2000;
    """
    description: str
    """
     Max length: 2000;
    """
    last_update_utc: datetime | None = Field(default=None, alias='lastUpdateUtc')
    updated_by: str | None = Field(default=None, alias='updatedBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AuditTrailEntry(ConnectWiseModel):
    text: str | None = None
    entered_date: str | None = Field(default=None, alias='enteredDate')
    entered_by: str | None = Field(default=None, alias='enteredBy')
    audit_type: str | None = Field(default=None, alias='auditType')
    audit_sub_type: str | None = Field(default=None, alias='auditSubType')
    audit_source: str | None = Field(default=None, alias='auditSource')


class AuthAnvil(ConnectWiseModel):
    id: int | None = None
    server_location_url: str = Field(..., alias='serverLocationUrl')
    site_id: int = Field(..., alias='siteId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AutomateScriptReference(ActivityReference):
    pass


class BillingCycle(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 5;
    """
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    billing_options: Literal[
        'BiMonthly',
        'BiWeekly',
        'Monthly',
        'NotRecurring',
        'Quarterly',
        'SemiAnnual',
        'Weekly',
        'Yearly',
    ] = Field(..., alias='billingOptions')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingCycleInfo(AddressFormatInfo):
    pass


class BillingCycleReference(ActivityReference):
    pass


class BillingDeliveryReference(ActivityReference):
    pass


class BillingSetupReference(ActivityReference):
    pass


class BillingStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    sort_order: int | None = Field(default=None, alias='sortOrder')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    sent_flag: bool | None = Field(default=None, alias='sentFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingStatusInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingStatusReference(ActivityReference):
    pass


class BillingTerm(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    due_days: int = Field(..., alias='dueDays')
    terms_xref: str | None = Field(default=None, alias='termsXref')
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingTermInfo(ActivityReference):
    pass


class BillingTermsReference(ActivityReference):
    pass


class BoardCopy(ConnectWiseModel):
    id: int
    name: str
    """
     Max length: 50;
    """


class BoardExcludedMember(ConnectWiseModel):
    id: int | None = None
    member_id: int | None = Field(default=None, alias='memberId')
    board_id: int | None = Field(default=None, alias='boardId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardReference(ActivityReference):
    pass


class BoardStatusInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardSubType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    type_association_ids: list[int] | None = Field(
        default=None, alias='typeAssociationIds'
    )
    add_all_types_flag: bool | None = Field(default=None, alias='addAllTypesFlag')
    remove_all_types_flag: bool | None = Field(default=None, alias='removeAllTypesFlag')
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardSubTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    type_association_ids: list[int] | None = Field(
        default=None, alias='typeAssociationIds'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardTeamInfo(ActivityReference):
    pass


class BoardTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    board: BoardReference | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CalendarInfo(ActivityReference):
    pass


class CalendarReference(ActivityReference):
    pass


class CalendarSetupReference(ConnectWiseModel):
    id: int | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CallbackEntry(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    """
     Max length: 100;
    """
    url: str | None = None
    """
     Required Reference
    """
    object_id: int | None = Field(default=None, alias='objectId')
    """
     Required Reference
    """
    type: str | None = None
    """
     Required Reference
    """
    level: str | None = None
    """
     Required Reference
    """
    member_id: int | None = Field(default=None, alias='memberId')
    payload_version: str | None = Field(default=None, alias='payloadVersion')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    is_soap_callback_flag: bool | None = Field(default=None, alias='isSoapCallbackFlag')
    is_self_suppressed_flag: bool | None = Field(
        default=None, alias='isSelfSuppressedFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CampaignReference(ActivityReference):
    pass


class CampaignStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CampaignStatusReference(ActivityReference):
    pass


class CampaignSubTypeReference(ActivityReference):
    pass


class CampaignType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CampaignTypeInfo(ActivityReference):
    pass


class CampaignTypeReference(ActivityReference):
    pass


class CatalogItemInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    description: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    product_class: Literal[
        'Agreement', 'Bundle', 'Inventory', 'NonInventory', 'Service'
    ] | None = Field(default=None, alias='productClass')
    serialized_cost_flag: bool | None = Field(default=None, alias='serializedCostFlag')
    price: float | None = None
    cost: float | None = None
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    drop_ship_flag: bool | None = Field(default=None, alias='dropShipFlag')
    special_order_flag: bool | None = Field(default=None, alias='specialOrderFlag')
    customer_description: str | None = Field(default=None, alias='customerDescription')
    manufacturer_part_number: str | None = Field(
        default=None, alias='manufacturerPartNumber'
    )
    vendor_sku: str | None = Field(default=None, alias='vendorSku')
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CatalogItemReference(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Category(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    price_level_xref: str | None = Field(default=None, alias='priceLevelXref')
    """
     Max length: 10;
    """
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    add_all_locations: bool | None = Field(default=None, alias='addAllLocations')
    remove_all_locations: bool | None = Field(default=None, alias='removeAllLocations')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CategoryInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CertificationReference(ActivityReference):
    pass


class ChargeCodeReference(ActivityReference):
    pass


class Classification(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    multiplier: float | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    company_flag: bool | None = Field(default=None, alias='companyFlag')
    employee_flag: bool | None = Field(default=None, alias='employeeFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ClassificationReference(ActivityReference):
    pass


class ClosedInvoice(ConnectWiseModel):
    id: int | None = None
    status: BillingStatusReference | None = None
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Code(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    description: str
    board_id: int | None = Field(default=None, alias='boardId')
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CommunicationType(ConnectWiseModel):
    id: int | None = None
    description: str
    phone_flag: bool | None = Field(default=None, alias='phoneFlag')
    """
    Gets or sets at least one flag is required to be true -- phone, fax, or email.
    """
    fax_flag: bool | None = Field(default=None, alias='faxFlag')
    """
    Gets or sets at least one flag is required to be true -- phone, fax, or email.
    """
    email_flag: bool | None = Field(default=None, alias='emailFlag')
    """
    Gets or sets at least one flag is required to be true -- phone, fax, or email.
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    exchange_xref: str | None = Field(default=None, alias='exchangeXref')
    """
     Max length: 50;
    """
    iphone_xref: str | None = Field(default=None, alias='iphoneXref')
    """
     Max length: 50;
    """
    android_xref: str | None = Field(default=None, alias='androidXref')
    """
     Max length: 50;
    """
    google_xref: str | None = Field(default=None, alias='googleXref')
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CommunicationTypeInfo(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    phone_flag: bool | None = Field(default=None, alias='phoneFlag')
    fax_flag: bool | None = Field(default=None, alias='faxFlag')
    email_flag: bool | None = Field(default=None, alias='emailFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CommunicationTypeReference(ActivityReference):
    pass


class CompanyMerge(ConnectWiseModel):
    to_company_id: int = Field(..., alias='toCompanyId')
    name: Literal['From', 'To'] | None = None
    identifier: Literal['From', 'To'] | None = None
    status: Literal['From', 'To'] | None = None
    type: Literal['From', 'To'] | None = None
    primary_address: Literal['From', 'To'] | None = Field(
        default=None, alias='primaryAddress'
    )
    primary_contact: Literal['From', 'To'] | None = Field(
        default=None, alias='primaryContact'
    )
    phone: Literal['From', 'To'] | None = None
    fax: Literal['From', 'To'] | None = None
    website: Literal['From', 'To'] | None = None
    market: Literal['From', 'To'] | None = None
    territory: Literal['From', 'To'] | None = None
    revenue: Literal['From', 'To'] | None = None
    revenue_year: Literal['From', 'To'] | None = Field(
        default=None, alias='revenueYear'
    )
    number_of_employees: Literal['From', 'To'] | None = Field(
        default=None, alias='numberOfEmployees'
    )
    sic_code: Literal['From', 'To'] | None = Field(default=None, alias='sicCode')
    date_acquired: Literal['From', 'To'] | None = Field(
        default=None, alias='dateAcquired'
    )
    time_zone: Literal['From', 'To'] | None = Field(default=None, alias='timeZone')
    source_list: Literal['From', 'To'] | None = Field(default=None, alias='sourceList')
    user_defined_field1: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField1'
    )
    user_defined_field2: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField2'
    )
    user_defined_field3: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField3'
    )
    user_defined_field4: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField4'
    )
    user_defined_field5: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField5'
    )
    user_defined_field6: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField6'
    )
    user_defined_field7: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField7'
    )
    user_defined_field8: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField8'
    )
    user_defined_field9: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField9'
    )
    user_defined_field10: Literal['From', 'To'] | None = Field(
        default=None, alias='userDefinedField10'
    )
    billing_address: Literal['From', 'To'] | None = Field(
        default=None, alias='billingAddress'
    )
    billing_contact: Literal['From', 'To'] | None = Field(
        default=None, alias='billingContact'
    )
    tax_code: Literal['From', 'To'] | None = Field(default=None, alias='taxCode')
    account_number: Literal['From', 'To'] | None = Field(
        default=None, alias='accountNumber'
    )
    billing_terms: Literal['From', 'To'] | None = Field(
        default=None, alias='billingTerms'
    )
    notes: Literal['Discard', 'Merge'] | None = None
    sites: Literal['Discard', 'Merge'] | None = None
    activities: Literal['Discard', 'Merge'] | None = None
    opportunities: Literal['Discard', 'Merge'] | None = None
    services: Literal['Discard', 'Merge'] | None = None
    projects: Literal['Discard', 'Merge'] | None = None
    contacts: Literal['Discard', 'Merge'] | None = None
    documents: Literal['Discard', 'Merge'] | None = None


class CompanyNoteType(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    """
     Max length: 15;
    """
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    import_flag: bool | None = Field(default=None, alias='importFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyNoteTypeInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyReference(CatalogItemReference):
    pass


class CompanyStatusReference(ActivityReference):
    pass


class CompanyType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    vendor_flag: bool | None = Field(default=None, alias='vendorFlag')
    service_alert_flag: bool | None = Field(default=None, alias='serviceAlertFlag')
    service_alert_message: str | None = Field(default=None, alias='serviceAlertMessage')
    """
     Max length: 150;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    is_vendor: bool | None = Field(default=None, alias='isVendor')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyTypeReference(ActivityReference):
    pass


class ConfigurationQuestion(ConnectWiseModel):
    answer_id: int | None = Field(default=None, alias='answerId')
    question_id: int | None = Field(default=None, alias='questionId')
    question: str | None = None
    answer: dict[str, Any] | None = None
    sequence_number: float | None = Field(default=None, alias='sequenceNumber')
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    field_type: Literal[
        'TextArea',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] | None = Field(default=None, alias='fieldType')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')


class ConfigurationReference(ConnectWiseModel):
    id: int | None = None
    device_identifier: str | None = Field(default=None, alias='deviceIdentifier')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationStatus(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 50;
    """
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationStatusInfo(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationStatusReference(ActivityReference):
    pass


class ConfigurationType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    system_flag: bool | None = Field(default=None, alias='systemFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeCopy(BoardCopy):
    pass


class ConfigurationTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    system_flag: bool | None = Field(default=None, alias='systemFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeQuestionReference(ConnectWiseModel):
    id: int | None = None
    question: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeReference(ActivityReference):
    pass


class ConnectWiseHostedScreen(ConnectWiseModel):
    id: int | None = None
    screen_id: str | None = Field(default=None, alias='screenId')
    name: str | None = None


class ConnectWiseHostedSetup(ConnectWiseModel):
    id: int | None = None
    screen_id: int = Field(..., alias='screenId')
    """
    Can be obtained via ConnectWiseHostedApiScreen report.
    """
    description: str
    """
     Max length: 50;
    """
    url: str
    """
     Max length: 1024;
    """
    type: Literal['Tab', 'Pod', 'ToolbarButton']
    client_id: str | None = Field(default=None, alias='clientId')
    """
    Only required if not already set. Max length: 36;
    """
    origin: str | None = None
    """
     Max length: 100;
    """
    pod_height: int | None = Field(default=None, alias='podHeight')
    toolbar_button_dialog_height: int | None = Field(
        default=None, alias='toolbarButtonDialogHeight'
    )
    toolbar_button_dialog_width: int | None = Field(
        default=None, alias='toolbarButtonDialogWidth'
    )
    toolbar_button_text: str | None = Field(default=None, alias='toolbarButtonText')
    """
    Only required for ToolbarButtons. Max length: 50;
    """
    toolbar_button_tool_tip: str | None = Field(
        default=None, alias='toolbarButtonToolTip'
    )
    """
     Max length: 50;
    """
    toolbar_button_icon_document_id: int | None = Field(
        default=None, alias='toolbarButtonIconDocumentId'
    )
    disabled_flag: bool | None = Field(default=None, alias='disabledFlag')
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    locations_enabled_flag: bool | None = Field(
        default=None, alias='locationsEnabledFlag'
    )
    created_by: str | None = Field(default=None, alias='createdBy')
    date_created: str | None = Field(default=None, alias='dateCreated')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactCommunication(ConnectWiseModel):
    id: int | None = None
    contact_id: int | None = Field(default=None, alias='contactId')
    type: CommunicationTypeReference | None = None
    value: str
    """
     Max length: 250;
    """
    extension: str | None = None
    """
     Max length: 15;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    communication_type: Literal['Email', 'Fax', 'Phone'] | None = Field(
        default=None, alias='communicationType'
    )
    domain: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactCommunicationItem(ConnectWiseModel):
    id: int | None = None
    type: CommunicationTypeReference | None = None
    value: str | None = None
    extension: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    domain: str | None = None
    communication_type: Literal['Email', 'Fax', 'Phone'] | None = Field(
        default=None, alias='communicationType'
    )


class ContactDepartment(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactDepartmentInfo(ActivityReference):
    pass


class ContactDepartmentReference(ActivityReference):
    pass


class ContactReference(ActivityReference):
    pass


class ContactRelationship(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactTrack(ConnectWiseModel):
    id: int | None = None
    track_id: int | None = Field(default=None, alias='trackId')
    name: str | None = None
    start_date: str | None = Field(default=None, alias='startDate')
    end_date: str | None = Field(default=None, alias='endDate')
    action_taken: int | None = Field(default=None, alias='actionTaken')
    action_remaining: int | None = Field(default=None, alias='actionRemaining')
    started_by: str | None = Field(default=None, alias='startedBy')
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactType(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    service_alert_flag: bool | None = Field(default=None, alias='serviceAlertFlag')
    service_alert_message: str | None = Field(default=None, alias='serviceAlertMessage')
    """
     Max length: 150;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactTypeInfo(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    service_alert_flag: bool | None = Field(default=None, alias='serviceAlertFlag')
    service_alert_message: str | None = Field(default=None, alias='serviceAlertMessage')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactTypeReference(ActivityReference):
    pass


class CorporateStructureLevel(ConnectWiseModel):
    id: int | None = None
    name: str | None = None


class CorporateStructureLevelReference(ActivityReference):
    pass


class Count(ConnectWiseModel):
    count: int | None = None


class CountryInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    city_caption: str | None = Field(default=None, alias='cityCaption')
    state_caption: str | None = Field(default=None, alias='stateCaption')
    zip_caption: str | None = Field(default=None, alias='zipCaption')
    dialing_prefix: str | None = Field(default=None, alias='dialingPrefix')
    localization_caption_one: str | None = Field(
        default=None, alias='localizationCaptionOne'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CountryReference(CatalogItemReference):
    pass


class CreateAccountingBatchRequest(ConnectWiseModel):
    id: int | None = None
    batch_identifier: str | None = Field(default=None, alias='batchIdentifier')
    """
     Max length: 50;
    """
    gl_interface_identifier: str | None = Field(
        default=None, alias='glInterfaceIdentifier'
    )
    export_invoices_flag: bool | None = Field(default=None, alias='exportInvoicesFlag')
    """
    Batch must export Invoices, Expenses or Products.
    """
    export_expenses_flag: bool | None = Field(default=None, alias='exportExpensesFlag')
    """
    Batch must export Invoices, Expenses or Products.
    """
    export_products_flag: bool | None = Field(default=None, alias='exportProductsFlag')
    """
    Batch must export Invoices, Expenses or Products.
    """
    processed_record_ids: list[int] = Field(..., alias='processedRecordIds')
    """
    GL Entry RecIDs.
    """
    summarize_expenses: bool | None = Field(default=None, alias='summarizeExpenses')


class CurrencyCode(ActivityReference):
    pass


class CurrencyCodeReference(ActivityReference):
    pass


class CurrencyInfo(ActivityReference):
    pass


class CurrencyReference(ConnectWiseModel):
    id: int | None = None
    symbol: str | None = None
    currency_code: str | None = Field(default=None, alias='currencyCode')
    decimal_separator: str | None = Field(default=None, alias='decimalSeparator')
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    thousands_separator: str | None = Field(default=None, alias='thousandsSeparator')
    negative_parentheses_flag: bool | None = Field(
        default=None, alias='negativeParenthesesFlag'
    )
    display_symbol_flag: bool | None = Field(default=None, alias='displaySymbolFlag')
    currency_identifier: str | None = Field(default=None, alias='currencyIdentifier')
    display_id_flag: bool | None = Field(default=None, alias='displayIdFlag')
    right_align: bool | None = Field(default=None, alias='rightAlign')
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CustomFieldValue(ConnectWiseModel):
    id: int | None = None
    caption: str | None = None
    type: Literal[
        'TextArea',
        'Button',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] | None = None
    entry_method: Literal['Date', 'EntryField', 'List', 'Option'] | None = Field(
        default=None, alias='entryMethod'
    )
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    value: str | bool | int | None = None


class CustomReport(ConnectWiseModel):
    id: int | None = None
    report_link: str = Field(..., alias='reportLink')
    name: str
    """
     Max length: 100;
    """
    module: Literal[
        'Companies',
        'Finance',
        'Marketing',
        'Procurement',
        'Project',
        'Sales',
        'ServiceDesk',
        'TimeExpense',
    ]
    """
    The Module Name.
    """
    description: str
    """
     Max length: 150;
    """
    generated_flag: bool | None = Field(default=None, alias='generatedFlag')
    parameter_prefix: str | None = Field(default=None, alias='parameterPrefix')
    """
     Max length: 50;
    """
    parameter_separator: str | None = Field(default=None, alias='parameterSeparator')
    """
     Max length: 50;
    """
    parameter_name_separator: str | None = Field(
        default=None, alias='parameterNameSeparator'
    )
    """
     Max length: 50;
    """
    parameter_suffix: str | None = Field(default=None, alias='parameterSuffix')
    """
     Max length: 50;
    """
    location_flag: bool | None = Field(default=None, alias='locationFlag')
    location_param_id: int | None = Field(default=None, alias='locationParamId')
    """
    Parameter unique identifier for the Custom Report's Location parameter.
    """
    location_default_flag: bool | None = Field(
        default=None, alias='locationDefaultFlag'
    )
    location_override: str | None = Field(default=None, alias='locationOverride')
    department_flag: bool | None = Field(default=None, alias='departmentFlag')
    department_param_id: int | None = Field(default=None, alias='departmentParamId')
    """
    Parameter unique identifier for the Custom Report's Department parameter.
    """
    department_default_flag: bool | None = Field(
        default=None, alias='departmentDefaultFlag'
    )
    department_override: str | None = Field(default=None, alias='departmentOverride')
    territory_flag: bool | None = Field(default=None, alias='territoryFlag')
    territory_param_id: int | None = Field(default=None, alias='territoryParamId')
    """
    Parameter unique identifier for the Custom Report's Terriroty parameter.
    """
    territory_default_flag: bool | None = Field(
        default=None, alias='territoryDefaultFlag'
    )
    territory_override: str | None = Field(default=None, alias='territoryOverride')
    company_flag: bool | None = Field(default=None, alias='companyFlag')
    company_param_id: int | None = Field(default=None, alias='companyParamId')
    """
    Parameter unique identifier for the Custom Report's Company parameter.
    """
    company_override: str | None = Field(default=None, alias='companyOverride')
    member_flag: bool | None = Field(default=None, alias='memberFlag')
    member_param_id: int | None = Field(default=None, alias='memberParamId')
    """
    Parameter unique identifier for the Custom Report's Member parameter.
    """
    member_override: str | None = Field(default=None, alias='memberOverride')
    start_date_flag: bool | None = Field(default=None, alias='startDateFlag')
    start_date_param_id: int | None = Field(default=None, alias='startDateParamId')
    """
    Parameter unique identifier for the Custom Report's Start Date parameter.
    """
    start_date_override: str | None = Field(default=None, alias='startDateOverride')
    end_date_flag: bool | None = Field(default=None, alias='endDateFlag')
    end_date_param_id: int | None = Field(default=None, alias='endDateParamId')
    """
    Parameter unique identifier for the Custom Report's End Date parameter.
    """
    end_date_override: str | None = Field(default=None, alias='endDateOverride')
    opp_type_flag: bool | None = Field(default=None, alias='oppTypeFlag')
    opp_type_param_id: int | None = Field(default=None, alias='oppTypeParamId')
    """
    Parameter unique identifier for the Custom Report's Opportunity Type parameter.
    """
    opp_type_override: str | None = Field(default=None, alias='oppTypeOverride')
    opportunity_flag: bool | None = Field(default=None, alias='opportunityFlag')
    opportunity_param_id: int | None = Field(default=None, alias='opportunityParamId')
    """
    Parameter unique identifier for the Custom Report's Opportunity parameter.
    """
    opportunity_override: str | None = Field(default=None, alias='opportunityOverride')
    marketing_campaign_flag: bool | None = Field(
        default=None, alias='marketingCampaignFlag'
    )
    marketing_campaign_param_id: int | None = Field(
        default=None, alias='marketingCampaignParamId'
    )
    """
    Parameter unique identifier for the Custom Report's Marketing Campaign parameter.
    """
    marketing_campaign_override: str | None = Field(
        default=None, alias='marketingCampaignOverride'
    )
    service_board_flag: bool | None = Field(default=None, alias='serviceBoardFlag')
    service_board_param_id: int | None = Field(
        default=None, alias='serviceBoardParamId'
    )
    """
    Parameter unique identifier for the Custom Report's Service Board parameter.
    """
    service_board_default_flag: bool | None = Field(
        default=None, alias='serviceBoardDefaultFlag'
    )
    service_board_override: str | None = Field(
        default=None, alias='serviceBoardOverride'
    )
    service_type_flag: bool | None = Field(default=None, alias='serviceTypeFlag')
    service_type_param_id: int | None = Field(default=None, alias='serviceTypeParamId')
    """
    Parameter unique identifier for the Custom Report's Service Type parameter.
    """
    service_type_override: str | None = Field(default=None, alias='serviceTypeOverride')
    service_status_flag: bool | None = Field(default=None, alias='serviceStatusFlag')
    service_status_param_id: int | None = Field(
        default=None, alias='serviceStatusParamId'
    )
    """
    Parameter unique identifier for the Custom Report's Service Status parameter.
    """
    service_status_override: str | None = Field(
        default=None, alias='serviceStatusOverride'
    )
    agreement_type_flag: bool | None = Field(default=None, alias='agreementTypeFlag')
    agreement_type_param_id: int | None = Field(
        default=None, alias='agreementTypeParamId'
    )
    """
    Parameter unique identifier for the Custom Report's Agreement Type parameter.
    """
    agreement_type_override: str | None = Field(
        default=None, alias='agreementTypeOverride'
    )
    agreement_flag: bool | None = Field(default=None, alias='agreementFlag')
    agreement_param_id: int | None = Field(default=None, alias='agreementParamId')
    """
    Parameter unique identifier for the Custom Report's Agreement parameter.
    """
    agreement_override: str | None = Field(default=None, alias='agreementOverride')
    project_type_flag: bool | None = Field(default=None, alias='projectTypeFlag')
    project_type_param_id: int | None = Field(default=None, alias='projectTypeParamId')
    """
    Parameter unique identifier for the Custom Report's Project Type parameter.
    """
    project_type_override: str | None = Field(default=None, alias='projectTypeOverride')
    project_flag: bool | None = Field(default=None, alias='projectFlag')
    project_param_id: int | None = Field(default=None, alias='projectParamId')
    """
    Parameter unique identifier for the Custom Report's Project parameter.
    """
    project_override: str | None = Field(default=None, alias='projectOverride')
    work_role_flag: bool | None = Field(default=None, alias='workRoleFlag')
    work_role_param_id: int | None = Field(default=None, alias='workRoleParamId')
    """
    Parameter unique identifier for the Custom Report's Work Role parameter.
    """
    work_role_override: str | None = Field(default=None, alias='workRoleOverride')
    work_type_flag: bool | None = Field(default=None, alias='workTypeFlag')
    work_type_param_id: int | None = Field(default=None, alias='workTypeParamId')
    """
    Parameter unique identifier for the Custom Report's Work Type parameter.
    """
    work_type_override: str | None = Field(default=None, alias='workTypeOverride')
    invoice_flag: bool | None = Field(default=None, alias='invoiceFlag')
    invoice_param_id: int | None = Field(default=None, alias='invoiceParamId')
    """
    Parameter unique identifier for the Custom Report's Invoice Type parameter.
    """
    invoice_override: str | None = Field(default=None, alias='invoiceOverride')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CustomReportReference(ActivityReference):
    pass


class CwTimeZone(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    offset: float | None = None
    """
    The hours offset (+/-).
    """
    start_date: str | None = Field(default=None, alias='startDate')
    end_date: str | None = Field(default=None, alias='endDate')
    daylight_savings_flag: bool | None = Field(
        default=None, alias='daylightSavingsFlag'
    )
    """
    Determined based on system library value for specified timeZone.
                Not able to be used in query params at this time.
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DeliveryMethod(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    email_flag: bool | None = Field(default=None, alias='emailFlag')
    integration_email_flag: bool | None = Field(
        default=None, alias='integrationEmailFlag'
    )
    integration_print_flag: bool | None = Field(
        default=None, alias='integrationPrintFlag'
    )
    integration_active_flag: bool | None = Field(
        default=None, alias='integrationActiveFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Department(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 15;
    """
    name: str
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DepartmentInfo(ActivityReference):
    pass


class DirectionalSync(ContactRelationship):
    pass


class DirectionalSyncInfo(ActivityReference):
    pass


class DirectionalSyncReference(ActivityReference):
    pass


class DocumentFormData(ConnectWiseModel):
    file: bytes | None = None
    record_id: int | None = Field(default=None, alias='recordId')
    record_type: str | None = Field(default=None, alias='recordType')
    title: str | None = None
    url: str | None = None
    private_flag: bool | None = Field(default=None, alias='privateFlag')
    read_only_flay: bool | None = Field(default=None, alias='readOnlyFlay')
    is_avatar: bool | None = Field(default=None, alias='isAvatar')


class DocumentReference(ActivityReference):
    pass


class DocumentSetup(ConnectWiseModel):
    id: int | None = None
    upload_as_link_flag: bool | None = Field(default=None, alias='uploadAsLinkFlag')
    is_public_flag: bool | None = Field(default=None, alias='isPublicFlag')
    doc_path: str | None = Field(default=None, alias='docPath')
    """
     Max length: 100;
    """
    template_path: str | None = Field(default=None, alias='templatePath')
    """
     Max length: 200;
    """
    template_output_path: str | None = Field(default=None, alias='templateOutputPath')
    """
     Max length: 200;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DocumentType(ConnectWiseModel):
    id: int | None = None
    file_extension: str | None = Field(default=None, alias='fileExtension')
    icon: str | None = None
    mime_type: str | None = Field(default=None, alias='mimeType')
    description: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DocumentTypeReference(ActivityReference):
    pass


class EmailConnectorParsingStyleReference(ActivityReference):
    pass


class EmailConnectorParsingTypeReference(ActivityReference):
    pass


class EmailConnectorParsingVariableReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    identifier: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailConnectorReference(ActivityReference):
    pass


class EmailExclusion(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 100;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailOpened(ConnectWiseModel):
    id: int | None = None
    campaign_id: int | None = Field(default=None, alias='campaignId')
    contact_id: int = Field(..., alias='contactId')
    date_opened: datetime | None = Field(default=None, alias='dateOpened')


class EmailTemplateReference(ActivityReference):
    pass


class EmailToken(ConnectWiseModel):
    id: int | None = None
    token: str | None = None
    description: str | None = None
    address_flag: bool | None = Field(default=None, alias='addressFlag')
    agreement_flag: bool | None = Field(default=None, alias='agreementFlag')
    company_flag: bool | None = Field(default=None, alias='companyFlag')
    config_flag: bool | None = Field(default=None, alias='configFlag')
    contact_flag: bool | None = Field(default=None, alias='contactFlag')
    invoice_flag: bool | None = Field(default=None, alias='invoiceFlag')
    purchase_order_flag: bool | None = Field(default=None, alias='purchaseOrderFlag')
    purchase_order_status_flag: bool | None = Field(
        default=None, alias='purchaseOrderStatusFlag'
    )
    rma_flag: bool | None = Field(default=None, alias='rmaFlag')
    sales_flag: bool | None = Field(default=None, alias='salesFlag')
    service_flag: bool | None = Field(default=None, alias='serviceFlag')
    tracks_flag: bool | None = Field(default=None, alias='tracksFlag')
    workflow_flag: bool | None = Field(default=None, alias='workflowFlag')
    portal_password_flag: bool | None = Field(default=None, alias='portalPasswordFlag')


class EntityType(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    code: str | None = None


class EntityTypeInfo(CorporateStructureLevel):
    pass


class EntityTypeReference(ActivityReference):
    pass


class ExpenseDetailReference(ConnectWiseModel):
    id: int | None = None
    amount: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseReportReference(ActivityReference):
    pass


class ExpenseReportTierUpdate(ConnectWiseModel):
    id: int | None = None
    approval_type: Literal[
        'DataEntry',
        'Tier1Update',
        'Tier2Update',
        'Billing',
        'Service',
        'Project',
        'MonthlySummary',
        'SalesActivity',
        'Schedule',
    ] | None = Field(default=None, alias='approvalType')


class ExpenseRevenueReference(AgreementRevenueReference):
    pass


class ExpenseTaxTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive: bool | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseTaxTypeReference(ActivityReference):
    pass


class ExpenseType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    amount_caption: str = Field(..., alias='amountCaption')
    reimbursement_rate: float | None = Field(default=None, alias='reimbursementRate')
    bill_expenses: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billExpenses'
    )
    invoice_markup_option: Literal['Amount', 'Mile', 'Percent'] = Field(
        ..., alias='invoiceMarkupOption'
    )
    invoice_markup_amount: float | None = Field(
        default=None, alias='invoiceMarkupAmount'
    )
    advanced_amount_flag: bool | None = Field(default=None, alias='advancedAmountFlag')
    mileage_flag: bool | None = Field(default=None, alias='mileageFlag')
    quantity_flag: bool | None = Field(default=None, alias='quantityFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    max_amount: float | None = Field(default=None, alias='maxAmount')
    integration_x_ref: str | None = Field(default=None, alias='integrationXRef')
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    amount_caption: str | None = Field(default=None, alias='amountCaption')
    mileage_flag: bool | None = Field(default=None, alias='mileageFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseTypeReference(ActivityReference):
    pass


class Experiment(ConnectWiseModel):
    id: int | None = None
    experiment_id: str | None = Field(default=None, alias='experimentId')
    name: str | None = None
    description: str | None = None
    properties: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    member_inactive_flag: bool | None = Field(default=None, alias='memberInactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExportAccountingBatchRequest(ConnectWiseModel):
    batch_identifier: str | None = Field(default=None, alias='batchIdentifier')
    """
     Max length: 50;
    """
    gl_interface_identifier: str | None = Field(
        default=None, alias='glInterfaceIdentifier'
    )
    thru_date: datetime | None = Field(default=None, alias='thruDate')
    location_id: int | None = Field(default=None, alias='locationId')
    summarize_invoices: Literal['Default', 'Condensed', 'Detailed'] | None = Field(
        default=None, alias='summarizeInvoices'
    )
    export_invoices_flag: bool | None = Field(default=None, alias='exportInvoicesFlag')
    """
    Batch export must include invoices, expenses, or products (procurement).
    """
    included_invoice_ids: list[int] | None = Field(
        default=None, alias='includedInvoiceIds'
    )
    excluded_invoice_ids: list[int] | None = Field(
        default=None, alias='excludedInvoiceIds'
    )
    export_expenses_flag: bool | None = Field(default=None, alias='exportExpensesFlag')
    """
    Batch export must include invoices, expenses, or products (procurement).
    """
    included_expense_ids: list[int] | None = Field(
        default=None, alias='includedExpenseIds'
    )
    excluded_expense_ids: list[int] | None = Field(
        default=None, alias='excludedExpenseIds'
    )
    export_payments_flag: bool | None = Field(default=None, alias='exportPaymentsFlag')
    """
    Batch export must include invoices, expenses, or products (procurement).
    """
    included_payment_ids: list[int] | None = Field(
        default=None, alias='includedPaymentIds'
    )
    export_products_flag: bool | None = Field(default=None, alias='exportProductsFlag')
    """
    Batch export must include invoices, expenses, or products (procurement).
    """
    included_product_ids: list[str] | None = Field(
        default=None, alias='includedProductIds'
    )
    excluded_product_ids: list[str] | None = Field(
        default=None, alias='excludedProductIds'
    )


class FileUploadSetting(ConnectWiseModel):
    id: int | None = None
    restrict_file_types_flag: bool = Field(..., alias='restrictFileTypesFlag')
    global_file_size_limit: int | None = Field(
        default=None, alias='globalFileSizeLimit'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class FilterValues(ConnectWiseModel):
    conditions: str | None = None
    order_by: str | None = Field(default=None, alias='orderBy')
    childconditions: str | None = None
    customfieldconditions: str | None = None


class FinanceCurrency(ConnectWiseModel):
    id: int | None = None
    currency_identifier: str = Field(..., alias='currencyIdentifier')
    """
     Max length: 10;
    """
    name: str
    """
     Max length: 50;
    """
    symbol: str | None = None
    """
     Max length: 10;
    """
    display_id_flag: bool | None = Field(default=None, alias='displayIdFlag')
    display_symbol_flag: bool | None = Field(default=None, alias='displaySymbolFlag')
    currency_code: CurrencyCodeReference | None = Field(
        default=None, alias='currencyCode'
    )
    thousands_separator: str | None = Field(default=None, alias='thousandsSeparator')
    """
     Max length: 1;
    """
    decimal_separator: str | None = Field(default=None, alias='decimalSeparator')
    """
     Max length: 1;
    """
    negative_parentheses_flag: bool | None = Field(
        default=None, alias='negativeParenthesesFlag'
    )
    right_align: bool | None = Field(default=None, alias='rightAlign')
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    report_format: str | None = Field(default=None, alias='reportFormat')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ForecastRevenueReference(AgreementRevenueReference):
    pass


class FormSubmitted(ConnectWiseModel):
    id: int | None = None
    campaign_id: int | None = Field(default=None, alias='campaignId')
    contact_id: int = Field(..., alias='contactId')
    date_submitted: datetime | None = Field(default=None, alias='dateSubmitted')
    url: str
    """
     Max length: 2083;
    """
    query_string: str | None = Field(default=None, alias='queryString')
    page_type: str | None = Field(default=None, alias='pageType')
    page_sub_type: str | None = Field(default=None, alias='pageSubType')
    topic: str | None = None
    version: str | None = None
    status: str | None = None


class GenericBoardTeamReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    is_project_team_flag: bool | None = Field(default=None, alias='isProjectTeamFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GenericIdIdentifierReference(AccountingPackage):
    pass


class GenericNameIdDTO(AgreementApplicationAviablePer):
    pass


class GLCaption(ConnectWiseModel):
    id: int | None = None
    segment1: str | None = None
    """
     Max length: 255;
    """
    segment2: str | None = None
    """
     Max length: 255;
    """
    segment3: str | None = None
    """
     Max length: 255;
    """
    segment4: str | None = None
    """
     Max length: 255;
    """
    segment5: str | None = None
    """
     Max length: 255;
    """
    segment6: str | None = None
    """
     Max length: 255;
    """
    segment7: str | None = None
    """
     Max length: 255;
    """
    segment8: str | None = None
    """
     Max length: 255;
    """
    segment9: str | None = None
    """
     Max length: 255;
    """
    segment10: str | None = None
    """
     Max length: 255;
    """
    segment1type: Literal['Account', 'Class'] | None = None
    segment2type: Literal['Account', 'Class'] | None = None
    segment3type: Literal['Account', 'Class'] | None = None
    segment4type: Literal['Account', 'Class'] | None = None
    segment5type: Literal['Account', 'Class'] | None = None
    segment6type: Literal['Account', 'Class'] | None = None
    segment7type: Literal['Account', 'Class'] | None = None
    segment8type: Literal['Account', 'Class'] | None = None
    segment9type: Literal['Account', 'Class'] | None = None
    segment10type: Literal['Account', 'Class'] | None = None
    cogs1: str | None = None
    """
     Max length: 255;
    """
    cogs2: str | None = None
    """
     Max length: 255;
    """
    cogs3: str | None = None
    """
     Max length: 255;
    """
    cogs4: str | None = None
    """
     Max length: 255;
    """
    cogs5: str | None = None
    """
     Max length: 255;
    """
    cogs6: str | None = None
    """
     Max length: 255;
    """
    cogs7: str | None = None
    """
     Max length: 255;
    """
    cogs8: str | None = None
    """
     Max length: 255;
    """
    cogs9: str | None = None
    """
     Max length: 255;
    """
    cogs10: str | None = None
    """
     Max length: 255;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GLExportCustomerTaxLevel(ConnectWiseModel):
    tax_rate: float | None = Field(default=None, alias='taxRate')
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    agency_xref: str | None = Field(default=None, alias='agencyXref')
    tax_level: int | None = Field(default=None, alias='taxLevel')


class GLExportExpenseBillDetail(ConnectWiseModel):
    id: list[int] | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    memo: str | None = None
    company: CompanyReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    expense_class: ClassificationReference | None = Field(
        default=None, alias='expenseClass'
    )
    currency: CurrencyReference | None = None
    total: float | None = None
    billable: bool | None = None
    reimbursable: bool | None = None
    company_advance: bool | None = Field(default=None, alias='companyAdvance')


class GLExportInventoryTransferOffset(ConnectWiseModel):
    id: int | None = None
    document_type: str | None = Field(default=None, alias='documentType')
    document_date: str | None = Field(default=None, alias='documentDate')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_class: str | None = Field(default=None, alias='glClass')
    total: float | None = None
    memo: str | None = None
    description: str | None = None
    gl_type_id: str | None = Field(default=None, alias='glTypeId')


class GLExportPurchaseTransactionTaxLevel(ConnectWiseModel):
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    tax_level: int | None = Field(default=None, alias='taxLevel')


class GLExportSettings(ConnectWiseModel):
    pass


class GLExportTransactionDetailTaxLevel(ConnectWiseModel):
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    tax_level: int | None = Field(default=None, alias='taxLevel')


class GLExportTransactionTaxLevel(ConnectWiseModel):
    tax_amount: float | None = Field(default=None, alias='taxAmount')
    taxable_amount: float | None = Field(default=None, alias='taxableAmount')
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    tax_level: int | None = Field(default=None, alias='taxLevel')


class GoogleEmailSetup(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 200;
    """
    username: str
    """
     Max length: 100;
    """
    inbox_folder: str = Field(..., alias='inboxFolder')
    """
     Max length: 40;
    """
    processed_folder: str = Field(..., alias='processedFolder')
    """
     Max length: 40;
    """
    failed_folder: str = Field(..., alias='failedFolder')
    """
     Max length: 40;
    """
    client_id: str | None = Field(default=None, alias='clientId')
    """
     Max length: 200;
    """
    private_key: str | None = Field(default=None, alias='privateKey')
    """
     Max length: 4000;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    email_connector: EmailConnectorReference | None = Field(
        default=None, alias='emailConnector'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GoogleEmailSetupReference(ActivityReference):
    pass


class Group(ConnectWiseModel):
    id: int | None = None
    name: str
    public_description: str | None = Field(default=None, alias='publicDescription')
    """
     Max length: 255;
    """
    public_flag: bool | None = Field(default=None, alias='publicFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GroupInfo(ActivityReference):
    pass


class GroupReference(ActivityReference):
    pass


class HolidayList(ContactRelationship):
    pass


class HolidayListInfo(ActivityReference):
    pass


class HolidayListReference(ActivityReference):
    pass


class IdCollection(ConnectWiseModel):
    ids: list[int] | None = None


class Imap(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 200;
    """
    imap_name: str = Field(..., alias='imapName')
    """
     Max length: 40;
    """
    processed_name: str = Field(..., alias='processedName')
    """
     Max length: 40;
    """
    failed_folder: str = Field(..., alias='failedFolder')
    """
     Max length: 40;
    """
    server: str
    """
     Max length: 200;
    """
    user_name: str = Field(..., alias='userName')
    """
     Max length: 80;
    """
    password: str | None = None
    """
     Max length: 80;
    """
    port: int
    ssl_flag: bool | None = Field(default=None, alias='sslFlag')
    email_connector: EmailConnectorReference | None = Field(
        default=None, alias='emailConnector'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ImapInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    email_connector: EmailConnectorReference | None = Field(
        default=None, alias='emailConnector'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ImapSetupReference(ActivityReference):
    pass


class Impact(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    description: str
    """
     Max length: 200;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ImportMassMaintenance(ConnectWiseModel):
    deleted_contact_count: int | None = Field(default=None, alias='deletedContactCount')
    deleted_company_count: int | None = Field(default=None, alias='deletedCompanyCount')
    message: str | None = None
    success: bool | None = None


class InclusiveRevenueReference(AgreementRevenueReference):
    pass


class InOutType(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 30;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InOutTypeInfo(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InOutTypeReference(ActivityReference):
    pass


class IntegratorLoginReference(ActivityReference):
    pass


class IntegratorTag(ConnectWiseModel):
    id: int | None = None
    text: str
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class IntegratorTagCollection(ConnectWiseModel):
    tags: list[str] | None = None


class InvoiceEmailTemplateInfo(ActivityReference):
    pass


class InvoiceGroupingReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    description: str | None = None
    show_price_flag: bool | None = Field(default=None, alias='showPriceFlag')
    show_sub_items_flag: bool | None = Field(default=None, alias='showSubItemsFlag')
    group_parent_child_additions_flag: bool | None = Field(
        default=None, alias='groupParentChildAdditionsFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InvoiceReference(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    billing_type: str | None = Field(default=None, alias='billingType')
    apply_to_type: str | None = Field(default=None, alias='applyToType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InvoiceTemplate(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    margin_left: float | None = Field(default=None, alias='marginLeft')
    margin_right: float | None = Field(default=None, alias='marginRight')
    margin_top: float | None = Field(default=None, alias='marginTop')
    margin_bottom: float | None = Field(default=None, alias='marginBottom')
    logo_visible_flag: bool | None = Field(default=None, alias='logoVisibleFlag')
    header_logo_position: Literal['Center', 'LeftSide', 'RightSide'] | None = Field(
        default=None, alias='headerLogoPosition'
    )
    remit_to_visible_flag: bool | None = Field(default=None, alias='remitToVisibleFlag')
    header_address_position: Literal['Center', 'LeftSide', 'RightSide'] | None = Field(
        default=None, alias='headerAddressPosition'
    )
    header_title_visible_flag: bool | None = Field(
        default=None, alias='headerTitleVisibleFlag'
    )
    header_title_caption: str | None = Field(default=None, alias='headerTitleCaption')
    """
     Max length: 50;
    """
    header_title_position: Literal['Center', 'LeftSide', 'RightSide'] | None = Field(
        default=None, alias='headerTitlePosition'
    )
    header_title_font: Literal[
        'Regular', 'RegularBold', 'Large', 'LargeBold', 'ExtraLarge', 'ExtraLargeBold'
    ] | None = Field(default=None, alias='headerTitleFont')
    header_terms_visible_flag: bool | None = Field(
        default=None, alias='headerTermsVisibleFlag'
    )
    header_terms_caption: str | None = Field(default=None, alias='headerTermsCaption')
    """
     Max length: 50;
    """
    header_due_date_visible_flag: bool | None = Field(
        default=None, alias='headerDueDateVisibleFlag'
    )
    header_due_date_caption: str | None = Field(
        default=None, alias='headerDueDateCaption'
    )
    """
     Max length: 50;
    """
    header_po_number_visible_flag: bool | None = Field(
        default=None, alias='headerPoNumberVisibleFlag'
    )
    header_po_number_caption: str | None = Field(
        default=None, alias='headerPoNumberCaption'
    )
    """
     Max length: 50;
    """
    header_reference_visible_flag: bool | None = Field(
        default=None, alias='headerReferenceVisibleFlag'
    )
    header_reference_caption: str | None = Field(
        default=None, alias='headerReferenceCaption'
    )
    """
     Max length: 50;
    """
    header_account_visible_flag: bool | None = Field(
        default=None, alias='headerAccountVisibleFlag'
    )
    header_account_caption: str | None = Field(
        default=None, alias='headerAccountCaption'
    )
    """
     Max length: 50;
    """
    header_tax_id_visible_flag: bool | None = Field(
        default=None, alias='headerTaxIdVisibleFlag'
    )
    header_tax_id_caption: str | None = Field(default=None, alias='headerTaxIdCaption')
    """
     Max length: 50;
    """
    header_ship_to_visible_flag: bool | None = Field(
        default=None, alias='headerShipToVisibleFlag'
    )
    header_ship_to_caption: str | None = Field(
        default=None, alias='headerShipToCaption'
    )
    """
     Max length: 50;
    """
    header_hours_based_extended_amount_visible_flag: bool | None = Field(
        default=None, alias='headerHoursBasedExtendedAmountVisibleFlag'
    )
    payable_caption: str | None = Field(default=None, alias='payableCaption')
    """
     Max length: 1000;
    """
    service_header_ticket_number_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderTicketNumberVisibleFlag'
    )
    service_header_ticket_number_caption: str | None = Field(
        default=None, alias='serviceHeaderTicketNumberCaption'
    )
    """
     Max length: 50;
    """
    service_header_company_name_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderCompanyNameVisibleFlag'
    )
    service_header_company_name_caption: str | None = Field(
        default=None, alias='serviceHeaderCompanyNameCaption'
    )
    """
     Max length: 50;
    """
    service_header_summary_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderSummaryVisibleFlag'
    )
    service_header_summary_caption: str | None = Field(
        default=None, alias='serviceHeaderSummaryCaption'
    )
    """
     Max length: 50;
    """
    service_header_contact_name_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderContactNameVisibleFlag'
    )
    service_header_contact_name_caption: str | None = Field(
        default=None, alias='serviceHeaderContactNameCaption'
    )
    """
     Max length: 50;
    """
    service_header_detail_description_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderDetailDescriptionVisibleFlag'
    )
    service_header_detail_description_caption: str | None = Field(
        default=None, alias='serviceHeaderDetailDescriptionCaption'
    )
    """
     Max length: 50;
    """
    service_header_resolution_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderResolutionVisibleFlag'
    )
    service_header_resolution_caption: str | None = Field(
        default=None, alias='serviceHeaderResolutionCaption'
    )
    """
     Max length: 50;
    """
    service_header_amount_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderAmountVisibleFlag'
    )
    service_header_amount_caption: str | None = Field(
        default=None, alias='serviceHeaderAmountCaption'
    )
    """
     Max length: 50;
    """
    service_header_billing_method_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderBillingMethodVisibleFlag'
    )
    service_header_billing_method_caption: str | None = Field(
        default=None, alias='serviceHeaderBillingMethodCaption'
    )
    """
     Max length: 50;
    """
    service_header_closed_tasks_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderClosedTasksVisibleFlag'
    )
    service_header_open_tasks_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderOpenTasksVisibleFlag'
    )
    service_header_bundled_tickets_visible_flag: bool | None = Field(
        default=None, alias='serviceHeaderBundledTicketsVisibleFlag'
    )
    project_header_project_name_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderProjectNameVisibleFlag'
    )
    project_header_project_name_caption: str | None = Field(
        default=None, alias='projectHeaderProjectNameCaption'
    )
    """
     Max length: 50;
    """
    project_header_company_name_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderCompanyNameVisibleFlag'
    )
    project_header_company_name_caption: str | None = Field(
        default=None, alias='projectHeaderCompanyNameCaption'
    )
    """
     Max length: 50;
    """
    project_header_original_downpayment_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderOriginalDownpaymentVisibleFlag'
    )
    project_header_original_downpayment_caption: str | None = Field(
        default=None, alias='projectHeaderOriginalDownpaymentCaption'
    )
    """
     Max length: 50;
    """
    project_header_contact_name_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderContactNameVisibleFlag'
    )
    project_header_contact_name_caption: str | None = Field(
        default=None, alias='projectHeaderContactNameCaption'
    )
    """
     Max length: 50;
    """
    project_header_amount_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderAmountVisibleFlag'
    )
    project_header_amount_caption: str | None = Field(
        default=None, alias='projectHeaderAmountCaption'
    )
    """
     Max length: 50;
    """
    project_header_billing_method_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderBillingMethodVisibleFlag'
    )
    project_header_billing_method_caption: str | None = Field(
        default=None, alias='projectHeaderBillingMethodCaption'
    )
    """
     Max length: 50;
    """
    project_header_billing_type_visible_flag: bool | None = Field(
        default=None, alias='projectHeaderBillingTypeVisibleFlag'
    )
    project_header_billing_type_caption: str | None = Field(
        default=None, alias='projectHeaderBillingTypeCaption'
    )
    """
     Max length: 50;
    """
    invoice_payment_amount_visible_flag: bool | None = Field(
        default=None, alias='invoicePaymentAmountVisibleFlag'
    )
    invoice_payment_amount_caption: str | None = Field(
        default=None, alias='invoicePaymentAmountCaption'
    )
    """
     Max length: 50;
    """
    invoice_credit_amount_visible_flag: bool | None = Field(
        default=None, alias='invoiceCreditAmountVisibleFlag'
    )
    invoice_credit_amount_caption: str | None = Field(
        default=None, alias='invoiceCreditAmountCaption'
    )
    """
     Max length: 50;
    """
    invoice_balance_due_visible_flag: bool | None = Field(
        default=None, alias='invoiceBalanceDueVisibleFlag'
    )
    invoice_balance_due_caption: str | None = Field(
        default=None, alias='invoiceBalanceDueCaption'
    )
    """
     Max length: 50;
    """
    credit_credit_amount_visible_flag: bool | None = Field(
        default=None, alias='creditCreditAmountVisibleFlag'
    )
    credit_credit_amount_caption: str | None = Field(
        default=None, alias='creditCreditAmountCaption'
    )
    """
     Max length: 50;
    """
    credit_remaining_amount_visible_flag: bool | None = Field(
        default=None, alias='creditRemainingAmountVisibleFlag'
    )
    credit_remaining_amount_caption: str | None = Field(
        default=None, alias='creditRemainingAmountCaption'
    )
    """
     Max length: 50;
    """
    time_detail_visible_flag: bool | None = Field(
        default=None, alias='timeDetailVisibleFlag'
    )
    time_detail_primary_sort_field: str | None = Field(
        default=None, alias='timeDetailPrimarySortField'
    )
    time_detail_primary_sort_direction: str | None = Field(
        default=None, alias='timeDetailPrimarySortDirection'
    )
    time_detail_secondary_sort_field: str | None = Field(
        default=None, alias='timeDetailSecondarySortField'
    )
    time_detail_secondary_sort_direction: str | None = Field(
        default=None, alias='timeDetailSecondarySortDirection'
    )
    time_detail_subtotal_visible_flag: bool | None = Field(
        default=None, alias='timeDetailSubtotalVisibleFlag'
    )
    time_detail_start_end_time_visible_flag: bool | None = Field(
        default=None, alias='timeDetailStartEndTimeVisibleFlag'
    )
    time_detail_hours_visible_flag: bool | None = Field(
        default=None, alias='timeDetailHoursVisibleFlag'
    )
    time_detail_members_visible_flag: bool | None = Field(
        default=None, alias='timeDetailMembersVisibleFlag'
    )
    time_detail_billable_visible_flag: bool | None = Field(
        default=None, alias='timeDetailBillableVisibleFlag'
    )
    time_detail_extended_amount_visible_flag: bool | None = Field(
        default=None, alias='timeDetailExtendedAmountVisibleFlag'
    )
    time_detail_dollar_amounts_on_hourse_based_visible_flag: bool | None = Field(
        default=None, alias='timeDetailDollarAmountsOnHourseBasedVisibleFlag'
    )
    time_detail_hourly_rate_visible_flag: bool | None = Field(
        default=None, alias='timeDetailHourlyRateVisibleFlag'
    )
    time_detail_contacts_visible_flag: bool | None = Field(
        default=None, alias='timeDetailContactsVisibleFlag'
    )
    time_detail_notes_visible_flag: bool | None = Field(
        default=None, alias='timeDetailNotesVisibleFlag'
    )
    time_detail_non_billable_caption: str | None = Field(
        default=None, alias='timeDetailNonBillableCaption'
    )
    """
     Max length: 50;
    """
    time_detail_agreement_visible_flag: bool | None = Field(
        default=None, alias='timeDetailAgreementVisibleFlag'
    )
    time_detail_hours_based_hours_visible_flag: bool | None = Field(
        default=None, alias='timeDetailHoursBasedHoursVisibleFlag'
    )
    time_detail_hours_based_ext_amount_visible_flag: bool | None = Field(
        default=None, alias='timeDetailHoursBasedExtAmountVisibleFlag'
    )
    time_detail_hoursbased_hourly_rate_visible_flag: bool | None = Field(
        default=None, alias='timeDetailHoursbasedHourlyRateVisibleFlag'
    )
    time_detail_amount_based_hours_visible_flag: bool | None = Field(
        default=None, alias='timeDetailAmountBasedHoursVisibleFlag'
    )
    time_detail_amount_based_ext_amount_visible_flag: bool | None = Field(
        default=None, alias='timeDetailAmountBasedExtAmountVisibleFlag'
    )
    time_detail_amount_based_hourly_rate_visible_flag: bool | None = Field(
        default=None, alias='timeDetailAmountBasedHourlyRateVisibleFlag'
    )
    time_detail_sr_ticket_summary_visible_flag: bool | None = Field(
        default=None, alias='timeDetailSRTicketSummaryVisibleFlag'
    )
    time_detail_sr_contact_visible_flag: bool | None = Field(
        default=None, alias='timeDetailSRContactVisibleFlag'
    )
    time_detail_sr_address_visible_flag: bool | None = Field(
        default=None, alias='timeDetailSRAddressVisibleFlag'
    )
    time_detail_pm_phase_visible_flag: bool | None = Field(
        default=None, alias='timeDetailPmPhaseVisibleFlag'
    )
    time_detail_pm_summary_visible_flag: bool | None = Field(
        default=None, alias='timeDetailPmSummaryVisibleFlag'
    )
    time_detail_ticket_number_visible_flag: bool | None = Field(
        default=None, alias='timeDetailTicketNumberVisibleFlag'
    )
    time_detail_dates_visible_flag: bool | None = Field(
        default=None, alias='timeDetailDatesVisibleFlag'
    )
    services_staff_caption: str | None = Field(
        default=None, alias='servicesStaffCaption'
    )
    """
     Max length: 50;
    """
    services_staff_visible_flag: bool | None = Field(
        default=None, alias='servicesStaffVisibleFlag'
    )
    services_amount_caption: str | None = Field(
        default=None, alias='servicesAmountCaption'
    )
    """
     Max length: 50;
    """
    services_amount_visible_flag: bool | None = Field(
        default=None, alias='servicesAmountVisibleFlag'
    )
    services_hours_caption: str | None = Field(
        default=None, alias='servicesHoursCaption'
    )
    """
     Max length: 50;
    """
    services_hours_visible_flag: bool | None = Field(
        default=None, alias='servicesHoursVisibleFlag'
    )
    services_rate_caption: str | None = Field(default=None, alias='servicesRateCaption')
    """
     Max length: 50;
    """
    services_rate_visible_flag: bool | None = Field(
        default=None, alias='servicesRateVisibleFlag'
    )
    services_work_role_caption: str | None = Field(
        default=None, alias='servicesWorkRoleCaption'
    )
    """
     Max length: 50;
    """
    services_work_role_visible_flag: bool | None = Field(
        default=None, alias='servicesWorkRoleVisibleFlag'
    )
    services_work_type_caption: str | None = Field(
        default=None, alias='servicesWorkTypeCaption'
    )
    """
     Max length: 50;
    """
    services_work_type_visible_flag: bool | None = Field(
        default=None, alias='servicesWorkTypeVisibleFlag'
    )
    services_total_visible_flag: bool | None = Field(
        default=None, alias='servicesTotalVisibleFlag'
    )
    services_member_name_visible_flag: bool | None = Field(
        default=None, alias='servicesMemberNameVisibleFlag'
    )
    services_member_name_caption: str | None = Field(
        default=None, alias='servicesMemberNameCaption'
    )
    """
     Max length: 50;
    """
    currency_id_visible_flag: bool | None = Field(
        default=None, alias='currencyIdVisibleFlag'
    )
    currency_symbol_visible_flag: bool | None = Field(
        default=None, alias='currencySymbolVisibleFlag'
    )
    portal_flag: bool | None = Field(default=None, alias='portalFlag')
    services_collapsed_flag: bool | None = Field(
        default=None, alias='servicesCollapsedFlag'
    )
    expenses_collapsed_flag: bool | None = Field(
        default=None, alias='expensesCollapsedFlag'
    )
    other_charges_collapsed_flag: bool | None = Field(
        default=None, alias='otherChargesCollapsedFlag'
    )
    expenses_type_caption: str | None = Field(default=None, alias='expensesTypeCaption')
    """
     Max length: 50;
    """
    expenses_staff_caption: str | None = Field(
        default=None, alias='expensesStaffCaption'
    )
    """
     Max length: 50;
    """
    expenses_amount_caption: str | None = Field(
        default=None, alias='expensesAmountCaption'
    )
    """
     Max length: 50;
    """
    expenses_type_visible_flag: bool | None = Field(
        default=None, alias='expensesTypeVisibleFlag'
    )
    expenses_staff_visible_flag: bool | None = Field(
        default=None, alias='expensesStaffVisibleFlag'
    )
    expenses_amount_visible_flag: bool | None = Field(
        default=None, alias='expensesAmountVisibleFlag'
    )
    expenses_total_visible_flag: bool | None = Field(
        default=None, alias='expensesTotalVisibleFlag'
    )
    expense_detail_subtotal_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailSubtotalVisibleFlag'
    )
    expense_detail_members_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailMembersVisibleFlag'
    )
    expense_detail_contacts_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailContactsVisibleFlag'
    )
    expense_detail_billable_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailBillableVisibleFlag'
    )
    expense_detail_ext_amount_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailExtAmountVisibleFlag'
    )
    expense_detail_notes_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailNotesVisibleFlag'
    )
    expense_detail_primary_sort_field: str | None = Field(
        default=None, alias='expenseDetailPrimarySortField'
    )
    expense_detail_primary_sort_direction: str | None = Field(
        default=None, alias='expenseDetailPrimarySortDirection'
    )
    expense_detail_secondary_sort_field: str | None = Field(
        default=None, alias='expenseDetailSecondarySortField'
    )
    expense_detail_secondary_sort_direction: str | None = Field(
        default=None, alias='expenseDetailSecondarySortDirection'
    )
    expense_detail_nonbillable_caption: str | None = Field(
        default=None, alias='expenseDetailNonbillableCaption'
    )
    """
     Max length: 50;
    """
    expense_detail_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailVisibleFlag'
    )
    expense_detail_agreement_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailAgreementVisibleFlag'
    )
    expense_detail_agreement_ext_amount_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailAgreementExtAmountVisibleFlag'
    )
    expense_detail_ticket_number_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailTicketNumberVisibleFlag'
    )
    expense_detail_sr_ticket_summary_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailSrTicketSummaryVisibleFlag'
    )
    expense_detail_sr_contact_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailSrContactVisibleFlag'
    )
    expense_detail_sr_address_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailSrAddressVisibleFlag'
    )
    expense_detail_pm_phase_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailPmPhaseVisibleFlag'
    )
    expense_detail_pm_summary_visible_flag: bool | None = Field(
        default=None, alias='expenseDetailPmSummaryVisibleFlag'
    )
    other_charges_amount_caption: str | None = Field(
        default=None, alias='otherChargesAmountCaption'
    )
    """
     Max length: 50;
    """
    other_charges_amount_visible_flag: bool | None = Field(
        default=None, alias='otherChargesAmountVisibleFlag'
    )
    other_charges_description_caption: str | None = Field(
        default=None, alias='otherChargesDescriptionCaption'
    )
    """
     Max length: 50;
    """
    other_charges_description_visible_flag: bool | None = Field(
        default=None, alias='otherChargesDescriptionVisibleFlag'
    )
    other_charges_display_six_decimals: bool | None = Field(
        default=None, alias='otherChargesDisplaySixDecimals'
    )
    other_charges_item_id_visible_flag: bool | None = Field(
        default=None, alias='otherChargesItemIdVisibleFlag'
    )
    other_charges_price_caption: str | None = Field(
        default=None, alias='otherChargesPriceCaption'
    )
    """
     Max length: 50;
    """
    other_charges_price_visible_flag: bool | None = Field(
        default=None, alias='otherChargesPriceVisibleFlag'
    )
    other_charges_quantity_caption: str | None = Field(
        default=None, alias='otherChargesQuantityCaption'
    )
    """
     Max length: 50;
    """
    other_charges_quantity_visible_flag: bool | None = Field(
        default=None, alias='otherChargesQuantityVisibleFlag'
    )
    other_charges_serial_number_visible_flag: bool | None = Field(
        default=None, alias='otherChargesSerialNumberVisibleFlag'
    )
    other_charges_total_visible_flag: bool | None = Field(
        default=None, alias='otherChargesTotalVisibleFlag'
    )
    adjustment_description_visible_flag: bool | None = Field(
        default=None, alias='adjustmentDescriptionVisibleFlag'
    )
    adjustment_description_caption: str | None = Field(
        default=None, alias='adjustmentDescriptionCaption'
    )
    """
     Max length: 50;
    """
    adjustment_quantity_visible_flag: bool | None = Field(
        default=None, alias='adjustmentQuantityVisibleFlag'
    )
    adjustment_quantity_caption: str | None = Field(
        default=None, alias='adjustmentQuantityCaption'
    )
    """
     Max length: 50;
    """
    adjustment_amount_visible_flag: bool | None = Field(
        default=None, alias='adjustmentAmountVisibleFlag'
    )
    adjustment_amount_caption: str | None = Field(
        default=None, alias='adjustmentAmountCaption'
    )
    """
     Max length: 50;
    """
    adjustment_agr_type_visible_flag: bool | None = Field(
        default=None, alias='adjustmentAgrTypeVisibleFlag'
    )
    adjustment_total_visible_flag: bool | None = Field(
        default=None, alias='adjustmentTotalVisibleFlag'
    )
    adjustment_price_visible_flag: bool | None = Field(
        default=None, alias='adjustmentPriceVisibleFlag'
    )
    adjustment_price_caption: str | None = Field(
        default=None, alias='adjustmentPriceCaption'
    )
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InvoiceTemplateDetailReference(ActivityReference):
    pass


class InvoiceTemplateReference(ConnectWiseModel):
    id: int | None = None
    """
    Gets or sets invoice Template Setup Id.
    """
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InvoiceTemplateSetup(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    custom_flag: bool | None = Field(default=None, alias='customFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class IRestIdentifiedItem(ConnectWiseModel):
    id: int | None = None


class IvItemReference(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class KBCategoryReference(ActivityReference):
    pass


class KnowledgeBaseArticle(ConnectWiseModel):
    id: int | None = None
    title: str
    issue: str
    resolution: str
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    board: BoardReference | None = None
    category_id: int | None = Field(default=None, alias='categoryId')
    sub_category_id: int | None = Field(default=None, alias='subCategoryId')
    date_created: str | None = Field(default=None, alias='dateCreated')
    created_by: str | None = Field(default=None, alias='createdBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class KPICategory(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')


class KPICategoryReference(ActivityReference):
    pass


class KPIReference(ActivityReference):
    pass


class LdapConfiguration(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    server: str
    """
    FQDN of the Server. Max length: 200;
    """
    domain: str
    """
    Domain Name of the server. Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LdapConfigurationInfo(ActivityReference):
    pass


class LdapConfigurationReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    server: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LdapConfigurationTestLink(ConnectWiseModel):
    server: str | None = None
    """
     Max length: 200;
    """


class LegacySubCategory(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LegacySubCategoryInfo(CategoryInfo):
    pass


class LicenseBit(ConnectWiseModel):
    name: str | None = None
    active_flag: bool | None = Field(default=None, alias='activeFlag')


class Link(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    table_reference_id: int | None = Field(default=None, alias='tableReferenceId')
    url: str | None = None
    """
     Max length: 1000;
    """
    screen_link: Literal[
        'Company', 'Contact', 'Service', 'Invoice', 'PurchaseOrder', 'SalesOrder'
    ] | None = Field(default=None, alias='screenLink')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LinkClicked(ConnectWiseModel):
    id: int | None = None
    campaign_id: int | None = Field(default=None, alias='campaignId')
    contact_id: int = Field(..., alias='contactId')
    date_clicked: datetime | None = Field(default=None, alias='dateClicked')
    url: str
    """
     Max length: 2083;
    """
    query_string: str | None = Field(default=None, alias='queryString')


class LinkInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    screen_link: Literal[
        'Company', 'Contact', 'Service', 'Invoice', 'PurchaseOrder', 'SalesOrder'
    ] | None = Field(default=None, alias='screenLink')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LinkResolveUrlInfo(ConnectWiseModel):
    reference_id: int = Field(..., alias='referenceId')
    url: str | None = None


class LocaleInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    locale_code: str | None = Field(default=None, alias='localeCode')


class LocaleReference(ActivityReference):
    pass


class LocationInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    location_flag: bool | None = None
    structure_level: CorporateStructureLevelReference | None = Field(
        default=None, alias='structureLevel'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LostRevenueReference(AgreementRevenueReference):
    pass


class M365Contact(ConnectWiseModel):
    id: int | None = None
    user_principal_name: str | None = Field(default=None, alias='userPrincipalName')
    display_name: str | None = Field(default=None, alias='displayName')
    contact_rec_id: int | None = Field(default=None, alias='contactRecId')
    tenant_id: str | None = Field(default=None, alias='tenantId')
    m365_contact_id: str | None = Field(default=None, alias='m365ContactId')
    department: str | None = None
    employee_type: str | None = Field(default=None, alias='employeeType')
    manager_id: str | None = Field(default=None, alias='managerId')
    proxy_addresses: str | None = Field(default=None, alias='proxyAddresses')
    proxy_addresses_plain: str | None = Field(default=None, alias='proxyAddressesPlain')
    groups: str | None = None
    directory_roles: str | None = Field(default=None, alias='directoryRoles')
    assigned_licenses: str | None = Field(default=None, alias='assignedLicenses')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class M365ContactSync(ConnectWiseModel):
    id: int | None = None
    tenant_id: str | None = Field(default=None, alias='tenantId')
    client_id: str | None = Field(default=None, alias='clientId')
    client_secret: str | None = Field(default=None, alias='clientSecret')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    primary_domain: str | None = Field(default=None, alias='primaryDomain')
    display_name: str | None = Field(default=None, alias='displayName')
    authorized_flag: bool | None = Field(default=None, alias='authorizedFlag')
    server_url: str | None = Field(default=None, alias='serverUrl')
    username: str | None = None
    password: str | None = None
    domain: str | None = None
    company_contacts_folder: str | None = Field(
        default=None, alias='companyContactsFolder'
    )
    service_account_email: str | None = Field(default=None, alias='serviceAccountEmail')
    credential_file: str | None = Field(default=None, alias='credentialFile')
    credential_file_name: str | None = Field(default=None, alias='credentialFileName')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class M365ContactSyncInfo(ActivityReference):
    pass


class M365ContactSyncMonitoring(ConnectWiseModel):
    id: int | None = None
    monitoring_type_id: int | None = Field(default=None, alias='monitoringTypeId')
    email_address: str | None = Field(default=None, alias='emailAddress')
    service_board_id: int | None = Field(default=None, alias='serviceBoardId')
    service_board_status_id: int | None = Field(
        default=None, alias='serviceBoardStatusId'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class M365ContactSyncMonitoringNotificationInfo(ConnectWiseModel):
    company_rec_id: int | None = Field(default=None, alias='companyRecId')
    company_name: str | None = Field(default=None, alias='companyName')
    address_rec_id: int | None = Field(default=None, alias='addressRecId')
    primary_contact_rec_id: int | None = Field(
        default=None, alias='primaryContactRecId'
    )
    primary_contact_full_name: str | None = Field(
        default=None, alias='primaryContactFullName'
    )
    tenant_id: str | None = Field(default=None, alias='tenantId')
    tenant_name: str | None = Field(default=None, alias='tenantName')


class M365ContactSyncProperty(ConnectWiseModel):
    id: int | None = None
    include_exclude_type: Literal['All', 'M365Property', 'None'] | None = Field(
        default=None, alias='includeExcludeType'
    )
    property_type: Literal[
        'City',
        'DepartmentContactSync',
        'Email',
        'DistributionGroup',
        'JobTitle',
        'AssignedLicenses',
        'DisplayName',
        'OfficeLocation',
        'ReportManager',
        'State',
        'EmployeeType',
        'UserType',
    ] | None = Field(default=None, alias='propertyType')
    exclude_include_flag: bool | None = Field(default=None, alias='excludeIncludeFlag')
    wild_card: str | None = Field(default=None, alias='wildCard')
    company_rec_id: int | None = Field(default=None, alias='companyRecID')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class M365License(ConnectWiseModel):
    id: str | None = None
    description: str | None = None


class M365Tenant(ConnectWiseModel):
    id: str | None = None
    name: str | None = None


class ManagedDevicesIntegrationInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    solution: str | None = None
    management_it_setup_type: str | None = Field(
        default=None, alias='managementItSetupType'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDevicesIntegrationReference(ActivityReference):
    pass


class ManagedInformation(ConnectWiseModel):
    management_solution_name: str | None = Field(
        default=None, alias='managementSolutionName'
    )
    managed_identifier: str | None = Field(default=None, alias='managedIdentifier')
    type: str | None = None
    level: str | None = None
    child_configurations_matching_on: str | None = Field(
        default=None, alias='childConfigurationsMatchingOn'
    )
    inactivate_configurations_matching_on: str | None = Field(
        default=None, alias='inactivateConfigurationsMatchingOn'
    )
    inactive_configuration_status_id: int | None = Field(
        default=None, alias='inactiveConfigurationStatusId'
    )


class Management(ConnectWiseModel):
    id: int | None = None
    run_time: datetime | None = Field(default=None, alias='runTime')
    added_configuration_status: ConfigurationStatusReference | None = Field(
        default=None, alias='addedConfigurationStatus'
    )
    deleted_configuration_status: ConfigurationStatusReference | None = Field(
        default=None, alias='deletedConfigurationStatus'
    )
    integrator_login: IntegratorLoginReference | None = Field(
        default=None, alias='integratorLogin'
    )
    schedule_executive_summary_report_flag: bool = Field(
        ..., alias='scheduleExecutiveSummaryReportFlag'
    )
    executive_summary_report_schedule_day: int | None = Field(
        default=None, alias='executiveSummaryReportScheduleDay'
    )
    """
    Gets or sets
                this is only required when scheduleExecutiveSummaryReportFlag = true.
    """
    executive_summary_report_schedule_hour: int | None = Field(
        default=None, alias='executiveSummaryReportScheduleHour'
    )
    """
    Gets or sets
                this is only required when scheduleExecutiveSummaryReportFlag = true. Input should be in 24 hour format, ie 2pm is 14.
    """
    executive_summary_report_schedule_minute: int | None = Field(
        default=None, alias='executiveSummaryReportScheduleMinute'
    )
    """
    Gets or sets
                this is only required when scheduleExecutiveSummaryReportFlag = true.
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementBackup(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    item: CatalogItemReference | None = None
    billing_level: Literal['Detail', 'Summary'] = Field(..., alias='billingLevel')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementItSolution(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    management_it_solution_type: Literal[
        'LevelPlatforms', 'NAble', 'Continuum', 'Custom'
    ] = Field(..., alias='managementItSolutionType')
    management_solution_name: str | None = Field(
        default=None, alias='managementSolutionName'
    )
    """
    Gets or sets
                this is only required when managementItSolutionType is Custom. Max length: 30;
    """
    management_server_url: str | None = Field(default=None, alias='managementServerUrl')
    """
    Gets or sets
                this is only required for Level Platforms. Max length: 200;
    """
    webservice_override_url: str | None = Field(
        default=None, alias='webserviceOverrideUrl'
    )
    """
    Gets or sets
                this is only required for Level Platforms when overrideWebServiceLocationFlag is true. Max length: 200;
    """
    portal_override_login_url: str | None = Field(
        default=None, alias='portalOverrideLoginUrl'
    )
    """
    Gets or sets
                this is only required for Level Platforms when overrideLoginLocationFlag is true. Max length: 200;
    """
    global_login_flag: bool | None = Field(default=None, alias='globalLoginFlag')
    global_login_username: str | None = Field(default=None, alias='globalLoginUsername')
    """
    Gets or sets
                this is only required when globalLoginFlag = true. Max length: 50;
    """
    global_login_password: str | None = Field(default=None, alias='globalLoginPassword')
    """
    Gets or sets
                this is only required when globalLoginFlag = true. Max length: 50;
    """
    using_ssl_flag: bool | None = Field(default=None, alias='usingSslFlag')
    n_able_username: str | None = Field(default=None, alias='nAbleUsername')
    """
    Gets or sets
                this is only required for N-Able solution. Max length: 50;
    """
    n_able_password: str | None = Field(default=None, alias='nAblePassword')
    """
    Gets or sets
                this is only required for N-Able solution. Max length: 50;
    """
    override_web_service_location_flag: bool | None = Field(
        default=None, alias='overrideWebServiceLocationFlag'
    )
    override_login_location_flag: bool | None = Field(
        default=None, alias='overrideLoginLocationFlag'
    )
    continuum_api_username: str | None = Field(
        default=None, alias='continuumApiUsername'
    )
    """
    Gets or sets
                this is only required for Continuum solution. Max length: 100;
    """
    continuum_api_password: str | None = Field(
        default=None, alias='continuumApiPassword'
    )
    """
    Gets or sets
                this is only required for Continuum solution. Max length: 100;
    """
    level_api_username: str | None = Field(default=None, alias='levelApiUsername')
    """
    Gets or sets
                this is only required for Level Platforms solution. Max length: 100;
    """
    level_api_password: str | None = Field(default=None, alias='levelApiPassword')
    """
    Gets or sets
                this is only required for Level Platforms solution. Max length: 100;
    """
    level_var_domain: str | None = Field(default=None, alias='levelVarDomain')
    """
    Gets or sets
                this is only required for Level Platforms solution. Max length: 100;
    """
    no_display_flag: bool | None = Field(default=None, alias='noDisplayFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementItSolutionAgreementInterfaceParameter(ConnectWiseModel):
    id: int | None = None
    managed_devices_integration: ManagedDevicesIntegrationReference | None = Field(
        default=None, alias='managedDevicesIntegration'
    )
    agreement_type: AgreementTypeReference | None = Field(
        default=None, alias='agreementType'
    )
    server_product: IvItemReference | None = Field(default=None, alias='serverProduct')
    workstation_product: IvItemReference | None = Field(
        default=None, alias='workstationProduct'
    )
    spam_stats_product: IvItemReference | None = Field(
        default=None, alias='spamStatsProduct'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementLogDocumentInfo(ConnectWiseModel):
    full_path_file_name: str | None = Field(default=None, alias='fullPathFileName')
    file_size: str | None = Field(default=None, alias='fileSize')


class ManagementNetworkSecurity(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    username: str | None = None
    """
     Max length: 50;
    """
    password: str | None = None
    """
     Max length: 50;
    """
    site: str
    """
     Max length: 100;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementReportSetup(ConnectWiseModel):
    id: int | None = None
    scheduled_report_disabled_flag: bool = Field(
        ..., alias='scheduledReportDisabledFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementSolutionReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    setup_name: str | None = Field(default=None, alias='setupName')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Manager(ConnectWiseModel):
    manager_id: str | None = None
    user_type: str | None = Field(default=None, alias='userType')
    microsoft_365_contact_rec_id: int | None = Field(
        default=None, alias='microsoft_365_Contact_RecID'
    )
    principal_name: str | None = Field(default=None, alias='principalName')
    display_name: str | None = Field(default=None, alias='displayName')
    contact_rec_id: int | None = Field(default=None, alias='contact_RecID')
    tenant_id: str | None = Field(default=None, alias='tenant_ID')
    id: str | None = None
    department: str | None = None
    manager_id_1: str | None = Field(default=None, alias='manager_ID')
    employee_type: str | None = Field(default=None, alias='employeeType')
    manager: Manager | None = None
    date_entered_utc: datetime | None = Field(default=None, alias='date_Entered_UTC')
    entered_by: str | None = Field(default=None, alias='entered_By')
    last_update_utc: datetime | None = Field(default=None, alias='last_Update_UTC')
    updated_by: str | None = Field(default=None, alias='updated_By')
    first_name: str | None = Field(default=None, alias='firstName')
    last_name: str | None = Field(default=None, alias='lastName')
    groups: list[str] | None = None
    directory_roles: list[str] | None = Field(default=None, alias='directoryRoles')
    proxy_addresses: list[str] | None = Field(default=None, alias='proxyAddresses')
    mail_nickname: str | None = Field(default=None, alias='mailNickname')
    mail: str | None = None
    country: str | None = None
    state: str | None = None
    city: str | None = None
    address: str | None = None
    fax: str | None = None
    title: str | None = None
    mobile_phone: str | None = Field(default=None, alias='mobilePhone')
    office: str | None = None
    phone_number: str | None = Field(default=None, alias='phoneNumber')
    language: str | None = None
    usage_location: str | None = Field(default=None, alias='usageLocation')
    postal_code: str | None = Field(default=None, alias='postalCode')
    licenses: list[M365License] | None = None
    account_enabled: bool | None = Field(default=None, alias='accountEnabled')


class Manufacturer(LegacySubCategory):
    pass


class ManufacturerInfo(CategoryInfo):
    pass


class ManufacturerReference(ActivityReference):
    pass


class MappedRecordReference(CorporateStructureLevel):
    pass


class MappedType(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    table: str | None = None
    rec_id_field: str | None = Field(default=None, alias='recIdField')
    gl_type: Literal[
        'AP',
        'AR',
        'EE',
        'EI',
        'EO',
        'IA',
        'IT',
        'P',
        'PF',
        'R',
        'RA',
        'RD',
        'RE',
        'RP',
        'ST',
        'SD',
        'ET',
        'FT',
        'PT',
        'WP',
        'WR',
    ] | None = Field(default=None, alias='glType')
    sort_order: int | None = Field(default=None, alias='sortOrder')


class MappedTypeReference(ActivityReference):
    pass


class MarketDescription(ContactRelationship):
    pass


class MarketDescriptionInfo(ActivityReference):
    pass


class MarketDescriptionReference(ActivityReference):
    pass


class MarketingCompany(ConnectWiseModel):
    id: int | None = None
    group_id: int | None = Field(default=None, alias='groupId')
    default_contact_flag: bool | None = Field(default=None, alias='defaultContactFlag')
    all_contacts_flag: bool | None = Field(default=None, alias='allContactsFlag')
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MarketingContact(ConnectWiseModel):
    id: int | None = None
    group_id: int | None = Field(default=None, alias='groupId')
    note: str | None = None
    """
     Max length: 50;
    """
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MarketplaceImport(ConnectWiseModel):
    id: int | None = None
    marketplace_import_type: Literal[
        'Agreements',
        'Configurations',
        'CRMSurveys',
        'CustomReports',
        'CustomerPortalTypes',
        'HTMLEmailTemplates',
        'Products',
        'ProjectBoards',
        'ProjectTemplates',
        'ReportWriterReports',
        'ServiceBoards',
        'TicketTemplates',
        'Views',
    ] | None = Field(default=None, alias='marketplaceImportType')
    marketplace_object: list | None = Field(default=None, alias='marketplaceObject')
    required_fields: list[str] | None = Field(default=None, alias='requiredFields')


class MemberInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    first_name: str | None = Field(default=None, alias='firstName')
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    last_name: str | None = Field(default=None, alias='lastName')
    full_name: str | None = Field(default=None, alias='fullName')
    default_email: str | None = Field(default=None, alias='defaultEmail')
    photo: DocumentReference | None = None
    license_class: Literal['A', 'C', 'F', 'X'] | None = Field(
        default=None, alias='licenseClass'
    )
    """
    F = Full Member, A = API Member, C = StreamlineIT Member, X = Subcontractor Member
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberLinkSsoUser(ConnectWiseModel):
    sso_user_id: str | None = Field(default=None, alias='ssoUserId')
    """
     Max length: 100;
    """


class MemberNotificationSetting(ConnectWiseModel):
    id: int | None = None
    notification_type: Literal['Email', 'Push'] = Field(..., alias='notificationType')
    notification_trigger: Literal[
        'ActivityStatusReq',
        'CustomerUpdated',
        'ExpenseReport',
        'TicketStatusChange',
        'TicketStatusRequest',
        'TimeNagApprover',
        'TimeNagMember',
        'TimeSheet',
        'WorkflowRules',
    ] = Field(..., alias='notificationTrigger')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberOffice365(M365Tenant):
    pass


class MemberReference(CatalogItemReference):
    pass


class MemberSsoSettingsReference(ConnectWiseModel):
    id: int | None = None
    sso_user_id: str | None = Field(default=None, alias='ssoUserId')
    user_name: str | None = Field(default=None, alias='userName')
    email: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberSsoToken(ConnectWiseModel):
    token: str | None = None


class MemberType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberTypeInfo(CategoryInfo):
    pass


class MemberTypeReference(ActivityReference):
    pass


class MenuLocationReference(ActivityReference):
    pass


class MySecurity(ConnectWiseModel):
    id: int | None = None
    add_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='addLevel'
    )
    edit_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='editLevel'
    )
    delete_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='deleteLevel'
    )
    inquire_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='inquireLevel'
    )
    module_function_name: str | None = Field(default=None, alias='moduleFunctionName')
    module_function_description: str | None = Field(
        default=None, alias='moduleFunctionDescription'
    )
    my_all_flag: bool | None = Field(default=None, alias='myAllFlag')
    module_function_identifier: str | None = Field(
        default=None, alias='moduleFunctionIdentifier'
    )
    report_flag: bool | None = Field(default=None, alias='reportFlag')
    restrict_flag: bool | None = Field(default=None, alias='restrictFlag')
    custom_flag: bool | None = Field(default=None, alias='customFlag')
    module_description: str | None = Field(default=None, alias='moduleDescription')
    module_identifier: str | None = Field(default=None, alias='moduleIdentifier')
    module_name: str | None = Field(default=None, alias='moduleName')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MySecurityCustomizeItem(ConnectWiseModel):
    id: int | None = None
    customize_identifier: Literal[
        'CompanyReports',
        'FinanceReports',
        'MarketingReports',
        'ProcurementReports',
        'ProjectReports',
        'SalesReports',
        'ServiceReports',
        'SystemReports',
        'TimeAndExpenseReports',
        'CompanyConfigurations',
        'FinanceAgreements',
        'ProjectScheduling',
        'ServiceResourceScheduling',
        'SystemManageHostedApi',
        'SystemMyAccount',
        'SystemCustomMenuEntry',
        'SystemMassMaintenance',
        'SystemTableSetup',
    ] | None = Field(default=None, alias='customizeIdentifier')
    item_identifier: str | None = Field(default=None, alias='itemIdentifier')


class NoteTypeReference(ActivityReference):
    pass


class NotificationRecipient(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    external_flag: bool | None = Field(default=None, alias='externalFlag')
    service_flag: bool | None = Field(default=None, alias='serviceFlag')
    sales_flag: bool | None = Field(default=None, alias='salesFlag')
    invoice_flag: bool | None = Field(default=None, alias='invoiceFlag')
    agreement_flag: bool | None = Field(default=None, alias='agreementFlag')
    member_flag: bool | None = Field(default=None, alias='memberFlag')
    config_flag: bool | None = Field(default=None, alias='configFlag')
    msp_flag: bool | None = Field(default=None, alias='mspFlag')
    track_flag: bool | None = Field(default=None, alias='trackFlag')
    project_flag: bool | None = Field(default=None, alias='projectFlag')
    procurement_flag: bool | None = Field(default=None, alias='procurementFlag')
    knowledge_base_flag: bool | None = Field(default=None, alias='knowledgeBaseFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class NotificationRecipientReference(CatalogItemReference):
    pass


class NotifyTypeReference(CatalogItemReference):
    pass


class Office365EmailSetup(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 200;
    """
    username: str
    """
     Max length: 100;
    """
    inbox_folder: str = Field(..., alias='inboxFolder')
    """
     Max length: 40;
    """
    processed_folder: str = Field(..., alias='processedFolder')
    """
     Max length: 40;
    """
    failed_folder: str = Field(..., alias='failedFolder')
    """
     Max length: 40;
    """
    tenant_id: str | None = Field(default=None, alias='tenantId')
    """
     Max length: 36;
    """
    client_id: str | None = Field(default=None, alias='clientId')
    """
     Max length: 36;
    """
    client_secret: str | None = Field(default=None, alias='clientSecret')
    """
     Max length: 4000;
    """
    authorized_flag: bool | None = Field(default=None, alias='authorizedFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    source: int | None = None
    email_connector: EmailConnectorReference | None = Field(
        default=None, alias='emailConnector'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Office365EmailSetupReference(ActivityReference):
    pass


class OnHandSerialNumberReference(ConnectWiseModel):
    id: int | None = None
    serial_number: str | None = Field(default=None, alias='serialNumber')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OnPremiseSearchSetting(ConnectWiseModel):
    id: int | None = None
    password: str
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpenRevenueReference(AgreementRevenueReference):
    pass


class OpportunityNote(ConnectWiseModel):
    id: int | None = None
    opportunity_id: int | None = Field(default=None, alias='opportunityId')
    type: NoteTypeReference | None = None
    text: str
    flagged: bool | None = None
    entered_by: str | None = Field(default=None, alias='enteredBy')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityPriorityReference(ActivityReference):
    pass


class OpportunityProbabilityReference(ActivityReference):
    pass


class OpportunityRating(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    sort_order: int | None = Field(default=None, alias='sortOrder')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityRatingInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityRatingReference(ActivityReference):
    pass


class OpportunityReference(ActivityReference):
    pass


class OpportunitySalesRoleReference(ActivityReference):
    pass


class OpportunityStage(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    probability: OpportunityProbabilityReference | None = None
    color: str | None = None
    """
     Max length: 25;
    """
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityStageInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    probability: OpportunityProbabilityReference | None = None
    color: str | None = None
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityStageReference(ActivityReference):
    pass


class OpportunityStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    won_flag: bool | None = Field(default=None, alias='wonFlag')
    lost_flag: bool | None = Field(default=None, alias='lostFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    entered_by: str | None = Field(default=None, alias='enteredBy')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityStatusInfo(ConnectWiseModel):
    id: int | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityStatusReference(ActivityReference):
    pass


class OpportunityToAgreementConversion(ConnectWiseModel):
    agreement_id: int | None = Field(default=None, alias='agreementId')
    name: str | None = None
    type: AgreementTypeReference | None = None
    start_date: str | None = Field(default=None, alias='startDate')
    end_date: str | None = Field(default=None, alias='endDate')
    no_ending_date_flag: bool | None = Field(default=None, alias='noEndingDateFlag')
    bill_cycle_id: int | None = Field(default=None, alias='billCycleId')
    bill_one_time_flag: bool | None = Field(default=None, alias='billOneTimeFlag')
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    include_all_notes_flag: bool | None = Field(
        default=None, alias='includeAllNotesFlag'
    )
    include_all_documents_flag: bool | None = Field(
        default=None, alias='includeAllDocumentsFlag'
    )
    include_all_products_flag: bool | None = Field(
        default=None, alias='includeAllProductsFlag'
    )
    include_note_ids: list[int] | None = Field(default=None, alias='includeNoteIds')
    include_document_ids: list[int] | None = Field(
        default=None, alias='includeDocumentIds'
    )
    include_product_ids: list[int] | None = Field(
        default=None, alias='includeProductIds'
    )


class OpportunityToSalesOrderConversion(ConnectWiseModel):
    sales_order_id: int | None = Field(default=None, alias='salesOrderId')
    name: str | None = None
    include_all_notes_flag: bool | None = Field(
        default=None, alias='includeAllNotesFlag'
    )
    include_all_documents_flag: bool | None = Field(
        default=None, alias='includeAllDocumentsFlag'
    )
    include_all_products_flag: bool | None = Field(
        default=None, alias='includeAllProductsFlag'
    )
    include_note_ids: list[int] | None = Field(default=None, alias='includeNoteIds')
    include_document_ids: list[int] | None = Field(
        default=None, alias='includeDocumentIds'
    )
    include_product_ids: list[int] | None = Field(
        default=None, alias='includeProductIds'
    )


class OpportunityToServiceTicketConversion(ConnectWiseModel):
    ticket_id: int | None = Field(default=None, alias='ticketId')
    summary: str | None = None
    include_all_notes_flag: bool | None = Field(
        default=None, alias='includeAllNotesFlag'
    )
    include_all_documents_flag: bool | None = Field(
        default=None, alias='includeAllDocumentsFlag'
    )
    include_all_products_flag: bool | None = Field(
        default=None, alias='includeAllProductsFlag'
    )
    include_note_ids: list[int] | None = Field(default=None, alias='includeNoteIds')
    include_document_ids: list[int] | None = Field(
        default=None, alias='includeDocumentIds'
    )
    include_product_ids: list[int] | None = Field(
        default=None, alias='includeProductIds'
    )


class OpportunityType(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityTypeInfo(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityTypeReference(ActivityReference):
    pass


class OrderStatusEmailTemplateReference(ActivityReference):
    pass


class OrderStatusInfo(CategoryInfo):
    pass


class OrderStatusReference(ActivityReference):
    pass


class OsGradeWeight(ConnectWiseModel):
    id: int | None = None
    os_grade_weight: float | None = Field(default=None, alias='osGradeWeight')
    os_name: str | None = Field(default=None, alias='osName')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Other1RevenueReference(AgreementRevenueReference):
    pass


class Other2RevenueReference(AgreementRevenueReference):
    pass


class OwnerLevelReference(ActivityReference):
    pass


class OwnershipType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 200;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OwnershipTypeInfo(ActivityReference):
    pass


class OwnershipTypeReference(ActivityReference):
    pass


class PageValues(ConnectWiseModel):
    page: int | None = None
    page_size: int | None = Field(default=None, alias='pageSize')
    page_id: int | None = Field(default=None, alias='pageId')


class ParsingType(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    parse_rule: str | None = Field(default=None, alias='parseRule')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ParsingVariable(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    code: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PatchOperation(ConnectWiseModel):
    op: str | None = None
    path: str | None = None
    value: dict[str, Any] | None = None


class PaymentMethodReference(ActivityReference):
    pass


class PaymentType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    classification: ClassificationReference | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    company_flag: bool | None = Field(default=None, alias='companyFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PaymentTypeInfo(AddressFormatInfo):
    pass


class PersonasInfo(CorporateStructureLevel):
    pass


class PhaseStatusReference(ActivityReference):
    pass


class PortalCalendar(ConnectWiseModel):
    id: int | None = None
    week_start: Literal[
        'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'
    ] = Field(..., alias='weekStart')
    adjust1_start: str | None = Field(default=None, alias='adjust1Start')
    adjust1_end: str | None = Field(default=None, alias='adjust1End')
    adjust1_hours: float | None = Field(default=None, alias='adjust1Hours')
    adjust2_start: str | None = Field(default=None, alias='adjust2Start')
    adjust2_end: str | None = Field(default=None, alias='adjust2End')
    adjust2_hours: float | None = Field(default=None, alias='adjust2Hours')
    adjust3_start: str | None = Field(default=None, alias='adjust3Start')
    adjust3_end: str | None = Field(default=None, alias='adjust3End')
    adjust3_hours: float | None = Field(default=None, alias='adjust3Hours')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfiguration(ConnectWiseModel):
    id: int | None = None
    """
    Gets or sets and Sets
                An existing Portal Configuration id is required when copying a Portal Configuration.
    """
    name: str
    """
     Max length: 150;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    company: CompanyReference | None = None
    login_background_color: str | None = Field(
        default=None, alias='loginBackgroundColor'
    )
    """
     Max length: 7;
    """
    portal_background_color: str | None = Field(
        default=None, alias='portalBackgroundColor'
    )
    """
     Max length: 7;
    """
    menu_color: str | None = Field(default=None, alias='menuColor')
    """
     Max length: 7;
    """
    button_color: str | None = Field(default=None, alias='buttonColor')
    """
     Max length: 7;
    """
    header_color: str | None = Field(default=None, alias='headerColor')
    """
     Max length: 7;
    """
    url: str | None = None
    """
     Max length: 1000;
    """
    language: Literal[
        'English',
        'Spanish',
        'French',
        'British',
        'Australian',
        'BrazilianPortuguese',
        'CanadianFrench',
        'German',
        'NewZealand',
        'Dutch',
    ] | None = None
    welcome_text: str | None = Field(default=None, alias='welcomeText')
    """
     Max length: 4000;
    """
    board_ids: list[int] | None = Field(default=None, alias='boardIds')
    agreement_type_ids: list[int] | None = Field(default=None, alias='agreementTypeIds')
    config_type_ids: list[int] | None = Field(default=None, alias='configTypeIds')
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    portal_image_copy_success_flag: bool | None = Field(
        default=None, alias='portalImageCopySuccessFlag'
    )
    display_vendor_flag: bool | None = Field(default=None, alias='displayVendorFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationOpportunitySetup(ConnectWiseModel):
    id: int | None = None
    opportunity_status_rec_i_ds: list[int] | None = Field(
        default=None, alias='opportunityStatusRecIDs'
    )
    add_all_opportunity_statuses: bool | None = Field(
        default=None, alias='addAllOpportunityStatuses'
    )
    remove_all_opportunity_statuses: bool | None = Field(
        default=None, alias='removeAllOpportunityStatuses'
    )
    opportunity_type_rec_i_ds: list[int] | None = Field(
        default=None, alias='opportunityTypeRecIDs'
    )
    add_all_opportunity_types: bool | None = Field(
        default=None, alias='addAllOpportunityTypes'
    )
    remove_all_opportunity_types: bool | None = Field(
        default=None, alias='removeAllOpportunityTypes'
    )
    restrict_view_by_opportunity_status_flag: bool | None = Field(
        default=None, alias='restrictViewByOpportunityStatusFlag'
    )
    restrict_view_by_opportunity_type_flag: bool | None = Field(
        default=None, alias='restrictViewByOpportunityTypeFlag'
    )
    acceptance_change_status_flag: bool | None = Field(
        default=None, alias='acceptanceChangeStatusFlag'
    )
    acceptance_create_activity_flag: bool | None = Field(
        default=None, alias='acceptanceCreateActivityFlag'
    )
    acceptance_opportunity_status: OpportunityStatusReference | None = Field(
        default=None, alias='acceptanceOpportunityStatus'
    )
    acceptance_send_email_flag: bool | None = Field(
        default=None, alias='acceptanceSendEmailFlag'
    )
    acceptance_email_from_first_name: str | None = Field(
        default=None, alias='acceptanceEmailFromFirstName'
    )
    acceptance_email_from_last_name: str | None = Field(
        default=None, alias='acceptanceEmailFromLastName'
    )
    acceptance_email_subject: str | None = Field(
        default=None, alias='acceptanceEmailSubject'
    )
    acceptance_email_body: str | None = Field(default=None, alias='acceptanceEmailBody')
    acceptance_from_email: str | None = Field(default=None, alias='acceptanceFromEmail')
    """
    Gets or sets
                required when acceptanceSendEmailFlag is true.
    """
    acceptance_email_activity_type: ActivityTypeReference | None = Field(
        default=None, alias='acceptanceEmailActivityType'
    )
    acceptance_email_assigned_by_member: MemberReference | None = Field(
        default=None, alias='acceptanceEmailAssignedByMember'
    )
    rejection_change_status_flag: bool | None = Field(
        default=None, alias='rejectionChangeStatusFlag'
    )
    rejection_create_activity_flag: bool | None = Field(
        default=None, alias='rejectionCreateActivityFlag'
    )
    rejection_opportunity_status: OpportunityStatusReference | None = Field(
        default=None, alias='rejectionOpportunityStatus'
    )
    rejection_send_email_flag: bool | None = Field(
        default=None, alias='rejectionSendEmailFlag'
    )
    rejection_email_from_first_name: str | None = Field(
        default=None, alias='rejectionEmailFromFirstName'
    )
    rejection_email_from_last_name: str | None = Field(
        default=None, alias='rejectionEmailFromLastName'
    )
    rejection_from_email: str | None = Field(default=None, alias='rejectionFromEmail')
    """
    Gets or sets
                required when rejectionSendEmailFlag is true.
    """
    rejection_email_subject: str | None = Field(
        default=None, alias='rejectionEmailSubject'
    )
    rejection_email_body: str | None = Field(default=None, alias='rejectionEmailBody')
    rejection_email_activity_type: ActivityTypeReference | None = Field(
        default=None, alias='rejectionEmailActivityType'
    )
    rejection_email_assigned_by_member: MemberReference | None = Field(
        default=None, alias='rejectionEmailAssignedByMember'
    )
    confirmation_send_email_flag: bool | None = Field(
        default=None, alias='confirmationSendEmailFlag'
    )
    confirmation_email_use_default_company_email_address_flag: bool | None = Field(
        default=None, alias='confirmationEmailUseDefaultCompanyEmailAddressFlag'
    )
    confirmation_email_from_first_name: str | None = Field(
        default=None, alias='confirmationEmailFromFirstName'
    )
    confirmation_email_from_last_name: str | None = Field(
        default=None, alias='confirmationEmailFromLastName'
    )
    confirmation_from_email: str | None = Field(
        default=None, alias='confirmationFromEmail'
    )
    """
    Gets or sets
                required when confirmationSendEmailFlag is true.
    """
    confirmation_email_subject: str | None = Field(
        default=None, alias='confirmationEmailSubject'
    )
    confirmation_email_body: str | None = Field(
        default=None, alias='confirmationEmailBody'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationPasswordEmailSetup(ConnectWiseModel):
    id: int | None = None
    valid_password_email_use_custom_email_flag: bool | None = Field(
        default=None, alias='validPasswordEmailUseCustomEmailFlag'
    )
    valid_password_email_from_first_name: str | None = Field(
        default=None, alias='validPasswordEmailFromFirstName'
    )
    valid_password_email_from_last_name: str | None = Field(
        default=None, alias='validPasswordEmailFromLastName'
    )
    valid_password_email_from_email: str | None = Field(
        default=None, alias='validPasswordEmailFromEmail'
    )
    """
    Gets or sets
                required when validPasswordEmailUseCustomEmailFlag is true.
    """
    valid_password_email_subject: str | None = Field(
        default=None, alias='validPasswordEmailSubject'
    )
    valid_password_email_body: str | None = Field(
        default=None, alias='validPasswordEmailBody'
    )
    invalid_password_email_use_custom_email_flag: bool | None = Field(
        default=None, alias='invalidPasswordEmailUseCustomEmailFlag'
    )
    invalid_password_email_from_first_name: str | None = Field(
        default=None, alias='invalidPasswordEmailFromFirstName'
    )
    invalid_password_email_from_last_name: str | None = Field(
        default=None, alias='invalidPasswordEmailFromLastName'
    )
    invalid_password_email_from_email: str | None = Field(
        default=None, alias='invalidPasswordEmailFromEmail'
    )
    """
    Gets or sets
                required when invalidPasswordEmailUseCustomEmailFlag is true.
    """
    invalid_password_email_subject: str | None = Field(
        default=None, alias='invalidPasswordEmailSubject'
    )
    invalid_password_email_body: str | None = Field(
        default=None, alias='invalidPasswordEmailBody'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationPaymentProcessor(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    test_url: str | None = Field(default=None, alias='testURL')


class PortalConfigurationPaymentProcessorReference(ActivityReference):
    pass


class PortalConfigurationReference(ActivityReference):
    pass


class PortalReport(ConnectWiseModel):
    id: int | None = None
    portal_configuration: PortalConfigurationReference | None = Field(
        default=None, alias='portalConfiguration'
    )
    name: str
    """
     Max length: 255;
    """
    url: str
    """
     Max length: 255;
    """
    open_same_window_flag: bool | None = Field(default=None, alias='openSameWindowFlag')
    custom_flag: bool | None = Field(default=None, alias='customFlag')
    display_flag: bool | None = Field(default=None, alias='displayFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalSecurity(ConnectWiseModel):
    identifier: str | None = None
    enabled: bool | None = None


class PortalSecurityLevel(ConnectWiseModel):
    id: int | None = None
    caption_identifier: str | None = Field(default=None, alias='captionIdentifier')
    is_default_flag: bool | None = Field(default=None, alias='isDefaultFlag')
    caption: str | None = None
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalSecuritySetting(ConnectWiseModel):
    id: int | None = None
    function_identifier: str | None = Field(default=None, alias='functionIdentifier')
    function_description: str | None = Field(default=None, alias='functionDescription')
    level_one: bool | None = Field(default=None, alias='levelOne')
    level_two: bool | None = Field(default=None, alias='levelTwo')
    level_three: bool | None = Field(default=None, alias='levelThree')
    level_four: bool | None = Field(default=None, alias='levelFour')
    level_five: bool | None = Field(default=None, alias='levelFive')
    level_six: bool | None = Field(default=None, alias='levelSix')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PricingBreak(ConnectWiseModel):
    id: int | None = None
    detail_id: int | None = Field(default=None, alias='detailId')
    amount: float | None = None
    quantity_start: float = Field(..., alias='quantityStart')
    quantity_end: float | None = Field(default=None, alias='quantityEnd')
    unlimited: bool | None = None
    price_method: Literal[
        'FlatRateForRange',
        'PercentMarkupFromCost',
        'PercentMarkdownFromPrice',
        'PricePerUnit',
    ] = Field(..., alias='priceMethod')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PricingSchedule(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    currency: CurrencyReference | None = None
    companies: list[int] | None = None
    set_all_companies_flag: bool | None = Field(
        default=None, alias='setAllCompaniesFlag'
    )
    remove_all_companies_flag: bool | None = Field(
        default=None, alias='removeAllCompaniesFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PricingScheduleReference(ActivityReference):
    pass


class Priority(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    color: Literal[
        'Black',
        'Blue',
        'Cyan',
        'Gray',
        'Green',
        'Lime',
        'Orange',
        'Pink',
        'Purple',
        'Red',
        'White',
        'Yellow',
        'Custom',
    ]
    sort_order: int | None = Field(default=None, alias='sortOrder')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    image_link: str | None = Field(default=None, alias='imageLink')
    urgency_sort_order: str | None = Field(default=None, alias='urgencySortOrder')
    level: Literal['Critical', 'High', 'Medium', 'Low'] | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PriorityInfo(OpportunityRatingInfo):
    pass


class PriorityReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort: int | None = None
    level: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProcurementSetting(ConnectWiseModel):
    id: int | None = None
    starting_purchase_order_num: int = Field(..., alias='startingPurchaseOrderNum')
    purchase_order_prefix: str | None = Field(default=None, alias='purchaseOrderPrefix')
    """
     Max length: 5;
    """
    purchase_order_suffix: str | None = Field(default=None, alias='purchaseOrderSuffix')
    """
     Max length: 5;
    """
    prefix_suffix_type: Literal['Prefix', 'Suffix'] | None = Field(
        default=None, alias='prefixSuffixType'
    )
    disable_cost_updates_flag: bool | None = Field(
        default=None, alias='disableCostUpdatesFlag'
    )
    disable_negative_inventory_flag: bool | None = Field(
        default=None, alias='disableNegativeInventoryFlag'
    )
    costing_method: Literal['FIFO', 'LIFO', 'AverageCosting'] = Field(
        ..., alias='costingMethod'
    )
    auto_close_purchase_order_flag: bool | None = Field(
        default=None, alias='autoClosePurchaseOrderFlag'
    )
    auto_close_purchase_order_item_flag: bool | None = Field(
        default=None, alias='autoClosePurchaseOrderItemFlag'
    )
    auto_approve_purchase_order_flag: bool | None = Field(
        default=None, alias='autoApprovePurchaseOrderFlag'
    )
    tax_purchase_order_flag: bool | None = Field(
        default=None, alias='taxPurchaseOrderFlag'
    )
    tax_freight_flag: bool | None = Field(default=None, alias='taxFreightFlag')
    use_vendor_tax_code_flag: bool | None = Field(
        default=None, alias='useVendorTaxCodeFlag'
    )
    num_decimal_places: int | None = Field(default=None, alias='numDecimalPlaces')
    disable_auto_pick_flag: bool | None = Field(
        default=None, alias='disableAutoPickFlag'
    )
    default_product_taxable_flag: bool | None = Field(
        default=None, alias='defaultProductTaxableFlag'
    )
    eori_number: str | None = Field(default=None, alias='eoriNumber')
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProductCategoryReference(ActivityReference):
    pass


class ProductDemand(ConnectWiseModel):
    product_rec_id: int | None = Field(default=None, alias='productRecId')
    quantity: int | None = None
    cost: float | None = None


class ProductDetach(ConnectWiseModel):
    remove_from_ticket: bool | None = Field(default=None, alias='removeFromTicket')
    remove_from_invoice: bool | None = Field(default=None, alias='removeFromInvoice')
    remove_from_opportunity: bool | None = Field(
        default=None, alias='removeFromOpportunity'
    )
    remove_from_sales_order: bool | None = Field(
        default=None, alias='removeFromSalesOrder'
    )
    remove_from_project: bool | None = Field(default=None, alias='removeFromProject')


class ProductItemReference(ActivityReference):
    pass


class ProductRecurring(ConnectWiseModel):
    recurring_revenue: float | None = Field(default=None, alias='recurringRevenue')
    recurring_cost: float | None = Field(default=None, alias='recurringCost')
    start_date: str | None = Field(default=None, alias='startDate')
    end_date: str | None = Field(default=None, alias='endDate')
    """
    The Recurring End Date is calculated based on the
                start date, number of cycles, and cycle type.
    """
    bill_cycle_id: int | None = Field(default=None, alias='billCycleId')
    cycles: int | None = None
    cycle_type: Literal['ContractYear', 'CalendarYear'] | None = Field(
        default=None, alias='cycleType'
    )


class ProductReference(InOutTypeInfo):
    pass


class ProductRevenueReference(AgreementRevenueReference):
    pass


class ProductSubCategoryReference(ActivityReference):
    pass


class ProductType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    type_xref: Literal[
        'InventoryPart', 'NonInventoryPart', 'OtherCharge', 'Service'
    ] | None = Field(default=None, alias='typeXref')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProductTypeInfo(CategoryInfo):
    pass


class ProductTypeReference(ActivityReference):
    pass


class ProjectBoardReference(ActivityReference):
    pass


class ProjectBoardTeamInfo(ActivityReference):
    pass


class ProjectContact(ConnectWiseModel):
    id: int | None = None
    project_id: int | None = Field(default=None, alias='projectId')
    contact: ContactReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectNote(ConnectWiseModel):
    id: int | None = None
    project_id: int | None = Field(default=None, alias='projectId')
    text: str
    type: NoteTypeReference | None = None
    flagged: bool | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectPhaseReference(ActivityReference):
    pass


class ProjectReference(ActivityReference):
    pass


class ProjectRoleReference(AdjustmentTypeReference):
    pass


class ProjectSecurityRole(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    manager_role_flag: bool | None = Field(default=None, alias='managerRoleFlag')
    default_contact_flag: bool | None = Field(default=None, alias='defaultContactFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectSecurityRoleSetting(ConnectWiseModel):
    id: int | None = None
    add_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='addLevel'
    )
    edit_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='editLevel'
    )
    delete_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='deleteLevel'
    )
    inquire_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='inquireLevel'
    )
    module_identifier: str | None = Field(default=None, alias='moduleIdentifier')
    """
     Max length: 50;
    """
    my_flag: bool | None = Field(default=None, alias='myFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectStatusInfo(CategoryInfo):
    pass


class ProjectStatusReference(ActivityReference):
    pass


class ProjectTemplateWorkPlan(ConnectWiseModel):
    tree_id: str | None = Field(default=None, alias='treeID')
    i_d: int | None = Field(default=None, alias='iD')
    rec_id: int | None = Field(default=None, alias='recID')
    display_id: str | None = Field(default=None, alias='displayID')
    s_r_service_rec_id: int | None = Field(default=None, alias='sR_Service_RecID')
    description: str | None = None
    project_name: str | None = Field(default=None, alias='projectName')
    budget_amount: float | None = Field(default=None, alias='budgetAmount')
    is_project: bool | None = Field(default=None, alias='isProject')
    is_phase: bool | None = Field(default=None, alias='isPhase')
    is_ticket: bool | None = Field(default=None, alias='isTicket')
    is_new_item: bool | None = Field(default=None, alias='isNewItem')
    wbs_code: str | None = Field(default=None, alias='wbsCode')
    parent_phase_rec_id: int | None = Field(default=None, alias='parentPhaseRecID')


class ProjectType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTypeInfo(ActivityReference):
    pass


class ProjectTypeReference(ActivityReference):
    pass


class PurchaseOrderLineItemReference(AdjustmentTypeReference):
    pass


class PurchaseOrderReference(ActivityReference):
    pass


class PurchaseOrderStatusEmailTemplateReference(ActivityReference):
    pass


class PurchaseOrderStatusReference(ActivityReference):
    pass


class RelationshipReference(ActivityReference):
    pass


class ReminderReference(ActivityReference):
    pass


class Report(ConnectWiseModel):
    name: str | None = None


class ReportCard(ContactRelationship):
    pass


class ReportCardInfo(ActivityReference):
    pass


class ReportCardReference(ActivityReference):
    pass


class ReportColumnDefinition(ConnectWiseModel):
    type: str | None = None
    is_nullable: bool | None = Field(default=None, alias='isNullable')
    identity_column: bool | None = Field(default=None, alias='identityColumn')


class ReportDataResponse(ConnectWiseModel):
    column_definitions: list[dict[str, ReportColumnDefinition]] | None = None
    row_values: list[list[dict[str, Any]]] | None = None


class ReportingService(ConnectWiseModel):
    id: int | None = None
    reporting_user_name: str | None = Field(default=None, alias='reportingUserName')
    """
     Max length: 50;
    """
    reporting_password: str | None = Field(default=None, alias='reportingPassword')
    """
    To blank out the password, enter an empty string here. Max length: 50;
    """
    reporting_domain: str | None = Field(default=None, alias='reportingDomain')
    """
     Max length: 50;
    """
    reporting_url: str | None = Field(default=None, alias='reportingUrl')
    """
     Max length: 100;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class RequestPasswordRequest(ConnectWiseModel):
    email: str


class RmaAction(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class RmaActionInfo(ActivityReference):
    pass


class RmaActionReference(ActivityReference):
    pass


class RmaDisposition(RmaAction):
    pass


class RmaDispositionInfo(ActivityReference):
    pass


class RmaDispositionReference(ActivityReference):
    pass


class RmaStatusEmailTemplateReference(ActivityReference):
    pass


class RmaStatusInfo(OpportunityRatingInfo):
    pass


class RmaStatusReference(ActivityReference):
    pass


class Role(ContactRelationship):
    pass


class SalesOrderReference(AdjustmentTypeReference):
    pass


class SalesProbability(ConnectWiseModel):
    id: int | None = None
    probability: int
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SalesProbabilityInfo(ConnectWiseModel):
    id: int | None = None
    probability: int | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SalesTeamReference(AdjustmentTypeReference):
    pass


class ScheduleColor(ConnectWiseModel):
    id: int | None = None
    start_percent: int | None = Field(default=None, alias='startPercent')
    """
    A startPercent (0 or higher) is required if endPercent has value.
    """
    end_percent: int | None = Field(default=None, alias='endPercent')
    """
    A endPercent is required if startPercent has value.
    """
    color: str
    """
    Must be a valid Hexadecimal Color Code.
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleEntryReference(InOutTypeInfo):
    pass


class ScheduleReminderTime(ConnectWiseModel):
    id: int | None = None
    time: int | None = None
    """
    Time is calculated in minutes.
    """
    name: str | None = None
    """
     Max length: 10;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleSpanReference(AdjustmentTypeReference):
    pass


class ScheduleStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    show_as_tentative_flag: bool | None = Field(
        default=None, alias='showAsTentativeFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleStatusReference(ActivityReference):
    pass


class ScheduleTypeReference(AdjustmentTypeReference):
    pass


class SchedulingMemberInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    first_name: str | None = Field(default=None, alias='firstName')
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    last_name: str | None = Field(default=None, alias='lastName')
    full_name: str | None = Field(default=None, alias='fullName')
    default_email: str | None = Field(default=None, alias='defaultEmail')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SecurityRole(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    role_type: str | None = Field(default=None, alias='roleType')
    """
     Max length: 30;
    """
    admin_flag: bool | None = Field(default=None, alias='adminFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SecurityRoleInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    role_type: str | None = Field(default=None, alias='roleType')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SecurityRoleReference(ActivityReference):
    pass


class SecurityRoleSetting(ConnectWiseModel):
    id: int | None = None
    add_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='addLevel'
    )
    edit_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='editLevel'
    )
    delete_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='deleteLevel'
    )
    inquire_level: Literal['None', 'My', 'All'] | None = Field(
        default=None, alias='inquireLevel'
    )
    module_function_name: str | None = Field(default=None, alias='moduleFunctionName')
    module_function_description: str | None = Field(
        default=None, alias='moduleFunctionDescription'
    )
    my_all_flag: bool | None = Field(default=None, alias='myAllFlag')
    module_function_identifier: str | None = Field(
        default=None, alias='moduleFunctionIdentifier'
    )
    report_flag: bool | None = Field(default=None, alias='reportFlag')
    restrict_flag: bool | None = Field(default=None, alias='restrictFlag')
    custom_flag: bool | None = Field(default=None, alias='customFlag')
    module_description: str | None = Field(default=None, alias='moduleDescription')
    module_identifier: str | None = Field(default=None, alias='moduleIdentifier')
    module_name: str | None = Field(default=None, alias='moduleName')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Service(ConnectWiseModel):
    id: int | None = None
    sr_notify: Literal[
        'All', 'NewAndClosedRequests', 'ClosedRequestsOnly', 'NewRequestsOnly', 'None'
    ] = Field(..., alias='srNotify')
    schedule_span: Literal['Standard', 'OfficeHours', 'Overnight'] = Field(
        ..., alias='scheduleSpan'
    )
    hide_delimiter_flag: bool | None = Field(default=None, alias='hideDelimiterFlag')
    allow_cc_flag: bool | None = Field(default=None, alias='allowCCFlag')
    allow_to_flag: bool | None = Field(default=None, alias='allowTOFlag')
    header_color: str | None = Field(default=None, alias='headerColor')
    """
     Max length: 50;
    """
    member_color: str | None = Field(default=None, alias='memberColor')
    """
     Max length: 50;
    """
    contact_color: str | None = Field(default=None, alias='contactColor')
    """
     Max length: 50;
    """
    unknown_color: str | None = Field(default=None, alias='unknownColor')
    """
     Max length: 50;
    """
    calendar_setup: CalendarSetupReference | None = Field(
        default=None, alias='calendarSetup'
    )
    header_color_disable_flag: bool | None = Field(
        default=None, alias='headerColorDisableFlag'
    )
    member_color_disable_flag: bool | None = Field(
        default=None, alias='memberColorDisableFlag'
    )
    contact_color_disable_flag: bool | None = Field(
        default=None, alias='contactColorDisableFlag'
    )
    unknown_color_disable_flag: bool | None = Field(
        default=None, alias='unknownColorDisableFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceCodeReference(ActivityReference):
    pass


class ServiceEmailTemplateReference(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    type: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceInfo(ConnectWiseModel):
    id: int | None = None
    header_color: str | None = Field(default=None, alias='headerColor')
    member_color: str | None = Field(default=None, alias='memberColor')
    contact_color: str | None = Field(default=None, alias='contactColor')
    unknown_color: str | None = Field(default=None, alias='unknownColor')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceItemReference(ActivityReference):
    pass


class ServiceLocation(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    where: Literal['OnSite', 'Remote', 'InHouse']
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceLocationInfo(AddressFormatInfo):
    pass


class ServiceLocationReference(ActivityReference):
    pass


class ServiceNote(ConnectWiseModel):
    id: int | None = None
    ticket_id: int | None = Field(default=None, alias='ticketId')
    text: str | None = None
    detail_description_flag: bool | None = Field(
        default=None, alias='detailDescriptionFlag'
    )
    internal_analysis_flag: bool | None = Field(
        default=None, alias='internalAnalysisFlag'
    )
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    issue_flag: bool | None = Field(default=None, alias='issueFlag')
    member: MemberReference | None = None
    contact: ContactReference | None = None
    customer_updated_flag: bool | None = Field(
        default=None, alias='customerUpdatedFlag'
    )
    process_notifications: bool | None = Field(
        default=None, alias='processNotifications'
    )
    date_created: str | None = Field(default=None, alias='dateCreated')
    created_by: str | None = Field(default=None, alias='createdBy')
    internal_flag: bool | None = Field(default=None, alias='internalFlag')
    external_flag: bool | None = Field(default=None, alias='externalFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceRevenueReference(AgreementRevenueReference):
    pass


class ServiceSignoff(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    visible_logo_flag: bool | None = Field(default=None, alias='visibleLogoFlag')
    company_info_flag: bool | None = Field(default=None, alias='companyInfoFlag')
    billing_terms_flag: bool | None = Field(default=None, alias='billingTermsFlag')
    summary_flag: bool | None = Field(default=None, alias='summaryFlag')
    discussion_flag: bool | None = Field(default=None, alias='discussionFlag')
    task_flag: bool | None = Field(default=None, alias='taskFlag')
    """
    On add/post, if this is set to true but no value is set for task, task is defaulted to ServiceTasks.All.
    """
    task: Literal['All', 'Closed', 'Open'] | None = None
    """
    On add/post, if this is set but no value is set for taskFlag, taskFlag is set to true.
    """
    configurations_flag: bool | None = Field(default=None, alias='configurationsFlag')
    internal_notes_flag: bool | None = Field(default=None, alias='internalNotesFlag')
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    time_flag: bool | None = Field(default=None, alias='timeFlag')
    """
    On add/post, if any time related flag is set to true, this is also set to true.
    """
    time_member_flag: bool | None = Field(default=None, alias='timeMemberFlag')
    time_date_flag: bool | None = Field(default=None, alias='timeDateFlag')
    time_start_end_flag: bool | None = Field(default=None, alias='timeStartEndFlag')
    time_bill_flag: bool | None = Field(default=None, alias='timeBillFlag')
    time_hours_flag: bool | None = Field(default=None, alias='timeHoursFlag')
    time_rate_flag: bool | None = Field(default=None, alias='timeRateFlag')
    time_extended_amount_flag: bool | None = Field(
        default=None, alias='timeExtendedAmountFlag'
    )
    time_work_type_flag: bool | None = Field(default=None, alias='timeWorkTypeFlag')
    time_agreement_flag: bool | None = Field(default=None, alias='timeAgreementFlag')
    time_notes_flag: bool | None = Field(default=None, alias='timeNotesFlag')
    time_manual_flag: bool | None = Field(default=None, alias='timeManualFlag')
    time_manual_entry: int | None = Field(default=None, alias='timeManualEntry')
    time_tax_flag: bool | None = Field(default=None, alias='timeTaxFlag')
    expense_flag: bool | None = Field(default=None, alias='expenseFlag')
    """
    On add/post, if any expense related flag is set to true, this is also set to true.
    """
    expense_date_flag: bool | None = Field(default=None, alias='expenseDateFlag')
    expense_member_flag: bool | None = Field(default=None, alias='expenseMemberFlag')
    expense_type_flag: bool | None = Field(default=None, alias='expenseTypeFlag')
    expense_bill_flag: bool | None = Field(default=None, alias='expenseBillFlag')
    expense_amount_flag: bool | None = Field(default=None, alias='expenseAmountFlag')
    expense_agreement_flag: bool | None = Field(
        default=None, alias='expenseAgreementFlag'
    )
    expense_notes_flag: bool | None = Field(default=None, alias='expenseNotesFlag')
    expense_tax_flag: bool | None = Field(default=None, alias='expenseTaxFlag')
    expense_manual_flag: bool | None = Field(default=None, alias='expenseManualFlag')
    expense_manual_entry: int | None = Field(default=None, alias='expenseManualEntry')
    product_flag: bool | None = Field(default=None, alias='productFlag')
    """
    On add/post, if any product related flag is set to true, this is also set to true.
    """
    product_description_flag: bool | None = Field(
        default=None, alias='productDescriptionFlag'
    )
    product_bill_flag: bool | None = Field(default=None, alias='productBillFlag')
    product_quantity_flag: bool | None = Field(
        default=None, alias='productQuantityFlag'
    )
    product_price_flag: bool | None = Field(default=None, alias='productPriceFlag')
    product_extended_amount_flag: bool | None = Field(
        default=None, alias='productExtendedAmountFlag'
    )
    product_agreement_flag: bool | None = Field(
        default=None, alias='productAgreementFlag'
    )
    product_manual_flag: bool | None = Field(default=None, alias='productManualFlag')
    product_manual_entry: int | None = Field(default=None, alias='productManualEntry')
    product_tax_flag: bool | None = Field(default=None, alias='productTaxFlag')
    technician_signoff_flag: bool | None = Field(
        default=None, alias='technicianSignoffFlag'
    )
    customer_signoff_text_flag: bool | None = Field(
        default=None, alias='customerSignoffTextFlag'
    )
    """
    On add/post, if customerSignoffText.Length > 0, this is set to true.
    """
    customer_signoff_text: str | None = Field(default=None, alias='customerSignoffText')
    """
     Max length: 4000;
    """
    customer_signoff_fields_flag: bool | None = Field(
        default=None, alias='customerSignoffFieldsFlag'
    )
    billing_methods_text_flag: bool | None = Field(
        default=None, alias='billingMethodsTextFlag'
    )
    """
    On add/post, if billingMethodsText.Length > 0, this is set to true.
    """
    billing_methods_text: str | None = Field(default=None, alias='billingMethodsText')
    """
     Max length: 2000;
    """
    credit_card_fields_flag: bool | None = Field(
        default=None, alias='creditCardFieldsFlag'
    )
    default_ff_flag: bool | None = Field(default=None, alias='defaultFFFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceSignoffInfo(AddressFormatInfo):
    pass


class ServiceSignoffReference(ActivityReference):
    pass


class ServiceSourceReference(ActivityReference):
    pass


class ServiceStatusReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    sort: int | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceSubTypeReference(ActivityReference):
    pass


class ServiceSurvey(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    header_include_logo_flag: bool | None = Field(
        default=None, alias='headerIncludeLogoFlag'
    )
    header_text: str | None = Field(default=None, alias='headerText')
    """
     Max length: 4000;
    """
    header_text_visible_flag: bool | None = Field(
        default=None, alias='headerTextVisibleFlag'
    )
    footer_text: str | None = Field(default=None, alias='footerText')
    """
     Max length: 500;
    """
    footer_text_visible_flag: bool | None = Field(
        default=None, alias='footerTextVisibleFlag'
    )
    thank_you_text: str | None = Field(default=None, alias='thankYouText')
    """
     Max length: 4000;
    """
    notify_who: GenericIdIdentifierReference | None = Field(
        default=None, alias='notifyWho'
    )
    notify_who_visible_flag: bool | None = Field(
        default=None, alias='notifyWhoVisibleFlag'
    )
    notify_member: MemberReference | None = Field(default=None, alias='notifyMember')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceSurveyQuestionOption(ConnectWiseModel):
    include_flag: bool | None = Field(default=None, alias='includeFlag')
    caption: str | None = None
    points: int | None = None


class ServiceSurveyReference(ActivityReference):
    pass


class ServiceTeamReference(ActivityReference):
    pass


class ServiceTemplateInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    template_flag: bool | None = Field(default=None, alias='templateFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTemplateReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    summary: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTicketLink(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    enabled_flag: bool | None = Field(default=None, alias='enabledFlag')
    link_text: str = Field(..., alias='linkText')
    """
     Max length: 50;
    """
    url: str
    """
     Max length: 1000;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTicketLinkInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    link_text: str | None = Field(default=None, alias='linkText')
    url: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTypeReference(ActivityReference):
    pass


class SetupScreen(ConnectWiseModel):
    id: int | None = None
    category: str | None = None
    name: str | None = None
    description: str | None = None
    module_description: str | None = Field(default=None, alias='moduleDescription')
    module_identifier: str | None = Field(default=None, alias='moduleIdentifier')
    module_name: str | None = Field(default=None, alias='moduleName')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Severity(Impact):
    pass


class ShipmentMethod(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    tracking_url: str | None = Field(default=None, alias='trackingUrl')
    """
     Max length: 200;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ShipmentMethodInfo(ActivityReference):
    pass


class ShipmentMethodReference(ActivityReference):
    pass


class SicCodeReference(ActivityReference):
    pass


class SiteReference(ActivityReference):
    pass


class SkillCategory(ContactDepartment):
    pass


class SkillCategoryReference(ActivityReference):
    pass


class SkillInfo(ActivityReference):
    pass


class SkillReference(ActivityReference):
    pass


class SLA(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 25;
    """
    based_on: Literal['AllHours', 'Customer', 'MyCalendar', 'Custom'] = Field(
        ..., alias='basedOn'
    )
    custom_calendar: CalendarReference | None = Field(
        default=None, alias='customCalendar'
    )
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    application_order: int | None = Field(default=None, alias='applicationOrder')
    hi_impact_hi_urgency: PriorityReference | None = Field(
        default=None, alias='hiImpactHiUrgency'
    )
    hi_impact_med_urgency: PriorityReference | None = Field(
        default=None, alias='hiImpactMedUrgency'
    )
    hi_impact_low_urgency: PriorityReference | None = Field(
        default=None, alias='hiImpactLowUrgency'
    )
    med_impact_hi_urgency: PriorityReference | None = Field(
        default=None, alias='medImpactHiUrgency'
    )
    med_impact_med_urgency: PriorityReference | None = Field(
        default=None, alias='medImpactMedUrgency'
    )
    med_impact_low_urgency: PriorityReference | None = Field(
        default=None, alias='medImpactLowUrgency'
    )
    low_impact_hi_urgency: PriorityReference | None = Field(
        default=None, alias='lowImpactHiUrgency'
    )
    low_impact_med_urgency: PriorityReference | None = Field(
        default=None, alias='lowImpactMedUrgency'
    )
    low_impact_low_urgency: PriorityReference | None = Field(
        default=None, alias='lowImpactLowUrgency'
    )
    respond_hours: float | None = Field(default=None, alias='respondHours')
    respond_percent: int | None = Field(default=None, alias='respondPercent')
    plan_within: float | None = Field(default=None, alias='planWithin')
    plan_within_percent: int | None = Field(default=None, alias='planWithinPercent')
    resolution_hours: float | None = Field(default=None, alias='resolutionHours')
    resolution_percent: int | None = Field(default=None, alias='resolutionPercent')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SLAInfo(ActivityReference):
    pass


class SLAReference(ActivityReference):
    pass


class Source(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    entered_by: str | None = Field(default=None, alias='enteredBy')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SourceInfo(ActivityReference):
    pass


class SsoConfiguration(ConnectWiseModel):
    id: int | None = None
    """
    Unique identifier of the SSO Configuration
    """
    name: str
    """
    Descriptor of the SSO Configuration Max length: 100;
    """
    sso_type: Literal['CWSSO', 'SAML'] = Field(..., alias='ssoType')
    """
    Type of SSO Configuration
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    """
    Whether the SSO configuration is not active
    """
    saml_entity_id: str | None = Field(default=None, alias='samlEntityId')
    """
    SAML Identity Provider Id Max length: 1000;
    """
    saml_sign_in_url: str | None = Field(default=None, alias='samlSignInUrl')
    """
    Sign in url for the SAML Identity Provider Max length: 1000;
    """
    saml_idp_certificate: str | None = Field(default=None, alias='samlIdpCertificate')
    """
    Public certificate for Identity Provider signatures
    """
    saml_certificate_name: str | None = Field(default=None, alias='samlCertificateName')
    """
    Name of the SAML certificate. Metadata on SAML_Idp_Certificate
    """
    saml_certificate_issued_to: str | None = Field(
        default=None, alias='samlCertificateIssuedTo'
    )
    """
    Who the SAML certificate was issued to. Metadata on SAML_Idp_Certificate
    """
    saml_certificate_thumbprint: str | None = Field(
        default=None, alias='samlCertificateThumbprint'
    )
    """
    Thumbprint of the SAML certificate. Metadata on SAML_Idp_Certificate
    """
    saml_certificate_valid_from: datetime | None = Field(
        default=None, alias='samlCertificateValidFrom'
    )
    """
    Date when the SAML certificate becomes valid. Metadata on SAML_Idp_Certificate
    """
    saml_certificate_valid_to: datetime | None = Field(
        default=None, alias='samlCertificateValidTo'
    )
    """
    Date when the SAML certificate is no longer valid. Metadata on SAML_Idp_Certificate
    """
    location_ids: list[int] = Field(..., alias='locationIds')
    """
    The locations where the SAML Idp Configuration is used
    """
    client_id: str | None = Field(default=None, alias='clientId')
    """
    Client identity for this configuration of ConnectWise SSO Max length: 1000;
    """
    sts_base_url: str | None = Field(default=None, alias='stsBaseUrl')
    """
    Sign in URL for ConnectWise SSO
    """
    sts_user_admin_url: str | None = Field(default=None, alias='stsUserAdminUrl')
    """
    User Admin Url for ConnectWise SSO
    """
    token: str | None = None
    submitted_member_count: int | None = Field(
        default=None, alias='submittedMemberCount'
    )
    all_members_submitted: bool | None = Field(
        default=None, alias='allMembersSubmitted'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    is_sso_on_by_default: bool | None = Field(default=None, alias='isSsoOnByDefault')


class SsoUser(ConnectWiseModel):
    id: int | None = None
    sso_user_id: str | None = Field(default=None, alias='ssoUserId')
    user_name: str | None = Field(default=None, alias='userName')
    first_name: str | None = Field(default=None, alias='firstName')
    last_name: str | None = Field(default=None, alias='lastName')
    email: str | None = None
    email_confirmed: bool | None = Field(default=None, alias='emailConfirmed')
    disabled_flag: bool | None = Field(default=None, alias='disabledFlag')
    linked_flag: bool | None = Field(default=None, alias='linkedFlag')
    date_entered: str | None = Field(default=None, alias='dateEntered')
    last_updated: str | None = Field(default=None, alias='lastUpdated')
    linked_member: MemberReference | None = Field(default=None, alias='linkedMember')


class State(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 50;
    """
    name: str
    """
     Max length: 50;
    """
    country: CountryReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class StateInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    identifier: str | None = None
    country: CountryReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class StateReference(CatalogItemReference):
    pass


class StatusIndicator(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    color: str | None = None
    icon: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class StatusIndicatorReference(CatalogItemReference):
    pass


class StructureReference(ActivityReference):
    pass


class SubCategory(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    category: ProductCategoryReference
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SubCategoryInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    category: ProductCategoryReference | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SuccessResponse(ConnectWiseModel):
    success: bool | None = None
    message: str | None = None


class Survey(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    instructions: str | None = None
    """
     Max length: 1000;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SurveyInfo(CategoryInfo):
    pass


class SurveyOption(ConnectWiseModel):
    id: int | None = None
    caption: str
    """
     Max length: 100;
    """
    points: int
    visibleflag: bool | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SurveyQuestionReference(ConfigurationTypeQuestionReference):
    pass


class SurveyReference(ActivityReference):
    pass


class SurveyResultDetail(ConnectWiseModel):
    question_id: int | None = Field(default=None, alias='questionId')
    answer: dict[str, Any] | None = None
    """
    If question type is Selection, this should be the option array index.
    """


class SystemDepartmentReference(CatalogItemReference):
    pass


class SystemLocationReference(ActivityReference):
    pass


class SystemMenuEntryReference(ActivityReference):
    pass


class SystemSetting(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    value: str
    value_type: str | None = Field(default=None, alias='valueType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Task(ConnectWiseModel):
    id: int | None = None
    ticket_id: int | None = Field(default=None, alias='ticketId')
    notes: str | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    priority: int | None = None
    schedule: ScheduleEntryReference | None = None
    code: ServiceCodeReference | None = None
    resolution: str | None = None
    child_schedule_action: Literal['Transfer', 'Delete', 'Done'] | None = Field(
        default=None, alias='childScheduleAction'
    )
    child_ticket_id: int | None = Field(default=None, alias='childTicketId')
    summary: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxCode(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 8;
    """
    description: str
    """
     Max length: 50;
    """
    invoice_caption: str = Field(..., alias='invoiceCaption')
    """
     Max length: 25;
    """
    country: CountryReference | None = None
    effective_date: datetime = Field(..., alias='effectiveDate')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    display_on_invoice_flag: bool | None = Field(
        default=None, alias='displayOnInvoiceFlag'
    )
    canada_calculate_gst_flag: bool | None = Field(
        default=None, alias='canadaCalculateGSTFlag'
    )
    cancel_date: datetime | None = Field(default=None, alias='cancelDate')
    level_one_rate: float | None = Field(default=None, alias='levelOneRate')
    level_one_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelOneRateType'
    )
    level_one_taxable_max: float | None = Field(
        default=None, alias='levelOneTaxableMax'
    )
    level_one_caption: str | None = Field(default=None, alias='levelOneCaption')
    """
     Max length: 25;
    """
    level_one_tax_code_xref: str | None = Field(
        default=None, alias='levelOneTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_one_agency_xref: str | None = Field(default=None, alias='levelOneAgencyXref')
    """
     Max length: 100;
    """
    level_one_services_flag: bool | None = Field(
        default=None, alias='levelOneServicesFlag'
    )
    level_one_expenses_flag: bool | None = Field(
        default=None, alias='levelOneExpensesFlag'
    )
    level_one_products_flag: bool | None = Field(
        default=None, alias='levelOneProductsFlag'
    )
    level_one_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelOneApplySingleUnitFlag'
    )
    level_one_apply_single_unit_min: float | None = Field(
        default=None, alias='levelOneApplySingleUnitMin'
    )
    level_one_apply_single_unit_max: float | None = Field(
        default=None, alias='levelOneApplySingleUnitMax'
    )
    level_two_rate: float | None = Field(default=None, alias='levelTwoRate')
    level_two_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelTwoRateType'
    )
    level_two_taxable_max: float | None = Field(
        default=None, alias='levelTwoTaxableMax'
    )
    level_two_caption: str | None = Field(default=None, alias='levelTwoCaption')
    """
     Max length: 25;
    """
    level_two_tax_code_xref: str | None = Field(
        default=None, alias='levelTwoTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_two_agency_xref: str | None = Field(default=None, alias='levelTwoAgencyXref')
    """
     Max length: 100;
    """
    level_two_services_flag: bool | None = Field(
        default=None, alias='levelTwoServicesFlag'
    )
    level_two_expenses_flag: bool | None = Field(
        default=None, alias='levelTwoExpensesFlag'
    )
    level_two_products_flag: bool | None = Field(
        default=None, alias='levelTwoProductsFlag'
    )
    level_two_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelTwoApplySingleUnitFlag'
    )
    level_two_apply_single_unit_min: float | None = Field(
        default=None, alias='levelTwoApplySingleUnitMin'
    )
    level_two_apply_single_unit_max: float | None = Field(
        default=None, alias='levelTwoApplySingleUnitMax'
    )
    level_three_rate: float | None = Field(default=None, alias='levelThreeRate')
    level_three_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelThreeRateType'
    )
    level_three_taxable_max: float | None = Field(
        default=None, alias='levelThreeTaxableMax'
    )
    level_three_caption: str | None = Field(default=None, alias='levelThreeCaption')
    """
     Max length: 25;
    """
    level_three_tax_code_xref: str | None = Field(
        default=None, alias='levelThreeTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_three_agency_xref: str | None = Field(
        default=None, alias='levelThreeAgencyXref'
    )
    """
     Max length: 100;
    """
    level_three_services_flag: bool | None = Field(
        default=None, alias='levelThreeServicesFlag'
    )
    level_three_expenses_flag: bool | None = Field(
        default=None, alias='levelThreeExpensesFlag'
    )
    level_three_products_flag: bool | None = Field(
        default=None, alias='levelThreeProductsFlag'
    )
    level_three_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelThreeApplySingleUnitFlag'
    )
    level_three_apply_single_unit_min: float | None = Field(
        default=None, alias='levelThreeApplySingleUnitMin'
    )
    level_three_apply_single_unit_max: float | None = Field(
        default=None, alias='levelThreeApplySingleUnitMax'
    )
    level_four_rate: float | None = Field(default=None, alias='levelFourRate')
    level_four_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelFourRateType'
    )
    level_four_taxable_max: float | None = Field(
        default=None, alias='levelFourTaxableMax'
    )
    level_four_caption: str | None = Field(default=None, alias='levelFourCaption')
    """
     Max length: 25;
    """
    level_four_tax_code_xref: str | None = Field(
        default=None, alias='levelFourTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_four_agency_xref: str | None = Field(
        default=None, alias='levelFourAgencyXref'
    )
    """
     Max length: 100;
    """
    level_four_services_flag: bool | None = Field(
        default=None, alias='levelFourServicesFlag'
    )
    level_four_expenses_flag: bool | None = Field(
        default=None, alias='levelFourExpensesFlag'
    )
    level_four_products_flag: bool | None = Field(
        default=None, alias='levelFourProductsFlag'
    )
    level_four_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelFourApplySingleUnitFlag'
    )
    level_four_apply_single_unit_min: float | None = Field(
        default=None, alias='levelFourApplySingleUnitMin'
    )
    level_four_apply_single_unit_max: float | None = Field(
        default=None, alias='levelFourApplySingleUnitMax'
    )
    level_five_rate: float | None = Field(default=None, alias='levelFiveRate')
    level_five_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelFiveRateType'
    )
    level_five_taxable_max: float | None = Field(
        default=None, alias='levelFiveTaxableMax'
    )
    level_five_caption: str | None = Field(default=None, alias='levelFiveCaption')
    """
     Max length: 25;
    """
    level_five_tax_code_xref: str | None = Field(
        default=None, alias='levelFiveTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_five_agency_xref: str | None = Field(
        default=None, alias='levelFiveAgencyXref'
    )
    """
     Max length: 100;
    """
    level_five_services_flag: bool | None = Field(
        default=None, alias='levelFiveServicesFlag'
    )
    level_five_expenses_flag: bool | None = Field(
        default=None, alias='levelFiveExpensesFlag'
    )
    level_five_products_flag: bool | None = Field(
        default=None, alias='levelFiveProductsFlag'
    )
    level_five_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelFiveApplySingleUnitFlag'
    )
    level_five_apply_single_unit_min: float | None = Field(
        default=None, alias='levelFiveApplySingleUnitMin'
    )
    level_five_apply_single_unit_max: float | None = Field(
        default=None, alias='levelFiveApplySingleUnitMax'
    )
    level_six_rate: float | None = Field(default=None, alias='levelSixRate')
    level_six_rate_type: Literal['Amount', 'Percent'] | None = Field(
        default=None, alias='levelSixRateType'
    )
    level_six_taxable_max: float | None = Field(
        default=None, alias='levelSixTaxableMax'
    )
    level_six_caption: str | None = Field(default=None, alias='levelSixCaption')
    """
     Max length: 25;
    """
    level_six_tax_code_xref: str | None = Field(
        default=None, alias='levelSixTaxCodeXref'
    )
    """
     Max length: 50;
    """
    level_six_agency_xref: str | None = Field(default=None, alias='levelSixAgencyXref')
    """
     Max length: 100;
    """
    level_six_services_flag: bool | None = Field(
        default=None, alias='levelSixServicesFlag'
    )
    level_six_expenses_flag: bool | None = Field(
        default=None, alias='levelSixExpensesFlag'
    )
    level_six_products_flag: bool | None = Field(
        default=None, alias='levelSixProductsFlag'
    )
    level_six_apply_single_unit_flag: bool | None = Field(
        default=None, alias='levelSixApplySingleUnitFlag'
    )
    level_six_apply_single_unit_min: float | None = Field(
        default=None, alias='levelSixApplySingleUnitMin'
    )
    level_six_apply_single_unit_max: float | None = Field(
        default=None, alias='levelSixApplySingleUnitMax'
    )
    work_role_ids: list[int] | None = Field(default=None, alias='workRoleIds')
    """
    Array of work role exemptions for the tax code.
    """
    add_all_work_roles: bool | None = Field(default=None, alias='addAllWorkRoles')
    remove_all_work_roles: bool | None = Field(default=None, alias='removeAllWorkRoles')
    expense_type_ids: list[int] | None = Field(default=None, alias='expenseTypeIds')
    """
    Array of expense type exemptions for the tax code.
    """
    add_all_expense_types: bool | None = Field(default=None, alias='addAllExpenseTypes')
    remove_all_expense_types: bool | None = Field(
        default=None, alias='removeAllExpenseTypes'
    )
    product_type_ids: list[int] | None = Field(default=None, alias='productTypeIds')
    """
    Array of product type exemptions for the tax code.
    """
    add_all_product_types: bool | None = Field(default=None, alias='addAllProductTypes')
    remove_all_product_types: bool | None = Field(
        default=None, alias='removeAllProductTypes'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxCodeInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    description: str | None = None
    effective_date: str | None = Field(default=None, alias='effectiveDate')
    cancel_date: str | None = Field(default=None, alias='cancelDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxCodeLevel(ConnectWiseModel):
    id: int | None = None
    tax_level: int | None = Field(default=None, alias='taxLevel')
    tax_rate: float = Field(..., alias='taxRate')
    rate_type: Literal['Amount', 'Percent'] = Field(..., alias='rateType')
    taxable_max: float | None = Field(default=None, alias='taxableMax')
    caption: str | None = None
    """
     Max length: 25;
    """
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    """
     Max length: 50;
    """
    agency_xref: str | None = Field(default=None, alias='agencyXref')
    """
     Max length: 100;
    """
    tax_services_flag: bool | None = Field(default=None, alias='taxServicesFlag')
    tax_expenses_flag: bool | None = Field(default=None, alias='taxExpensesFlag')
    tax_products_flag: bool | None = Field(default=None, alias='taxProductsFlag')
    single_unit_flag: bool | None = Field(default=None, alias='singleUnitFlag')
    single_unit_minimum: float | None = Field(default=None, alias='singleUnitMinimum')
    single_unit_maximum: float | None = Field(default=None, alias='singleUnitMaximum')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxCodeLevelReference(ActivityReference):
    pass


class TaxCodeReference(ActivityReference):
    pass


class TaxCodeXRef(ConnectWiseModel):
    id: int | None = None
    description: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    level_one: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelOne'
    )
    level_two: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelTwo'
    )
    level_three: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelThree'
    )
    level_four: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelFour'
    )
    level_five: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelFive'
    )
    level_six: Literal['NonTaxable', 'Taxable'] | None = Field(
        default=None, alias='levelSix'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    taxable_levels: list[int] | None = Field(default=None, alias='taxableLevels')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxIntegration(ConnectWiseModel):
    tax_integration_type: Literal['Avalara'] | None = Field(
        default=None, alias='taxIntegrationType'
    )
    id: int | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    """
     Max length: 50;
    """
    license_key: str | None = Field(default=None, alias='licenseKey')
    """
     Max length: 50;
    """
    service_url: str | None = Field(default=None, alias='serviceUrl')
    """
     Max length: 250;
    """
    company_code: str | None = Field(default=None, alias='companyCode')
    """
     Max length: 50;
    """
    time_tax_code: str | None = Field(default=None, alias='timeTaxCode')
    """
     Max length: 50;
    """
    expense_tax_code: str | None = Field(default=None, alias='expenseTaxCode')
    """
     Max length: 50;
    """
    product_tax_code: str | None = Field(default=None, alias='productTaxCode')
    """
     Max length: 50;
    """
    invoice_amount_tax_code: str | None = Field(
        default=None, alias='invoiceAmountTaxCode'
    )
    """
     Max length: 50;
    """
    enabled_flag: bool | None = Field(default=None, alias='enabledFlag')
    commit_transactions_flag: bool | None = Field(
        default=None, alias='commitTransactionsFlag'
    )
    sales_invoice_flag: bool | None = Field(default=None, alias='salesInvoiceFlag')
    freight_tax_code: str | None = Field(default=None, alias='freightTaxCode')
    """
     Max length: 50;
    """
    accounting_integration_flag: bool | None = Field(
        default=None, alias='accountingIntegrationFlag'
    )
    tax_line_flag: bool | None = Field(default=None, alias='taxLineFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxIntegrationInfo(ConnectWiseModel):
    id: int | None = None
    enabled_flag: bool | None = Field(default=None, alias='enabledFlag')
    tax_integration_type: Literal['Avalara'] | None = Field(
        default=None, alias='taxIntegrationType'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Team(ConnectWiseModel):
    id: int | None = None
    type: Literal['Individual', 'Team']
    member: MemberReference | None = None
    sales_team: SalesTeamReference | None = Field(default=None, alias='salesTeam')
    commission_percent: int | None = Field(default=None, alias='commissionPercent')
    referral_flag: bool | None = Field(default=None, alias='referralFlag')
    opportunity_id: int | None = Field(default=None, alias='opportunityId')
    responsible_flag: bool | None = Field(default=None, alias='responsibleFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TeamMember(ConnectWiseModel):
    id: int | None = None
    board: BoardReference | None = None
    team: ServiceTeamReference | None = None
    member: MemberReference | None = None
    team_leader_flag: bool | None = Field(default=None, alias='teamLeaderFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TeamRole(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 20;
    """
    account_manager_flag: bool | None = Field(default=None, alias='accountManagerFlag')
    tech_flag: bool | None = Field(default=None, alias='techFlag')
    sales_flag: bool | None = Field(default=None, alias='salesFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TeamRoleInfo(ActivityReference):
    pass


class TeamRoleReference(ActivityReference):
    pass


class TemplateGeneratedCountsModel(ConnectWiseModel):
    service_count: int | None = Field(default=None, alias='serviceCount')
    schedule_count: int | None = Field(default=None, alias='scheduleCount')


class TicketBundle(ConnectWiseModel):
    child_ticket_ids: list[int] | None = Field(default=None, alias='childTicketIds')


class TicketInfo(ConnectWiseModel):
    id: int | None = None
    summary: str | None = None
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TicketMerge(ConnectWiseModel):
    merge_ticket_ids: list[int] = Field(..., alias='mergeTicketIds')
    status: ServiceStatusReference | None = None


class TicketNote(ConnectWiseModel):
    id: int | None = None
    ticket_id: int | None = Field(default=None, alias='ticketId')
    text: str | None = None
    detail_description_flag: bool | None = Field(
        default=None, alias='detailDescriptionFlag'
    )
    internal_analysis_flag: bool | None = Field(
        default=None, alias='internalAnalysisFlag'
    )
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    issue_flag: bool | None = Field(default=None, alias='issueFlag')
    member: MemberReference | None = None
    contact: ContactReference | None = None
    customer_updated_flag: bool | None = Field(
        default=None, alias='customerUpdatedFlag'
    )
    process_notifications: bool | None = Field(
        default=None, alias='processNotifications'
    )
    internal_flag: bool | None = Field(default=None, alias='internalFlag')
    external_flag: bool | None = Field(default=None, alias='externalFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TicketReference(ConnectWiseModel):
    id: int | None = None
    summary: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TicketSync(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 80;
    """
    vendor_type: Literal['Zenith'] = Field(..., alias='vendorType')
    integrator_login: IntegratorLoginReference | None = Field(
        default=None, alias='integratorLogin'
    )
    company: CompanyReference | None = None
    url: str
    user_name: str | None = Field(default=None, alias='userName')
    password: str | None = None
    psg: str | None = None
    problem_description_flag: bool | None = Field(
        default=None, alias='problemDescriptionFlag'
    )
    internal_analysis_flag: bool | None = Field(
        default=None, alias='internalAnalysisFlag'
    )
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TicketTask(ConnectWiseModel):
    id: int | None = None
    ticket_id: int | None = Field(default=None, alias='ticketId')
    notes: str | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    priority: int | None = None
    schedule: ScheduleEntryReference | None = None
    code: ServiceCodeReference | None = None
    resolution: str | None = None
    summary: str | None = None
    child_schedule_action: Literal['Transfer', 'Delete', 'Done'] | None = Field(
        default=None, alias='childScheduleAction'
    )
    child_ticket_id: int | None = Field(default=None, alias='childTicketId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeAccrual(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    vacation_flag: bool | None = Field(default=None, alias='vacationFlag')
    """
    if vacationFlag is set to false, system will clear out or ingore the values of vacationAvailableType, vacationCarryoverAllowedFlag, vacationCarryoverLimit
    """
    vacation_available_type: Literal['AnniversaryYear', 'CalendarYear'] | None = Field(
        default=None, alias='vacationAvailableType'
    )
    vacation_carryover_allowed_flag: bool | None = Field(
        default=None, alias='vacationCarryoverAllowedFlag'
    )
    vacation_carryover_limit: float | None = Field(
        default=None, alias='vacationCarryoverLimit'
    )
    sick_flag: bool | None = Field(default=None, alias='sickFlag')
    """
    if sickFlag is set to false, system will clear out or ignore the values of sickAvailableType, sickCarryoverAllowedFlag, sickCarryoverLimit
    """
    sick_available_type: Literal['AnniversaryYear', 'CalendarYear'] | None = Field(
        default=None, alias='sickAvailableType'
    )
    sick_carryover_allowed_flag: bool | None = Field(
        default=None, alias='sickCarryoverAllowedFlag'
    )
    sick_carryover_limit: float | None = Field(default=None, alias='sickCarryoverLimit')
    pto_flag: bool | None = Field(default=None, alias='ptoFlag')
    """
    if ptoFlag is set to false, system will clear out or ignore the values of ptoAvailableType, ptoCarryoverAllowedFlag, ptoCarryoverLimit
    """
    pto_available_type: Literal['AnniversaryYear', 'CalendarYear'] | None = Field(
        default=None, alias='ptoAvailableType'
    )
    pto_carryover_allowed_flag: bool | None = Field(
        default=None, alias='ptoCarryoverAllowedFlag'
    )
    pto_carryover_limit: float | None = Field(default=None, alias='ptoCarryoverLimit')
    holiday_flag: bool | None = Field(default=None, alias='holidayFlag')
    """
    if holidayFlag is set to false, system will clear out or ignore the values of holidayAvailableType, holidayCarryoverAllowedFlag, holidayCarryoverLimit
    """
    holiday_available_type: Literal['AnniversaryYear', 'CalendarYear'] | None = Field(
        default=None, alias='holidayAvailableType'
    )
    holiday_carryover_allowed_flag: bool | None = Field(
        default=None, alias='holidayCarryoverAllowedFlag'
    )
    holiday_carryover_limit: float | None = Field(
        default=None, alias='holidayCarryoverLimit'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeAccrualReference(ActivityReference):
    pass


class TimeEntryAudit(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    source: Literal[
        'None',
        'Member',
        'API',
        'Workflow',
        'Portal',
        'Mobile',
        'Network',
        'EmailConnector',
        'MassMaintenance',
        'Application',
        'SystemAPI',
        'Conversion',
    ] | None = None
    type: Literal[
        'Activity',
        'CloseDate',
        'Company',
        'Contact',
        'Conversion',
        'Document',
        'Forecast',
        'Note',
        'Notes',
        'Opportunity',
        'Products',
        'Stage',
        'Status',
        'Surveys',
        'Team',
        'Tracks',
        'Configuration',
        'ConfigurationQuestions',
        'DeviceBackupDetails',
        'Tickets',
        'Subject',
        'ActivityOverview',
        'Schedule',
        'Resources',
        'ExpenseEntry',
        'Member',
        'Date',
        'Classification',
        'Amount',
        'ExpenseType',
        'WorkType',
        'WorkRole',
        'Mileage',
        'Billing',
        'ExpenseHeader',
        'Project',
        'TimeEntry',
        'TicketStatus',
        'DateTime',
        'DeductHours',
        'ActualHours',
        'Invoice',
        'CompanyFinance',
        'Billable',
        'SalesOrder',
        'Shipping',
        'Profile',
        'Group',
        'GroupContact',
        'GroupCompany',
        'Options',
        'Site',
        'Agreement',
        'Addition',
        'Adjustment',
        'Microsoft365',
        'API',
        'ProjectFinance',
        'CompanyProfile',
        'CompanyTeam',
        'CompanyMgmt',
        'InvoiceTotal',
        'BillingInformation',
        'ShippingInformation',
        'BillingStatus',
        'Location',
        'Department',
        'Territory',
        'Payment',
        'Credit',
        'SubcontractorInformation',
        'InvoicingParameters',
        'ApplicationParameters',
        'Finance',
        'Invoicing',
        'Email',
        'Batching',
        'KnowledgeBase',
        'KbArticle',
        'KnowledgeBaseApproval',
        'KnowledgeBaseTicket',
        'ManageNetwork',
        'Tasks',
        'CustomField',
        'ScreenConnect',
        'SLA',
        'Ticket',
        'Workflow',
        'Record',
        'CombinedTickets',
        'Template',
        'PurchaseOrder',
        'Meeting',
        'RmaOverview',
        'ReturnedBy',
        'PurchasedFromVendor',
        'WarrantyVendor',
        'RepairVendor',
        'AdditionalDetails',
        'TicketTemplate',
        'AutoGeneration',
        'TimeInternalNote',
        'TimeDiscussion',
        'TimeInternal',
        'TimeResolution',
        'MemberTemplate',
        'Delegation',
        'Skill',
        'Certification',
        'Accrual',
        'ApiKey',
        'Login',
        'Notifications',
        'System',
        'ServiceBoard',
        'ProjectBoard',
        'Scheduling',
        'TimeBillingExpense',
        'CRM',
        'Procurement',
        'JobRole',
        'Details',
        'Authentication',
    ] | None = None
    message: str | None = None
    old_value: str | None = Field(default=None, alias='oldValue')
    new_value: str | None = Field(default=None, alias='newValue')
    value: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeEntryReference(CalendarSetupReference):
    pass


class TimeExpense(ConnectWiseModel):
    id: int | None = None
    tier1_approval_flag: bool | None = Field(default=None, alias='tier1ApprovalFlag')
    tier2_approval_flag: bool | None = Field(default=None, alias='tier2ApprovalFlag')
    disable_time_entry_flag: bool | None = Field(
        default=None, alias='disableTimeEntryFlag'
    )
    require_time_note_flag: bool | None = Field(
        default=None, alias='requireTimeNoteFlag'
    )
    require_expense_note_flag: bool | None = Field(
        default=None, alias='requireExpenseNoteFlag'
    )
    rounding_factor: float | None = Field(default=None, alias='roundingFactor')
    invoice_start: int | None = Field(default=None, alias='invoiceStart')
    default_special_invoice_type: Literal[
        'Agreement',
        'CreditMemo',
        'DownPayment',
        'Miscellaneous',
        'Progress',
        'Standard',
    ] | None = Field(default=None, alias='defaultSpecialInvoiceType')
    internal_company: CompanyReference | None = Field(
        default=None, alias='internalCompany'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimePeriodSetup(ConnectWiseModel):
    id: int | None = None
    period_apply_to: Literal['Both', 'Expense', 'Time'] = Field(
        ..., alias='periodApplyTo'
    )
    year: int
    number_future_periods: int = Field(..., alias='numberFuturePeriods')
    type: Literal['Weekly', 'BiWeekly', 'SemiMonthly', 'Monthly']
    description: str | None = None
    """
     Max length: 100;
    """
    first_period_end_date: date = Field(..., alias='firstPeriodEndDate')
    monthly_period_ends: int | None = Field(default=None, alias='monthlyPeriodEnds')
    """
    Only needed when type is monthly
    """
    semi_monthly_first_period: int | None = Field(
        default=None, alias='semiMonthlyFirstPeriod'
    )
    """
    Only needed when type is semi-monthly
    """
    semi_monthly_second_period: int | None = Field(
        default=None, alias='semiMonthlySecondPeriod'
    )
    """
    Only needed when type is semi-monthly
    """
    semi_monthly_last_day_flag: bool | None = Field(
        default=None, alias='semiMonthlyLastDayFlag'
    )
    last_day_flag: bool | None = Field(default=None, alias='lastDayFlag')
    """
    Only needed when type is monthly
    """
    days_past_end_date: int = Field(..., alias='daysPastEndDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimePeriodSetupDefaults(GLExportSettings):
    pass


class TimePeriodSetupReference(CalendarSetupReference):
    pass


class TimeRevenueReference(AgreementRevenueReference):
    pass


class TimeSheet(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    year: int | None = None
    period: int | None = None
    date_start: str | None = Field(default=None, alias='dateStart')
    date_end: str | None = Field(default=None, alias='dateEnd')
    status: Literal[
        'Open',
        'Rejected',
        'PendingApproval',
        'ErrorsCorrected',
        'PendingProjectApproval',
        'ApprovedByTierOne',
        'RejectBySecondTier',
        'ApprovedByTierTwo',
        'ReadyToBill',
        'Billed',
        'WrittenOff',
        'BilledAgreement',
    ] | None = None
    hours: float | None = None
    deadline: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeSheetAudit(TimeEntryAudit):
    pass


class TimeSheetReference(ActivityReference):
    pass


class TimeSheetTierUpdate(ExpenseReportTierUpdate):
    pass


class TimeZoneReference(ActivityReference):
    pass


class TimeZoneSetup(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    time_zone: TimeZoneReference | None = Field(default=None, alias='timeZone')
    offset: float | None = None
    """
    The hours offset from UTC (+/-)
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    """
    Identifies the default system time zone setup
    """
    daylight_savings_flag: bool | None = Field(
        default=None, alias='daylightSavingsFlag'
    )
    """
    Determined based on system library value for specified timeZone.
                Not able to be used in query params at this time
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeZoneSetupInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    offset: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeZoneSetupReference(ActivityReference):
    pass


class TodayPageCategory(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    sort_order: int = Field(..., alias='sortOrder')
    location: SystemLocationReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Token(ConnectWiseModel):
    public_key: str | None = Field(default=None, alias='publicKey')
    private_key: str | None = Field(default=None, alias='privateKey')
    expiration: str | None = None


class Track(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    notify_action_ids: list[int] | None = Field(default=None, alias='notifyActionIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TrackReference(ActivityReference):
    pass


class TypeSubTypeCampaignSubType(ConnectWiseModel):
    id: int | None = None
    type_id: int | None = Field(default=None, alias='typeId')
    name: str | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnitOfMeasure(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    uom_schedule_xref: str | None = Field(default=None, alias='uomScheduleXref')
    """
     Max length: 31;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnitOfMeasureReference(ActivityReference):
    pass


class UnpostedExpense(ConnectWiseModel):
    id: int | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    department_id: int | None = Field(default=None, alias='departmentId')
    company: CompanyReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    credit_account: str | None = Field(default=None, alias='creditAccount')
    expense_detail_id: int | None = Field(default=None, alias='expenseDetailId')
    expense_type: ExpenseTypeReference | None = Field(default=None, alias='expenseType')
    classification: Literal['NonReimbursable', 'Reimbursable', 'Personal'] | None = None
    gl_type: Literal[
        'AP',
        'AR',
        'EE',
        'EI',
        'EO',
        'IA',
        'IT',
        'P',
        'PF',
        'R',
        'RA',
        'RD',
        'RE',
        'RP',
        'ST',
        'SD',
        'ET',
        'FT',
        'PT',
        'WP',
        'WR',
    ] | None = Field(default=None, alias='glType')
    member: MemberReference | None = None
    date_expense: str | None = Field(default=None, alias='dateExpense')
    charge_code: ChargeCodeReference | None = Field(default=None, alias='chargeCode')
    charge_description: str | None = Field(default=None, alias='chargeDescription')
    in_policy: bool | None = Field(default=None, alias='inPolicy')
    payment_method: PaymentMethodReference | None = Field(
        default=None, alias='paymentMethod'
    )
    currency: CurrencyReference | None = None
    total: float | None = None
    billable_amount: float | None = Field(default=None, alias='billableAmount')
    non_billable_amount: float | None = Field(default=None, alias='nonBillableAmount')
    agreement: AgreementReference | None = None
    agreement_amount_covered: float | None = Field(
        default=None, alias='agreementAmountCovered'
    )
    ticket: TicketReference | None = None
    project: ProjectReference | None = None
    project_phase: ProjectPhaseReference | None = Field(
        default=None, alias='projectPhase'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    avalara_tax_flag: bool | None = Field(default=None, alias='avalaraTaxFlag')
    """
    Used to determine if Avalara tax is enabled.
    """
    item_taxable_flag: bool | None = Field(default=None, alias='itemTaxableFlag')
    sales_tax_amount: float | None = Field(default=None, alias='salesTaxAmount')
    state_tax_flag: bool | None = Field(default=None, alias='stateTaxFlag')
    """
    Set to true if transaction is taxable at the state level.
    """
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    state_tax_amount: float | None = Field(default=None, alias='stateTaxAmount')
    county_tax_flag: bool | None = Field(default=None, alias='countyTaxFlag')
    """
    Set to true if transaction is taxable at the county level.
    """
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    county_tax_amount: float | None = Field(default=None, alias='countyTaxAmount')
    city_tax_flag: bool | None = Field(default=None, alias='cityTaxFlag')
    """
    Set to true if transaction is taxable at the city level.
    """
    city_tax_xref: str | None = Field(default=None, alias='cityTaxXref')
    city_tax_amount: float | None = Field(default=None, alias='cityTaxAmount')
    country_tax_flag: bool | None = Field(default=None, alias='countryTaxFlag')
    """
    Set to true if transaction is taxable at the country level.
    """
    country_tax_xref: str | None = Field(default=None, alias='countryTaxXref')
    country_tax_amount: float | None = Field(default=None, alias='countryTaxAmount')
    composite_tax_flag: bool | None = Field(default=None, alias='compositeTaxFlag')
    """
    Set to true if transaction is taxable at the composite level.
    """
    composite_tax_xref: str | None = Field(default=None, alias='compositeTaxXref')
    composite_tax_amount: float | None = Field(default=None, alias='compositeTaxAmount')
    level_six_tax_flag: bool | None = Field(default=None, alias='levelSixTaxFlag')
    """
    Set to true if transaction is taxable at level six.
    """
    level_six_tax_xref: str | None = Field(default=None, alias='levelSixTaxXref')
    level_six_tax_amount: float | None = Field(default=None, alias='levelSixTaxAmount')
    date_closed: str | None = Field(default=None, alias='dateClosed')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnpostedExpenseTaxableLevel(ConnectWiseModel):
    id: int | None = None
    tax_level: int | None = Field(default=None, alias='taxLevel')
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    tax_amount: float | None = Field(default=None, alias='taxAmount')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnpostedInvoice(ConnectWiseModel):
    id: int | None = None
    billing_log_id: int | None = Field(default=None, alias='billingLogId')
    location_id: int | None = Field(default=None, alias='locationId')
    department_id: int | None = Field(default=None, alias='departmentId')
    company: CompanyReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    invoice_number: str | None = Field(default=None, alias='invoiceNumber')
    invoice_date: str | None = Field(default=None, alias='invoiceDate')
    invoice_type: Literal[
        'Agreement',
        'CreditMemo',
        'DownPayment',
        'Miscellaneous',
        'Progress',
        'Standard',
    ] | None = Field(default=None, alias='invoiceType')
    description: str | None = None
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    due_days: str | None = Field(default=None, alias='dueDays')
    due_date: str | None = Field(default=None, alias='dueDate')
    currency: CurrencyReference | None = None
    sub_total: float | None = Field(default=None, alias='subTotal')
    total: float | None = None
    invoice_taxable_flag: bool | None = Field(default=None, alias='invoiceTaxableFlag')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    avalara_tax_flag: bool | None = Field(default=None, alias='avalaraTaxFlag')
    """
    Used to determine if Avalara tax is enabled.
    """
    item_taxable_flag: bool | None = Field(default=None, alias='itemTaxableFlag')
    sales_tax_amount: float | None = Field(default=None, alias='salesTaxAmount')
    state_tax_flag: bool | None = Field(default=None, alias='stateTaxFlag')
    """
    Set to true if transaction is taxable at the state level.
    """
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    state_tax_amount: float | None = Field(default=None, alias='stateTaxAmount')
    county_tax_flag: bool | None = Field(default=None, alias='countyTaxFlag')
    """
    Set to true if transaction is taxable at the county level.
    """
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    county_tax_amount: float | None = Field(default=None, alias='countyTaxAmount')
    city_tax_flag: bool | None = Field(default=None, alias='cityTaxFlag')
    """
    Set to true if transaction is taxable at the city level.
    """
    city_tax_xref: str | None = Field(default=None, alias='cityTaxXref')
    city_tax_amount: float | None = Field(default=None, alias='cityTaxAmount')
    country_tax_flag: bool | None = Field(default=None, alias='countryTaxFlag')
    """
    Set to true if transaction is taxable at the country level.
    """
    country_tax_xref: str | None = Field(default=None, alias='countryTaxXref')
    country_tax_amount: float | None = Field(default=None, alias='countryTaxAmount')
    composite_tax_flag: bool | None = Field(default=None, alias='compositeTaxFlag')
    """
    Set to true if transaction is taxable at the composite level.
    """
    composite_tax_xref: str | None = Field(default=None, alias='compositeTaxXref')
    composite_tax_amount: float | None = Field(default=None, alias='compositeTaxAmount')
    level_six_tax_flag: bool | None = Field(default=None, alias='levelSixTaxFlag')
    """
    Set to true if transaction is taxable at level six.
    """
    level_six_tax_xref: str | None = Field(default=None, alias='levelSixTaxXref')
    level_six_tax_amount: float | None = Field(default=None, alias='levelSixTaxAmount')
    created_by: str | None = Field(default=None, alias='createdBy')
    date_closed: str | None = Field(default=None, alias='dateClosed')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnpostedInvoiceTaxableLevel(UnpostedExpenseTaxableLevel):
    pass


class UnpostedProcurement(ConnectWiseModel):
    id: int | None = None
    description: str | None = None
    unposted_product_id: str | None = Field(default=None, alias='unpostedProductId')
    location_id: int | None = Field(default=None, alias='locationId')
    department_id: int | None = Field(default=None, alias='departmentId')
    procurement_type: Literal['Purchase', 'Adjustment', 'Transfer'] | None = Field(
        default=None, alias='procurementType'
    )
    purchase_order: PurchaseOrderReference | None = Field(
        default=None, alias='purchaseOrder'
    )
    purchase_date: str | None = Field(default=None, alias='purchaseDate')
    tracking_number: str | None = Field(default=None, alias='trackingNumber')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    currency: CurrencyReference | None = None
    total: float | None = None
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    avalara_tax_flag: bool | None = Field(default=None, alias='avalaraTaxFlag')
    """
    Used to determine if Avalara tax is enabled.
    """
    item_taxable_flag: bool | None = Field(default=None, alias='itemTaxableFlag')
    purchase_order_taxable_flag: bool | None = Field(
        default=None, alias='purchaseOrderTaxableFlag'
    )
    state_tax_flag: bool | None = Field(default=None, alias='stateTaxFlag')
    """
    Set to true if transaction is taxable at the state level.
    """
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    state_tax_amount: float | None = Field(default=None, alias='stateTaxAmount')
    county_tax_flag: bool | None = Field(default=None, alias='countyTaxFlag')
    """
    Set to true if transaction is taxable at the county level.
    """
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    county_tax_amount: float | None = Field(default=None, alias='countyTaxAmount')
    city_tax_flag: bool | None = Field(default=None, alias='cityTaxFlag')
    """
    Set to true if transaction is taxable at the city level.
    """
    city_tax_xref: str | None = Field(default=None, alias='cityTaxXref')
    city_tax_amount: float | None = Field(default=None, alias='cityTaxAmount')
    country_tax_flag: bool | None = Field(default=None, alias='countryTaxFlag')
    """
    Set to true if transaction is taxable at the country level.
    """
    country_tax_xref: str | None = Field(default=None, alias='countryTaxXref')
    country_tax_amount: float | None = Field(default=None, alias='countryTaxAmount')
    composite_tax_flag: bool | None = Field(default=None, alias='compositeTaxFlag')
    """
    Set to true if transaction is taxable at the composite level.
    """
    composite_tax_xref: str | None = Field(default=None, alias='compositeTaxXref')
    composite_tax_amount: float | None = Field(default=None, alias='compositeTaxAmount')
    level_six_tax_flag: bool | None = Field(default=None, alias='levelSixTaxFlag')
    """
    Set to true if transaction is taxable at level six.
    """
    level_six_tax_xref: str | None = Field(default=None, alias='levelSixTaxXref')
    level_six_tax_amount: float | None = Field(default=None, alias='levelSixTaxAmount')
    tax_total: float | None = Field(default=None, alias='taxTotal')
    customer: CompanyReference | None = None
    vendor: CompanyReference | None = None
    vendor_account_number: str | None = Field(default=None, alias='vendorAccountNumber')
    vendor_invoice_number: str | None = Field(default=None, alias='vendorInvoiceNumber')
    vendor_invoice_date: str | None = Field(default=None, alias='vendorInvoiceDate')
    tax_freight_flag: bool | None = Field(default=None, alias='taxFreightFlag')
    freight_tax_total: float | None = Field(default=None, alias='freightTaxTotal')
    freight_cost: float | None = Field(default=None, alias='freightCost')
    date_closed: str | None = Field(default=None, alias='dateClosed')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UnpostedProcurementTaxableLevel(UnpostedExpenseTaxableLevel):
    pass


class Usage(ConnectWiseModel):
    type: str | None = None
    count: int | None = None
    id: int | None = None
    description: str | None = None
    hyperlink: str | None = None
    type_key: str | None = Field(default=None, alias='typeKey')


class UserDefinedFieldOption(ConnectWiseModel):
    id: int | None = None
    option_value: str | None = Field(default=None, alias='optionValue')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    sort_order: int | None = Field(default=None, alias='sortOrder')


class UserDefinedFieldReference(ActivityReference):
    pass


class UserDefinedFieldValueModel(ConnectWiseModel):
    user_defined_field_rec_id: int | None = Field(
        default=None, alias='userDefinedFieldRecId'
    )
    value: str | None = None
    row_num: int | None = Field(default=None, alias='rowNum')
    skip_location_and_billing_unit: bool | None = Field(
        default=None, alias='skipLocationAndBillingUnit'
    )
    filtered: bool | None = None


class ValidatePortalRequest(ConnectWiseModel):
    email: str
    password: str


class ValidatePortalResponse(ConnectWiseModel):
    success: bool | None = None
    contact_id: int | None = Field(default=None, alias='contactId')


class ValidationError(ConnectWiseModel):
    code: str | None = None
    message: str | None = None
    resource: str | None = None
    field: str | None = None
    details: str | None = None


class Warehouse(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    company: CompanyReference | None = None
    location: SystemLocationReference | None = None
    contact: ContactReference | None = None
    department: SystemDepartmentReference | None = None
    manager: MemberReference | None = None
    site: SiteReference | None = None
    location_xref: str | None = Field(default=None, alias='locationXref')
    """
     Max length: 10;
    """
    location_default_flag: bool | None = Field(
        default=None, alias='locationDefaultFlag'
    )
    overall_default_flag: bool | None = Field(default=None, alias='overallDefaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    locked_flag: bool | None = Field(default=None, alias='lockedFlag')
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WarehouseBinReference(ActivityReference):
    pass


class WarehouseInfo(CategoryInfo):
    pass


class WarehouseReference(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    locked_flag: bool | None = Field(default=None, alias='lockedFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WisePayBatchPayment(ConnectWiseModel):
    amount: float | None = None
    wise_pay_href: str | None = Field(default=None, alias='wisePayHref')


class WisePayFeeInvoice(ConnectWiseModel):
    id: int | None = None
    invoice_number: str | None = Field(default=None, alias='invoiceNumber')
    amount: float | None = None
    invoice_href: str | None = Field(default=None, alias='invoiceHref')


class WisePayPayment(ConnectWiseModel):
    payment_date_utc: str | None = Field(default=None, alias='paymentDateUtc')
    wise_pay_reference: str | None = Field(default=None, alias='wisePayReference')
    batch_payment: WisePayBatchPayment | None = Field(
        default=None, alias='batchPayment'
    )
    fee_invoice: WisePayFeeInvoice | None = Field(default=None, alias='feeInvoice')


class WonRevenueReference(AgreementRevenueReference):
    pass


class WorkflowAction(ConnectWiseModel):
    id: int | None = None
    notify_type: NotifyTypeReference = Field(..., alias='notifyType')
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    specific_member_to: MemberReference | None = Field(
        default=None, alias='specificMemberTo'
    )
    email_recipient: str | None = Field(default=None, alias='emailRecipient')
    """
    Required when notifyWho is set to: "Email Address" Max length: 250;
    """
    notify_from: NotificationRecipientReference | None = Field(
        default=None, alias='notifyFrom'
    )
    specific_member_from: MemberReference | None = Field(
        default=None, alias='specificMemberFrom'
    )
    email_from: str | None = Field(default=None, alias='emailFrom')
    """
    Required when notifyFrom is set to: "Email Address" Max length: 250;
    """
    cc_contact: ContactReference | None = Field(default=None, alias='ccContact')
    bcc_contact: ContactReference | None = Field(default=None, alias='bccContact')
    subject: str | None = None
    """
    Required when notifyType is set to: "Create Activity", "Send Email", "Assign Resource" Max length: 100;
    """
    notes: str | None = None
    activity_status: ActivityStatusReference | None = Field(
        default=None, alias='activityStatus'
    )
    activity_type: ActivityTypeReference | None = Field(
        default=None, alias='activityType'
    )
    attached_track: TrackReference | None = Field(default=None, alias='attachedTrack')
    days_to_execute: int | None = Field(default=None, alias='daysToExecute')
    board: BoardReference | None = None
    board_status: ServiceStatusReference | None = Field(
        default=None, alias='boardStatus'
    )
    service_type: ServiceTypeReference | None = Field(default=None, alias='serviceType')
    service_sub_type: ServiceSubTypeReference | None = Field(
        default=None, alias='serviceSubType'
    )
    service_item: ServiceItemReference | None = Field(default=None, alias='serviceItem')
    group: GroupReference | None = None
    service_template: ServiceTemplateReference | None = Field(
        default=None, alias='serviceTemplate'
    )
    invoice_min_days: int | None = Field(default=None, alias='invoiceMinDays')
    automate_script: AutomateScriptReference | None = Field(
        default=None, alias='automateScript'
    )
    script_success_status: ServiceStatusReference | None = Field(
        default=None, alias='scriptSuccessStatus'
    )
    script_fail_status: ServiceStatusReference | None = Field(
        default=None, alias='scriptFailStatus'
    )
    detail_notes_flag: bool | None = Field(default=None, alias='detailNotesFlag')
    internal_notes_flag: bool | None = Field(default=None, alias='internalNotesFlag')
    audit_notes_flag: bool | None = Field(default=None, alias='auditNotesFlag')
    service_priority: PriorityReference | None = Field(
        default=None, alias='servicePriority'
    )
    update_owner_flag: bool | None = Field(default=None, alias='updateOwnerFlag')
    sales_order_status: OrderStatusReference | None = Field(
        default=None, alias='salesOrderStatus'
    )
    project_status: ProjectStatusReference | None = Field(
        default=None, alias='projectStatus'
    )
    company_status: CompanyStatusReference | None = Field(
        default=None, alias='companyStatus'
    )
    attachments: list[int] | None = None
    service_survey: ServiceSurveyReference | None = Field(
        default=None, alias='serviceSurvey'
    )
    specific_team_to: GenericBoardTeamReference | None = Field(
        default=None, alias='specificTeamTo'
    )
    attach_configurations_for: Literal['Company', 'Contact'] | None = Field(
        default=None, alias='attachConfigurationsFor'
    )
    """
    Required when notifyType is set to: "Attach Configuration"
    """
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    configuration_status: ConfigurationStatusReference | None = Field(
        default=None, alias='configurationStatus'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowActionAutomateParameter(ConnectWiseModel):
    id: int | None = None
    name: str
    value: str | None = None


class WorkflowActionUserDefinedField(ConnectWiseModel):
    id: int | None = None
    event_id: int | None = Field(default=None, alias='eventId')
    action_id: int | None = Field(default=None, alias='actionId')
    caption: str | None = None
    user_defined_field_id: int | None = Field(default=None, alias='userDefinedFieldId')
    value: str | None = None
    overwrite_flag: bool | None = Field(default=None, alias='overwriteFlag')
    pod_description: str | None = Field(default=None, alias='podDescription')
    field_type_id: str | None = Field(default=None, alias='fieldTypeId')
    entry_type_id: str | None = Field(default=None, alias='entryTypeId')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowAttachment(ActivityReference):
    pass


class WorkflowEvent(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    event_condition: str = Field(..., alias='eventCondition')
    frequency_unit: Literal['Minutes', 'Hours', 'Days', 'Months'] | None = Field(
        default=None, alias='frequencyUnit'
    )
    """
    Required when exectionTimes is set to MultipleTimes or Continuously
    """
    frequency_of_execution: int | None = Field(
        default=None, alias='frequencyOfExecution'
    )
    """
    Required when exectionTimes is set to MultipleTimes or Continuously
    """
    max_number_of_execution: int | None = Field(
        default=None, alias='maxNumberOfExecution'
    )
    """
    Required when exectionTimes is set to MultipleTimes
    """
    execution_time: Literal['Once', 'MultipleTimes', 'Continuously'] | None = Field(
        default=None, alias='executionTime'
    )
    """
    Defaults to Once when not specified
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowNotifyType(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    is_setup_flag: bool | None = Field(default=None, alias='isSetupFlag')
    """
    If the current action is available because it is already set up. Pertains to integrations such as Automate
    """
    external_flag: bool | None = Field(default=None, alias='externalFlag')
    """
    If the current action effects external objects e.g. integrations or sending an email
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowNotifyTypeInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    name: str | None = None
    is_setup_flag: bool | None = Field(default=None, alias='isSetupFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowTableType(CatalogItemReference):
    pass


class WorkflowTableTypeInfo(CatalogItemReference):
    pass


class WorkflowTableTypeReference(CatalogItemReference):
    pass


class WorkflowTrigger(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    description: str | None = None
    has_options_flag: bool | None = Field(default=None, alias='hasOptionsFlag')
    has_operator_flag: bool | None = Field(default=None, alias='hasOperatorFlag')
    custom_field: UserDefinedFieldReference | None = Field(
        default=None, alias='customField'
    )
    expected_type: str | None = Field(default=None, alias='expectedType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkflowTriggerOption(ConnectWiseModel):
    value: str | None = None
    name: str | None = None
    custom_field: UserDefinedFieldReference | None = Field(
        default=None, alias='customField'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkRole(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    add_all_locations: bool | None = Field(default=None, alias='addAllLocations')
    remove_all_locations: bool | None = Field(default=None, alias='removeAllLocations')
    add_all_agreement_exclusions: bool | None = Field(
        default=None, alias='addAllAgreementExclusions'
    )
    """
    Used only on create to add the work role to all agreement and agreement type exclusion lists
    """
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkRoleInfo(CategoryInfo):
    pass


class WorkRoleReference(ActivityReference):
    pass


class WorkType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge'] = Field(
        ..., alias='billTime'
    )
    rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='rateType'
    )
    rate: float
    hours_min: float | None = Field(default=None, alias='hoursMin')
    hours_max: float | None = Field(default=None, alias='hoursMax')
    round_bill_hours_to: float | None = Field(default=None, alias='roundBillHoursTo')
    accrual_type: Literal['Holiday', 'PTO', 'Sick', 'Vacation'] | None = Field(
        default=None, alias='accrualType'
    )
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    overall_default_flag: bool | None = Field(default=None, alias='overallDefaultFlag')
    activity_default_flag: bool | None = Field(
        default=None, alias='activityDefaultFlag'
    )
    utilization_flag: bool | None = Field(default=None, alias='utilizationFlag')
    cost_multiplier: float | None = Field(default=None, alias='costMultiplier')
    integration_x_ref: str | None = Field(default=None, alias='integrationXRef')
    """
     Max length: 50;
    """
    add_all_agreement_exclusions: bool | None = Field(
        default=None, alias='addAllAgreementExclusions'
    )
    """
    Used only on create to add the work type to all agreement and agreement type exclusion lists
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    activity_default_flag: bool | None = Field(
        default=None, alias='activityDefaultFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkTypeReference(ActivityReference):
    pass


class Activity(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    type: ActivityTypeReference | None = None
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    phone_number: str | None = Field(default=None, alias='phoneNumber')
    """
     Max length: 30;
    """
    email: str | None = None
    """
     Max length: 250;
    """
    status: ActivityStatusReference | None = None
    opportunity: OpportunityReference | None = None
    ticket: TicketReference | None = None
    agreement: AgreementReference | None = None
    campaign: CampaignReference | None = None
    notes: str | None = None
    date_start: datetime | None = Field(default=None, alias='dateStart')
    date_end: datetime | None = Field(default=None, alias='dateEnd')
    assigned_by: MemberReference | None = Field(default=None, alias='assignedBy')
    assign_to: MemberReference | None = Field(default=None, alias='assignTo')
    schedule_status: ScheduleStatusReference | None = Field(
        default=None, alias='scheduleStatus'
    )
    reminder: ReminderReference | None = None
    where: ServiceLocationReference | None = None
    notify_flag: bool | None = Field(default=None, alias='notifyFlag')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class ActivityStopwatch(ConnectWiseModel):
    activity_id: int = Field(..., alias='activityId')
    activity_mobile_guid: UUID | None = Field(default=None, alias='activityMobileGuid')
    agreement: AgreementReference | None = None
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    end_time: datetime | None = Field(default=None, alias='endTime')
    id: int | None = None
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    location_id: int | None = Field(default=None, alias='locationId')
    member: MemberReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    notes: str | None = None
    """
     Max length: 4000;
    """
    start_time: datetime | None = Field(default=None, alias='startTime')
    status: Literal['Reset', 'Running', 'Paused', 'Stopped']
    total_pause_time: int | None = Field(default=None, alias='totalPauseTime')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Addition(ConnectWiseModel):
    id: int | None = None
    product: IvItemReference | None = None
    quantity: float | None = None
    less_included: float | None = Field(default=None, alias='lessIncluded')
    unit_price: float | None = Field(default=None, alias='unitPrice')
    unit_cost: float | None = Field(default=None, alias='unitCost')
    bill_customer: Literal['Billable', 'DoNotBill', 'NoCharge'] = Field(
        ..., alias='billCustomer'
    )
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    cancelled_date: datetime | None = Field(default=None, alias='cancelledDate')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    serial_number: str | None = Field(default=None, alias='serialNumber')
    """
     Max length: 50;
    """
    invoice_description: str | None = Field(default=None, alias='invoiceDescription')
    """
     Max length: 6000;
    """
    purchase_item_flag: bool | None = Field(default=None, alias='purchaseItemFlag')
    special_order_flag: bool | None = Field(default=None, alias='specialOrderFlag')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    description: str | None = None
    billed_quantity: float | None = Field(default=None, alias='billedQuantity')
    uom: str | None = None
    ext_price: float | None = Field(default=None, alias='extPrice')
    ext_cost: float | None = Field(default=None, alias='extCost')
    sequence_number: float | None = Field(default=None, alias='sequenceNumber')
    margin: float | None = None
    prorate_cost: float | None = Field(default=None, alias='prorateCost')
    prorate_price: float | None = Field(default=None, alias='proratePrice')
    extended_prorate_cost: float | None = Field(
        default=None, alias='extendedProrateCost'
    )
    extended_prorate_price: float | None = Field(
        default=None, alias='extendedProratePrice'
    )
    prorate_current_period_flag: bool | None = Field(
        default=None, alias='prorateCurrentPeriodFlag'
    )
    opportunity: OpportunityReference | None = None
    agreement_status: Literal[
        'Active', 'Cancelled', 'Expired', 'Inactive'
    ] | None = Field(default=None, alias='agreementStatus')
    invoice_grouping: InvoiceGroupingReference | None = Field(
        default=None, alias='invoiceGrouping'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class AdjustmentDetail(ConnectWiseModel):
    id: int | None = None
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    description: str | None = None
    """
     Max length: 50;
    """
    quantity_on_hand: float | None = Field(default=None, alias='quantityOnHand')
    unit_cost: float | None = Field(default=None, alias='unitCost')
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    quantity_adjusted: int = Field(..., alias='quantityAdjusted')
    serial_number: str | None = Field(default=None, alias='serialNumber')
    """
     Max length: 1000;
    """
    adjustment: AdjustmentReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Agreement(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    type: AgreementTypeReference | None = None
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    site: SiteReference | None = None
    sub_contract_company: CompanyReference | None = Field(
        default=None, alias='subContractCompany'
    )
    sub_contract_contact: ContactReference | None = Field(
        default=None, alias='subContractContact'
    )
    parent_agreement: AgreementReference | None = Field(
        default=None, alias='parentAgreement'
    )
    customer_po: str | None = Field(default=None, alias='customerPO')
    """
     Max length: 50;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    restrict_location_flag: bool | None = Field(
        default=None, alias='restrictLocationFlag'
    )
    restrict_department_flag: bool | None = Field(
        default=None, alias='restrictDepartmentFlag'
    )
    start_date: datetime | None = Field(default=None, alias='startDate')
    end_date: datetime | None = Field(default=None, alias='endDate')
    no_ending_date_flag: bool | None = Field(default=None, alias='noEndingDateFlag')
    opportunity: OpportunityReference | None = None
    cancelled_flag: bool | None = Field(default=None, alias='cancelledFlag')
    date_cancelled: datetime | None = Field(default=None, alias='dateCancelled')
    reason_cancelled: str | None = Field(default=None, alias='reasonCancelled')
    """
     Max length: 100;
    """
    sla: SLAReference | None = None
    work_order: str | None = Field(default=None, alias='workOrder')
    """
     Max length: 20;
    """
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    application_units: Literal['Amount', 'Hours', 'Incidents'] | None = Field(
        default=None, alias='applicationUnits'
    )
    application_limit: float | None = Field(default=None, alias='applicationLimit')
    application_cycle: Literal[
        'Contract2Weeks',
        'Contract4Weeks',
        'ContractYear',
        'CalendarMonth',
        'CalendarQuarter',
        'CalendarWeek',
        'ContractQuarter',
        'CalendarYear',
    ] | None = Field(default=None, alias='applicationCycle')
    application_unlimited_flag: bool | None = Field(
        default=None, alias='applicationUnlimitedFlag'
    )
    one_time_flag: bool | None = Field(default=None, alias='oneTimeFlag')
    cover_agreement_time: bool | None = Field(default=None, alias='coverAgreementTime')
    cover_agreement_product: bool | None = Field(
        default=None, alias='coverAgreementProduct'
    )
    cover_agreement_expense: bool | None = Field(
        default=None, alias='coverAgreementExpense'
    )
    cover_sales_tax: bool | None = Field(default=None, alias='coverSalesTax')
    carry_over_unused: bool | None = Field(default=None, alias='carryOverUnused')
    allow_overruns: bool | None = Field(default=None, alias='allowOverruns')
    expired_days: int | None = Field(default=None, alias='expiredDays')
    limit: int | None = None
    expire_when_zero: bool | None = Field(default=None, alias='expireWhenZero')
    charge_to_firm: bool | None = Field(default=None, alias='chargeToFirm')
    employee_comp_rate: Literal['Actual', 'Hourly'] | None = Field(
        default=None, alias='employeeCompRate'
    )
    """
     Required On Updates;
    """
    employee_comp_not_exceed: Literal['Billing', 'Amount', 'Percent'] | None = Field(
        default=None, alias='employeeCompNotExceed'
    )
    comp_hourly_rate: float | None = Field(default=None, alias='compHourlyRate')
    comp_limit_amount: float | None = Field(default=None, alias='compLimitAmount')
    billing_cycle: BillingCycleReference | None = Field(
        default=None, alias='billingCycle'
    )
    bill_one_time_flag: bool | None = Field(default=None, alias='billOneTimeFlag')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    invoicing_cycle: Literal['ContractYear', 'CalendarYear'] | None = Field(
        default=None, alias='invoicingCycle'
    )
    """
     Required On Updates;
    """
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    bill_amount: float | None = Field(default=None, alias='billAmount')
    taxable: bool | None = None
    prorate_first_bill: float | None = Field(default=None, alias='prorateFirstBill')
    bill_start_date: datetime | None = Field(default=None, alias='billStartDate')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    restrict_down_payment: bool | None = Field(
        default=None, alias='restrictDownPayment'
    )
    prorate_flag: bool | None = Field(default=None, alias='prorateFlag')
    invoice_prorated_additions_flag: bool | None = Field(
        default=None, alias='invoiceProratedAdditionsFlag'
    )
    invoice_description: str | None = Field(default=None, alias='invoiceDescription')
    top_comment: bool | None = Field(default=None, alias='topComment')
    bottom_comment: bool | None = Field(default=None, alias='bottomComment')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    project_type: ProjectTypeReference | None = Field(default=None, alias='projectType')
    invoice_template: InvoiceTemplateReference | None = Field(
        default=None, alias='invoiceTemplate'
    )
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    """
     Required On Updates;
    """
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    """
     Required On Updates;
    """
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    """
     Required On Updates;
    """
    billable_time_invoice: bool | None = Field(
        default=None, alias='billableTimeInvoice'
    )
    billable_expense_invoice: bool | None = Field(
        default=None, alias='billableExpenseInvoice'
    )
    billable_product_invoice: bool | None = Field(
        default=None, alias='billableProductInvoice'
    )
    currency: CurrencyReference | None = None
    period_type: Literal['Current', 'Future', 'Both', 'Undefined'] | None = Field(
        default=None, alias='periodType'
    )
    auto_invoice_flag: bool | None = Field(default=None, alias='autoInvoiceFlag')
    next_invoice_date: str | None = Field(default=None, alias='nextInvoiceDate')
    company_location: SystemLocationReference | None = Field(
        default=None, alias='companyLocation'
    )
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    agreement_status: Literal[
        'Active', 'Cancelled', 'Expired', 'Inactive'
    ] | None = Field(default=None, alias='agreementStatus')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class AgreementAdjustment(ConnectWiseModel):
    id: int | None = None
    amount: float | None = None
    description: str | None = None
    """
     Max length: 1000;
    """
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class AgreementApplicationParameters(ConnectWiseModel):
    application_unit: AgreementApplicationUnit | None = Field(
        default=None, alias='applicationUnit'
    )
    application_limit: AgreementApplicationLimit | None = Field(
        default=None, alias='applicationLimit'
    )
    application_limit_amount: float | None = Field(
        default=None, alias='applicationLimitAmount'
    )
    available_per: AgreementApplicationAviablePer | None = Field(
        default=None, alias='availablePer'
    )
    covers_time_flag: bool | None = Field(default=None, alias='coversTimeFlag')
    covers_expenses_flag: bool | None = Field(default=None, alias='coversExpensesFlag')
    covers_products_flag: bool | None = Field(default=None, alias='coversProductsFlag')
    covers_tax_flag: bool | None = Field(default=None, alias='coversTaxFlag')
    carryover_unused_flag: bool | None = Field(
        default=None, alias='carryoverUnusedFlag'
    )
    carry_over_days: int | None = Field(default=None, alias='carryOverDays')
    allow_overruns_flag: bool | None = Field(default=None, alias='allowOverrunsFlag')
    overrun_limit: int | None = Field(default=None, alias='overrunLimit')
    agreement_expires_flag: bool | None = Field(
        default=None, alias='agreementExpiresFlag'
    )
    charge_adjustments_flag: bool | None = Field(
        default=None, alias='chargeAdjustmentsFlag'
    )
    prepay_flag: bool | None = Field(default=None, alias='prepayFlag')
    agr_billing_cycle: AgreementApplicationBillingCycle | None = Field(
        default=None, alias='agrBillingCycle'
    )
    user_defined_field_values: list[UserDefinedFieldValueModel] | None = Field(
        default=None, alias='userDefinedFieldValues'
    )


class AgreementRecurringParameters(ConnectWiseModel):
    billing_cycle: GenericNameIdDTO | None = Field(default=None, alias='billingCycle')
    cycle_base: GenericNameIdDTO | None = Field(default=None, alias='cycleBase')
    a_gr_amount: float | None = Field(default=None, alias='aGRAmount')
    taxable: bool | None = None
    children_amount: float | None = Field(default=None, alias='childrenAmount')
    additions_amount: float | None = Field(default=None, alias='additionsAmount')
    total_amount: float | None = Field(default=None, alias='totalAmount')
    a_gr_prorate: float | None = Field(default=None, alias='aGRProrate')
    bill_start_date: str | None = Field(default=None, alias='billStartDate')
    tax_code: GenericNameIdDTO | None = Field(default=None, alias='taxCode')
    terms: GenericNameIdDTO | None = None
    prorate_flag: bool | None = Field(default=None, alias='prorateFlag')
    invoice_prorated_additions_flag: bool | None = Field(
        default=None, alias='invoiceProratedAdditionsFlag'
    )
    restrict_downpayment: bool | None = Field(default=None, alias='restrictDownpayment')
    currency: GenericNameIdDTO | None = None
    auto_invoice_flag: bool | None = Field(default=None, alias='autoInvoiceFlag')
    user_defined_field_values: list[UserDefinedFieldValueModel] | None = Field(
        default=None, alias='userDefinedFieldValues'
    )


class AgreementSite(ConnectWiseModel):
    id: int | None = None
    company: CompanyReference | None = None
    site: SiteReference | None = None
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class AgreementType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    prefix_suffix_option: Literal['Prefix', 'Suffix'] | None = Field(
        default=None, alias='prefixSuffixOption'
    )
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    pre_payment_flag: bool | None = Field(default=None, alias='prePaymentFlag')
    invoice_pre_suffix: str | None = Field(default=None, alias='invoicePreSuffix')
    """
     Max length: 5;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    restrict_location_flag: bool | None = Field(
        default=None, alias='restrictLocationFlag'
    )
    restrict_department_flag: bool | None = Field(
        default=None, alias='restrictDepartmentFlag'
    )
    sla: SLAReference | None = None
    application_units: Literal['Amount', 'Hours', 'Incidents'] | None = Field(
        default=None, alias='applicationUnits'
    )
    application_limit: float | None = Field(default=None, alias='applicationLimit')
    application_cycle: Literal[
        'Contract2Weeks',
        'Contract4Weeks',
        'ContractYear',
        'CalendarMonth',
        'CalendarQuarter',
        'CalendarWeek',
        'ContractQuarter',
        'CalendarYear',
    ] | None = Field(default=None, alias='applicationCycle')
    application_unlimited_flag: bool | None = Field(
        default=None, alias='applicationUnlimitedFlag'
    )
    one_time_flag: bool | None = Field(default=None, alias='oneTimeFlag')
    cover_agreement_time_flag: bool | None = Field(
        default=None, alias='coverAgreementTimeFlag'
    )
    cover_agreement_product_flag: bool | None = Field(
        default=None, alias='coverAgreementProductFlag'
    )
    cover_agreement_expense_flag: bool | None = Field(
        default=None, alias='coverAgreementExpenseFlag'
    )
    cover_sales_tax_flag: bool | None = Field(default=None, alias='coverSalesTaxFlag')
    carry_over_unused_flag: bool | None = Field(
        default=None, alias='carryOverUnusedFlag'
    )
    allow_overruns_flag: bool | None = Field(default=None, alias='allowOverrunsFlag')
    expired_days: int | None = Field(default=None, alias='expiredDays')
    limit: int | None = None
    expire_when_zero: bool | None = Field(default=None, alias='expireWhenZero')
    charge_to_firm_flag: bool | None = Field(default=None, alias='chargeToFirmFlag')
    employee_comp_rate: Literal['Actual', 'Hourly'] = Field(
        ..., alias='employeeCompRate'
    )
    employee_comp_not_exceed: Literal['Billing', 'Amount', 'Percent'] = Field(
        ..., alias='employeeCompNotExceed'
    )
    comp_hourly_rate: float | None = Field(default=None, alias='compHourlyRate')
    comp_limit_amount: float | None = Field(default=None, alias='compLimitAmount')
    billing_cycle: BillingCycleReference | None = Field(
        default=None, alias='billingCycle'
    )
    bill_one_time_flag: bool | None = Field(default=None, alias='billOneTimeFlag')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    invoicing_cycle: Literal['ContractYear', 'CalendarYear'] = Field(
        ..., alias='invoicingCycle'
    )
    bill_amount: float | None = Field(default=None, alias='billAmount')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    restrict_down_payment_flag: bool | None = Field(
        default=None, alias='restrictDownPaymentFlag'
    )
    invoice_description: str | None = Field(default=None, alias='invoiceDescription')
    """
     Max length: 4000;
    """
    top_comment_flag: bool | None = Field(default=None, alias='topCommentFlag')
    bottom_comment_flag: bool | None = Field(default=None, alias='bottomCommentFlag')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    project_type: ProjectTypeReference | None = Field(default=None, alias='projectType')
    invoice_template: InvoiceTemplateReference | None = Field(
        default=None, alias='invoiceTemplate'
    )
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billTime'
    )
    bill_expenses: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billExpenses'
    )
    bill_products: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billProducts'
    )
    billable_time_invoice_flag: bool | None = Field(
        default=None, alias='billableTimeInvoiceFlag'
    )
    billable_expense_invoice_flag: bool | None = Field(
        default=None, alias='billableExpenseInvoiceFlag'
    )
    billable_product_invoice_flag: bool | None = Field(
        default=None, alias='billableProductInvoiceFlag'
    )
    copy_work_roles_flag: bool | None = Field(default=None, alias='copyWorkRolesFlag')
    copy_work_types_flag: bool | None = Field(default=None, alias='copyWorkTypesFlag')
    exclusion_work_role_ids: list[int] | None = Field(
        default=None, alias='exclusionWorkRoleIds'
    )
    add_all_work_role_exclusions: bool | None = Field(
        default=None, alias='addAllWorkRoleExclusions'
    )
    remove_all_work_role_exclusions: bool | None = Field(
        default=None, alias='removeAllWorkRoleExclusions'
    )
    exclusion_work_type_ids: list[int] | None = Field(
        default=None, alias='exclusionWorkTypeIds'
    )
    add_all_work_type_exclusions: bool | None = Field(
        default=None, alias='addAllWorkTypeExclusions'
    )
    remove_all_work_type_exclusions: bool | None = Field(
        default=None, alias='removeAllWorkTypeExclusions'
    )
    integration_x_ref: str | None = Field(default=None, alias='integrationXRef')
    """
     Max length: 50;
    """
    prorate_flag: bool | None = Field(default=None, alias='prorateFlag')
    email_template: EmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    auto_invoice_flag: bool | None = Field(default=None, alias='autoInvoiceFlag')
    invoice_prorated_additions_flag: bool | None = Field(
        default=None, alias='invoiceProratedAdditionsFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeBoardDefault(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    location: SystemLocationReference
    department: SystemDepartmentReference | None = None
    board: BoardReference | None = None
    service_type: ServiceTypeReference | None = Field(default=None, alias='serviceType')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeWorkRole(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    ending_date: datetime | None = Field(default=None, alias='endingDate')
    rate: float | None = None
    rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='rateType'
    )
    limit_to: float | None = Field(default=None, alias='limitTo')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeWorkRoleExclusion(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeWorkRoleInfo(AgreementTypeWorkRoleExclusion):
    pass


class AgreementTypeWorkType(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    ending_date: datetime | None = Field(default=None, alias='endingDate')
    rate: float | None = None
    rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='rateType'
    )
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billTime'
    )
    hours_min: float | None = Field(default=None, alias='hoursMin')
    hours_max: float | None = Field(default=None, alias='hoursMax')
    round_bill_hours: float | None = Field(default=None, alias='roundBillHours')
    overage_rate: float | None = Field(default=None, alias='overageRate')
    overage_rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='overageRateType'
    )
    limit_to: float | None = Field(default=None, alias='limitTo')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementTypeWorkTypeExclusion(ConnectWiseModel):
    id: int | None = None
    type: AgreementTypeReference | None = None
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementWorkRole(ConnectWiseModel):
    id: int | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    location_id: int | None = Field(default=None, alias='locationId')
    rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='rateType'
    )
    rate: float | None = None
    limit_to: float | None = Field(default=None, alias='limitTo')
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    ending_date: datetime | None = Field(default=None, alias='endingDate')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementWorkRoleExclusion(ConnectWiseModel):
    id: int | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementWorkType(ConnectWiseModel):
    id: int | None = None
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    location: OwnerLevelReference | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] = Field(
        ..., alias='rateType'
    )
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] = Field(
        ..., alias='billTime'
    )
    rate: float | None = None
    hours_max: float | None = Field(default=None, alias='hoursMax')
    hours_min: float | None = Field(default=None, alias='hoursMin')
    round_bill_hours: float | None = Field(default=None, alias='roundBillHours')
    overage_rate: float | None = Field(default=None, alias='overageRate')
    overage_rate_type: Literal['AdjAmount', 'Custom', 'Multiplier'] | None = Field(
        default=None, alias='overageRateType'
    )
    agreement_limit: float | None = Field(default=None, alias='agreementLimit')
    site: SiteReference | None = None
    effective_date: datetime | None = Field(default=None, alias='effectiveDate')
    ending_date: datetime | None = Field(default=None, alias='endingDate')
    agreement: AgreementReference | None = None
    agreement_id: int | None = Field(default=None, alias='agreementId')
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class AgreementWorkTypeExclusion(ConnectWiseModel):
    id: int | None = None
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ApiMember(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 15;
    """
    name: str | None = None
    """
     Max length: 30; Required On Updates;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
     Max length: 250;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    inactive_date: datetime | None = Field(default=None, alias='inactiveDate')
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    security_role: SecurityRoleReference | None = Field(
        default=None, alias='securityRole'
    )
    structure_level: StructureReference | None = Field(
        default=None, alias='structureLevel'
    )
    security_location: SystemLocationReference | None = Field(
        default=None, alias='securityLocation'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    notes: str | None = None
    excluded_service_board_ids: list[int] | None = Field(
        default=None, alias='excludedServiceBoardIds'
    )
    block_price_flag: bool | None = Field(default=None, alias='blockPriceFlag')
    block_cost_flag: bool | None = Field(default=None, alias='blockCostFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ApiRequest(ConnectWiseModel):
    id: int | None = None
    external_id: str | None = Field(default=None, alias='externalId')
    parent_id: int | None = Field(default=None, alias='parentId')
    grand_parent_id: int | None = Field(default=None, alias='grandParentId')
    entity: IRestIdentifiedItem | None = None
    filters: FilterValues | None = None
    page: PageValues | None = None
    format: str | None = None
    fields: str | None = None
    misc_properties: dict[str, dict[str, Any]] | None = Field(
        default=None, alias='miscProperties'
    )
    member_context: str | None = Field(default=None, alias='memberContext')
    update_only_ces_properties: bool | None = Field(
        default=None, alias='updateOnlyCesProperties'
    )


class AutoSyncTime(ConnectWiseModel):
    id: int | None = None
    sync_time: str = Field(..., alias='syncTime')
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BatchEntry(ConnectWiseModel):
    id: int | None = None
    account_type: str | None = Field(default=None, alias='accountType')
    name: str | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    debit: float | None = None
    credit: float | None = None
    cost: float | None = None
    item: str | None = None
    sales_code: str | None = Field(default=None, alias='salesCode')
    cost_of_goods_sold_account_number: str | None = Field(
        default=None, alias='costOfGoodsSoldAccountNumber'
    )
    invoice: InvoiceReference | None = None
    purchase_order: PurchaseOrderReference | None = Field(
        default=None, alias='purchaseOrder'
    )
    line_item: PurchaseOrderLineItemReference | None = Field(
        default=None, alias='lineItem'
    )
    transfer: str | None = None
    expense: ExpenseDetailReference | None = None
    adjustment_detail: AdjustmentDetailReference | None = Field(
        default=None, alias='adjustmentDetail'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingSetup(ConnectWiseModel):
    id: int | None = None
    remit_name: str = Field(..., alias='remitName')
    """
     Max length: 50;
    """
    location: SystemLocationReference
    address_one: str | None = Field(default=None, alias='addressOne')
    """
     Max length: 50;
    """
    address_two: str | None = Field(default=None, alias='addressTwo')
    """
     Max length: 50;
    """
    city: str | None = None
    """
     Max length: 50;
    """
    state: StateReference | None = None
    zip: str | None = None
    """
     Max length: 12;
    """
    country: CountryReference | None = None
    phone: str | None = None
    """
     Max length: 15;
    """
    invoice_title: str = Field(..., alias='invoiceTitle')
    """
     Max length: 50;
    """
    payable_name: str = Field(..., alias='payableName')
    """
     Max length: 50;
    """
    topcomment: str | None = None
    """
     Max length: 4000;
    """
    invoice_footer: str | None = Field(default=None, alias='invoiceFooter')
    """
     Max length: 500;
    """
    quote_footer: str | None = Field(default=None, alias='quoteFooter')
    """
     Max length: 1000;
    """
    overall_invoice_default: InvoiceTemplateReference | None = Field(
        default=None, alias='overallInvoiceDefault'
    )
    standard_invoice_actual: InvoiceTemplateReference | None = Field(
        default=None, alias='standardInvoiceActual'
    )
    standard_invoice_fixed: InvoiceTemplateReference | None = Field(
        default=None, alias='standardInvoiceFixed'
    )
    progress_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='progressInvoice'
    )
    agreement_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='agreementInvoice'
    )
    credit_memo_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='creditMemoInvoice'
    )
    down_payment_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='downPaymentInvoice'
    )
    misc_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='miscInvoice'
    )
    sales_order_invoice: InvoiceTemplateReference | None = Field(
        default=None, alias='salesOrderInvoice'
    )
    exclude_do_not_bill_time_flag: bool | None = Field(
        default=None, alias='excludeDoNotBillTimeFlag'
    )
    exclude_do_not_bill_expense_flag: bool | None = Field(
        default=None, alias='excludeDoNotBillExpenseFlag'
    )
    exclude_do_not_bill_product_flag: bool | None = Field(
        default=None, alias='excludeDoNotBillProductFlag'
    )
    prefix_suffix_flag: Literal['Prefix', 'Suffix'] | None = Field(
        default=None, alias='prefixSuffixFlag'
    )
    prefix_suffix_text: str | None = Field(default=None, alias='prefixSuffixText')
    """
     Max length: 5;
    """
    charge_adj_to_firm_flag: bool | None = Field(
        default=None, alias='chargeAdjToFirmFlag'
    )
    no_watermark_flag: bool | None = Field(default=None, alias='noWatermarkFlag')
    display_tax_flag: bool | None = Field(default=None, alias='displayTaxFlag')
    allow_restricted_dept_on_routing_flag: bool | None = Field(
        default=None, alias='allowRestrictedDeptOnRoutingFlag'
    )
    bill_ticket_separately_flag: bool | None = Field(
        default=None, alias='billTicketSeparatelyFlag'
    )
    bill_ticket_complete_flag: bool | None = Field(
        default=None, alias='billTicketCompleteFlag'
    )
    bill_ticket_unapproved_flag: bool | None = Field(
        default=None, alias='billTicketUnapprovedFlag'
    )
    bill_project_complete_flag: bool | None = Field(
        default=None, alias='billProjectCompleteFlag'
    )
    bill_project_unapproved_flag: bool | None = Field(
        default=None, alias='billProjectUnapprovedFlag'
    )
    progress_time_flag: bool | None = Field(default=None, alias='progressTimeFlag')
    restrict_project_downpayment_flag: bool | None = Field(
        default=None, alias='restrictProjectDownpaymentFlag'
    )
    bill_sales_order_complete_flag: bool | None = Field(
        default=None, alias='billSalesOrderCompleteFlag'
    )
    bill_product_after_ship_flag: bool | None = Field(
        default=None, alias='billProductAfterShipFlag'
    )
    restrict_downpayment_flag: bool | None = Field(
        default=None, alias='restrictDownpaymentFlag'
    )
    copy_non_service_products_flag: bool | None = Field(
        default=None, alias='copyNonServiceProductsFlag'
    )
    copy_service_products_flag: bool | None = Field(
        default=None, alias='copyServiceProductsFlag'
    )
    copy_agreement_products_flag: bool | None = Field(
        default=None, alias='copyAgreementProductsFlag'
    )
    print_logo_flag: bool | None = Field(default=None, alias='printLogoFlag')
    read_receipt_flag: bool | None = Field(default=None, alias='readReceiptFlag')
    delivery_receipt_flag: bool | None = Field(
        default=None, alias='deliveryReceiptFlag'
    )
    attach_xml_invoice_flag: bool | None = Field(
        default=None, alias='attachXmlInvoiceFlag'
    )
    disable_routing_email_flag: bool | None = Field(
        default=None, alias='disableRoutingEmailFlag'
    )
    email_template: EmailTemplateReference = Field(..., alias='emailTemplate')
    localized_country: CountryReference | None = Field(
        default=None, alias='localizedCountry'
    )
    business_number: str | None = Field(default=None, alias='businessNumber')
    """
     Max length: 50;
    """
    currency: CurrencyReference | None = None
    custom_label: str | None = Field(default=None, alias='customLabel')
    """
     Max length: 50;
    """
    custom_text: str | None = Field(default=None, alias='customText')
    """
     Max length: 500;
    """
    company_code: str | None = Field(default=None, alias='companyCode')
    """
     Max length: 250;
    """
    exclude_avalara_flag: bool | None = Field(default=None, alias='excludeAvalaraFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingSetupInfo(ConnectWiseModel):
    id: int | None = None
    remit_name: str | None = Field(default=None, alias='remitName')
    location: SystemLocationReference | None = None
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BillingSetupRouting(ConnectWiseModel):
    id: int | None = None
    sequence_number: int = Field(..., alias='sequenceNumber')
    invoice_rule: Literal['All', 'Standard', 'Project', 'Agreement'] = Field(
        ..., alias='invoiceRule'
    )
    routing_rule: Literal[
        'Account',
        'Territory',
        'Creator',
        'Department',
        'Location',
        'Member',
        'Project',
        'Sales',
    ] = Field(..., alias='routingRule')
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Board(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    sign_off_template: ServiceSignoffReference | None = Field(
        default=None, alias='signOffTemplate'
    )
    send_to_contact_flag: bool | None = Field(default=None, alias='sendToContactFlag')
    contact_template: ServiceEmailTemplateReference | None = Field(
        default=None, alias='contactTemplate'
    )
    send_to_resource_flag: bool | None = Field(default=None, alias='sendToResourceFlag')
    resource_template: ServiceEmailTemplateReference | None = Field(
        default=None, alias='resourceTemplate'
    )
    project_flag: bool | None = Field(default=None, alias='projectFlag')
    show_dependencies_flag: bool | None = Field(
        default=None, alias='showDependenciesFlag'
    )
    """
    This field only shows if it is Project Board.
    """
    show_estimates_flag: bool | None = Field(default=None, alias='showEstimatesFlag')
    """
    This field only shows if it is Project Board.
    """
    board_icon: DocumentReference | None = Field(default=None, alias='boardIcon')
    bill_tickets_after_closed_flag: bool | None = Field(
        default=None, alias='billTicketsAfterClosedFlag'
    )
    bill_ticket_separately_flag: bool | None = Field(
        default=None, alias='billTicketSeparatelyFlag'
    )
    bill_unapproved_time_expense_flag: bool | None = Field(
        default=None, alias='billUnapprovedTimeExpenseFlag'
    )
    override_billing_setup_flag: bool | None = Field(
        default=None, alias='overrideBillingSetupFlag'
    )
    dispatch_member: MemberReference | None = Field(
        default=None, alias='dispatchMember'
    )
    service_manager_member: MemberReference | None = Field(
        default=None, alias='serviceManagerMember'
    )
    duty_manager_member: MemberReference | None = Field(
        default=None, alias='dutyManagerMember'
    )
    oncall_member: MemberReference | None = Field(default=None, alias='oncallMember')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    bill_expense: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpense')
    bill_product: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProduct')
    auto_close_status: ServiceStatusReference | None = Field(
        default=None, alias='autoCloseStatus'
    )
    auto_assign_new_tickets_flag: bool | None = Field(
        default=None, alias='autoAssignNewTicketsFlag'
    )
    auto_assign_new_ec_tickets_flag: bool | None = Field(
        default=None, alias='autoAssignNewECTicketsFlag'
    )
    auto_assign_new_portal_tickets_flag: bool | None = Field(
        default=None, alias='autoAssignNewPortalTicketsFlag'
    )
    discussions_locked_flag: bool | None = Field(
        default=None, alias='discussionsLockedFlag'
    )
    time_entry_locked_flag: bool | None = Field(
        default=None, alias='timeEntryLockedFlag'
    )
    notify_email_from: str | None = Field(default=None, alias='notifyEmailFrom')
    """
     Max length: 50;
    """
    notify_email_from_name: str | None = Field(
        default=None, alias='notifyEmailFromName'
    )
    """
     Max length: 60;
    """
    closed_loop_discussions_flag: bool | None = Field(
        default=None, alias='closedLoopDiscussionsFlag'
    )
    closed_loop_resolution_flag: bool | None = Field(
        default=None, alias='closedLoopResolutionFlag'
    )
    closed_loop_internal_analysis_flag: bool | None = Field(
        default=None, alias='closedLoopInternalAnalysisFlag'
    )
    time_entry_discussion_flag: bool | None = Field(
        default=None, alias='timeEntryDiscussionFlag'
    )
    time_entry_resolution_flag: bool | None = Field(
        default=None, alias='timeEntryResolutionFlag'
    )
    time_entry_internal_analysis_flag: bool | None = Field(
        default=None, alias='timeEntryInternalAnalysisFlag'
    )
    problem_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='problemSort'
    )
    resolution_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='resolutionSort'
    )
    internal_analysis_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='internalAnalysisSort'
    )
    email_connector_allow_reopen_closed_flag: bool | None = Field(
        default=None, alias='emailConnectorAllowReopenClosedFlag'
    )
    email_connector_reopen_status: ServiceStatusReference | None = Field(
        default=None, alias='emailConnectorReopenStatus'
    )
    email_connector_reopen_resources_flag: bool | None = Field(
        default=None, alias='emailConnectorReopenResourcesFlag'
    )
    """
    This field can only be set when emailConnectorAllowReopenClosed is true.
    """
    email_connector_new_ticket_no_match_flag: bool | None = Field(
        default=None, alias='emailConnectorNewTicketNoMatchFlag'
    )
    """
    This field can only be set when emailConnectorAllowReopenClosed is true.
    """
    email_connector_never_reopen_by_days_flag: bool | None = Field(
        default=None, alias='emailConnectorNeverReopenByDaysFlag'
    )
    """
    This field can only be set when emailConnectorAllowReopenClosed is true.
    """
    email_connector_reopen_days_limit: int | None = Field(
        default=None, alias='emailConnectorReopenDaysLimit'
    )
    """
    This field can only be set when emailConnectorNeverReopenByDaysFlag and emailConnectorAllowReopenClosed are both true
                This field is required when emailConnectorNeverReopenByDaysFlag is true.
    """
    email_connector_never_reopen_by_days_closed_flag: bool | None = Field(
        default=None, alias='emailConnectorNeverReopenByDaysClosedFlag'
    )
    """
    This field can only be set when emailConnectorAllowReopenClosed is true.
    """
    email_connector_reopen_days_closed_limit: int | None = Field(
        default=None, alias='emailConnectorReopenDaysClosedLimit'
    )
    """
    This field can only be set when emailConnectorNeverReopenByDaysClosedFlag and emailConnectorAllowReopenClosed are both true
                This field is required when emailConnectorNeverReopenByDaysClosedFlag is true.
    """
    use_member_display_name_flag: bool | None = Field(
        default=None, alias='useMemberDisplayNameFlag'
    )
    send_to_cc_flag: bool | None = Field(default=None, alias='sendToCCFlag')
    auto_assign_ticket_owner_flag: bool | None = Field(
        default=None, alias='autoAssignTicketOwnerFlag'
    )
    auto_assign_limit_flag: bool | None = Field(
        default=None, alias='autoAssignLimitFlag'
    )
    auto_assign_limit_amount: int | None = Field(
        default=None, alias='autoAssignLimitAmount'
    )
    """
    This field can only be set when autoAssignLimitFlag is true
    """
    closed_loop_all_flag: bool | None = Field(default=None, alias='closedLoopAllFlag')
    percentage_calculation: Literal[
        'ActualHours', 'Manual', 'ClosedPhases', 'ClosedTickets'
    ] | None = Field(default=None, alias='percentageCalculation')
    all_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='allSort'
    )
    mark_first_note_issue_flag: bool | None = Field(
        default=None, alias='markFirstNoteIssueFlag'
    )
    restrict_board_by_default_flag: bool | None = Field(
        default=None, alias='restrictBoardByDefaultFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardAutoAssignResource(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardAutoTemplate(ConnectWiseModel):
    id: int | None = None
    type: ServiceTypeReference | None = None
    subtype: ServiceSubTypeReference | None = None
    item: ServiceItemReference | None = None
    service_template: ServiceTemplateReference | None = Field(
        default=None, alias='serviceTemplate'
    )
    board: BoardReference | None = None
    summary_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='summarySetting'
    )
    discussion_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='discussionSetting'
    )
    internal_analysis_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='internalAnalysisSetting'
    )
    resolution_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='resolutionSetting'
    )
    tasks_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='tasksSetting'
    )
    documents_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='documentsSetting'
    )
    resources_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='resourcesSetting'
    )
    budget_hours_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='budgetHoursSetting'
    )
    finance_information_setting: Literal[
        'Append', 'Overwrite', 'Ignore'
    ] | None = Field(default=None, alias='financeInformationSetting')
    send_notes_as_email_setting: Literal[
        'Append', 'Overwrite', 'Ignore'
    ] | None = Field(default=None, alias='sendNotesAsEmailSetting')
    impact_urgency_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='impactUrgencySetting'
    )
    template_priority_setting: Literal['Append', 'Overwrite', 'Ignore'] | None = Field(
        default=None, alias='templatePrioritySetting'
    )
    auto_apply_flag: bool | None = Field(default=None, alias='autoApplyFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardDefault(ConnectWiseModel):
    id: int | None = None
    board: BoardReference | None = None
    service_type: ServiceTypeReference | None = Field(default=None, alias='serviceType')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    agreement_id: int | None = Field(default=None, alias='agreementId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    project_flag: bool | None = Field(default=None, alias='projectFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    closed_loop_discussions_flag: bool | None = Field(
        default=None, alias='closedLoopDiscussionsFlag'
    )
    closed_loop_internal_analysis_flag: bool | None = Field(
        default=None, alias='closedLoopInternalAnalysisFlag'
    )
    closed_loop_resolution_flag: bool | None = Field(
        default=None, alias='closedLoopResolutionFlag'
    )
    closed_loop_all_flag: bool | None = Field(default=None, alias='closedLoopAllFlag')
    problem_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='problemSort'
    )
    internal_analysis_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='internalAnalysisSort'
    )
    resolution_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='resolutionSort'
    )
    all_sort: Literal['Ascending', 'Descending'] | None = Field(
        default=None, alias='allSort'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardItem(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardItemAssociation(ConnectWiseModel):
    id: int
    sub_type_association_ids: list[int] | None = Field(
        default=None, alias='subTypeAssociationIds'
    )
    """
    If addAllSubTypesFlag and removeAllSubTypesFlag are both false, this field is required.
    """
    add_all_sub_types_flag: bool | None = Field(
        default=None, alias='addAllSubTypesFlag'
    )
    remove_all_sub_types_flag: bool | None = Field(
        default=None, alias='removeAllSubTypesFlag'
    )
    item: ServiceItemReference | None = None
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    member: MemberReference | None = None
    email: str | None = None
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    board: BoardReference | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')
    display_on_board: bool | None = Field(default=None, alias='displayOnBoard')
    inactive: bool | None = None
    closed_status: bool | None = Field(default=None, alias='closedStatus')
    time_entry_not_allowed: bool | None = Field(
        default=None, alias='timeEntryNotAllowed'
    )
    round_robin_catchall: bool | None = Field(default=None, alias='roundRobinCatchall')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    escalation_status: Literal[
        'NotResponded', 'Responded', 'ResolutionPlan', 'Resolved', 'NoEscalation'
    ] | None = Field(default=None, alias='escalationStatus')
    customer_portal_description: str | None = Field(
        default=None, alias='customerPortalDescription'
    )
    """
     Max length: 500;
    """
    customer_portal_flag: bool | None = Field(default=None, alias='customerPortalFlag')
    email_template: ServiceEmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    status_indicator: StatusIndicatorReference | None = Field(
        default=None, alias='statusIndicator'
    )
    custom_status_indicator_name: str | None = Field(
        default=None, alias='customStatusIndicatorName'
    )
    """
     Max length: 30;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')
    save_time_as_note: bool | None = Field(default=None, alias='saveTimeAsNote')


class BoardStatusNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    status: ServiceStatusReference | None = None
    member: MemberReference | None = None
    email: str | None = None
    """
    Service Status Notification email must be entered if the notify type is "Email Address". Max length: 255;
    """
    workflow_step: int | None = Field(default=None, alias='workflowStep')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardTeam(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    team_leader: MemberReference | None = Field(default=None, alias='teamLeader')
    members: list[int] | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    notify_on_ticket_delete: bool | None = Field(
        default=None, alias='notifyOnTicketDelete'
    )
    default_round_robin_flag: bool | None = Field(
        default=None, alias='defaultRoundRobinFlag'
    )
    round_robin_flag: bool | None = Field(default=None, alias='roundRobinFlag')
    board_id: int | None = Field(default=None, alias='boardId')
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    category: Literal['Reactive', 'Proactive'] | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    request_for_change_flag: bool | None = Field(
        default=None, alias='requestForChangeFlag'
    )
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    skill_category: SkillCategoryReference | None = Field(
        default=None, alias='skillCategory'
    )
    skill: SkillReference | None = None
    board: BoardReference | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BoardTypeSubTypeItemAssociation(ConnectWiseModel):
    id: int | None = None
    type: ServiceTypeReference | None = None
    sub_type: ServiceSubTypeReference | None = Field(default=None, alias='subType')
    item: ServiceItemReference | None = None
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BundleRequest(ConnectWiseModel):
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    resource_type: str | None = Field(default=None, alias='resourceType')
    version: str | None = None
    api_request: ApiRequest | None = Field(default=None, alias='apiRequest')


class BundleRequestsCollection(ConnectWiseModel):
    requests: list[BundleRequest]


class Calendar(ConnectWiseModel):
    id: int | None = None
    name: str
    holiday_list: HolidayListReference | None = Field(default=None, alias='holidayList')
    monday_start_time: str | None = Field(default=None, alias='mondayStartTime')
    monday_end_time: str | None = Field(default=None, alias='mondayEndTime')
    tuesday_start_time: str | None = Field(default=None, alias='tuesdayStartTime')
    tuesday_end_time: str | None = Field(default=None, alias='tuesdayEndTime')
    wednesday_start_time: str | None = Field(default=None, alias='wednesdayStartTime')
    wednesday_end_time: str | None = Field(default=None, alias='wednesdayEndTime')
    thursday_start_time: str | None = Field(default=None, alias='thursdayStartTime')
    thursday_end_time: str | None = Field(default=None, alias='thursdayEndTime')
    friday_start_time: str | None = Field(default=None, alias='fridayStartTime')
    friday_end_time: str | None = Field(default=None, alias='fridayEndTime')
    saturday_start_time: str | None = Field(default=None, alias='saturdayStartTime')
    saturday_end_time: str | None = Field(default=None, alias='saturdayEndTime')
    sunday_start_time: str | None = Field(default=None, alias='sundayStartTime')
    sunday_end_time: str | None = Field(default=None, alias='sundayEndTime')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Campaign(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    type: CampaignTypeReference | None = None
    sub_type: CampaignSubTypeReference | None = Field(default=None, alias='subType')
    status: CampaignStatusReference | None = None
    start_date: datetime = Field(..., alias='startDate')
    end_date: datetime | None = Field(default=None, alias='endDate')
    location_id: int | None = Field(default=None, alias='locationId')
    member: MemberReference | None = None
    inactive: bool | None = None
    inactive_days_after_end: int | None = Field(
        default=None, alias='inactiveDaysAfterEnd'
    )
    notes: str | None = None
    default_group: GroupReference | None = Field(default=None, alias='defaultGroup')
    marketing_manager_default_track_id: int | None = Field(
        default=None, alias='marketingManagerDefaultTrackId'
    )
    opportunity_default_track_id: int | None = Field(
        default=None, alias='opportunityDefaultTrackId'
    )
    impressions: int | None = None
    budget_revenue: float | None = Field(default=None, alias='budgetRevenue')
    budget_cost: float | None = Field(default=None, alias='budgetCost')
    actual_cost: float | None = Field(default=None, alias='actualCost')
    budget_gross_margin: float | None = Field(default=None, alias='budgetGrossMargin')
    budget_roi: float | None = Field(default=None, alias='budgetROI')
    actual_revenue: float | None = Field(default=None, alias='actualRevenue')
    actual_gross_margin: float | None = Field(default=None, alias='actualGrossMargin')
    actual_roi: float | None = Field(default=None, alias='actualROI')
    emails_sent: int | None = Field(default=None, alias='emailsSent')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CampaignSubTypeCampaignSubType(ConnectWiseModel):
    id: int | None = None
    type: CampaignTypeReference | None = None
    name: str
    """
     Max length: 100;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CampaignAudit(ConnectWiseModel):
    id: int | None = None
    emails_sent: int = Field(..., alias='emailsSent')
    emails_unsent: int | None = Field(default=None, alias='emailsUnsent')
    documents_created: int | None = Field(default=None, alias='documentsCreated')
    email_subject: str | None = Field(default=None, alias='emailSubject')
    """
     Max length: 1000;
    """
    group: GroupReference | None = None
    campaign_id: int | None = Field(default=None, alias='campaignId')
    created_by: str | None = Field(default=None, alias='createdBy')
    date_created: str | None = Field(default=None, alias='dateCreated')


class CatalogComponent(ConnectWiseModel):
    id: int | None = None
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    quantity: float
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    hide_price_flag: bool | None = Field(default=None, alias='hidePriceFlag')
    hide_item_identifier_flag: bool | None = Field(
        default=None, alias='hideItemIdentifierFlag'
    )
    hide_description_flag: bool | None = Field(
        default=None, alias='hideDescriptionFlag'
    )
    hide_quantity_flag: bool | None = Field(default=None, alias='hideQuantityFlag')
    hide_extended_price_flag: bool | None = Field(
        default=None, alias='hideExtendedPriceFlag'
    )
    parent_catalog_item: CatalogItemReference | None = Field(
        default=None, alias='parentCatalogItem'
    )
    price: float | None = None
    cost: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CatalogInventory(ConnectWiseModel):
    id: int | None = None
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    on_hand: int | None = Field(default=None, alias='onHand')
    serial_numbers: list[OnHandSerialNumberReference] | None = Field(
        default=None, alias='serialNumbers'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CatalogItem(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 60;
    """
    description: str
    """
     Max length: 60;
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    subcategory: ProductSubCategoryReference | None = None
    type: ProductTypeReference | None = None
    product_class: Literal[
        'Agreement', 'Bundle', 'Inventory', 'NonInventory', 'Service'
    ] | None = Field(default=None, alias='productClass')
    """
    Defaults to Non-Inventory.
    """
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    serialized_cost_flag: bool | None = Field(default=None, alias='serializedCostFlag')
    phase_product_flag: bool | None = Field(default=None, alias='phaseProductFlag')
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    min_stock_level: int | None = Field(default=None, alias='minStockLevel')
    price: float | None = None
    cost: float | None = None
    price_attribute: Literal[
        'FixedFee', 'NotToExceed', 'OverrideRate', 'TimeAndMaterials'
    ] | None = Field(default=None, alias='priceAttribute')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    drop_ship_flag: bool | None = Field(default=None, alias='dropShipFlag')
    special_order_flag: bool | None = Field(default=None, alias='specialOrderFlag')
    customer_description: str = Field(..., alias='customerDescription')
    """
     Max length: 6000;
    """
    manufacturer: ManufacturerReference | None = None
    manufacturer_part_number: str | None = Field(
        default=None, alias='manufacturerPartNumber'
    )
    """
     Max length: 50;
    """
    vendor: CompanyReference | None = None
    vendor_sku: str | None = Field(default=None, alias='vendorSku')
    """
     Max length: 50;
    """
    notes: str | None = None
    integration_x_ref: str | None = Field(default=None, alias='integrationXRef')
    """
     Max length: 50;
    """
    sla: SLAReference | None = None
    entity_type: EntityTypeReference | None = Field(default=None, alias='entityType')
    recurring_flag: bool | None = Field(default=None, alias='recurringFlag')
    recurring_revenue: float | None = Field(default=None, alias='recurringRevenue')
    recurring_cost: float | None = Field(default=None, alias='recurringCost')
    recurring_one_time_flag: bool | None = Field(
        default=None, alias='recurringOneTimeFlag'
    )
    recurring_bill_cycle: BillingCycleReference | None = Field(
        default=None, alias='recurringBillCycle'
    )
    recurring_cycle_type: Literal['ContractYear', 'CalendarYear'] | None = Field(
        default=None, alias='recurringCycleType'
    )
    date_entered: str | None = Field(default=None, alias='dateEntered')
    calculated_price_flag: bool | None = Field(
        default=None, alias='calculatedPriceFlag'
    )
    calculated_cost_flag: bool | None = Field(default=None, alias='calculatedCostFlag')
    category: ProductCategoryReference | None = None
    calculated_price: float | None = Field(default=None, alias='calculatedPrice')
    calculated_cost: float | None = Field(default=None, alias='calculatedCost')
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class CatalogPricing(ConnectWiseModel):
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    company: CompanyReference | None = None
    location: SystemLocationReference | None = None
    quantity: int | None = None
    date: str | None = None
    price: float | None = None


class Certification(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ChargeCode(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    company: CompanyReference | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    expense_entry_flag: bool | None = Field(default=None, alias='expenseEntryFlag')
    allow_all_expense_type_flag: bool | None = Field(
        default=None, alias='allowAllExpenseTypeFlag'
    )
    time_entry_flag: bool | None = Field(default=None, alias='timeEntryFlag')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    integration_xref: str | None = Field(default=None, alias='integrationXref')
    """
     Max length: 50;
    """
    expense_type_ids: list[int] | None = Field(default=None, alias='expenseTypeIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ChargeCodeExpenseType(ConnectWiseModel):
    id: int | None = None
    type: ExpenseTypeReference | None = None
    charge_code: ChargeCodeReference | None = Field(default=None, alias='chargeCode')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ChargeCodeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    expense_entry_flag: bool | None = Field(default=None, alias='expenseEntryFlag')
    allow_all_expense_type_flag: bool | None = Field(
        default=None, alias='allowAllExpenseTypeFlag'
    )
    time_entry_flag: bool | None = Field(default=None, alias='timeEntryFlag')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    expense_type_ids: list[int] | None = Field(default=None, alias='expenseTypeIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ClearPickerRequest(ConnectWiseModel):
    member: MemberReference | None = None
    type: Literal['Company', 'Vendor'] | None = None


class Commission(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    commission_percent: float | None = Field(default=None, alias='commissionPercent')
    date_start: datetime | None = Field(default=None, alias='dateStart')
    date_end: datetime | None = Field(default=None, alias='dateEnd')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    company: CompanyReference | None = None
    site: SiteReference | None = None
    agreement: AgreementReference | None = None
    project: ProjectReference | None = None
    service_board: BoardReference | None = Field(default=None, alias='serviceBoard')
    ticket: TicketReference | None = None
    territory: SystemLocationReference | None = None
    billing_method: Literal[
        'Agreement',
        'CreditMemo',
        'DownPayment',
        'Miscellaneous',
        'Progress',
        'Standard',
    ] | None = Field(default=None, alias='billingMethod')
    service_type: ServiceTypeReference | None = Field(default=None, alias='serviceType')
    project_board: ProjectBoardReference | None = Field(
        default=None, alias='projectBoard'
    )
    project_type: ProjectTypeReference | None = Field(default=None, alias='projectType')
    agreement_type: AgreementTypeReference | None = Field(
        default=None, alias='agreementType'
    )
    number_of_months: int | None = Field(default=None, alias='numberOfMonths')
    product_category: ProductCategoryReference | None = Field(
        default=None, alias='productCategory'
    )
    product_sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='productSubCategory'
    )
    item: IvItemReference | None = None
    commission_basis: Literal['GrossProfit', 'SalesAmount'] | None = Field(
        default=None, alias='commissionBasis'
    )
    invoice_option: Literal['AllInvoices', 'PaidInvoices'] | None = Field(
        default=None, alias='invoiceOption'
    )
    services_flag: bool | None = Field(default=None, alias='servicesFlag')
    agreements_flag: bool | None = Field(default=None, alias='agreementsFlag')
    products_flag: bool | None = Field(default=None, alias='productsFlag')
    my_opportunities_flag: bool | None = Field(
        default=None, alias='myOpportunitiesFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Company(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 30;
    """
    name: str
    """
     Max length: 50;
    """
    status: CompanyStatusReference | None = None
    address_line1: str | None = Field(default=None, alias='addressLine1')
    """
    Gets or sets at least one address field is required -- addressLine1, addressLine2, city, state, zip and/or country. Max length: 50;
    """
    address_line2: str | None = Field(default=None, alias='addressLine2')
    """
    Gets or sets at least one address field is required -- addressLine1, addressLine2, city, state, zip and/or country. Max length: 50;
    """
    city: str | None = None
    """
    Gets or sets at least one address field is required -- addressLine1, addressLine2, city, state, zip and/or country. Max length: 50;
    """
    state: str | None = None
    """
    Gets or sets at least one address field is required -- addressLine1, addressLine2, city, state, zip and/or country. Max length: 50;
    """
    zip: str | None = None
    """
    Gets or sets at least one address field is required -- addressLine1, addressLine2, city, state, zip and/or country. Max length: 12;
    """
    country: CountryReference | None = None
    phone_number: str | None = Field(default=None, alias='phoneNumber')
    """
     Max length: 30;
    """
    fax_number: str | None = Field(default=None, alias='faxNumber')
    """
     Max length: 30;
    """
    website: str | None = None
    """
     Max length: 255;
    """
    territory: SystemLocationReference | None = None
    market: MarketDescriptionReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    default_contact: ContactReference | None = Field(
        default=None, alias='defaultContact'
    )
    date_acquired: datetime | None = Field(default=None, alias='dateAcquired')
    sic_code: SicCodeReference | None = Field(default=None, alias='sicCode')
    parent_company: CompanyReference | None = Field(default=None, alias='parentCompany')
    annual_revenue: float | None = Field(default=None, alias='annualRevenue')
    number_of_employees: int | None = Field(default=None, alias='numberOfEmployees')
    year_established: int | None = Field(default=None, alias='yearEstablished')
    revenue_year: int | None = Field(default=None, alias='revenueYear')
    ownership_type: OwnershipTypeReference | None = Field(
        default=None, alias='ownershipType'
    )
    time_zone_setup: TimeZoneSetupReference | None = Field(
        default=None, alias='timeZoneSetup'
    )
    lead_source: str | None = Field(default=None, alias='leadSource')
    """
     Max length: 50;
    """
    lead_flag: bool | None = Field(default=None, alias='leadFlag')
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    calendar: CalendarReference | None = None
    user_defined_field1: str | None = Field(default=None, alias='userDefinedField1')
    """
     Max length: 50;
    """
    user_defined_field2: str | None = Field(default=None, alias='userDefinedField2')
    """
     Max length: 50;
    """
    user_defined_field3: str | None = Field(default=None, alias='userDefinedField3')
    """
     Max length: 50;
    """
    user_defined_field4: str | None = Field(default=None, alias='userDefinedField4')
    """
     Max length: 50;
    """
    user_defined_field5: str | None = Field(default=None, alias='userDefinedField5')
    """
     Max length: 50;
    """
    user_defined_field6: str | None = Field(default=None, alias='userDefinedField6')
    """
     Max length: 50;
    """
    user_defined_field7: str | None = Field(default=None, alias='userDefinedField7')
    """
     Max length: 50;
    """
    user_defined_field8: str | None = Field(default=None, alias='userDefinedField8')
    """
     Max length: 50;
    """
    user_defined_field9: str | None = Field(default=None, alias='userDefinedField9')
    """
     Max length: 50;
    """
    user_defined_field10: str | None = Field(default=None, alias='userDefinedField10')
    """
     Max length: 50;
    """
    vendor_identifier: str | None = Field(default=None, alias='vendorIdentifier')
    tax_identifier: str | None = Field(default=None, alias='taxIdentifier')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    invoice_template: InvoiceTemplateReference | None = Field(
        default=None, alias='invoiceTemplate'
    )
    pricing_schedule: PricingScheduleReference | None = Field(
        default=None, alias='pricingSchedule'
    )
    company_entity_type: EntityTypeReference | None = Field(
        default=None, alias='companyEntityType'
    )
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    billing_site: SiteReference | None = Field(default=None, alias='billingSite')
    billing_contact: ContactReference | None = Field(
        default=None, alias='billingContact'
    )
    invoice_delivery_method: BillingDeliveryReference | None = Field(
        default=None, alias='invoiceDeliveryMethod'
    )
    invoice_to_email_address: str | None = Field(
        default=None, alias='invoiceToEmailAddress'
    )
    invoice_cc_email_address: str | None = Field(
        default=None, alias='invoiceCCEmailAddress'
    )
    deleted_flag: bool | None = Field(default=None, alias='deletedFlag')
    date_deleted: datetime | None = Field(default=None, alias='dateDeleted')
    deleted_by: str | None = Field(default=None, alias='deletedBy')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    facebook_url: str | None = Field(default=None, alias='facebookUrl')
    twitter_url: str | None = Field(default=None, alias='twitterUrl')
    linked_in_url: str | None = Field(default=None, alias='linkedInUrl')
    currency: CurrencyReference | None = None
    territory_manager: MemberReference | None = Field(
        default=None, alias='territoryManager'
    )
    reseller_identifier: str | None = Field(default=None, alias='resellerIdentifier')
    is_vendor_flag: bool | None = Field(default=None, alias='isVendorFlag')
    types: list[CompanyTypeReference] | None = None
    """
    Gets or sets integrer array of Company_Type_Recids to be assigned to company that can be passed in only during new company creation (post)
                To update existing companies type, use the /company/companyTypeAssociations or /company/companies/{ID}/typeAssociations endpoints.
    """
    site: SiteReference | None = None
    integrator_tags: list[str] | None = Field(default=None, alias='integratorTags')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class CompanyCompanyTypeAssociation(ConnectWiseModel):
    id: int | None = None
    type: CompanyTypeReference | None = None
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyConfiguration(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    type: ConfigurationTypeReference | None = None
    status: ConfigurationStatusReference | None = None
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    site: SiteReference | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    device_identifier: str | None = Field(default=None, alias='deviceIdentifier')
    """
     Max length: 100;
    """
    serial_number: str | None = Field(default=None, alias='serialNumber')
    """
     Max length: 250;
    """
    model_number: str | None = Field(default=None, alias='modelNumber')
    """
     Max length: 50;
    """
    tag_number: str | None = Field(default=None, alias='tagNumber')
    """
     Max length: 50;
    """
    purchase_date: datetime | None = Field(default=None, alias='purchaseDate')
    installation_date: datetime | None = Field(default=None, alias='installationDate')
    installed_by: MemberReference | None = Field(default=None, alias='installedBy')
    warranty_expiration_date: datetime | None = Field(
        default=None, alias='warrantyExpirationDate'
    )
    vendor_notes: str | None = Field(default=None, alias='vendorNotes')
    notes: str | None = None
    mac_address: str | None = Field(default=None, alias='macAddress')
    """
     Max length: 25;
    """
    last_login_name: str | None = Field(default=None, alias='lastLoginName')
    """
     Max length: 100;
    """
    bill_flag: bool | None = Field(default=None, alias='billFlag')
    backup_successes: int | None = Field(default=None, alias='backupSuccesses')
    backup_incomplete: int | None = Field(default=None, alias='backupIncomplete')
    backup_failed: int | None = Field(default=None, alias='backupFailed')
    backup_restores: int | None = Field(default=None, alias='backupRestores')
    last_backup_date: datetime | None = Field(default=None, alias='lastBackupDate')
    backup_server_name: str | None = Field(default=None, alias='backupServerName')
    """
     Max length: 50;
    """
    backup_billable_space_gb: float | None = Field(
        default=None, alias='backupBillableSpaceGb'
    )
    backup_protected_device_list: str | None = Field(
        default=None, alias='backupProtectedDeviceList'
    )
    backup_year: int | None = Field(default=None, alias='backupYear')
    backup_month: int | None = Field(default=None, alias='backupMonth')
    ip_address: str | None = Field(default=None, alias='ipAddress')
    """
     Max length: 50;
    """
    default_gateway: str | None = Field(default=None, alias='defaultGateway')
    """
     Max length: 50;
    """
    os_type: str | None = Field(default=None, alias='osType')
    """
     Max length: 250;
    """
    os_info: str | None = Field(default=None, alias='osInfo')
    """
     Max length: 250;
    """
    cpu_speed: str | None = Field(default=None, alias='cpuSpeed')
    """
     Max length: 100;
    """
    ram: str | None = None
    """
     Max length: 25;
    """
    local_hard_drives: str | None = Field(default=None, alias='localHardDrives')
    parent_configuration_id: int | None = Field(
        default=None, alias='parentConfigurationId'
    )
    vendor: CompanyReference | None = None
    manufacturer: ManufacturerReference | None = None
    questions: list[ConfigurationQuestion] | None = None
    active_flag: bool | None = Field(default=None, alias='activeFlag')
    management_link: str | None = Field(default=None, alias='managementLink')
    """
     Max length: 1000;
    """
    remote_link: str | None = Field(default=None, alias='remoteLink')
    """
     Max length: 1000;
    """
    sla: SLAReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    display_vendor_flag: bool | None = Field(default=None, alias='displayVendorFlag')
    company_location_id: int | None = Field(default=None, alias='companyLocationId')
    show_remote_flag: bool | None = Field(default=None, alias='showRemoteFlag')
    show_automate_flag: bool | None = Field(default=None, alias='showAutomateFlag')
    needs_renewal_flag: bool | None = Field(default=None, alias='needsRenewalFlag')
    manufacturer_part_number: str | None = Field(
        default=None, alias='manufacturerPartNumber'
    )
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class CompanyContactTypeAssociation(ConnectWiseModel):
    id: int | None = None
    type: ContactTypeReference | None = None
    contact: ContactReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyCompanyTypeAssociationCompanyTypeAssociation(
    CompanyCompanyTypeAssociation
):
    pass


class CompanyCustomNote(ConnectWiseModel):
    id: int | None = None
    custom_note: str = Field(..., alias='customNote')
    """
     Max length: 1500;
    """
    status: CompanyStatusReference | None = None
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyFinance(ConnectWiseModel):
    id: int | None = None
    bill_override_flag: bool | None = Field(default=None, alias='billOverrideFlag')
    bill_sr_flag: bool | None = Field(default=None, alias='billSrFlag')
    bill_complete_sr_flag: bool | None = Field(default=None, alias='billCompleteSrFlag')
    bill_unapproved_sr_flag: bool | None = Field(
        default=None, alias='billUnapprovedSrFlag'
    )
    bill_restrict_pm_flag: bool | None = Field(default=None, alias='billRestrictPmFlag')
    bill_complete_pm_flag: bool | None = Field(default=None, alias='billCompletePmFlag')
    bill_unapproved_pm_flag: bool | None = Field(
        default=None, alias='billUnapprovedPmFlag'
    )
    email_template: EmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class CompanyGroup(ConnectWiseModel):
    id: int | None = None
    """
     Required On Updates;
    """
    group: GroupReference | None = None
    company: CompanyReference | None = None
    default_contact_flag: bool | None = Field(default=None, alias='defaultContactFlag')
    all_contacts_flag: bool | None = Field(default=None, alias='allContactsFlag')
    remove_all_contacts_flag: bool | None = Field(
        default=None, alias='removeAllContactsFlag'
    )
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    contact_ids: list[int] | None = Field(default=None, alias='contactIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyManagementSummary(ConnectWiseModel):
    id: int | None = None
    management_solution: ManagementSolutionReference | None = Field(
        default=None, alias='managementSolution'
    )
    group_identifier: str = Field(..., alias='groupIdentifier')
    """
     Max length: 100;
    """
    device_type: Literal[
        'WorkstationsAndServers', 'BackupStats', 'Servers', 'Workstations'
    ] | None = Field(default=None, alias='deviceType')
    """
    Gets or sets deviceType is required if the managementSolution is Legacy.
    """
    agreement: AgreementReference | None = None
    snmp_machines: int | None = Field(default=None, alias='snmpMachines')
    total_workstations: int | None = Field(default=None, alias='totalWorkstations')
    total_servers: int | None = Field(default=None, alias='totalServers')
    total_windows_servers: int | None = Field(default=None, alias='totalWindowsServers')
    total_windows_workstations: int | None = Field(
        default=None, alias='totalWindowsWorkstations'
    )
    total_managed_machines: int | None = Field(
        default=None, alias='totalManagedMachines'
    )
    servers_offline: int | None = Field(default=None, alias='serversOffline')
    servers_disk_space_low: int | None = Field(
        default=None, alias='serversDiskSpaceLow'
    )
    failed_backup_jobs: int | None = Field(default=None, alias='failedBackupJobs')
    total_notifications: int | None = Field(default=None, alias='totalNotifications')
    successful_backup_jobs: int | None = Field(
        default=None, alias='successfulBackupJobs'
    )
    server_availability: int | None = Field(default=None, alias='serverAvailability')
    viruses_removed: int | None = Field(default=None, alias='virusesRemoved')
    spyware_items_removed: int | None = Field(default=None, alias='spywareItemsRemoved')
    windows_patches_installed: int | None = Field(
        default=None, alias='windowsPatchesInstalled'
    )
    disk_cleanups: int | None = Field(default=None, alias='diskCleanups')
    disk_defragmentations: int | None = Field(
        default=None, alias='diskDefragmentations'
    )
    fully_patched_machines: int | None = Field(
        default=None, alias='fullyPatchedMachines'
    )
    missing_one_two_patches_machines: int | None = Field(
        default=None, alias='missingOneTwoPatchesMachines'
    )
    missing_three_five_patches_machines: int | None = Field(
        default=None, alias='missingThreeFivePatchesMachines'
    )
    missing_more_five_patches_machines: int | None = Field(
        default=None, alias='missingMoreFivePatchesMachines'
    )
    missing_unscanned_patches_machines: int | None = Field(
        default=None, alias='missingUnscannedPatchesMachines'
    )
    alerts_generated: str | None = Field(default=None, alias='alertsGenerated')
    internet_connectivity: float | None = Field(
        default=None, alias='internetConnectivity'
    )
    disk_space_cleaned_mb: int | None = Field(default=None, alias='diskSpaceCleanedMb')
    missing_security_patches: str | None = Field(
        default=None, alias='missingSecurityPatches'
    )
    cpu_utilization: float | None = Field(default=None, alias='cpuUtilization')
    memory_utilization: float | None = Field(default=None, alias='memoryUtilization')
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyNote(ConnectWiseModel):
    id: int | None = None
    text: str
    type: NoteTypeReference | None = None
    flagged: bool | None = None
    entered_by: str | None = Field(default=None, alias='enteredBy')
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyPickerItem(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    company: CompanyReference | None = None
    company_status: CompanyStatusReference | None = Field(
        default=None, alias='companyStatus'
    )
    company_type: CompanyTypeReference | None = Field(default=None, alias='companyType')
    company_site: SiteReference | None = Field(default=None, alias='companySite')
    company_location: SystemLocationReference | None = Field(
        default=None, alias='companyLocation'
    )
    company_country: CountryReference | None = Field(
        default=None, alias='companyCountry'
    )
    vendor_picker_flag: bool | None = Field(default=None, alias='vendorPickerFlag')
    """
    Gets or sets if true, this record was created by the vendor picker component. Otherwise, the record was created by the company picker component.
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanySite(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    address_line1: str | None = Field(default=None, alias='addressLine1')
    """
     Max length: 50;
    """
    address_line2: str | None = Field(default=None, alias='addressLine2')
    """
     Max length: 50;
    """
    city: str | None = None
    """
     Max length: 50;
    """
    state_reference: StateReference | None = Field(default=None, alias='stateReference')
    zip: str | None = None
    """
     Max length: 12;
    """
    country: CountryReference | None = None
    address_format: str | None = Field(default=None, alias='addressFormat')
    phone_number: str | None = Field(default=None, alias='phoneNumber')
    """
     Max length: 30;
    """
    phone_number_ext: str | None = Field(default=None, alias='phoneNumberExt')
    """
     Max length: 30;
    """
    fax_number: str | None = Field(default=None, alias='faxNumber')
    """
     Max length: 30;
    """
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    entity_type: EntityTypeReference | None = Field(default=None, alias='entityType')
    expense_reimbursement: float | None = Field(
        default=None, alias='expenseReimbursement'
    )
    primary_address_flag: bool | None = Field(default=None, alias='primaryAddressFlag')
    default_shipping_flag: bool | None = Field(
        default=None, alias='defaultShippingFlag'
    )
    default_billing_flag: bool | None = Field(default=None, alias='defaultBillingFlag')
    default_mailing_flag: bool | None = Field(default=None, alias='defaultMailingFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    bill_separate_flag: bool | None = Field(default=None, alias='billSeparateFlag')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    calendar: CalendarReference | None = None
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class CompanyStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    notify_flag: bool | None = Field(default=None, alias='notifyFlag')
    disallow_saving_flag: bool | None = Field(default=None, alias='disallowSavingFlag')
    notification_message: str | None = Field(default=None, alias='notificationMessage')
    """
     Max length: 500;
    """
    custom_note_flag: bool | None = Field(default=None, alias='customNoteFlag')
    cancel_open_tracks_flag: bool | None = Field(
        default=None, alias='cancelOpenTracksFlag'
    )
    track: TrackReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CompanyTeam(ConnectWiseModel):
    id: int | None = None
    company: CompanyReference | None = None
    team_role: TeamRoleReference | None = Field(default=None, alias='teamRole')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    contact: ContactReference | None = None
    member: MemberReference | None = None
    account_manager_flag: bool | None = Field(default=None, alias='accountManagerFlag')
    tech_flag: bool | None = Field(default=None, alias='techFlag')
    sales_flag: bool | None = Field(default=None, alias='salesFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeQuestion(ConnectWiseModel):
    id: int | None = None
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    field_type: Literal[
        'TextArea',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] = Field(..., alias='fieldType')
    entry_type: Literal['Date', 'EntryField', 'List', 'Option'] = Field(
        ..., alias='entryType'
    )
    sequence_number: float = Field(..., alias='sequenceNumber')
    question: str
    """
     Max length: 1000;
    """
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeQuestionInfo(ConnectWiseModel):
    id: int | None = None
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    field_type: Literal[
        'TextArea',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] | None = Field(default=None, alias='fieldType')
    entry_type: Literal['Date', 'EntryField', 'List', 'Option'] | None = Field(
        default=None, alias='entryType'
    )
    sequence_number: float | None = Field(default=None, alias='sequenceNumber')
    question: str | None = None
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeQuestionValue(ConnectWiseModel):
    id: int | None = None
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    question: ConfigurationTypeQuestionReference | None = None
    value: str
    """
     Max length: 1000;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConfigurationTypeQuestionValueInfo(ConnectWiseModel):
    id: int | None = None
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    question: ConfigurationTypeQuestionReference | None = None
    value: str | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Contact(ConnectWiseModel):
    id: int | None = None
    first_name: str | None = Field(default=None, alias='firstName')
    last_name: str | None = Field(default=None, alias='lastName')
    company: CompanyReference | None = None
    site: SiteReference | None = None
    address_line1: str | None = Field(default=None, alias='addressLine1')
    address_line2: str | None = Field(default=None, alias='addressLine2')
    city: str | None = None
    state: str | None = None
    zip: str | None = None
    country: CountryReference | None = None
    relationship: RelationshipReference | None = None
    relationship_override: str | None = Field(
        default=None, alias='relationshipOverride'
    )
    department: ContactDepartmentReference | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_merge_contact_id: int | None = Field(
        default=None, alias='defaultMergeContactId'
    )
    security_identifier: str | None = Field(default=None, alias='securityIdentifier')
    manager_contact: ContactReference | None = Field(
        default=None, alias='managerContact'
    )
    assistant_contact: ContactReference | None = Field(
        default=None, alias='assistantContact'
    )
    title: str | None = None
    school: str | None = None
    nick_name: str | None = Field(default=None, alias='nickName')
    married_flag: bool | None = Field(default=None, alias='marriedFlag')
    children_flag: bool | None = Field(default=None, alias='childrenFlag')
    children: str | None = None
    significant_other: str | None = Field(default=None, alias='significantOther')
    portal_password: str | None = Field(default=None, alias='portalPassword')
    portal_security_level: int | None = Field(default=None, alias='portalSecurityLevel')
    disable_portal_login_flag: bool | None = Field(
        default=None, alias='disablePortalLoginFlag'
    )
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    gender: Literal['Female', 'Male'] | None = None
    birth_day: str | None = Field(default=None, alias='birthDay')
    anniversary: str | None = None
    presence: Literal[
        'NoAgent', 'Online', 'DoNotDisturb', 'Away', 'Offline'
    ] | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    facebook_url: str | None = Field(default=None, alias='facebookUrl')
    twitter_url: str | None = Field(default=None, alias='twitterUrl')
    linked_in_url: str | None = Field(default=None, alias='linkedInUrl')
    default_phone_type: str | None = Field(default=None, alias='defaultPhoneType')
    default_phone_nbr: str | None = Field(default=None, alias='defaultPhoneNbr')
    default_phone_extension: str | None = Field(
        default=None, alias='defaultPhoneExtension'
    )
    default_billing_flag: bool | None = Field(default=None, alias='defaultBillingFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    user_defined_field1: str | None = Field(default=None, alias='userDefinedField1')
    """
     Max length: 50;
    """
    user_defined_field2: str | None = Field(default=None, alias='userDefinedField2')
    """
     Max length: 50;
    """
    user_defined_field3: str | None = Field(default=None, alias='userDefinedField3')
    """
     Max length: 50;
    """
    user_defined_field4: str | None = Field(default=None, alias='userDefinedField4')
    """
     Max length: 50;
    """
    user_defined_field5: str | None = Field(default=None, alias='userDefinedField5')
    """
     Max length: 50;
    """
    user_defined_field6: str | None = Field(default=None, alias='userDefinedField6')
    """
     Max length: 50;
    """
    user_defined_field7: str | None = Field(default=None, alias='userDefinedField7')
    """
     Max length: 50;
    """
    user_defined_field8: str | None = Field(default=None, alias='userDefinedField8')
    """
     Max length: 50;
    """
    user_defined_field9: str | None = Field(default=None, alias='userDefinedField9')
    """
     Max length: 50;
    """
    user_defined_field10: str | None = Field(default=None, alias='userDefinedField10')
    """
     Max length: 50;
    """
    company_location: SystemLocationReference | None = Field(
        default=None, alias='companyLocation'
    )
    communication_items: list[ContactCommunicationItem] | None = Field(
        default=None, alias='communicationItems'
    )
    types: list[ContactTypeReference] | None = None
    integrator_tags: list[str] | None = Field(default=None, alias='integratorTags')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )
    photo: DocumentReference | None = None
    ignore_duplicates: bool | None = Field(default=None, alias='ignoreDuplicates')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    type_ids: list[int] | None = Field(default=None, alias='typeIds')
    """
    Gets or sets integrer array of Contact_Type_Recids to be assigned to contact that can be passed in only during new contact creation (post)
                To update existing contacts type, use the /company/contactTypeAssociations or /company/contacts/{ID}/typeAssociations endpoints.
    """


class ContactContactTypeAssociationContactTypeAssociation(
    CompanyContactTypeAssociation
):
    pass


class ContactGroup(ConnectWiseModel):
    id: int | None = None
    group: GroupReference | None = None
    contact: ContactReference | None = None
    description: str | None = None
    """
     Max length: 50;
    """
    unsubscribe_flag: bool | None = Field(default=None, alias='unsubscribeFlag')
    company_unsubcribed_email_message: str | None = Field(
        default=None, alias='companyUnsubcribedEmailMessage'
    )
    company_group_unsubscribed_email_message: str | None = Field(
        default=None, alias='companyGroupUnsubscribedEmailMessage'
    )
    contact_unsubscribed_email_message: str | None = Field(
        default=None, alias='contactUnsubscribedEmailMessage'
    )
    contact_group_unsubscribed_email_message: str | None = Field(
        default=None, alias='contactGroupUnsubscribedEmailMessage'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ContactNote(ConnectWiseModel):
    id: int | None = None
    contact_id: int | None = Field(default=None, alias='contactId')
    text: str
    type: NoteTypeReference | None = None
    flagged: bool | None = None
    entered_by: str | None = Field(default=None, alias='enteredBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Conversion(ConnectWiseModel):
    id: int | None = None
    quantity: float | None = None
    uom_type: UnitOfMeasureReference | None = Field(default=None, alias='uomType')
    parent_uom: UnitOfMeasureReference | None = Field(default=None, alias='parentUOM')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ConvertItem(ConnectWiseModel):
    id: int | None = None
    record_type: Literal['ProjectIssue', 'ProjectTicket', 'ServiceTicket'] = Field(
        ..., alias='recordType'
    )
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    wbs_code: str | None = Field(default=None, alias='wbsCode')


class ConvertToProject(ConnectWiseModel):
    id: int | None = None
    record_type: Literal[
        'ProjectIssue', 'ProjectTicket', 'ServiceTicket'
    ] | None = Field(default=None, alias='recordType')
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    wbs_code: str = Field(..., alias='wbsCode')


class CorporateStructure(ConnectWiseModel):
    id: int | None = None
    level_count: Literal[
        'Level1', 'Level2', 'Level3', 'Level4', 'Level5'
    ] | None = Field(default=None, alias='levelCount')
    level1_name: str | None = Field(default=None, alias='level1Name')
    """
     Max length: 20;
    """
    level2_name: str | None = Field(default=None, alias='level2Name')
    """
     Max length: 20;
    """
    level3_name: str | None = Field(default=None, alias='level3Name')
    """
     Max length: 20;
    """
    level4_name: str | None = Field(default=None, alias='level4Name')
    """
     Max length: 20;
    """
    level5_name: str | None = Field(default=None, alias='level5Name')
    """
     Max length: 20;
    """
    fiscal_year_start: Literal[
        'January',
        'February',
        'March',
        'April',
        'May',
        'June',
        'July',
        'August',
        'September',
        'October',
        'November',
        'December',
    ] = Field(..., alias='fiscalYearStart')
    location_caption: str = Field(..., alias='locationCaption')
    """
     Max length: 50;
    """
    group_caption: str = Field(..., alias='groupCaption')
    """
     Max length: 50;
    """
    base_currency: CurrencyReference = Field(..., alias='baseCurrency')
    president: MemberReference | None = None
    chief_operating_officer: MemberReference | None = Field(
        default=None, alias='chiefOperatingOfficer'
    )
    controller: MemberReference | None = None
    dispatcher: MemberReference | None = None
    service_manager: MemberReference | None = Field(
        default=None, alias='serviceManager'
    )
    duty_manager: MemberReference | None = Field(default=None, alias='dutyManager')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CorporateStructureInfo(ConnectWiseModel):
    id: int | None = None
    location_caption: str | None = Field(default=None, alias='locationCaption')
    group_caption: str | None = Field(default=None, alias='groupCaption')
    base_currency: CurrencyReference | None = Field(default=None, alias='baseCurrency')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Country(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    currency: CurrencyReference | None = None
    city_caption: str | None = Field(default=None, alias='cityCaption')
    """
     Max length: 25;
    """
    state_caption: str | None = Field(default=None, alias='stateCaption')
    """
     Max length: 25;
    """
    zip_caption: str | None = Field(default=None, alias='zipCaption')
    """
     Max length: 25;
    """
    zip_minimum_length: int | None = Field(default=None, alias='zipMinimumLength')
    dialing_prefix: str | None = Field(default=None, alias='dialingPrefix')
    """
     Max length: 5;
    """
    address_format: AddressFormatReference | None = Field(
        default=None, alias='addressFormat'
    )
    country_code: str | None = Field(default=None, alias='countryCode')
    """
     Max length: 2;
    """
    core_entity_country_code: Literal[
        'AF',
        'AX',
        'AL',
        'DZ',
        'AS',
        'AD',
        'AO',
        'AI',
        'AQ',
        'AR',
        'AM',
        'AW',
        'AT',
        'AZ',
        'BH',
        'BD',
        'BB',
        'BY',
        'BZ',
        'BJ',
        'BM',
        'BT',
        'BO',
        'BQ',
        'BA',
        'BW',
        'BV',
        'IO',
        'BN',
        'BG',
        'BF',
        'BI',
        'CM',
        'CV',
        'KY',
        'CF',
        'TD',
        'CL',
        'CX',
        'CC',
        'CO',
        'KM',
        'CG',
        'CK',
        'CI',
        'HR',
        'CU',
        'CW',
        'CY',
        'CZ',
        'CD',
        'DK',
        'DJ',
        'DM',
        'EC',
        'EG',
        'GQ',
        'ER',
        'EE',
        'ET',
        'FK',
        'FO',
        'FJ',
        'FI',
        'FR',
        'GF',
        'PF',
        'TF',
        'GA',
        'GM',
        'GE',
        'GH',
        'GI',
        'GR',
        'GL',
        'GD',
        'GP',
        'GU',
        'GT',
        'GG',
        'GN',
        'GW',
        'GY',
        'HT',
        'HM',
        'HN',
        'HK',
        'HU',
        'IS',
        'IN',
        'IR',
        'IQ',
        'IE',
        'IM',
        'IT',
        'JM',
        'JP',
        'JE',
        'JO',
        'KZ',
        'KE',
        'KI',
        'XK',
        'KW',
        'KG',
        'LA',
        'LV',
        'LB',
        'LS',
        'LR',
        'LY',
        'LI',
        'LT',
        'LU',
        'MO',
        'MK',
        'MG',
        'MW',
        'MY',
        'ML',
        'MT',
        'MH',
        'MQ',
        'MR',
        'MU',
        'YT',
        'FM',
        'MD',
        'MC',
        'MN',
        'ME',
        'MS',
        'MZ',
        'NA',
        'NR',
        'NP',
        'NC',
        'NZ',
        'NI',
        'NE',
        'NG',
        'NU',
        'NF',
        'KP',
        'MP',
        'OM',
        'PK',
        'PW',
        'PS',
        'PG',
        'PY',
        'PE',
        'PN',
        'PL',
        'PT',
        'PR',
        'RE',
        'RO',
        'RU',
        'RW',
        'BL',
        'SH',
        'PM',
        'VC',
        'WS',
        'SM',
        'ST',
        'SN',
        'RS',
        'SC',
        'SL',
        'SX',
        'SK',
        'SI',
        'SB',
        'SO',
        'ZA',
        'GS',
        'KR',
        'SS',
        'ES',
        'LK',
        'SD',
        'SR',
        'SJ',
        'SZ',
        'SE',
        'SY',
        'TJ',
        'TZ',
        'TH',
        'TL',
        'TG',
        'TK',
        'TO',
        'TN',
        'TR',
        'TV',
        'UG',
        'UA',
        'GB',
        'UM',
        'UZ',
        'VU',
        'VN',
        'WF',
        'EH',
        'YE',
        'ZM',
        'ZW',
        'US',
        'CR',
        'MX',
        'AE',
        'VI',
        'VG',
        'SA',
        'KH',
        'AU',
        'ID',
        'CA',
        'BR',
        'TW',
        'TM',
        'TC',
        'QA',
        'MM',
        'CN',
        'SG',
        'IL',
        'VA',
        'DE',
        'NL',
        'AG',
        'BE',
        'LC',
        'UY',
        'PH',
        'BS',
        'VE',
        'CH',
        'MF',
        'KN',
        'TT',
        'DO',
        'PA',
        'MV',
        'SV',
        'NO',
        'MA',
        'AC',
        'TA',
    ] | None = Field(default=None, alias='coreEntityCountryCode')
    localization_caption_one: str | None = Field(
        default=None, alias='localizationCaptionOne'
    )
    """
     Max length: 25;
    """
    localization_value_one: str | None = Field(
        default=None, alias='localizationValueOne'
    )
    """
     Max length: 50;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Crm(ConnectWiseModel):
    id: int | None = None
    company_list_count: int | None = Field(default=None, alias='companyListCount')
    lock_probability_flag: bool | None = Field(
        default=None, alias='lockProbabilityFlag'
    )
    account_manager_role: TeamRoleReference | None = Field(
        default=None, alias='accountManagerRole'
    )
    technical_contact_role: TeamRoleReference | None = Field(
        default=None, alias='technicalContactRole'
    )
    sales_rep_role: TeamRoleReference | None = Field(default=None, alias='salesRepRole')
    company_id_generation_flag: bool | None = Field(
        default=None, alias='companyIdGenerationFlag'
    )
    exclude_spaces_flag: bool | None = Field(default=None, alias='excludeSpacesFlag')
    field1_caption: str | None = Field(default=None, alias='field1Caption')
    """
     Max length: 25;
    """
    field2_caption: str | None = Field(default=None, alias='field2Caption')
    """
     Max length: 25;
    """
    field3_caption: str | None = Field(default=None, alias='field3Caption')
    """
     Max length: 25;
    """
    field4_caption: str | None = Field(default=None, alias='field4Caption')
    """
     Max length: 25;
    """
    field5_caption: str | None = Field(default=None, alias='field5Caption')
    """
     Max length: 25;
    """
    field6_caption: str | None = Field(default=None, alias='field6Caption')
    """
     Max length: 25;
    """
    field7_caption: str | None = Field(default=None, alias='field7Caption')
    """
     Max length: 25;
    """
    field8_caption: str | None = Field(default=None, alias='field8Caption')
    """
     Max length: 25;
    """
    field9_caption: str | None = Field(default=None, alias='field9Caption')
    """
     Max length: 25;
    """
    field10_caption: str | None = Field(default=None, alias='field10Caption')
    """
     Max length: 25;
    """
    primary_rep_caption: str | None = Field(default=None, alias='primaryRepCaption')
    """
     Max length: 50;
    """
    secondary_rep_caption: str | None = Field(default=None, alias='secondaryRepCaption')
    """
     Max length: 50;
    """
    other1_caption: str | None = Field(default=None, alias='other1Caption')
    """
     Max length: 50;
    """
    other2_caption: str | None = Field(default=None, alias='other2Caption')
    """
     Max length: 50;
    """
    default_year: bool | None = Field(default=None, alias='defaultYear')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CrmInfo(ConnectWiseModel):
    id: int | None = None
    account_manager_role: TeamRoleReference | None = Field(
        default=None, alias='accountManagerRole'
    )
    technical_contact_role: TeamRoleReference | None = Field(
        default=None, alias='technicalContactRole'
    )
    sales_rep_role: TeamRoleReference | None = Field(default=None, alias='salesRepRole')
    field1_caption: str | None = Field(default=None, alias='field1Caption')
    field2_caption: str | None = Field(default=None, alias='field2Caption')
    field3_caption: str | None = Field(default=None, alias='field3Caption')
    field4_caption: str | None = Field(default=None, alias='field4Caption')
    field5_caption: str | None = Field(default=None, alias='field5Caption')
    field6_caption: str | None = Field(default=None, alias='field6Caption')
    field7_caption: str | None = Field(default=None, alias='field7Caption')
    field8_caption: str | None = Field(default=None, alias='field8Caption')
    field9_caption: str | None = Field(default=None, alias='field9Caption')
    field10_caption: str | None = Field(default=None, alias='field10Caption')
    primary_rep_caption: str | None = Field(default=None, alias='primaryRepCaption')
    secondary_rep_caption: str | None = Field(default=None, alias='secondaryRepCaption')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class CustomReportParameter(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    """
    Either a caption name or parameter name is required. Max length: 50;
    """
    caption_name: str | None = Field(default=None, alias='captionName')
    """
    Either a caption name or parameter name is required. Max length: 50;
    """
    custom_report: CustomReportReference | None = Field(
        default=None, alias='customReport'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DepartmentLocation(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    department_manager: MemberReference | None = Field(
        default=None, alias='departmentManager'
    )
    dispatch: MemberReference | None = None
    service_manager: MemberReference | None = Field(
        default=None, alias='serviceManager'
    )
    duty_manager: MemberReference | None = Field(default=None, alias='dutyManager')
    ldap_config: LdapConfigurationReference | None = Field(
        default=None, alias='ldapConfig'
    )
    add_all_locations: bool | None = Field(default=None, alias='addAllLocations')
    remove_all_locations: bool | None = Field(default=None, alias='removeAllLocations')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DepartmentLocationInfo(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class DocumentInfo(ConnectWiseModel):
    id: int | None = None
    title: str | None = None
    file_name: str | None = Field(default=None, alias='fileName')
    server_file_name: str | None = Field(default=None, alias='serverFileName')
    owner: str | None = None
    link_flag: bool | None = Field(default=None, alias='linkFlag')
    image_flag: bool | None = Field(default=None, alias='imageFlag')
    public_flag: bool | None = Field(default=None, alias='publicFlag')
    html_template_flag: bool | None = Field(default=None, alias='htmlTemplateFlag')
    read_only_flag: bool | None = Field(default=None, alias='readOnlyFlag')
    size: int | None = None
    url_flag: bool | None = Field(default=None, alias='urlFlag')
    created_on_date: str | None = Field(default=None, alias='createdOnDate')
    document_type: DocumentTypeReference | None = Field(
        default=None, alias='documentType'
    )
    guid: UUID | None = Field(
        default=None, example='00000000-0000-0000-0000-000000000000'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailConnector(ConnectWiseModel):
    id: int | None = None
    email_server_type: Literal['IMAP', 'Office365', 'Google', 'Asio365'] | None = Field(
        default=None, alias='emailServerType'
    )
    imap_setup: ImapSetupReference | None = Field(default=None, alias='imapSetup')
    office365_email_setup: Office365EmailSetupReference | None = Field(
        default=None, alias='office365EmailSetup'
    )
    asio365_email_setup: Office365EmailSetupReference | None = Field(
        default=None, alias='asio365EmailSetup'
    )
    google_email_setup: GoogleEmailSetupReference | None = Field(
        default=None, alias='googleEmailSetup'
    )
    service_board: BoardReference | None = Field(default=None, alias='serviceBoard')
    default_company: CompanyReference | None = Field(
        default=None, alias='defaultCompany'
    )
    default_member: MemberReference | None = Field(default=None, alias='defaultMember')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    email_notify_from: str | None = Field(default=None, alias='emailNotifyFrom')
    """
     Max length: 50;
    """
    bcc_email_to: str | None = Field(default=None, alias='bccEmailTo')
    """
     Max length: 250;
    """
    email_errors_to: str = Field(..., alias='emailErrorsTo')
    """
     Max length: 50;
    """
    set_email_to_default_contact_flag: bool | None = Field(
        default=None, alias='setEmailToDefaultContactFlag'
    )
    no_response_flag: bool | None = Field(default=None, alias='noResponseFlag')
    never_respond_flag: bool | None = Field(default=None, alias='neverRespondFlag')
    discard_duplicates_flag: bool | None = Field(
        default=None, alias='discardDuplicatesFlag'
    )
    post_replies_to_ticket_flag: bool | None = Field(
        default=None, alias='postRepliesToTicketFlag'
    )
    create_contact_flag: bool | None = Field(default=None, alias='createContactFlag')
    response_email_for_new: str | None = Field(
        default=None, alias='responseEmailForNew'
    )
    response_email_for_existing: str | None = Field(
        default=None, alias='responseEmailForExisting'
    )
    source_override: ServiceSourceReference | None = Field(
        default=None, alias='sourceOverride'
    )
    priority_override: PriorityReference | None = Field(
        default=None, alias='priorityOverride'
    )
    type_override: ServiceTypeReference | None = Field(
        default=None, alias='typeOverride'
    )
    sub_type_override: ServiceSubTypeReference | None = Field(
        default=None, alias='subTypeOverride'
    )
    item_override: ServiceItemReference | None = Field(
        default=None, alias='itemOverride'
    )
    status_override: ServiceStatusReference | None = Field(
        default=None, alias='statusOverride'
    )
    add_cc_flag: bool | None = Field(default=None, alias='addCcFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailConnectorInfo(ConnectWiseModel):
    id: int | None = None
    imap_setup: ImapSetupReference | None = Field(default=None, alias='imapSetup')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailConnectorParsingRule(ConnectWiseModel):
    id: int | None = None
    parsing_style: EmailConnectorParsingStyleReference | None = Field(
        default=None, alias='parsingStyle'
    )
    priority: int
    parsing_variable: EmailConnectorParsingVariableReference | None = Field(
        default=None, alias='parsingVariable'
    )
    search_term: str = Field(..., alias='searchTerm')
    """
     Max length: 250;
    """
    service_priority: PriorityReference | None = Field(
        default=None, alias='servicePriority'
    )
    service_status: ServiceStatusReference | None = Field(
        default=None, alias='serviceStatus'
    )
    service_type: ServiceTypeReference | None = Field(default=None, alias='serviceType')
    service_sub_type: ServiceSubTypeReference | None = Field(
        default=None, alias='serviceSubType'
    )
    service_item: ServiceItemReference | None = Field(default=None, alias='serviceItem')
    service_board: BoardReference | None = Field(default=None, alias='serviceBoard')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EmailConnectorParsingStyle(ConnectWiseModel):
    id: int | None = None
    parsing_type: EmailConnectorParsingTypeReference | None = Field(
        default=None, alias='parsingType'
    )
    parse_rule: str = Field(..., alias='parseRule')
    """
     Max length: 500;
    """
    priority: int
    info: dict[str, str] | None = Field(default=None, alias='_info')


class EPayConfiguration(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    currency: CurrencyReference | None = None
    url: str
    """
     Max length: 400;
    """
    store_identifier: str = Field(..., alias='storeIdentifier')
    """
     Max length: 500;
    """
    encryption_key: str | None = Field(default=None, alias='encryptionKey')
    """
     Max length: 500;
    """
    initialization_vector: str | None = Field(
        default=None, alias='initializationVector'
    )
    """
     Max length: 500;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ErrorResponseMessage(ConnectWiseModel):
    code: str | None = None
    message: str | None = None
    errors: list[ValidationError] | None = None


class ExpenseEntryAudit(TimeEntryAudit):
    pass


class ExpenseReport(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    year: int | None = None
    period: int | None = None
    date_start: str | None = Field(default=None, alias='dateStart')
    date_end: str | None = Field(default=None, alias='dateEnd')
    status: Literal[
        'Open',
        'Rejected',
        'PendingApproval',
        'ErrorsCorrected',
        'PendingProjectApproval',
        'ApprovedByTierOne',
        'RejectBySecondTier',
        'ApprovedByTierTwo',
        'ReadyToBill',
        'Billed',
        'WrittenOff',
        'BilledAgreement',
    ] | None = None
    total: float | None = None
    due_date: str | None = Field(default=None, alias='dueDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseReportAudit(TimeEntryAudit):
    pass


class ExpenseTax(ConnectWiseModel):
    id: int | None = None
    amount: float | None = None
    type: ExpenseTaxTypeReference | None = None


class ExpenseTypeExemption(ConnectWiseModel):
    id: int | None = None
    expense_type: ExpenseTypeReference = Field(..., alias='expenseType')
    taxable_levels: list[int] | None = Field(default=None, alias='taxableLevels')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ForecastItem(ConnectWiseModel):
    id: int | None = None
    forecast_description: str | None = Field(default=None, alias='forecastDescription')
    """
     Max length: 50;
    """
    opportunity: OpportunityReference | None = None
    quantity: float | None = None
    status: OpportunityStatusReference | None = None
    catalog_item: IvItemReference | None = Field(default=None, alias='catalogItem')
    product_description: str | None = Field(default=None, alias='productDescription')
    product_class: str | None = Field(default=None, alias='productClass')
    revenue: float | None = None
    cost: float | None = None
    margin: float | None = None
    percentage: int | None = None
    include_flag: bool | None = Field(default=None, alias='includeFlag')
    quote_werks_doc_no: str | None = Field(default=None, alias='quoteWerksDocNo')
    """
     Max length: 20;
    """
    quote_werks_doc_name: str | None = Field(default=None, alias='quoteWerksDocName')
    """
     Max length: 255;
    """
    quote_werks_quantity: int | None = Field(default=None, alias='quoteWerksQuantity')
    forecast_type: Literal[
        'Other1', 'Other2', 'Agreement', 'Product', 'Service'
    ] = Field(..., alias='forecastType')
    link_flag: bool | None = Field(default=None, alias='linkFlag')
    recurring_revenue: float | None = Field(default=None, alias='recurringRevenue')
    recurring_cost: float | None = Field(default=None, alias='recurringCost')
    recurring_date_start: datetime | None = Field(
        default=None, alias='recurringDateStart'
    )
    recurring_date_end: datetime | None = Field(default=None, alias='recurringDateEnd')
    bill_cycle: BillingCycleReference | None = Field(default=None, alias='billCycle')
    cycle_basis: str | None = Field(default=None, alias='cycleBasis')
    cycles: int | None = None
    recurring_flag: bool | None = Field(default=None, alias='recurringFlag')
    sequence_number: float | None = Field(default=None, alias='sequenceNumber')
    sub_number: int | None = Field(default=None, alias='subNumber')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GLAccount(ConnectWiseModel):
    id: int | None = None
    gl_type: Literal[
        'AP',
        'AR',
        'EE',
        'EI',
        'EO',
        'IA',
        'IT',
        'P',
        'PF',
        'R',
        'RA',
        'RD',
        'RE',
        'RP',
        'ST',
        'SD',
        'ET',
        'FT',
        'PT',
        'WP',
        'WR',
    ] = Field(..., alias='glType')
    mapped_type: MappedTypeReference = Field(..., alias='mappedType')
    mapped_record: MappedRecordReference = Field(..., alias='mappedRecord')
    segment1: str | None = None
    """
     Max length: 255;
    """
    segment2: str | None = None
    """
     Max length: 255;
    """
    segment3: str | None = None
    """
     Max length: 255;
    """
    segment4: str | None = None
    """
     Max length: 255;
    """
    segment5: str | None = None
    """
     Max length: 255;
    """
    segment6: str | None = None
    """
     Max length: 255;
    """
    segment7: str | None = None
    """
     Max length: 255;
    """
    segment8: str | None = None
    """
     Max length: 255;
    """
    segment9: str | None = None
    """
     Max length: 255;
    """
    segment10: str | None = None
    """
     Max length: 255;
    """
    cogs1: str | None = None
    """
     Max length: 255;
    """
    cogs2: str | None = None
    """
     Max length: 255;
    """
    cogs3: str | None = None
    """
     Max length: 255;
    """
    cogs4: str | None = None
    """
     Max length: 255;
    """
    cogs5: str | None = None
    """
     Max length: 255;
    """
    cogs6: str | None = None
    """
     Max length: 255;
    """
    cogs7: str | None = None
    """
     Max length: 255;
    """
    cogs8: str | None = None
    """
     Max length: 255;
    """
    cogs9: str | None = None
    """
     Max length: 255;
    """
    cogs10: str | None = None
    """
     Max length: 255;
    """
    product_id: str | None = Field(default=None, alias='productId')
    """
     Max length: 255;
    """
    inventory: str | None = None
    """
     Max length: 255;
    """
    sales_code: str | None = Field(default=None, alias='salesCode')
    """
     Max length: 255;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GLExportAdjustmentTransactionDetail(ConnectWiseModel):
    gl_class: str | None = Field(default=None, alias='glClass')
    description: str | None = None
    memo: str | None = None
    item: IvItemReference | None = None
    quantity: int | None = None
    total: float | None = None
    cost: float | None = None
    cost_account_number: str | None = Field(default=None, alias='costAccountNumber')
    inventory_account_number: str | None = Field(
        default=None, alias='inventoryAccountNumber'
    )
    account_number: str | None = Field(default=None, alias='accountNumber')
    product_account_number: str | None = Field(
        default=None, alias='productAccountNumber'
    )


class GLExportCustomer(ConnectWiseModel):
    company: CompanyReference | None = None
    company_type: CompanyTypeReference | None = Field(default=None, alias='companyType')
    contact: ContactReference | None = None
    site: SiteReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    billing_terms_xref: str | None = Field(default=None, alias='billingTermsXref')
    due_days: int | None = Field(default=None, alias='dueDays')
    taxable: bool | None = None
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    currency: CurrencyReference | None = None
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    city_tax_xref: str | None = Field(default=None, alias='cityTaxXref')
    country_tax_xref: str | None = Field(default=None, alias='countryTaxXref')
    composite_tax_xref: str | None = Field(default=None, alias='compositeTaxXref')
    state_tax_rate: float | None = Field(default=None, alias='stateTaxRate')
    county_tax_rate: float | None = Field(default=None, alias='countyTaxRate')
    city_tax_rate: float | None = Field(default=None, alias='cityTaxRate')
    country_tax_rate: float | None = Field(default=None, alias='countryTaxRate')
    composite_tax_rate: float | None = Field(default=None, alias='compositeTaxRate')
    tax_group_rate: float | None = Field(default=None, alias='taxGroupRate')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')
    state_tax_agency_xref: str | None = Field(default=None, alias='stateTaxAgencyXref')
    county_tax_agency_xref: str | None = Field(
        default=None, alias='countyTaxAgencyXref'
    )
    city_tax_agency_xref: str | None = Field(default=None, alias='cityTaxAgencyXref')
    country_tax_agency_xref: str | None = Field(
        default=None, alias='countryTaxAgencyXref'
    )
    composite_tax_agency_xref: str | None = Field(
        default=None, alias='compositeTaxAgencyXref'
    )
    tax_levels: list[GLExportCustomerTaxLevel] | None = Field(
        default=None, alias='taxLevels'
    )


class GLExportExpenseBill(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    document_type: str | None = Field(default=None, alias='documentType')
    document_number: str | None = Field(default=None, alias='documentNumber')
    memo: str | None = None
    gl_class: str | None = Field(default=None, alias='glClass')
    ap_account_number: str | None = Field(default=None, alias='apAccountNumber')
    member: MemberReference | None = None
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    currency: CurrencyReference | None = None
    total: float | None = None
    detail: list[GLExportExpenseBillDetail] | None = None


class GLExportExpenseOffset(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    document_type: str | None = Field(default=None, alias='documentType')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    gl_class: str | None = Field(default=None, alias='glClass')
    member: MemberReference | None = None
    memo: str | None = None
    description: str | None = None
    total: float | None = None


class GLExportInventoryTransfer(ConnectWiseModel):
    id: str | None = None
    document_type: str | None = Field(default=None, alias='documentType')
    document_date: str | None = Field(default=None, alias='documentDate')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_class: str | None = Field(default=None, alias='glClass')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    description: str | None = None
    sales_code: str | None = Field(default=None, alias='salesCode')
    memo: str | None = None
    cost_account_number: str | None = Field(default=None, alias='costAccountNumber')
    inventory_account_number: str | None = Field(
        default=None, alias='inventoryAccountNumber'
    )
    transfer_id: int | None = Field(default=None, alias='transferId')
    item: IvItemReference | None = None
    gl_item_id: str | None = Field(default=None, alias='glItemId')
    sales_description: str | None = Field(default=None, alias='salesDescription')
    item_description: str | None = Field(default=None, alias='itemDescription')
    currency: CurrencyReference | None = None
    item_price: float | None = Field(default=None, alias='itemPrice')
    taxable: bool | None = None
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    quantity: float | None = None
    cost: float | None = None
    total: float | None = None
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    serial_numbers: str | None = Field(default=None, alias='serialNumbers')
    bin: WarehouseBinReference | None = None
    warehouse: WarehouseReference | None = None
    transfer_from_bin: WarehouseBinReference | None = Field(
        default=None, alias='transferFromBin'
    )
    transfer_from_location_xref: str | None = Field(
        default=None, alias='transferFromLocationXref'
    )
    transfer_to_bin: WarehouseBinReference | None = Field(
        default=None, alias='transferToBin'
    )
    transfer_to_location_xref: str | None = Field(
        default=None, alias='transferToLocationXref'
    )
    location_xref: str | None = Field(default=None, alias='locationXref')
    price_level_xref: str | None = Field(default=None, alias='priceLevelXref')
    uom_schedule_xref: str | None = Field(default=None, alias='uomScheduleXref')
    item_type_xref: str | None = Field(default=None, alias='itemTypeXref')
    inventory_xref: str | None = Field(default=None, alias='inventoryXref')
    cogs_xref: str | None = Field(default=None, alias='cogsXref')
    tax_note: str | None = Field(default=None, alias='taxNote')
    offset: GLExportInventoryTransferOffset | None = None


class GLExportPurchaseTransactionDetail(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    gl_class: str | None = Field(default=None, alias='glClass')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    gl_item_id: str | None = Field(default=None, alias='glItemId')
    sales_code: str | None = Field(default=None, alias='salesCode')
    description: str | None = None
    cost: float | None = None
    memo: str | None = None
    tax_note: str | None = Field(default=None, alias='taxNote')
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    account_number: str | None = Field(default=None, alias='accountNumber')
    cost_account_number: str | None = Field(default=None, alias='costAccountNumber')
    inventory_account_number: str | None = Field(
        default=None, alias='inventoryAccountNumber'
    )
    vendor_account_number: str | None = Field(default=None, alias='vendorAccountNumber')
    item: IvItemReference | None = None
    item_description: str | None = Field(default=None, alias='itemDescription')
    sales_description: str | None = Field(default=None, alias='salesDescription')
    taxable: bool | None = None
    item_price: float | None = Field(default=None, alias='itemPrice')
    item_cost: float | None = Field(default=None, alias='itemCost')
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    quantity: float | None = None
    total: float | None = None
    currency: CurrencyReference | None = None
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    serial_numbers: str | None = Field(default=None, alias='serialNumbers')
    drop_shipped_flag: bool | None = Field(default=None, alias='dropShippedFlag')
    line_number: int | None = Field(default=None, alias='lineNumber')
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    warehouse_site: SiteReference | None = Field(default=None, alias='warehouseSite')
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    item_type_xref: str | None = Field(default=None, alias='itemTypeXref')
    inventory_xref: str | None = Field(default=None, alias='inventoryXref')
    cogs_xref: str | None = Field(default=None, alias='cogsXref')
    uom_schedule_xref: str | None = Field(default=None, alias='uomScheduleXref')
    price_level_xref: str | None = Field(default=None, alias='priceLevelXref')
    location_xref: str | None = Field(default=None, alias='locationXref')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    purchase_header_tax_group: str | None = Field(
        default=None, alias='purchaseHeaderTaxGroup'
    )
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    tax_rate: float | None = Field(default=None, alias='taxRate')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')


class GLExportPurchaseTransactionDetailTax(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_class: str | None = Field(default=None, alias='glClass')
    cost: float | None = None
    sales_code: str | None = Field(default=None, alias='salesCode')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    gl_item_id: str | None = Field(default=None, alias='glItemId')
    memo: str | None = None
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    vendor_account_number: str | None = Field(default=None, alias='vendorAccountNumber')
    cost_account_number: str | None = Field(default=None, alias='costAccountNumber')
    inventory_account_number: str | None = Field(
        default=None, alias='inventoryAccountNumber'
    )
    item_type_xref: str | None = Field(default=None, alias='itemTypeXref')
    inventory_xref: str | None = Field(default=None, alias='inventoryXref')
    cogs_xref: str | None = Field(default=None, alias='cogsXref')
    uom_schedule_xref: str | None = Field(default=None, alias='uomScheduleXref')
    price_level_xref: str | None = Field(default=None, alias='priceLevelXref')
    location_xref: str | None = Field(default=None, alias='locationXref')
    item: IvItemReference | None = None
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    sales_description: str | None = Field(default=None, alias='salesDescription')
    item_description: str | None = Field(default=None, alias='itemDescription')
    item_price: float | None = Field(default=None, alias='itemPrice')
    item_cost: float | None = Field(default=None, alias='itemCost')
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    quantity: float | None = None
    total: float | None = None
    currency: CurrencyReference | None = None
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    serial_numbers: str | None = Field(default=None, alias='serialNumbers')
    drop_shipped_flag: bool | None = Field(default=None, alias='dropShippedFlag')
    line_number: int | None = Field(default=None, alias='lineNumber')
    warehouse_site: SiteReference | None = Field(default=None, alias='warehouseSite')
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    tax_rate: float | None = Field(default=None, alias='taxRate')
    tax_rate_percent: float | None = Field(default=None, alias='taxRatePercent')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')
    tax_note: str | None = Field(default=None, alias='taxNote')
    purchase_header_tax_group: str | None = Field(
        default=None, alias='purchaseHeaderTaxGroup'
    )


class GLExportTransactionDetail(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    document_type: str | None = Field(default=None, alias='documentType')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_class: str | None = Field(default=None, alias='glClass')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    gl_item_id: str | None = Field(default=None, alias='glItemId')
    invoice_summary_option: str | None = Field(
        default=None, alias='invoiceSummaryOption'
    )
    cost: float | None = None
    sales_code: str | None = Field(default=None, alias='salesCode')
    memo: str | None = None
    description: str | None = None
    quantity: float | None = None
    total: float | None = None
    currency: CurrencyReference | None = None
    time_entry: TimeEntryReference | None = Field(default=None, alias='timeEntry')
    cost_account_number: str | None = Field(default=None, alias='costAccountNumber')
    inventory_account_number: str | None = Field(
        default=None, alias='inventoryAccountNumber'
    )
    product_account_number: str | None = Field(
        default=None, alias='productAccountNumber'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    tax_code_xref: str | None = Field(default=None, alias='taxCodeXref')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')
    tax_note: str | None = Field(default=None, alias='taxNote')
    tax_rate: float | None = Field(default=None, alias='taxRate')
    tax_rate_percent: float | None = Field(default=None, alias='taxRatePercent')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    taxable2_flag: bool | None = Field(default=None, alias='taxable2Flag')
    taxable3_flag: bool | None = Field(default=None, alias='taxable3Flag')
    taxable4_flag: bool | None = Field(default=None, alias='taxable4Flag')
    taxable5_flag: bool | None = Field(default=None, alias='taxable5Flag')
    item: IvItemReference | None = None
    product: ProductReference | None = None
    item_taxable_flag: bool | None = Field(default=None, alias='itemTaxableFlag')
    item_price: float | None = Field(default=None, alias='itemPrice')
    item_cost: float | None = Field(default=None, alias='itemCost')
    item_description: str | None = Field(default=None, alias='itemDescription')
    sales_description: str | None = Field(default=None, alias='salesDescription')
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    serialized_flag: bool | None = Field(default=None, alias='serializedFlag')
    serial_numbers: str | None = Field(default=None, alias='serialNumbers')
    warehouse_site: SiteReference | None = Field(default=None, alias='warehouseSite')
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    drop_shipped_flag: bool | None = Field(default=None, alias='dropShippedFlag')
    item_type_xref: str | None = Field(default=None, alias='itemTypeXref')
    inventory_xref: str | None = Field(default=None, alias='inventoryXref')
    cogs_xref: str | None = Field(default=None, alias='cogsXref')
    uom_schedule_xref: str | None = Field(default=None, alias='uomScheduleXref')
    price_level_xref: str | None = Field(default=None, alias='priceLevelXref')
    location_xref: str | None = Field(default=None, alias='locationXref')
    tax_levels: list[GLExportTransactionDetailTaxLevel] | None = Field(
        default=None, alias='taxLevels'
    )


class GLExportVendor(ConnectWiseModel):
    member: MemberReference | None = None
    vendor: CompanyReference | None = None
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    account_number: str | None = Field(default=None, alias='accountNumber')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    due_days: int | None = Field(default=None, alias='dueDays')
    site: SiteReference | None = None
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')


class GLPath(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    path: str | None = None
    """
     Max length: 255;
    """
    sql_server_name: str | None = Field(default=None, alias='sqlServerName')
    """
     Max length: 255;
    """
    database_name: str | None = Field(default=None, alias='databaseName')
    """
     Max length: 100;
    """
    last_payment_sync: datetime | None = Field(default=None, alias='lastPaymentSync')
    last_payment_sync_by: MemberReference | None = Field(
        default=None, alias='lastPaymentSyncBy'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GraphUserCsv(ConnectWiseModel):
    id: str | None = None
    display_name: str | None = Field(default=None, alias='displayName')
    principal_name: str | None = Field(default=None, alias='principalName')
    country: str | None = None
    state: str | None = None
    city: str | None = None
    department: str | None = None
    first_name: str | None = Field(default=None, alias='firstName')
    last_name: str | None = Field(default=None, alias='lastName')
    address: str | None = None
    postal_code: str | None = Field(default=None, alias='postalCode')
    mail: str | None = None
    is_matched_contact: bool | None = Field(default=None, alias='isMatchedContact')
    account_enabled: bool | None = Field(default=None, alias='accountEnabled')
    manage_contact_rec_id: int | None = Field(default=None, alias='manageContactRecId')
    manage_contact_name: str | None = Field(default=None, alias='manageContactName')
    job_title: str | None = Field(default=None, alias='jobTitle')
    proxy_addresses: list[str] | None = Field(default=None, alias='proxyAddresses')
    nick_name: str | None = Field(default=None, alias='nickName')
    manager: Manager | None = None
    employee_type: str | None = Field(default=None, alias='employeeType')


class Holiday(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    all_day_flag: bool | None = Field(default=None, alias='allDayFlag')
    """
    Can be set to false to set a holiday for specific hours (Defaults to True).
    """
    date: date
    time_start: str | None = Field(default=None, alias='timeStart')
    time_end: str | None = Field(default=None, alias='timeEnd')
    holiday_list: HolidayListReference | None = Field(default=None, alias='holidayList')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class HolidayInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    all_day_flag: bool | None = Field(default=None, alias='allDayFlag')
    """
    Can be set to false to set a holiday for specific hours (Defaults to True).
    """
    date: str | None = None
    time_start: str | None = Field(default=None, alias='timeStart')
    time_end: str | None = Field(default=None, alias='timeEnd')
    holiday_list: HolidayListReference | None = Field(default=None, alias='holidayList')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Info(ConnectWiseModel):
    version: str | None = None
    is_cloud: bool | None = Field(default=None, alias='isCloud')
    server_time_zone: str | None = Field(default=None, alias='serverTimeZone')
    license_bits: list[LicenseBit] | None = Field(default=None, alias='licenseBits')
    cloud_region: str | None = Field(default=None, alias='cloudRegion')


class InOutBoard(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    in_out_type: InOutTypeReference | None = Field(default=None, alias='inOutType')
    additional_info: str | None = Field(default=None, alias='additionalInfo')
    """
     Max length: 100;
    """
    date_back: datetime = Field(..., alias='dateBack')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class IntegratorLogin(ConnectWiseModel):
    id: int | None = None
    username: str
    """
     Max length: 50;
    """
    password: str | None = None
    """
    The password will never be returned in response. Max length: 50;
    """
    can_access_all_records_flag: bool | None = Field(
        default=None, alias='canAccessAllRecordsFlag'
    )
    """
    This flag controls whether the integrator can access only the db records it created, or all system records.
    """
    can_access_all_apis_flag: bool | None = Field(
        default=None, alias='canAccessAllApisFlag'
    )
    """
    Setting this flag to true will create an integrator that can access all of the available apis in the system.
                If this field is set to true, both the member and board fields are required.
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    date_inactivated: datetime | None = Field(default=None, alias='dateInactivated')
    inactivated_by: MemberReference | None = Field(default=None, alias='inactivatedBy')
    service_ticket_api_flag: bool | None = Field(
        default=None, alias='serviceTicketApiFlag'
    )
    board: BoardReference | None = None
    service_board_callback_url: str | None = Field(
        default=None, alias='serviceBoardCallbackUrl'
    )
    """
     Max length: 1000;
    """
    service_board_legacy_callback_flag: bool | None = Field(
        default=None, alias='serviceBoardLegacyCallbackFlag'
    )
    time_entry_api_flag: bool | None = Field(default=None, alias='timeEntryApiFlag')
    member: MemberReference | None = None
    time_entry_callback_url: str | None = Field(
        default=None, alias='timeEntryCallbackUrl'
    )
    """
     Max length: 1000;
    """
    time_entry_legacy_callback_flag: bool | None = Field(
        default=None, alias='timeEntryLegacyCallbackFlag'
    )
    managed_services_api_flag: bool | None = Field(
        default=None, alias='managedServicesApiFlag'
    )
    managed_services_auto_child_flag: bool | None = Field(
        default=None, alias='managedServicesAutoChildFlag'
    )
    managed_services_childing_flag: bool | None = Field(
        default=None, alias='managedServicesChildingFlag'
    )
    """
    True if integrator is allowed to child configurations.
    """
    contact_api_flag: bool | None = Field(default=None, alias='contactApiFlag')
    contact_callback_url: str | None = Field(default=None, alias='contactCallbackUrl')
    """
     Max length: 1000;
    """
    contact_legacy_callback_flag: bool | None = Field(
        default=None, alias='contactLegacyCallbackFlag'
    )
    company_api_flag: bool | None = Field(default=None, alias='companyApiFlag')
    company_callback_url: str | None = Field(default=None, alias='companyCallbackUrl')
    """
     Max length: 1000;
    """
    company_legacy_callback_flag: bool | None = Field(
        default=None, alias='companyLegacyCallbackFlag'
    )
    activity_api_flag: bool | None = Field(default=None, alias='activityApiFlag')
    activity_callback_url: str | None = Field(default=None, alias='activityCallbackUrl')
    """
     Max length: 1000;
    """
    activity_legacy_callback_flag: bool | None = Field(
        default=None, alias='activityLegacyCallbackFlag'
    )
    invoice_api_flag: bool | None = Field(default=None, alias='invoiceApiFlag')
    product_api_flag: bool | None = Field(default=None, alias='productApiFlag')
    product_callback_url: str | None = Field(default=None, alias='productCallbackUrl')
    """
     Max length: 1000;
    """
    product_legacy_callback_flag: bool | None = Field(
        default=None, alias='productLegacyCallbackFlag'
    )
    opportunity_api_flag: bool | None = Field(default=None, alias='opportunityApiFlag')
    opportunity_callback_url: str | None = Field(
        default=None, alias='opportunityCallbackUrl'
    )
    """
     Max length: 1000;
    """
    opportunity_legacy_callback_flag: bool | None = Field(
        default=None, alias='opportunityLegacyCallbackFlag'
    )
    opportunity_conversion_api_flag: bool | None = Field(
        default=None, alias='opportunityConversionApiFlag'
    )
    """
    True if the member has access to the Opportunity Conversion Api.
    """
    member_api_flag: bool | None = Field(default=None, alias='memberApiFlag')
    marketing_api_flag: bool | None = Field(default=None, alias='marketingApiFlag')
    purchasing_api_flag: bool | None = Field(default=None, alias='purchasingApiFlag')
    purchasing_callback_url: str | None = Field(
        default=None, alias='purchasingCallbackUrl'
    )
    """
     Max length: 1000;
    """
    purchasing_legacy_callback_flag: bool | None = Field(
        default=None, alias='purchasingLegacyCallbackFlag'
    )
    reporting_api_flag: bool | None = Field(default=None, alias='reportingApiFlag')
    system_api_flag: bool | None = Field(default=None, alias='systemApiFlag')
    project_api_flag: bool | None = Field(default=None, alias='projectApiFlag')
    project_callback_url: str | None = Field(default=None, alias='projectCallbackUrl')
    """
     Max length: 1000;
    """
    project_legacy_callback_flag: bool | None = Field(
        default=None, alias='projectLegacyCallbackFlag'
    )
    configuration_api_flag: bool | None = Field(
        default=None, alias='configurationApiFlag'
    )
    configuration_auto_child_flag: bool | None = Field(
        default=None, alias='configurationAutoChildFlag'
    )
    configuration_childling_flag: bool | None = Field(
        default=None, alias='configurationChildlingFlag'
    )
    """
    True if integrator is allowed to child configurations.
    """
    configuration_callback_url: str | None = Field(
        default=None, alias='configurationCallbackUrl'
    )
    """
     Max length: 1000;
    """
    configuration_legacy_callback_flag: bool | None = Field(
        default=None, alias='configurationLegacyCallbackFlag'
    )
    schedule_api_flag: bool | None = Field(default=None, alias='scheduleApiFlag')
    schedule_callback_url: str | None = Field(default=None, alias='scheduleCallbackUrl')
    """
     Max length: 1000;
    """
    schedule_legacy_callback_flag: bool | None = Field(
        default=None, alias='scheduleLegacyCallbackFlag'
    )
    agreement_api_flag: bool | None = Field(default=None, alias='agreementApiFlag')
    agreement_callback_url: str | None = Field(
        default=None, alias='agreementCallbackUrl'
    )
    """
     Max length: 1000;
    """
    agreement_callback_legacy_flag: bool | None = Field(
        default=None, alias='agreementCallbackLegacyFlag'
    )
    document_api_flag: bool | None = Field(default=None, alias='documentApiFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InventoryOnHand(CatalogInventory):
    pass


class Invoice(ConnectWiseModel):
    id: int | None = None
    invoice_number: str | None = Field(default=None, alias='invoiceNumber')
    """
     Max length: 15; Required On Updates;
    """
    type: Literal[
        'Agreement',
        'CreditMemo',
        'DownPayment',
        'Miscellaneous',
        'Progress',
        'Standard',
    ]
    status: BillingStatusReference | None = None
    company: CompanyReference | None = None
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    account_number: str | None = Field(default=None, alias='accountNumber')
    apply_to_type: Literal[
        'All', 'Agreement', 'Project', 'ProjectPhase', 'SalesOrder', 'Ticket'
    ] | None = Field(default=None, alias='applyToType')
    apply_to_id: int | None = Field(default=None, alias='applyToId')
    attention: str | None = None
    """
     Max length: 60;
    """
    ship_to_attention: str | None = Field(default=None, alias='shipToAttention')
    """
     Max length: 60;
    """
    billing_site: SiteReference | None = Field(default=None, alias='billingSite')
    billing_site_address_line1: str | None = Field(
        default=None, alias='billingSiteAddressLine1'
    )
    billing_site_address_line2: str | None = Field(
        default=None, alias='billingSiteAddressLine2'
    )
    billing_site_city: str | None = Field(default=None, alias='billingSiteCity')
    billing_site_state: str | None = Field(default=None, alias='billingSiteState')
    billing_site_zip: str | None = Field(default=None, alias='billingSiteZip')
    billing_site_country: str | None = Field(default=None, alias='billingSiteCountry')
    shipping_site: SiteReference | None = Field(default=None, alias='shippingSite')
    shipping_site_address_line1: str | None = Field(
        default=None, alias='shippingSiteAddressLine1'
    )
    shipping_site_address_line2: str | None = Field(
        default=None, alias='shippingSiteAddressLine2'
    )
    shipping_site_city: str | None = Field(default=None, alias='shippingSiteCity')
    shipping_site_state: str | None = Field(default=None, alias='shippingSiteState')
    shipping_site_zip: str | None = Field(default=None, alias='shippingSiteZip')
    shipping_site_country: str | None = Field(default=None, alias='shippingSiteCountry')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    reference: str | None = None
    """
     Max length: 50;
    """
    customer_po: str | None = Field(default=None, alias='customerPO')
    """
     Max length: 50;
    """
    template_setup_id: int | None = Field(default=None, alias='templateSetupId')
    """
    Can be obtained via InvoiceTemplate report.
    """
    invoice_template: InvoiceTemplateDetailReference | None = Field(
        default=None, alias='invoiceTemplate'
    )
    email_template_id: int | None = Field(default=None, alias='emailTemplateId')
    """
    Can be obtained via InvoiceEmailTemplate report.
    """
    add_to_batch_email_list: bool | None = Field(
        default=None, alias='addToBatchEmailList'
    )
    date: datetime | None = None
    restrict_downpayment_flag: bool | None = Field(
        default=None, alias='restrictDownpaymentFlag'
    )
    location_id: int | None = Field(default=None, alias='locationId')
    """
     Required On Updates;
    """
    department_id: int | None = Field(default=None, alias='departmentId')
    """
    departmentId is only required for special invoices.
    """
    territory_id: int | None = Field(default=None, alias='territoryId')
    top_comment: str | None = Field(default=None, alias='topComment')
    bottom_comment: str | None = Field(default=None, alias='bottomComment')
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    downpayment_previously_taxed_flag: bool | None = Field(
        default=None, alias='downpaymentPreviouslyTaxedFlag'
    )
    service_total: float | None = Field(default=None, alias='serviceTotal')
    override_down_payment_amount_flag: bool | None = Field(
        default=None, alias='overrideDownPaymentAmountFlag'
    )
    currency: CurrencyReference | None = None
    due_date: datetime | None = Field(default=None, alias='dueDate')
    expense_total: float | None = Field(default=None, alias='expenseTotal')
    product_total: float | None = Field(default=None, alias='productTotal')
    previous_progress_applied: float | None = Field(
        default=None, alias='previousProgressApplied'
    )
    service_adjustment_amount: float | None = Field(
        default=None, alias='serviceAdjustmentAmount'
    )
    agreement_amount: float | None = Field(default=None, alias='agreementAmount')
    downpayment_applied: float | None = Field(default=None, alias='downpaymentApplied')
    subtotal: float | None = None
    total: float | None = None
    remaining_downpayment: float | None = Field(
        default=None, alias='remainingDownpayment'
    )
    sales_tax: float | None = Field(default=None, alias='salesTax')
    adjustment_reason: str | None = Field(default=None, alias='adjustmentReason')
    adjusted_by: str | None = Field(default=None, alias='adjustedBy')
    payments: float | None = None
    credits: float | None = None
    balance: float | None = None
    special_invoice_flag: bool | None = Field(default=None, alias='specialInvoiceFlag')
    billing_setup_reference: BillingSetupReference | None = Field(
        default=None, alias='billingSetupReference'
    )
    ticket: TicketReference | None = None
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    sales_order: SalesOrderReference | None = Field(default=None, alias='salesOrder')
    agreement: AgreementReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class InvoiceEmailTemplate(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    service_survey: ServiceSurveyReference | None = Field(
        default=None, alias='serviceSurvey'
    )
    use_sender_flag: bool | None = Field(default=None, alias='useSenderFlag')
    first_name: str | None = Field(default=None, alias='firstName')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    last_name: str | None = Field(default=None, alias='lastName')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    subject: str
    """
     Max length: 200;
    """
    body: str | None = None
    copy_sender_flag: bool | None = Field(default=None, alias='copySenderFlag')
    invoice_status: BillingStatusReference | None = Field(
        default=None, alias='invoiceStatus'
    )
    attach_invoice_flag: bool | None = Field(default=None, alias='attachInvoiceFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class InvoicePayment(ConnectWiseModel):
    id: int | None = None
    type: str | None = None
    source: Literal['Default', 'WisePay'] | None = None
    invoice: InvoiceReference | None = None
    credit: InvoiceReference | None = None
    amount: float | None = None
    payment_date: datetime | None = Field(default=None, alias='paymentDate')
    applied_by: str | None = Field(default=None, alias='appliedBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    wise_pay_payment: WisePayPayment | None = Field(
        default=None, alias='wisePayPayment'
    )
    payment_sync_status: str | None = Field(default=None, alias='paymentSyncStatus')
    payment_sync_date: str | None = Field(default=None, alias='paymentSyncDate')
    payment_account: str | None = Field(default=None, alias='paymentAccount')
    a_r_payment_account: str | None = Field(default=None, alias='aRPaymentAccount')


class KnowledgeBaseCategory(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    approver: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class KnowledgeBaseSettings(ConnectWiseModel):
    id: int | None = None
    require_approval: bool = Field(..., alias='requireApproval')
    default_approver: MemberReference | None = Field(
        default=None, alias='defaultApprover'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class KnowledgeBaseSubCategory(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    category: KBCategoryReference
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class KPI(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    category: KPICategoryReference | None = None
    date_filter: str | None = Field(default=None, alias='dateFilter')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')


class Location(ConnectWiseModel):
    id: int | None = None
    owner_level_id: int | None = Field(default=None, alias='ownerLevelId')
    structure_level: CorporateStructureLevelReference | None = Field(
        default=None, alias='structureLevel'
    )
    name: str
    """
     Max length: 50;
    """
    manager: MemberReference | None = None
    reports_to: SystemLocationReference | None = Field(default=None, alias='reportsTo')
    sales_rep: str | None = Field(default=None, alias='salesRep')
    """
     Max length: 50;
    """
    time_zone_setup: TimeZoneSetupReference | None = Field(
        default=None, alias='timeZoneSetup'
    )
    calendar: CalendarReference | None = None
    override_address_line1: str | None = Field(
        default=None, alias='overrideAddressLine1'
    )
    """
     Max length: 50;
    """
    override_address_line2: str | None = Field(
        default=None, alias='overrideAddressLine2'
    )
    """
     Max length: 50;
    """
    override_city: str | None = Field(default=None, alias='overrideCity')
    """
     Max length: 50;
    """
    override_state: str | None = Field(default=None, alias='overrideState')
    """
     Max length: 50;
    """
    override_zip: str | None = Field(default=None, alias='overrideZip')
    """
     Max length: 12;
    """
    override_country: CountryReference | None = Field(
        default=None, alias='overrideCountry'
    )
    override_phone_number: str | None = Field(default=None, alias='overridePhoneNumber')
    """
     Max length: 15;
    """
    override_fax_number: str | None = Field(default=None, alias='overrideFaxNumber')
    """
     Max length: 15;
    """
    owa_url: str | None = Field(default=None, alias='owaUrl')
    """
     Max length: 100;
    """
    payroll_xref: str | None = Field(default=None, alias='payrollXref')
    """
     Max length: 10;
    """
    location_flag: bool | None = Field(default=None, alias='locationFlag')
    client_flag: bool | None = Field(default=None, alias='clientFlag')
    work_role_ids: list[int] | None = Field(default=None, alias='workRoleIds')
    department_ids: list[int] | None = Field(default=None, alias='departmentIds')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class LocationDepartment(DepartmentLocationInfo):
    pass


class LocationWorkRole(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_role_inactive_flag: bool | None = Field(
        default=None, alias='workRoleInactiveFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class M365ContactSyncCompany(ConnectWiseModel):
    id: int | None = None
    company_rec_id: int | None = Field(default=None, alias='companyRecId')
    tenant_id: str | None = Field(default=None, alias='tenantId')
    parent_tenant_id: str | None = Field(default=None, alias='parentTenantId')
    m365_tenant: M365Tenant | None = Field(default=None, alias='m365Tenant')
    display_name: str | None = Field(default=None, alias='displayName')
    sync_flag: bool | None = Field(default=None, alias='syncFlag')
    company_id: str | None = Field(default=None, alias='companyId')
    contacts: list[GraphUserCsv] | None = None
    inactive_flag_tenant: bool | None = Field(default=None, alias='inactiveFlagTenant')
    are_all_microsoft365_contact_sync_inactive: bool | None = Field(
        default=None, alias='areAllMicrosoft365ContactSyncInactive'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDeviceAccount(ConnectWiseModel):
    id: int | None = None
    username: str | None = None
    password: str | None = None
    managed_devices_integration: ManagedDevicesIntegrationReference | None = Field(
        default=None, alias='managedDevicesIntegration'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDevicesIntegration(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    solution: str
    """
     Max length: 30;
    """
    portal_url: str | None = Field(default=None, alias='portalUrl')
    """
     Max length: 200;
    """
    login_by: Literal['Global', 'Member'] = Field(..., alias='loginBy')
    global_login_username: str | None = Field(default=None, alias='globalLoginUsername')
    """
    Gets or sets
                this is only required when globalLoginFlag = true. Max length: 50;
    """
    global_login_password: str | None = Field(default=None, alias='globalLoginPassword')
    """
    Gets or sets
                this is only required when globalLoginFlag = true. Max length: 50;
    """
    default_billing_level: Literal['Detail', 'Summary'] = Field(
        ..., alias='defaultBillingLevel'
    )
    management_it_setup_type: str | None = Field(
        default=None, alias='managementItSetupType'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    integrator_login: IntegratorLoginReference | None = Field(
        default=None, alias='integratorLogin'
    )
    match_on_serial_number_flag: bool | None = Field(
        default=None, alias='matchOnSerialNumberFlag'
    )
    disable_new_cross_references_flag: bool | None = Field(
        default=None, alias='disableNewCrossReferencesFlag'
    )
    config_bill_customer_flag: bool | None = Field(
        default=None, alias='configBillCustomerFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDevicesIntegrationCrossReference(ConnectWiseModel):
    id: int | None = None
    managed_devices_integration: ManagedDevicesIntegrationReference | None = Field(
        default=None, alias='managedDevicesIntegration'
    )
    vendor_type: str | None = Field(default=None, alias='vendorType')
    """
     Max length: 255;
    """
    vendor_level: str | None = Field(default=None, alias='vendorLevel')
    """
     Max length: 255;
    """
    agreement_type: AgreementTypeReference | None = Field(
        default=None, alias='agreementType'
    )
    product: IvItemReference | None = None
    configuration_type: ConfigurationTypeReference | None = Field(
        default=None, alias='configurationType'
    )
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDevicesIntegrationLogin(ConnectWiseModel):
    id: int | None = None
    managed_devices_integration: ManagedDevicesIntegrationReference | None = Field(
        default=None, alias='managedDevicesIntegration'
    )
    username: str
    """
     Max length: 50;
    """
    password: str | None = None
    """
     Max length: 50;
    """
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagedDevicesIntegrationNotification(ConnectWiseModel):
    id: int | None = None
    managed_devices_integration: ManagedDevicesIntegrationReference | None = Field(
        default=None, alias='managedDevicesIntegration'
    )
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    member: MemberReference | None = None
    log_type: Literal[
        'All',
        'Error',
        'NewManagedSolution',
        'NewDeviceType',
        'NewConfiguration',
        'NewAddition',
        'Info',
    ] = Field(..., alias='logType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ManagementReportNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    member: MemberReference | None = None
    email: str | None = None
    """
     Max length: 50;
    """
    global_flag: bool | None = Field(default=None, alias='globalFlag')
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Member(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 15;
    """
    password: str | None = None
    """
    ConditionallyRequired. API Member will get random password generated Max length: 60;
    """
    disable_online_flag: bool | None = Field(default=None, alias='disableOnlineFlag')
    license_class: Literal['A', 'C', 'F', 'X'] = Field(..., alias='licenseClass')
    """
    F = Full Member, A = API Member, C = StreamlineIT Member, X = Subcontractor Member
    """
    notes: str | None = None
    employee_identifer: str | None = Field(default=None, alias='employeeIdentifer')
    """
     Max length: 10;
    """
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    enable_mobile_gps_flag: bool | None = Field(
        default=None, alias='enableMobileGpsFlag'
    )
    inactive_date: datetime | None = Field(default=None, alias='inactiveDate')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    last_login: str | None = Field(default=None, alias='lastLogin')
    client_id: str | None = Field(default=None, alias='clientId')
    token: str | None = None
    first_name: str = Field(..., alias='firstName')
    """
     Max length: 30;
    """
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    """
     Max length: 1;
    """
    last_name: str = Field(..., alias='lastName')
    """
     Max length: 30;
    """
    hire_date: datetime = Field(..., alias='hireDate')
    country: CountryReference | None = None
    photo: DocumentReference | None = None
    office_email: str | None = Field(default=None, alias='officeEmail')
    """
     Max length: 250;
    """
    mobile_email: str | None = Field(default=None, alias='mobileEmail')
    """
     Max length: 250;
    """
    home_email: str | None = Field(default=None, alias='homeEmail')
    """
     Max length: 250;
    """
    default_email: Literal['Office', 'Mobile', 'Home'] = Field(
        ..., alias='defaultEmail'
    )
    primary_email: str | None = Field(default=None, alias='primaryEmail')
    """
     Max length: 250;
    """
    office_phone: str | None = Field(default=None, alias='officePhone')
    """
     Max length: 15;
    """
    office_extension: str | None = Field(default=None, alias='officeExtension')
    """
     Max length: 10;
    """
    mobile_phone: str | None = Field(default=None, alias='mobilePhone')
    """
     Max length: 15;
    """
    mobile_extension: str | None = Field(default=None, alias='mobileExtension')
    """
     Max length: 10;
    """
    home_phone: str | None = Field(default=None, alias='homePhone')
    """
     Max length: 15;
    """
    home_extension: str | None = Field(default=None, alias='homeExtension')
    """
     Max length: 10;
    """
    default_phone: Literal['Office', 'Mobile', 'Home'] = Field(
        ..., alias='defaultPhone'
    )
    security_role: SecurityRoleReference | None = Field(
        default=None, alias='securityRole'
    )
    office365: MemberOffice365 | None = None
    mapi_name: str | None = Field(default=None, alias='mapiName')
    calendar_sync_integration_flag: bool | None = Field(
        default=None, alias='calendarSyncIntegrationFlag'
    )
    authentication_service_type: Literal[
        'AuthAnvil', 'GoogleAuthenticator', 'Email'
    ] | None = Field(default=None, alias='authenticationServiceType')
    timebased_one_time_password_activated: bool | None = Field(
        default=None, alias='timebasedOneTimePasswordActivated'
    )
    enable_ldap_authentication_flag: bool | None = Field(
        default=None, alias='enableLdapAuthenticationFlag'
    )
    ldap_configuration: LdapConfigurationReference | None = Field(
        default=None, alias='ldapConfiguration'
    )
    ldap_user_name: str | None = Field(default=None, alias='ldapUserName')
    """
     Max length: 50;
    """
    directional_sync: DirectionalSyncReference | None = Field(
        default=None, alias='directionalSync'
    )
    sso_settings: MemberSsoSettingsReference | None = Field(
        default=None, alias='ssoSettings'
    )
    signature: str | None = None
    phone_integration_type: Literal[
        'TAPI', 'SKYPE', 'TEL', 'CALLTO', 'NONE'
    ] | None = Field(default=None, alias='phoneIntegrationType')
    use_browser_language_flag: bool | None = Field(
        default=None, alias='useBrowserLanguageFlag'
    )
    title: str | None = None
    report_card: ReportCardReference | None = Field(default=None, alias='reportCard')
    enable_mobile_flag: bool | None = Field(default=None, alias='enableMobileFlag')
    type: MemberTypeReference | None = None
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    partner_portal_flag: bool | None = Field(default=None, alias='partnerPortalFlag')
    sts_user_admin_url: str | None = Field(default=None, alias='stsUserAdminUrl')
    toast_notification_flag: bool | None = Field(
        default=None, alias='toastNotificationFlag'
    )
    member_personas: list[int] | None = Field(default=None, alias='memberPersonas')
    admin_flag: bool | None = Field(default=None, alias='adminFlag')
    structure_level: StructureReference | None = Field(
        default=None, alias='structureLevel'
    )
    security_location: SystemLocationReference | None = Field(
        default=None, alias='securityLocation'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    reports_to: MemberReference | None = Field(default=None, alias='reportsTo')
    restrict_location_flag: bool | None = Field(
        default=None, alias='restrictLocationFlag'
    )
    restrict_department_flag: bool | None = Field(
        default=None, alias='restrictDepartmentFlag'
    )
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    time_approver: MemberReference | None = Field(default=None, alias='timeApprover')
    expense_approver: MemberReference | None = Field(
        default=None, alias='expenseApprover'
    )
    billable_forecast: float | None = Field(default=None, alias='billableForecast')
    daily_capacity: float | None = Field(default=None, alias='dailyCapacity')
    hourly_cost: float | None = Field(default=None, alias='hourlyCost')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    include_in_utilization_reporting_flag: bool | None = Field(
        default=None, alias='includeInUtilizationReportingFlag'
    )
    require_expense_entry_flag: bool | None = Field(
        default=None, alias='requireExpenseEntryFlag'
    )
    require_time_sheet_entry_flag: bool | None = Field(
        default=None, alias='requireTimeSheetEntryFlag'
    )
    require_start_and_end_time_on_time_entry_flag: bool | None = Field(
        default=None, alias='requireStartAndEndTimeOnTimeEntryFlag'
    )
    allow_in_cell_entry_on_time_sheet: bool | None = Field(
        default=None, alias='allowInCellEntryOnTimeSheet'
    )
    enter_time_against_company_flag: bool | None = Field(
        default=None, alias='enterTimeAgainstCompanyFlag'
    )
    allow_expenses_entered_against_companies_flag: bool | None = Field(
        default=None, alias='allowExpensesEnteredAgainstCompaniesFlag'
    )
    time_reminder_email_flag: bool | None = Field(
        default=None, alias='timeReminderEmailFlag'
    )
    days_tolerance: int | None = Field(default=None, alias='daysTolerance')
    minimum_hours: float | None = Field(default=None, alias='minimumHours')
    time_sheet_start_date: str | None = Field(default=None, alias='timeSheetStartDate')
    service_default_location: SystemLocationReference | None = Field(
        default=None, alias='serviceDefaultLocation'
    )
    service_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='serviceDefaultDepartment'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    restrict_service_default_location_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultLocationFlag'
    )
    restrict_service_default_department_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultDepartmentFlag'
    )
    excluded_service_board_ids: list[int] | None = Field(
        default=None, alias='excludedServiceBoardIds'
    )
    teams: list[int] | None = None
    service_board_team_ids: list[int] | None = Field(
        default=None, alias='serviceBoardTeamIds'
    )
    project_default_location: SystemLocationReference | None = Field(
        default=None, alias='projectDefaultLocation'
    )
    project_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='projectDefaultDepartment'
    )
    project_default_board: ProjectBoardReference | None = Field(
        default=None, alias='projectDefaultBoard'
    )
    restrict_project_default_location_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultLocationFlag'
    )
    restrict_project_default_department_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultDepartmentFlag'
    )
    excluded_project_board_ids: list[int] | None = Field(
        default=None, alias='excludedProjectBoardIds'
    )
    schedule_default_location: SystemLocationReference | None = Field(
        default=None, alias='scheduleDefaultLocation'
    )
    schedule_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='scheduleDefaultDepartment'
    )
    schedule_capacity: float | None = Field(default=None, alias='scheduleCapacity')
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    restrict_schedule_flag: bool | None = Field(
        default=None, alias='restrictScheduleFlag'
    )
    hide_member_in_dispatch_portal_flag: bool | None = Field(
        default=None, alias='hideMemberInDispatchPortalFlag'
    )
    calendar: CalendarReference | None = None
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    restrict_default_sales_territory_flag: bool | None = Field(
        default=None, alias='restrictDefaultSalesTerritoryFlag'
    )
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    restrict_default_warehouse_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseFlag'
    )
    restrict_default_warehouse_bin_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseBinFlag'
    )
    company_activity_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='companyActivityTabFormat'
    )
    invoice_time_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='invoiceTimeTabFormat'
    )
    invoice_screen_default_tab_format: Literal[
        'ShowInvoicingTab', 'ShowAgreementInvoicingTab'
    ] | None = Field(default=None, alias='invoiceScreenDefaultTabFormat')
    invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='invoicingDisplayOptions')
    agreement_invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='agreementInvoicingDisplayOptions')
    auto_start_stopwatch: bool | None = Field(default=None, alias='autoStartStopwatch')
    auto_popup_quick_notes_with_stopwatch: bool | None = Field(
        default=None, alias='autoPopupQuickNotesWithStopwatch'
    )
    global_search_default_ticket_filter: Literal[
        'OpenRecords', 'ClosedRecords', 'AllRecords'
    ] | None = Field(default=None, alias='globalSearchDefaultTicketFilter')
    global_search_default_sort: Literal[
        'None', 'LastUpdatedDesc', 'LastUpdatedAsc', 'CreatedDesc', 'CreatedAsc'
    ] | None = Field(default=None, alias='globalSearchDefaultSort')
    phone_source: str | None = Field(default=None, alias='phoneSource')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    copy_pod_layouts: bool | None = Field(default=None, alias='copyPodLayouts')
    copy_shared_default_views: bool | None = Field(
        default=None, alias='copySharedDefaultViews'
    )
    copy_column_layouts_and_filters: bool | None = Field(
        default=None, alias='copyColumnLayoutsAndFilters'
    )
    from_member_rec_id: int | None = Field(default=None, alias='fromMemberRecId')
    from_member_template_rec_id: int | None = Field(
        default=None, alias='fromMemberTemplateRecId'
    )
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class MemberAccrual(ConnectWiseModel):
    id: int | None = None
    accrual_type: Literal['Holiday', 'PTO', 'Sick', 'Vacation'] = Field(
        ..., alias='accrualType'
    )
    year: int
    hours: float
    reason: str
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberCertification(ConnectWiseModel):
    id: int | None = None
    certification: CertificationReference
    percent_complete: int | None = Field(default=None, alias='percentComplete')
    date_received: datetime | None = Field(default=None, alias='dateReceived')
    date_expires: datetime | None = Field(default=None, alias='dateExpires')
    certification_number: str | None = Field(default=None, alias='certificationNumber')
    """
     Max length: 50;
    """
    notes: str | None = None
    member: MemberReference | None = None
    company: CompanyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberDeactivationCompanyTeam(ConnectWiseModel):
    count: int | None = None
    id: int | None = None
    name: str | None = None
    re_assign_to_member: MemberReference | None = Field(
        default=None, alias='reAssignToMember'
    )
    re_assign_to_contact: ContactReference | None = Field(
        default=None, alias='reAssignToContact'
    )


class MemberDeactivationDepartmentMananager(ConnectWiseModel):
    count: int | None = None
    re_assign_to_member: MemberReference | None = Field(
        default=None, alias='reAssignToMember'
    )


class MemberDeactivationDispatchMember(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationDutyManager(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationKnowledgebaseArticle(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyControllerRole(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyCOORole(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyDispatchRole(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyDutyManagerRole(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyPresidentRole(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationMyCompanyServiceManagerRole(
    MemberDeactivationDepartmentMananager
):
    pass


class MemberDeactivationOpportunity(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationProjectManager(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationSalesActivity(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationSalesTeam(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationSendFromEmailNotify(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationServiceManger(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationServiceTeam(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationServiceTemplate(MemberDeactivationDepartmentMananager):
    pass


class MemberDeactivationStatusWorkflow(ConnectWiseModel):
    count: int | None = None
    id: int | None = None
    name: str | None = None
    re_assign_to_member: MemberReference | None = Field(
        default=None, alias='reAssignToMember'
    )


class MemberDeactivationWorkflow(MemberDeactivationDepartmentMananager):
    pass


class MemberDelegation(ConnectWiseModel):
    id: int | None = None
    delegation_type: Literal['Approval', 'Project'] = Field(..., alias='delegationType')
    delegated_to: MemberReference | None = Field(default=None, alias='delegatedTo')
    date_start: datetime = Field(..., alias='dateStart')
    date_end: datetime = Field(..., alias='dateEnd')
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberPersona(ConnectWiseModel):
    id: int | None = None
    job_role_percentage: int | None = Field(default=None, alias='jobRolePercentage')
    name: str | None = None
    persona_id: int = Field(..., alias='personaId')
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberSkill(ConnectWiseModel):
    id: int | None = None
    skill: SkillReference
    skill_level: Literal['Beginner', 'Intermediate', 'Advanced', 'Expert'] = Field(
        ..., alias='skillLevel'
    )
    certified_flag: bool | None = Field(default=None, alias='certifiedFlag')
    years_experience: int | None = Field(default=None, alias='yearsExperience')
    notes: str | None = None
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberTemplate(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 50;
    """
    template_description: str | None = Field(default=None, alias='templateDescription')
    """
     Max length: 1024;
    """
    title: str | None = None
    report_card: ReportCardReference | None = Field(default=None, alias='reportCard')
    enable_mobile_flag: bool | None = Field(default=None, alias='enableMobileFlag')
    type: MemberTypeReference | None = None
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    partner_portal_flag: bool | None = Field(default=None, alias='partnerPortalFlag')
    sts_user_admin_url: str | None = Field(default=None, alias='stsUserAdminUrl')
    toast_notification_flag: bool | None = Field(
        default=None, alias='toastNotificationFlag'
    )
    member_personas: list[int] | None = Field(default=None, alias='memberPersonas')
    admin_flag: bool | None = Field(default=None, alias='adminFlag')
    structure_level: StructureReference | None = Field(
        default=None, alias='structureLevel'
    )
    security_location: SystemLocationReference | None = Field(
        default=None, alias='securityLocation'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    reports_to: MemberReference | None = Field(default=None, alias='reportsTo')
    restrict_location_flag: bool | None = Field(
        default=None, alias='restrictLocationFlag'
    )
    restrict_department_flag: bool | None = Field(
        default=None, alias='restrictDepartmentFlag'
    )
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    time_approver: MemberReference | None = Field(default=None, alias='timeApprover')
    expense_approver: MemberReference | None = Field(
        default=None, alias='expenseApprover'
    )
    billable_forecast: float | None = Field(default=None, alias='billableForecast')
    daily_capacity: float | None = Field(default=None, alias='dailyCapacity')
    hourly_cost: float | None = Field(default=None, alias='hourlyCost')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    include_in_utilization_reporting_flag: bool | None = Field(
        default=None, alias='includeInUtilizationReportingFlag'
    )
    require_expense_entry_flag: bool | None = Field(
        default=None, alias='requireExpenseEntryFlag'
    )
    require_time_sheet_entry_flag: bool | None = Field(
        default=None, alias='requireTimeSheetEntryFlag'
    )
    require_start_and_end_time_on_time_entry_flag: bool | None = Field(
        default=None, alias='requireStartAndEndTimeOnTimeEntryFlag'
    )
    allow_in_cell_entry_on_time_sheet: bool | None = Field(
        default=None, alias='allowInCellEntryOnTimeSheet'
    )
    enter_time_against_company_flag: bool | None = Field(
        default=None, alias='enterTimeAgainstCompanyFlag'
    )
    allow_expenses_entered_against_companies_flag: bool | None = Field(
        default=None, alias='allowExpensesEnteredAgainstCompaniesFlag'
    )
    time_reminder_email_flag: bool | None = Field(
        default=None, alias='timeReminderEmailFlag'
    )
    days_tolerance: int | None = Field(default=None, alias='daysTolerance')
    minimum_hours: float | None = Field(default=None, alias='minimumHours')
    time_sheet_start_date: str | None = Field(default=None, alias='timeSheetStartDate')
    service_default_location: SystemLocationReference | None = Field(
        default=None, alias='serviceDefaultLocation'
    )
    service_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='serviceDefaultDepartment'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    restrict_service_default_location_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultLocationFlag'
    )
    restrict_service_default_department_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultDepartmentFlag'
    )
    excluded_service_board_ids: list[int] | None = Field(
        default=None, alias='excludedServiceBoardIds'
    )
    teams: list[int] | None = None
    service_board_team_ids: list[int] | None = Field(
        default=None, alias='serviceBoardTeamIds'
    )
    project_default_location: SystemLocationReference | None = Field(
        default=None, alias='projectDefaultLocation'
    )
    project_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='projectDefaultDepartment'
    )
    project_default_board: ProjectBoardReference | None = Field(
        default=None, alias='projectDefaultBoard'
    )
    restrict_project_default_location_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultLocationFlag'
    )
    restrict_project_default_department_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultDepartmentFlag'
    )
    excluded_project_board_ids: list[int] | None = Field(
        default=None, alias='excludedProjectBoardIds'
    )
    schedule_default_location: SystemLocationReference | None = Field(
        default=None, alias='scheduleDefaultLocation'
    )
    schedule_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='scheduleDefaultDepartment'
    )
    schedule_capacity: float | None = Field(default=None, alias='scheduleCapacity')
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    restrict_schedule_flag: bool | None = Field(
        default=None, alias='restrictScheduleFlag'
    )
    hide_member_in_dispatch_portal_flag: bool | None = Field(
        default=None, alias='hideMemberInDispatchPortalFlag'
    )
    calendar: CalendarReference | None = None
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    restrict_default_sales_territory_flag: bool | None = Field(
        default=None, alias='restrictDefaultSalesTerritoryFlag'
    )
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    restrict_default_warehouse_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseFlag'
    )
    restrict_default_warehouse_bin_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseBinFlag'
    )
    company_activity_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='companyActivityTabFormat'
    )
    invoice_time_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='invoiceTimeTabFormat'
    )
    invoice_screen_default_tab_format: Literal[
        'ShowInvoicingTab', 'ShowAgreementInvoicingTab'
    ] | None = Field(default=None, alias='invoiceScreenDefaultTabFormat')
    invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='invoicingDisplayOptions')
    agreement_invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='agreementInvoicingDisplayOptions')
    auto_start_stopwatch: bool | None = Field(default=None, alias='autoStartStopwatch')
    auto_popup_quick_notes_with_stopwatch: bool | None = Field(
        default=None, alias='autoPopupQuickNotesWithStopwatch'
    )
    global_search_default_ticket_filter: Literal[
        'OpenRecords', 'ClosedRecords', 'AllRecords'
    ] | None = Field(default=None, alias='globalSearchDefaultTicketFilter')
    global_search_default_sort: Literal[
        'None', 'LastUpdatedDesc', 'LastUpdatedAsc', 'CreatedDesc', 'CreatedAsc'
    ] | None = Field(default=None, alias='globalSearchDefaultSort')
    phone_source: str | None = Field(default=None, alias='phoneSource')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    copy_pod_layouts: bool | None = Field(default=None, alias='copyPodLayouts')
    copy_shared_default_views: bool | None = Field(
        default=None, alias='copySharedDefaultViews'
    )
    copy_column_layouts_and_filters: bool | None = Field(
        default=None, alias='copyColumnLayoutsAndFilters'
    )
    from_member_rec_id: int | None = Field(default=None, alias='fromMemberRecId')
    from_member_template_rec_id: int | None = Field(
        default=None, alias='fromMemberTemplateRecId'
    )
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class MenuEntry(ConnectWiseModel):
    id: int | None = None
    menu_location: MenuLocationReference | None = Field(
        default=None, alias='menuLocation'
    )
    caption: str
    """
     Max length: 50;
    """
    link: str
    """
     Max length: 2000;
    """
    new_window_flag: bool = Field(..., alias='newWindowFlag')
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    origin: str | None = None
    """
     Max length: 2000;
    """
    client_id: str | None = Field(default=None, alias='clientId')
    """
    Only required if not already set Max length: 36;
    """
    add_all_locations: bool | None = Field(default=None, alias='addAllLocations')
    remove_all_locations: bool | None = Field(default=None, alias='removeAllLocations')
    small_menu_icon_id: int | None = Field(default=None, alias='smallMenuIconId')
    large_menu_icon_id: int | None = Field(default=None, alias='largeMenuIconId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MenuEntryLocation(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    menu_entry: SystemMenuEntryReference | None = Field(default=None, alias='menuEntry')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MinimumStockByWarehouse(ConnectWiseModel):
    id: int | None = None
    warehouse: WarehouseReference
    minimum_stock: int = Field(..., alias='minimumStock')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MyAccount(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 15;
    """
    password: str | None = None
    """
    ConditionallyRequired. API Member will get random password generated Max length: 60;
    """
    first_name: str = Field(..., alias='firstName')
    """
     Max length: 30;
    """
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    """
     Max length: 1;
    """
    last_name: str = Field(..., alias='lastName')
    """
     Max length: 30;
    """
    title: str | None = None
    """
     Max length: 50;
    """
    report_card: ReportCardReference | None = Field(default=None, alias='reportCard')
    license_class: Literal['A', 'C', 'F', 'X'] = Field(..., alias='licenseClass')
    """
    F = Full Member, A = API Member, C = StreamlineIT Member, X = Subcontractor Member
    """
    disable_online_flag: bool | None = Field(default=None, alias='disableOnlineFlag')
    enable_mobile_flag: bool | None = Field(default=None, alias='enableMobileFlag')
    type: MemberTypeReference | None = None
    employee_identifer: str | None = Field(default=None, alias='employeeIdentifer')
    """
     Max length: 10;
    """
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    notes: str | None = None
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    country: CountryReference | None = None
    service_board_team_ids: list[int] | None = Field(
        default=None, alias='serviceBoardTeamIds'
    )
    enable_mobile_gps_flag: bool | None = Field(
        default=None, alias='enableMobileGpsFlag'
    )
    inactive_date: datetime | None = Field(default=None, alias='inactiveDate')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    last_login: str | None = Field(default=None, alias='lastLogin')
    photo: DocumentReference | None = None
    partner_portal_flag: bool | None = Field(default=None, alias='partnerPortalFlag')
    client_id: str | None = Field(default=None, alias='clientId')
    sts_user_admin_url: str | None = Field(default=None, alias='stsUserAdminUrl')
    token: str | None = None
    toast_notification_flag: bool | None = Field(
        default=None, alias='toastNotificationFlag'
    )
    member_personas: list[int] | None = Field(default=None, alias='memberPersonas')
    office365: MemberOffice365 | None = None
    office_email: str | None = Field(default=None, alias='officeEmail')
    """
     Max length: 250;
    """
    office_phone: str | None = Field(default=None, alias='officePhone')
    """
     Max length: 15;
    """
    office_extension: str | None = Field(default=None, alias='officeExtension')
    """
     Max length: 10;
    """
    mobile_email: str | None = Field(default=None, alias='mobileEmail')
    """
     Max length: 250;
    """
    mobile_phone: str | None = Field(default=None, alias='mobilePhone')
    """
     Max length: 15;
    """
    mobile_extension: str | None = Field(default=None, alias='mobileExtension')
    """
     Max length: 10;
    """
    home_email: str | None = Field(default=None, alias='homeEmail')
    """
     Max length: 250;
    """
    home_phone: str | None = Field(default=None, alias='homePhone')
    """
     Max length: 15;
    """
    home_extension: str | None = Field(default=None, alias='homeExtension')
    """
     Max length: 10;
    """
    default_email: Literal['Office', 'Mobile', 'Home'] = Field(
        ..., alias='defaultEmail'
    )
    primary_email: str | None = Field(default=None, alias='primaryEmail')
    """
     Max length: 250;
    """
    default_phone: Literal['Office', 'Mobile', 'Home'] = Field(
        ..., alias='defaultPhone'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    reports_to: MemberReference | None = Field(default=None, alias='reportsTo')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    time_approver: MemberReference | None = Field(default=None, alias='timeApprover')
    expense_approver: MemberReference | None = Field(
        default=None, alias='expenseApprover'
    )
    billable_forecast: float | None = Field(default=None, alias='billableForecast')
    daily_capacity: float | None = Field(default=None, alias='dailyCapacity')
    include_in_utilization_reporting_flag: bool | None = Field(
        default=None, alias='includeInUtilizationReportingFlag'
    )
    require_expense_entry_flag: bool | None = Field(
        default=None, alias='requireExpenseEntryFlag'
    )
    require_time_sheet_entry_flag: bool | None = Field(
        default=None, alias='requireTimeSheetEntryFlag'
    )
    require_start_and_end_time_on_time_entry_flag: bool | None = Field(
        default=None, alias='requireStartAndEndTimeOnTimeEntryFlag'
    )
    allow_in_cell_entry_on_time_sheet: bool | None = Field(
        default=None, alias='allowInCellEntryOnTimeSheet'
    )
    enter_time_against_company_flag: bool | None = Field(
        default=None, alias='enterTimeAgainstCompanyFlag'
    )
    allow_expenses_entered_against_companies_flag: bool | None = Field(
        default=None, alias='allowExpensesEnteredAgainstCompaniesFlag'
    )
    time_reminder_email_flag: bool | None = Field(
        default=None, alias='timeReminderEmailFlag'
    )
    days_tolerance: int | None = Field(default=None, alias='daysTolerance')
    minimum_hours: float | None = Field(default=None, alias='minimumHours')
    time_sheet_start_date: datetime | None = Field(
        default=None, alias='timeSheetStartDate'
    )
    hire_date: datetime = Field(..., alias='hireDate')
    service_default_location: SystemLocationReference | None = Field(
        default=None, alias='serviceDefaultLocation'
    )
    service_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='serviceDefaultDepartment'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    project_default_location: SystemLocationReference | None = Field(
        default=None, alias='projectDefaultLocation'
    )
    project_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='projectDefaultDepartment'
    )
    project_default_board: ProjectBoardReference | None = Field(
        default=None, alias='projectDefaultBoard'
    )
    schedule_default_location: SystemLocationReference | None = Field(
        default=None, alias='scheduleDefaultLocation'
    )
    schedule_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='scheduleDefaultDepartment'
    )
    schedule_capacity: float | None = Field(default=None, alias='scheduleCapacity')
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    hide_member_in_dispatch_portal_flag: bool | None = Field(
        default=None, alias='hideMemberInDispatchPortalFlag'
    )
    calendar: CalendarReference | None = None
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    mapi_name: str | None = Field(default=None, alias='mapiName')
    calendar_sync_integration_flag: bool | None = Field(
        default=None, alias='calendarSyncIntegrationFlag'
    )
    company_activity_tab_format: Literal['SummaryList', 'DetailList'] = Field(
        ..., alias='companyActivityTabFormat'
    )
    invoice_time_tab_format: Literal['SummaryList', 'DetailList'] = Field(
        ..., alias='invoiceTimeTabFormat'
    )
    invoice_screen_default_tab_format: Literal[
        'ShowInvoicingTab', 'ShowAgreementInvoicingTab'
    ] = Field(..., alias='invoiceScreenDefaultTabFormat')
    invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] = Field(..., alias='invoicingDisplayOptions')
    agreement_invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] = Field(..., alias='agreementInvoicingDisplayOptions')
    authentication_service_type: Literal[
        'AuthAnvil', 'GoogleAuthenticator', 'Email'
    ] | None = Field(default=None, alias='authenticationServiceType')
    timebased_one_time_password_activated: bool | None = Field(
        default=None, alias='timebasedOneTimePasswordActivated'
    )
    directional_sync: DirectionalSyncReference | None = Field(
        default=None, alias='directionalSync'
    )
    auto_start_stopwatch: bool | None = Field(default=None, alias='autoStartStopwatch')
    auto_popup_quick_notes_with_stopwatch: bool | None = Field(
        default=None, alias='autoPopupQuickNotesWithStopwatch'
    )
    signature: str | None = None
    global_search_default_ticket_filter: Literal[
        'OpenRecords', 'ClosedRecords', 'AllRecords'
    ] | None = Field(default=None, alias='globalSearchDefaultTicketFilter')
    global_search_default_sort: Literal[
        'None', 'LastUpdatedDesc', 'LastUpdatedAsc', 'CreatedDesc', 'CreatedAsc'
    ] | None = Field(default=None, alias='globalSearchDefaultSort')
    phone_source: str | None = Field(default=None, alias='phoneSource')
    phone_integration_type: Literal[
        'TAPI', 'SKYPE', 'TEL', 'CALLTO', 'NONE'
    ] | None = Field(default=None, alias='phoneIntegrationType')
    use_browser_language_flag: bool | None = Field(
        default=None, alias='useBrowserLanguageFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    copy_pod_layouts: bool | None = Field(default=None, alias='copyPodLayouts')
    copy_shared_default_views: bool | None = Field(
        default=None, alias='copySharedDefaultViews'
    )
    copy_column_layouts_and_filters: bool | None = Field(
        default=None, alias='copyColumnLayoutsAndFilters'
    )
    from_member_rec_id: int | None = Field(default=None, alias='fromMemberRecId')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class MyMember(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    password: str | None = None
    """
    ConditionallyRequired. API Member will get random password generated
    """
    first_name: str | None = Field(default=None, alias='firstName')
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    last_name: str | None = Field(default=None, alias='lastName')
    title: str | None = None
    report_card: ReportCardReference | None = Field(default=None, alias='reportCard')
    license_class: Literal['A', 'C', 'F', 'X'] | None = Field(
        default=None, alias='licenseClass'
    )
    """
    F = Full Member, A = API Member, C = StreamlineIT Member, X = Subcontractor Member
    """
    disable_online_flag: bool | None = Field(default=None, alias='disableOnlineFlag')
    enable_mobile_flag: bool | None = Field(default=None, alias='enableMobileFlag')
    type: MemberTypeReference | None = None
    employee_identifer: str | None = Field(default=None, alias='employeeIdentifer')
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    notes: str | None = None
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    country: CountryReference | None = None
    service_board_team_ids: list[int] | None = Field(
        default=None, alias='serviceBoardTeamIds'
    )
    enable_mobile_gps_flag: bool | None = Field(
        default=None, alias='enableMobileGpsFlag'
    )
    inactive_date: str | None = Field(default=None, alias='inactiveDate')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    last_login: str | None = Field(default=None, alias='lastLogin')
    photo: DocumentReference | None = None
    toast_notification_flag: bool | None = Field(
        default=None, alias='toastNotificationFlag'
    )
    office_email: str | None = Field(default=None, alias='officeEmail')
    office_phone: str | None = Field(default=None, alias='officePhone')
    office_extension: str | None = Field(default=None, alias='officeExtension')
    mobile_email: str | None = Field(default=None, alias='mobileEmail')
    mobile_phone: str | None = Field(default=None, alias='mobilePhone')
    mobile_extension: str | None = Field(default=None, alias='mobileExtension')
    home_email: str | None = Field(default=None, alias='homeEmail')
    home_phone: str | None = Field(default=None, alias='homePhone')
    home_extension: str | None = Field(default=None, alias='homeExtension')
    default_email: Literal['Office', 'Mobile', 'Home'] | None = Field(
        default=None, alias='defaultEmail'
    )
    default_phone: Literal['Office', 'Mobile', 'Home'] | None = Field(
        default=None, alias='defaultPhone'
    )
    security_role: SecurityRoleReference | None = Field(
        default=None, alias='securityRole'
    )
    admin_flag: bool | None = Field(default=None, alias='adminFlag')
    structure_level: StructureReference | None = Field(
        default=None, alias='structureLevel'
    )
    security_location: SystemLocationReference | None = Field(
        default=None, alias='securityLocation'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    reports_to: MemberReference | None = Field(default=None, alias='reportsTo')
    restrict_location_flag: bool | None = Field(
        default=None, alias='restrictLocationFlag'
    )
    restrict_department_flag: bool | None = Field(
        default=None, alias='restrictDepartmentFlag'
    )
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    time_approver: MemberReference | None = Field(default=None, alias='timeApprover')
    expense_approver: MemberReference | None = Field(
        default=None, alias='expenseApprover'
    )
    billable_forecast: float | None = Field(default=None, alias='billableForecast')
    daily_capacity: float | None = Field(default=None, alias='dailyCapacity')
    hourly_cost: float | None = Field(default=None, alias='hourlyCost')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    include_in_utilization_reporting_flag: bool | None = Field(
        default=None, alias='includeInUtilizationReportingFlag'
    )
    require_expense_entry_flag: bool | None = Field(
        default=None, alias='requireExpenseEntryFlag'
    )
    require_time_sheet_entry_flag: bool | None = Field(
        default=None, alias='requireTimeSheetEntryFlag'
    )
    require_start_and_end_time_on_time_entry_flag: bool | None = Field(
        default=None, alias='requireStartAndEndTimeOnTimeEntryFlag'
    )
    allow_in_cell_entry_on_time_sheet: bool | None = Field(
        default=None, alias='allowInCellEntryOnTimeSheet'
    )
    enter_time_against_company_flag: bool | None = Field(
        default=None, alias='enterTimeAgainstCompanyFlag'
    )
    allow_expenses_entered_against_companies_flag: bool | None = Field(
        default=None, alias='allowExpensesEnteredAgainstCompaniesFlag'
    )
    time_reminder_email_flag: bool | None = Field(
        default=None, alias='timeReminderEmailFlag'
    )
    days_tolerance: int | None = Field(default=None, alias='daysTolerance')
    minimum_hours: float | None = Field(default=None, alias='minimumHours')
    time_sheet_start_date: str | None = Field(default=None, alias='timeSheetStartDate')
    hire_date: str | None = Field(default=None, alias='hireDate')
    service_default_location: SystemLocationReference | None = Field(
        default=None, alias='serviceDefaultLocation'
    )
    service_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='serviceDefaultDepartment'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    restrict_service_default_location_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultLocationFlag'
    )
    restrict_service_default_department_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultDepartmentFlag'
    )
    excluded_service_board_ids: list[int] | None = Field(
        default=None, alias='excludedServiceBoardIds'
    )
    project_default_location: SystemLocationReference | None = Field(
        default=None, alias='projectDefaultLocation'
    )
    project_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='projectDefaultDepartment'
    )
    project_default_board: ProjectBoardReference | None = Field(
        default=None, alias='projectDefaultBoard'
    )
    restrict_project_default_location_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultLocationFlag'
    )
    restrict_project_default_department_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultDepartmentFlag'
    )
    excluded_project_board_ids: list[int] | None = Field(
        default=None, alias='excludedProjectBoardIds'
    )
    schedule_default_location: SystemLocationReference | None = Field(
        default=None, alias='scheduleDefaultLocation'
    )
    schedule_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='scheduleDefaultDepartment'
    )
    schedule_capacity: float | None = Field(default=None, alias='scheduleCapacity')
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    restrict_schedule_flag: bool | None = Field(
        default=None, alias='restrictScheduleFlag'
    )
    hide_member_in_dispatch_portal_flag: bool | None = Field(
        default=None, alias='hideMemberInDispatchPortalFlag'
    )
    calendar: CalendarReference | None = None
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    restrict_default_sales_territory_flag: bool | None = Field(
        default=None, alias='restrictDefaultSalesTerritoryFlag'
    )
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    restrict_default_warehouse_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseFlag'
    )
    restrict_default_warehouse_bin_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseBinFlag'
    )
    mapi_name: str | None = Field(default=None, alias='mapiName')
    calendar_sync_integration_flag: bool | None = Field(
        default=None, alias='calendarSyncIntegrationFlag'
    )
    enable_ldap_authentication_flag: bool | None = Field(
        default=None, alias='enableLdapAuthenticationFlag'
    )
    ldap_configuration: LdapConfigurationReference | None = Field(
        default=None, alias='ldapConfiguration'
    )
    ldap_user_name: str | None = Field(default=None, alias='ldapUserName')
    company_activity_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='companyActivityTabFormat'
    )
    invoice_time_tab_format: Literal['SummaryList', 'DetailList'] | None = Field(
        default=None, alias='invoiceTimeTabFormat'
    )
    invoice_screen_default_tab_format: Literal[
        'ShowInvoicingTab', 'ShowAgreementInvoicingTab'
    ] | None = Field(default=None, alias='invoiceScreenDefaultTabFormat')
    invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='invoicingDisplayOptions')
    agreement_invoicing_display_options: Literal[
        'RemainOnInvoicingScreen', 'ShowRecentInvoices'
    ] | None = Field(default=None, alias='agreementInvoicingDisplayOptions')
    corelytics_username: str | None = Field(default=None, alias='corelyticsUsername')
    corelytics_password: str | None = Field(default=None, alias='corelyticsPassword')
    authentication_service_type: Literal[
        'AuthAnvil', 'GoogleAuthenticator', 'Email'
    ] | None = Field(default=None, alias='authenticationServiceType')
    timebased_one_time_password_activated: bool | None = Field(
        default=None, alias='timebasedOneTimePasswordActivated'
    )
    directional_sync: DirectionalSyncReference | None = Field(
        default=None, alias='directionalSync'
    )
    sso_session_flag: bool | None = Field(default=None, alias='ssoSessionFlag')
    sso_client_id: str | None = Field(default=None, alias='ssoClientId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MyMemberInfo(ConnectWiseModel):
    id: int | None = None
    identifier: str | None = None
    first_name: str | None = Field(default=None, alias='firstName')
    middle_initial: str | None = Field(default=None, alias='middleInitial')
    last_name: str | None = Field(default=None, alias='lastName')
    full_name: str | None = Field(default=None, alias='fullName')
    default_email: str | None = Field(default=None, alias='defaultEmail')
    photo: DocumentReference | None = None
    license_class: Literal['A', 'C', 'F', 'X'] | None = Field(
        default=None, alias='licenseClass'
    )
    """
    F = Full Member, A = API Member, C = StreamlineIT Member, X = Subcontractor Member
    """
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    time_zone: TimeZoneSetupReference | None = Field(default=None, alias='timeZone')
    use_browser_language_flag: bool | None = Field(
        default=None, alias='useBrowserLanguageFlag'
    )
    default_location: SystemLocationReference | None = Field(
        default=None, alias='defaultLocation'
    )
    default_department: SystemDepartmentReference | None = Field(
        default=None, alias='defaultDepartment'
    )
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    daily_capacity: float | None = Field(default=None, alias='dailyCapacity')
    require_expense_entry_flag: bool | None = Field(
        default=None, alias='requireExpenseEntryFlag'
    )
    require_time_sheet_entry_flag: bool | None = Field(
        default=None, alias='requireTimeSheetEntryFlag'
    )
    require_start_and_end_time_on_time_entry_flag: bool | None = Field(
        default=None, alias='requireStartAndEndTimeOnTimeEntryFlag'
    )
    enter_time_against_company_flag: bool | None = Field(
        default=None, alias='enterTimeAgainstCompanyFlag'
    )
    allow_expenses_entered_against_companies_flag: bool | None = Field(
        default=None, alias='allowExpensesEnteredAgainstCompaniesFlag'
    )
    service_default_board: BoardReference | None = Field(
        default=None, alias='serviceDefaultBoard'
    )
    service_default_location: SystemLocationReference | None = Field(
        default=None, alias='serviceDefaultLocation'
    )
    service_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='serviceDefaultDepartment'
    )
    restrict_service_default_location_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultLocationFlag'
    )
    restrict_service_default_department_flag: bool | None = Field(
        default=None, alias='restrictServiceDefaultDepartmentFlag'
    )
    excluded_service_board_ids: list[int] | None = Field(
        default=None, alias='excludedServiceBoardIds'
    )
    project_default_location: SystemLocationReference | None = Field(
        default=None, alias='projectDefaultLocation'
    )
    project_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='projectDefaultDepartment'
    )
    project_default_board: ProjectBoardReference | None = Field(
        default=None, alias='projectDefaultBoard'
    )
    restrict_project_default_location_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultLocationFlag'
    )
    restrict_project_default_department_flag: bool | None = Field(
        default=None, alias='restrictProjectDefaultDepartmentFlag'
    )
    excluded_project_board_ids: list[int] | None = Field(
        default=None, alias='excludedProjectBoardIds'
    )
    schedule_default_location: SystemLocationReference | None = Field(
        default=None, alias='scheduleDefaultLocation'
    )
    schedule_default_department: SystemDepartmentReference | None = Field(
        default=None, alias='scheduleDefaultDepartment'
    )
    schedule_capacity: float | None = Field(default=None, alias='scheduleCapacity')
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    sales_default_location: SystemLocationReference | None = Field(
        default=None, alias='salesDefaultLocation'
    )
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    restrict_default_warehouse_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseFlag'
    )
    restrict_default_warehouse_bin_flag: bool | None = Field(
        default=None, alias='restrictDefaultWarehouseBinFlag'
    )
    sso_session_flag: bool | None = Field(default=None, alias='ssoSessionFlag')
    sso_client_id: str | None = Field(default=None, alias='ssoClientId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OnHandSerialNumber(ConnectWiseModel):
    id: int | None = None
    serial: str | None = None
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Opportunity(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    expected_close_date: datetime | None = Field(
        default=None, alias='expectedCloseDate'
    )
    """
     Required On Updates;
    """
    type: OpportunityTypeReference | None = None
    stage: OpportunityStageReference | None = None
    status: OpportunityStatusReference | None = None
    priority: OpportunityPriorityReference | None = None
    notes: str | None = None
    probability: OpportunityProbabilityReference | None = None
    source: str | None = None
    """
     Max length: 50;
    """
    rating: OpportunityRatingReference | None = None
    campaign: CampaignReference | None = None
    primary_sales_rep: MemberReference | None = Field(
        default=None, alias='primarySalesRep'
    )
    secondary_sales_rep: MemberReference | None = Field(
        default=None, alias='secondarySalesRep'
    )
    location_id: int | None = Field(default=None, alias='locationId')
    """
     Required On Updates;
    """
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    """
     Required On Updates;
    """
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    site: SiteReference | None = None
    customer_po: str | None = Field(default=None, alias='customerPO')
    """
     Max length: 25;
    """
    pipeline_change_date: datetime | None = Field(
        default=None, alias='pipelineChangeDate'
    )
    date_became_lead: datetime | None = Field(default=None, alias='dateBecameLead')
    closed_date: datetime | None = Field(default=None, alias='closedDate')
    closed_by: MemberReference | None = Field(default=None, alias='closedBy')
    total_sales_tax: float | None = Field(default=None, alias='totalSalesTax')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    currency: CurrencyReference | None = None
    company_location_id: int | None = Field(default=None, alias='companyLocationId')
    technical_contact: ContactReference | None = Field(
        default=None, alias='technicalContact'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class OpportunityContact(ConnectWiseModel):
    id: int | None = None
    contact: ContactReference | None = None
    company: CompanyReference | None = None
    role: OpportunitySalesRoleReference | None = None
    notes: str | None = None
    referral_flag: bool | None = Field(default=None, alias='referralFlag')
    opportunity_id: int | None = Field(default=None, alias='opportunityId')
    phone_number: str | None = Field(default=None, alias='phoneNumber')
    email_address: str | None = Field(default=None, alias='emailAddress')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OpportunityToProjectConversion(ConnectWiseModel):
    project_id: int | None = Field(default=None, alias='projectId')
    name: str | None = None
    status: ProjectStatusReference | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    board: ProjectBoardReference | None = None
    manager: MemberReference | None = None
    estimated_start: str | None = Field(default=None, alias='estimatedStart')
    estimated_end: str | None = Field(default=None, alias='estimatedEnd')
    include_all_notes_flag: bool | None = Field(
        default=None, alias='includeAllNotesFlag'
    )
    include_all_documents_flag: bool | None = Field(
        default=None, alias='includeAllDocumentsFlag'
    )
    include_all_products_flag: bool | None = Field(
        default=None, alias='includeAllProductsFlag'
    )
    include_note_ids: list[int] | None = Field(default=None, alias='includeNoteIds')
    include_document_ids: list[int] | None = Field(
        default=None, alias='includeDocumentIds'
    )
    include_product_ids: list[int] | None = Field(
        default=None, alias='includeProductIds'
    )


class Order(ConnectWiseModel):
    id: int | None = None
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    phone: str | None = None
    phone_ext: str | None = Field(default=None, alias='phoneExt')
    email: str | None = None
    site: SiteReference | None = None
    status: OrderStatusReference | None = None
    opportunity: OpportunityReference | None = None
    order_date: datetime | None = Field(default=None, alias='orderDate')
    due_date: datetime | None = Field(default=None, alias='dueDate')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    po_number: str | None = Field(default=None, alias='poNumber')
    """
     Max length: 50;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    sales_rep: MemberReference | None = Field(default=None, alias='salesRep')
    notes: str | None = None
    bill_closed_flag: bool | None = Field(default=None, alias='billClosedFlag')
    bill_shipped_flag: bool | None = Field(default=None, alias='billShippedFlag')
    restrict_downpayment_flag: bool | None = Field(
        default=None, alias='restrictDownpaymentFlag'
    )
    description: str | None = None
    top_comment_flag: bool | None = Field(default=None, alias='topCommentFlag')
    bottom_comment_flag: bool | None = Field(default=None, alias='bottomCommentFlag')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    product_ids: list[int] | None = Field(default=None, alias='productIds')
    document_ids: list[int] | None = Field(default=None, alias='documentIds')
    invoice_ids: list[int] | None = Field(default=None, alias='invoiceIds')
    config_ids: list[int] | None = Field(default=None, alias='configIds')
    total: float | None = None
    tax_total: float | None = Field(default=None, alias='taxTotal')
    currency: CurrencyReference | None = None
    company_location: SystemLocationReference | None = Field(
        default=None, alias='companyLocation'
    )
    sub_total: float | None = Field(default=None, alias='subTotal')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class OrderStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    email_template: OrderStatusEmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OrderStatusEmailTemplate(ConnectWiseModel):
    id: int | None = None
    status: OrderStatusReference | None = None
    use_sender_flag: bool | None = Field(default=None, alias='useSenderFlag')
    first_name: str | None = Field(default=None, alias='firstName')
    """
     Max length: 100;
    """
    last_name: str | None = Field(default=None, alias='lastName')
    """
     Max length: 100;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
     Max length: 100;
    """
    subject: str
    """
     Max length: 200;
    """
    body: str
    copy_sender_flag: bool | None = Field(default=None, alias='copySenderFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class OrderStatusNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    status: OrderStatusReference | None = None
    member: MemberReference | None = None
    email: str | None = None
    """
    Order Status Notification sendEmail must be entered if the notify type is "Email Address". Max length: 50;
    """
    workflow_step: int | None = Field(default=None, alias='workflowStep')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Other(ConnectWiseModel):
    id: int | None = None
    default_ldap: LdapConfigurationReference | None = Field(
        default=None, alias='defaultLdap'
    )
    default_from_address: str = Field(..., alias='defaultFromAddress')
    """
     Max length: 50;
    """
    portal_url_override: str = Field(..., alias='portalUrlOverride')
    """
     Max length: 100;
    """
    site_url: str = Field(..., alias='siteUrl')
    """
     Max length: 100;
    """
    logo_path: str | None = Field(default=None, alias='logoPath')
    """
     Max length: 200;
    """
    contact_sync: Literal['FL', 'LF', 'CFL', 'CLF'] | None = Field(
        default=None, alias='contactSync'
    )
    server_time_zone: TimeZoneSetupReference | None = Field(
        default=None, alias='serverTimeZone'
    )
    default_calendar: CalendarReference | None = Field(
        default=None, alias='defaultCalendar'
    )
    default_address_format: AddressFormatReference | None = Field(
        default=None, alias='defaultAddressFormat'
    )
    use_ssl_flag: bool | None = Field(default=None, alias='useSslFlag')
    sync_leads_flag: bool | None = Field(default=None, alias='syncLeadsFlag')
    include_portal_link_flag: bool | None = Field(
        default=None, alias='includePortalLinkFlag'
    )
    use_expanded_format_time_flag: bool | None = Field(
        default=None, alias='useExpandedFormatTimeFlag'
    )
    use_expanded_format_activity_flag: bool | None = Field(
        default=None, alias='useExpandedFormatActivityFlag'
    )
    disable_z_admin_login_flag: bool | None = Field(
        default=None, alias='disableZAdminLoginFlag'
    )
    locale: LocaleReference | None = None
    update_member_time_zones_flag: bool | None = Field(
        default=None, alias='updateMemberTimeZonesFlag'
    )
    """
    If true, all Members time zone will also be set to serverTimeZone. Otherwise, only My Company time zone will be updated.
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PhaseStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    collapsed_flag: bool | None = Field(default=None, alias='collapsedFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    board_association_ids: list[int] | None = Field(
        default=None, alias='boardAssociationIds'
    )
    status_indicator: StatusIndicatorReference | None = Field(
        default=None, alias='statusIndicator'
    )
    custom_status_indicator_name: str | None = Field(
        default=None, alias='customStatusIndicatorName'
    )
    """
    Required when statusIndicator is Custom. Max length: 30;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationInvoiceSetup(ConnectWiseModel):
    id: int | None = None
    portal_configuration: PortalConfigurationReference | None = Field(
        default=None, alias='portalConfiguration'
    )
    display_inv_pmt_flag: bool | None = Field(default=None, alias='displayInvPmtFlag')
    allow_inv_pmt_flag: bool | None = Field(default=None, alias='allowInvPmtFlag')
    location: SystemLocationReference | None = None
    payment_processor: PortalConfigurationPaymentProcessorReference | None = Field(
        default=None, alias='paymentProcessor'
    )
    login: str | None = None
    password: str | None = None
    url_override: str | None = Field(default=None, alias='urlOverride')
    billing_status_ids: list[int] | None = Field(default=None, alias='billingStatusIds')
    add_all_statuses: bool | None = Field(default=None, alias='addAllStatuses')
    remove_all_statuses: bool | None = Field(default=None, alias='removeAllStatuses')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationProjectSetup(ConnectWiseModel):
    id: int | None = None
    portal_config: PortalConfigurationReference | None = Field(
        default=None, alias='portalConfig'
    )
    project_name_flag: bool | None = Field(default=None, alias='projectNameFlag')
    project_type_flag: bool | None = Field(default=None, alias='projectTypeFlag')
    status_flag: bool | None = Field(default=None, alias='statusFlag')
    project_manager_flag: bool | None = Field(default=None, alias='projectManagerFlag')
    billing_method_flag: bool | None = Field(default=None, alias='billingMethodFlag')
    contact_flag: bool | None = Field(default=None, alias='contactFlag')
    estimated_start_flag: bool | None = Field(default=None, alias='estimatedStartFlag')
    estimated_end_flag: bool | None = Field(default=None, alias='estimatedEndFlag')
    description_flag: bool | None = Field(default=None, alias='descriptionFlag')
    last_updated_flag: bool | None = Field(default=None, alias='lastUpdatedFlag')
    only_display: Literal[
        'DoNotDisplay',
        'Closed30Days',
        'Closed60Days',
        'Closed90Days',
        'Closed120Days',
        'AllClosed',
    ] = Field(..., alias='onlyDisplay')
    time_material_budget_hrs_flag: bool | None = Field(
        default=None, alias='timeMaterialBudgetHrsFlag'
    )
    time_material_scheduled_start_flag: bool | None = Field(
        default=None, alias='timeMaterialScheduledStartFlag'
    )
    time_material_scheduled_finish_flag: bool | None = Field(
        default=None, alias='timeMaterialScheduledFinishFlag'
    )
    time_material_scheduled_hrs_flag: bool | None = Field(
        default=None, alias='timeMaterialScheduledHrsFlag'
    )
    time_material_actual_start_flag: bool | None = Field(
        default=None, alias='timeMaterialActualStartFlag'
    )
    time_material_actual_finish_flag: bool | None = Field(
        default=None, alias='timeMaterialActualFinishFlag'
    )
    time_material_actual_hrs_flag: bool | None = Field(
        default=None, alias='timeMaterialActualHrsFlag'
    )
    time_material_bill_flag: bool | None = Field(
        default=None, alias='timeMaterialBillFlag'
    )
    time_material_status_flag: bool | None = Field(
        default=None, alias='timeMaterialStatusFlag'
    )
    time_material_assigned_flag: bool | None = Field(
        default=None, alias='timeMaterialAssignedFlag'
    )
    fixed_fee_budget_hrs_flag: bool | None = Field(
        default=None, alias='fixedFeeBudgetHrsFlag'
    )
    fixed_fee_scheduled_start_flag: bool | None = Field(
        default=None, alias='fixedFeeScheduledStartFlag'
    )
    fixed_fee_scheduled_finish_flag: bool | None = Field(
        default=None, alias='fixedFeeScheduledFinishFlag'
    )
    fixed_fee_scheduled_hrs_flag: bool | None = Field(
        default=None, alias='fixedFeeScheduledHrsFlag'
    )
    fixed_fee_actual_start_flag: bool | None = Field(
        default=None, alias='fixedFeeActualStartFlag'
    )
    fixed_fee_actual_finish_flag: bool | None = Field(
        default=None, alias='fixedFeeActualFinishFlag'
    )
    fixed_fee_actual_hrs_flag: bool | None = Field(
        default=None, alias='fixedFeeActualHrsFlag'
    )
    fixed_fee_bill_flag: bool | None = Field(default=None, alias='fixedFeeBillFlag')
    fixed_fee_status_flag: bool | None = Field(default=None, alias='fixedFeeStatusFlag')
    fixed_fee_assigned_flag: bool | None = Field(
        default=None, alias='fixedFeeAssignedFlag'
    )
    project_issue_budget_hrs_flag: bool | None = Field(
        default=None, alias='projectIssueBudgetHrsFlag'
    )
    project_issue_scheduled_start_flag: bool | None = Field(
        default=None, alias='projectIssueScheduledStartFlag'
    )
    project_issue_scheduled_finish_flag: bool | None = Field(
        default=None, alias='projectIssueScheduledFinishFlag'
    )
    project_issue_scheduled_hrs_flag: bool | None = Field(
        default=None, alias='projectIssueScheduledHrsFlag'
    )
    project_issue_actual_start_flag: bool | None = Field(
        default=None, alias='projectIssueActualStartFlag'
    )
    project_issue_actual_finish_flag: bool | None = Field(
        default=None, alias='projectIssueActualFinishFlag'
    )
    project_issue_actual_hrs_flag: bool | None = Field(
        default=None, alias='projectIssueActualHrsFlag'
    )
    project_issue_bill_flag: bool | None = Field(
        default=None, alias='projectIssueBillFlag'
    )
    project_issue_status_flag: bool | None = Field(
        default=None, alias='projectIssueStatusFlag'
    )
    project_issue_assigned_flag: bool | None = Field(
        default=None, alias='projectIssueAssignedFlag'
    )
    project_detail_total_hours_flag: bool | None = Field(
        default=None, alias='projectDetailTotalHoursFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PortalConfigurationServiceSetup(ConnectWiseModel):
    id: int | None = None
    service_type_flag: bool | None = Field(default=None, alias='serviceTypeFlag')
    service_sub_type_flag: bool | None = Field(default=None, alias='serviceSubTypeFlag')
    service_sub_type_item_flag: bool | None = Field(
        default=None, alias='serviceSubTypeItemFlag'
    )
    status_flag: bool | None = Field(default=None, alias='statusFlag')
    site_name_flag: bool | None = Field(default=None, alias='siteNameFlag')
    entered_date_flag: bool | None = Field(default=None, alias='enteredDateFlag')
    last_update_flag: bool | None = Field(default=None, alias='lastUpdateFlag')
    required_date_flag: bool | None = Field(default=None, alias='requiredDateFlag')
    contact_flag: bool | None = Field(default=None, alias='contactFlag')
    assigned_resources_flag: bool | None = Field(
        default=None, alias='assignedResourcesFlag'
    )
    sla_info_flag: bool | None = Field(default=None, alias='slaInfoFlag')
    service_board_flag: bool | None = Field(default=None, alias='serviceBoardFlag')
    budget_hours_flag: bool | None = Field(default=None, alias='budgetHoursFlag')
    actual_hours_flag: bool | None = Field(default=None, alias='actualHoursFlag')
    approval_status_flag: bool | None = Field(default=None, alias='approvalStatusFlag')
    open_tasks_flag: bool | None = Field(default=None, alias='openTasksFlag')
    closed_tasks_flag: bool | None = Field(default=None, alias='closedTasksFlag')
    enable_chat_assist_flag: bool | None = Field(
        default=None, alias='enableChatAssistFlag'
    )
    display_closed_tickets_option: Literal[
        'DoNotDisplay',
        'Closed30Days',
        'Closed60Days',
        'Closed90Days',
        'Closed120Days',
        'AllClosed',
    ] = Field(..., alias='displayClosedTicketsOption')
    time_materials_ticket_template: ServiceSignoffReference | None = Field(
        default=None, alias='timeMaterialsTicketTemplate'
    )
    fixed_fee_ticket_template: ServiceSignoffReference | None = Field(
        default=None, alias='fixedFeeTicketTemplate'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PricingDetail(ConnectWiseModel):
    id: int | None = None
    product: CatalogItemReference | None = None
    category: ProductCategoryReference | None = None
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    start_date: datetime = Field(..., alias='startDate')
    end_date: datetime | None = Field(default=None, alias='endDate')
    no_end_date: bool | None = Field(default=None, alias='noEndDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProcurementAdjustment(ConnectWiseModel):
    id: int | None = None
    identifier: str
    """
     Max length: 50;
    """
    type: AdjustmentTypeReference | None = None
    reason: str | None = None
    """
     Max length: 100;
    """
    notes: str | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    closed_by: str | None = Field(default=None, alias='closedBy')
    closed_date: datetime | None = Field(default=None, alias='closedDate')
    adjustment_details: list[AdjustmentDetail] | None = Field(
        default=None, alias='adjustmentDetails'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProductComponent(ConnectWiseModel):
    id: int | None = None
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    """
     Required On Updates;
    """
    quantity: float
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    hide_price_flag: bool | None = Field(default=None, alias='hidePriceFlag')
    hide_item_identifier_flag: bool | None = Field(
        default=None, alias='hideItemIdentifierFlag'
    )
    hide_description_flag: bool | None = Field(
        default=None, alias='hideDescriptionFlag'
    )
    hide_quantity_flag: bool | None = Field(default=None, alias='hideQuantityFlag')
    hide_extended_price_flag: bool | None = Field(
        default=None, alias='hideExtendedPriceFlag'
    )
    vendor: CompanyReference | None = None
    parent_product_item: ProductItemReference | None = Field(
        default=None, alias='parentProductItem'
    )
    product_item: ProductItemReference | None = Field(default=None, alias='productItem')
    price: float | None = None
    cost: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProductItem(ConnectWiseModel):
    id: int | None = None
    catalog_item: CatalogItemReference | None = Field(default=None, alias='catalogItem')
    description: str | None = None
    """
     Max length: 2000;
    """
    sequence_number: float | None = Field(default=None, alias='sequenceNumber')
    quantity: float | None = None
    price: float | None = None
    cost: float | None = None
    discount: float | None = None
    agreement_amount: float | None = Field(default=None, alias='agreementAmount')
    price_method: Literal[
        'FlatRateForRange',
        'PercentMarkupFromCost',
        'PercentMarkdownFromPrice',
        'PricePerUnit',
    ] | None = Field(default=None, alias='priceMethod')
    billable_option: Literal['Billable', 'DoNotBill', 'NoCharge'] = Field(
        ..., alias='billableOption'
    )
    agreement: AgreementReference | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    """
     Required On Updates;
    """
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    """
     Required On Updates;
    """
    vendor: CompanyReference | None = None
    vendor_sku: str | None = Field(default=None, alias='vendorSku')
    """
     Max length: 50;
    """
    taxable_flag: bool | None = Field(default=None, alias='taxableFlag')
    dropship_flag: bool | None = Field(default=None, alias='dropshipFlag')
    special_order_flag: bool | None = Field(default=None, alias='specialOrderFlag')
    phase_product_flag: bool | None = Field(default=None, alias='phaseProductFlag')
    cancelled_flag: bool | None = Field(default=None, alias='cancelledFlag')
    quantity_cancelled: float | None = Field(default=None, alias='quantityCancelled')
    cancelled_reason: str | None = Field(default=None, alias='cancelledReason')
    """
     Max length: 100;
    """
    customer_description: str | None = Field(default=None, alias='customerDescription')
    """
     Max length: 6000; Required On Updates;
    """
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    """
     Max length: 1000;
    """
    product_supplied_flag: bool | None = Field(
        default=None, alias='productSuppliedFlag'
    )
    sub_contractor_ship_to_id: int | None = Field(
        default=None, alias='subContractorShipToId'
    )
    sub_contractor_amount_limit: float | None = Field(
        default=None, alias='subContractorAmountLimit'
    )
    recurring: ProductRecurring | None = None
    sla: SLAReference | None = None
    entity_type: EntityTypeReference | None = Field(default=None, alias='entityType')
    ticket: TicketReference | None = None
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    sales_order: SalesOrderReference | None = Field(default=None, alias='salesOrder')
    opportunity: OpportunityReference | None = None
    invoice: InvoiceReference | None = None
    warehouse_id: int | None = Field(default=None, alias='warehouseId')
    warehouse_bin_id: int | None = Field(default=None, alias='warehouseBinId')
    calculated_price_flag: bool | None = Field(
        default=None, alias='calculatedPriceFlag'
    )
    calculated_cost_flag: bool | None = Field(default=None, alias='calculatedCostFlag')
    forecast_detail_id: int | None = Field(default=None, alias='forecastDetailId')
    cancelled_by: int | None = Field(default=None, alias='cancelledBy')
    cancelled_date: datetime | None = Field(default=None, alias='cancelledDate')
    warehouse: str | None = None
    warehouse_bin: str | None = Field(default=None, alias='warehouseBin')
    purchase_date: datetime | None = Field(default=None, alias='purchaseDate')
    integration_x_ref: str | None = Field(default=None, alias='integrationXRef')
    list_price: float | None = Field(default=None, alias='listPrice')
    serial_number_ids: list[int] | None = Field(default=None, alias='serialNumberIds')
    serial_numbers: list[str] | None = Field(default=None, alias='serialNumbers')
    company: CompanyReference | None = None
    forecast_status: OpportunityStatusReference | None = Field(
        default=None, alias='forecastStatus'
    )
    product_class: Literal[
        'Agreement', 'Bundle', 'Inventory', 'NonInventory', 'Service'
    ] | None = Field(default=None, alias='productClass')
    need_to_purchase_flag: bool | None = Field(default=None, alias='needToPurchaseFlag')
    need_to_order_quantity: int | None = Field(
        default=None, alias='needToOrderQuantity'
    )
    minimum_stock_flag: bool | None = Field(default=None, alias='minimumStockFlag')
    ship_set: str | None = Field(default=None, alias='shipSet')
    """
     Max length: 10;
    """
    calculated_price: float | None = Field(default=None, alias='calculatedPrice')
    calculated_cost: float | None = Field(default=None, alias='calculatedCost')
    invoice_grouping: InvoiceGroupingReference | None = Field(
        default=None, alias='invoiceGrouping'
    )
    po_approved_flag: bool | None = Field(default=None, alias='poApprovedFlag')
    add_components_flag: bool | None = Field(default=None, alias='addComponentsFlag')
    ignore_pricing_schedules_flag: bool | None = Field(
        default=None, alias='ignorePricingSchedulesFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    bypass_forecast_update: bool | None = Field(
        default=None, alias='bypassForecastUpdate'
    )
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class ProductPickingShippingDetail(ConnectWiseModel):
    id: int | None = None
    picked_quantity: int | None = Field(default=None, alias='pickedQuantity')
    shipped_quantity: int | None = Field(default=None, alias='shippedQuantity')
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    serial_number: str | None = Field(default=None, alias='serialNumber')
    serial_number_ids: list[int] | None = Field(default=None, alias='serialNumberIds')
    tracking_number: str | None = Field(default=None, alias='trackingNumber')
    product_item: ProductItemReference | None = Field(default=None, alias='productItem')
    line_number: int | None = Field(default=None, alias='lineNumber')
    quantity: int | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProductTypeExemption(ConnectWiseModel):
    id: int | None = None
    product_type: ProductTypeReference = Field(..., alias='productType')
    taxable_levels: list[int] | None = Field(default=None, alias='taxableLevels')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Project(ConnectWiseModel):
    id: int | None = None
    actual_end: datetime | None = Field(default=None, alias='actualEnd')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    actual_start: datetime | None = Field(default=None, alias='actualStart')
    agreement: AgreementReference | None = None
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    """
     Required On Updates;
    """
    billing_amount: float | None = Field(default=None, alias='billingAmount')
    billing_attention: str | None = Field(default=None, alias='billingAttention')
    """
     Max length: 50;
    """
    billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] = Field(..., alias='billingMethod')
    billing_rate_type: Literal['StaffMember', 'WorkRole'] | None = Field(
        default=None, alias='billingRateType'
    )
    """
     Required On Updates;
    """
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    """
     Required On Updates;
    """
    bill_project_after_closed_flag: bool | None = Field(
        default=None, alias='billProjectAfterClosedFlag'
    )
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    """
     Required On Updates;
    """
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    bill_unapproved_time_and_expense: bool | None = Field(
        default=None, alias='billUnapprovedTimeAndExpense'
    )
    board: ProjectBoardReference | None = None
    budget_analysis: Literal['ActualHours', 'BillableHours'] | None = Field(
        default=None, alias='budgetAnalysis'
    )
    """
     Required On Updates;
    """
    budget_flag: bool | None = Field(default=None, alias='budgetFlag')
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    customer_po: str | None = Field(default=None, alias='customerPO')
    """
     Max length: 50;
    """
    description: str | None = None
    currency: CurrencyReference | None = None
    downpayment: float | None = None
    estimated_end: datetime = Field(..., alias='estimatedEnd')
    percent_complete: float | None = Field(default=None, alias='percentComplete')
    estimated_expense_revenue: float | None = Field(
        default=None, alias='estimatedExpenseRevenue'
    )
    estimated_hours: float | None = Field(default=None, alias='estimatedHours')
    estimated_product_revenue: float | None = Field(
        default=None, alias='estimatedProductRevenue'
    )
    estimated_start: datetime = Field(..., alias='estimatedStart')
    estimated_time_revenue: float | None = Field(
        default=None, alias='estimatedTimeRevenue'
    )
    expense_approver: MemberReference | None = Field(
        default=None, alias='expenseApprover'
    )
    include_dependencies_flag: bool | None = Field(
        default=None, alias='includeDependenciesFlag'
    )
    include_estimates_flag: bool | None = Field(
        default=None, alias='includeEstimatesFlag'
    )
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    manager: MemberReference | None = None
    name: str
    """
     Max length: 100;
    """
    opportunity: OpportunityReference | None = None
    project_template_id: int | None = Field(default=None, alias='projectTemplateId')
    restrict_down_payment_flag: bool | None = Field(
        default=None, alias='restrictDownPaymentFlag'
    )
    scheduled_end: datetime | None = Field(default=None, alias='scheduledEnd')
    scheduled_hours: float | None = Field(default=None, alias='scheduledHours')
    scheduled_start: datetime | None = Field(default=None, alias='scheduledStart')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    site: SiteReference | None = None
    status: ProjectStatusReference | None = None
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    time_approver: MemberReference | None = Field(default=None, alias='timeApprover')
    type: ProjectTypeReference | None = None
    do_not_display_in_portal_flag: bool | None = Field(
        default=None, alias='doNotDisplayInPortalFlag'
    )
    billing_start_date: datetime | None = Field(default=None, alias='billingStartDate')
    estimated_time_cost: float | None = Field(default=None, alias='estimatedTimeCost')
    estimated_expense_cost: float | None = Field(
        default=None, alias='estimatedExpenseCost'
    )
    estimated_product_cost: float | None = Field(
        default=None, alias='estimatedProductCost'
    )
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    company_location: SystemLocationReference | None = Field(
        default=None, alias='companyLocation'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class ProjectBillingRate(ConnectWiseModel):
    id: int | None = None
    project_rec_id: int | None = Field(default=None, alias='projectRecId')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    activity_class_rec_id: int | None = Field(default=None, alias='activityClassRecId')
    member: MemberReference | None = None
    member_rec_id: int | None = Field(default=None, alias='memberRecId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectBoardTeam(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectBoardTeamMember(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    project_role: ProjectRoleReference | None = Field(default=None, alias='projectRole')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectPhase(ConnectWiseModel):
    id: int | None = None
    project_id: int | None = Field(default=None, alias='projectId')
    description: str
    """
     Max length: 100;
    """
    board: ProjectBoardReference | None = None
    status: PhaseStatusReference | None = None
    agreement: AgreementReference | None = None
    opportunity: OpportunityReference | None = None
    parent_phase: ProjectPhaseReference | None = Field(
        default=None, alias='parentPhase'
    )
    wbs_code: str | None = Field(default=None, alias='wbsCode')
    """
     Max length: 50;
    """
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    """
     Required On Updates;
    """
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    """
     Required On Updates;
    """
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    """
     Required On Updates;
    """
    mark_as_milestone_flag: bool | None = Field(
        default=None, alias='markAsMilestoneFlag'
    )
    notes: str | None = None
    deadline_date: datetime | None = Field(default=None, alias='deadlineDate')
    bill_separately_flag: bool | None = Field(default=None, alias='billSeparatelyFlag')
    billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='billingMethod')
    """
    billingMethod is required if the phase billSeparatelyFlag is true.
    """
    scheduled_hours: float | None = Field(default=None, alias='scheduledHours')
    scheduled_start: str | None = Field(default=None, alias='scheduledStart')
    scheduled_end: str | None = Field(default=None, alias='scheduledEnd')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    actual_start: str | None = Field(default=None, alias='actualStart')
    actual_end: str | None = Field(default=None, alias='actualEnd')
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    billing_start_date: datetime | None = Field(default=None, alias='billingStartDate')
    bill_phase_closed_flag: bool | None = Field(
        default=None, alias='billPhaseClosedFlag'
    )
    """
    This phase can only be billed after it has been closed.
    """
    bill_project_closed_flag: bool | None = Field(
        default=None, alias='billProjectClosedFlag'
    )
    """
    This phase can only be billed after the project has been closed.
    """
    downpayment: float | None = None
    po_number: str | None = Field(default=None, alias='poNumber')
    """
     Max length: 25;
    """
    po_amount: float | None = Field(default=None, alias='poAmount')
    estimated_time_cost: float | None = Field(default=None, alias='estimatedTimeCost')
    estimated_expense_cost: float | None = Field(
        default=None, alias='estimatedExpenseCost'
    )
    estimated_product_cost: float | None = Field(
        default=None, alias='estimatedProductCost'
    )
    estimated_time_revenue: float | None = Field(
        default=None, alias='estimatedTimeRevenue'
    )
    estimated_expense_revenue: float | None = Field(
        default=None, alias='estimatedExpenseRevenue'
    )
    estimated_product_revenue: float | None = Field(
        default=None, alias='estimatedProductRevenue'
    )
    currency: CurrencyReference | None = None
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class ProjectStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 30;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    no_time_flag: bool | None = Field(default=None, alias='noTimeFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    status_indicator: StatusIndicatorReference | None = Field(
        default=None, alias='statusIndicator'
    )
    custom_status_indicator_name: str | None = Field(
        default=None, alias='customStatusIndicatorName'
    )
    """
    Required when statusIndicator is Custom. Max length: 30;
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTeamMember(ConnectWiseModel):
    id: int | None = None
    project_id: int | None = Field(default=None, alias='projectId')
    hours: float | None = None
    member: MemberReference | None = None
    project_role: ProjectRoleReference | None = Field(default=None, alias='projectRole')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    start_date: datetime | None = Field(default=None, alias='startDate')
    end_date: datetime | None = Field(default=None, alias='endDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTemplate(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 200;
    """
    description: str | None = None
    type: ProjectTypeReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTemplateTask(ConnectWiseModel):
    id: int | None = None
    ticket_id: int | None = Field(default=None, alias='ticketId')
    sequence: int | None = None
    description: str | None = None
    summary: str | None = None
    code: ServiceCodeReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTemplateTicket(ConnectWiseModel):
    id: int | None = None
    project_template_id: int | None = Field(default=None, alias='projectTemplateId')
    project_template_phase_id: int | None = Field(
        default=None, alias='projectTemplatePhaseId'
    )
    line_number: float | None = Field(default=None, alias='lineNumber')
    description: str
    """
     Max length: 100;
    """
    notes: str | None = None
    internal_analysis: str | None = Field(default=None, alias='internalAnalysis')
    resolution: str | None = None
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    duration: int | None = None
    wbs_code: str | None = Field(default=None, alias='wbsCode')
    """
     Max length: 50;
    """
    bill_separately_flag: bool | None = Field(default=None, alias='billSeparatelyFlag')
    mark_as_milestone_flag: bool | None = Field(
        default=None, alias='markAsMilestoneFlag'
    )
    record_type: str | None = Field(default=None, alias='recordType')
    """
     Max length: 1;
    """
    pm_tmp_project_rec_id: int | None = Field(default=None, alias='pmTmpProjectRecID')
    priority: PriorityReference | None = None
    source: ServiceSourceReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectTicket(ConnectWiseModel):
    id: int | None = None
    summary: str
    """
     Max length: 100;
    """
    is_issue_flag: bool | None = Field(default=None, alias='isIssueFlag')
    board: BoardReference | None = None
    status: ServiceStatusReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    wbs_code: str | None = Field(default=None, alias='wbsCode')
    """
     Max length: 50;
    """
    company: CompanyReference | None = None
    site: SiteReference | None = None
    site_name: str | None = Field(default=None, alias='siteName')
    """
     Max length: 50;
    """
    address_line1: str | None = Field(default=None, alias='addressLine1')
    """
     Max length: 50;
    """
    address_line2: str | None = Field(default=None, alias='addressLine2')
    """
     Max length: 50;
    """
    city: str | None = None
    """
     Max length: 50;
    """
    state_identifier: str | None = Field(default=None, alias='stateIdentifier')
    """
     Max length: 50;
    """
    zip: str | None = None
    """
     Max length: 12;
    """
    country: CountryReference | None = None
    contact: ContactReference | None = None
    contact_name: str | None = Field(default=None, alias='contactName')
    """
     Max length: 62;
    """
    contact_phone_number: str | None = Field(default=None, alias='contactPhoneNumber')
    """
     Max length: 20;
    """
    contact_phone_extension: str | None = Field(
        default=None, alias='contactPhoneExtension'
    )
    """
     Max length: 15;
    """
    contact_email_address: str | None = Field(default=None, alias='contactEmailAddress')
    """
     Max length: 250;
    """
    type: ServiceTypeReference | None = None
    sub_type: ServiceSubTypeReference | None = Field(default=None, alias='subType')
    item: ServiceItemReference | None = None
    owner: MemberReference | None = None
    priority: PriorityReference | None = None
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    source: ServiceSourceReference | None = None
    required_date: datetime | None = Field(default=None, alias='requiredDate')
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    opportunity: OpportunityReference | None = None
    agreement: AgreementReference | None = None
    knowledge_base_category_id: int | None = Field(
        default=None, alias='knowledgeBaseCategoryId'
    )
    knowledge_base_sub_category_id: int | None = Field(
        default=None, alias='knowledgeBaseSubCategoryId'
    )
    knowledge_base_link_id: int | None = Field(
        default=None, alias='knowledgeBaseLinkId'
    )
    knowledge_base_link_type: Literal[
        'Activity',
        'ProjectIssue',
        'KnowledgeBaseArticle',
        'ProjectTicket',
        'ServiceTicket',
        'Time',
    ] | None = Field(default=None, alias='knowledgeBaseLinkType')
    allow_all_clients_portal_view: bool | None = Field(
        default=None, alias='allowAllClientsPortalView'
    )
    customer_updated_flag: bool | None = Field(
        default=None, alias='customerUpdatedFlag'
    )
    automatic_email_contact_flag: bool | None = Field(
        default=None, alias='automaticEmailContactFlag'
    )
    automatic_email_resource_flag: bool | None = Field(
        default=None, alias='automaticEmailResourceFlag'
    )
    automatic_email_cc_flag: bool | None = Field(
        default=None, alias='automaticEmailCcFlag'
    )
    automatic_email_cc: str | None = Field(default=None, alias='automaticEmailCc')
    """
     Max length: 1000;
    """
    closed_date: str | None = Field(default=None, alias='closedDate')
    closed_by: str | None = Field(default=None, alias='closedBy')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    approved: bool | None = None
    sub_billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='subBillingMethod')
    sub_billing_amount: float | None = Field(default=None, alias='subBillingAmount')
    sub_date_accepted: str | None = Field(default=None, alias='subDateAccepted')
    resources: str | None = None
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    predecessor_type: Literal['Ticket', 'Phase'] | None = Field(
        default=None, alias='predecessorType'
    )
    predecessor_id: int | None = Field(default=None, alias='predecessorId')
    predecessor_closed_flag: bool | None = Field(
        default=None, alias='predecessorClosedFlag'
    )
    lag_days: int | None = Field(default=None, alias='lagDays')
    lag_nonworking_days_flag: bool | None = Field(
        default=None, alias='lagNonworkingDaysFlag'
    )
    estimated_start_date: datetime | None = Field(
        default=None, alias='estimatedStartDate'
    )
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    duration: int | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    tasks: list[TicketTask] | None = None
    initial_description: str | None = Field(default=None, alias='initialDescription')
    """
    Only available for POST, will not be returned in the response.
    """
    initial_internal_analysis: str | None = Field(
        default=None, alias='initialInternalAnalysis'
    )
    """
    Only available for POST, will not be returned in the response.
    """
    initial_resolution: str | None = Field(default=None, alias='initialResolution')
    """
    Only available for POST, will not be returned in the response.
    """
    contact_email_lookup: str | None = Field(default=None, alias='contactEmailLookup')
    process_notifications: bool | None = Field(
        default=None, alias='processNotifications'
    )
    """
    Can be set to false to skip notification processing when adding or updating a ticket (Defaults to True).
    """
    skip_callback: bool | None = Field(default=None, alias='skipCallback')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class ProjectTicketNote(ConnectWiseModel):
    id: int | None = None
    note_type: Literal['TicketNote', 'TimeEntryNote', 'MeetingNote'] | None = Field(
        default=None, alias='noteType'
    )
    ticket: TicketReference | None = None
    text: str | None = None
    detail_description_flag: bool | None = Field(
        default=None, alias='detailDescriptionFlag'
    )
    internal_analysis_flag: bool | None = Field(
        default=None, alias='internalAnalysisFlag'
    )
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    time_start: datetime | None = Field(default=None, alias='timeStart')
    time_end: datetime | None = Field(default=None, alias='timeEnd')
    bundled_flag: bool | None = Field(default=None, alias='bundledFlag')
    merged_flag: bool | None = Field(default=None, alias='mergedFlag')
    issue_flag: bool | None = Field(default=None, alias='issueFlag')
    original_author: str | None = Field(default=None, alias='originalAuthor')
    member: MemberReference | None = None
    contact: ContactReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ProjectWorkplan(ConnectWiseModel):
    id: int | None = None
    project_id: int | None = Field(default=None, alias='projectId')
    description: str | None = None
    board: ProjectBoardReference | None = None
    status: PhaseStatusReference | None = None
    agreement: AgreementReference | None = None
    opportunity: OpportunityReference | None = None
    parent_phase: ProjectPhaseReference | None = Field(
        default=None, alias='parentPhase'
    )
    wbs_code: str | None = Field(default=None, alias='wbsCode')
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    mark_as_milestone_flag: bool | None = Field(
        default=None, alias='markAsMilestoneFlag'
    )
    notes: str | None = None
    deadline_date: str | None = Field(default=None, alias='deadlineDate')
    bill_separately_flag: bool | None = Field(default=None, alias='billSeparatelyFlag')
    billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='billingMethod')
    """
    billingMethod is required if the phase billSeparatelyFlag is true.
    """
    scheduled_hours: float | None = Field(default=None, alias='scheduledHours')
    scheduled_start: str | None = Field(default=None, alias='scheduledStart')
    scheduled_end: str | None = Field(default=None, alias='scheduledEnd')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    actual_start: str | None = Field(default=None, alias='actualStart')
    actual_end: str | None = Field(default=None, alias='actualEnd')
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    billing_start_date: str | None = Field(default=None, alias='billingStartDate')
    bill_phase_closed_flag: bool | None = Field(
        default=None, alias='billPhaseClosedFlag'
    )
    """
    This phase can only be billed after it has been closed.
    """
    bill_project_closed_flag: bool | None = Field(
        default=None, alias='billProjectClosedFlag'
    )
    """
    This phase can only be billed after the project has been closed.
    """
    downpayment: float | None = None
    po_number: str | None = Field(default=None, alias='poNumber')
    po_amount: float | None = Field(default=None, alias='poAmount')
    estimated_time_cost: float | None = Field(default=None, alias='estimatedTimeCost')
    estimated_expense_cost: float | None = Field(
        default=None, alias='estimatedExpenseCost'
    )
    estimated_product_cost: float | None = Field(
        default=None, alias='estimatedProductCost'
    )
    estimated_time_revenue: float | None = Field(
        default=None, alias='estimatedTimeRevenue'
    )
    estimated_expense_revenue: float | None = Field(
        default=None, alias='estimatedExpenseRevenue'
    )
    estimated_product_revenue: float | None = Field(
        default=None, alias='estimatedProductRevenue'
    )
    currency: CurrencyReference | None = None
    bill_to_company: CompanyReference | None = Field(
        default=None, alias='billToCompany'
    )
    bill_to_contact: ContactReference | None = Field(
        default=None, alias='billToContact'
    )
    bill_to_site: SiteReference | None = Field(default=None, alias='billToSite')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    tickets: list[ProjectTicket] | None = None
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class PurchaseOrder(ConnectWiseModel):
    id: int | None = None
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    cancel_reason: str | None = Field(default=None, alias='cancelReason')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    """
    The closed flag can only be updated via updating the purchase order status to a closed/open status.
    """
    closed_by: str | None = Field(default=None, alias='closedBy')
    customer_city: str | None = Field(default=None, alias='customerCity')
    customer_company: CompanyReference | None = Field(
        default=None, alias='customerCompany'
    )
    customer_contact: ContactReference | None = Field(
        default=None, alias='customerContact'
    )
    customer_country: CountryReference | None = Field(
        default=None, alias='customerCountry'
    )
    customer_extension: str | None = Field(default=None, alias='customerExtension')
    customer_name: str | None = Field(default=None, alias='customerName')
    customer_phone: str | None = Field(default=None, alias='customerPhone')
    customer_site: SiteReference | None = Field(default=None, alias='customerSite')
    customer_site_name: str | None = Field(default=None, alias='customerSiteName')
    customer_state: str | None = Field(default=None, alias='customerState')
    customer_street_line1: str | None = Field(default=None, alias='customerStreetLine1')
    customer_street_line2: str | None = Field(default=None, alias='customerStreetLine2')
    customer_zip: str | None = Field(default=None, alias='customerZip')
    date_closed: datetime | None = Field(default=None, alias='dateClosed')
    drop_ship_customer_flag: bool | None = Field(
        default=None, alias='dropShipCustomerFlag'
    )
    entered_by: str | None = Field(default=None, alias='enteredBy')
    freight_cost: float | None = Field(default=None, alias='freightCost')
    freight_packing_slip: str | None = Field(default=None, alias='freightPackingSlip')
    freight_tax_total: float | None = Field(default=None, alias='freightTaxTotal')
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    location_id: int | None = Field(default=None, alias='locationId')
    po_date: datetime | None = Field(default=None, alias='poDate')
    """
     Required On Updates;
    """
    po_number: str | None = Field(default=None, alias='poNumber')
    """
     Required On Updates; Max length: 50;
    """
    sales_tax: float | None = Field(default=None, alias='salesTax')
    shipment_date: datetime | None = Field(default=None, alias='shipmentDate')
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    shipping_instructions: str | None = Field(
        default=None, alias='shippingInstructions'
    )
    status: PurchaseOrderStatusReference | None = None
    sub_total: float | None = Field(default=None, alias='subTotal')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    tax_freight_flag: bool | None = Field(default=None, alias='taxFreightFlag')
    tax_po_flag: bool | None = Field(default=None, alias='taxPoFlag')
    terms: BillingTermsReference | None = None
    total: float | None = None
    tracking_number: str | None = Field(default=None, alias='trackingNumber')
    """
     Max length: 50;
    """
    update_shipment_info: bool | None = Field(default=None, alias='updateShipmentInfo')
    """
    Determines whether or not to update all of the shipment info for each associated line item when new shipment info is passed in.
    """
    update_vendor_order_number: bool | None = Field(
        default=None, alias='updateVendorOrderNumber'
    )
    """
    Determines whether or not to update vendor order number for each associated line item when new vendor order number is passed in.
    """
    vendor_company: CompanyReference | None = Field(default=None, alias='vendorCompany')
    vendor_contact: ContactReference | None = Field(default=None, alias='vendorContact')
    vendor_invoice_date: datetime | None = Field(
        default=None, alias='vendorInvoiceDate'
    )
    vendor_invoice_number: str | None = Field(default=None, alias='vendorInvoiceNumber')
    """
     Max length: 50;
    """
    vendor_order_number: str | None = Field(default=None, alias='vendorOrderNumber')
    """
     Max length: 50;
    """
    vendor_site: SiteReference | None = Field(default=None, alias='vendorSite')
    warehouse: WarehouseReference | None = None
    warehouse_contact: ContactReference | None = Field(
        default=None, alias='warehouseContact'
    )
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class PurchaseOrderLineItem(ConnectWiseModel):
    id: int | None = None
    backordered_flag: bool | None = Field(default=None, alias='backorderedFlag')
    canceled_by: str | None = Field(default=None, alias='canceledBy')
    canceled_flag: bool | None = Field(default=None, alias='canceledFlag')
    canceled_reason: str | None = Field(default=None, alias='canceledReason')
    """
     Max length: 100;
    """
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    date_canceled: datetime | None = Field(default=None, alias='dateCanceled')
    date_canceled_utc: datetime | None = Field(default=None, alias='dateCanceledUtc')
    description: str
    """
     Max length: 6000;
    """
    display_internal_notes_flag: bool | None = Field(
        default=None, alias='displayInternalNotesFlag'
    )
    expected_ship_date: datetime | None = Field(default=None, alias='expectedShipDate')
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    """
     Max length: 1000;
    """
    line_number: int = Field(..., alias='lineNumber')
    packing_slip: str | None = Field(default=None, alias='packingSlip')
    """
     Max length: 50;
    """
    product: IvItemReference | None = None
    purchase_order_id: int | None = Field(default=None, alias='purchaseOrderId')
    quantity: float
    received_quantity: int | None = Field(default=None, alias='receivedQuantity')
    serial_numbers: str | None = Field(default=None, alias='serialNumbers')
    ship_date: datetime | None = Field(default=None, alias='shipDate')
    shipment_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipmentMethod'
    )
    tax: float | None = None
    tracking_number: str | None = Field(default=None, alias='trackingNumber')
    """
     Max length: 50;
    """
    unit_cost: float | None = Field(default=None, alias='unitCost')
    unit_of_measure: UnitOfMeasureReference | None = Field(
        default=None, alias='unitOfMeasure'
    )
    vendor_order_number: str | None = Field(default=None, alias='vendorOrderNumber')
    """
     Max length: 50;
    """
    vendor_sku: str | None = Field(default=None, alias='vendorSku')
    """
     Max length: 50;
    """
    warehouse: WarehouseReference | None = None
    warehouse_bin: WarehouseBinReference | None = Field(
        default=None, alias='warehouseBin'
    )
    ship_set: str | None = Field(default=None, alias='shipSet')
    """
     Max length: 10;
    """
    date_received: datetime | None = Field(default=None, alias='dateReceived')
    received_status: Literal[
        'Waiting',
        'FullyReceived',
        'PartiallyReceiveCancelRest',
        'PartiallyReceiveCloneRest',
    ] | None = Field(default=None, alias='receivedStatus')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class PurchaseOrderStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_closed_flag: bool | None = Field(default=None, alias='defaultClosedFlag')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    email_template: PurchaseOrderStatusEmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PurchaseOrderStatusEmailTemplate(ConnectWiseModel):
    id: int | None = None
    status: PurchaseOrderStatusReference | None = None
    use_sender_flag: bool | None = Field(default=None, alias='useSenderFlag')
    first_name: str | None = Field(default=None, alias='firstName')
    """
     Max length: 100;
    """
    last_name: str | None = Field(default=None, alias='lastName')
    """
     Max length: 100;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
     Max length: 100;
    """
    subject: str
    """
     Max length: 200;
    """
    body: str | None = None
    copy_sender_flag: bool | None = Field(default=None, alias='copySenderFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PurchaseOrderStatusNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    status: PurchaseOrderStatusReference | None = None
    member: MemberReference | None = None
    email: str | None = None
    """
    Purchase Order Status Notification email must be entered if the notify type is "Email Address". Max length: 50;
    """
    workflow_step: int | None = Field(default=None, alias='workflowStep')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class PurchasingDemand(ConnectWiseModel):
    warehouse: WarehouseReference | None = None
    vendor: CompanyReference | None = None
    products: list[ProductDemand] | None = None
    purchase_order: PurchaseOrder | None = Field(default=None, alias='purchaseOrder')


class QuoteLink(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    link: str
    """
     Max length: 2000;
    """
    all_locations_flag: bool | None = Field(default=None, alias='allLocationsFlag')
    new_window_flag: bool | None = Field(default=None, alias='newWindowFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ReportCardDetail(ConnectWiseModel):
    id: int | None = None
    kpi: KPIReference | None = None
    sort_order: int | None = Field(default=None, alias='sortOrder')
    report_card: ReportCardReference | None = Field(default=None, alias='reportCard')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ResultInfo(ConnectWiseModel):
    success: bool | None = None
    original_index: int | None = Field(default=None, alias='originalIndex')
    status_code: int | None = Field(default=None, alias='statusCode')
    data: IRestIdentifiedItem | None = None
    error: ErrorResponseMessage | None = None


class RmaStatus(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    sort_order: int | None = Field(default=None, alias='sortOrder')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    email_template: RmaStatusEmailTemplateReference | None = Field(
        default=None, alias='emailTemplate'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class RmaStatusEmailTemplate(ConnectWiseModel):
    id: int | None = None
    status: RmaStatusReference | None = None
    use_sender_flag: bool | None = Field(default=None, alias='useSenderFlag')
    first_name: str | None = Field(default=None, alias='firstName')
    """
     Max length: 100;
    """
    last_name: str | None = Field(default=None, alias='lastName')
    """
     Max length: 100;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
     Max length: 100;
    """
    subject: str
    """
     Max length: 200;
    """
    body: str
    copy_sender_flag: bool | None = Field(default=None, alias='copySenderFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class RmaStatusNotification(ConnectWiseModel):
    id: int | None = None
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    status: RmaStatusReference | None = None
    member: MemberReference | None = None
    email: str | None = None
    """
    RMA Status Notification sendEmail must be entered if the notify type is "Email Address". Max length: 50;
    """
    workflow_step: int | None = Field(default=None, alias='workflowStep')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class RmaTag(ConnectWiseModel):
    id: int | None = None
    service_ticket: TicketReference | None = Field(default=None, alias='serviceTicket')
    sales_order: SalesOrderReference | None = Field(default=None, alias='salesOrder')
    invoice: InvoiceReference | None = None
    project: ProjectReference | None = None
    summary: str | None = None
    """
     Max length: 150;
    """
    product: IvItemReference | None = None
    iv_description: str | None = Field(default=None, alias='ivDescription')
    product_description: str = Field(..., alias='productDescription')
    """
     Max length: 200;
    """
    serial_number: str | None = Field(default=None, alias='serialNumber')
    mfg_item_id: str | None = Field(default=None, alias='mfgItemID')
    """
     Max length: 100;
    """
    status: RmaStatusReference | None = None
    list_price: float | None = Field(default=None, alias='listPrice')
    unit_price: float | None = Field(default=None, alias='unitPrice')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    problem_description: str | None = Field(default=None, alias='problemDescription')
    """
     Max length: 1000;
    """
    returned_company: CompanyReference | None = Field(
        default=None, alias='returnedCompany'
    )
    returned_contact: ContactReference | None = Field(
        default=None, alias='returnedContact'
    )
    returned_contact_type: str | None = Field(default=None, alias='returnedContactType')
    returned_contact_phone: str | None = Field(
        default=None, alias='returnedContactPhone'
    )
    returned_contact_extension: str | None = Field(
        default=None, alias='returnedContactExtension'
    )
    returned_contact_email: str | None = Field(
        default=None, alias='returnedContactEmail'
    )
    returned_contact_address_line1: str | None = Field(
        default=None, alias='returnedContactAddressLine1'
    )
    """
     Max length: 50;
    """
    returned_contact_address_line2: str | None = Field(
        default=None, alias='returnedContactAddressLine2'
    )
    """
     Max length: 50;
    """
    returned_contact_city: str | None = Field(default=None, alias='returnedContactCity')
    """
     Max length: 50;
    """
    returned_contact_state: str | None = Field(
        default=None, alias='returnedContactState'
    )
    """
     Max length: 50;
    """
    returned_contact_zip: str | None = Field(default=None, alias='returnedContactZip')
    """
     Max length: 12;
    """
    returned_contact_country: CountryReference | None = Field(
        default=None, alias='returnedContactCountry'
    )
    rma_disposition: RmaDispositionReference | None = Field(
        default=None, alias='rmaDisposition'
    )
    returned_site: SiteReference | None = Field(default=None, alias='returnedSite')
    purchased_company: CompanyReference | None = Field(
        default=None, alias='purchasedCompany'
    )
    purchased_contact: ContactReference | None = Field(
        default=None, alias='purchasedContact'
    )
    purchased_contact_type: str | None = Field(
        default=None, alias='purchasedContactType'
    )
    purchased_contact_phone: str | None = Field(
        default=None, alias='purchasedContactPhone'
    )
    purchased_contact_extension: str | None = Field(
        default=None, alias='purchasedContactExtension'
    )
    purchased_contact_email: str | None = Field(
        default=None, alias='purchasedContactEmail'
    )
    purchased_contact_address_line1: str | None = Field(
        default=None, alias='purchasedContactAddressLine1'
    )
    """
     Max length: 50;
    """
    purchased_contact_address_line2: str | None = Field(
        default=None, alias='purchasedContactAddressLine2'
    )
    """
     Max length: 50;
    """
    purchased_contact_city: str | None = Field(
        default=None, alias='purchasedContactCity'
    )
    """
     Max length: 50;
    """
    purchased_contact_state: str | None = Field(
        default=None, alias='purchasedContactState'
    )
    """
     Max length: 50;
    """
    purchased_contact_zip: str | None = Field(default=None, alias='purchasedContactZip')
    """
     Max length: 12;
    """
    purchased_contact_country: CountryReference | None = Field(
        default=None, alias='purchasedContactCountry'
    )
    purchased_invoice_number: str | None = Field(
        default=None, alias='purchasedInvoiceNumber'
    )
    """
     Max length: 50;
    """
    purchased_invoice_date: date | None = Field(
        default=None, alias='purchasedInvoiceDate'
    )
    purchased_order_number: str | None = Field(
        default=None, alias='purchasedOrderNumber'
    )
    """
     Max length: 50;
    """
    purchased_vendor_action: RmaActionReference | None = Field(
        default=None, alias='purchasedVendorAction'
    )
    purchased_vendor_rma_number: str | None = Field(
        default=None, alias='purchasedVendorRmaNumber'
    )
    """
     Max length: 50;
    """
    purchased_site: SiteReference | None = Field(default=None, alias='purchasedSite')
    purchased_notes: str | None = Field(default=None, alias='purchasedNotes')
    """
     Max length: 1000;
    """
    warranty_company: CompanyReference | None = Field(
        default=None, alias='warrantyCompany'
    )
    warranty_contact: ContactReference | None = Field(
        default=None, alias='warrantyContact'
    )
    warranty_contact_type: str | None = Field(default=None, alias='warrantyContactType')
    warranty_contact_phone: str | None = Field(
        default=None, alias='warrantyContactPhone'
    )
    warranty_contact_email: str | None = Field(
        default=None, alias='warrantyContactEmail'
    )
    warranty_contact_extension: str | None = Field(
        default=None, alias='warrantyContactExtension'
    )
    warranty_contact_address_line1: str | None = Field(
        default=None, alias='warrantyContactAddressLine1'
    )
    """
     Max length: 50;
    """
    warranty_contact_address_line2: str | None = Field(
        default=None, alias='warrantyContactAddressLine2'
    )
    """
     Max length: 50;
    """
    warranty_contact_city: str | None = Field(default=None, alias='warrantyContactCity')
    """
     Max length: 50;
    """
    warranty_contact_state: str | None = Field(
        default=None, alias='warrantyContactState'
    )
    """
     Max length: 50;
    """
    warranty_contact_zip: str | None = Field(default=None, alias='warrantyContactZip')
    """
     Max length: 12;
    """
    warranty_contact_country: CountryReference | None = Field(
        default=None, alias='warrantyContactCountry'
    )
    warranty_site: SiteReference | None = Field(default=None, alias='warrantySite')
    warranty_notes: str | None = Field(default=None, alias='warrantyNotes')
    """
     Max length: 1000;
    """
    repair_company: CompanyReference | None = Field(default=None, alias='repairCompany')
    repair_contact: ContactReference | None = Field(default=None, alias='repairContact')
    repair_contact_type: str | None = Field(default=None, alias='repairContactType')
    repair_contact_phone: str | None = Field(default=None, alias='repairContactPhone')
    repair_contact_extension: str | None = Field(
        default=None, alias='repairContactExtension'
    )
    repair_contact_email: str | None = Field(default=None, alias='repairContactEmail')
    repair_contact_address_line1: str | None = Field(
        default=None, alias='repairContactAddressLine1'
    )
    """
     Max length: 50;
    """
    repair_contact_address_line2: str | None = Field(
        default=None, alias='repairContactAddressLine2'
    )
    """
     Max length: 50;
    """
    repair_contact_city: str | None = Field(default=None, alias='repairContactCity')
    """
     Max length: 50;
    """
    repair_contact_state: str | None = Field(default=None, alias='repairContactState')
    """
     Max length: 50;
    """
    repair_contact_zip: str | None = Field(default=None, alias='repairContactZip')
    """
     Max length: 12;
    """
    repair_contact_country: CountryReference | None = Field(
        default=None, alias='repairContactCountry'
    )
    repair_order_number: str | None = Field(default=None, alias='repairOrderNumber')
    """
     Max length: 50;
    """
    repair_site: SiteReference | None = Field(default=None, alias='repairSite')
    repair_notes: str | None = Field(default=None, alias='repairNotes')
    """
     Max length: 1000;
    """
    drop_ship_flag: bool | None = Field(default=None, alias='dropShipFlag')
    ship_method: ShipmentMethodReference | None = Field(
        default=None, alias='shipMethod'
    )
    shipping_date: date | None = Field(default=None, alias='shippingDate')
    shipping_tracking_number: str | None = Field(
        default=None, alias='shippingTrackingNumber'
    )
    """
     Max length: 50;
    """
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    """
     Max length: 1000;
    """
    closing_notes: str | None = Field(default=None, alias='closingNotes')
    """
     Max length: 1000;
    """
    date_closed: str | None = Field(default=None, alias='dateClosed')
    account_manager: MemberReference | None = Field(
        default=None, alias='accountManager'
    )
    technical_contact: MemberReference | None = Field(
        default=None, alias='technicalContact'
    )
    currency: CurrencyReference | None = None
    closed_by: MemberReference | None = Field(default=None, alias='closedBy')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class SalesQuota(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    forecast_year: int | None = Field(default=None, alias='forecastYear')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    category: ProductCategoryReference | None = None
    sub_category: ProductSubCategoryReference | None = Field(
        default=None, alias='subCategory'
    )
    january_revenue: float | None = Field(default=None, alias='januaryRevenue')
    january_margin: float | None = Field(default=None, alias='januaryMargin')
    february_revenue: float | None = Field(default=None, alias='februaryRevenue')
    february_margin: float | None = Field(default=None, alias='februaryMargin')
    march_revenue: float | None = Field(default=None, alias='marchRevenue')
    march_margin: float | None = Field(default=None, alias='marchMargin')
    april_revenue: float | None = Field(default=None, alias='aprilRevenue')
    april_margin: float | None = Field(default=None, alias='aprilMargin')
    may_revenue: float | None = Field(default=None, alias='mayRevenue')
    may_margin: float | None = Field(default=None, alias='mayMargin')
    june_revenue: float | None = Field(default=None, alias='juneRevenue')
    june_margin: float | None = Field(default=None, alias='juneMargin')
    july_revenue: float | None = Field(default=None, alias='julyRevenue')
    july_margin: float | None = Field(default=None, alias='julyMargin')
    august_revenue: float | None = Field(default=None, alias='augustRevenue')
    august_margin: float | None = Field(default=None, alias='augustMargin')
    september_revenue: float | None = Field(default=None, alias='septemberRevenue')
    september_margin: float | None = Field(default=None, alias='septemberMargin')
    october_revenue: float | None = Field(default=None, alias='octoberRevenue')
    october_margin: float | None = Field(default=None, alias='octoberMargin')
    november_revenue: float | None = Field(default=None, alias='novemberRevenue')
    november_margin: float | None = Field(default=None, alias='novemberMargin')
    december_revenue: float | None = Field(default=None, alias='decemberRevenue')
    december_margin: float | None = Field(default=None, alias='decemberMargin')
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SalesTeam(ConnectWiseModel):
    id: int | None = None
    sales_team_identifier: str = Field(..., alias='salesTeamIdentifier')
    """
     Max length: 20;
    """
    sales_team_description: str = Field(..., alias='salesTeamDescription')
    """
     Max length: 50;
    """
    sales_team_location: SystemLocationReference | None = Field(
        default=None, alias='salesTeamLocation'
    )
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SalesTeamMember(ConnectWiseModel):
    id: int | None = None
    member: MemberReference | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    allow_access_flag: bool | None = Field(default=None, alias='allowAccessFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleDetail(ConnectWiseModel):
    id: int | None = None
    schedule_entry: ScheduleEntryReference | None = Field(
        default=None, alias='scheduleEntry'
    )
    date_start: str | None = Field(default=None, alias='dateStart')
    date_end: str | None = Field(default=None, alias='dateEnd')
    member: MemberReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleEntry(ConnectWiseModel):
    id: int | None = None
    object_id: int | None = Field(default=None, alias='objectId')
    name: str | None = None
    """
     Max length: 250;
    """
    member: MemberReference | None = None
    where: ServiceLocationReference | None = None
    date_start: datetime | None = Field(default=None, alias='dateStart')
    date_end: datetime | None = Field(default=None, alias='dateEnd')
    reminder: ReminderReference | None = None
    status: ScheduleStatusReference | None = None
    type: ScheduleTypeReference | None = None
    span: ScheduleSpanReference | None = None
    done_flag: bool | None = Field(default=None, alias='doneFlag')
    acknowledged_flag: bool | None = Field(default=None, alias='acknowledgedFlag')
    owner_flag: bool | None = Field(default=None, alias='ownerFlag')
    meeting_flag: bool | None = Field(default=None, alias='meetingFlag')
    allow_schedule_conflicts_flag: bool | None = Field(
        default=None, alias='allowScheduleConflictsFlag'
    )
    add_member_to_project_flag: bool | None = Field(
        default=None, alias='addMemberToProjectFlag'
    )
    project_role_id: int | None = Field(default=None, alias='projectRoleId')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    acknowledged_date: datetime | None = Field(default=None, alias='acknowledgedDate')
    close_date: datetime | None = Field(default=None, alias='closeDate')
    hours: float | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleEntryDetail(ConnectWiseModel):
    id: int | None = None
    schedule_entry: ScheduleEntryReference | None = Field(
        default=None, alias='scheduleEntry'
    )
    date_start: str | None = Field(default=None, alias='dateStart')
    date_end: str | None = Field(default=None, alias='dateEnd')
    hours_scheduled: float | None = Field(default=None, alias='hoursScheduled')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleStopwatch(ConnectWiseModel):
    info: dict[str, str] | None = Field(default=None, alias='_info')
    agreement: AgreementReference | None = None
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    end_time: datetime | None = Field(default=None, alias='endTime')
    id: int | None = None
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    location_id: int | None = Field(default=None, alias='locationId')
    member: MemberReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    notes: str | None = None
    """
     Max length: 4000;
    """
    schedule_id: int = Field(..., alias='scheduleId')
    schedule_mobile_guid: UUID | None = Field(default=None, alias='scheduleMobileGuid')
    start_time: datetime | None = Field(default=None, alias='startTime')
    status: Literal['Reset', 'Running', 'Paused', 'Stopped']
    total_pause_time: int | None = Field(default=None, alias='totalPauseTime')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')


class ScheduleType(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    identifier: str
    """
     Max length: 1;
    """
    charge_code: ChargeCodeReference | None = Field(default=None, alias='chargeCode')
    where: ServiceLocationReference | None = None
    system_flag: bool | None = Field(default=None, alias='systemFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ScheduleTypeInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    identifier: str | None = None
    charge_code: ChargeCodeReference | None = Field(default=None, alias='chargeCode')
    where: ServiceLocationReference | None = None
    system_flag: bool | None = Field(default=None, alias='systemFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceEmailTemplate(ConnectWiseModel):
    id: int | None = None
    type: Literal[
        'Any',
        'Closed',
        'Invoice',
        'New',
        'SalesOrder',
        'PurchaseOrder',
        'RMA',
        'Specific',
    ]
    service_survey: ServiceSurveyReference | None = Field(
        default=None, alias='serviceSurvey'
    )
    service_board: BoardReference | None = Field(default=None, alias='serviceBoard')
    use_sender_flag: bool | None = Field(default=None, alias='useSenderFlag')
    first_name: str | None = Field(default=None, alias='firstName')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    last_name: str | None = Field(default=None, alias='lastName')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    email_address: str | None = Field(default=None, alias='emailAddress')
    """
    From fields (first name, last name, email address) are required if useSenderFlag is false. Max length: 100;
    """
    subject: str | None = None
    """
     Max length: 200;
    """
    body: str | None = None
    copy_sender_flag: bool | None = Field(default=None, alias='copySenderFlag')
    tasks_flag: bool | None = Field(default=None, alias='tasksFlag')
    resource_records_flag: bool | None = Field(
        default=None, alias='resourceRecordsFlag'
    )
    external_contact_notifications: bool | None = Field(
        default=None, alias='externalContactNotifications'
    )
    internal_contact_notifications: bool | None = Field(
        default=None, alias='internalContactNotifications'
    )
    service_status: ServiceStatusReference | None = Field(
        default=None, alias='serviceStatus'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceSignoffCustomField(ConnectWiseModel):
    id: int | None = None
    sequence_number: float = Field(..., alias='sequenceNumber')
    display_section: Literal[
        'CustomerInformation',
        'Detail',
        'Expenses',
        'Configurations',
        'AdditionalSignOffFields',
        'InternalNotes',
        'Time',
        'Products',
        'Resolution',
        'Summary',
        'Tasks',
    ] = Field(..., alias='displaySection')
    user_defined_field: UserDefinedFieldReference | None = Field(
        default=None, alias='userDefinedField'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceSurveyQuestion(ConnectWiseModel):
    id: int | None = None
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    type: Literal['OpenEnded', 'Selection']
    question: str
    """
     Max length: 1000;
    """
    options: list[ServiceSurveyQuestionOption] | None = None
    include_flag: bool | None = Field(default=None, alias='includeFlag')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    no_answer_points: int | None = Field(default=None, alias='noAnswerPoints')
    survey_id: int | None = Field(default=None, alias='surveyId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTeam(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    leader: MemberReference | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    delete_notify_flag: bool | None = Field(default=None, alias='deleteNotifyFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTemplate(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    board: BoardReference | None = None
    type: ServiceTypeReference | None = None
    item: ServiceItemReference | None = None
    subtype: ServiceSubTypeReference | None = None
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    status: ServiceStatusReference | None = None
    source: ServiceSourceReference | None = None
    priority: PriorityReference | None = None
    team: ServiceTeamReference | None = None
    company: CompanyReference | None = None
    contact: ContactReference | None = None
    site: SiteReference | None = None
    assigned_notify_flag: bool | None = Field(default=None, alias='assignedNotifyFlag')
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    summary: str | None = None
    problem: str | None = None
    hours_budget: float | None = Field(default=None, alias='hoursBudget')
    internal_analysis: str | None = Field(default=None, alias='internalAnalysis')
    time_billable_flag: bool | None = Field(default=None, alias='timeBillableFlag')
    expense_billable_flag: bool | None = Field(
        default=None, alias='expenseBillableFlag'
    )
    purchase_order_number: str | None = Field(default=None, alias='purchaseOrderNumber')
    reference: str | None = None
    bill_complete_flag: bool | None = Field(default=None, alias='billComplete_Flag')
    bill_service_separately_flag: bool | None = Field(
        default=None, alias='billServiceSeparatelyFlag'
    )
    billing_amount: float | None = Field(default=None, alias='billingAmount')
    bill_unapproved_time_and_expenses_flag: bool | None = Field(
        default=None, alias='billUnapprovedTimeAndExpensesFlag'
    )
    override_flag: bool | None = Field(default=None, alias='overrideFlag')
    time_invoice_flag: bool | None = Field(default=None, alias='timeInvoiceFlag')
    expense_invoice_flag: bool | None = Field(default=None, alias='expenseInvoiceFlag')
    product_invoice_flag: bool | None = Field(default=None, alias='productInvoiceFlag')
    agreement: AgreementReference | None = None
    billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='billingMethod')
    severity: Literal['Low', 'Medium', 'High'] | None = None
    impact: Literal['Low', 'Medium', 'High'] | None = None
    assigned_by: MemberReference | None = Field(default=None, alias='assignedBy')
    schedule_days_before: int | None = Field(default=None, alias='scheduleDaysBefore')
    service_days_before: int | None = Field(default=None, alias='serviceDaysBefore')
    attach_schedule_to_new_service_flag: bool | None = Field(
        default=None, alias='attachScheduleToNewServiceFlag'
    )
    template_flag: bool | None = Field(default=None, alias='templateFlag')
    email_contact_flag: bool | None = Field(default=None, alias='emailContactFlag')
    email_resource_flag: bool | None = Field(default=None, alias='emailResourceFlag')
    email_cc_flag: bool | None = Field(default=None, alias='emailCCFlag')
    email_cc: str | None = Field(default=None, alias='emailCC')
    restrict_downpayment_flag: bool | None = Field(
        default=None, alias='restrictDownpaymentFlag'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ServiceTicketNote(ConnectWiseModel):
    id: int | None = None
    note_type: Literal['TicketNote', 'TimeEntryNote', 'MeetingNote'] | None = Field(
        default=None, alias='noteType'
    )
    ticket: TicketReference | None = None
    text: str | None = None
    is_markdown_flag: bool | None = Field(default=None, alias='isMarkdownFlag')
    detail_description_flag: bool | None = Field(
        default=None, alias='detailDescriptionFlag'
    )
    internal_analysis_flag: bool | None = Field(
        default=None, alias='internalAnalysisFlag'
    )
    resolution_flag: bool | None = Field(default=None, alias='resolutionFlag')
    time_start: str | None = Field(default=None, alias='timeStart')
    time_end: str | None = Field(default=None, alias='timeEnd')
    bundled_flag: bool | None = Field(default=None, alias='bundledFlag')
    merged_flag: bool | None = Field(default=None, alias='mergedFlag')
    issue_flag: bool | None = Field(default=None, alias='issueFlag')
    original_author: str | None = Field(default=None, alias='originalAuthor')
    member: MemberReference | None = None
    contact: ContactReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Skill(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    category: SkillCategoryReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SLAPriority(ConnectWiseModel):
    id: int | None = None
    priority: PriorityReference | None = None
    respond_hours: float | None = Field(default=None, alias='respondHours')
    respond_percent: int | None = Field(default=None, alias='respondPercent')
    plan_within: float | None = Field(default=None, alias='planWithin')
    plan_within_percent: int | None = Field(default=None, alias='planWithinPercent')
    resolution_hours: float | None = Field(default=None, alias='resolutionHours')
    resolution_percent: int | None = Field(default=None, alias='resolutionPercent')
    sla: SLAReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class StandardNote(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    contents: str
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class StandardNoteInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    contents: str | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SurveyQuestion(ConnectWiseModel):
    id: int | None = None
    survey: SurveyReference | None = None
    field_type: Literal[
        'TextArea',
        'Button',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] = Field(..., alias='fieldType')
    entry_type: Literal['Date', 'EntryField', 'List', 'Option'] = Field(
        ..., alias='entryType'
    )
    sequence_number: float = Field(..., alias='sequenceNumber')
    question: str
    """
     Max length: 1000;
    """
    number_of_decimals: int | None = Field(default=None, alias='numberOfDecimals')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SurveyQuestionValue(ConnectWiseModel):
    id: int | None = None
    survey: SurveyReference | None = None
    question: SurveyQuestionReference | None = None
    value: str
    """
     Max length: 1000;
    """
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    point_value: int | None = Field(default=None, alias='pointValue')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class SurveyResult(ConnectWiseModel):
    id: int | None = None
    ticket_id: int = Field(..., alias='ticketId')
    email_address: str | None = Field(default=None, alias='emailAddress')
    footer_response: str | None = Field(default=None, alias='footerResponse')
    contact_me_flag: bool | None = Field(default=None, alias='contactMeFlag')
    contact: ContactReference | None = None
    results: list[SurveyResultDetail] | None = None
    total_points: int | None = Field(default=None, alias='totalPoints')
    company: CompanyReference | None = None
    survey_id: int | None = Field(default=None, alias='surveyId')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxableExpenseTypeLevel(ConnectWiseModel):
    id: int | None = None
    tax_code_level: TaxCodeLevelReference | None = Field(
        default=None, alias='taxCodeLevel'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TaxableProductTypeLevel(TaxableExpenseTypeLevel):
    pass


class TaxableWorkRoleLevel(TaxableExpenseTypeLevel):
    pass


class TaxableXRefLevel(TaxableExpenseTypeLevel):
    pass


class Ticket(ConnectWiseModel):
    id: int | None = None
    summary: str
    """
     Max length: 100;
    """
    record_type: Literal[
        'ProjectIssue', 'ProjectTicket', 'ServiceTicket'
    ] | None = Field(default=None, alias='recordType')
    board: BoardReference | None = None
    status: ServiceStatusReference | None = None
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    company: CompanyReference | None = None
    site: SiteReference | None = None
    site_name: str | None = Field(default=None, alias='siteName')
    """
     Max length: 50;
    """
    address_line1: str | None = Field(default=None, alias='addressLine1')
    """
     Max length: 50;
    """
    address_line2: str | None = Field(default=None, alias='addressLine2')
    """
     Max length: 50;
    """
    city: str | None = None
    """
     Max length: 50;
    """
    state_identifier: str | None = Field(default=None, alias='stateIdentifier')
    """
     Max length: 50;
    """
    zip: str | None = None
    """
     Max length: 12;
    """
    country: CountryReference | None = None
    contact: ContactReference | None = None
    contact_name: str | None = Field(default=None, alias='contactName')
    """
     Max length: 62;
    """
    contact_phone_number: str | None = Field(default=None, alias='contactPhoneNumber')
    """
     Max length: 20;
    """
    contact_phone_extension: str | None = Field(
        default=None, alias='contactPhoneExtension'
    )
    """
     Max length: 15;
    """
    contact_email_address: str | None = Field(default=None, alias='contactEmailAddress')
    """
     Max length: 250;
    """
    type: ServiceTypeReference | None = None
    sub_type: ServiceSubTypeReference | None = Field(default=None, alias='subType')
    item: ServiceItemReference | None = None
    team: ServiceTeamReference | None = None
    owner: MemberReference | None = None
    priority: PriorityReference | None = None
    service_location: ServiceLocationReference | None = Field(
        default=None, alias='serviceLocation'
    )
    source: ServiceSourceReference | None = None
    required_date: datetime | None = Field(default=None, alias='requiredDate')
    budget_hours: float | None = Field(default=None, alias='budgetHours')
    opportunity: OpportunityReference | None = None
    agreement: AgreementReference | None = None
    severity: Literal['Low', 'Medium', 'High'] | None = None
    """
     Required On Updates;
    """
    impact: Literal['Low', 'Medium', 'High'] | None = None
    """
     Required On Updates;
    """
    external_x_ref: str | None = Field(default=None, alias='externalXRef')
    """
     Max length: 100;
    """
    po_number: str | None = Field(default=None, alias='poNumber')
    """
     Max length: 50;
    """
    knowledge_base_category_id: int | None = Field(
        default=None, alias='knowledgeBaseCategoryId'
    )
    knowledge_base_sub_category_id: int | None = Field(
        default=None, alias='knowledgeBaseSubCategoryId'
    )
    allow_all_clients_portal_view: bool | None = Field(
        default=None, alias='allowAllClientsPortalView'
    )
    customer_updated_flag: bool | None = Field(
        default=None, alias='customerUpdatedFlag'
    )
    automatic_email_contact_flag: bool | None = Field(
        default=None, alias='automaticEmailContactFlag'
    )
    automatic_email_resource_flag: bool | None = Field(
        default=None, alias='automaticEmailResourceFlag'
    )
    automatic_email_cc_flag: bool | None = Field(
        default=None, alias='automaticEmailCcFlag'
    )
    automatic_email_cc: str | None = Field(default=None, alias='automaticEmailCc')
    """
     Max length: 1000;
    """
    initial_description: str | None = Field(default=None, alias='initialDescription')
    """
    Only available for POST, will not be returned in the response.
    """
    initial_internal_analysis: str | None = Field(
        default=None, alias='initialInternalAnalysis'
    )
    """
    Only available for POST, will not be returned in the response.
    """
    initial_resolution: str | None = Field(default=None, alias='initialResolution')
    """
    Only available for POST, will not be returned in the response.
    """
    initial_description_from: str | None = Field(
        default=None, alias='initialDescriptionFrom'
    )
    contact_email_lookup: str | None = Field(default=None, alias='contactEmailLookup')
    process_notifications: bool | None = Field(
        default=None, alias='processNotifications'
    )
    """
    Can be set to false to skip notification processing when adding or updating a ticket (Defaults to True).
    """
    skip_callback: bool | None = Field(default=None, alias='skipCallback')
    closed_date: str | None = Field(default=None, alias='closedDate')
    closed_by: str | None = Field(default=None, alias='closedBy')
    closed_flag: bool | None = Field(default=None, alias='closedFlag')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    approved: bool | None = None
    estimated_expense_cost: float | None = Field(
        default=None, alias='estimatedExpenseCost'
    )
    estimated_expense_revenue: float | None = Field(
        default=None, alias='estimatedExpenseRevenue'
    )
    estimated_product_cost: float | None = Field(
        default=None, alias='estimatedProductCost'
    )
    estimated_product_revenue: float | None = Field(
        default=None, alias='estimatedProductRevenue'
    )
    estimated_time_cost: float | None = Field(default=None, alias='estimatedTimeCost')
    estimated_time_revenue: float | None = Field(
        default=None, alias='estimatedTimeRevenue'
    )
    billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='billingMethod')
    billing_amount: float | None = Field(default=None, alias='billingAmount')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    sub_billing_method: Literal[
        'ActualRates', 'FixedFee', 'NotToExceed', 'OverrideRate'
    ] | None = Field(default=None, alias='subBillingMethod')
    sub_billing_amount: float | None = Field(default=None, alias='subBillingAmount')
    sub_date_accepted: str | None = Field(default=None, alias='subDateAccepted')
    date_resolved: str | None = Field(default=None, alias='dateResolved')
    date_resplan: str | None = Field(default=None, alias='dateResplan')
    date_responded: str | None = Field(default=None, alias='dateResponded')
    resolve_minutes: int | None = Field(default=None, alias='resolveMinutes')
    res_plan_minutes: int | None = Field(default=None, alias='resPlanMinutes')
    respond_minutes: int | None = Field(default=None, alias='respondMinutes')
    is_in_sla: bool | None = Field(default=None, alias='isInSla')
    knowledge_base_link_id: int | None = Field(
        default=None, alias='knowledgeBaseLinkId'
    )
    resources: str | None = None
    parent_ticket_id: int | None = Field(default=None, alias='parentTicketId')
    has_child_ticket: bool | None = Field(default=None, alias='hasChildTicket')
    has_merged_child_ticket_flag: bool | None = Field(
        default=None, alias='hasMergedChildTicketFlag'
    )
    knowledge_base_link_type: Literal[
        'Activity',
        'ProjectIssue',
        'KnowledgeBaseArticle',
        'ProjectTicket',
        'ServiceTicket',
        'Time',
    ] | None = Field(default=None, alias='knowledgeBaseLinkType')
    bill_time: Literal['Billable', 'DoNotBill', 'NoCharge', 'NoDefault'] | None = Field(
        default=None, alias='billTime'
    )
    bill_expenses: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billExpenses')
    bill_products: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billProducts')
    predecessor_type: Literal['Ticket', 'Phase'] | None = Field(
        default=None, alias='predecessorType'
    )
    predecessor_id: int | None = Field(default=None, alias='predecessorId')
    predecessor_closed_flag: bool | None = Field(
        default=None, alias='predecessorClosedFlag'
    )
    lag_days: int | None = Field(default=None, alias='lagDays')
    lag_nonworking_days_flag: bool | None = Field(
        default=None, alias='lagNonworkingDaysFlag'
    )
    estimated_start_date: datetime | None = Field(
        default=None, alias='estimatedStartDate'
    )
    duration: int | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    sla: SLAReference | None = None
    sla_status: str | None = Field(default=None, alias='slaStatus')
    request_for_change_flag: bool | None = Field(
        default=None, alias='requestForChangeFlag'
    )
    currency: CurrencyReference | None = None
    merged_parent_ticket: TicketReference | None = Field(
        default=None, alias='mergedParentTicket'
    )
    integrator_tags: list[str] | None = Field(default=None, alias='integratorTags')
    info: dict[str, str] | None = Field(default=None, alias='_info')
    escalation_start_date_utc: str | None = Field(
        default=None, alias='escalationStartDateUTC'
    )
    escalation_level: int | None = Field(default=None, alias='escalationLevel')
    minutes_before_waiting: int | None = Field(
        default=None, alias='minutesBeforeWaiting'
    )
    responded_skipped_minutes: int | None = Field(
        default=None, alias='respondedSkippedMinutes'
    )
    resplan_skipped_minutes: int | None = Field(
        default=None, alias='resplanSkippedMinutes'
    )
    responded_hours: float | None = Field(default=None, alias='respondedHours')
    responded_by: str | None = Field(default=None, alias='respondedBy')
    resplan_hours: float | None = Field(default=None, alias='resplanHours')
    resplan_by: str | None = Field(default=None, alias='resplanBy')
    resolution_hours: float | None = Field(default=None, alias='resolutionHours')
    resolved_by: str | None = Field(default=None, alias='resolvedBy')
    minutes_waiting: int | None = Field(default=None, alias='minutesWaiting')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class TicketStopwatch(ConnectWiseModel):
    info: dict[str, str] | None = Field(default=None, alias='_info')
    agreement: AgreementReference | None = None
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    end_time: datetime | None = Field(default=None, alias='endTime')
    id: int | None = None
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    location_id: int | None = Field(default=None, alias='locationId')
    member: MemberReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    notes: str | None = None
    """
     Max length: 4000;
    """
    service_status: ServiceStatusReference | None = Field(
        default=None, alias='serviceStatus'
    )
    start_time: datetime | None = Field(default=None, alias='startTime')
    status: Literal['Reset', 'Running', 'Paused', 'Stopped']
    ticket: TicketReference | None = None
    ticket_mobile_guid: UUID | None = Field(default=None, alias='ticketMobileGuid')
    total_pause_time: int | None = Field(default=None, alias='totalPauseTime')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    show_notes_in_discussion_flag: bool | None = Field(
        default=None, alias='showNotesInDiscussionFlag'
    )
    show_notes_in_internal_flag: bool | None = Field(
        default=None, alias='showNotesInInternalFlag'
    )
    show_notes_in_resolution_flag: bool | None = Field(
        default=None, alias='showNotesInResolutionFlag'
    )
    email_notes_to_contact_flag: bool | None = Field(
        default=None, alias='emailNotesToContactFlag'
    )
    email_notes_to_resources_flag: bool | None = Field(
        default=None, alias='emailNotesToResourcesFlag'
    )


class TimeAccrualDetail(ConnectWiseModel):
    id: int | None = None
    accrual_type: Literal['Holiday', 'PTO', 'Sick', 'Vacation'] = Field(
        ..., alias='accrualType'
    )
    """
    Available types are: Holiday, PTO, Sick and Vacation.
    """
    start_year: int = Field(..., alias='startYear')
    end_year: int = Field(..., alias='endYear')
    hours: float
    time_accrual: TimeAccrualReference | None = Field(default=None, alias='timeAccrual')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TimeEntry(ConnectWiseModel):
    id: int | None = None
    company: CompanyReference | None = None
    charge_to_id: int | None = Field(default=None, alias='chargeToId')
    """
    If chargeToId is not specified, we asume you enter time against the company specified
    """
    charge_to_type: Literal[
        'ServiceTicket', 'ProjectTicket', 'ChargeCode', 'Activity'
    ] | None = Field(default=None, alias='chargeToType')
    """
    If chargeToId is not specified, we asume you enter time against the company specified
    """
    member: MemberReference | None = None
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    work_type: WorkTypeReference | None = Field(default=None, alias='workType')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    agreement: AgreementReference | None = None
    time_start: datetime = Field(..., alias='timeStart')
    time_end: datetime | None = Field(default=None, alias='timeEnd')
    hours_deduct: float | None = Field(default=None, alias='hoursDeduct')
    actual_hours: float | None = Field(default=None, alias='actualHours')
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    """
     Required On Updates;
    """
    notes: str | None = None
    internal_notes: str | None = Field(default=None, alias='internalNotes')
    add_to_detail_description_flag: bool | None = Field(
        default=None, alias='addToDetailDescriptionFlag'
    )
    add_to_internal_analysis_flag: bool | None = Field(
        default=None, alias='addToInternalAnalysisFlag'
    )
    add_to_resolution_flag: bool | None = Field(
        default=None, alias='addToResolutionFlag'
    )
    email_resource_flag: bool | None = Field(default=None, alias='emailResourceFlag')
    """
    This is an action flag. To update this value use the /service/tickets endpoint automaticEmailResourceFlag field
    """
    email_contact_flag: bool | None = Field(default=None, alias='emailContactFlag')
    """
    This is an action flag. To update this value use the /service/tickets endpoint automaticEmailContactFlag field
    """
    email_cc_flag: bool | None = Field(default=None, alias='emailCcFlag')
    """
    This is an action flag. To update this value use the /service/tickets endpoint automaticEmailCcFlag field
    """
    email_cc: str | None = Field(default=None, alias='emailCc')
    """
    To update this value use the /service/tickets endpoint automaticEmailCc field
    """
    hours_billed: float | None = Field(default=None, alias='hoursBilled')
    invoice_hours: float | None = Field(default=None, alias='invoiceHours')
    entered_by: str | None = Field(default=None, alias='enteredBy')
    date_entered: datetime | None = Field(default=None, alias='dateEntered')
    invoice: InvoiceReference | None = None
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    """
    This field may only be Updated, it is defaulted on Create
    """
    overage_rate: float | None = Field(default=None, alias='overageRate')
    agreement_hours: float | None = Field(default=None, alias='agreementHours')
    agreement_amount: float | None = Field(default=None, alias='agreementAmount')
    time_sheet: TimeSheetReference | None = Field(default=None, alias='timeSheet')
    status: Literal[
        'Open',
        'Rejected',
        'PendingApproval',
        'ErrorsCorrected',
        'PendingProjectApproval',
        'ApprovedByTierOne',
        'RejectBySecondTier',
        'ApprovedByTierTwo',
        'ReadyToBill',
        'Billed',
        'WrittenOff',
        'BilledAgreement',
    ] | None = None
    ticket: TicketReference | None = None
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class TimePeriod(ConnectWiseModel):
    id: int | None = None
    time_period_setup: TimePeriodSetupReference | None = Field(
        default=None, alias='timePeriodSetup'
    )
    period: int | None = None
    start_date: str | None = Field(default=None, alias='startDate')
    end_date: str | None = Field(default=None, alias='endDate')
    deadline_date: str | None = Field(default=None, alias='deadlineDate')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class TrackAction(ConnectWiseModel):
    id: int | None = None
    notify_type: Literal[
        'CreateActivity',
        'SendEmail',
        'AddToGroup',
        'AttachTrack',
        'ChangeCompanyStatus',
        'CreateServiceTicket',
    ] = Field(..., alias='notifyType')
    service_template: ServiceTemplateReference | None = Field(
        default=None, alias='serviceTemplate'
    )
    specific_member_to: MemberReference | None = Field(
        default=None, alias='specificMemberTo'
    )
    email_recipient: str | None = Field(default=None, alias='emailRecipient')
    """
     Max length: 250;
    """
    specific_member_from: MemberReference | None = Field(
        default=None, alias='specificMemberFrom'
    )
    email_from: str | None = Field(default=None, alias='emailFrom')
    """
     Max length: 250;
    """
    subject: str | None = None
    """
     Max length: 100;
    """
    notes: str | None = None
    activity_type: ActivityTypeReference | None = Field(
        default=None, alias='activityType'
    )
    activity_status: ActivityStatusReference | None = Field(
        default=None, alias='activityStatus'
    )
    company_status: CompanyStatusReference | None = Field(
        default=None, alias='companyStatus'
    )
    track: TrackReference | None = None
    attached_track: TrackReference | None = Field(default=None, alias='attachedTrack')
    group: GroupReference | None = None
    cc_contact: ContactReference | None = Field(default=None, alias='ccContact')
    bcc_contact: ContactReference | None = Field(default=None, alias='bccContact')
    days_to_execute: int | None = Field(default=None, alias='daysToExecute')
    notify_who: NotificationRecipientReference | None = Field(
        default=None, alias='notifyWho'
    )
    notify_from: NotificationRecipientReference | None = Field(
        default=None, alias='notifyFrom'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UserDefinedField(ConnectWiseModel):
    id: int | None = None
    """
    ID of the custom user defined field
    """
    pod_id: int = Field(..., alias='podId')
    """
    Id of the Pod where the custom field will be placed
    """
    caption: str
    """
    Field caption Max length: 25;
    """
    sequence_number: int = Field(..., alias='sequenceNumber')
    """
    Must be between 1 and 500.  This defines the order in which the custom fields will appear
    """
    screen_id: str | None = Field(default=None, alias='screenId')
    """
    Field ScreenID Max length: 25;
    """
    help_text: str | None = Field(default=None, alias='helpText')
    """
    Help text to accompany the custom field Max length: 1000;
    """
    field_type_identifier: Literal[
        'TextArea',
        'Button',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] = Field(..., alias='fieldTypeIdentifier')
    number_decimals: int | None = Field(default=None, alias='numberDecimals')
    """
    Only valid for Number or percent
    """
    entry_type_identifier: Literal[
        'Date', 'EntryField', 'List', 'Option'
    ] | None = Field(default=None, alias='entryTypeIdentifier')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    display_on_screen_flag: bool | None = Field(
        default=None, alias='displayOnScreenFlag'
    )
    read_only_flag: bool | None = Field(default=None, alias='readOnlyFlag')
    list_view_flag: bool | None = Field(default=None, alias='listViewFlag')
    """
    Denotes that this custom field is included on a list view
    """
    button_url: str | None = Field(default=None, alias='buttonUrl')
    """
    Only available with Button Field Type. Required when entryTypeIdentifier is button Max length: 1000;
    """
    options: list[UserDefinedFieldOption] | None = None
    business_unit_ids: list[int] | None = Field(default=None, alias='businessUnitIds')
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    add_all_business_units: bool | None = Field(
        default=None, alias='addAllBusinessUnits'
    )
    remove_all_business_units: bool | None = Field(
        default=None, alias='removeAllBusinessUnits'
    )
    add_all_locations: bool | None = Field(default=None, alias='addAllLocations')
    remove_all_locations: bool | None = Field(default=None, alias='removeAllLocations')
    date_created: datetime | None = Field(default=None, alias='dateCreated')
    """
    Date in UTC the custom field was created
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class UserDefinedFieldInfo(ConnectWiseModel):
    id: int | None = None
    """
    ID of the custom user defined field
    """
    pod_id: int | None = Field(default=None, alias='podId')
    """
    Id of the Pod where the custom field will be placed
    """
    caption: str | None = None
    """
    Field caption
    """
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    """
    Must be between 1 and 500.  This defines the order in which the custom fields will appear
    """
    help_text: str | None = Field(default=None, alias='helpText')
    """
    Help text to accompany the custom field
    """
    field_type_identifier: Literal[
        'TextArea',
        'Button',
        'Currency',
        'Date',
        'Hyperlink',
        'IPAddress',
        'Checkbox',
        'Number',
        'Percent',
        'Text',
        'Password',
    ] | None = Field(default=None, alias='fieldTypeIdentifier')
    number_decimals: int | None = Field(default=None, alias='numberDecimals')
    """
    Only valid for Number or percent
    """
    entry_type_identifier: Literal[
        'Date', 'EntryField', 'List', 'Option'
    ] | None = Field(default=None, alias='entryTypeIdentifier')
    required_flag: bool | None = Field(default=None, alias='requiredFlag')
    display_on_screen_flag: bool | None = Field(
        default=None, alias='displayOnScreenFlag'
    )
    read_only_flag: bool | None = Field(default=None, alias='readOnlyFlag')
    list_view_flag: bool | None = Field(default=None, alias='listViewFlag')
    """
    Denotes that this custom field is included on a list view
    """
    button_url: str | None = Field(default=None, alias='buttonUrl')
    """
    Only available with Button Field Type. Required when entryTypeIdentifier is button
    """
    options: list[UserDefinedFieldOption] | None = None
    business_unit_ids: list[int] | None = Field(default=None, alias='businessUnitIds')
    """
    List of business unit ids using custom field
    """
    location_ids: list[int] | None = Field(default=None, alias='locationIds')
    """
    List of locations ids using custom field
    """
    date_created: str | None = Field(default=None, alias='dateCreated')
    """
    Date in UTC the custom field was created
    """
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WarehouseBin(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 50;
    """
    warehouse: WarehouseReference | None = None
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    min_quantity: float | None = Field(default=None, alias='minQuantity')
    max_quantity: float | None = Field(default=None, alias='maxQuantity')
    overflow_bin: WarehouseBinReference | None = Field(
        default=None, alias='overflowBin'
    )
    manager: MemberReference | None = None
    length: float | None = None
    width: float | None = None
    height: float | None = None
    weight: float | None = None
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    quantity_on_hand: int | None = Field(default=None, alias='quantityOnHand')
    company: CompanyReference | None = None
    transfer_bin: WarehouseBinReference | None = Field(
        default=None, alias='transferBin'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WarehouseBinInfo(ConnectWiseModel):
    id: int | None = None
    name: str | None = None
    warehouse: WarehouseReference | None = None
    inactive_flag: bool | None = Field(default=None, alias='inactiveFlag')
    default_flag: bool | None = Field(default=None, alias='defaultFlag')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class Workflow(ConnectWiseModel):
    id: int | None = None
    name: str
    """
     Max length: 100;
    """
    table_type: WorkflowTableTypeReference | None = Field(
        default=None, alias='tableType'
    )
    location: SystemLocationReference | None = None
    department: SystemDepartmentReference | None = None
    activate_flag: bool | None = Field(default=None, alias='activateFlag')
    """
    Batches can not be turned on until after the workflow is created and it has atleast one event associated with it
    """
    batch_interval: int | None = Field(default=None, alias='batchInterval')
    batch_frequency_unit: Literal['Minutes', 'Hours', 'Days'] | None = Field(
        default=None, alias='batchFrequencyUnit'
    )
    """
    If not specified, defaults to Minutes. Months is not supported as month length varies
    """
    batch_last_ran: datetime | None = Field(default=None, alias='batchLastRan')
    batch_schedule: Literal[
        'AnyTime', 'MyCompanyOfficeHours', 'SlaHours'
    ] | None = Field(default=None, alias='batchSchedule')
    """
    If activateFlag is true, batchSchedule is required
    """
    board: BoardReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkRoleExemption(ConnectWiseModel):
    id: int | None = None
    work_role: WorkRoleReference = Field(..., alias='workRole')
    taxable_levels: list[int] | None = Field(default=None, alias='taxableLevels')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class WorkRoleLocation(ConnectWiseModel):
    id: int | None = None
    location: SystemLocationReference | None = None
    hourly_rate: float | None = Field(default=None, alias='hourlyRate')
    work_role: WorkRoleReference | None = Field(default=None, alias='workRole')
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BulkResult(ConnectWiseModel):
    payload: list[ResultInfo] | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class BundleResult(ConnectWiseModel):
    sequence_number: int | None = Field(default=None, alias='sequenceNumber')
    resource_type: str | None = Field(default=None, alias='resourceType')
    entities: list[IRestIdentifiedItem] | None = None
    count: int | None = None
    version: str | None = None
    success: bool | None = None
    status_code: int | None = Field(default=None, alias='statusCode')
    error: ErrorResponseMessage | None = None


class BundleResultsCollection(ConnectWiseModel):
    results: list[BundleResult] | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class ExpenseEntry(ConnectWiseModel):
    id: int | None = None
    expense_report: ExpenseReportReference | None = Field(
        default=None, alias='expenseReport'
    )
    company: CompanyReference | None = None
    charge_to_id: int | None = Field(default=None, alias='chargeToId')
    charge_to_type: Literal[
        'ServiceTicket', 'ProjectTicket', 'ChargeCode', 'Activity'
    ] | None = Field(default=None, alias='chargeToType')
    """
    Gets or sets
                company or chargeToType is required.
    """
    type: ExpenseTypeReference | None = None
    member: MemberReference | None = None
    payment_method: PaymentMethodReference | None = Field(
        default=None, alias='paymentMethod'
    )
    classification: ClassificationReference | None = None
    amount: float
    billable_option: Literal[
        'Billable', 'DoNotBill', 'NoCharge', 'NoDefault'
    ] | None = Field(default=None, alias='billableOption')
    date: datetime
    location_id: int | None = Field(default=None, alias='locationId')
    business_unit_id: int | None = Field(default=None, alias='businessUnitId')
    notes: str | None = None
    agreement: AgreementReference | None = None
    invoice_amount: float | None = Field(default=None, alias='invoiceAmount')
    mobile_guid: UUID | None = Field(default=None, alias='mobileGuid')
    taxes: list[ExpenseTax] | None = None
    invoice: InvoiceReference | None = None
    currency: CurrencyReference | None = None
    status: Literal[
        'Open',
        'Rejected',
        'PendingApproval',
        'ErrorsCorrected',
        'PendingProjectApproval',
        'ApprovedByTierOne',
        'RejectBySecondTier',
        'ApprovedByTierTwo',
        'ReadyToBill',
        'Billed',
        'WrittenOff',
        'BilledAgreement',
    ] | None = None
    bill_amount: float | None = Field(default=None, alias='billAmount')
    agreement_amount: float | None = Field(default=None, alias='agreementAmount')
    odometer_start: float | None = Field(default=None, alias='odometerStart')
    odometer_end: float | None = Field(default=None, alias='odometerEnd')
    ticket: TicketReference | None = None
    project: ProjectReference | None = None
    phase: ProjectPhaseReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')
    custom_fields: list[CustomFieldValue] | None = Field(
        default=None, alias='customFields'
    )


class Forecast(ConnectWiseModel):
    id: int | None = None
    forecast_items: list[ForecastItem] | None = Field(
        default=None, alias='forecastItems'
    )
    product_revenue: ProductRevenueReference | None = Field(
        default=None, alias='productRevenue'
    )
    service_revenue: ServiceRevenueReference | None = Field(
        default=None, alias='serviceRevenue'
    )
    agreement_revenue: AgreementRevenueReference | None = Field(
        default=None, alias='agreementRevenue'
    )
    time_revenue: TimeRevenueReference | None = Field(default=None, alias='timeRevenue')
    expense_revenue: ExpenseRevenueReference | None = Field(
        default=None, alias='expenseRevenue'
    )
    forecast_revenue_totals: ForecastRevenueReference | None = Field(
        default=None, alias='forecastRevenueTotals'
    )
    inclusive_revenue_totals: InclusiveRevenueReference | None = Field(
        default=None, alias='inclusiveRevenueTotals'
    )
    recurring_total: float | None = Field(default=None, alias='recurringTotal')
    won_revenue: WonRevenueReference | None = Field(default=None, alias='wonRevenue')
    lost_revenue: LostRevenueReference | None = Field(default=None, alias='lostRevenue')
    open_revenue: OpenRevenueReference | None = Field(default=None, alias='openRevenue')
    other_revenue1: Other1RevenueReference | None = Field(
        default=None, alias='otherRevenue1'
    )
    other_revenue2: Other2RevenueReference | None = Field(
        default=None, alias='otherRevenue2'
    )
    sales_tax_revenue: float | None = Field(default=None, alias='salesTaxRevenue')
    forecast_total_with_taxes: float | None = Field(
        default=None, alias='forecastTotalWithTaxes'
    )
    expected_probability: int | None = Field(default=None, alias='expectedProbability')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    currency: CurrencyReference | None = None
    info: dict[str, str] | None = Field(default=None, alias='_info')


class GLExportAdjustmentTransaction(ConnectWiseModel):
    id: str | None = None
    document_type: str | None = Field(default=None, alias='documentType')
    document_date: str | None = Field(default=None, alias='documentDate')
    gl_type_id: str | None = Field(default=None, alias='glTypeID')
    account_number: str | None = Field(default=None, alias='accountNumber')
    memo: str | None = None
    gl_class: str | None = Field(default=None, alias='glClass')
    adjustment_description: str | None = Field(
        default=None, alias='adjustmentDescription'
    )
    adjustment_detail: list[GLExportAdjustmentTransactionDetail] | None = Field(
        default=None, alias='adjustmentDetail'
    )


class GLExportExpense(ConnectWiseModel):
    id: int | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    document_type: str | None = Field(default=None, alias='documentType')
    ap_account_number: str | None = Field(default=None, alias='apAccountNumber')
    ap_class: str | None = Field(default=None, alias='apClass')
    account_number: str | None = Field(default=None, alias='accountNumber')
    gl_class: str | None = Field(default=None, alias='glClass')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    memo: str | None = None
    description: str | None = None
    period_start_date: str | None = Field(default=None, alias='periodStartDate')
    period_end_date: str | None = Field(default=None, alias='periodEndDate')
    member: MemberReference | None = None
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    company: CompanyReference | None = None
    company_account_number: str | None = Field(
        default=None, alias='companyAccountNumber'
    )
    project: ProjectReference | None = None
    currency: CurrencyReference | None = None
    total: float | None = None
    offset: GLExportExpenseOffset | None = None


class GLExportPurchaseTransaction(ConnectWiseModel):
    id: str | None = None
    document_date: str | None = Field(default=None, alias='documentDate')
    document_number: str | None = Field(default=None, alias='documentNumber')
    description: str | None = None
    memo: str | None = None
    ap_account_number: str | None = Field(default=None, alias='apAccountNumber')
    purchase_date: str | None = Field(default=None, alias='purchaseDate')
    company: CompanyReference | None = None
    company_type: CompanyTypeReference | None = Field(default=None, alias='companyType')
    contact: ContactReference | None = None
    site: SiteReference | None = None
    purchase_class: str | None = Field(default=None, alias='purchaseClass')
    freight_amount: float | None = Field(default=None, alias='freightAmount')
    freight_packing_slip: str | None = Field(default=None, alias='freightPackingSlip')
    packing_slip: str | None = Field(default=None, alias='packingSlip')
    dropship_flag: bool | None = Field(default=None, alias='dropshipFlag')
    currency: CurrencyReference | None = None
    total: float | None = None
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    billing_terms_xref: str | None = Field(default=None, alias='billingTermsXref')
    due_days: int | None = Field(default=None, alias='dueDays')
    vendor_number: str | None = Field(default=None, alias='vendorNumber')
    vendor_account_number: str | None = Field(default=None, alias='vendorAccountNumber')
    vendor_invoice_date: str | None = Field(default=None, alias='vendorInvoiceDate')
    vendor_invoice_number: str | None = Field(default=None, alias='vendorInvoiceNumber')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    city_tax_xref: str | None = Field(default=None, alias='cityTaxXref')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_company_account_number: str | None = Field(
        default=None, alias='shipToCompanyAccountNumber'
    )
    ship_to_company_type: CompanyTypeReference | None = Field(
        default=None, alias='shipToCompanyType'
    )
    ship_to_contact: ContactReference | None = Field(
        default=None, alias='shipToContact'
    )
    ship_to_site: SiteReference | None = Field(default=None, alias='shipToSite')
    ship_to_tax_group: str | None = Field(default=None, alias='shipToTaxGroup')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    tax_group_rate: float | None = Field(default=None, alias='taxGroupRate')
    use_avalara_tax_flag: bool | None = Field(default=None, alias='useAvalaraTaxFlag')
    purchase_header_tax_group: str | None = Field(
        default=None, alias='purchaseHeaderTaxGroup'
    )
    purchase_header_taxable_flag: bool | None = Field(
        default=None, alias='purchaseHeaderTaxableFlag'
    )
    purchase_header_freight_taxable_flag: bool | None = Field(
        default=None, alias='purchaseHeaderFreightTaxableFlag'
    )
    tax_levels: list[GLExportPurchaseTransactionTaxLevel] | None = Field(
        default=None, alias='taxLevels'
    )
    purchase_detail: list[GLExportPurchaseTransactionDetail] | None = Field(
        default=None, alias='purchaseDetail'
    )
    purchase_detail_tax: list[GLExportPurchaseTransactionDetailTax] | None = Field(
        default=None, alias='purchaseDetailTax'
    )


class GLExportTransaction(ConnectWiseModel):
    id: int | None = None
    gl_class: str | None = Field(default=None, alias='glClass')
    gl_type_id: str | None = Field(default=None, alias='glTypeId')
    document_date: str | None = Field(default=None, alias='documentDate')
    document_number: str | None = Field(default=None, alias='documentNumber')
    document_type: str | None = Field(default=None, alias='documentType')
    memo: str | None = None
    description: str | None = None
    attention: str | None = None
    sales_territory: str | None = Field(default=None, alias='salesTerritory')
    company: CompanyReference | None = None
    company_type: CompanyTypeReference | None = Field(default=None, alias='companyType')
    company_account_number: str | None = Field(
        default=None, alias='companyAccountNumber'
    )
    site: SiteReference | None = None
    billing_terms: BillingTermsReference | None = Field(
        default=None, alias='billingTerms'
    )
    billing_terms_xref: str | None = Field(default=None, alias='billingTermsXref')
    due_days: int | None = Field(default=None, alias='dueDays')
    due_date: str | None = Field(default=None, alias='dueDate')
    email_delivery_flag: bool | None = Field(default=None, alias='emailDeliveryFlag')
    print_delivery_flag: bool | None = Field(default=None, alias='printDeliveryFlag')
    agreement_pre_payment_flag: bool | None = Field(
        default=None, alias='agreementPrePaymentFlag'
    )
    account_number: str | None = Field(default=None, alias='accountNumber')
    billing_type: str | None = Field(default=None, alias='billingType')
    gl_entry_ids: str | None = Field(default=None, alias='glEntryIds')
    purchase_order: PurchaseOrderReference | None = Field(
        default=None, alias='purchaseOrder'
    )
    project: ProjectReference | None = None
    currency: CurrencyReference | None = None
    total: float | None = None
    sales_rep_id: str | None = Field(default=None, alias='salesRepId')
    sales_rep_name: str | None = Field(default=None, alias='salesRepName')
    taxable: bool | None = None
    taxable_total: float | None = Field(default=None, alias='taxableTotal')
    tax_code: TaxCodeReference | None = Field(default=None, alias='taxCode')
    tax_group_rate: float | None = Field(default=None, alias='taxGroupRate')
    piggy_back_flag: bool | None = Field(default=None, alias='piggyBackFlag')
    tax_account_number: str | None = Field(default=None, alias='taxAccountNumber')
    sales_tax: float | None = Field(default=None, alias='salesTax')
    state_tax: float | None = Field(default=None, alias='stateTax')
    county_tax: float | None = Field(default=None, alias='countyTax')
    city_tax: float | None = Field(default=None, alias='cityTax')
    taxable_amount1: float | None = Field(default=None, alias='taxableAmount1')
    taxable_amount2: float | None = Field(default=None, alias='taxableAmount2')
    taxable_amount3: float | None = Field(default=None, alias='taxableAmount3')
    taxable_amount4: float | None = Field(default=None, alias='taxableAmount4')
    taxable_amount5: float | None = Field(default=None, alias='taxableAmount5')
    tax_agency_xref: str | None = Field(default=None, alias='taxAgencyXref')
    state_tax_xref: str | None = Field(default=None, alias='stateTaxXref')
    county_tax_xref: str | None = Field(default=None, alias='countyTaxXref')
    tax_id: str | None = Field(default=None, alias='taxId')
    tax_dp_applied_flag: bool | None = Field(default=None, alias='taxDpAppliedFlag')
    use_avalara_flag: bool | None = Field(default=None, alias='useAvalaraFlag')
    send_avalara_tax_flag: bool | None = Field(default=None, alias='sendAvalaraTaxFlag')
    ship_to_company: CompanyReference | None = Field(
        default=None, alias='shipToCompany'
    )
    ship_to_company_account_number: str | None = Field(
        default=None, alias='shipToCompanyAccountNumber'
    )
    ship_to_company_type: CompanyTypeReference | None = Field(
        default=None, alias='shipToCompanyType'
    )
    ship_to_tax_id: str | None = Field(default=None, alias='shipToTaxId')
    ship_site: SiteReference | None = Field(default=None, alias='shipSite')
    ship_contact: str | None = Field(default=None, alias='shipContact')
    detail: list[GLExportTransactionDetail] | None = None
    tax_levels: list[GLExportTransactionTaxLevel] | None = Field(
        default=None, alias='taxLevels'
    )


class InvoiceInfo(ConnectWiseModel):
    id: int | None = None
    invoice: Invoice | None = None
    invoice_template: InvoiceTemplate | None = Field(
        default=None, alias='invoiceTemplate'
    )
    products: list[ProductItem] | None = None
    bundled_components_info: list[ProductComponent] | None = Field(
        default=None, alias='bundledComponentsInfo'
    )
    expenses: list[ExpenseEntry] | None = None
    time_entries: list[TimeEntry] | None = Field(default=None, alias='timeEntries')
    logo: DocumentInfo | None = None
    billing_setup: BillingSetup | None = Field(default=None, alias='billingSetup')
    agreement_billing_info: list[AgreementBillingInfo] | None = Field(
        default=None, alias='agreementBillingInfo'
    )
    info: dict[str, str] | None = Field(default=None, alias='_info')


class MemberDeactivation(ConnectWiseModel):
    activity: MemberDeactivationSalesActivity | None = None
    service_team: MemberDeactivationServiceTeam | None = Field(
        default=None, alias='serviceTeam'
    )
    company_team: list[MemberDeactivationCompanyTeam] | None = Field(
        default=None, alias='companyTeam'
    )
    """
    A list of customers for which the member holds a team role
    """
    workflow_email: MemberDeactivationWorkflow | None = Field(
        default=None, alias='workflowEmail'
    )
    service_status_workflow: list[MemberDeactivationStatusWorkflow] | None = Field(
        default=None, alias='serviceStatusWorkflow'
    )
    ticket_template: MemberDeactivationServiceTemplate | None = Field(
        default=None, alias='ticketTemplate'
    )
    opportunity: MemberDeactivationOpportunity | None = None
    sales_team: MemberDeactivationSalesTeam | None = Field(
        default=None, alias='salesTeam'
    )
    project_manager: MemberDeactivationProjectManager | None = Field(
        default=None, alias='projectManager'
    )
    project_time_approver: MemberDeactivationProjectManager | None = Field(
        default=None, alias='projectTimeApprover'
    )
    project_expense_approver: MemberDeactivationProjectManager | None = Field(
        default=None, alias='projectExpenseApprover'
    )
    knowledge_base_article: MemberDeactivationKnowledgebaseArticle | None = Field(
        default=None, alias='knowledgeBaseArticle'
    )
    my_company_president: MemberDeactivationMyCompanyPresidentRole | None = Field(
        default=None, alias='myCompanyPresident'
    )
    my_company_coo: MemberDeactivationMyCompanyCOORole | None = Field(
        default=None, alias='myCompanyCOO'
    )
    my_company_controller: MemberDeactivationMyCompanyControllerRole | None = Field(
        default=None, alias='myCompanyController'
    )
    my_company_dispatch: MemberDeactivationMyCompanyDispatchRole | None = Field(
        default=None, alias='myCompanyDispatch'
    )
    my_company_service_manager: MemberDeactivationMyCompanyServiceManagerRole | None = (
        Field(default=None, alias='myCompanyServiceManager')
    )
    my_company_duty_manager_role: MemberDeactivationMyCompanyDutyManagerRole | None = (
        Field(default=None, alias='myCompanyDutyManagerRole')
    )
    department_manager: MemberDeactivationDepartmentMananager | None = Field(
        default=None, alias='departmentManager'
    )
    dispatch_member: MemberDeactivationDispatchMember | None = Field(
        default=None, alias='dispatchMember'
    )
    service_manager: MemberDeactivationServiceManger | None = Field(
        default=None, alias='serviceManager'
    )
    duty_manager: MemberDeactivationDutyManager | None = Field(
        default=None, alias='dutyManager'
    )
    send_from_email_notify: MemberDeactivationSendFromEmailNotify | None = Field(
        default=None, alias='sendFromEmailNotify'
    )
    delete_open_time_sheets_flag: bool | None = Field(
        default=None, alias='deleteOpenTimeSheetsFlag'
    )
    """
    By default, this is set to false
                If there is any open timesheets, system will return error message
                that there is open timesheets still attached to this member
                If user would like to delete member with open timesheets, they can set this boolean to TRUE
                System will delete member and any associated open timesheets
    """


class GLExport(ConnectWiseModel):
    export_settings: GLExportSettings | None = Field(
        default=None, alias='exportSettings'
    )
    vendors: list[GLExportVendor] | None = None
    customers: list[GLExportCustomer] | None = None
    transactions: list[GLExportTransaction] | None = None
    expenses: list[GLExportExpense] | None = None
    expense_bills: list[GLExportExpenseBill] | None = Field(
        default=None, alias='expenseBills'
    )
    purchase_transactions: list[GLExportPurchaseTransaction] | None = Field(
        default=None, alias='purchaseTransactions'
    )
    adjustment_transactions: list[GLExportAdjustmentTransaction] | None = Field(
        default=None, alias='adjustmentTransactions'
    )
    inventory_transfers: list[GLExportInventoryTransfer] | None = Field(
        default=None, alias='inventoryTransfers'
    )


Manager.model_rebuild()
