from typing import Any

from pyconnectwise.endpoints.base.connectwise_endpoint import ConnectWiseEndpoint
from pyconnectwise.endpoints.manage.SystemWorkflowsIdEventsIdActionsCountEndpoint import \
    SystemWorkflowsIdEventsIdActionsCountEndpoint
from pyconnectwise.endpoints.manage.SystemWorkflowsIdEventsIdActionsIdEndpoint import \
    SystemWorkflowsIdEventsIdActionsIdEndpoint
from pyconnectwise.interfaces import IDeleteable, IGettable, IPaginateable, IPatchable, IPostable, IPuttable
from pyconnectwise.models.manage import WorkflowAction
from pyconnectwise.responses.paginated_response import PaginatedResponse
from pyconnectwise.types import JSON, ConnectWiseAutomateRequestParams, ConnectWiseManageRequestParams, PatchRequestData


class SystemWorkflowsIdEventsIdActionsEndpoint(
    ConnectWiseEndpoint,
    IGettable[list[WorkflowAction], ConnectWiseManageRequestParams],
    IPostable[WorkflowAction, ConnectWiseManageRequestParams],
    IPaginateable[WorkflowAction, ConnectWiseManageRequestParams],
):
    def __init__(self, client, parent_endpoint=None):
        ConnectWiseEndpoint.__init__(self, client, "actions", parent_endpoint=parent_endpoint)
        IGettable.__init__(self, list[WorkflowAction])
        IPostable.__init__(self, WorkflowAction)
        IPaginateable.__init__(self, WorkflowAction)

        self.count = self._register_child_endpoint(
            SystemWorkflowsIdEventsIdActionsCountEndpoint(client, parent_endpoint=self)
        )

    def id(self, id: int) -> SystemWorkflowsIdEventsIdActionsIdEndpoint:
        """
        Sets the ID for this endpoint and returns an initialized SystemWorkflowsIdEventsIdActionsIdEndpoint object to move down the chain.

        Parameters:
            id (int): The ID to set.
        Returns:
            SystemWorkflowsIdEventsIdActionsIdEndpoint: The initialized SystemWorkflowsIdEventsIdActionsIdEndpoint object.
        """
        child = SystemWorkflowsIdEventsIdActionsIdEndpoint(self.client, parent_endpoint=self)
        child._id = id
        return child

    def paginated(
        self, page: int, page_size: int, params: ConnectWiseManageRequestParams | None = None
    ) -> PaginatedResponse[WorkflowAction]:
        """
        Performs a GET request against the /system/workflows/{id}/events/{id}/actions endpoint and returns an initialized PaginatedResponse object.

        Parameters:
            page (int): The page number to request.
            page_size (int): The number of results to return per page.
            params (dict[str, int | str]): The parameters to send in the request query string.
        Returns:
            PaginatedResponse[WorkflowAction]: The initialized PaginatedResponse object.
        """
        if params:
            params["page"] = page
            params["pageSize"] = page_size
        else:
            params = {"page": page, "pageSize": page_size}
        return PaginatedResponse(
            super()._make_request("GET", params=params), WorkflowAction, self, page, page_size, params
        )

    def get(
        self, data: JSON | None = None, params: ConnectWiseManageRequestParams | None = None
    ) -> list[WorkflowAction]:
        """
        Performs a GET request against the /system/workflows/{id}/events/{id}/actions endpoint.

        Parameters:
            data (dict[str, Any]): The data to send in the request body.
            params (dict[str, int | str]): The parameters to send in the request query string.
        Returns:
            list[WorkflowAction]: The parsed response data.
        """
        return self._parse_many(WorkflowAction, super()._make_request("GET", data=data, params=params).json())

    def post(self, data: JSON | None = None, params: ConnectWiseManageRequestParams | None = None) -> WorkflowAction:
        """
        Performs a POST request against the /system/workflows/{id}/events/{id}/actions endpoint.

        Parameters:
            data (dict[str, Any]): The data to send in the request body.
            params (dict[str, int | str]): The parameters to send in the request query string.
        Returns:
            WorkflowAction: The parsed response data.
        """
        return self._parse_one(WorkflowAction, super()._make_request("POST", data=data, params=params).json())
