from typing import Any

from pyconnectwise.endpoints.automate.ScriptsIdCopyEndpoint import ScriptsIdCopyEndpoint
from pyconnectwise.endpoints.base.connectwise_endpoint import ConnectWiseEndpoint
from pyconnectwise.interfaces import IDeleteable, IGettable, IPaginateable, IPatchable, IPostable, IPuttable
from pyconnectwise.models.automate import AutomateScript
from pyconnectwise.responses.paginated_response import PaginatedResponse
from pyconnectwise.types import JSON, ConnectWiseAutomateRequestParams, ConnectWiseManageRequestParams, PatchRequestData


class ScriptsIdEndpoint(
    ConnectWiseEndpoint,
    IGettable[AutomateScript, ConnectWiseAutomateRequestParams],
    IPuttable[AutomateScript, ConnectWiseAutomateRequestParams],
):
    def __init__(self, client, parent_endpoint=None):
        ConnectWiseEndpoint.__init__(self, client, "{id}", parent_endpoint=parent_endpoint)
        IGettable.__init__(self, AutomateScript)
        IPuttable.__init__(self, AutomateScript)

        self.copy = self._register_child_endpoint(ScriptsIdCopyEndpoint(client, parent_endpoint=self))

    def get(self, data: JSON | None = None, params: ConnectWiseAutomateRequestParams | None = None) -> AutomateScript:
        """
        Performs a GET request against the /Scripts/{id} endpoint.

        Parameters:
            data (dict[str, Any]): The data to send in the request body.
            params (dict[str, int | str]): The parameters to send in the request query string.
        Returns:
            AutomateScript: The parsed response data.
        """
        return self._parse_one(AutomateScript, super()._make_request("GET", data=data, params=params).json())

    def put(self, data: JSON | None = None, params: ConnectWiseAutomateRequestParams | None = None) -> AutomateScript:
        """
        Performs a PUT request against the /Scripts/{id} endpoint.

        Parameters:
            data (dict[str, Any]): The data to send in the request body.
            params (dict[str, int | str]): The parameters to send in the request query string.
        Returns:
            AutomateScript: The parsed response data.
        """
        return self._parse_one(AutomateScript, super()._make_request("PUT", data=data, params=params).json())

    def delete(self, data: JSON | None = None, params: ConnectWiseAutomateRequestParams | None = None) -> None:
        """
        Performs a DELETE request against the /Scripts/{id} endpoint.

        Parameters:
            data (dict[str, Any]): The data to send in the request body.
            params (dict[str, int | str]): The parameters to send in the request query string.
        """
        super()._make_request("DELETE", data=data, params=params)
