# loading snakefile variables
input = snakemake@input$md
outdir = dirname(snakemake@output[[1]])
templatedir = snakemake@params$template_dir
# read the knit_meta() output generated by knit.R
# which is a must for interactive plots (js libraries)
knitmeta = readRDS(sub(input,
    pattern = ".md$",
    replacement = ".knitmeta.RDS"))
source(file.path(templatedir, "outputLook.R"))
# expand css path
cssind  <- which(optionsRender$rmarkdown$pandoc$args=="--css")+1
csspath <- optionsRender$rmarkdown$pandoc$args[cssind]
# remove the redundant 'template/' prefix
csspath = sub(x = csspath, pattern = '^template/', replacement = '')
csspath <- file.path(templatedir, csspath)
optionsRender$rmarkdown$pandoc$args[cssind] = csspath
# add path for regular markdown figures
optionsRender$rmarkdown$pandoc$args =
	c(optionsRender$rmarkdown$pandoc$args,
		paste0("--resource-path=", getwd(), ":",
			file.path(getwd(), dirname(input))))
# custom title for each html doc
optionsRender$rmarkdown$pandoc$args =
	c(optionsRender$rmarkdown$pandoc$args,
		paste0("--metadata=pagetitle:",
        	sub("\\.md$", "", basename(input))))

# generate the html file
suppressWarnings(suppressMessages({
rmarkdown::render(input,
	output_format = optionsRender$rmarkdown,
	output_dir = outdir, quiet = TRUE,
	knit_meta = knitmeta)
}))

html_outfile = sub(pattern = ".md$", replacement = ".html",
	file.path(outdir, basename(input)))
# saving return code to a variable to reduce output ('[1] TRUE' lines)
retcode = system(sprintf("sed -i.bak \"s#\\(navbar-brand.*\\)index.html#\\1%s#g\" %s",
	snakemake@params$index_html, html_outfile))
bakfile = sprintf("%s.bak", html_outfile)
if(file.exists(bakfile)){
	retcode = file.remove(bakfile)
}
