"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const cloud9_generated_1 = require("../lib/cloud9.generated");
/**
 * A Cloud9 Environment with Amazon EC2
 * @resource AWS::Cloud9::EnvironmentEC2
 */
class Ec2Environment extends cdk.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        this.vpc = props.vpc;
        if (!props.subnetSelection && this.vpc.publicSubnets.length === 0) {
            throw new Error('no subnetSelection specified and no public subnet found in the vpc, please specify subnetSelection');
        }
        const vpcSubnets = (_a = props.subnetSelection) !== null && _a !== void 0 ? _a : { subnetType: ec2.SubnetType.PUBLIC };
        const c9env = new cloud9_generated_1.CfnEnvironmentEC2(this, 'Resource', {
            name: props.ec2EnvironmentName,
            description: props.description,
            instanceType: (_c = (_b = props.instanceType) === null || _b === void 0 ? void 0 : _b.toString()) !== null && _c !== void 0 ? _c : ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO).toString(),
            subnetId: this.vpc.selectSubnets(vpcSubnets).subnetIds[0],
        });
        this.environmentId = c9env.ref;
        this.ec2EnvironmentArn = c9env.getAtt('Arn').toString();
        this.ec2EnvironmentName = c9env.getAtt('Name').toString();
        this.ideUrl = `https://${this.stack.region}.console.aws.amazon.com/cloud9/ide/${this.environmentId}`;
    }
    /**
     * import from EnvironmentEc2Name
     */
    static fromEc2EnvironmentName(scope, id, ec2EnvironmentName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.ec2EnvironmentName = ec2EnvironmentName;
                this.ec2EnvironmentArn = cdk.Stack.of(this).formatArn({
                    service: 'cloud9',
                    resource: 'environment',
                    resourceName: this.ec2EnvironmentName,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.Ec2Environment = Ec2Environment;
//# sourceMappingURL=data:application/json;base64,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