window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "pathier", "modulename": "pathier", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "pathier.Pathier", "modulename": "pathier", "qualname": "Pathier", "kind": "class", "doc": "<p>Subclasses the standard library pathlib.Path class.</p>\n", "bases": "pathlib.Path"}, {"fullname": "pathier.Pathier.__init__", "modulename": "pathier", "qualname": "Pathier.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "pathier.Pathier.convert_backslashes", "modulename": "pathier", "qualname": "Pathier.convert_backslashes", "kind": "variable", "doc": "<p>If True, when <code>self.__str__()</code>/<code>str(self)</code> is called, string representations will have double backslashes converted to a forward slash.</p>\n\n<p>Only affects Windows paths.</p>\n", "annotation": ": bool"}, {"fullname": "pathier.Pathier.dob", "modulename": "pathier", "qualname": "Pathier.dob", "kind": "variable", "doc": "<p>Returns the creation date of this file or directory as a <code>dateime.datetime</code> object.</p>\n", "annotation": ": datetime.datetime | None"}, {"fullname": "pathier.Pathier.age", "modulename": "pathier", "qualname": "Pathier.age", "kind": "variable", "doc": "<p>Returns the age in seconds of this file or directory.</p>\n", "annotation": ": float | None"}, {"fullname": "pathier.Pathier.mod_date", "modulename": "pathier", "qualname": "Pathier.mod_date", "kind": "variable", "doc": "<p>Returns the modification date of this file or directory as a <code>datetime.datetime</code> object.</p>\n", "annotation": ": datetime.datetime | None"}, {"fullname": "pathier.Pathier.mod_delta", "modulename": "pathier", "qualname": "Pathier.mod_delta", "kind": "variable", "doc": "<p>Returns how long ago in seconds this file or directory was modified.</p>\n", "annotation": ": float | None"}, {"fullname": "pathier.Pathier.last_read_time", "modulename": "pathier", "qualname": "Pathier.last_read_time", "kind": "variable", "doc": "<p>Returns the last time this object made a call to <code>self.read_text()</code>, <code>self.read_bytes()</code>, or <code>self.open(mode=\"r\"|\"rb\")</code>.\nReturns <code>None</code> if the file hasn't been read from.</p>\n\n<p>Note: This property is only relative to the lifetime of this <code>Pathier</code> instance, not the file itself.\ni.e. This property will reset if you create a new <code>Pathier</code> object pointing to the same file.</p>\n", "annotation": ": datetime.datetime | None"}, {"fullname": "pathier.Pathier.modified_since_last_read", "modulename": "pathier", "qualname": "Pathier.modified_since_last_read", "kind": "variable", "doc": "<p>Returns <code>True</code> if this file hasn't been read from or has been modified since the last time this object\nmade a call to <code>self.read_text()</code>, <code>self.read_bytes()</code>, or <code>self.open(mode=\"r\"|\"rb\")</code>.</p>\n\n<p>Note: This property is only relative to the lifetime of this <code>Pathier</code> instance, not the file itself.\ni.e. This property will reset if you create a new <code>Pathier</code> object pointing to the same file.</p>\n\n<h4 id=\"caveat\">Caveat:</h4>\n\n<p>May not be accurate if the file was modified within a couple of seconds of checking this property.\n(For instance, on my machine <code>self.mod_date</code> is consistently 1-1.5s in the future from when <code>self.write_text()</code> was called according to <code>time.time()</code>.)</p>\n", "annotation": ": bool"}, {"fullname": "pathier.Pathier.size", "modulename": "pathier", "qualname": "Pathier.size", "kind": "variable", "doc": "<p>Returns the size in bytes of this file or directory.</p>\n\n<p>If this path doesn't exist, <code>0</code> will be returned.</p>\n", "annotation": ": int"}, {"fullname": "pathier.Pathier.formatted_size", "modulename": "pathier", "qualname": "Pathier.formatted_size", "kind": "variable", "doc": "<p>The size of this file or directory formatted with <code>self.format_bytes()</code>.</p>\n", "annotation": ": str"}, {"fullname": "pathier.Pathier.format_bytes", "modulename": "pathier", "qualname": "Pathier.format_bytes", "kind": "function", "doc": "<p>Format <code>size</code> with common file size abbreviations and rounded to two decimal places.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"mi\">1234</span> <span class=\"o\">-&gt;</span> <span class=\"s2\">&quot;1.23 kb&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.is_larger", "modulename": "pathier", "qualname": "Pathier.is_larger", "kind": "function", "doc": "<p>Returns whether this file or folder is larger than the one pointed to by <code>path</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">Self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.is_older", "modulename": "pathier", "qualname": "Pathier.is_older", "kind": "function", "doc": "<p>Returns whether this file or folder is older than the one pointed to by <code>path</code>.</p>\n\n<p>Returns <code>None</code> if one or both paths don't exist.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">Self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.modified_more_recently", "modulename": "pathier", "qualname": "Pathier.modified_more_recently", "kind": "function", "doc": "<p>Returns whether this file or folder was modified more recently than the one pointed to by <code>path</code>.</p>\n\n<p>Returns <code>None</code> if one or both paths don't exist.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">Self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.mkcwd", "modulename": "pathier", "qualname": "Pathier.mkcwd", "kind": "function", "doc": "<p>Make this path your current working directory.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.in_PATH", "modulename": "pathier", "qualname": "Pathier.in_PATH", "kind": "variable", "doc": "<p>Return <code>True</code> if this path is in <code>sys.path</code>.</p>\n", "annotation": ": bool"}, {"fullname": "pathier.Pathier.add_to_PATH", "modulename": "pathier", "qualname": "Pathier.add_to_PATH", "kind": "function", "doc": "<p>Insert this path into <code>sys.path</code> if it isn't already there.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>index</code>: The index of <code>sys.path</code> to insert this path at.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.append_to_PATH", "modulename": "pathier", "qualname": "Pathier.append_to_PATH", "kind": "function", "doc": "<p>Append this path to <code>sys.path</code> if it isn't already there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.remove_from_PATH", "modulename": "pathier", "qualname": "Pathier.remove_from_PATH", "kind": "function", "doc": "<p>Remove this path from <code>sys.path</code> if it's in <code>sys.path</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.moveup", "modulename": "pathier", "qualname": "Pathier.moveup", "kind": "function", "doc": "<p>Return a new <code>Pathier</code> object that is a parent of this instance.</p>\n\n<p><code>name</code> is case-sensitive and raises an exception if it isn't in <code>self.parts</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">p</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;C:/some/directory/in/your/system&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">p</span><span class=\"o\">.</span><span class=\"n\">moveup</span><span class=\"p\">(</span><span class=\"s2\">&quot;directory&quot;</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"s2\">&quot;C:/some/directory&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">p</span><span class=\"o\">.</span><span class=\"n\">moveup</span><span class=\"p\">(</span><span class=\"s2\">&quot;yeet&quot;</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"s2\">&quot;Exception: yeet is not a parent of C:/some/directory/in/your/system&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.move_under", "modulename": "pathier", "qualname": "Pathier.move_under", "kind": "function", "doc": "<p>Return a new <code>Pathier</code> object such that the stem is one level below the given folder <code>name</code>.</p>\n\n<p><code>name</code> is case-sensitive and raises an exception if it isn't in <code>self.parts</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">p</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;a/b/c/d/e/f/g&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">p</span><span class=\"o\">.</span><span class=\"n\">move_under</span><span class=\"p\">(</span><span class=\"s2\">&quot;c&quot;</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"s1\">&#39;a/b/c/d&#39;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.separate", "modulename": "pathier", "qualname": "Pathier.separate", "kind": "function", "doc": "<p>Return a new <code>Pathier</code> object that is the relative child path after <code>name</code>.</p>\n\n<p><code>name</code> is case-sensitive and raises an exception if it isn't in <code>self.parts</code>.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>keep_name</code>: If <code>True</code>, the returned path will start with <code>name</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">p</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;a/b/c/d/e/f/g&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">p</span><span class=\"o\">.</span><span class=\"n\">separate</span><span class=\"p\">(</span><span class=\"s2\">&quot;c&quot;</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"s1\">&#39;d/e/f/g&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">p</span><span class=\"o\">.</span><span class=\"n\">separate</span><span class=\"p\">(</span><span class=\"s2\">&quot;c&quot;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"s1\">&#39;c/d/e/f/g&#39;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">keep_name</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.mkdir", "modulename": "pathier", "qualname": "Pathier.mkdir", "kind": "function", "doc": "<p>Create this directory.</p>\n\n<p>Same as <code>Path().mkdir()</code> except <code>parents</code> and <code>exist_ok</code> default to <code>True</code> instead of <code>False</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">511</span>, </span><span class=\"param\"><span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">exist_ok</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.touch", "modulename": "pathier", "qualname": "Pathier.touch", "kind": "function", "doc": "<p>Create file (and parents if necessary).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.open", "modulename": "pathier", "qualname": "Pathier.open", "kind": "function", "doc": "<p>Open the file pointed by this path and return a file object, as\nthe built-in open() function does.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"o\">=</span><span class=\"s1\">&#39;r&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">buffering</span><span class=\"o\">=-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">newline</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.write_text", "modulename": "pathier", "qualname": "Pathier.write_text", "kind": "function", "doc": "<p>Write data to file.</p>\n\n<p>If a <code>TypeError</code> is raised, the function  will attempt to cast <code>data</code> to a <code>str</code> and try the write again.</p>\n\n<p>If a <code>FileNotFoundError</code> is raised and <code>parents = True</code>, <code>self.parent</code> will be created.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">newline</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.write_bytes", "modulename": "pathier", "qualname": "Pathier.write_bytes", "kind": "function", "doc": "<p>Write bytes to file.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>parents</code>: If <code>True</code> and the write operation fails with a <code>FileNotFoundError</code>,\nmake the parent directory and retry the write.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span>, </span><span class=\"param\"><span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.append", "modulename": "pathier", "qualname": "Pathier.append", "kind": "function", "doc": "<p>Append <code>data</code> to the file pointed to by this <code>Pathier</code> object.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>new_line</code>: If <code>True</code>, add <code>\\n</code> to <code>data</code>.</p>\n\n<p><code>encoding</code>: The file encoding to use.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">new_line</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.replace_strings", "modulename": "pathier", "qualname": "Pathier.replace_strings", "kind": "function", "doc": "<p>For each pair in <code>substitutions</code>, replace the first string with the second string.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>count</code>: Only replace this many occurences of each pair.\nBy default (<code>-1</code>), all occurences are replaced.</p>\n\n<p><code>encoding</code>: The file encoding to use.</p>\n\n<p>e.g.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;somefile.txt&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">replace</span><span class=\"p\">([(</span><span class=\"s2\">&quot;hello&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;yeet&quot;</span><span class=\"p\">),</span> <span class=\"p\">(</span><span class=\"s2\">&quot;goodbye&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;yeehaw&quot;</span><span class=\"p\">)])</span>\n<span class=\"go\">equivalent to</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">write_text</span><span class=\"p\">(</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">read_text</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">replace</span><span class=\"p\">(</span><span class=\"s2\">&quot;hello&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;yeet&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">replace</span><span class=\"p\">(</span><span class=\"s2\">&quot;goodbye&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;yeehaw&quot;</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">substitutions</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">count</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.join", "modulename": "pathier", "qualname": "Pathier.join", "kind": "function", "doc": "<p>Write a list of strings, joined by <code>sep</code>, to the file pointed at by this instance.</p>\n\n<p>Equivalent to <code>Pathier(\"somefile.txt\").write_text(sep.join(data), encoding=encoding)</code></p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>encoding</code>: The file encoding to use.</p>\n\n<p><code>sep</code>: The separator to use when joining <code>data</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"se\">\\n</span><span class=\"s1\">&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.split", "modulename": "pathier", "qualname": "Pathier.split", "kind": "function", "doc": "<p>Returns the content of the pointed at file as a list of strings, splitting at new line characters.</p>\n\n<p>Equivalent to <code>Pathier(\"somefile.txt\").read_text(encoding=encoding).splitlines()</code></p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>encoding</code>: The file encoding to use.</p>\n\n<p><code>keepend</code>: If <code>True</code>, line breaks will be included in returned strings.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">keepends</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.json_loads", "modulename": "pathier", "qualname": "Pathier.json_loads", "kind": "function", "doc": "<p>Load json file.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.json_dumps", "modulename": "pathier", "qualname": "Pathier.json_dumps", "kind": "function", "doc": "<p>Dump <code>data</code> to json file.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">newline</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sort_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.toml_loads", "modulename": "pathier", "qualname": "Pathier.toml_loads", "kind": "function", "doc": "<p>Load toml file.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.toml_dumps", "modulename": "pathier", "qualname": "Pathier.toml_dumps", "kind": "function", "doc": "<p>Dump <code>data</code> to toml file.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">newline</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sort_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.loads", "modulename": "pathier", "qualname": "Pathier.loads", "kind": "function", "doc": "<p>Load a json or toml file based off this instance's suffix.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.dumps", "modulename": "pathier", "qualname": "Pathier.dumps", "kind": "function", "doc": "<p>Dump <code>data</code> to a json or toml file based off this instance's suffix.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">newline</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sort_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parents</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.delete", "modulename": "pathier", "qualname": "Pathier.delete", "kind": "function", "doc": "<p>Delete the file or folder pointed to by this instance.</p>\n\n<p>Uses <code>self.unlink()</code> if a file and uses <code>shutil.rmtree()</code> if a directory.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">missing_ok</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.copy", "modulename": "pathier", "qualname": "Pathier.copy", "kind": "function", "doc": "<p>Copy the path pointed to by this instance\nto the instance pointed to by <code>new_path</code> using <code>shutil.copyfile</code>\nor <code>shutil.copytree</code>.</p>\n\n<p>Returns the new path.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>new_path</code>: The copy destination.</p>\n\n<p><code>overwrite</code>: If <code>True</code>, files already existing in <code>new_path</code> will be overwritten.\nIf <code>False</code>, only files that don't exist in <code>new_path</code> will be copied.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">new_path</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Self</span><span class=\"p\">,</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">overwrite</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.backup", "modulename": "pathier", "qualname": "Pathier.backup", "kind": "function", "doc": "<p>Create a copy of this file or directory with <code>_backup</code> appended to the path stem.\nIf the path to be backed up doesn't exist, <code>None</code> is returned.\nOtherwise a <code>Pathier</code> object for the backup is returned.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>timestamp</code>: Add a timestamp to the backup name to prevent overriding previous backups.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;some_file.txt&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">backup</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">list</span><span class=\"p\">(</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">iterdir</span><span class=\"p\">())</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"p\">[</span><span class=\"s1\">&#39;some_file.txt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;some_file_backup.txt&#39;</span><span class=\"p\">]</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">backup</span><span class=\"p\">(</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">list</span><span class=\"p\">(</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">iterdir</span><span class=\"p\">())</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"p\">[</span><span class=\"s1\">&#39;some_file.txt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;some_file_backup.txt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;some_file_backup_04-28-2023-06_25_52_PM.txt&#39;</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">timestamp</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Self</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "pathier.Pathier.execute", "modulename": "pathier", "qualname": "Pathier.execute", "kind": "function", "doc": "<p>Make a call to <code>os.system</code> using the path pointed to by this Pathier object.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>command</code>: Program/command to precede the path with.</p>\n\n<p><code>args</code>: Any arguments that should come after the path.</p>\n\n<p>:returns: The integer output of <code>os.system</code>.</p>\n\n<p>e.g.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span> <span class=\"o\">=</span> <span class=\"n\">Pathier</span><span class=\"p\">(</span><span class=\"s2\">&quot;mydirectory&quot;</span><span class=\"p\">)</span> <span class=\"o\">/</span> <span class=\"s2\">&quot;myscript.py&quot;</span>\n<span class=\"go\">then</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">execute</span><span class=\"p\">(</span><span class=\"s2\">&quot;py&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;--iterations 10&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">equivalent to</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">system</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;py </span><span class=\"si\">{</span><span class=\"n\">path</span><span class=\"si\">}</span><span class=\"s2\"> --iterations 10&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();