
# Setup
This library can be used in may ways. It can be used as a standalone library to quickly mine content on ArXiv or act as a layer of access to information stored in Elasticsearch after mining and scraping. A `pip` install of the core library is needed. All additional dependencies can be managed/installed according usecase match to [core components](core_components.md):
- Scraping : None
- Mining : [Latex mining utilities installation](quickstart.md#latex-mining-utils-installation) , [Ontology classifier installation](quickstart.md#setup-ontology-classifier)
- Storage and Search: [Elasticsearch 7.8.0](https://www.elastic.co/guide/en/elasticsearch/reference/7.8/deb.html).

## Core Library Install 

```sh
pip install -r git+https://github.com/valayDave/arxiv-miner
```
## Latex Mining Utils installation
Main dependences : `texlive-full` (Ubuntu) or [`texshop`](https://pages.uoregon.edu/koch/texshop/) (OSX) and [`opendetex`](https://github.com/pkubowicz/opendetex). The [setup_latex_parsing.sh](https://github.com/valayDave/arxiv-miner/blob/master/setup_latex_parsing.sh) script will install `texlive-full` and other dependencies for ubuntu and also create the binary for `opendetex` in the current working directory. 
```sh
sh setup_latex_parsing.sh
```
## Setup Ontology Classifier: 
The [`cso-classifier`](https://github.com/angelosalatino/cso-classifier/) needs to be installed to include Ontology mining when starting the mining process. 
```sh
sh cso_setup.sh
```
