# coding: utf-8
# !/usr/bin/python
"""
@File       :   static_data.py.py
@Author     :   jiaming
@Modify Time:   2020/3/9 14:28
@Contact    :   https://blog.csdn.net/weixin_39541632
@Version    :   1.0
@Desciption :   None
"""
import os

# 数据举例
data64 = "XFSB1wQ2XPKBsVTYdChtz9Gyx4PuYokVvbGX7ai1FYmFHRs2SDIIz39KAiGxkfxL"
data128 = "2rtw17PoD6jt6b1hZJ2HZJS1eWL1n9gXd4GXEa6DgWPQn0ou19YcxsJiTmJJitfr0VeGxbOxMyqncIj7Nw8y7M8woA6pIzQMLqeNWg1lcWsoNuLuCbdzaH2FNWvqsMi8"
data256 = "dMAdeVq2N0S4Htz1hJU5A139n0PeP8URNFEQglTUC4zCZdWpxccC4xGhKWDTR7qVtYl0bN6TlvWPbgFSkqpI1QjM1wEXtFn5I24kMxszm0HAIxvXN7gwkwBGdZ2Joz0uY6WFs9ib6vNwKT20arBeYijwHRrYhfwAjX3Lrc3JEZxpYja4qQp93R7dwfgkLR3cvPop90ryVSdqhQxYFRrhZlpGBaNoXd0HNXI4AjD8NZz3jtOKTIfEGuvpo6qrLGoV"

rawPath = os.path.abspath(__file__)
dataPath = rawPath[:rawPath.find('app')] + 'static\\'

# 只能对于 Alphanumeric_mode_table 中的字符进行编码
Alphanumeric_mode_table = {
    '0': 0,
    '1': 1,
    '2': 2,
    '3': 3,
    '4': 4,
    '5': 5,
    '6': 6,
    '7': 7,
    '8': 8,
    '9': 9,
    'A': 10,
    'B': 11,
    'C': 12,
    'D': 13,
    'E': 14,
    'F': 15,
    'G': 16,
    'H': 17,
    'I': 18,
    'J': 19,
    'K': 20,
    'L': 21,
    'M': 22,
    'N': 23,
    'O': 24,
    'P': 25,
    'Q': 26,
    'R': 27,
    'S': 28,
    'T': 29,
    'U': 30,
    'V': 31,
    'W': 32,
    'X': 33,
    'Y': 34,
    'Z': 35,
    ' ': 36,
    '$': 37,
    '%': 38,
    '*': 39,
    '+': 40,
    '-': 41,
    '.': 42,
    '/': 43,
    ':': 44,
}
# 字符数据的 bit 值, 两个字符合起来由 11 bit表示
number_of_bits_in_character_count = 11
# 编码样式前缀 —— 字符编码
Alphanumeric = '0010'
# coordinate of center module table
# version: [Number of alignment patterns, (Row/Column coordinates of center
# moudle)]
standard_module_table = {
    1: [0, ],
    2: [1, (6, 18)],
    3: [1, (6, 22)],
    4: [1, (6, 26)],
    5: [1, (6, 30)],
    6: [1, (6, 34)],
    7: [6, (6, 22, 38)],
    8: [6, (6, 24, 42)],
    9: [6, (6, 26, 46)],
    10: [6, (6, 28, 50)],
}
# capacity of each version qrcode bytes
capacity_of_each_qrcode = {
    0: 12,
    1: 26,
    2: 42,
    3: 62,
    4: 82,
    5: 106,
    6: 134,
    7: 158,
    8: 192,
    9: 228,
    10: 268,
}
# 未延展是各个版本二维码的数据点坐标
coordinate_no_expanding_table = {0: ([(44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(52, 48), (52, 52), (52, 56), (52, 60), (52, 64), (52, 68), (52, 72), (52, 76), (52, 80), (56, 48), (56, 52), (56, 56), (56, 60), (56, 64), (56, 68), (56, 72), (56, 76), (56, 80), (60, 48), (60, 52), (60, 56), (60, 60), (60, 64), (60, 68), (60, 72), (60, 76), (60, 80), (64, 48), (64, 52), (64, 56), (64, 60), (64, 64), (64, 68), (64, 72), (64, 76), (64, 80), (68, 48), (68, 52), (68, 56), (68, 60), (68, 64), (68, 68), (68, 72), (68, 76), (68, 80), (72, 48), (72, 52), (72, 56), (72, 60), (72, 64), (72, 68), (72, 72), (72, 76), (72, 80), (76, 48), (76, 52), (76, 56), (76, 60), (76, 64), (76, 68), (76, 72), (76, 76), (76, 80), (80, 48), (80, 52), (80, 56), (80, 60), (80, 64), (80, 68), (80, 72), (80, 76), (80, 80)]), 1: ([(52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(60, 16), (60, 20), (60, 24), (60, 28), (60, 32), (60, 36), (60, 40), (60, 44), (60, 48), (60, 52), (60, 56), (60, 60), (60, 64), (60, 68), (60, 72), (60, 76), (60, 80), (60, 84), (60, 88), (60, 92), (60, 96), (64, 16), (64, 20), (64, 24), (64, 28), (64, 32), (64, 36), (64, 40), (64, 44), (64, 48), (64, 52), (64, 56), (64, 60), (64, 64), (64, 68), (64, 72), (64, 76), (64, 80), (64, 84), (64, 88), (64, 92), (64, 96), (68, 48), (68, 52), (68, 56), (68, 60), (68, 64), (68, 68), (68, 72), (68, 76), (68, 80), (68, 84), (68, 88), (68, 92), (68, 96), (72, 48), (72, 52), (72, 56), (72, 60), (72, 64), (72, 68), (72, 72), (72, 76), (72, 80), (72, 84), (72, 88), (72, 92), (72, 96), (76, 48), (76, 52), (76, 56), (76, 60), (76, 64), (76, 68), (76, 72), (76, 76), (76, 80), (76, 84), (76, 88), (76, 92), (76, 96), (80, 48), (80, 52), (80, 56), (80, 60), (80, 64), (80, 68), (80, 72), (80, 76), (80, 80), (80, 84), (80, 88), (80, 92), (80, 96), (84, 48), (84, 52), (84, 56), (84, 60), (84, 64), (84, 68), (84, 72), (84, 76), (84, 80), (84, 84), (84, 88), (84, 92), (84, 96), (88, 48), (88, 52), (88, 56), (88, 60), (88, 64), (88, 68), (88, 72), (88, 76), (88, 80), (88, 84), (88, 88), (88, 92), (88, 96), (92, 48), (92, 52), (92, 56), (92, 60), (92, 64), (92, 68), (92, 72), (92, 76), (92, 80), (92, 84), (92, 88), (92, 92), (92, 96), (96, 48), (96, 52), (96, 56), (96, 60), (96, 64), (96, 68), (96, 72), (96, 76), (96, 80), (96, 84), (96, 88), (96, 92), (96, 96)]), 2: ([(60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(68, 16), (68, 20), (68, 24), (68, 28), (68, 32), (68, 36), (68, 40), (68, 44), (68, 48), (68, 52), (68, 56), (68, 60), (68, 64), (68, 68), (68, 72), (68, 76), (68, 80), (68, 84), (68, 88), (68, 92), (68, 96), (68, 100), (68, 104), (68, 108), (68, 112), (72, 16), (72, 20), (72, 24), (72, 28), (72, 32), (72, 36), (72, 40), (72, 44), (72, 48), (72, 52), (72, 56), (72, 60), (72, 64), (72, 68), (72, 72), (72, 76), (72, 80), (72, 84), (72, 88), (72, 92), (72, 96), (72, 100), (72, 104), (72, 108), (72, 112), (76, 16), (76, 20), (76, 24), (76, 28), (76, 32), (76, 36), (76, 40), (76, 44), (76, 48), (76, 52), (76, 56), (76, 60), (76, 64), (76, 68), (76, 72), (76, 76), (76, 80), (76, 84), (76, 88), (76, 92), (76, 96), (76, 100), (76, 104), (76, 108), (76, 112), (80, 16), (80, 20), (80, 24), (80, 28), (80, 32), (80, 36), (80, 40), (80, 44), (80, 48), (80, 52), (80, 56), (80, 60), (80, 64), (80, 68), (80, 72), (80, 76), (80, 80), (80, 84), (80, 88), (80, 92), (80, 96), (80, 100), (80, 104), (80, 108), (80, 112), (84, 48), (84, 52), (84, 56), (84, 60), (84, 64), (84, 68), (84, 72), (84, 76), (84, 80), (84, 84), (84, 88), (84, 92), (84, 96), (84, 100), (84, 104), (84, 108), (84, 112), (88, 48), (88, 52), (88, 56), (88, 60), (88, 64), (88, 68), (88, 72), (88, 76), (88, 80), (88, 84), (88, 88), (88, 92), (88, 96), (88, 100), (88, 104), (88, 108), (88, 112), (92, 48), (92, 52), (92, 56), (92, 60), (92, 64), (92, 68), (92, 72), (92, 76), (92, 80), (92, 84), (92, 88), (92, 92), (92, 96), (92, 100), (92, 104), (92, 108), (92, 112), (96, 48), (96, 52), (96, 56), (96, 60), (96, 64), (96, 68), (96, 72), (96, 76), (96, 80), (96, 84), (96, 88), (96, 92), (96, 96), (96, 100), (96, 104), (96, 108), (96, 112), (100, 48), (100, 52), (100, 56), (100, 60), (100, 64), (100, 68), (100, 72), (100, 76), (100, 80), (100, 84), (100, 88), (100, 92), (100, 96), (100, 100), (100, 104), (100, 108), (100, 112), (104, 48), (104, 52), (104, 56), (104, 60), (104, 64), (104, 68), (104, 72), (104, 76), (104, 80), (104, 84), (104, 88), (104, 92), (104, 96), (104, 100), (104, 104), (104, 108), (104, 112), (108, 48), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 96), (108, 100), (108, 104), (108, 108), (108, 112), (112, 48), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 96), (112, 100), (112, 104), (112, 108), (112, 112)]), 3: ([(68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 128), (48, 124), (48, 120), (48, 116), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 128), (44, 124), (44, 120), (44, 116), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 128), (40, 124), (40, 120), (40, 116), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 128), (36, 124), (36, 120), (36, 116), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 128), (32, 124), (32, 120), (32, 116), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(76, 16), (76, 20), (76, 24), (76, 28), (76, 32), (76, 36), (76, 40), (76, 44), (76, 48), (76, 52), (76, 56), (76, 60), (76, 64), (76, 68), (76, 72), (76, 76), (76, 80), (76, 84), (76, 88), (76, 92), (76, 96), (76, 100), (76, 104), (76, 108), (76, 112), (76, 116), (76, 120), (76, 124), (76, 128), (80, 16), (80, 20), (80, 24), (80, 28), (80, 32), (80, 36), (80, 40), (80, 44), (80, 48), (80, 52), (80, 56), (80, 60), (80, 64), (80, 68), (80, 72), (80, 76), (80, 80), (80, 84), (80, 88), (80, 92), (80, 96), (80, 100), (80, 104), (80, 108), (80, 112), (80, 116), (80, 120), (80, 124), (80, 128), (84, 16), (84, 20), (84, 24), (84, 28), (84, 32), (84, 36), (84, 40), (84, 44), (84, 48), (84, 52), (84, 56), (84, 60), (84, 64), (84, 68), (84, 72), (84, 76), (84, 80), (84, 84), (84, 88), (84, 92), (84, 96), (84, 100), (84, 104), (84, 108), (84, 112), (84, 116), (84, 120), (84, 124), (84, 128), (88, 16), (88, 20), (88, 24), (88, 28), (88, 32), (88, 36), (88, 40), (88, 44), (88, 48), (88, 52), (88, 56), (88, 60), (88, 64), (88, 68), (88, 72), (88, 76), (88, 80), (88, 84), (88, 88), (88, 92), (88, 96), (88, 100), (88, 104), (88, 108), (88, 112), (88, 116), (88, 120), (88, 124), (88, 128), (92, 16), (92, 20), (92, 24), (92, 28), (92, 32), (92, 36), (92, 40), (92, 44), (92, 48), (92, 52), (92, 56), (92, 60), (92, 64), (92, 68), (92, 72), (92, 76), (92, 80), (92, 84), (92, 88), (92, 92), (92, 96), (92, 100), (92, 104), (92, 108), (92, 112), (92, 116), (92, 120), (92, 124), (92, 128), (96, 16), (96, 20), (96, 24), (96, 28), (96, 32), (96, 36), (96, 40), (96, 44), (96, 48), (96, 52), (96, 56), (96, 60), (96, 64), (96, 68), (96, 72), (96, 76), (96, 80), (96, 84), (96, 88), (96, 92), (96, 96), (96, 100), (96, 104), (96, 108), (96, 112), (96, 116), (96, 120), (96, 124), (96, 128), (100, 48), (100, 52), (100, 56), (100, 60), (100, 64), (100, 68), (100, 72), (100, 76), (100, 80), (100, 84), (100, 88), (100, 92), (100, 96), (100, 100), (100, 104), (100, 108), (100, 112), (100, 116), (100, 120), (100, 124), (100, 128), (104, 48), (104, 52), (104, 56), (104, 60), (104, 64), (104, 68), (104, 72), (104, 76), (104, 80), (104, 84), (104, 88), (104, 92), (104, 96), (104, 100), (104, 104), (104, 108), (104, 112), (104, 116), (104, 120), (104, 124), (104, 128), (108, 48), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 96), (108, 100), (108, 104), (108, 108), (108, 112), (108, 116), (108, 120), (108, 124), (108, 128), (112, 48), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 96), (112, 100), (112, 104), (112, 108), (112, 112), (112, 116), (112, 120), (112, 124), (112, 128), (116, 48), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 104), (116, 108), (116, 112), (116, 116), (116, 120), (116, 124), (116, 128), (120, 48), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 104), (120, 108), (120, 112), (120, 116), (120, 120), (120, 124), (120, 128), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128)]), 4: ([(76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 144), (48, 140), (48, 136), (48, 132), (48, 128), (48, 124), (48, 120), (48, 116), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 144), (44, 140), (44, 136), (44, 132), (44, 128), (44, 124), (44, 120), (44, 116), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 144), (40, 140), (40, 136), (40, 132), (40, 128), (40, 124), (40, 120), (40, 116), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 144), (36, 140), (36, 136), (36, 132), (36, 128), (36, 124), (36, 120), (36, 116), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 144), (32, 140), (32, 136), (32, 132), (32, 128), (32, 124), (32, 120), (32, 116), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(84, 16), (84, 20), (84, 24), (84, 28), (84, 32), (84, 36), (84, 40), (84, 44), (84, 48), (84, 52), (84, 56), (84, 60), (84, 64), (84, 68), (84, 92), (84, 96), (84, 100), (84, 104), (84, 108), (84, 112), (84, 116), (84, 120), (84, 124), (84, 128), (84, 132), (84, 136), (84, 140), (84, 144), (88, 16), (88, 20), (88, 24), (88, 28), (88, 32), (88, 36), (88, 40), (88, 44), (88, 48), (88, 52), (88, 56), (88, 60), (88, 64), (88, 68), (88, 92), (88, 96), (88, 100), (88, 104), (88, 108), (88, 112), (88, 116), (88, 120), (88, 124), (88, 128), (88, 132), (88, 136), (88, 140), (88, 144), (92, 16), (92, 20), (92, 24), (92, 28), (92, 32), (92, 36), (92, 40), (92, 44), (92, 48), (92, 52), (92, 56), (92, 60), (92, 64), (92, 68), (92, 72), (92, 76), (92, 80), (92, 84), (92, 88), (92, 92), (92, 96), (92, 100), (92, 104), (92, 108), (92, 112), (92, 116), (92, 120), (92, 124), (92, 128), (92, 132), (92, 136), (92, 140), (92, 144), (96, 16), (96, 20), (96, 24), (96, 28), (96, 32), (96, 36), (96, 40), (96, 44), (96, 48), (96, 52), (96, 56), (96, 60), (96, 64), (96, 68), (96, 72), (96, 76), (96, 80), (96, 84), (96, 88), (96, 92), (96, 96), (96, 100), (96, 104), (96, 108), (96, 112), (96, 116), (96, 120), (96, 124), (96, 128), (96, 132), (96, 136), (96, 140), (96, 144), (100, 16), (100, 20), (100, 24), (100, 28), (100, 32), (100, 36), (100, 40), (100, 44), (100, 48), (100, 52), (100, 56), (100, 60), (100, 64), (100, 68), (100, 72), (100, 76), (100, 80), (100, 84), (100, 88), (100, 92), (100, 96), (100, 100), (100, 104), (100, 108), (100, 112), (100, 116), (100, 120), (100, 124), (100, 128), (100, 132), (100, 136), (100, 140), (100, 144), (104, 16), (104, 20), (104, 24), (104, 28), (104, 32), (104, 36), (104, 40), (104, 44), (104, 48), (104, 52), (104, 56), (104, 60), (104, 64), (104, 68), (104, 72), (104, 76), (104, 80), (104, 84), (104, 88), (104, 92), (104, 96), (104, 100), (104, 104), (104, 108), (104, 112), (104, 116), (104, 120), (104, 124), (104, 128), (104, 132), (104, 136), (104, 140), (104, 144), (108, 16), (108, 20), (108, 24), (108, 28), (108, 32), (108, 36), (108, 40), (108, 44), (108, 48), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 96), (108, 100), (108, 104), (108, 108), (108, 112), (108, 116), (108, 120), (108, 124), (108, 128), (108, 132), (108, 136), (108, 140), (108, 144), (112, 16), (112, 20), (112, 24), (112, 28), (112, 32), (112, 36), (112, 40), (112, 44), (112, 48), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 96), (112, 100), (112, 104), (112, 108), (112, 112), (112, 116), (112, 120), (112, 124), (112, 128), (112, 132), (112, 136), (112, 140), (112, 144), (116, 48), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 104), (116, 108), (116, 112), (116, 116), (116, 120), (116, 124), (116, 128), (116, 132), (116, 136), (116, 140), (116, 144), (120, 48), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 104), (120, 108), (120, 112), (120, 116), (120, 120), (120, 124), (120, 128), (120, 132), (120, 136), (120, 140), (120, 144), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (124, 132), (124, 136), (124, 140), (124, 144), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128), (128, 132), (128, 136), (128, 140), (128, 144), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144)]), 5: ([(84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 136), (48, 132), (48, 128), (48, 124), (48, 120), (48, 116), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 136), (44, 132), (44, 128), (44, 124), (44, 120), (44, 116), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 136), (40, 132), (40, 128), (40, 124), (40, 120), (40, 116), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 136), (36, 132), (36, 128), (36, 124), (36, 120), (36, 116), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 136), (32, 132), (32, 128), (32, 124), (32, 120), (32, 116), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(92, 16), (92, 20), (92, 24), (92, 28), (92, 32), (92, 36), (92, 40), (92, 44), (92, 48), (92, 52), (92, 56), (92, 60), (92, 64), (92, 68), (92, 72), (92, 76), (92, 100), (92, 104), (92, 108), (92, 112), (92, 116), (92, 120), (92, 124), (92, 128), (92, 132), (92, 136), (92, 140), (92, 144), (92, 148), (92, 152), (92, 156), (92, 160), (96, 16), (96, 20), (96, 24), (96, 28), (96, 32), (96, 36), (96, 40), (96, 44), (96, 48), (96, 52), (96, 56), (96, 60), (96, 64), (96, 68), (96, 72), (96, 76), (96, 100), (96, 104), (96, 108), (96, 112), (96, 116), (96, 120), (96, 124), (96, 128), (96, 132), (96, 136), (96, 140), (96, 144), (96, 148), (96, 152), (96, 156), (96, 160), (100, 16), (100, 20), (100, 24), (100, 28), (100, 32), (100, 36), (100, 40), (100, 44), (100, 48), (100, 52), (100, 56), (100, 60), (100, 64), (100, 68), (100, 72), (100, 76), (100, 80), (100, 84), (100, 88), (100, 92), (100, 96), (100, 100), (100, 104), (100, 108), (100, 112), (100, 116), (100, 120), (100, 124), (100, 128), (100, 132), (100, 136), (100, 140), (100, 144), (100, 148), (100, 152), (100, 156), (100, 160), (104, 16), (104, 20), (104, 24), (104, 28), (104, 32), (104, 36), (104, 40), (104, 44), (104, 48), (104, 52), (104, 56), (104, 60), (104, 64), (104, 68), (104, 72), (104, 76), (104, 80), (104, 84), (104, 88), (104, 92), (104, 96), (104, 100), (104, 104), (104, 108), (104, 112), (104, 116), (104, 120), (104, 124), (104, 128), (104, 132), (104, 136), (104, 140), (104, 144), (104, 148), (104, 152), (104, 156), (104, 160), (108, 16), (108, 20), (108, 24), (108, 28), (108, 32), (108, 36), (108, 40), (108, 44), (108, 48), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 96), (108, 100), (108, 104), (108, 108), (108, 112), (108, 116), (108, 120), (108, 124), (108, 128), (108, 132), (108, 136), (108, 140), (108, 144), (108, 148), (108, 152), (108, 156), (108, 160), (112, 16), (112, 20), (112, 24), (112, 28), (112, 32), (112, 36), (112, 40), (112, 44), (112, 48), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 96), (112, 100), (112, 104), (112, 108), (112, 112), (112, 116), (112, 120), (112, 124), (112, 128), (112, 132), (112, 136), (112, 140), (112, 144), (112, 148), (112, 152), (112, 156), (112, 160), (116, 16), (116, 20), (116, 24), (116, 28), (116, 32), (116, 36), (116, 40), (116, 44), (116, 48), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 104), (116, 108), (116, 112), (116, 116), (116, 120), (116, 124), (116, 128), (116, 132), (116, 136), (116, 140), (116, 144), (116, 148), (116, 152), (116, 156), (116, 160), (120, 16), (120, 20), (120, 24), (120, 28), (120, 32), (120, 36), (120, 40), (120, 44), (120, 48), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 104), (120, 108), (120, 112), (120, 116), (120, 120), (120, 124), (120, 128), (120, 132), (120, 136), (120, 140), (120, 144), (120, 148), (120, 152), (120, 156), (120, 160), (124, 16), (124, 20), (124, 24), (124, 28), (124, 32), (124, 36), (124, 40), (124, 44), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (124, 132), (124, 136), (124, 140), (124, 144), (124, 148), (124, 152), (124, 156), (124, 160), (128, 16), (128, 20), (128, 24), (128, 28), (128, 32), (128, 36), (128, 40), (128, 44), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128), (128, 132), (128, 136), (128, 140), (128, 144), (128, 148), (128, 152), (128, 156), (128, 160), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 96), (160, 100), (160, 104), (160, 108), (160, 112), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160)]), 6: ([(92, 176), (92, 172), (92, 168), (92, 164), (92, 160), (92, 156), (92, 152), (92, 148), (92, 144), (92, 140), (92, 136), (92, 132), (92, 128), (92, 124), (92, 120), (92, 116), (92, 112), (92, 108), (92, 84), (92, 80), (92, 76), (92, 72), (92, 68), (92, 64), (92, 60), (92, 56), (92, 52), (92, 48), (92, 44), (92, 40), (92, 36), (92, 32), (92, 28), (92, 24), (92, 20), (92, 16), (88, 176), (88, 172), (88, 168), (88, 164), (88, 160), (88, 156), (88, 152), (88, 148), (88, 144), (88, 140), (88, 136), (88, 132), (88, 128), (88, 124), (88, 120), (88, 116), (88, 112), (88, 108), (88, 84), (88, 80), (88, 76), (88, 72), (88, 68), (88, 64), (88, 60), (88, 56), (88, 52), (88, 48), (88, 44), (88, 40), (88, 36), (88, 32), (88, 28), (88, 24), (88, 20), (88, 16), (84, 176), (84, 172), (84, 168), (84, 164), (84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 96), (84, 92), (84, 88), (84, 84), (84, 80), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 176), (80, 172), (80, 168), (80, 164), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 96), (80, 92), (80, 88), (80, 84), (80, 80), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 176), (76, 172), (76, 168), (76, 164), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 176), (72, 172), (72, 168), (72, 164), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 176), (68, 172), (68, 168), (68, 164), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 176), (64, 172), (64, 168), (64, 164), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 176), (60, 172), (60, 168), (60, 164), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 176), (56, 172), (56, 168), (56, 164), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 176), (52, 172), (52, 168), (52, 164), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 176), (48, 172), (48, 168), (48, 164), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 136), (48, 132), (48, 128), (48, 124), (48, 120), (48, 116), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 176), (44, 172), (44, 168), (44, 164), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 136), (44, 132), (44, 128), (44, 124), (44, 120), (44, 116), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 176), (40, 172), (40, 168), (40, 164), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 136), (40, 132), (40, 128), (40, 124), (40, 120), (40, 116), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 176), (36, 172), (36, 168), (36, 164), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 136), (36, 132), (36, 128), (36, 124), (36, 120), (36, 116), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 176), (32, 172), (32, 168), (32, 164), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 136), (32, 132), (32, 128), (32, 124), (32, 120), (32, 116), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 176), (28, 172), (28, 168), (28, 164), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 176), (24, 172), (24, 168), (24, 164), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 176), (20, 172), (20, 168), (20, 164), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 176), (16, 172), (16, 168), (16, 164), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(100, 16), (100, 20), (100, 24), (100, 28), (100, 32), (100, 36), (100, 40), (100, 44), (100, 48), (100, 52), (100, 56), (100, 60), (100, 64), (100, 68), (100, 72), (100, 76), (100, 80), (100, 84), (100, 108), (100, 112), (100, 116), (100, 120), (100, 124), (100, 128), (100, 132), (100, 136), (100, 140), (100, 144), (100, 148), (100, 152), (100, 156), (100, 160), (100, 164), (100, 168), (100, 172), (100, 176), (104, 16), (104, 20), (104, 24), (104, 28), (104, 32), (104, 36), (104, 40), (104, 44), (104, 48), (104, 52), (104, 56), (104, 60), (104, 64), (104, 68), (104, 72), (104, 76), (104, 80), (104, 84), (104, 108), (104, 112), (104, 116), (104, 120), (104, 124), (104, 128), (104, 132), (104, 136), (104, 140), (104, 144), (104, 148), (104, 152), (104, 156), (104, 160), (104, 164), (104, 168), (104, 172), (104, 176), (108, 16), (108, 20), (108, 24), (108, 28), (108, 32), (108, 36), (108, 40), (108, 44), (108, 48), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 96), (108, 100), (108, 104), (108, 108), (108, 112), (108, 116), (108, 120), (108, 124), (108, 128), (108, 132), (108, 136), (108, 140), (108, 144), (108, 148), (108, 152), (108, 156), (108, 160), (108, 164), (108, 168), (108, 172), (108, 176), (112, 16), (112, 20), (112, 24), (112, 28), (112, 32), (112, 36), (112, 40), (112, 44), (112, 48), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 96), (112, 100), (112, 104), (112, 108), (112, 112), (112, 116), (112, 120), (112, 124), (112, 128), (112, 132), (112, 136), (112, 140), (112, 144), (112, 148), (112, 152), (112, 156), (112, 160), (112, 164), (112, 168), (112, 172), (112, 176), (116, 16), (116, 20), (116, 24), (116, 28), (116, 32), (116, 36), (116, 40), (116, 44), (116, 48), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 104), (116, 108), (116, 112), (116, 116), (116, 120), (116, 124), (116, 128), (116, 132), (116, 136), (116, 140), (116, 144), (116, 148), (116, 152), (116, 156), (116, 160), (116, 164), (116, 168), (116, 172), (116, 176), (120, 16), (120, 20), (120, 24), (120, 28), (120, 32), (120, 36), (120, 40), (120, 44), (120, 48), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 104), (120, 108), (120, 112), (120, 116), (120, 120), (120, 124), (120, 128), (120, 132), (120, 136), (120, 140), (120, 144), (120, 148), (120, 152), (120, 156), (120, 160), (120, 164), (120, 168), (120, 172), (120, 176), (124, 16), (124, 20), (124, 24), (124, 28), (124, 32), (124, 36), (124, 40), (124, 44), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (124, 132), (124, 136), (124, 140), (124, 144), (124, 148), (124, 152), (124, 156), (124, 160), (124, 164), (124, 168), (124, 172), (124, 176), (128, 16), (128, 20), (128, 24), (128, 28), (128, 32), (128, 36), (128, 40), (128, 44), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128), (128, 132), (128, 136), (128, 140), (128, 144), (128, 148), (128, 152), (128, 156), (128, 160), (128, 164), (128, 168), (128, 172), (128, 176), (132, 16), (132, 20), (132, 24), (132, 28), (132, 32), (132, 36), (132, 40), (132, 44), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (132, 164), (132, 168), (132, 172), (132, 176), (136, 16), (136, 20), (136, 24), (136, 28), (136, 32), (136, 36), (136, 40), (136, 44), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (136, 164), (136, 168), (136, 172), (136, 176), (140, 16), (140, 20), (140, 24), (140, 28), (140, 32), (140, 36), (140, 40), (140, 44), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (140, 164), (140, 168), (140, 172), (140, 176), (144, 16), (144, 20), (144, 24), (144, 28), (144, 32), (144, 36), (144, 40), (144, 44), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (144, 164), (144, 168), (144, 172), (144, 176), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (148, 164), (148, 168), (148, 172), (148, 176), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (152, 164), (152, 168), (152, 172), (152, 176), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (156, 164), (156, 168), (156, 172), (156, 176), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 96), (160, 100), (160, 104), (160, 108), (160, 112), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160), (160, 164), (160, 168), (160, 172), (160, 176), (164, 48), (164, 52), (164, 56), (164, 60), (164, 64), (164, 68), (164, 72), (164, 76), (164, 80), (164, 84), (164, 88), (164, 92), (164, 96), (164, 100), (164, 104), (164, 108), (164, 112), (164, 116), (164, 120), (164, 124), (164, 128), (164, 132), (164, 136), (164, 140), (164, 144), (164, 148), (164, 152), (164, 156), (164, 160), (164, 164), (164, 168), (164, 172), (164, 176), (168, 48), (168, 52), (168, 56), (168, 60), (168, 64), (168, 68), (168, 72), (168, 76), (168, 80), (168, 84), (168, 88), (168, 92), (168, 96), (168, 100), (168, 104), (168, 108), (168, 112), (168, 116), (168, 120), (168, 124), (168, 128), (168, 132), (168, 136), (168, 140), (168, 144), (168, 148), (168, 152), (168, 156), (168, 160), (168, 164), (168, 168), (168, 172), (168, 176), (172, 48), (172, 52), (172, 56), (172, 60), (172, 64), (172, 68), (172, 72), (172, 76), (172, 80), (172, 84), (172, 88), (172, 92), (172, 96), (172, 100), (172, 104), (172, 108), (172, 112), (172, 116), (172, 120), (172, 124), (172, 128), (172, 132), (172, 136), (172, 140), (172, 144), (172, 148), (172, 152), (172, 156), (172, 160), (172, 164), (172, 168), (172, 172), (172, 176), (176, 48), (176, 52), (176, 56), (176, 60), (176, 64), (176, 68), (176, 72), (176, 76), (176, 80), (176, 84), (176, 88), (176, 92), (176, 96), (176, 100), (176, 104), (176, 108), (176, 112), (176, 116), (176, 120), (176, 124), (176, 128), (176, 132), (176, 136), (176, 140), (176, 144), (176, 148), (176, 152), (176, 156), (176, 160), (176, 164), (176, 168), (176, 172), (176, 176)]), 7: ([(100, 192), (100, 188), (100, 184), (100, 180), (100, 156), (100, 152), (100, 148), (100, 144), (100, 140), (100, 136), (100, 132), (100, 128), (100, 124), (100, 120), (100, 116), (100, 92), (100, 88), (100, 84), (100, 80), (100, 76), (100, 72), (100, 68), (100, 64), (100, 60), (100, 56), (100, 52), (100, 28), (100, 24), (100, 20), (100, 16), (96, 192), (96, 188), (96, 184), (96, 180), (96, 156), (96, 152), (96, 148), (96, 144), (96, 140), (96, 136), (96, 132), (96, 128), (96, 124), (96, 120), (96, 116), (96, 92), (96, 88), (96, 84), (96, 80), (96, 76), (96, 72), (96, 68), (96, 64), (96, 60), (96, 56), (96, 52), (96, 28), (96, 24), (96, 20), (96, 16), (92, 192), (92, 188), (92, 184), (92, 180), (92, 176), (92, 172), (92, 168), (92, 164), (92, 160), (92, 156), (92, 152), (92, 148), (92, 144), (92, 140), (92, 136), (92, 132), (92, 128), (92, 124), (92, 120), (92, 116), (92, 112), (92, 108), (92, 104), (92, 100), (92, 96), (92, 92), (92, 88), (92, 84), (92, 80), (92, 76), (92, 72), (92, 68), (92, 64), (92, 60), (92, 56), (92, 52), (92, 48), (92, 44), (92, 40), (92, 36), (92, 32), (92, 28), (92, 24), (92, 20), (92, 16), (88, 192), (88, 188), (88, 184), (88, 180), (88, 176), (88, 172), (88, 168), (88, 164), (88, 160), (88, 156), (88, 152), (88, 148), (88, 144), (88, 140), (88, 136), (88, 132), (88, 128), (88, 124), (88, 120), (88, 116), (88, 112), (88, 108), (88, 104), (88, 100), (88, 96), (88, 92), (88, 88), (88, 84), (88, 80), (88, 76), (88, 72), (88, 68), (88, 64), (88, 60), (88, 56), (88, 52), (88, 48), (88, 44), (88, 40), (88, 36), (88, 32), (88, 28), (88, 24), (88, 20), (88, 16), (84, 192), (84, 188), (84, 184), (84, 180), (84, 176), (84, 172), (84, 168), (84, 164), (84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 96), (84, 92), (84, 88), (84, 84), (84, 80), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 192), (80, 188), (80, 184), (80, 180), (80, 176), (80, 172), (80, 168), (80, 164), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 96), (80, 92), (80, 88), (80, 84), (80, 80), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 192), (76, 188), (76, 184), (76, 180), (76, 176), (76, 172), (76, 168), (76, 164), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 192), (72, 188), (72, 184), (72, 180), (72, 176), (72, 172), (72, 168), (72, 164), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 192), (68, 188), (68, 184), (68, 180), (68, 176), (68, 172), (68, 168), (68, 164), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 192), (64, 188), (64, 184), (64, 180), (64, 176), (64, 172), (64, 168), (64, 164), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 192), (60, 188), (60, 184), (60, 180), (60, 176), (60, 172), (60, 168), (60, 164), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 192), (56, 188), (56, 184), (56, 180), (56, 176), (56, 172), (56, 168), (56, 164), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 192), (52, 188), (52, 184), (52, 180), (52, 176), (52, 172), (52, 168), (52, 164), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 192), (48, 188), (48, 184), (48, 180), (48, 176), (48, 172), (48, 168), (48, 164), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 136), (48, 132), (48, 128), (48, 124), (48, 120), (48, 116), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 192), (44, 188), (44, 184), (44, 180), (44, 176), (44, 172), (44, 168), (44, 164), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 136), (44, 132), (44, 128), (44, 124), (44, 120), (44, 116), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 192), (40, 188), (40, 184), (40, 180), (40, 176), (40, 172), (40, 168), (40, 164), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 136), (40, 132), (40, 128), (40, 124), (40, 120), (40, 116), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 192), (36, 188), (36, 184), (36, 180), (36, 176), (36, 172), (36, 168), (36, 164), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 136), (36, 132), (36, 128), (36, 124), (36, 120), (36, 116), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 192), (32, 188), (32, 184), (32, 180), (32, 176), (32, 172), (32, 168), (32, 164), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 136), (32, 132), (32, 128), (32, 124), (32, 120), (32, 116), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 192), (28, 188), (28, 184), (28, 180), (28, 176), (28, 172), (28, 168), (28, 164), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 192), (24, 188), (24, 184), (24, 180), (24, 176), (24, 172), (24, 168), (24, 164), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 192), (20, 188), (20, 184), (20, 180), (20, 176), (20, 172), (20, 168), (20, 164), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 192), (16, 188), (16, 184), (16, 180), (16, 176), (16, 172), (16, 168), (16, 164), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(108, 16), (108, 20), (108, 24), (108, 28), (108, 52), (108, 56), (108, 60), (108, 64), (108, 68), (108, 72), (108, 76), (108, 80), (108, 84), (108, 88), (108, 92), (108, 116), (108, 120), (108, 124), (108, 128), (108, 132), (108, 136), (108, 140), (108, 144), (108, 148), (108, 152), (108, 156), (108, 180), (108, 184), (108, 188), (108, 192), (112, 16), (112, 20), (112, 24), (112, 28), (112, 52), (112, 56), (112, 60), (112, 64), (112, 68), (112, 72), (112, 76), (112, 80), (112, 84), (112, 88), (112, 92), (112, 116), (112, 120), (112, 124), (112, 128), (112, 132), (112, 136), (112, 140), (112, 144), (112, 148), (112, 152), (112, 156), (112, 180), (112, 184), (112, 188), (112, 192), (116, 16), (116, 20), (116, 24), (116, 28), (116, 32), (116, 36), (116, 40), (116, 44), (116, 48), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 104), (116, 108), (116, 112), (116, 116), (116, 120), (116, 124), (116, 128), (116, 132), (116, 136), (116, 140), (116, 144), (116, 148), (116, 152), (116, 156), (116, 160), (116, 164), (116, 168), (116, 172), (116, 176), (116, 180), (116, 184), (116, 188), (116, 192), (120, 16), (120, 20), (120, 24), (120, 28), (120, 32), (120, 36), (120, 40), (120, 44), (120, 48), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 104), (120, 108), (120, 112), (120, 116), (120, 120), (120, 124), (120, 128), (120, 132), (120, 136), (120, 140), (120, 144), (120, 148), (120, 152), (120, 156), (120, 160), (120, 164), (120, 168), (120, 172), (120, 176), (120, 180), (120, 184), (120, 188), (120, 192), (124, 16), (124, 20), (124, 24), (124, 28), (124, 32), (124, 36), (124, 40), (124, 44), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (124, 132), (124, 136), (124, 140), (124, 144), (124, 148), (124, 152), (124, 156), (124, 160), (124, 164), (124, 168), (124, 172), (124, 176), (124, 180), (124, 184), (124, 188), (124, 192), (128, 16), (128, 20), (128, 24), (128, 28), (128, 32), (128, 36), (128, 40), (128, 44), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128), (128, 132), (128, 136), (128, 140), (128, 144), (128, 148), (128, 152), (128, 156), (128, 160), (128, 164), (128, 168), (128, 172), (128, 176), (128, 180), (128, 184), (128, 188), (128, 192), (132, 16), (132, 20), (132, 24), (132, 28), (132, 32), (132, 36), (132, 40), (132, 44), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (132, 164), (132, 168), (132, 172), (132, 176), (132, 180), (132, 184), (132, 188), (132, 192), (136, 16), (136, 20), (136, 24), (136, 28), (136, 32), (136, 36), (136, 40), (136, 44), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (136, 164), (136, 168), (136, 172), (136, 176), (136, 180), (136, 184), (136, 188), (136, 192), (140, 16), (140, 20), (140, 24), (140, 28), (140, 32), (140, 36), (140, 40), (140, 44), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (140, 164), (140, 168), (140, 172), (140, 176), (140, 180), (140, 184), (140, 188), (140, 192), (144, 16), (144, 20), (144, 24), (144, 28), (144, 32), (144, 36), (144, 40), (144, 44), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (144, 164), (144, 168), (144, 172), (144, 176), (144, 180), (144, 184), (144, 188), (144, 192), (148, 16), (148, 20), (148, 24), (148, 28), (148, 32), (148, 36), (148, 40), (148, 44), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (148, 164), (148, 168), (148, 172), (148, 176), (148, 180), (148, 184), (148, 188), (148, 192), (152, 16), (152, 20), (152, 24), (152, 28), (152, 32), (152, 36), (152, 40), (152, 44), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (152, 164), (152, 168), (152, 172), (152, 176), (152, 180), (152, 184), (152, 188), (152, 192), (156, 16), (156, 20), (156, 24), (156, 28), (156, 32), (156, 36), (156, 40), (156, 44), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (156, 164), (156, 168), (156, 172), (156, 176), (156, 180), (156, 184), (156, 188), (156, 192), (160, 16), (160, 20), (160, 24), (160, 28), (160, 32), (160, 36), (160, 40), (160, 44), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160), (160, 164), (160, 168), (160, 172), (160, 176), (160, 180), (160, 184), (160, 188), (160, 192), (164, 48), (164, 52), (164, 56), (164, 60), (164, 64), (164, 68), (164, 72), (164, 76), (164, 80), (164, 84), (164, 88), (164, 92), (164, 116), (164, 120), (164, 124), (164, 128), (164, 132), (164, 136), (164, 140), (164, 144), (164, 148), (164, 152), (164, 156), (164, 160), (164, 164), (164, 168), (164, 172), (164, 176), (164, 180), (164, 184), (164, 188), (164, 192), (168, 48), (168, 52), (168, 56), (168, 60), (168, 64), (168, 68), (168, 72), (168, 76), (168, 80), (168, 84), (168, 88), (168, 92), (168, 116), (168, 120), (168, 124), (168, 128), (168, 132), (168, 136), (168, 140), (168, 144), (168, 148), (168, 152), (168, 156), (168, 160), (168, 164), (168, 168), (168, 172), (168, 176), (168, 180), (168, 184), (168, 188), (168, 192), (172, 48), (172, 52), (172, 56), (172, 60), (172, 64), (172, 68), (172, 72), (172, 76), (172, 80), (172, 84), (172, 88), (172, 92), (172, 116), (172, 120), (172, 124), (172, 128), (172, 132), (172, 136), (172, 140), (172, 144), (172, 148), (172, 152), (172, 156), (172, 160), (172, 164), (172, 168), (172, 172), (172, 176), (172, 180), (172, 184), (172, 188), (172, 192), (176, 48), (176, 52), (176, 56), (176, 60), (176, 64), (176, 68), (176, 72), (176, 76), (176, 80), (176, 84), (176, 88), (176, 92), (176, 116), (176, 120), (176, 124), (176, 128), (176, 132), (176, 136), (176, 140), (176, 144), (176, 148), (176, 152), (176, 156), (176, 160), (176, 164), (176, 168), (176, 172), (176, 176), (176, 180), (176, 184), (176, 188), (176, 192), (180, 48), (180, 52), (180, 56), (180, 60), (180, 64), (180, 68), (180, 72), (180, 76), (180, 80), (180, 84), (180, 88), (180, 92), (180, 96), (180, 100), (180, 104), (180, 108), (180, 112), (180, 116), (180, 120), (180, 124), (180, 128), (180, 132), (180, 136), (180, 140), (180, 144), (180, 148), (180, 152), (180, 156), (180, 160), (180, 164), (180, 168), (180, 172), (180, 176), (180, 180), (180, 184), (180, 188), (180, 192), (184, 48), (184, 52), (184, 56), (184, 60), (184, 64), (184, 68), (184, 72), (184, 76), (184, 80), (184, 84), (184, 88), (184, 92), (184, 96), (184, 100), (184, 104), (184, 108), (184, 112), (184, 116), (184, 120), (184, 124), (184, 128), (184, 132), (184, 136), (184, 140), (184, 144), (184, 148), (184, 152), (184, 156), (184, 160), (184, 164), (184, 168), (184, 172), (184, 176), (184, 180), (184, 184), (184, 188), (184, 192), (188, 48), (188, 52), (188, 56), (188, 60), (188, 64), (188, 68), (188, 72), (188, 76), (188, 80), (188, 84), (188, 88), (188, 92), (188, 96), (188, 100), (188, 104), (188, 108), (188, 112), (188, 116), (188, 120), (188, 124), (188, 128), (188, 132), (188, 136), (188, 140), (188, 144), (188, 148), (188, 152), (188, 156), (188, 160), (188, 164), (188, 168), (188, 172), (188, 176), (188, 180), (188, 184), (188, 188), (188, 192), (192, 48), (192, 52), (192, 56), (192, 60), (192, 64), (192, 68), (192, 72), (192, 76), (192, 80), (192, 84), (192, 88), (192, 92), (192, 96), (192, 100), (192, 104), (192, 108), (192, 112), (192, 116), (192, 120), (192, 124), (192, 128), (192, 132), (192, 136), (192, 140), (192, 144), (192, 148), (192, 152), (192, 156), (192, 160), (192, 164), (192, 168), (192, 172), (192, 176), (192, 180), (192, 184), (192, 188), (192, 192)]), 8: ([(108, 208), (108, 204), (108, 200), (108, 196), (108, 172), (108, 168), (108, 164), (108, 160), (108, 156), (108, 152), (108, 148), (108, 144), (108, 140), (108, 136), (108, 132), (108, 128), (108, 124), (108, 100), (108, 96), (108, 92), (108, 88), (108, 84), (108, 80), (108, 76), (108, 72), (108, 68), (108, 64), (108, 60), (108, 56), (108, 52), (108, 28), (108, 24), (108, 20), (108, 16), (104, 208), (104, 204), (104, 200), (104, 196), (104, 172), (104, 168), (104, 164), (104, 160), (104, 156), (104, 152), (104, 148), (104, 144), (104, 140), (104, 136), (104, 132), (104, 128), (104, 124), (104, 100), (104, 96), (104, 92), (104, 88), (104, 84), (104, 80), (104, 76), (104, 72), (104, 68), (104, 64), (104, 60), (104, 56), (104, 52), (104, 28), (104, 24), (104, 20), (104, 16), (100, 208), (100, 204), (100, 200), (100, 196), (100, 192), (100, 188), (100, 184), (100, 180), (100, 176), (100, 172), (100, 168), (100, 164), (100, 160), (100, 156), (100, 152), (100, 148), (100, 144), (100, 140), (100, 136), (100, 132), (100, 128), (100, 124), (100, 120), (100, 116), (100, 112), (100, 108), (100, 104), (100, 100), (100, 96), (100, 92), (100, 88), (100, 84), (100, 80), (100, 76), (100, 72), (100, 68), (100, 64), (100, 60), (100, 56), (100, 52), (100, 48), (100, 44), (100, 40), (100, 36), (100, 32), (100, 28), (100, 24), (100, 20), (100, 16), (96, 208), (96, 204), (96, 200), (96, 196), (96, 192), (96, 188), (96, 184), (96, 180), (96, 176), (96, 172), (96, 168), (96, 164), (96, 160), (96, 156), (96, 152), (96, 148), (96, 144), (96, 140), (96, 136), (96, 132), (96, 128), (96, 124), (96, 120), (96, 116), (96, 112), (96, 108), (96, 104), (96, 100), (96, 96), (96, 92), (96, 88), (96, 84), (96, 80), (96, 76), (96, 72), (96, 68), (96, 64), (96, 60), (96, 56), (96, 52), (96, 48), (96, 44), (96, 40), (96, 36), (96, 32), (96, 28), (96, 24), (96, 20), (96, 16), (92, 208), (92, 204), (92, 200), (92, 196), (92, 192), (92, 188), (92, 184), (92, 180), (92, 176), (92, 172), (92, 168), (92, 164), (92, 160), (92, 156), (92, 152), (92, 148), (92, 144), (92, 140), (92, 136), (92, 132), (92, 128), (92, 124), (92, 120), (92, 116), (92, 112), (92, 108), (92, 104), (92, 100), (92, 96), (92, 92), (92, 88), (92, 84), (92, 80), (92, 76), (92, 72), (92, 68), (92, 64), (92, 60), (92, 56), (92, 52), (92, 48), (92, 44), (92, 40), (92, 36), (92, 32), (92, 28), (92, 24), (92, 20), (92, 16), (88, 208), (88, 204), (88, 200), (88, 196), (88, 192), (88, 188), (88, 184), (88, 180), (88, 176), (88, 172), (88, 168), (88, 164), (88, 160), (88, 156), (88, 152), (88, 148), (88, 144), (88, 140), (88, 136), (88, 132), (88, 128), (88, 124), (88, 120), (88, 116), (88, 112), (88, 108), (88, 104), (88, 100), (88, 96), (88, 92), (88, 88), (88, 84), (88, 80), (88, 76), (88, 72), (88, 68), (88, 64), (88, 60), (88, 56), (88, 52), (88, 48), (88, 44), (88, 40), (88, 36), (88, 32), (88, 28), (88, 24), (88, 20), (88, 16), (84, 208), (84, 204), (84, 200), (84, 196), (84, 192), (84, 188), (84, 184), (84, 180), (84, 176), (84, 172), (84, 168), (84, 164), (84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 96), (84, 92), (84, 88), (84, 84), (84, 80), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 208), (80, 204), (80, 200), (80, 196), (80, 192), (80, 188), (80, 184), (80, 180), (80, 176), (80, 172), (80, 168), (80, 164), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 96), (80, 92), (80, 88), (80, 84), (80, 80), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 208), (76, 204), (76, 200), (76, 196), (76, 192), (76, 188), (76, 184), (76, 180), (76, 176), (76, 172), (76, 168), (76, 164), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 208), (72, 204), (72, 200), (72, 196), (72, 192), (72, 188), (72, 184), (72, 180), (72, 176), (72, 172), (72, 168), (72, 164), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 208), (68, 204), (68, 200), (68, 196), (68, 192), (68, 188), (68, 184), (68, 180), (68, 176), (68, 172), (68, 168), (68, 164), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 208), (64, 204), (64, 200), (64, 196), (64, 192), (64, 188), (64, 184), (64, 180), (64, 176), (64, 172), (64, 168), (64, 164), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 208), (60, 204), (60, 200), (60, 196), (60, 192), (60, 188), (60, 184), (60, 180), (60, 176), (60, 172), (60, 168), (60, 164), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 208), (56, 204), (56, 200), (56, 196), (56, 192), (56, 188), (56, 184), (56, 180), (56, 176), (56, 172), (56, 168), (56, 164), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 208), (52, 204), (52, 200), (52, 196), (52, 192), (52, 188), (52, 184), (52, 180), (52, 176), (52, 172), (52, 168), (52, 164), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 208), (48, 204), (48, 200), (48, 196), (48, 192), (48, 188), (48, 184), (48, 180), (48, 176), (48, 172), (48, 168), (48, 164), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 136), (48, 132), (48, 128), (48, 124), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 208), (44, 204), (44, 200), (44, 196), (44, 192), (44, 188), (44, 184), (44, 180), (44, 176), (44, 172), (44, 168), (44, 164), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 136), (44, 132), (44, 128), (44, 124), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 208), (40, 204), (40, 200), (40, 196), (40, 192), (40, 188), (40, 184), (40, 180), (40, 176), (40, 172), (40, 168), (40, 164), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 136), (40, 132), (40, 128), (40, 124), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 208), (36, 204), (36, 200), (36, 196), (36, 192), (36, 188), (36, 184), (36, 180), (36, 176), (36, 172), (36, 168), (36, 164), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 136), (36, 132), (36, 128), (36, 124), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 208), (32, 204), (32, 200), (32, 196), (32, 192), (32, 188), (32, 184), (32, 180), (32, 176), (32, 172), (32, 168), (32, 164), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 136), (32, 132), (32, 128), (32, 124), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 208), (28, 204), (28, 200), (28, 196), (28, 192), (28, 188), (28, 184), (28, 180), (28, 176), (28, 172), (28, 168), (28, 164), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 208), (24, 204), (24, 200), (24, 196), (24, 192), (24, 188), (24, 184), (24, 180), (24, 176), (24, 172), (24, 168), (24, 164), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 208), (20, 204), (20, 200), (20, 196), (20, 192), (20, 188), (20, 184), (20, 180), (20, 176), (20, 172), (20, 168), (20, 164), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 208), (16, 204), (16, 200), (16, 196), (16, 192), (16, 188), (16, 184), (16, 180), (16, 176), (16, 172), (16, 168), (16, 164), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(116, 16), (116, 20), (116, 24), (116, 28), (116, 52), (116, 56), (116, 60), (116, 64), (116, 68), (116, 72), (116, 76), (116, 80), (116, 84), (116, 88), (116, 92), (116, 96), (116, 100), (116, 124), (116, 128), (116, 132), (116, 136), (116, 140), (116, 144), (116, 148), (116, 152), (116, 156), (116, 160), (116, 164), (116, 168), (116, 172), (116, 196), (116, 200), (116, 204), (116, 208), (120, 16), (120, 20), (120, 24), (120, 28), (120, 52), (120, 56), (120, 60), (120, 64), (120, 68), (120, 72), (120, 76), (120, 80), (120, 84), (120, 88), (120, 92), (120, 96), (120, 100), (120, 124), (120, 128), (120, 132), (120, 136), (120, 140), (120, 144), (120, 148), (120, 152), (120, 156), (120, 160), (120, 164), (120, 168), (120, 172), (120, 196), (120, 200), (120, 204), (120, 208), (124, 16), (124, 20), (124, 24), (124, 28), (124, 32), (124, 36), (124, 40), (124, 44), (124, 48), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 112), (124, 116), (124, 120), (124, 124), (124, 128), (124, 132), (124, 136), (124, 140), (124, 144), (124, 148), (124, 152), (124, 156), (124, 160), (124, 164), (124, 168), (124, 172), (124, 176), (124, 180), (124, 184), (124, 188), (124, 192), (124, 196), (124, 200), (124, 204), (124, 208), (128, 16), (128, 20), (128, 24), (128, 28), (128, 32), (128, 36), (128, 40), (128, 44), (128, 48), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 112), (128, 116), (128, 120), (128, 124), (128, 128), (128, 132), (128, 136), (128, 140), (128, 144), (128, 148), (128, 152), (128, 156), (128, 160), (128, 164), (128, 168), (128, 172), (128, 176), (128, 180), (128, 184), (128, 188), (128, 192), (128, 196), (128, 200), (128, 204), (128, 208), (132, 16), (132, 20), (132, 24), (132, 28), (132, 32), (132, 36), (132, 40), (132, 44), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (132, 164), (132, 168), (132, 172), (132, 176), (132, 180), (132, 184), (132, 188), (132, 192), (132, 196), (132, 200), (132, 204), (132, 208), (136, 16), (136, 20), (136, 24), (136, 28), (136, 32), (136, 36), (136, 40), (136, 44), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (136, 164), (136, 168), (136, 172), (136, 176), (136, 180), (136, 184), (136, 188), (136, 192), (136, 196), (136, 200), (136, 204), (136, 208), (140, 16), (140, 20), (140, 24), (140, 28), (140, 32), (140, 36), (140, 40), (140, 44), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (140, 164), (140, 168), (140, 172), (140, 176), (140, 180), (140, 184), (140, 188), (140, 192), (140, 196), (140, 200), (140, 204), (140, 208), (144, 16), (144, 20), (144, 24), (144, 28), (144, 32), (144, 36), (144, 40), (144, 44), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (144, 164), (144, 168), (144, 172), (144, 176), (144, 180), (144, 184), (144, 188), (144, 192), (144, 196), (144, 200), (144, 204), (144, 208), (148, 16), (148, 20), (148, 24), (148, 28), (148, 32), (148, 36), (148, 40), (148, 44), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (148, 164), (148, 168), (148, 172), (148, 176), (148, 180), (148, 184), (148, 188), (148, 192), (148, 196), (148, 200), (148, 204), (148, 208), (152, 16), (152, 20), (152, 24), (152, 28), (152, 32), (152, 36), (152, 40), (152, 44), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (152, 164), (152, 168), (152, 172), (152, 176), (152, 180), (152, 184), (152, 188), (152, 192), (152, 196), (152, 200), (152, 204), (152, 208), (156, 16), (156, 20), (156, 24), (156, 28), (156, 32), (156, 36), (156, 40), (156, 44), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (156, 164), (156, 168), (156, 172), (156, 176), (156, 180), (156, 184), (156, 188), (156, 192), (156, 196), (156, 200), (156, 204), (156, 208), (160, 16), (160, 20), (160, 24), (160, 28), (160, 32), (160, 36), (160, 40), (160, 44), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 96), (160, 100), (160, 104), (160, 108), (160, 112), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160), (160, 164), (160, 168), (160, 172), (160, 176), (160, 180), (160, 184), (160, 188), (160, 192), (160, 196), (160, 200), (160, 204), (160, 208), (164, 16), (164, 20), (164, 24), (164, 28), (164, 32), (164, 36), (164, 40), (164, 44), (164, 48), (164, 52), (164, 56), (164, 60), (164, 64), (164, 68), (164, 72), (164, 76), (164, 80), (164, 84), (164, 88), (164, 92), (164, 96), (164, 100), (164, 104), (164, 108), (164, 112), (164, 116), (164, 120), (164, 124), (164, 128), (164, 132), (164, 136), (164, 140), (164, 144), (164, 148), (164, 152), (164, 156), (164, 160), (164, 164), (164, 168), (164, 172), (164, 176), (164, 180), (164, 184), (164, 188), (164, 192), (164, 196), (164, 200), (164, 204), (164, 208), (168, 16), (168, 20), (168, 24), (168, 28), (168, 32), (168, 36), (168, 40), (168, 44), (168, 48), (168, 52), (168, 56), (168, 60), (168, 64), (168, 68), (168, 72), (168, 76), (168, 80), (168, 84), (168, 88), (168, 92), (168, 96), (168, 100), (168, 104), (168, 108), (168, 112), (168, 116), (168, 120), (168, 124), (168, 128), (168, 132), (168, 136), (168, 140), (168, 144), (168, 148), (168, 152), (168, 156), (168, 160), (168, 164), (168, 168), (168, 172), (168, 176), (168, 180), (168, 184), (168, 188), (168, 192), (168, 196), (168, 200), (168, 204), (168, 208), (172, 16), (172, 20), (172, 24), (172, 28), (172, 32), (172, 36), (172, 40), (172, 44), (172, 48), (172, 52), (172, 56), (172, 60), (172, 64), (172, 68), (172, 72), (172, 76), (172, 80), (172, 84), (172, 88), (172, 92), (172, 96), (172, 100), (172, 104), (172, 108), (172, 112), (172, 116), (172, 120), (172, 124), (172, 128), (172, 132), (172, 136), (172, 140), (172, 144), (172, 148), (172, 152), (172, 156), (172, 160), (172, 164), (172, 168), (172, 172), (172, 176), (172, 180), (172, 184), (172, 188), (172, 192), (172, 196), (172, 200), (172, 204), (172, 208), (176, 16), (176, 20), (176, 24), (176, 28), (176, 32), (176, 36), (176, 40), (176, 44), (176, 48), (176, 52), (176, 56), (176, 60), (176, 64), (176, 68), (176, 72), (176, 76), (176, 80), (176, 84), (176, 88), (176, 92), (176, 96), (176, 100), (176, 124), (176, 128), (176, 132), (176, 136), (176, 140), (176, 144), (176, 148), (176, 152), (176, 156), (176, 160), (176, 164), (176, 168), (176, 172), (176, 176), (176, 180), (176, 184), (176, 188), (176, 192), (176, 196), (176, 200), (176, 204), (176, 208), (180, 48), (180, 52), (180, 56), (180, 60), (180, 64), (180, 68), (180, 72), (180, 76), (180, 80), (180, 84), (180, 88), (180, 92), (180, 96), (180, 100), (180, 124), (180, 128), (180, 132), (180, 136), (180, 140), (180, 144), (180, 148), (180, 152), (180, 156), (180, 160), (180, 164), (180, 168), (180, 172), (180, 176), (180, 180), (180, 184), (180, 188), (180, 192), (180, 196), (180, 200), (180, 204), (180, 208), (184, 48), (184, 52), (184, 56), (184, 60), (184, 64), (184, 68), (184, 72), (184, 76), (184, 80), (184, 84), (184, 88), (184, 92), (184, 96), (184, 100), (184, 124), (184, 128), (184, 132), (184, 136), (184, 140), (184, 144), (184, 148), (184, 152), (184, 156), (184, 160), (184, 164), (184, 168), (184, 172), (184, 176), (184, 180), (184, 184), (184, 188), (184, 192), (184, 196), (184, 200), (184, 204), (184, 208), (188, 48), (188, 52), (188, 56), (188, 60), (188, 64), (188, 68), (188, 72), (188, 76), (188, 80), (188, 84), (188, 88), (188, 92), (188, 96), (188, 100), (188, 124), (188, 128), (188, 132), (188, 136), (188, 140), (188, 144), (188, 148), (188, 152), (188, 156), (188, 160), (188, 164), (188, 168), (188, 172), (188, 176), (188, 180), (188, 184), (188, 188), (188, 192), (188, 196), (188, 200), (188, 204), (188, 208), (192, 48), (192, 52), (192, 56), (192, 60), (192, 64), (192, 68), (192, 72), (192, 76), (192, 80), (192, 84), (192, 88), (192, 92), (192, 96), (192, 100), (192, 124), (192, 128), (192, 132), (192, 136), (192, 140), (192, 144), (192, 148), (192, 152), (192, 156), (192, 160), (192, 164), (192, 168), (192, 172), (192, 176), (192, 180), (192, 184), (192, 188), (192, 192), (192, 196), (192, 200), (192, 204), (192, 208), (196, 48), (196, 52), (196, 56), (196, 60), (196, 64), (196, 68), (196, 72), (196, 76), (196, 80), (196, 84), (196, 88), (196, 92), (196, 96), (196, 100), (196, 104), (196, 108), (196, 112), (196, 116), (196, 120), (196, 124), (196, 128), (196, 132), (196, 136), (196, 140), (196, 144), (196, 148), (196, 152), (196, 156), (196, 160), (196, 164), (196, 168), (196, 172), (196, 176), (196, 180), (196, 184), (196, 188), (196, 192), (196, 196), (196, 200), (196, 204), (196, 208), (200, 48), (200, 52), (200, 56), (200, 60), (200, 64), (200, 68), (200, 72), (200, 76), (200, 80), (200, 84), (200, 88), (200, 92), (200, 96), (200, 100), (200, 104), (200, 108), (200, 112), (200, 116), (200, 120), (200, 124), (200, 128), (200, 132), (200, 136), (200, 140), (200, 144), (200, 148), (200, 152), (200, 156), (200, 160), (200, 164), (200, 168), (200, 172), (200, 176), (200, 180), (200, 184), (200, 188), (200, 192), (200, 196), (200, 200), (200, 204), (200, 208), (204, 48), (204, 52), (204, 56), (204, 60), (204, 64), (204, 68), (204, 72), (204, 76), (204, 80), (204, 84), (204, 88), (204, 92), (204, 96), (204, 100), (204, 104), (204, 108), (204, 112), (204, 116), (204, 120), (204, 124), (204, 128), (204, 132), (204, 136), (204, 140), (204, 144), (204, 148), (204, 152), (204, 156), (204, 160), (204, 164), (204, 168), (204, 172), (204, 176), (204, 180), (204, 184), (204, 188), (204, 192), (204, 196), (204, 200), (204, 204), (204, 208), (208, 48), (208, 52), (208, 56), (208, 60), (208, 64), (208, 68), (208, 72), (208, 76), (208, 80), (208, 84), (208, 88), (208, 92), (208, 96), (208, 100), (208, 104), (208, 108), (208, 112), (208, 116), (208, 120), (208, 124), (208, 128), (208, 132), (208, 136), (208, 140), (208, 144), (208, 148), (208, 152), (208, 156), (208, 160), (208, 164), (208, 168), (208, 172), (208, 176), (208, 180), (208, 184), (208, 188), (208, 192), (208, 196), (208, 200), (208, 204), (208, 208)]), 9: ([(116, 224), (116, 220), (116, 216), (116, 212), (116, 188), (116, 184), (116, 180), (116, 176), (116, 172), (116, 168), (116, 164), (116, 160), (116, 156), (116, 152), (116, 148), (116, 144), (116, 140), (116, 136), (116, 132), (116, 108), (116, 104), (116, 100), (116, 96), (116, 92), (116, 88), (116, 84), (116, 80), (116, 76), (116, 72), (116, 68), (116, 64), (116, 60), (116, 56), (116, 52), (116, 28), (116, 24), (116, 20), (116, 16), (112, 224), (112, 220), (112, 216), (112, 212), (112, 188), (112, 184), (112, 180), (112, 176), (112, 172), (112, 168), (112, 164), (112, 160), (112, 156), (112, 152), (112, 148), (112, 144), (112, 140), (112, 136), (112, 132), (112, 108), (112, 104), (112, 100), (112, 96), (112, 92), (112, 88), (112, 84), (112, 80), (112, 76), (112, 72), (112, 68), (112, 64), (112, 60), (112, 56), (112, 52), (112, 28), (112, 24), (112, 20), (112, 16), (108, 224), (108, 220), (108, 216), (108, 212), (108, 208), (108, 204), (108, 200), (108, 196), (108, 192), (108, 188), (108, 184), (108, 180), (108, 176), (108, 172), (108, 168), (108, 164), (108, 160), (108, 156), (108, 152), (108, 148), (108, 144), (108, 140), (108, 136), (108, 132), (108, 128), (108, 124), (108, 120), (108, 116), (108, 112), (108, 108), (108, 104), (108, 100), (108, 96), (108, 92), (108, 88), (108, 84), (108, 80), (108, 76), (108, 72), (108, 68), (108, 64), (108, 60), (108, 56), (108, 52), (108, 48), (108, 44), (108, 40), (108, 36), (108, 32), (108, 28), (108, 24), (108, 20), (108, 16), (104, 224), (104, 220), (104, 216), (104, 212), (104, 208), (104, 204), (104, 200), (104, 196), (104, 192), (104, 188), (104, 184), (104, 180), (104, 176), (104, 172), (104, 168), (104, 164), (104, 160), (104, 156), (104, 152), (104, 148), (104, 144), (104, 140), (104, 136), (104, 132), (104, 128), (104, 124), (104, 120), (104, 116), (104, 112), (104, 108), (104, 104), (104, 100), (104, 96), (104, 92), (104, 88), (104, 84), (104, 80), (104, 76), (104, 72), (104, 68), (104, 64), (104, 60), (104, 56), (104, 52), (104, 48), (104, 44), (104, 40), (104, 36), (104, 32), (104, 28), (104, 24), (104, 20), (104, 16), (100, 224), (100, 220), (100, 216), (100, 212), (100, 208), (100, 204), (100, 200), (100, 196), (100, 192), (100, 188), (100, 184), (100, 180), (100, 176), (100, 172), (100, 168), (100, 164), (100, 160), (100, 156), (100, 152), (100, 148), (100, 144), (100, 140), (100, 136), (100, 132), (100, 128), (100, 124), (100, 120), (100, 116), (100, 112), (100, 108), (100, 104), (100, 100), (100, 96), (100, 92), (100, 88), (100, 84), (100, 80), (100, 76), (100, 72), (100, 68), (100, 64), (100, 60), (100, 56), (100, 52), (100, 48), (100, 44), (100, 40), (100, 36), (100, 32), (100, 28), (100, 24), (100, 20), (100, 16), (96, 224), (96, 220), (96, 216), (96, 212), (96, 208), (96, 204), (96, 200), (96, 196), (96, 192), (96, 188), (96, 184), (96, 180), (96, 176), (96, 172), (96, 168), (96, 164), (96, 160), (96, 156), (96, 152), (96, 148), (96, 144), (96, 140), (96, 136), (96, 132), (96, 128), (96, 124), (96, 120), (96, 116), (96, 112), (96, 108), (96, 104), (96, 100), (96, 96), (96, 92), (96, 88), (96, 84), (96, 80), (96, 76), (96, 72), (96, 68), (96, 64), (96, 60), (96, 56), (96, 52), (96, 48), (96, 44), (96, 40), (96, 36), (96, 32), (96, 28), (96, 24), (96, 20), (96, 16), (92, 224), (92, 220), (92, 216), (92, 212), (92, 208), (92, 204), (92, 200), (92, 196), (92, 192), (92, 188), (92, 184), (92, 180), (92, 176), (92, 172), (92, 168), (92, 164), (92, 160), (92, 156), (92, 152), (92, 148), (92, 144), (92, 140), (92, 136), (92, 132), (92, 128), (92, 124), (92, 120), (92, 116), (92, 112), (92, 108), (92, 104), (92, 100), (92, 96), (92, 92), (92, 88), (92, 84), (92, 80), (92, 76), (92, 72), (92, 68), (92, 64), (92, 60), (92, 56), (92, 52), (92, 48), (92, 44), (92, 40), (92, 36), (92, 32), (92, 28), (92, 24), (92, 20), (92, 16), (88, 224), (88, 220), (88, 216), (88, 212), (88, 208), (88, 204), (88, 200), (88, 196), (88, 192), (88, 188), (88, 184), (88, 180), (88, 176), (88, 172), (88, 168), (88, 164), (88, 160), (88, 156), (88, 152), (88, 148), (88, 144), (88, 140), (88, 136), (88, 132), (88, 128), (88, 124), (88, 120), (88, 116), (88, 112), (88, 108), (88, 104), (88, 100), (88, 96), (88, 92), (88, 88), (88, 84), (88, 80), (88, 76), (88, 72), (88, 68), (88, 64), (88, 60), (88, 56), (88, 52), (88, 48), (88, 44), (88, 40), (88, 36), (88, 32), (88, 28), (88, 24), (88, 20), (88, 16), (84, 224), (84, 220), (84, 216), (84, 212), (84, 208), (84, 204), (84, 200), (84, 196), (84, 192), (84, 188), (84, 184), (84, 180), (84, 176), (84, 172), (84, 168), (84, 164), (84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 96), (84, 92), (84, 88), (84, 84), (84, 80), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 224), (80, 220), (80, 216), (80, 212), (80, 208), (80, 204), (80, 200), (80, 196), (80, 192), (80, 188), (80, 184), (80, 180), (80, 176), (80, 172), (80, 168), (80, 164), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 96), (80, 92), (80, 88), (80, 84), (80, 80), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 224), (76, 220), (76, 216), (76, 212), (76, 208), (76, 204), (76, 200), (76, 196), (76, 192), (76, 188), (76, 184), (76, 180), (76, 176), (76, 172), (76, 168), (76, 164), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 224), (72, 220), (72, 216), (72, 212), (72, 208), (72, 204), (72, 200), (72, 196), (72, 192), (72, 188), (72, 184), (72, 180), (72, 176), (72, 172), (72, 168), (72, 164), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 224), (68, 220), (68, 216), (68, 212), (68, 208), (68, 204), (68, 200), (68, 196), (68, 192), (68, 188), (68, 184), (68, 180), (68, 176), (68, 172), (68, 168), (68, 164), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 224), (64, 220), (64, 216), (64, 212), (64, 208), (64, 204), (64, 200), (64, 196), (64, 192), (64, 188), (64, 184), (64, 180), (64, 176), (64, 172), (64, 168), (64, 164), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 224), (60, 220), (60, 216), (60, 212), (60, 208), (60, 204), (60, 200), (60, 196), (60, 192), (60, 188), (60, 184), (60, 180), (60, 176), (60, 172), (60, 168), (60, 164), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 224), (56, 220), (56, 216), (56, 212), (56, 208), (56, 204), (56, 200), (56, 196), (56, 192), (56, 188), (56, 184), (56, 180), (56, 176), (56, 172), (56, 168), (56, 164), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 224), (52, 220), (52, 216), (52, 212), (52, 208), (52, 204), (52, 200), (52, 196), (52, 192), (52, 188), (52, 184), (52, 180), (52, 176), (52, 172), (52, 168), (52, 164), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 224), (48, 220), (48, 216), (48, 212), (48, 208), (48, 204), (48, 200), (48, 196), (48, 192), (48, 188), (48, 184), (48, 180), (48, 176), (48, 172), (48, 168), (48, 164), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 136), (48, 132), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 224), (44, 220), (44, 216), (44, 212), (44, 208), (44, 204), (44, 200), (44, 196), (44, 192), (44, 188), (44, 184), (44, 180), (44, 176), (44, 172), (44, 168), (44, 164), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 136), (44, 132), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 224), (40, 220), (40, 216), (40, 212), (40, 208), (40, 204), (40, 200), (40, 196), (40, 192), (40, 188), (40, 184), (40, 180), (40, 176), (40, 172), (40, 168), (40, 164), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 136), (40, 132), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 224), (36, 220), (36, 216), (36, 212), (36, 208), (36, 204), (36, 200), (36, 196), (36, 192), (36, 188), (36, 184), (36, 180), (36, 176), (36, 172), (36, 168), (36, 164), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 136), (36, 132), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 224), (32, 220), (32, 216), (32, 212), (32, 208), (32, 204), (32, 200), (32, 196), (32, 192), (32, 188), (32, 184), (32, 180), (32, 176), (32, 172), (32, 168), (32, 164), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 136), (32, 132), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 224), (28, 220), (28, 216), (28, 212), (28, 208), (28, 204), (28, 200), (28, 196), (28, 192), (28, 188), (28, 184), (28, 180), (28, 176), (28, 172), (28, 168), (28, 164), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 224), (24, 220), (24, 216), (24, 212), (24, 208), (24, 204), (24, 200), (24, 196), (24, 192), (24, 188), (24, 184), (24, 180), (24, 176), (24, 172), (24, 168), (24, 164), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 224), (20, 220), (20, 216), (20, 212), (20, 208), (20, 204), (20, 200), (20, 196), (20, 192), (20, 188), (20, 184), (20, 180), (20, 176), (20, 172), (20, 168), (20, 164), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 224), (16, 220), (16, 216), (16, 212), (16, 208), (16, 204), (16, 200), (16, 196), (16, 192), (16, 188), (16, 184), (16, 180), (16, 176), (16, 172), (16, 168), (16, 164), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(124, 16), (124, 20), (124, 24), (124, 28), (124, 52), (124, 56), (124, 60), (124, 64), (124, 68), (124, 72), (124, 76), (124, 80), (124, 84), (124, 88), (124, 92), (124, 96), (124, 100), (124, 104), (124, 108), (124, 132), (124, 136), (124, 140), (124, 144), (124, 148), (124, 152), (124, 156), (124, 160), (124, 164), (124, 168), (124, 172), (124, 176), (124, 180), (124, 184), (124, 188), (124, 212), (124, 216), (124, 220), (124, 224), (128, 16), (128, 20), (128, 24), (128, 28), (128, 52), (128, 56), (128, 60), (128, 64), (128, 68), (128, 72), (128, 76), (128, 80), (128, 84), (128, 88), (128, 92), (128, 96), (128, 100), (128, 104), (128, 108), (128, 132), (128, 136), (128, 140), (128, 144), (128, 148), (128, 152), (128, 156), (128, 160), (128, 164), (128, 168), (128, 172), (128, 176), (128, 180), (128, 184), (128, 188), (128, 212), (128, 216), (128, 220), (128, 224), (132, 16), (132, 20), (132, 24), (132, 28), (132, 32), (132, 36), (132, 40), (132, 44), (132, 48), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 120), (132, 124), (132, 128), (132, 132), (132, 136), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (132, 164), (132, 168), (132, 172), (132, 176), (132, 180), (132, 184), (132, 188), (132, 192), (132, 196), (132, 200), (132, 204), (132, 208), (132, 212), (132, 216), (132, 220), (132, 224), (136, 16), (136, 20), (136, 24), (136, 28), (136, 32), (136, 36), (136, 40), (136, 44), (136, 48), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 120), (136, 124), (136, 128), (136, 132), (136, 136), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (136, 164), (136, 168), (136, 172), (136, 176), (136, 180), (136, 184), (136, 188), (136, 192), (136, 196), (136, 200), (136, 204), (136, 208), (136, 212), (136, 216), (136, 220), (136, 224), (140, 16), (140, 20), (140, 24), (140, 28), (140, 32), (140, 36), (140, 40), (140, 44), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (140, 164), (140, 168), (140, 172), (140, 176), (140, 180), (140, 184), (140, 188), (140, 192), (140, 196), (140, 200), (140, 204), (140, 208), (140, 212), (140, 216), (140, 220), (140, 224), (144, 16), (144, 20), (144, 24), (144, 28), (144, 32), (144, 36), (144, 40), (144, 44), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (144, 164), (144, 168), (144, 172), (144, 176), (144, 180), (144, 184), (144, 188), (144, 192), (144, 196), (144, 200), (144, 204), (144, 208), (144, 212), (144, 216), (144, 220), (144, 224), (148, 16), (148, 20), (148, 24), (148, 28), (148, 32), (148, 36), (148, 40), (148, 44), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (148, 164), (148, 168), (148, 172), (148, 176), (148, 180), (148, 184), (148, 188), (148, 192), (148, 196), (148, 200), (148, 204), (148, 208), (148, 212), (148, 216), (148, 220), (148, 224), (152, 16), (152, 20), (152, 24), (152, 28), (152, 32), (152, 36), (152, 40), (152, 44), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (152, 164), (152, 168), (152, 172), (152, 176), (152, 180), (152, 184), (152, 188), (152, 192), (152, 196), (152, 200), (152, 204), (152, 208), (152, 212), (152, 216), (152, 220), (152, 224), (156, 16), (156, 20), (156, 24), (156, 28), (156, 32), (156, 36), (156, 40), (156, 44), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (156, 164), (156, 168), (156, 172), (156, 176), (156, 180), (156, 184), (156, 188), (156, 192), (156, 196), (156, 200), (156, 204), (156, 208), (156, 212), (156, 216), (156, 220), (156, 224), (160, 16), (160, 20), (160, 24), (160, 28), (160, 32), (160, 36), (160, 40), (160, 44), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 96), (160, 100), (160, 104), (160, 108), (160, 112), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160), (160, 164), (160, 168), (160, 172), (160, 176), (160, 180), (160, 184), (160, 188), (160, 192), (160, 196), (160, 200), (160, 204), (160, 208), (160, 212), (160, 216), (160, 220), (160, 224), (164, 16), (164, 20), (164, 24), (164, 28), (164, 32), (164, 36), (164, 40), (164, 44), (164, 48), (164, 52), (164, 56), (164, 60), (164, 64), (164, 68), (164, 72), (164, 76), (164, 80), (164, 84), (164, 88), (164, 92), (164, 96), (164, 100), (164, 104), (164, 108), (164, 112), (164, 116), (164, 120), (164, 124), (164, 128), (164, 132), (164, 136), (164, 140), (164, 144), (164, 148), (164, 152), (164, 156), (164, 160), (164, 164), (164, 168), (164, 172), (164, 176), (164, 180), (164, 184), (164, 188), (164, 192), (164, 196), (164, 200), (164, 204), (164, 208), (164, 212), (164, 216), (164, 220), (164, 224), (168, 16), (168, 20), (168, 24), (168, 28), (168, 32), (168, 36), (168, 40), (168, 44), (168, 48), (168, 52), (168, 56), (168, 60), (168, 64), (168, 68), (168, 72), (168, 76), (168, 80), (168, 84), (168, 88), (168, 92), (168, 96), (168, 100), (168, 104), (168, 108), (168, 112), (168, 116), (168, 120), (168, 124), (168, 128), (168, 132), (168, 136), (168, 140), (168, 144), (168, 148), (168, 152), (168, 156), (168, 160), (168, 164), (168, 168), (168, 172), (168, 176), (168, 180), (168, 184), (168, 188), (168, 192), (168, 196), (168, 200), (168, 204), (168, 208), (168, 212), (168, 216), (168, 220), (168, 224), (172, 16), (172, 20), (172, 24), (172, 28), (172, 32), (172, 36), (172, 40), (172, 44), (172, 48), (172, 52), (172, 56), (172, 60), (172, 64), (172, 68), (172, 72), (172, 76), (172, 80), (172, 84), (172, 88), (172, 92), (172, 96), (172, 100), (172, 104), (172, 108), (172, 112), (172, 116), (172, 120), (172, 124), (172, 128), (172, 132), (172, 136), (172, 140), (172, 144), (172, 148), (172, 152), (172, 156), (172, 160), (172, 164), (172, 168), (172, 172), (172, 176), (172, 180), (172, 184), (172, 188), (172, 192), (172, 196), (172, 200), (172, 204), (172, 208), (172, 212), (172, 216), (172, 220), (172, 224), (176, 16), (176, 20), (176, 24), (176, 28), (176, 32), (176, 36), (176, 40), (176, 44), (176, 48), (176, 52), (176, 56), (176, 60), (176, 64), (176, 68), (176, 72), (176, 76), (176, 80), (176, 84), (176, 88), (176, 92), (176, 96), (176, 100), (176, 104), (176, 108), (176, 112), (176, 116), (176, 120), (176, 124), (176, 128), (176, 132), (176, 136), (176, 140), (176, 144), (176, 148), (176, 152), (176, 156), (176, 160), (176, 164), (176, 168), (176, 172), (176, 176), (176, 180), (176, 184), (176, 188), (176, 192), (176, 196), (176, 200), (176, 204), (176, 208), (176, 212), (176, 216), (176, 220), (176, 224), (180, 16), (180, 20), (180, 24), (180, 28), (180, 32), (180, 36), (180, 40), (180, 44), (180, 48), (180, 52), (180, 56), (180, 60), (180, 64), (180, 68), (180, 72), (180, 76), (180, 80), (180, 84), (180, 88), (180, 92), (180, 96), (180, 100), (180, 104), (180, 108), (180, 112), (180, 116), (180, 120), (180, 124), (180, 128), (180, 132), (180, 136), (180, 140), (180, 144), (180, 148), (180, 152), (180, 156), (180, 160), (180, 164), (180, 168), (180, 172), (180, 176), (180, 180), (180, 184), (180, 188), (180, 192), (180, 196), (180, 200), (180, 204), (180, 208), (180, 212), (180, 216), (180, 220), (180, 224), (184, 16), (184, 20), (184, 24), (184, 28), (184, 32), (184, 36), (184, 40), (184, 44), (184, 48), (184, 52), (184, 56), (184, 60), (184, 64), (184, 68), (184, 72), (184, 76), (184, 80), (184, 84), (184, 88), (184, 92), (184, 96), (184, 100), (184, 104), (184, 108), (184, 112), (184, 116), (184, 120), (184, 124), (184, 128), (184, 132), (184, 136), (184, 140), (184, 144), (184, 148), (184, 152), (184, 156), (184, 160), (184, 164), (184, 168), (184, 172), (184, 176), (184, 180), (184, 184), (184, 188), (184, 192), (184, 196), (184, 200), (184, 204), (184, 208), (184, 212), (184, 216), (184, 220), (184, 224), (188, 16), (188, 20), (188, 24), (188, 28), (188, 32), (188, 36), (188, 40), (188, 44), (188, 48), (188, 52), (188, 56), (188, 60), (188, 64), (188, 68), (188, 72), (188, 76), (188, 80), (188, 84), (188, 88), (188, 92), (188, 96), (188, 100), (188, 104), (188, 108), (188, 112), (188, 116), (188, 120), (188, 124), (188, 128), (188, 132), (188, 136), (188, 140), (188, 144), (188, 148), (188, 152), (188, 156), (188, 160), (188, 164), (188, 168), (188, 172), (188, 176), (188, 180), (188, 184), (188, 188), (188, 192), (188, 196), (188, 200), (188, 204), (188, 208), (188, 212), (188, 216), (188, 220), (188, 224), (192, 16), (192, 20), (192, 24), (192, 28), (192, 32), (192, 36), (192, 40), (192, 44), (192, 48), (192, 52), (192, 56), (192, 60), (192, 64), (192, 68), (192, 72), (192, 76), (192, 80), (192, 84), (192, 88), (192, 92), (192, 96), (192, 100), (192, 104), (192, 108), (192, 132), (192, 136), (192, 140), (192, 144), (192, 148), (192, 152), (192, 156), (192, 160), (192, 164), (192, 168), (192, 172), (192, 176), (192, 180), (192, 184), (192, 188), (192, 192), (192, 196), (192, 200), (192, 204), (192, 208), (192, 212), (192, 216), (192, 220), (192, 224), (196, 48), (196, 52), (196, 56), (196, 60), (196, 64), (196, 68), (196, 72), (196, 76), (196, 80), (196, 84), (196, 88), (196, 92), (196, 96), (196, 100), (196, 104), (196, 108), (196, 132), (196, 136), (196, 140), (196, 144), (196, 148), (196, 152), (196, 156), (196, 160), (196, 164), (196, 168), (196, 172), (196, 176), (196, 180), (196, 184), (196, 188), (196, 192), (196, 196), (196, 200), (196, 204), (196, 208), (196, 212), (196, 216), (196, 220), (196, 224), (200, 48), (200, 52), (200, 56), (200, 60), (200, 64), (200, 68), (200, 72), (200, 76), (200, 80), (200, 84), (200, 88), (200, 92), (200, 96), (200, 100), (200, 104), (200, 108), (200, 132), (200, 136), (200, 140), (200, 144), (200, 148), (200, 152), (200, 156), (200, 160), (200, 164), (200, 168), (200, 172), (200, 176), (200, 180), (200, 184), (200, 188), (200, 192), (200, 196), (200, 200), (200, 204), (200, 208), (200, 212), (200, 216), (200, 220), (200, 224), (204, 48), (204, 52), (204, 56), (204, 60), (204, 64), (204, 68), (204, 72), (204, 76), (204, 80), (204, 84), (204, 88), (204, 92), (204, 96), (204, 100), (204, 104), (204, 108), (204, 132), (204, 136), (204, 140), (204, 144), (204, 148), (204, 152), (204, 156), (204, 160), (204, 164), (204, 168), (204, 172), (204, 176), (204, 180), (204, 184), (204, 188), (204, 192), (204, 196), (204, 200), (204, 204), (204, 208), (204, 212), (204, 216), (204, 220), (204, 224), (208, 48), (208, 52), (208, 56), (208, 60), (208, 64), (208, 68), (208, 72), (208, 76), (208, 80), (208, 84), (208, 88), (208, 92), (208, 96), (208, 100), (208, 104), (208, 108), (208, 132), (208, 136), (208, 140), (208, 144), (208, 148), (208, 152), (208, 156), (208, 160), (208, 164), (208, 168), (208, 172), (208, 176), (208, 180), (208, 184), (208, 188), (208, 192), (208, 196), (208, 200), (208, 204), (208, 208), (208, 212), (208, 216), (208, 220), (208, 224), (212, 48), (212, 52), (212, 56), (212, 60), (212, 64), (212, 68), (212, 72), (212, 76), (212, 80), (212, 84), (212, 88), (212, 92), (212, 96), (212, 100), (212, 104), (212, 108), (212, 112), (212, 116), (212, 120), (212, 124), (212, 128), (212, 132), (212, 136), (212, 140), (212, 144), (212, 148), (212, 152), (212, 156), (212, 160), (212, 164), (212, 168), (212, 172), (212, 176), (212, 180), (212, 184), (212, 188), (212, 192), (212, 196), (212, 200), (212, 204), (212, 208), (212, 212), (212, 216), (212, 220), (212, 224), (216, 48), (216, 52), (216, 56), (216, 60), (216, 64), (216, 68), (216, 72), (216, 76), (216, 80), (216, 84), (216, 88), (216, 92), (216, 96), (216, 100), (216, 104), (216, 108), (216, 112), (216, 116), (216, 120), (216, 124), (216, 128), (216, 132), (216, 136), (216, 140), (216, 144), (216, 148), (216, 152), (216, 156), (216, 160), (216, 164), (216, 168), (216, 172), (216, 176), (216, 180), (216, 184), (216, 188), (216, 192), (216, 196), (216, 200), (216, 204), (216, 208), (216, 212), (216, 216), (216, 220), (216, 224), (220, 48), (220, 52), (220, 56), (220, 60), (220, 64), (220, 68), (220, 72), (220, 76), (220, 80), (220, 84), (220, 88), (220, 92), (220, 96), (220, 100), (220, 104), (220, 108), (220, 112), (220, 116), (220, 120), (220, 124), (220, 128), (220, 132), (220, 136), (220, 140), (220, 144), (220, 148), (220, 152), (220, 156), (220, 160), (220, 164), (220, 168), (220, 172), (220, 176), (220, 180), (220, 184), (220, 188), (220, 192), (220, 196), (220, 200), (220, 204), (220, 208), (220, 212), (220, 216), (220, 220), (220, 224), (224, 48), (224, 52), (224, 56), (224, 60), (224, 64), (224, 68), (224, 72), (224, 76), (224, 80), (224, 84), (224, 88), (224, 92), (224, 96), (224, 100), (224, 104), (224, 108), (224, 112), (224, 116), (224, 120), (224, 124), (224, 128), (224, 132), (224, 136), (224, 140), (224, 144), (224, 148), (224, 152), (224, 156), (224, 160), (224, 164), (224, 168), (224, 172), (224, 176), (224, 180), (224, 184), (224, 188), (224, 192), (224, 196), (224, 200), (224, 204), (224, 208), (224, 212), (224, 216), (224, 220), (224, 224)]), 10: ([(124, 240), (124, 236), (124, 232), (124, 228), (124, 204), (124, 200), (124, 196), (124, 192), (124, 188), (124, 184), (124, 180), (124, 176), (124, 172), (124, 168), (124, 164), (124, 160), (124, 156), (124, 152), (124, 148), (124, 144), (124, 140), (124, 116), (124, 112), (124, 108), (124, 104), (124, 100), (124, 96), (124, 92), (124, 88), (124, 84), (124, 80), (124, 76), (124, 72), (124, 68), (124, 64), (124, 60), (124, 56), (124, 52), (124, 28), (124, 24), (124, 20), (124, 16), (120, 240), (120, 236), (120, 232), (120, 228), (120, 204), (120, 200), (120, 196), (120, 192), (120, 188), (120, 184), (120, 180), (120, 176), (120, 172), (120, 168), (120, 164), (120, 160), (120, 156), (120, 152), (120, 148), (120, 144), (120, 140), (120, 116), (120, 112), (120, 108), (120, 104), (120, 100), (120, 96), (120, 92), (120, 88), (120, 84), (120, 80), (120, 76), (120, 72), (120, 68), (120, 64), (120, 60), (120, 56), (120, 52), (120, 28), (120, 24), (120, 20), (120, 16), (116, 240), (116, 236), (116, 232), (116, 228), (116, 224), (116, 220), (116, 216), (116, 212), (116, 208), (116, 204), (116, 200), (116, 196), (116, 192), (116, 188), (116, 184), (116, 180), (116, 176), (116, 172), (116, 168), (116, 164), (116, 160), (116, 156), (116, 152), (116, 148), (116, 144), (116, 140), (116, 136), (116, 132), (116, 128), (116, 124), (116, 120), (116, 116), (116, 112), (116, 108), (116, 104), (116, 100), (116, 96), (116, 92), (116, 88), (116, 84), (116, 80), (116, 76), (116, 72), (116, 68), (116, 64), (116, 60), (116, 56), (116, 52), (116, 48), (116, 44), (116, 40), (116, 36), (116, 32), (116, 28), (116, 24), (116, 20), (116, 16), (112, 240), (112, 236), (112, 232), (112, 228), (112, 224), (112, 220), (112, 216), (112, 212), (112, 208), (112, 204), (112, 200), (112, 196), (112, 192), (112, 188), (112, 184), (112, 180), (112, 176), (112, 172), (112, 168), (112, 164), (112, 160), (112, 156), (112, 152), (112, 148), (112, 144), (112, 140), (112, 136), (112, 132), (112, 128), (112, 124), (112, 120), (112, 116), (112, 112), (112, 108), (112, 104), (112, 100), (112, 96), (112, 92), (112, 88), (112, 84), (112, 80), (112, 76), (112, 72), (112, 68), (112, 64), (112, 60), (112, 56), (112, 52), (112, 48), (112, 44), (112, 40), (112, 36), (112, 32), (112, 28), (112, 24), (112, 20), (112, 16), (108, 240), (108, 236), (108, 232), (108, 228), (108, 224), (108, 220), (108, 216), (108, 212), (108, 208), (108, 204), (108, 200), (108, 196), (108, 192), (108, 188), (108, 184), (108, 180), (108, 176), (108, 172), (108, 168), (108, 164), (108, 160), (108, 156), (108, 152), (108, 148), (108, 144), (108, 140), (108, 136), (108, 132), (108, 128), (108, 124), (108, 120), (108, 116), (108, 112), (108, 108), (108, 104), (108, 100), (108, 96), (108, 92), (108, 88), (108, 84), (108, 80), (108, 76), (108, 72), (108, 68), (108, 64), (108, 60), (108, 56), (108, 52), (108, 48), (108, 44), (108, 40), (108, 36), (108, 32), (108, 28), (108, 24), (108, 20), (108, 16), (104, 240), (104, 236), (104, 232), (104, 228), (104, 224), (104, 220), (104, 216), (104, 212), (104, 208), (104, 204), (104, 200), (104, 196), (104, 192), (104, 188), (104, 184), (104, 180), (104, 176), (104, 172), (104, 168), (104, 164), (104, 160), (104, 156), (104, 152), (104, 148), (104, 144), (104, 140), (104, 136), (104, 132), (104, 128), (104, 124), (104, 120), (104, 116), (104, 112), (104, 108), (104, 104), (104, 100), (104, 96), (104, 92), (104, 88), (104, 84), (104, 80), (104, 76), (104, 72), (104, 68), (104, 64), (104, 60), (104, 56), (104, 52), (104, 48), (104, 44), (104, 40), (104, 36), (104, 32), (104, 28), (104, 24), (104, 20), (104, 16), (100, 240), (100, 236), (100, 232), (100, 228), (100, 224), (100, 220), (100, 216), (100, 212), (100, 208), (100, 204), (100, 200), (100, 196), (100, 192), (100, 188), (100, 184), (100, 180), (100, 176), (100, 172), (100, 168), (100, 164), (100, 160), (100, 156), (100, 152), (100, 148), (100, 144), (100, 140), (100, 136), (100, 132), (100, 128), (100, 124), (100, 120), (100, 116), (100, 112), (100, 108), (100, 104), (100, 100), (100, 96), (100, 92), (100, 88), (100, 84), (100, 80), (100, 76), (100, 72), (100, 68), (100, 64), (100, 60), (100, 56), (100, 52), (100, 48), (100, 44), (100, 40), (100, 36), (100, 32), (100, 28), (100, 24), (100, 20), (100, 16), (96, 240), (96, 236), (96, 232), (96, 228), (96, 224), (96, 220), (96, 216), (96, 212), (96, 208), (96, 204), (96, 200), (96, 196), (96, 192), (96, 188), (96, 184), (96, 180), (96, 176), (96, 172), (96, 168), (96, 164), (96, 160), (96, 156), (96, 152), (96, 148), (96, 144), (96, 140), (96, 136), (96, 132), (96, 128), (96, 124), (96, 120), (96, 116), (96, 112), (96, 108), (96, 104), (96, 100), (96, 96), (96, 92), (96, 88), (96, 84), (96, 80), (96, 76), (96, 72), (96, 68), (96, 64), (96, 60), (96, 56), (96, 52), (96, 48), (96, 44), (96, 40), (96, 36), (96, 32), (96, 28), (96, 24), (96, 20), (96, 16), (92, 240), (92, 236), (92, 232), (92, 228), (92, 224), (92, 220), (92, 216), (92, 212), (92, 208), (92, 204), (92, 200), (92, 196), (92, 192), (92, 188), (92, 184), (92, 180), (92, 176), (92, 172), (92, 168), (92, 164), (92, 160), (92, 156), (92, 152), (92, 148), (92, 144), (92, 140), (92, 136), (92, 132), (92, 128), (92, 124), (92, 120), (92, 116), (92, 112), (92, 108), (92, 104), (92, 100), (92, 96), (92, 92), (92, 88), (92, 84), (92, 80), (92, 76), (92, 72), (92, 68), (92, 64), (92, 60), (92, 56), (92, 52), (92, 48), (92, 44), (92, 40), (92, 36), (92, 32), (92, 28), (92, 24), (92, 20), (92, 16), (88, 240), (88, 236), (88, 232), (88, 228), (88, 224), (88, 220), (88, 216), (88, 212), (88, 208), (88, 204), (88, 200), (88, 196), (88, 192), (88, 188), (88, 184), (88, 180), (88, 176), (88, 172), (88, 168), (88, 164), (88, 160), (88, 156), (88, 152), (88, 148), (88, 144), (88, 140), (88, 136), (88, 132), (88, 128), (88, 124), (88, 120), (88, 116), (88, 112), (88, 108), (88, 104), (88, 100), (88, 96), (88, 92), (88, 88), (88, 84), (88, 80), (88, 76), (88, 72), (88, 68), (88, 64), (88, 60), (88, 56), (88, 52), (88, 48), (88, 44), (88, 40), (88, 36), (88, 32), (88, 28), (88, 24), (88, 20), (88, 16), (84, 240), (84, 236), (84, 232), (84, 228), (84, 224), (84, 220), (84, 216), (84, 212), (84, 208), (84, 204), (84, 200), (84, 196), (84, 192), (84, 188), (84, 184), (84, 180), (84, 176), (84, 172), (84, 168), (84, 164), (84, 160), (84, 156), (84, 152), (84, 148), (84, 144), (84, 140), (84, 136), (84, 132), (84, 128), (84, 124), (84, 120), (84, 116), (84, 112), (84, 108), (84, 104), (84, 100), (84, 96), (84, 92), (84, 88), (84, 84), (84, 80), (84, 76), (84, 72), (84, 68), (84, 64), (84, 60), (84, 56), (84, 52), (84, 48), (84, 44), (84, 40), (84, 36), (84, 32), (84, 28), (84, 24), (84, 20), (84, 16), (80, 240), (80, 236), (80, 232), (80, 228), (80, 224), (80, 220), (80, 216), (80, 212), (80, 208), (80, 204), (80, 200), (80, 196), (80, 192), (80, 188), (80, 184), (80, 180), (80, 176), (80, 172), (80, 168), (80, 164), (80, 160), (80, 156), (80, 152), (80, 148), (80, 144), (80, 140), (80, 136), (80, 132), (80, 128), (80, 124), (80, 120), (80, 116), (80, 112), (80, 108), (80, 104), (80, 100), (80, 96), (80, 92), (80, 88), (80, 84), (80, 80), (80, 76), (80, 72), (80, 68), (80, 64), (80, 60), (80, 56), (80, 52), (80, 48), (80, 44), (80, 40), (80, 36), (80, 32), (80, 28), (80, 24), (80, 20), (80, 16), (76, 240), (76, 236), (76, 232), (76, 228), (76, 224), (76, 220), (76, 216), (76, 212), (76, 208), (76, 204), (76, 200), (76, 196), (76, 192), (76, 188), (76, 184), (76, 180), (76, 176), (76, 172), (76, 168), (76, 164), (76, 160), (76, 156), (76, 152), (76, 148), (76, 144), (76, 140), (76, 136), (76, 132), (76, 128), (76, 124), (76, 120), (76, 116), (76, 112), (76, 108), (76, 104), (76, 100), (76, 96), (76, 92), (76, 88), (76, 84), (76, 80), (76, 76), (76, 72), (76, 68), (76, 64), (76, 60), (76, 56), (76, 52), (76, 48), (76, 44), (76, 40), (76, 36), (76, 32), (76, 28), (76, 24), (76, 20), (76, 16), (72, 240), (72, 236), (72, 232), (72, 228), (72, 224), (72, 220), (72, 216), (72, 212), (72, 208), (72, 204), (72, 200), (72, 196), (72, 192), (72, 188), (72, 184), (72, 180), (72, 176), (72, 172), (72, 168), (72, 164), (72, 160), (72, 156), (72, 152), (72, 148), (72, 144), (72, 140), (72, 136), (72, 132), (72, 128), (72, 124), (72, 120), (72, 116), (72, 112), (72, 108), (72, 104), (72, 100), (72, 96), (72, 92), (72, 88), (72, 84), (72, 80), (72, 76), (72, 72), (72, 68), (72, 64), (72, 60), (72, 56), (72, 52), (72, 48), (72, 44), (72, 40), (72, 36), (72, 32), (72, 28), (72, 24), (72, 20), (72, 16), (68, 240), (68, 236), (68, 232), (68, 228), (68, 224), (68, 220), (68, 216), (68, 212), (68, 208), (68, 204), (68, 200), (68, 196), (68, 192), (68, 188), (68, 184), (68, 180), (68, 176), (68, 172), (68, 168), (68, 164), (68, 160), (68, 156), (68, 152), (68, 148), (68, 144), (68, 140), (68, 136), (68, 132), (68, 128), (68, 124), (68, 120), (68, 116), (68, 112), (68, 108), (68, 104), (68, 100), (68, 96), (68, 92), (68, 88), (68, 84), (68, 80), (68, 76), (68, 72), (68, 68), (68, 64), (68, 60), (68, 56), (68, 52), (68, 48), (68, 44), (68, 40), (68, 36), (68, 32), (68, 28), (68, 24), (68, 20), (68, 16), (64, 240), (64, 236), (64, 232), (64, 228), (64, 224), (64, 220), (64, 216), (64, 212), (64, 208), (64, 204), (64, 200), (64, 196), (64, 192), (64, 188), (64, 184), (64, 180), (64, 176), (64, 172), (64, 168), (64, 164), (64, 160), (64, 156), (64, 152), (64, 148), (64, 144), (64, 140), (64, 136), (64, 132), (64, 128), (64, 124), (64, 120), (64, 116), (64, 112), (64, 108), (64, 104), (64, 100), (64, 96), (64, 92), (64, 88), (64, 84), (64, 80), (64, 76), (64, 72), (64, 68), (64, 64), (64, 60), (64, 56), (64, 52), (64, 48), (64, 44), (64, 40), (64, 36), (64, 32), (64, 28), (64, 24), (64, 20), (64, 16), (60, 240), (60, 236), (60, 232), (60, 228), (60, 224), (60, 220), (60, 216), (60, 212), (60, 208), (60, 204), (60, 200), (60, 196), (60, 192), (60, 188), (60, 184), (60, 180), (60, 176), (60, 172), (60, 168), (60, 164), (60, 160), (60, 156), (60, 152), (60, 148), (60, 144), (60, 140), (60, 136), (60, 132), (60, 128), (60, 124), (60, 120), (60, 116), (60, 112), (60, 108), (60, 104), (60, 100), (60, 96), (60, 92), (60, 88), (60, 84), (60, 80), (60, 76), (60, 72), (60, 68), (60, 64), (60, 60), (60, 56), (60, 52), (60, 48), (60, 44), (60, 40), (60, 36), (60, 32), (60, 28), (60, 24), (60, 20), (60, 16), (56, 240), (56, 236), (56, 232), (56, 228), (56, 224), (56, 220), (56, 216), (56, 212), (56, 208), (56, 204), (56, 200), (56, 196), (56, 192), (56, 188), (56, 184), (56, 180), (56, 176), (56, 172), (56, 168), (56, 164), (56, 160), (56, 156), (56, 152), (56, 148), (56, 144), (56, 140), (56, 136), (56, 132), (56, 128), (56, 124), (56, 120), (56, 116), (56, 112), (56, 108), (56, 104), (56, 100), (56, 96), (56, 92), (56, 88), (56, 84), (56, 80), (56, 76), (56, 72), (56, 68), (56, 64), (56, 60), (56, 56), (56, 52), (56, 48), (56, 44), (56, 40), (56, 36), (56, 32), (56, 28), (56, 24), (56, 20), (56, 16), (52, 240), (52, 236), (52, 232), (52, 228), (52, 224), (52, 220), (52, 216), (52, 212), (52, 208), (52, 204), (52, 200), (52, 196), (52, 192), (52, 188), (52, 184), (52, 180), (52, 176), (52, 172), (52, 168), (52, 164), (52, 160), (52, 156), (52, 152), (52, 148), (52, 144), (52, 140), (52, 136), (52, 132), (52, 128), (52, 124), (52, 120), (52, 116), (52, 112), (52, 108), (52, 104), (52, 100), (52, 96), (52, 92), (52, 88), (52, 84), (52, 80), (52, 76), (52, 72), (52, 68), (52, 64), (52, 60), (52, 56), (52, 52), (52, 48), (52, 44), (52, 40), (52, 36), (52, 32), (52, 28), (52, 24), (52, 20), (52, 16), (48, 240), (48, 236), (48, 232), (48, 228), (48, 224), (48, 220), (48, 216), (48, 212), (48, 208), (48, 204), (48, 200), (48, 196), (48, 192), (48, 188), (48, 184), (48, 180), (48, 176), (48, 172), (48, 168), (48, 164), (48, 160), (48, 156), (48, 152), (48, 148), (48, 144), (48, 140), (48, 116), (48, 112), (48, 108), (48, 104), (48, 100), (48, 96), (48, 92), (48, 88), (48, 84), (48, 80), (48, 76), (48, 72), (48, 68), (48, 64), (48, 60), (48, 56), (48, 52), (48, 48), (48, 44), (48, 40), (48, 36), (48, 32), (48, 28), (48, 24), (48, 20), (48, 16), (44, 240), (44, 236), (44, 232), (44, 228), (44, 224), (44, 220), (44, 216), (44, 212), (44, 208), (44, 204), (44, 200), (44, 196), (44, 192), (44, 188), (44, 184), (44, 180), (44, 176), (44, 172), (44, 168), (44, 164), (44, 160), (44, 156), (44, 152), (44, 148), (44, 144), (44, 140), (44, 116), (44, 112), (44, 108), (44, 104), (44, 100), (44, 96), (44, 92), (44, 88), (44, 84), (44, 80), (44, 76), (44, 72), (44, 68), (44, 64), (44, 60), (44, 56), (44, 52), (44, 48), (40, 240), (40, 236), (40, 232), (40, 228), (40, 224), (40, 220), (40, 216), (40, 212), (40, 208), (40, 204), (40, 200), (40, 196), (40, 192), (40, 188), (40, 184), (40, 180), (40, 176), (40, 172), (40, 168), (40, 164), (40, 160), (40, 156), (40, 152), (40, 148), (40, 144), (40, 140), (40, 116), (40, 112), (40, 108), (40, 104), (40, 100), (40, 96), (40, 92), (40, 88), (40, 84), (40, 80), (40, 76), (40, 72), (40, 68), (40, 64), (40, 60), (40, 56), (40, 52), (40, 48), (36, 240), (36, 236), (36, 232), (36, 228), (36, 224), (36, 220), (36, 216), (36, 212), (36, 208), (36, 204), (36, 200), (36, 196), (36, 192), (36, 188), (36, 184), (36, 180), (36, 176), (36, 172), (36, 168), (36, 164), (36, 160), (36, 156), (36, 152), (36, 148), (36, 144), (36, 140), (36, 116), (36, 112), (36, 108), (36, 104), (36, 100), (36, 96), (36, 92), (36, 88), (36, 84), (36, 80), (36, 76), (36, 72), (36, 68), (36, 64), (36, 60), (36, 56), (36, 52), (36, 48), (32, 240), (32, 236), (32, 232), (32, 228), (32, 224), (32, 220), (32, 216), (32, 212), (32, 208), (32, 204), (32, 200), (32, 196), (32, 192), (32, 188), (32, 184), (32, 180), (32, 176), (32, 172), (32, 168), (32, 164), (32, 160), (32, 156), (32, 152), (32, 148), (32, 144), (32, 140), (32, 116), (32, 112), (32, 108), (32, 104), (32, 100), (32, 96), (32, 92), (32, 88), (32, 84), (32, 80), (32, 76), (32, 72), (32, 68), (32, 64), (32, 60), (32, 56), (32, 52), (32, 48), (28, 240), (28, 236), (28, 232), (28, 228), (28, 224), (28, 220), (28, 216), (28, 212), (28, 208), (28, 204), (28, 200), (28, 196), (28, 192), (28, 188), (28, 184), (28, 180), (28, 176), (28, 172), (28, 168), (28, 164), (28, 160), (28, 156), (28, 152), (28, 148), (28, 144), (28, 140), (28, 136), (28, 132), (28, 128), (28, 124), (28, 120), (28, 116), (28, 112), (28, 108), (28, 104), (28, 100), (28, 96), (28, 92), (28, 88), (28, 84), (28, 80), (28, 76), (28, 72), (28, 68), (28, 64), (28, 60), (28, 56), (28, 52), (28, 48), (24, 240), (24, 236), (24, 232), (24, 228), (24, 224), (24, 220), (24, 216), (24, 212), (24, 208), (24, 204), (24, 200), (24, 196), (24, 192), (24, 188), (24, 184), (24, 180), (24, 176), (24, 172), (24, 168), (24, 164), (24, 160), (24, 156), (24, 152), (24, 148), (24, 144), (24, 140), (24, 136), (24, 132), (24, 128), (24, 124), (24, 120), (24, 116), (24, 112), (24, 108), (24, 104), (24, 100), (24, 96), (24, 92), (24, 88), (24, 84), (24, 80), (24, 76), (24, 72), (24, 68), (24, 64), (24, 60), (24, 56), (24, 52), (24, 48), (20, 240), (20, 236), (20, 232), (20, 228), (20, 224), (20, 220), (20, 216), (20, 212), (20, 208), (20, 204), (20, 200), (20, 196), (20, 192), (20, 188), (20, 184), (20, 180), (20, 176), (20, 172), (20, 168), (20, 164), (20, 160), (20, 156), (20, 152), (20, 148), (20, 144), (20, 140), (20, 136), (20, 132), (20, 128), (20, 124), (20, 120), (20, 116), (20, 112), (20, 108), (20, 104), (20, 100), (20, 96), (20, 92), (20, 88), (20, 84), (20, 80), (20, 76), (20, 72), (20, 68), (20, 64), (20, 60), (20, 56), (20, 52), (20, 48), (16, 240), (16, 236), (16, 232), (16, 228), (16, 224), (16, 220), (16, 216), (16, 212), (16, 208), (16, 204), (16, 200), (16, 196), (16, 192), (16, 188), (16, 184), (16, 180), (16, 176), (16, 172), (16, 168), (16, 164), (16, 160), (16, 156), (16, 152), (16, 148), (16, 144), (16, 140), (16, 136), (16, 132), (16, 128), (16, 124), (16, 120), (16, 116), (16, 112), (16, 108), (16, 104), (16, 100), (16, 96), (16, 92), (16, 88), (16, 84), (16, 80), (16, 76), (16, 72), (16, 68), (16, 64), (16, 60), (16, 56), (16, 52), (16, 48)], [(132, 16), (132, 20), (132, 24), (132, 28), (132, 52), (132, 56), (132, 60), (132, 64), (132, 68), (132, 72), (132, 76), (132, 80), (132, 84), (132, 88), (132, 92), (132, 96), (132, 100), (132, 104), (132, 108), (132, 112), (132, 116), (132, 140), (132, 144), (132, 148), (132, 152), (132, 156), (132, 160), (132, 164), (132, 168), (132, 172), (132, 176), (132, 180), (132, 184), (132, 188), (132, 192), (132, 196), (132, 200), (132, 204), (132, 228), (132, 232), (132, 236), (132, 240), (136, 16), (136, 20), (136, 24), (136, 28), (136, 52), (136, 56), (136, 60), (136, 64), (136, 68), (136, 72), (136, 76), (136, 80), (136, 84), (136, 88), (136, 92), (136, 96), (136, 100), (136, 104), (136, 108), (136, 112), (136, 116), (136, 140), (136, 144), (136, 148), (136, 152), (136, 156), (136, 160), (136, 164), (136, 168), (136, 172), (136, 176), (136, 180), (136, 184), (136, 188), (136, 192), (136, 196), (136, 200), (136, 204), (136, 228), (136, 232), (136, 236), (136, 240), (140, 16), (140, 20), (140, 24), (140, 28), (140, 32), (140, 36), (140, 40), (140, 44), (140, 48), (140, 52), (140, 56), (140, 60), (140, 64), (140, 68), (140, 72), (140, 76), (140, 80), (140, 84), (140, 88), (140, 92), (140, 96), (140, 100), (140, 104), (140, 108), (140, 112), (140, 116), (140, 120), (140, 124), (140, 128), (140, 132), (140, 136), (140, 140), (140, 144), (140, 148), (140, 152), (140, 156), (140, 160), (140, 164), (140, 168), (140, 172), (140, 176), (140, 180), (140, 184), (140, 188), (140, 192), (140, 196), (140, 200), (140, 204), (140, 208), (140, 212), (140, 216), (140, 220), (140, 224), (140, 228), (140, 232), (140, 236), (140, 240), (144, 16), (144, 20), (144, 24), (144, 28), (144, 32), (144, 36), (144, 40), (144, 44), (144, 48), (144, 52), (144, 56), (144, 60), (144, 64), (144, 68), (144, 72), (144, 76), (144, 80), (144, 84), (144, 88), (144, 92), (144, 96), (144, 100), (144, 104), (144, 108), (144, 112), (144, 116), (144, 120), (144, 124), (144, 128), (144, 132), (144, 136), (144, 140), (144, 144), (144, 148), (144, 152), (144, 156), (144, 160), (144, 164), (144, 168), (144, 172), (144, 176), (144, 180), (144, 184), (144, 188), (144, 192), (144, 196), (144, 200), (144, 204), (144, 208), (144, 212), (144, 216), (144, 220), (144, 224), (144, 228), (144, 232), (144, 236), (144, 240), (148, 16), (148, 20), (148, 24), (148, 28), (148, 32), (148, 36), (148, 40), (148, 44), (148, 48), (148, 52), (148, 56), (148, 60), (148, 64), (148, 68), (148, 72), (148, 76), (148, 80), (148, 84), (148, 88), (148, 92), (148, 96), (148, 100), (148, 104), (148, 108), (148, 112), (148, 116), (148, 120), (148, 124), (148, 128), (148, 132), (148, 136), (148, 140), (148, 144), (148, 148), (148, 152), (148, 156), (148, 160), (148, 164), (148, 168), (148, 172), (148, 176), (148, 180), (148, 184), (148, 188), (148, 192), (148, 196), (148, 200), (148, 204), (148, 208), (148, 212), (148, 216), (148, 220), (148, 224), (148, 228), (148, 232), (148, 236), (148, 240), (152, 16), (152, 20), (152, 24), (152, 28), (152, 32), (152, 36), (152, 40), (152, 44), (152, 48), (152, 52), (152, 56), (152, 60), (152, 64), (152, 68), (152, 72), (152, 76), (152, 80), (152, 84), (152, 88), (152, 92), (152, 96), (152, 100), (152, 104), (152, 108), (152, 112), (152, 116), (152, 120), (152, 124), (152, 128), (152, 132), (152, 136), (152, 140), (152, 144), (152, 148), (152, 152), (152, 156), (152, 160), (152, 164), (152, 168), (152, 172), (152, 176), (152, 180), (152, 184), (152, 188), (152, 192), (152, 196), (152, 200), (152, 204), (152, 208), (152, 212), (152, 216), (152, 220), (152, 224), (152, 228), (152, 232), (152, 236), (152, 240), (156, 16), (156, 20), (156, 24), (156, 28), (156, 32), (156, 36), (156, 40), (156, 44), (156, 48), (156, 52), (156, 56), (156, 60), (156, 64), (156, 68), (156, 72), (156, 76), (156, 80), (156, 84), (156, 88), (156, 92), (156, 96), (156, 100), (156, 104), (156, 108), (156, 112), (156, 116), (156, 120), (156, 124), (156, 128), (156, 132), (156, 136), (156, 140), (156, 144), (156, 148), (156, 152), (156, 156), (156, 160), (156, 164), (156, 168), (156, 172), (156, 176), (156, 180), (156, 184), (156, 188), (156, 192), (156, 196), (156, 200), (156, 204), (156, 208), (156, 212), (156, 216), (156, 220), (156, 224), (156, 228), (156, 232), (156, 236), (156, 240), (160, 16), (160, 20), (160, 24), (160, 28), (160, 32), (160, 36), (160, 40), (160, 44), (160, 48), (160, 52), (160, 56), (160, 60), (160, 64), (160, 68), (160, 72), (160, 76), (160, 80), (160, 84), (160, 88), (160, 92), (160, 96), (160, 100), (160, 104), (160, 108), (160, 112), (160, 116), (160, 120), (160, 124), (160, 128), (160, 132), (160, 136), (160, 140), (160, 144), (160, 148), (160, 152), (160, 156), (160, 160), (160, 164), (160, 168), (160, 172), (160, 176), (160, 180), (160, 184), (160, 188), (160, 192), (160, 196), (160, 200), (160, 204), (160, 208), (160, 212), (160, 216), (160, 220), (160, 224), (160, 228), (160, 232), (160, 236), (160, 240), (164, 16), (164, 20), (164, 24), (164, 28), (164, 32), (164, 36), (164, 40), (164, 44), (164, 48), (164, 52), (164, 56), (164, 60), (164, 64), (164, 68), (164, 72), (164, 76), (164, 80), (164, 84), (164, 88), (164, 92), (164, 96), (164, 100), (164, 104), (164, 108), (164, 112), (164, 116), (164, 120), (164, 124), (164, 128), (164, 132), (164, 136), (164, 140), (164, 144), (164, 148), (164, 152), (164, 156), (164, 160), (164, 164), (164, 168), (164, 172), (164, 176), (164, 180), (164, 184), (164, 188), (164, 192), (164, 196), (164, 200), (164, 204), (164, 208), (164, 212), (164, 216), (164, 220), (164, 224), (164, 228), (164, 232), (164, 236), (164, 240), (168, 16), (168, 20), (168, 24), (168, 28), (168, 32), (168, 36), (168, 40), (168, 44), (168, 48), (168, 52), (168, 56), (168, 60), (168, 64), (168, 68), (168, 72), (168, 76), (168, 80), (168, 84), (168, 88), (168, 92), (168, 96), (168, 100), (168, 104), (168, 108), (168, 112), (168, 116), (168, 120), (168, 124), (168, 128), (168, 132), (168, 136), (168, 140), (168, 144), (168, 148), (168, 152), (168, 156), (168, 160), (168, 164), (168, 168), (168, 172), (168, 176), (168, 180), (168, 184), (168, 188), (168, 192), (168, 196), (168, 200), (168, 204), (168, 208), (168, 212), (168, 216), (168, 220), (168, 224), (168, 228), (168, 232), (168, 236), (168, 240), (172, 16), (172, 20), (172, 24), (172, 28), (172, 32), (172, 36), (172, 40), (172, 44), (172, 48), (172, 52), (172, 56), (172, 60), (172, 64), (172, 68), (172, 72), (172, 76), (172, 80), (172, 84), (172, 88), (172, 92), (172, 96), (172, 100), (172, 104), (172, 108), (172, 112), (172, 116), (172, 120), (172, 124), (172, 128), (172, 132), (172, 136), (172, 140), (172, 144), (172, 148), (172, 152), (172, 156), (172, 160), (172, 164), (172, 168), (172, 172), (172, 176), (172, 180), (172, 184), (172, 188), (172, 192), (172, 196), (172, 200), (172, 204), (172, 208), (172, 212), (172, 216), (172, 220), (172, 224), (172, 228), (172, 232), (172, 236), (172, 240), (176, 16), (176, 20), (176, 24), (176, 28), (176, 32), (176, 36), (176, 40), (176, 44), (176, 48), (176, 52), (176, 56), (176, 60), (176, 64), (176, 68), (176, 72), (176, 76), (176, 80), (176, 84), (176, 88), (176, 92), (176, 96), (176, 100), (176, 104), (176, 108), (176, 112), (176, 116), (176, 120), (176, 124), (176, 128), (176, 132), (176, 136), (176, 140), (176, 144), (176, 148), (176, 152), (176, 156), (176, 160), (176, 164), (176, 168), (176, 172), (176, 176), (176, 180), (176, 184), (176, 188), (176, 192), (176, 196), (176, 200), (176, 204), (176, 208), (176, 212), (176, 216), (176, 220), (176, 224), (176, 228), (176, 232), (176, 236), (176, 240), (180, 16), (180, 20), (180, 24), (180, 28), (180, 32), (180, 36), (180, 40), (180, 44), (180, 48), (180, 52), (180, 56), (180, 60), (180, 64), (180, 68), (180, 72), (180, 76), (180, 80), (180, 84), (180, 88), (180, 92), (180, 96), (180, 100), (180, 104), (180, 108), (180, 112), (180, 116), (180, 120), (180, 124), (180, 128), (180, 132), (180, 136), (180, 140), (180, 144), (180, 148), (180, 152), (180, 156), (180, 160), (180, 164), (180, 168), (180, 172), (180, 176), (180, 180), (180, 184), (180, 188), (180, 192), (180, 196), (180, 200), (180, 204), (180, 208), (180, 212), (180, 216), (180, 220), (180, 224), (180, 228), (180, 232), (180, 236), (180, 240), (184, 16), (184, 20), (184, 24), (184, 28), (184, 32), (184, 36), (184, 40), (184, 44), (184, 48), (184, 52), (184, 56), (184, 60), (184, 64), (184, 68), (184, 72), (184, 76), (184, 80), (184, 84), (184, 88), (184, 92), (184, 96), (184, 100), (184, 104), (184, 108), (184, 112), (184, 116), (184, 120), (184, 124), (184, 128), (184, 132), (184, 136), (184, 140), (184, 144), (184, 148), (184, 152), (184, 156), (184, 160), (184, 164), (184, 168), (184, 172), (184, 176), (184, 180), (184, 184), (184, 188), (184, 192), (184, 196), (184, 200), (184, 204), (184, 208), (184, 212), (184, 216), (184, 220), (184, 224), (184, 228), (184, 232), (184, 236), (184, 240), (188, 16), (188, 20), (188, 24), (188, 28), (188, 32), (188, 36), (188, 40), (188, 44), (188, 48), (188, 52), (188, 56), (188, 60), (188, 64), (188, 68), (188, 72), (188, 76), (188, 80), (188, 84), (188, 88), (188, 92), (188, 96), (188, 100), (188, 104), (188, 108), (188, 112), (188, 116), (188, 120), (188, 124), (188, 128), (188, 132), (188, 136), (188, 140), (188, 144), (188, 148), (188, 152), (188, 156), (188, 160), (188, 164), (188, 168), (188, 172), (188, 176), (188, 180), (188, 184), (188, 188), (188, 192), (188, 196), (188, 200), (188, 204), (188, 208), (188, 212), (188, 216), (188, 220), (188, 224), (188, 228), (188, 232), (188, 236), (188, 240), (192, 16), (192, 20), (192, 24), (192, 28), (192, 32), (192, 36), (192, 40), (192, 44), (192, 48), (192, 52), (192, 56), (192, 60), (192, 64), (192, 68), (192, 72), (192, 76), (192, 80), (192, 84), (192, 88), (192, 92), (192, 96), (192, 100), (192, 104), (192, 108), (192, 112), (192, 116), (192, 120), (192, 124), (192, 128), (192, 132), (192, 136), (192, 140), (192, 144), (192, 148), (192, 152), (192, 156), (192, 160), (192, 164), (192, 168), (192, 172), (192, 176), (192, 180), (192, 184), (192, 188), (192, 192), (192, 196), (192, 200), (192, 204), (192, 208), (192, 212), (192, 216), (192, 220), (192, 224), (192, 228), (192, 232), (192, 236), (192, 240), (196, 16), (196, 20), (196, 24), (196, 28), (196, 32), (196, 36), (196, 40), (196, 44), (196, 48), (196, 52), (196, 56), (196, 60), (196, 64), (196, 68), (196, 72), (196, 76), (196, 80), (196, 84), (196, 88), (196, 92), (196, 96), (196, 100), (196, 104), (196, 108), (196, 112), (196, 116), (196, 120), (196, 124), (196, 128), (196, 132), (196, 136), (196, 140), (196, 144), (196, 148), (196, 152), (196, 156), (196, 160), (196, 164), (196, 168), (196, 172), (196, 176), (196, 180), (196, 184), (196, 188), (196, 192), (196, 196), (196, 200), (196, 204), (196, 208), (196, 212), (196, 216), (196, 220), (196, 224), (196, 228), (196, 232), (196, 236), (196, 240), (200, 16), (200, 20), (200, 24), (200, 28), (200, 32), (200, 36), (200, 40), (200, 44), (200, 48), (200, 52), (200, 56), (200, 60), (200, 64), (200, 68), (200, 72), (200, 76), (200, 80), (200, 84), (200, 88), (200, 92), (200, 96), (200, 100), (200, 104), (200, 108), (200, 112), (200, 116), (200, 120), (200, 124), (200, 128), (200, 132), (200, 136), (200, 140), (200, 144), (200, 148), (200, 152), (200, 156), (200, 160), (200, 164), (200, 168), (200, 172), (200, 176), (200, 180), (200, 184), (200, 188), (200, 192), (200, 196), (200, 200), (200, 204), (200, 208), (200, 212), (200, 216), (200, 220), (200, 224), (200, 228), (200, 232), (200, 236), (200, 240), (204, 16), (204, 20), (204, 24), (204, 28), (204, 32), (204, 36), (204, 40), (204, 44), (204, 48), (204, 52), (204, 56), (204, 60), (204, 64), (204, 68), (204, 72), (204, 76), (204, 80), (204, 84), (204, 88), (204, 92), (204, 96), (204, 100), (204, 104), (204, 108), (204, 112), (204, 116), (204, 120), (204, 124), (204, 128), (204, 132), (204, 136), (204, 140), (204, 144), (204, 148), (204, 152), (204, 156), (204, 160), (204, 164), (204, 168), (204, 172), (204, 176), (204, 180), (204, 184), (204, 188), (204, 192), (204, 196), (204, 200), (204, 204), (204, 208), (204, 212), (204, 216), (204, 220), (204, 224), (204, 228), (204, 232), (204, 236), (204, 240), (208, 16), (208, 20), (208, 24), (208, 28), (208, 32), (208, 36), (208, 40), (208, 44), (208, 48), (208, 52), (208, 56), (208, 60), (208, 64), (208, 68), (208, 72), (208, 76), (208, 80), (208, 84), (208, 88), (208, 92), (208, 96), (208, 100), (208, 104), (208, 108), (208, 112), (208, 116), (208, 140), (208, 144), (208, 148), (208, 152), (208, 156), (208, 160), (208, 164), (208, 168), (208, 172), (208, 176), (208, 180), (208, 184), (208, 188), (208, 192), (208, 196), (208, 200), (208, 204), (208, 208), (208, 212), (208, 216), (208, 220), (208, 224), (208, 228), (208, 232), (208, 236), (208, 240), (212, 48), (212, 52), (212, 56), (212, 60), (212, 64), (212, 68), (212, 72), (212, 76), (212, 80), (212, 84), (212, 88), (212, 92), (212, 96), (212, 100), (212, 104), (212, 108), (212, 112), (212, 116), (212, 140), (212, 144), (212, 148), (212, 152), (212, 156), (212, 160), (212, 164), (212, 168), (212, 172), (212, 176), (212, 180), (212, 184), (212, 188), (212, 192), (212, 196), (212, 200), (212, 204), (212, 208), (212, 212), (212, 216), (212, 220), (212, 224), (212, 228), (212, 232), (212, 236), (212, 240), (216, 48), (216, 52), (216, 56), (216, 60), (216, 64), (216, 68), (216, 72), (216, 76), (216, 80), (216, 84), (216, 88), (216, 92), (216, 96), (216, 100), (216, 104), (216, 108), (216, 112), (216, 116), (216, 140), (216, 144), (216, 148), (216, 152), (216, 156), (216, 160), (216, 164), (216, 168), (216, 172), (216, 176), (216, 180), (216, 184), (216, 188), (216, 192), (216, 196), (216, 200), (216, 204), (216, 208), (216, 212), (216, 216), (216, 220), (216, 224), (216, 228), (216, 232), (216, 236), (216, 240), (220, 48), (220, 52), (220, 56), (220, 60), (220, 64), (220, 68), (220, 72), (220, 76), (220, 80), (220, 84), (220, 88), (220, 92), (220, 96), (220, 100), (220, 104), (220, 108), (220, 112), (220, 116), (220, 140), (220, 144), (220, 148), (220, 152), (220, 156), (220, 160), (220, 164), (220, 168), (220, 172), (220, 176), (220, 180), (220, 184), (220, 188), (220, 192), (220, 196), (220, 200), (220, 204), (220, 208), (220, 212), (220, 216), (220, 220), (220, 224), (220, 228), (220, 232), (220, 236), (220, 240), (224, 48), (224, 52), (224, 56), (224, 60), (224, 64), (224, 68), (224, 72), (224, 76), (224, 80), (224, 84), (224, 88), (224, 92), (224, 96), (224, 100), (224, 104), (224, 108), (224, 112), (224, 116), (224, 140), (224, 144), (224, 148), (224, 152), (224, 156), (224, 160), (224, 164), (224, 168), (224, 172), (224, 176), (224, 180), (224, 184), (224, 188), (224, 192), (224, 196), (224, 200), (224, 204), (224, 208), (224, 212), (224, 216), (224, 220), (224, 224), (224, 228), (224, 232), (224, 236), (224, 240), (228, 48), (228, 52), (228, 56), (228, 60), (228, 64), (228, 68), (228, 72), (228, 76), (228, 80), (228, 84), (228, 88), (228, 92), (228, 96), (228, 100), (228, 104), (228, 108), (228, 112), (228, 116), (228, 120), (228, 124), (228, 128), (228, 132), (228, 136), (228, 140), (228, 144), (228, 148), (228, 152), (228, 156), (228, 160), (228, 164), (228, 168), (228, 172), (228, 176), (228, 180), (228, 184), (228, 188), (228, 192), (228, 196), (228, 200), (228, 204), (228, 208), (228, 212), (228, 216), (228, 220), (228, 224), (228, 228), (228, 232), (228, 236), (228, 240), (232, 48), (232, 52), (232, 56), (232, 60), (232, 64), (232, 68), (232, 72), (232, 76), (232, 80), (232, 84), (232, 88), (232, 92), (232, 96), (232, 100), (232, 104), (232, 108), (232, 112), (232, 116), (232, 120), (232, 124), (232, 128), (232, 132), (232, 136), (232, 140), (232, 144), (232, 148), (232, 152), (232, 156), (232, 160), (232, 164), (232, 168), (232, 172), (232, 176), (232, 180), (232, 184), (232, 188), (232, 192), (232, 196), (232, 200), (232, 204), (232, 208), (232, 212), (232, 216), (232, 220), (232, 224), (232, 228), (232, 232), (232, 236), (232, 240), (236, 48), (236, 52), (236, 56), (236, 60), (236, 64), (236, 68), (236, 72), (236, 76), (236, 80), (236, 84), (236, 88), (236, 92), (236, 96), (236, 100), (236, 104), (236, 108), (236, 112), (236, 116), (236, 120), (236, 124), (236, 128), (236, 132), (236, 136), (236, 140), (236, 144), (236, 148), (236, 152), (236, 156), (236, 160), (236, 164), (236, 168), (236, 172), (236, 176), (236, 180), (236, 184), (236, 188), (236, 192), (236, 196), (236, 200), (236, 204), (236, 208), (236, 212), (236, 216), (236, 220), (236, 224), (236, 228), (236, 232), (236, 236), (236, 240), (240, 48), (240, 52), (240, 56), (240, 60), (240, 64), (240, 68), (240, 72), (240, 76), (240, 80), (240, 84), (240, 88), (240, 92), (240, 96), (240, 100), (240, 104), (240, 108), (240, 112), (240, 116), (240, 120), (240, 124), (240, 128), (240, 132), (240, 136), (240, 140), (240, 144), (240, 148), (240, 152), (240, 156), (240, 160), (240, 164), (240, 168), (240, 172), (240, 176), (240, 180), (240, 184), (240, 188), (240, 192), (240, 196), (240, 200), (240, 204), (240, 208), (240, 212), (240, 216), (240, 220), (240, 224), (240, 228), (240, 232), (240, 236), (240, 240)])}


