"""
To generate a test bam file for the capseq protocol, run as below:

$ python generate_test_bam_capseq.py > sam_capseq_test.sam
$ samtools view -bS sam_capseq_test.sam > capseq_test.bam
$ samtools sort capseq_test.bam -o capseq_test_sorted.bam
$ samtools index capseq_test_sorted.bam

"""

sequence = "ACGT" * 25  # => 100 nt reads

header = """@HD	VN:1.4	SO:coordinate
@SQ	SN:1	LN:248956422"""

first_forward_proper_primary = "VH00211:1:AAAFH3LHV:1:1213:74792:28053_TTGCCACG	99	1	3102683	255	80M	=	3329443	226812	AGCCGGGCAGTGGTGGCACATGTCTTTAATCCCAGCACTTGGGAGGCAGAGGCAGGCAGATTTCTGAGTTCGAGGCCAGC	CCCCCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCC-CCCCCCCCCCCCC-CCCCCCCCC;CCCCCCCCCCCCCCCCCCCC	NH:i:1	HI:i:1	AS:i:122	nM:i:3	NM:i:3	MD:Z:17G2C1C57	jM:B:c,-1	jI:B:i,-1	MC:Z:35S52M14S"
first_reverse_proper_primary = "VH00211:1:AAAFH3LHV:1:1204:57863:28621_TTCAGACG	83	1	3152962	0	81M	=	3152913	-130	ATTCAGAGACAATATCCTTTTATTACTTAGGGTTTTAGTTTACTACAAAAGTTTCTACAAAAAATAAAGAAAGCTTTTATA	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCCCCC	NH:i:9	HI:i:4	AS:i:180	nM:i:0	NM:i:0	MD:Z:81	jM:B:c,-1	jI:B:i,-1	MC:Z:101M"

first_forward_unmapped = "VH00211:1:AAAFH3LHV:1:2108:20541:2855_ATCCCCAC	73	1	4846397	255	82M	*	0	0	GAATATGTTGCAAAAATTATGGTTATTTCTGAACGGTTGCTTTTCTTGCTGTTTTCCAACCAACCAAGAAGCACCTTTATAA	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-CCCCCCCCCC;CCC-C;C;CCCCC;CCC;C	NH:i:1	HI:i:1	AS:i:80	nM:i:0	NM:i:0	MD:Z:82	jM:B:c,-1	jI:B:i,-1"
first_reverse_unmapped = "VH00211:1:AAAFH3LHV:1:2613:39306:41608_CTGTGGGG	89	1	4580793	0	82M	*	0	0	ACCATGTGGTTGCTGGGATTTGAACTCGGGACCTTTGGAAGAGCAGTCGGCACTCTTAACCACTGAGCCATCTCACCAGCCC	CCCCCCCCC;CCCCCCCC-CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC	NH:i:7	HI:i:7	AS:i:80	nM:i:0	NM:i:0	MD:Z:82	jM:B:c,-1	jI:B:i,-1"

# Fake 97
first_forward_notproper = "VH00211:1:AAAFH3LHV:1:2512:35538:14139_TGAGTGCA	97	1	3154540	3	80M	=	3154540	80	CAATTTGCATTTAAATAAAGTACCTAGACTTCCCCGAAAGAAGTTCTGCTTTCCTACTTTCTCACTGTCGAGATTTTGTC	CCCCCCCCCCCCC;;CCC-CCCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;CCCCCCCCC	NH:i:2	HI:i:1	AS:i:154	nM:i:2	NM:i:1	MD:Z:12G67	jM:B:c,-1	jI:B:i,-1	MC:Z:19S80M"

first_forward_proper_notprimary = "VH00211:1:AAAFH3LHV:1:1414:24082:40472_CACCAGTG	355	1	4758097	1	82M	=	4958305	200256	GGGGCTGGTGAGATGGCTCAGTGGGTAAGAGCACCCGACTGCTCTTCCAAAGGTCCGGAGTTCAAACCCCAGCAACCACATG	CCCCCCCCCCCC;CCCCCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;C-CCCCCCCCCCCCCCCC	NH:i:3	HI:i:1	AS:i:120	nM:i:3	NM:i:3	MD:Z:48G8A8T15	jM:B:c,-1	jI:B:i,-1	MC:Z:50S48M3S"

# Fake 147
second_reverse_proper_primary = "VH00211:1:AAAFH3LHV:2:1612:27169:50297_TTCAGACG	147	1	3152962	0	81M	=	3152913	-130	ATTCAGAGACAATATCCTTTTATTACTTAGGGTTTTAGTTTACTACAAAAGTTTCTACAAAAAATAAAGAAAGCTTTTATA	CCCCCCCCCC;C-CCCCCC;CCCC;C;CCCCCC;CC-C;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;CCCC-;;C	NH:i:9	HI:i:4	AS:i:178	nM:i:1	NM:i:0	MD:Z:81	jM:B:c,-1	jI:B:i,-1	MC:Z:101M"

print("\n".join([
    header,
    first_forward_proper_primary,
    first_reverse_proper_primary,
    first_forward_unmapped,
    first_reverse_unmapped,
    first_forward_notproper,
    first_forward_proper_notprimary,
    second_reverse_proper_primary
]))
