"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const gitlab_runner_autoscaling_1 = require("./gitlab-runner-autoscaling");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const app = new core_1.App();
const stack = new core_1.Stack(app, 'TestStackAutoscaling', { env });
const vpc = ec2.Vpc.fromLookup(stack, 'DefaultVpc', {
    isDefault: true,
});
const runner = new gitlab_runner_autoscaling_1.GitlabRunnerAutoscaling(stack, 'TestRunnerAutoscaling', {
    gitlabToken: stack.node.tryGetContext('GITLAB_TOKEN'),
    ebsSize: 30,
    vpc: vpc,
    dockerVolumes: [{
            hostPath: '/tmp/cache',
            containerPath: '/tmp/cache',
        }],
    instanceType: 't3.large',
    desiredCapacity: 1,
    maxCapacity: 1,
    minCapacity: 1,
    spotInstance: true,
});
new core_1.CfnOutput(stack, 'role', { value: runner.instanceRole.roleArn });
//# sourceMappingURL=data:application/json;base64,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