import { IVpc, IInstance, ISecurityGroup, SubnetSelection } from '@aws-cdk/aws-ec2';
import { IRole } from '@aws-cdk/aws-iam';
import { Construct, Duration } from '@aws-cdk/core';
import { DockerVolumes } from './gitlab-runner-interfaces';
/**
 * @experimental
 */
export interface GitlabContainerRunnerProps {
    /**
     * (experimental) Gitlab token for the Register Runner .
     *
     * @default - You must to give the token !!!
     * @experimental
     * @example
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN' });
     */
    readonly gitlabtoken: string;
    /**
     * (experimental) Runner default EC2 instance type.
     *
     * @default - t3.micro
     * @experimental
     * @example
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', ec2type: 't3.small' });
     */
    readonly ec2type?: string;
    /**
     * (experimental) VPC for the Gitlab Runner .
     *
     * @default - new VPC will be created , 1 Vpc , 2 Public Subnet .
     * @experimental
     * @example
     *
     * const newvpc = new Vpc(stack, 'NEWVPC', {
     *   cidr: '10.1.0.0/16',
     *   maxAzs: 2,
     *   subnetConfiguration: [{
     *     cidrMask: 26,
     *     name: 'RunnerVPC',
     *     subnetType: SubnetType.PUBLIC,
     *   }],
     *   natGateways: 0,
     * });
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', selfvpc: newvpc });
     */
    readonly selfvpc?: IVpc;
    /**
     * (experimental) IAM role for the Gitlab Runner Instance .
     *
     * @default - new Role for Gitlab Runner Instance , attach AmazonSSMManagedInstanceCore Policy .
     * @experimental
     * @example
     *
     * const role = new Role(stack, 'runner-role', {
     *   assumedBy: new ServicePrincipal('ec2.amazonaws.com'),
     *   description: 'For Gitlab EC2 Runner Test Role',
     *   roleName: 'Myself-Runner-Role',
     * });
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', ec2iamrole: role });
     */
    readonly ec2iamrole?: IRole;
    /**
     * (deprecated) Gitlab Runner register tag1  .
     *
     * @default - tag1: gitlab .
     * @deprecated - use tags ['runner', 'gitlab', 'awscdk']
     * @example
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', tag1: 'aa' });
     */
    readonly tag1?: string;
    /**
     * (deprecated) Gitlab Runner register tag2  .
     *
     * @default - tag2: awscdk .
     * @deprecated - use tags ['runner', 'gitlab', 'awscdk']
     * @example
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', tag2: 'bb' });
     */
    readonly tag2?: string;
    /**
     * (deprecated) Gitlab Runner register tag3  .
     *
     * @default - tag3: runner .
     * @deprecated - use tags ['runner', 'gitlab', 'awscdk']
     * @example
     *
     * new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN', tag3: 'cc' });
     */
    readonly tag3?: string;
    /**
     * (experimental) tags for the runner.
     *
     * @default - ['runner', 'gitlab', 'awscdk']
     * @experimental
     */
    readonly tags?: string[];
    /**
     * (experimental) Gitlab Runner register url .
     *
     * @default - gitlaburl='https://gitlab.com/' , please use https://yourgitlab.com/ do not use https://yourgitlab.com
     * @experimental
     * @example
     *
     * const runner = new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN',gitlaburl: 'https://gitlab.com/'});
     */
    readonly gitlaburl?: string;
    /**
     * (experimental) Gitlab Runner instance EBS size .
     *
     * @default - ebsSize=60
     * @experimental
     * @example
     *
     * const runner = new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN',ebsSize: 100});
     */
    readonly ebsSize?: number;
    /**
     * (experimental) Gitlab Runner instance Use Spot Fleet or not ?!.
     *
     * @default - spotFleet=false
     * @experimental
     * @example
     *
     * const runner = new GitlabContainerRunner(stack, 'runner', { gitlabtoken: 'GITLAB_TOKEN',spotFleet: true});
     */
    readonly spotFleet?: boolean;
    /**
     * (experimental) SSH key name.
     *
     * @default - no ssh key will be assigned , !!! only support spotfleet runner !!! .
     * @experimental
     */
    readonly keyName?: string;
    /**
     * (experimental) Reservce the Spot Runner instance as spot block with defined duration.
     *
     * @default - BlockDuration.ONE_HOUR , !!! only support spotfleet runner !!! .
     * @experimental
     */
    readonly blockDuration?: BlockDuration;
    /**
     * (experimental) The behavior when a Spot Runner Instance is interrupted.
     *
     * @default - InstanceInterruptionBehavior.TERMINATE , !!! only support spotfleet runner !!! .
     * @experimental
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * (experimental) the time when the spot fleet allocation expires.
     *
     * @default - no expiration , !!! only support spotfleet runner !!! .
     * @experimental
     */
    readonly validUntil?: string;
    /**
     * (experimental) VPC subnet for the spot fleet.
     *
     * @default - public subnet
     * @experimental
     * @example
     *
     * const vpc = new Vpc(stack, 'nat', {
     * natGateways: 1,
     * maxAzs: 2,
     * });
     * const runner = new GitlabContainerRunner(stack, 'testing', {
     *   gitlabtoken: 'GITLAB_TOKEN',
     *   ec2type: 't3.large',
     *   ec2iamrole: role,
     *   ebsSize: 100,
     *   selfvpc: vpc,
     *   vpcSubnet: {
     *     subnetType: SubnetType.PUBLIC,
     *   },
     * });
     */
    readonly vpcSubnet?: SubnetSelection;
    /**
     * (experimental) add another Gitlab Container Runner Docker Volumes Path at job runner runtime.
     *
     * more detail see https://docs.gitlab.com/runner/configuration/advanced-configuration.html#the-runnersdocker-section
     *
     * @default - already mount "/var/run/docker.sock:/var/run/docker.sock"
     * @experimental
     * @example
     *
     * dockerVolumes: [
     *   {
     *     hostPath: '/tmp/cache',
     *     containerPath: '/tmp/cache',
     *   },
     * ],
     */
    readonly dockerVolumes?: DockerVolumes[];
}
/**
 * @experimental
 */
export declare enum BlockDuration {
    /**
     * @experimental
     */
    ONE_HOUR = 60,
    /**
     * @experimental
     */
    TWO_HOURS = 120,
    /**
     * @experimental
     */
    THREE_HOURS = 180,
    /**
     * @experimental
     */
    FOUR_HOURS = 240,
    /**
     * @experimental
     */
    FIVE_HOURS = 300,
    /**
     * @experimental
     */
    SIX_HOURS = 360,
    /**
     * @experimental
     */
    SEVEN_HOURS = 420,
    /**
     * @experimental
     */
    EIGHT_HOURS = 480,
    /**
     * @experimental
     */
    NINE_HOURS = 540,
    /**
     * @experimental
     */
    TEN_HOURS = 600,
    /**
     * @experimental
     */
    ELEVEN_HOURS = 660,
    /**
     * @experimental
     */
    TWELVE_HOURS = 720,
    /**
     * @experimental
     */
    THIRTEEN_HOURS = 780,
    /**
     * @experimental
     */
    FOURTEEN_HOURS = 840,
    /**
     * @experimental
     */
    FIFTEEN_HOURS = 900,
    /**
     * @experimental
     */
    SIXTEEN_HOURS = 960,
    /**
     * @experimental
     */
    SEVENTEEN_HOURS = 1020,
    /**
     * @experimental
     */
    EIGHTTEEN_HOURS = 1080,
    /**
     * @experimental
     */
    NINETEEN_HOURS = 1140,
    /**
     * @experimental
     */
    TWENTY_HOURS = 1200
}
/**
 * @experimental
 */
export declare enum InstanceInterruptionBehavior {
    /**
     * @experimental
     */
    HIBERNATE = "hibernate",
    /**
     * @experimental
     */
    STOP = "stop",
    /**
     * @experimental
     */
    TERMINATE = "terminate"
}
/**
 * @experimental
 */
export declare class GitlabContainerRunner extends Construct {
    /**
     * (experimental) The IAM role assumed by the Runner instance .
     *
     * @experimental
     */
    readonly runnerRole: IRole;
    /**
     * (experimental) This represents a Runner EC2 instance , !!! only support On-demand runner instance !!!
     *
     * @experimental
     */
    readonly runnerEc2: IInstance;
    /**
     * (experimental) The EC2 runner's vpc.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * The time when the the fleet allocation will expire , !!! only support spotfleet runner !!!
     */
    private validUntil?;
    /**
     * (experimental) The EC2 runner's default SecurityGroup.
     *
     * @experimental
     */
    readonly defaultRunnerSG: ISecurityGroup;
    /**
     * (experimental) SpotFleetRequestId for this spot fleet , !!! only support spotfleet runner !!!
     *
     * @experimental
     */
    readonly spotFleetRequestId: string;
    /**
     * (experimental) the first instance id in this fleet , !!! only support spotfleet runner !!!
     *
     * @experimental
     */
    readonly spotFleetInstanceId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GitlabContainerRunnerProps);
    /**
     * @default - !!! only support spotfleet runner !!! .
     * @experimental
     */
    expireAfter(duration: Duration): void;
    private synthesizeTags;
    private dockerVolumesList;
}
