from autoclass.autoargs_ import autoargs, autoargs_decorate
from autoclass.autoprops_ import IllegalGetterSignatureException, IllegalSetterSignatureException, autoprops, \
    autoprops_decorate, DuplicateOverrideError, getter_override, setter_override, autoprops_override_decorate
from autoclass.autoslots_ import autoslots, autoslots_decorate
from autoclass.autodict_ import autodict, autodict_decorate, autodict_override, autodict_override_decorate, \
    print_ordered_dict
from autoclass.autohash_ import autohash, autohash_decorate
from autoclass.autorepr_ import autorepr, autorepr_decorate
from autoclass.autoclass_ import autoclass, autoclass_decorate
from autoclass.utils import AutoclassDecorationException, autoclass_override

try:
    # Distribution mode : import from _version.py generated by setuptools_scm during release
    from ._version import version as __version__
except ImportError:
    # Source mode : use setuptools_scm to get the current version from src using git
    from setuptools_scm import get_version as _gv
    from os import path as _path
    __version__ = _gv(_path.join(_path.dirname(__file__), _path.pardir))

__all__ = [
    '__version__',
    # submodules
    'autoargs_', 'autoclass_', 'autodict_', 'autohash_', 'autoprops_', 'utils',
    # symbols
    'autoargs', 'autoargs_decorate',
    'autoclass', 'autoclass_decorate', 'autoclass_override',
    'autoslots', 'autoslots_decorate',
    'autodict', 'autodict_decorate', 'autodict_override', 'autodict_override_decorate', 'print_ordered_dict',
    'autohash', 'autohash_decorate',
    'autorepr', 'autorepr_decorate',
    'IllegalGetterSignatureException', 'IllegalSetterSignatureException', 'autoprops', 'autoprops_decorate',
    'DuplicateOverrideError', 'getter_override', 'setter_override', 'autoprops_override_decorate',
    'AutoclassDecorationException'
]
