// We require the Hardhat Runtime Environment explicitly here. This is optional 
// but useful for running the script in a standalone fashion through `node <script>`.
//
// When running the script with `hardhat run <script>` you'll find the Hardhat
// Runtime Environment's members available in the global scope.
const hre = require("hardhat");

async function main() {
    // Hardhat always runs the compile task when running scripts with its command
    // line interface.
    //
    // If this script is run directly using `node` you may want to call compile 
    // manually to make sure everything is compiled
    // await hre.run('compile');

    // We get the contract to deploy
    const ABC = await hre.ethers.getContractFactory("ABC");
    const abc = await ABC.deploy();
    await abc.deployed();
    console.log("ABC deployed to:", abc.address);


    const Bar = await hre.ethers.getContractFactory("Bar");
    const bar = await Bar.deploy();
    await bar.deployed();
    console.log("Bar deployed to:", bar.address);


    const Foo = await hre.ethers.getContractFactory("Foo");
    const foo = await Foo.deploy();
    await foo.deployed();
    console.log("Foo deployed to:", foo.address);

    const Migrations = await hre.ethers.getContractFactory("Migrations");
    const migrations = await Migrations.deploy();
    await migrations.deployed();
    console.log("Migrations deployed to:", migrations.address);
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main()
    .then(() => process.exit(0))
    .catch(error => {
        console.error(error);
        process.exit(1);
    });